/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointventure;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.JointVentureService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Joint Venture
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JointVentureType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class JointVenture extends VdmEntity<JointVenture> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_jointventure.v0001.A_JointVentureType";
    /**
     * Selector for all available fields of JointVenture.
     * 
     */
    public final static SimpleProperty<JointVenture> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<JointVenture> COMPANY_CODE =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     * 
     * @return Joint Venture
     */
    @Nullable
    @ElementName( "JointVenture" )
    private java.lang.String jointVenture;
    public final static SimpleProperty.String<JointVenture> JOINT_VENTURE =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JointVenture");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureName</b>
     * </p>
     * 
     * @return The jointVentureName contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "JointVentureName" )
    private java.lang.String jointVentureName;
    public final static SimpleProperty.String<JointVenture> JOINT_VENTURE_NAME =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JointVentureName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JointVenturePaymentTerms</b>
     * </p>
     * 
     * @return Terms of Payment Key
     */
    @Nullable
    @ElementName( "JointVenturePaymentTerms" )
    private java.lang.String jointVenturePaymentTerms;
    public final static SimpleProperty.String<JointVenture> JOINT_VENTURE_PAYMENT_TERMS =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JointVenturePaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureBillingType</b>
     * </p>
     * 
     * @return Billing Method
     */
    @Nullable
    @ElementName( "JointVentureBillingType" )
    private java.lang.String jointVentureBillingType;
    public final static SimpleProperty.String<JointVenture> JOINT_VENTURE_BILLING_TYPE =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JointVentureBillingType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureType</b>
     * </p>
     * 
     * @return Venture Type
     */
    @Nullable
    @ElementName( "JointVentureType" )
    private java.lang.String jointVentureType;
    public final static SimpleProperty.String<JointVenture> JOINT_VENTURE_TYPE =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JointVentureType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureOperator</b>
     * </p>
     * 
     * @return Operator
     */
    @Nullable
    @ElementName( "JointVentureOperator" )
    private java.lang.String jointVentureOperator;
    public final static SimpleProperty.String<JointVenture> JOINT_VENTURE_OPERATOR =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JointVentureOperator");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureClass</b>
     * </p>
     * 
     * @return Venture Class
     */
    @Nullable
    @ElementName( "JointVentureClass" )
    private java.lang.String jointVentureClass;
    public final static SimpleProperty.String<JointVenture> JOINT_VENTURE_CLASS =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JointVentureClass");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
     * </p>
     * 
     * @return Joint Operating Agreement
     */
    @Nullable
    @ElementName( "JntOpgAgrmt" )
    private java.lang.String jntOpgAgrmt;
    public final static SimpleProperty.String<JointVenture> JNT_OPG_AGRMT =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JntOpgAgrmt");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrBillgCutbackIsBlk</b>
     * </p>
     * 
     * @return Joint Venture Status
     */
    @Nullable
    @ElementName( "JntVntrBillgCutbackIsBlk" )
    private java.lang.String jntVntrBillgCutbackIsBlk;
    public final static SimpleProperty.String<JointVenture> JNT_VNTR_BILLG_CUTBACK_IS_BLK =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JntVntrBillgCutbackIsBlk");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrInceptionToDateData</b>
     * </p>
     * 
     * @return Inception to Date
     */
    @Nullable
    @ElementName( "JntVntrInceptionToDateData" )
    private java.lang.String jntVntrInceptionToDateData;
    public final static SimpleProperty.String<JointVenture> JNT_VNTR_INCEPTION_TO_DATE_DATA =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JntVntrInceptionToDateData");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrCurrentMonthBillg</b>
     * </p>
     * 
     * @return The jntVntrCurrentMonthBillg contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "JntVntrCurrentMonthBillg" )
    private java.lang.String jntVntrCurrentMonthBillg;
    public final static SimpleProperty.String<JointVenture> JNT_VNTR_CURRENT_MONTH_BILLG =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JntVntrCurrentMonthBillg");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrYearToDateBillg</b>
     * </p>
     * 
     * @return The jntVntrYearToDateBillg contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "JntVntrYearToDateBillg" )
    private java.lang.String jntVntrYearToDateBillg;
    public final static SimpleProperty.String<JointVenture> JNT_VNTR_YEAR_TO_DATE_BILLG =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JntVntrYearToDateBillg");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrInceptionToDateBillg</b>
     * </p>
     * 
     * @return The jntVntrInceptionToDateBillg contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "JntVntrInceptionToDateBillg" )
    private java.lang.String jntVntrInceptionToDateBillg;
    public final static SimpleProperty.String<JointVenture> JNT_VNTR_INCEPTION_TO_DATE_BILLG =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JntVntrInceptionToDateBillg");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrFundingGroup</b>
     * </p>
     * 
     * @return JV Funding group
     */
    @Nullable
    @ElementName( "JntVntrFundingGroup" )
    private java.lang.String jntVntrFundingGroup;
    public final static SimpleProperty.String<JointVenture> JNT_VNTR_FUNDING_GROUP =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JntVntrFundingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCreatedByUser</b>
     * </p>
     * 
     * @return User who Created
     */
    @Nullable
    @ElementName( "JointVentureCreatedByUser" )
    private java.lang.String jointVentureCreatedByUser;
    public final static SimpleProperty.String<JointVenture> JOINT_VENTURE_CREATED_BY_USER =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JointVentureCreatedByUser");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrTimeCreated</b>
     * </p>
     * 
     * @return Time Created
     */
    @Nullable
    @ElementName( "JntVntrTimeCreated" )
    private LocalTime jntVntrTimeCreated;
    public final static SimpleProperty.Time<JointVenture> JNT_VNTR_TIME_CREATED =
        new SimpleProperty.Time<JointVenture>(JointVenture.class, "JntVntrTimeCreated");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrDateCreated</b>
     * </p>
     * 
     * @return Date Created
     */
    @Nullable
    @ElementName( "JntVntrDateCreated" )
    private LocalDate jntVntrDateCreated;
    public final static SimpleProperty.Date<JointVenture> JNT_VNTR_DATE_CREATED =
        new SimpleProperty.Date<JointVenture>(JointVenture.class, "JntVntrDateCreated");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrCreationDateTime</b>
     * </p>
     * 
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @Nullable
    @ElementName( "JntVntrCreationDateTime" )
    private OffsetDateTime jntVntrCreationDateTime;
    public final static SimpleProperty.DateTime<JointVenture> JNT_VNTR_CREATION_DATE_TIME =
        new SimpleProperty.DateTime<JointVenture>(JointVenture.class, "JntVntrCreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureLastChangedByUser</b>
     * </p>
     * 
     * @return User who Last Changed
     */
    @Nullable
    @ElementName( "JointVentureLastChangedByUser" )
    private java.lang.String jointVentureLastChangedByUser;
    public final static SimpleProperty.String<JointVenture> JOINT_VENTURE_LAST_CHANGED_BY_USER =
        new SimpleProperty.String<JointVenture>(JointVenture.class, "JointVentureLastChangedByUser");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrTimeLastChanged</b>
     * </p>
     * 
     * @return Time Last Changed
     */
    @Nullable
    @ElementName( "JntVntrTimeLastChanged" )
    private LocalTime jntVntrTimeLastChanged;
    public final static SimpleProperty.Time<JointVenture> JNT_VNTR_TIME_LAST_CHANGED =
        new SimpleProperty.Time<JointVenture>(JointVenture.class, "JntVntrTimeLastChanged");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrDateLastChanged</b>
     * </p>
     * 
     * @return Date Last Changed
     */
    @Nullable
    @ElementName( "JntVntrDateLastChanged" )
    private LocalDate jntVntrDateLastChanged;
    public final static SimpleProperty.Date<JointVenture> JNT_VNTR_DATE_LAST_CHANGED =
        new SimpleProperty.Date<JointVenture>(JointVenture.class, "JntVntrDateLastChanged");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrLastChangedDateTime</b>
     * </p>
     * 
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @Nullable
    @ElementName( "JntVntrLastChangedDateTime" )
    private OffsetDateTime jntVntrLastChangedDateTime;
    public final static SimpleProperty.DateTime<JointVenture> JNT_VNTR_LAST_CHANGED_DATE_TIME =
        new SimpleProperty.DateTime<JointVenture>(JointVenture.class, "JntVntrLastChangedDateTime");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JointVenture, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JointVenture, SAP__Message>(
            JointVenture.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_JointVentureDescription</b> for <b>JointVenture</b> to multiple
     * <b>JointVentureDescription</b>.
     * 
     */
    @ElementName( "_JointVentureDescription" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<JointVentureDescription> to_JointVentureDescription;
    /**
     * Navigation property <b>_JointVentureEquityGroup</b> for <b>JointVenture</b> to multiple
     * <b>JointVentureEquityGroup</b>.
     * 
     */
    @ElementName( "_JointVentureEquityGroup" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<JointVentureEquityGroup> to_JointVentureEquityGroup;
    /**
     * Navigation property <b>_JointVentureEquityType</b> for <b>JointVenture</b> to multiple
     * <b>JointVentureEquityType</b>.
     * 
     */
    @ElementName( "_JointVentureEquityType" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<JointVentureEquityType> to_JointVentureEquityType;
    /**
     * Use with available request builders to apply the <b>_JointVentureDescription</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JointVenture, JointVentureDescription> TO__JOINT_VENTURE_DESCRIPTION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JointVenture, JointVentureDescription>(
            JointVenture.class,
            "_JointVentureDescription",
            JointVentureDescription.class);
    /**
     * Use with available request builders to apply the <b>_JointVentureEquityGroup</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JointVenture, JointVentureEquityGroup> TO__JOINT_VENTURE_EQUITY_GROUP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JointVenture, JointVentureEquityGroup>(
            JointVenture.class,
            "_JointVentureEquityGroup",
            JointVentureEquityGroup.class);
    /**
     * Use with available request builders to apply the <b>_JointVentureEquityType</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JointVenture, JointVentureEquityType> TO__JOINT_VENTURE_EQUITY_TYPE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JointVenture, JointVentureEquityType>(
            JointVenture.class,
            "_JointVentureEquityType",
            JointVentureEquityType.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<JointVenture> getType()
    {
        return JointVenture.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     * 
     * @param jointVenture
     *            Joint Venture
     */
    public void setJointVenture( @Nullable final java.lang.String jointVenture )
    {
        rememberChangedField("JointVenture", this.jointVenture);
        this.jointVenture = jointVenture;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureName</b>
     * </p>
     * 
     * @param jointVentureName
     *            The jointVentureName to set.
     */
    public void setJointVentureName( @Nullable final java.lang.String jointVentureName )
    {
        rememberChangedField("JointVentureName", this.jointVentureName);
        this.jointVentureName = jointVentureName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JointVenturePaymentTerms</b>
     * </p>
     * 
     * @param jointVenturePaymentTerms
     *            Terms of Payment Key
     */
    public void setJointVenturePaymentTerms( @Nullable final java.lang.String jointVenturePaymentTerms )
    {
        rememberChangedField("JointVenturePaymentTerms", this.jointVenturePaymentTerms);
        this.jointVenturePaymentTerms = jointVenturePaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureBillingType</b>
     * </p>
     * 
     * @param jointVentureBillingType
     *            Billing Method
     */
    public void setJointVentureBillingType( @Nullable final java.lang.String jointVentureBillingType )
    {
        rememberChangedField("JointVentureBillingType", this.jointVentureBillingType);
        this.jointVentureBillingType = jointVentureBillingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureType</b>
     * </p>
     * 
     * @param jointVentureType
     *            Venture Type
     */
    public void setJointVentureType( @Nullable final java.lang.String jointVentureType )
    {
        rememberChangedField("JointVentureType", this.jointVentureType);
        this.jointVentureType = jointVentureType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureOperator</b>
     * </p>
     * 
     * @param jointVentureOperator
     *            Operator
     */
    public void setJointVentureOperator( @Nullable final java.lang.String jointVentureOperator )
    {
        rememberChangedField("JointVentureOperator", this.jointVentureOperator);
        this.jointVentureOperator = jointVentureOperator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureClass</b>
     * </p>
     * 
     * @param jointVentureClass
     *            Venture Class
     */
    public void setJointVentureClass( @Nullable final java.lang.String jointVentureClass )
    {
        rememberChangedField("JointVentureClass", this.jointVentureClass);
        this.jointVentureClass = jointVentureClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
     * </p>
     * 
     * @param jntOpgAgrmt
     *            Joint Operating Agreement
     */
    public void setJntOpgAgrmt( @Nullable final java.lang.String jntOpgAgrmt )
    {
        rememberChangedField("JntOpgAgrmt", this.jntOpgAgrmt);
        this.jntOpgAgrmt = jntOpgAgrmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrBillgCutbackIsBlk</b>
     * </p>
     * 
     * @param jntVntrBillgCutbackIsBlk
     *            Joint Venture Status
     */
    public void setJntVntrBillgCutbackIsBlk( @Nullable final java.lang.String jntVntrBillgCutbackIsBlk )
    {
        rememberChangedField("JntVntrBillgCutbackIsBlk", this.jntVntrBillgCutbackIsBlk);
        this.jntVntrBillgCutbackIsBlk = jntVntrBillgCutbackIsBlk;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrInceptionToDateData</b>
     * </p>
     * 
     * @param jntVntrInceptionToDateData
     *            Inception to Date
     */
    public void setJntVntrInceptionToDateData( @Nullable final java.lang.String jntVntrInceptionToDateData )
    {
        rememberChangedField("JntVntrInceptionToDateData", this.jntVntrInceptionToDateData);
        this.jntVntrInceptionToDateData = jntVntrInceptionToDateData;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrCurrentMonthBillg</b>
     * </p>
     * 
     * @param jntVntrCurrentMonthBillg
     *            The jntVntrCurrentMonthBillg to set.
     */
    public void setJntVntrCurrentMonthBillg( @Nullable final java.lang.String jntVntrCurrentMonthBillg )
    {
        rememberChangedField("JntVntrCurrentMonthBillg", this.jntVntrCurrentMonthBillg);
        this.jntVntrCurrentMonthBillg = jntVntrCurrentMonthBillg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrYearToDateBillg</b>
     * </p>
     * 
     * @param jntVntrYearToDateBillg
     *            The jntVntrYearToDateBillg to set.
     */
    public void setJntVntrYearToDateBillg( @Nullable final java.lang.String jntVntrYearToDateBillg )
    {
        rememberChangedField("JntVntrYearToDateBillg", this.jntVntrYearToDateBillg);
        this.jntVntrYearToDateBillg = jntVntrYearToDateBillg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrInceptionToDateBillg</b>
     * </p>
     * 
     * @param jntVntrInceptionToDateBillg
     *            The jntVntrInceptionToDateBillg to set.
     */
    public void setJntVntrInceptionToDateBillg( @Nullable final java.lang.String jntVntrInceptionToDateBillg )
    {
        rememberChangedField("JntVntrInceptionToDateBillg", this.jntVntrInceptionToDateBillg);
        this.jntVntrInceptionToDateBillg = jntVntrInceptionToDateBillg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrFundingGroup</b>
     * </p>
     * 
     * @param jntVntrFundingGroup
     *            JV Funding group
     */
    public void setJntVntrFundingGroup( @Nullable final java.lang.String jntVntrFundingGroup )
    {
        rememberChangedField("JntVntrFundingGroup", this.jntVntrFundingGroup);
        this.jntVntrFundingGroup = jntVntrFundingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCreatedByUser</b>
     * </p>
     * 
     * @param jointVentureCreatedByUser
     *            User who Created
     */
    public void setJointVentureCreatedByUser( @Nullable final java.lang.String jointVentureCreatedByUser )
    {
        rememberChangedField("JointVentureCreatedByUser", this.jointVentureCreatedByUser);
        this.jointVentureCreatedByUser = jointVentureCreatedByUser;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrTimeCreated</b>
     * </p>
     * 
     * @param jntVntrTimeCreated
     *            Time Created
     */
    public void setJntVntrTimeCreated( @Nullable final LocalTime jntVntrTimeCreated )
    {
        rememberChangedField("JntVntrTimeCreated", this.jntVntrTimeCreated);
        this.jntVntrTimeCreated = jntVntrTimeCreated;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrDateCreated</b>
     * </p>
     * 
     * @param jntVntrDateCreated
     *            Date Created
     */
    public void setJntVntrDateCreated( @Nullable final LocalDate jntVntrDateCreated )
    {
        rememberChangedField("JntVntrDateCreated", this.jntVntrDateCreated);
        this.jntVntrDateCreated = jntVntrDateCreated;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrCreationDateTime</b>
     * </p>
     * 
     * @param jntVntrCreationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setJntVntrCreationDateTime( @Nullable final OffsetDateTime jntVntrCreationDateTime )
    {
        rememberChangedField("JntVntrCreationDateTime", this.jntVntrCreationDateTime);
        this.jntVntrCreationDateTime = jntVntrCreationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureLastChangedByUser</b>
     * </p>
     * 
     * @param jointVentureLastChangedByUser
     *            User who Last Changed
     */
    public void setJointVentureLastChangedByUser( @Nullable final java.lang.String jointVentureLastChangedByUser )
    {
        rememberChangedField("JointVentureLastChangedByUser", this.jointVentureLastChangedByUser);
        this.jointVentureLastChangedByUser = jointVentureLastChangedByUser;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrTimeLastChanged</b>
     * </p>
     * 
     * @param jntVntrTimeLastChanged
     *            Time Last Changed
     */
    public void setJntVntrTimeLastChanged( @Nullable final LocalTime jntVntrTimeLastChanged )
    {
        rememberChangedField("JntVntrTimeLastChanged", this.jntVntrTimeLastChanged);
        this.jntVntrTimeLastChanged = jntVntrTimeLastChanged;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrDateLastChanged</b>
     * </p>
     * 
     * @param jntVntrDateLastChanged
     *            Date Last Changed
     */
    public void setJntVntrDateLastChanged( @Nullable final LocalDate jntVntrDateLastChanged )
    {
        rememberChangedField("JntVntrDateLastChanged", this.jntVntrDateLastChanged);
        this.jntVntrDateLastChanged = jntVntrDateLastChanged;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrLastChangedDateTime</b>
     * </p>
     * 
     * @param jntVntrLastChangedDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setJntVntrLastChangedDateTime( @Nullable final OffsetDateTime jntVntrLastChangedDateTime )
    {
        rememberChangedField("JntVntrLastChangedDateTime", this.jntVntrLastChangedDateTime);
        this.jntVntrLastChangedDateTime = jntVntrLastChangedDateTime;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_JointVenture";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CompanyCode", getCompanyCode());
        entityKey.addKeyProperty("JointVenture", getJointVenture());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("JointVenture", getJointVenture());
        values.put("JointVentureName", getJointVentureName());
        values.put("JointVenturePaymentTerms", getJointVenturePaymentTerms());
        values.put("JointVentureBillingType", getJointVentureBillingType());
        values.put("JointVentureType", getJointVentureType());
        values.put("JointVentureOperator", getJointVentureOperator());
        values.put("JointVentureClass", getJointVentureClass());
        values.put("JntOpgAgrmt", getJntOpgAgrmt());
        values.put("JntVntrBillgCutbackIsBlk", getJntVntrBillgCutbackIsBlk());
        values.put("JntVntrInceptionToDateData", getJntVntrInceptionToDateData());
        values.put("JntVntrCurrentMonthBillg", getJntVntrCurrentMonthBillg());
        values.put("JntVntrYearToDateBillg", getJntVntrYearToDateBillg());
        values.put("JntVntrInceptionToDateBillg", getJntVntrInceptionToDateBillg());
        values.put("JntVntrFundingGroup", getJntVntrFundingGroup());
        values.put("JointVentureCreatedByUser", getJointVentureCreatedByUser());
        values.put("JntVntrTimeCreated", getJntVntrTimeCreated());
        values.put("JntVntrDateCreated", getJntVntrDateCreated());
        values.put("JntVntrCreationDateTime", getJntVntrCreationDateTime());
        values.put("JointVentureLastChangedByUser", getJointVentureLastChangedByUser());
        values.put("JntVntrTimeLastChanged", getJntVntrTimeLastChanged());
        values.put("JntVntrDateLastChanged", getJntVntrDateLastChanged());
        values.put("JntVntrLastChangedDateTime", getJntVntrLastChangedDateTime());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVenture") ) {
                final Object value = values.remove("JointVenture");
                if( (value == null) || (!value.equals(getJointVenture())) ) {
                    setJointVenture(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVentureName") ) {
                final Object value = values.remove("JointVentureName");
                if( (value == null) || (!value.equals(getJointVentureName())) ) {
                    setJointVentureName(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVenturePaymentTerms") ) {
                final Object value = values.remove("JointVenturePaymentTerms");
                if( (value == null) || (!value.equals(getJointVenturePaymentTerms())) ) {
                    setJointVenturePaymentTerms(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVentureBillingType") ) {
                final Object value = values.remove("JointVentureBillingType");
                if( (value == null) || (!value.equals(getJointVentureBillingType())) ) {
                    setJointVentureBillingType(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVentureType") ) {
                final Object value = values.remove("JointVentureType");
                if( (value == null) || (!value.equals(getJointVentureType())) ) {
                    setJointVentureType(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVentureOperator") ) {
                final Object value = values.remove("JointVentureOperator");
                if( (value == null) || (!value.equals(getJointVentureOperator())) ) {
                    setJointVentureOperator(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVentureClass") ) {
                final Object value = values.remove("JointVentureClass");
                if( (value == null) || (!value.equals(getJointVentureClass())) ) {
                    setJointVentureClass(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmt") ) {
                final Object value = values.remove("JntOpgAgrmt");
                if( (value == null) || (!value.equals(getJntOpgAgrmt())) ) {
                    setJntOpgAgrmt(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrBillgCutbackIsBlk") ) {
                final Object value = values.remove("JntVntrBillgCutbackIsBlk");
                if( (value == null) || (!value.equals(getJntVntrBillgCutbackIsBlk())) ) {
                    setJntVntrBillgCutbackIsBlk(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrInceptionToDateData") ) {
                final Object value = values.remove("JntVntrInceptionToDateData");
                if( (value == null) || (!value.equals(getJntVntrInceptionToDateData())) ) {
                    setJntVntrInceptionToDateData(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrCurrentMonthBillg") ) {
                final Object value = values.remove("JntVntrCurrentMonthBillg");
                if( (value == null) || (!value.equals(getJntVntrCurrentMonthBillg())) ) {
                    setJntVntrCurrentMonthBillg(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrYearToDateBillg") ) {
                final Object value = values.remove("JntVntrYearToDateBillg");
                if( (value == null) || (!value.equals(getJntVntrYearToDateBillg())) ) {
                    setJntVntrYearToDateBillg(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrInceptionToDateBillg") ) {
                final Object value = values.remove("JntVntrInceptionToDateBillg");
                if( (value == null) || (!value.equals(getJntVntrInceptionToDateBillg())) ) {
                    setJntVntrInceptionToDateBillg(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrFundingGroup") ) {
                final Object value = values.remove("JntVntrFundingGroup");
                if( (value == null) || (!value.equals(getJntVntrFundingGroup())) ) {
                    setJntVntrFundingGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVentureCreatedByUser") ) {
                final Object value = values.remove("JointVentureCreatedByUser");
                if( (value == null) || (!value.equals(getJointVentureCreatedByUser())) ) {
                    setJointVentureCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrTimeCreated") ) {
                final Object value = values.remove("JntVntrTimeCreated");
                if( (value == null) || (!value.equals(getJntVntrTimeCreated())) ) {
                    setJntVntrTimeCreated(((LocalTime) value));
                }
            }
            if( values.containsKey("JntVntrDateCreated") ) {
                final Object value = values.remove("JntVntrDateCreated");
                if( (value == null) || (!value.equals(getJntVntrDateCreated())) ) {
                    setJntVntrDateCreated(((LocalDate) value));
                }
            }
            if( values.containsKey("JntVntrCreationDateTime") ) {
                final Object value = values.remove("JntVntrCreationDateTime");
                if( (value == null) || (!value.equals(getJntVntrCreationDateTime())) ) {
                    setJntVntrCreationDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("JointVentureLastChangedByUser") ) {
                final Object value = values.remove("JointVentureLastChangedByUser");
                if( (value == null) || (!value.equals(getJointVentureLastChangedByUser())) ) {
                    setJointVentureLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrTimeLastChanged") ) {
                final Object value = values.remove("JntVntrTimeLastChanged");
                if( (value == null) || (!value.equals(getJntVntrTimeLastChanged())) ) {
                    setJntVntrTimeLastChanged(((LocalTime) value));
                }
            }
            if( values.containsKey("JntVntrDateLastChanged") ) {
                final Object value = values.remove("JntVntrDateLastChanged");
                if( (value == null) || (!value.equals(getJntVntrDateLastChanged())) ) {
                    setJntVntrDateLastChanged(((LocalDate) value));
                }
            }
            if( values.containsKey("JntVntrLastChangedDateTime") ) {
                final Object value = values.remove("JntVntrLastChangedDateTime");
                if( (value == null) || (!value.equals(getJntVntrLastChangedDateTime())) ) {
                    setJntVntrLastChangedDateTime(((OffsetDateTime) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_JointVentureDescription") ) {
                final Object value = (values).remove("_JointVentureDescription");
                if( value instanceof Iterable ) {
                    if( to_JointVentureDescription == null ) {
                        to_JointVentureDescription = Lists.newArrayList();
                    } else {
                        to_JointVentureDescription = Lists.newArrayList(to_JointVentureDescription);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        JointVentureDescription entity;
                        if( to_JointVentureDescription.size() > i ) {
                            entity = to_JointVentureDescription.get(i);
                        } else {
                            entity = new JointVentureDescription();
                            to_JointVentureDescription.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_JointVentureEquityGroup") ) {
                final Object value = (values).remove("_JointVentureEquityGroup");
                if( value instanceof Iterable ) {
                    if( to_JointVentureEquityGroup == null ) {
                        to_JointVentureEquityGroup = Lists.newArrayList();
                    } else {
                        to_JointVentureEquityGroup = Lists.newArrayList(to_JointVentureEquityGroup);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        JointVentureEquityGroup entity;
                        if( to_JointVentureEquityGroup.size() > i ) {
                            entity = to_JointVentureEquityGroup.get(i);
                        } else {
                            entity = new JointVentureEquityGroup();
                            to_JointVentureEquityGroup.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_JointVentureEquityType") ) {
                final Object value = (values).remove("_JointVentureEquityType");
                if( value instanceof Iterable ) {
                    if( to_JointVentureEquityType == null ) {
                        to_JointVentureEquityType = Lists.newArrayList();
                    } else {
                        to_JointVentureEquityType = Lists.newArrayList(to_JointVentureEquityType);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        JointVentureEquityType entity;
                        if( to_JointVentureEquityType.size() > i ) {
                            entity = to_JointVentureEquityType.get(i);
                        } else {
                            entity = new JointVentureEquityType();
                            to_JointVentureEquityType.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return JointVentureService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_JointVentureDescription != null ) {
            (values).put("_JointVentureDescription", to_JointVentureDescription);
        }
        if( to_JointVentureEquityGroup != null ) {
            (values).put("_JointVentureEquityGroup", to_JointVentureEquityGroup);
        }
        if( to_JointVentureEquityType != null ) {
            (values).put("_JointVentureEquityType", to_JointVentureEquityType);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>JointVentureDescription</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_JointVentureDescription</b>.
     * <p>
     * If the navigation property for an entity <b>JointVenture</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JointVentureDescription</b> is already loaded, the result
     *         will contain the <b>JointVentureDescription</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<JointVentureDescription>> getJointVentureDescriptionIfPresent()
    {
        return Option.of(to_JointVentureDescription);
    }

    /**
     * Overwrites the list of associated <b>JointVentureDescription</b> entities for the loaded navigation property
     * <b>_JointVentureDescription</b>.
     * <p>
     * If the navigation property <b>_JointVentureDescription</b> of a queried <b>JointVenture</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>JointVentureDescription</b> entities.
     */
    public void setJointVentureDescription( @Nonnull final List<JointVentureDescription> value )
    {
        if( to_JointVentureDescription == null ) {
            to_JointVentureDescription = Lists.newArrayList();
        }
        to_JointVentureDescription.clear();
        to_JointVentureDescription.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>JointVentureDescription</b> entities. This corresponds to the OData
     * navigation property <b>_JointVentureDescription</b>.
     * <p>
     * If the navigation property <b>_JointVentureDescription</b> of a queried <b>JointVenture</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>JointVentureDescription</b> entities.
     */
    public void addJointVentureDescription( JointVentureDescription... entity )
    {
        if( to_JointVentureDescription == null ) {
            to_JointVentureDescription = Lists.newArrayList();
        }
        to_JointVentureDescription.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>JointVentureEquityGroup</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_JointVentureEquityGroup</b>.
     * <p>
     * If the navigation property for an entity <b>JointVenture</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JointVentureEquityGroup</b> is already loaded, the result
     *         will contain the <b>JointVentureEquityGroup</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<JointVentureEquityGroup>> getJointVentureEquityGroupIfPresent()
    {
        return Option.of(to_JointVentureEquityGroup);
    }

    /**
     * Overwrites the list of associated <b>JointVentureEquityGroup</b> entities for the loaded navigation property
     * <b>_JointVentureEquityGroup</b>.
     * <p>
     * If the navigation property <b>_JointVentureEquityGroup</b> of a queried <b>JointVenture</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>JointVentureEquityGroup</b> entities.
     */
    public void setJointVentureEquityGroup( @Nonnull final List<JointVentureEquityGroup> value )
    {
        if( to_JointVentureEquityGroup == null ) {
            to_JointVentureEquityGroup = Lists.newArrayList();
        }
        to_JointVentureEquityGroup.clear();
        to_JointVentureEquityGroup.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>JointVentureEquityGroup</b> entities. This corresponds to the OData
     * navigation property <b>_JointVentureEquityGroup</b>.
     * <p>
     * If the navigation property <b>_JointVentureEquityGroup</b> of a queried <b>JointVenture</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>JointVentureEquityGroup</b> entities.
     */
    public void addJointVentureEquityGroup( JointVentureEquityGroup... entity )
    {
        if( to_JointVentureEquityGroup == null ) {
            to_JointVentureEquityGroup = Lists.newArrayList();
        }
        to_JointVentureEquityGroup.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>JointVentureEquityType</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_JointVentureEquityType</b>.
     * <p>
     * If the navigation property for an entity <b>JointVenture</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JointVentureEquityType</b> is already loaded, the result
     *         will contain the <b>JointVentureEquityType</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<JointVentureEquityType>> getJointVentureEquityTypeIfPresent()
    {
        return Option.of(to_JointVentureEquityType);
    }

    /**
     * Overwrites the list of associated <b>JointVentureEquityType</b> entities for the loaded navigation property
     * <b>_JointVentureEquityType</b>.
     * <p>
     * If the navigation property <b>_JointVentureEquityType</b> of a queried <b>JointVenture</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>JointVentureEquityType</b> entities.
     */
    public void setJointVentureEquityType( @Nonnull final List<JointVentureEquityType> value )
    {
        if( to_JointVentureEquityType == null ) {
            to_JointVentureEquityType = Lists.newArrayList();
        }
        to_JointVentureEquityType.clear();
        to_JointVentureEquityType.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>JointVentureEquityType</b> entities. This corresponds to the OData
     * navigation property <b>_JointVentureEquityType</b>.
     * <p>
     * If the navigation property <b>_JointVentureEquityType</b> of a queried <b>JointVenture</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>JointVentureEquityType</b> entities.
     */
    public void addJointVentureEquityType( JointVentureEquityType... entity )
    {
        if( to_JointVentureEquityType == null ) {
            to_JointVentureEquityType = Lists.newArrayList();
        }
        to_JointVentureEquityType.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of JointVenture instances.
     * 
     */
    public final static class JointVentureBuilder
    {

        private List<JointVentureDescription> to_JointVentureDescription = Lists.newArrayList();
        private List<JointVentureEquityGroup> to_JointVentureEquityGroup = Lists.newArrayList();
        private List<JointVentureEquityType> to_JointVentureEquityType = Lists.newArrayList();

        private JointVenture.JointVentureBuilder to_JointVentureDescription( final List<JointVentureDescription> value )
        {
            to_JointVentureDescription.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_JointVentureDescription</b> for <b>JointVenture</b> to multiple
         * <b>JointVentureDescription</b>.
         * 
         * @param value
         *            The JointVentureDescriptions to build this JointVenture with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JointVenture.JointVentureBuilder jointVentureDescription( JointVentureDescription... value )
        {
            return to_JointVentureDescription(Lists.newArrayList(value));
        }

        private JointVenture.JointVentureBuilder to_JointVentureEquityGroup( final List<JointVentureEquityGroup> value )
        {
            to_JointVentureEquityGroup.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_JointVentureEquityGroup</b> for <b>JointVenture</b> to multiple
         * <b>JointVentureEquityGroup</b>.
         * 
         * @param value
         *            The JointVentureEquityGroups to build this JointVenture with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JointVenture.JointVentureBuilder jointVentureEquityGroup( JointVentureEquityGroup... value )
        {
            return to_JointVentureEquityGroup(Lists.newArrayList(value));
        }

        private JointVenture.JointVentureBuilder to_JointVentureEquityType( final List<JointVentureEquityType> value )
        {
            to_JointVentureEquityType.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_JointVentureEquityType</b> for <b>JointVenture</b> to multiple
         * <b>JointVentureEquityType</b>.
         * 
         * @param value
         *            The JointVentureEquityTypes to build this JointVenture with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JointVenture.JointVentureBuilder jointVentureEquityType( JointVentureEquityType... value )
        {
            return to_JointVentureEquityType(Lists.newArrayList(value));
        }

    }

}
