/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointventure;

import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.JointVentureService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Description
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JointVentureDescriptionType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class JointVentureDescription extends VdmEntity<JointVentureDescription> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_jointventure.v0001.A_JointVentureDescriptionType";
    /**
     * Selector for all available fields of JointVentureDescription.
     * 
     */
    public final static SimpleProperty<JointVentureDescription> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<JointVentureDescription> COMPANY_CODE =
        new SimpleProperty.String<JointVentureDescription>(JointVentureDescription.class, "CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<JointVentureDescription> LANGUAGE =
        new SimpleProperty.String<JointVentureDescription>(JointVentureDescription.class, "Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     * 
     * @return Joint Venture
     */
    @Nullable
    @ElementName( "JointVenture" )
    private java.lang.String jointVenture;
    public final static SimpleProperty.String<JointVentureDescription> JOINT_VENTURE =
        new SimpleProperty.String<JointVentureDescription>(JointVentureDescription.class, "JointVenture");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureName</b>
     * </p>
     * 
     * @return Joint Venture Name
     */
    @Nullable
    @ElementName( "JointVentureName" )
    private java.lang.String jointVentureName;
    public final static SimpleProperty.String<JointVentureDescription> JOINT_VENTURE_NAME =
        new SimpleProperty.String<JointVentureDescription>(JointVentureDescription.class, "JointVentureName");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JointVentureDescription, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JointVentureDescription, SAP__Message>(
            JointVentureDescription.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_JointVenture</b> for <b>JointVentureDescription</b> to single <b>JointVenture</b>.
     * 
     */
    @ElementName( "_JointVenture" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private JointVenture to_JointVenture;
    /**
     * Use with available request builders to apply the <b>_JointVenture</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JointVentureDescription, JointVenture> TO__JOINT_VENTURE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JointVentureDescription, JointVenture>(
            JointVentureDescription.class,
            "_JointVenture",
            JointVenture.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<JointVentureDescription> getType()
    {
        return JointVentureDescription.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     * 
     * @param jointVenture
     *            Joint Venture
     */
    public void setJointVenture( @Nullable final java.lang.String jointVenture )
    {
        rememberChangedField("JointVenture", this.jointVenture);
        this.jointVenture = jointVenture;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureName</b>
     * </p>
     * 
     * @param jointVentureName
     *            Joint Venture Name
     */
    public void setJointVentureName( @Nullable final java.lang.String jointVentureName )
    {
        rememberChangedField("JointVentureName", this.jointVentureName);
        this.jointVentureName = jointVentureName;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_JointVentureDescription";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CompanyCode", getCompanyCode());
        entityKey.addKeyProperty("Language", getLanguage());
        entityKey.addKeyProperty("JointVenture", getJointVenture());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("Language", getLanguage());
        values.put("JointVenture", getJointVenture());
        values.put("JointVentureName", getJointVentureName());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVenture") ) {
                final Object value = values.remove("JointVenture");
                if( (value == null) || (!value.equals(getJointVenture())) ) {
                    setJointVenture(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVentureName") ) {
                final Object value = values.remove("JointVentureName");
                if( (value == null) || (!value.equals(getJointVentureName())) ) {
                    setJointVentureName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_JointVenture") ) {
                final Object value = (values).remove("_JointVenture");
                if( value instanceof Map ) {
                    if( to_JointVenture == null ) {
                        to_JointVenture = new JointVenture();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_JointVenture.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return JointVentureService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_JointVenture != null ) {
            (values).put("_JointVenture", to_JointVenture);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>JointVenture</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_JointVenture</b>.
     * <p>
     * If the navigation property for an entity <b>JointVentureDescription</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JointVenture</b> is already loaded, the result will
     *         contain the <b>JointVenture</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<JointVenture> getJointVentureIfPresent()
    {
        return Option.of(to_JointVenture);
    }

    /**
     * Overwrites the associated <b>JointVenture</b> entity for the loaded navigation property <b>_JointVenture</b>.
     * 
     * @param value
     *            New <b>JointVenture</b> entity.
     */
    public void setJointVenture( final JointVenture value )
    {
        to_JointVenture = value;
    }

    /**
     * Helper class to allow for fluent creation of JointVentureDescription instances.
     * 
     */
    public final static class JointVentureDescriptionBuilder
    {

        private JointVenture to_JointVenture;
        private java.lang.String jointVenture = null;

        private JointVentureDescription.JointVentureDescriptionBuilder to_JointVenture( final JointVenture value )
        {
            to_JointVenture = value;
            return this;
        }

        /**
         * Navigation property <b>_JointVenture</b> for <b>JointVentureDescription</b> to single <b>JointVenture</b>.
         * 
         * @param value
         *            The JointVenture to build this JointVentureDescription with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JointVentureDescription.JointVentureDescriptionBuilder jointVenture( final JointVenture value )
        {
            return to_JointVenture(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>JointVenture</b>
         * </p>
         * 
         * @param value
         *            The jointVenture to build this JointVentureDescription with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JointVentureDescription.JointVentureDescriptionBuilder jointVenture( final java.lang.String value )
        {
            jointVenture = value;
            return this;
        }

    }

}
