/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointventure;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.JointVentureService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Equity Group
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JointVentureEquityGroupType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class JointVentureEquityGroup extends VdmEntity<JointVentureEquityGroup> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_jointventure.v0001.A_JointVentureEquityGroupType";
    /**
     * Selector for all available fields of JointVentureEquityGroup.
     * 
     */
    public final static SimpleProperty<JointVentureEquityGroup> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<JointVentureEquityGroup> COMPANY_CODE =
        new SimpleProperty.String<JointVentureEquityGroup>(JointVentureEquityGroup.class, "CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     * 
     * @return Joint Venture
     */
    @Nullable
    @ElementName( "JointVenture" )
    private java.lang.String jointVenture;
    public final static SimpleProperty.String<JointVentureEquityGroup> JOINT_VENTURE =
        new SimpleProperty.String<JointVentureEquityGroup>(JointVentureEquityGroup.class, "JointVenture");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrp</b>
     * </p>
     * 
     * @return Equity Group
     */
    @Nullable
    @ElementName( "JntOpgAgrmtEquityGrp" )
    private java.lang.String jntOpgAgrmtEquityGrp;
    public final static SimpleProperty.String<JointVentureEquityGroup> JNT_OPG_AGRMT_EQUITY_GRP =
        new SimpleProperty.String<JointVentureEquityGroup>(JointVentureEquityGroup.class, "JntOpgAgrmtEquityGrp");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrpText</b>
     * </p>
     * 
     * @return The jntOpgAgrmtEquityGrpText contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "JntOpgAgrmtEquityGrpText" )
    private java.lang.String jntOpgAgrmtEquityGrpText;
    public final static SimpleProperty.String<JointVentureEquityGroup> JNT_OPG_AGRMT_EQUITY_GRP_TEXT =
        new SimpleProperty.String<JointVentureEquityGroup>(JointVentureEquityGroup.class, "JntOpgAgrmtEquityGrpText");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOperatedShare</b>
     * </p>
     * 
     * @return Operated Share
     */
    @Nullable
    @ElementName( "JntVntrOperatedShare" )
    @DecimalDescriptor( precision = 9, scale = 6 )
    private BigDecimal jntVntrOperatedShare;
    public final static SimpleProperty.NumericDecimal<JointVentureEquityGroup> JNT_VNTR_OPERATED_SHARE =
        new SimpleProperty.NumericDecimal<JointVentureEquityGroup>(
            JointVentureEquityGroup.class,
            "JntVntrOperatedShare");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNonOperatedShare</b>
     * </p>
     * 
     * @return Non-Operated Share
     */
    @Nullable
    @ElementName( "JntVntrNonOperatedShare" )
    @DecimalDescriptor( precision = 9, scale = 6 )
    private BigDecimal jntVntrNonOperatedShare;
    public final static SimpleProperty.NumericDecimal<JointVentureEquityGroup> JNT_VNTR_NON_OPERATED_SHARE =
        new SimpleProperty.NumericDecimal<JointVentureEquityGroup>(
            JointVentureEquityGroup.class,
            "JntVntrNonOperatedShare");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpIsSuspended</b>
     * </p>
     * 
     * @return Equity Group Suspended
     */
    @Nullable
    @ElementName( "JntVntrEquityGrpIsSuspended" )
    private java.lang.Boolean jntVntrEquityGrpIsSuspended;
    public final static SimpleProperty.Boolean<JointVentureEquityGroup> JNT_VNTR_EQUITY_GRP_IS_SUSPENDED =
        new SimpleProperty.Boolean<JointVentureEquityGroup>(
            JointVentureEquityGroup.class,
            "JntVntrEquityGrpIsSuspended");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpSuspendedPerd</b>
     * </p>
     * 
     * @return Equity Group Suspended Period
     */
    @Nullable
    @ElementName( "JntVntrEquityGrpSuspendedPerd" )
    private java.lang.String jntVntrEquityGrpSuspendedPerd;
    public final static SimpleProperty.String<JointVentureEquityGroup> JNT_VNTR_EQUITY_GRP_SUSPENDED_PERD =
        new SimpleProperty.String<JointVentureEquityGroup>(
            JointVentureEquityGroup.class,
            "JntVntrEquityGrpSuspendedPerd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpSuspendedYr</b>
     * </p>
     * 
     * @return JV Group Suspense Year
     */
    @Nullable
    @ElementName( "JntVntrEquityGrpSuspendedYr" )
    private java.lang.String jntVntrEquityGrpSuspendedYr;
    public final static SimpleProperty.String<JointVentureEquityGroup> JNT_VNTR_EQUITY_GRP_SUSPENDED_YR =
        new SimpleProperty.String<JointVentureEquityGroup>(
            JointVentureEquityGroup.class,
            "JntVntrEquityGrpSuspendedYr");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpIsNotSuspended</b>
     * </p>
     * 
     * @return JV Equity Group Unsuspensed
     */
    @Nullable
    @ElementName( "JntVntrEquityGrpIsNotSuspended" )
    private java.lang.Boolean jntVntrEquityGrpIsNotSuspended;
    public final static SimpleProperty.Boolean<JointVentureEquityGroup> JNT_VNTR_EQUITY_GRP_IS_NOT_SUSPENDED =
        new SimpleProperty.Boolean<JointVentureEquityGroup>(
            JointVentureEquityGroup.class,
            "JntVntrEquityGrpIsNotSuspended");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrGrpNotSuspendedPerd</b>
     * </p>
     * 
     * @return JV Group Unsuspensed Period
     */
    @Nullable
    @ElementName( "JntVntrGrpNotSuspendedPerd" )
    private java.lang.String jntVntrGrpNotSuspendedPerd;
    public final static SimpleProperty.String<JointVentureEquityGroup> JNT_VNTR_GRP_NOT_SUSPENDED_PERD =
        new SimpleProperty.String<JointVentureEquityGroup>(JointVentureEquityGroup.class, "JntVntrGrpNotSuspendedPerd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrGrpNotSuspendedYr</b>
     * </p>
     * 
     * @return JV Group Unsuspensed Year
     */
    @Nullable
    @ElementName( "JntVntrGrpNotSuspendedYr" )
    private java.lang.String jntVntrGrpNotSuspendedYr;
    public final static SimpleProperty.String<JointVentureEquityGroup> JNT_VNTR_GRP_NOT_SUSPENDED_YR =
        new SimpleProperty.String<JointVentureEquityGroup>(JointVentureEquityGroup.class, "JntVntrGrpNotSuspendedYr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNetProfitIntrstGrp</b>
     * </p>
     * 
     * @return JV Net Profit Interest Group
     */
    @Nullable
    @ElementName( "JntVntrNetProfitIntrstGrp" )
    private java.lang.String jntVntrNetProfitIntrstGrp;
    public final static SimpleProperty.String<JointVentureEquityGroup> JNT_VNTR_NET_PROFIT_INTRST_GRP =
        new SimpleProperty.String<JointVentureEquityGroup>(JointVentureEquityGroup.class, "JntVntrNetProfitIntrstGrp");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JointVentureEquityGroup, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JointVentureEquityGroup, SAP__Message>(
            JointVentureEquityGroup.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_JntVntrPartOwnrEquityShr</b> for <b>JointVentureEquityGroup</b> to multiple
     * <b>JntVntrPartEquityShr</b>.
     * 
     */
    @ElementName( "_JntVntrPartOwnrEquityShr" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<JntVntrPartEquityShr> to_JntVntrPartOwnrEquityShr;
    /**
     * Navigation property <b>_JointVenture</b> for <b>JointVentureEquityGroup</b> to single <b>JointVenture</b>.
     * 
     */
    @ElementName( "_JointVenture" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private JointVenture to_JointVenture;
    /**
     * Use with available request builders to apply the <b>_JntVntrPartOwnrEquityShr</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JointVentureEquityGroup, JntVntrPartEquityShr> TO__JNT_VNTR_PART_OWNR_EQUITY_SHR =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JointVentureEquityGroup, JntVntrPartEquityShr>(
            JointVentureEquityGroup.class,
            "_JntVntrPartOwnrEquityShr",
            JntVntrPartEquityShr.class);
    /**
     * Use with available request builders to apply the <b>_JointVenture</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JointVentureEquityGroup, JointVenture> TO__JOINT_VENTURE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JointVentureEquityGroup, JointVenture>(
            JointVentureEquityGroup.class,
            "_JointVenture",
            JointVenture.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<JointVentureEquityGroup> getType()
    {
        return JointVentureEquityGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     * 
     * @param jointVenture
     *            Joint Venture
     */
    public void setJointVenture( @Nullable final java.lang.String jointVenture )
    {
        rememberChangedField("JointVenture", this.jointVenture);
        this.jointVenture = jointVenture;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrp</b>
     * </p>
     * 
     * @param jntOpgAgrmtEquityGrp
     *            Equity Group
     */
    public void setJntOpgAgrmtEquityGrp( @Nullable final java.lang.String jntOpgAgrmtEquityGrp )
    {
        rememberChangedField("JntOpgAgrmtEquityGrp", this.jntOpgAgrmtEquityGrp);
        this.jntOpgAgrmtEquityGrp = jntOpgAgrmtEquityGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrpText</b>
     * </p>
     * 
     * @param jntOpgAgrmtEquityGrpText
     *            The jntOpgAgrmtEquityGrpText to set.
     */
    public void setJntOpgAgrmtEquityGrpText( @Nullable final java.lang.String jntOpgAgrmtEquityGrpText )
    {
        rememberChangedField("JntOpgAgrmtEquityGrpText", this.jntOpgAgrmtEquityGrpText);
        this.jntOpgAgrmtEquityGrpText = jntOpgAgrmtEquityGrpText;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOperatedShare</b>
     * </p>
     * 
     * @param jntVntrOperatedShare
     *            Operated Share
     */
    public void setJntVntrOperatedShare( @Nullable final BigDecimal jntVntrOperatedShare )
    {
        rememberChangedField("JntVntrOperatedShare", this.jntVntrOperatedShare);
        this.jntVntrOperatedShare = jntVntrOperatedShare;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNonOperatedShare</b>
     * </p>
     * 
     * @param jntVntrNonOperatedShare
     *            Non-Operated Share
     */
    public void setJntVntrNonOperatedShare( @Nullable final BigDecimal jntVntrNonOperatedShare )
    {
        rememberChangedField("JntVntrNonOperatedShare", this.jntVntrNonOperatedShare);
        this.jntVntrNonOperatedShare = jntVntrNonOperatedShare;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpIsSuspended</b>
     * </p>
     * 
     * @param jntVntrEquityGrpIsSuspended
     *            Equity Group Suspended
     */
    public void setJntVntrEquityGrpIsSuspended( @Nullable final java.lang.Boolean jntVntrEquityGrpIsSuspended )
    {
        rememberChangedField("JntVntrEquityGrpIsSuspended", this.jntVntrEquityGrpIsSuspended);
        this.jntVntrEquityGrpIsSuspended = jntVntrEquityGrpIsSuspended;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpSuspendedPerd</b>
     * </p>
     * 
     * @param jntVntrEquityGrpSuspendedPerd
     *            Equity Group Suspended Period
     */
    public void setJntVntrEquityGrpSuspendedPerd( @Nullable final java.lang.String jntVntrEquityGrpSuspendedPerd )
    {
        rememberChangedField("JntVntrEquityGrpSuspendedPerd", this.jntVntrEquityGrpSuspendedPerd);
        this.jntVntrEquityGrpSuspendedPerd = jntVntrEquityGrpSuspendedPerd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpSuspendedYr</b>
     * </p>
     * 
     * @param jntVntrEquityGrpSuspendedYr
     *            JV Group Suspense Year
     */
    public void setJntVntrEquityGrpSuspendedYr( @Nullable final java.lang.String jntVntrEquityGrpSuspendedYr )
    {
        rememberChangedField("JntVntrEquityGrpSuspendedYr", this.jntVntrEquityGrpSuspendedYr);
        this.jntVntrEquityGrpSuspendedYr = jntVntrEquityGrpSuspendedYr;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpIsNotSuspended</b>
     * </p>
     * 
     * @param jntVntrEquityGrpIsNotSuspended
     *            JV Equity Group Unsuspensed
     */
    public void setJntVntrEquityGrpIsNotSuspended( @Nullable final java.lang.Boolean jntVntrEquityGrpIsNotSuspended )
    {
        rememberChangedField("JntVntrEquityGrpIsNotSuspended", this.jntVntrEquityGrpIsNotSuspended);
        this.jntVntrEquityGrpIsNotSuspended = jntVntrEquityGrpIsNotSuspended;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrGrpNotSuspendedPerd</b>
     * </p>
     * 
     * @param jntVntrGrpNotSuspendedPerd
     *            JV Group Unsuspensed Period
     */
    public void setJntVntrGrpNotSuspendedPerd( @Nullable final java.lang.String jntVntrGrpNotSuspendedPerd )
    {
        rememberChangedField("JntVntrGrpNotSuspendedPerd", this.jntVntrGrpNotSuspendedPerd);
        this.jntVntrGrpNotSuspendedPerd = jntVntrGrpNotSuspendedPerd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrGrpNotSuspendedYr</b>
     * </p>
     * 
     * @param jntVntrGrpNotSuspendedYr
     *            JV Group Unsuspensed Year
     */
    public void setJntVntrGrpNotSuspendedYr( @Nullable final java.lang.String jntVntrGrpNotSuspendedYr )
    {
        rememberChangedField("JntVntrGrpNotSuspendedYr", this.jntVntrGrpNotSuspendedYr);
        this.jntVntrGrpNotSuspendedYr = jntVntrGrpNotSuspendedYr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNetProfitIntrstGrp</b>
     * </p>
     * 
     * @param jntVntrNetProfitIntrstGrp
     *            JV Net Profit Interest Group
     */
    public void setJntVntrNetProfitIntrstGrp( @Nullable final java.lang.String jntVntrNetProfitIntrstGrp )
    {
        rememberChangedField("JntVntrNetProfitIntrstGrp", this.jntVntrNetProfitIntrstGrp);
        this.jntVntrNetProfitIntrstGrp = jntVntrNetProfitIntrstGrp;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_JointVentureEquityGroup";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CompanyCode", getCompanyCode());
        entityKey.addKeyProperty("JointVenture", getJointVenture());
        entityKey.addKeyProperty("JntOpgAgrmtEquityGrp", getJntOpgAgrmtEquityGrp());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("JointVenture", getJointVenture());
        values.put("JntOpgAgrmtEquityGrp", getJntOpgAgrmtEquityGrp());
        values.put("JntOpgAgrmtEquityGrpText", getJntOpgAgrmtEquityGrpText());
        values.put("JntVntrOperatedShare", getJntVntrOperatedShare());
        values.put("JntVntrNonOperatedShare", getJntVntrNonOperatedShare());
        values.put("JntVntrEquityGrpIsSuspended", getJntVntrEquityGrpIsSuspended());
        values.put("JntVntrEquityGrpSuspendedPerd", getJntVntrEquityGrpSuspendedPerd());
        values.put("JntVntrEquityGrpSuspendedYr", getJntVntrEquityGrpSuspendedYr());
        values.put("JntVntrEquityGrpIsNotSuspended", getJntVntrEquityGrpIsNotSuspended());
        values.put("JntVntrGrpNotSuspendedPerd", getJntVntrGrpNotSuspendedPerd());
        values.put("JntVntrGrpNotSuspendedYr", getJntVntrGrpNotSuspendedYr());
        values.put("JntVntrNetProfitIntrstGrp", getJntVntrNetProfitIntrstGrp());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVenture") ) {
                final Object value = values.remove("JointVenture");
                if( (value == null) || (!value.equals(getJointVenture())) ) {
                    setJointVenture(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtEquityGrp") ) {
                final Object value = values.remove("JntOpgAgrmtEquityGrp");
                if( (value == null) || (!value.equals(getJntOpgAgrmtEquityGrp())) ) {
                    setJntOpgAgrmtEquityGrp(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtEquityGrpText") ) {
                final Object value = values.remove("JntOpgAgrmtEquityGrpText");
                if( (value == null) || (!value.equals(getJntOpgAgrmtEquityGrpText())) ) {
                    setJntOpgAgrmtEquityGrpText(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrOperatedShare") ) {
                final Object value = values.remove("JntVntrOperatedShare");
                if( (value == null) || (!value.equals(getJntVntrOperatedShare())) ) {
                    setJntVntrOperatedShare(((BigDecimal) value));
                }
            }
            if( values.containsKey("JntVntrNonOperatedShare") ) {
                final Object value = values.remove("JntVntrNonOperatedShare");
                if( (value == null) || (!value.equals(getJntVntrNonOperatedShare())) ) {
                    setJntVntrNonOperatedShare(((BigDecimal) value));
                }
            }
            if( values.containsKey("JntVntrEquityGrpIsSuspended") ) {
                final Object value = values.remove("JntVntrEquityGrpIsSuspended");
                if( (value == null) || (!value.equals(getJntVntrEquityGrpIsSuspended())) ) {
                    setJntVntrEquityGrpIsSuspended(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntVntrEquityGrpSuspendedPerd") ) {
                final Object value = values.remove("JntVntrEquityGrpSuspendedPerd");
                if( (value == null) || (!value.equals(getJntVntrEquityGrpSuspendedPerd())) ) {
                    setJntVntrEquityGrpSuspendedPerd(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrEquityGrpSuspendedYr") ) {
                final Object value = values.remove("JntVntrEquityGrpSuspendedYr");
                if( (value == null) || (!value.equals(getJntVntrEquityGrpSuspendedYr())) ) {
                    setJntVntrEquityGrpSuspendedYr(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrEquityGrpIsNotSuspended") ) {
                final Object value = values.remove("JntVntrEquityGrpIsNotSuspended");
                if( (value == null) || (!value.equals(getJntVntrEquityGrpIsNotSuspended())) ) {
                    setJntVntrEquityGrpIsNotSuspended(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntVntrGrpNotSuspendedPerd") ) {
                final Object value = values.remove("JntVntrGrpNotSuspendedPerd");
                if( (value == null) || (!value.equals(getJntVntrGrpNotSuspendedPerd())) ) {
                    setJntVntrGrpNotSuspendedPerd(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrGrpNotSuspendedYr") ) {
                final Object value = values.remove("JntVntrGrpNotSuspendedYr");
                if( (value == null) || (!value.equals(getJntVntrGrpNotSuspendedYr())) ) {
                    setJntVntrGrpNotSuspendedYr(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrNetProfitIntrstGrp") ) {
                final Object value = values.remove("JntVntrNetProfitIntrstGrp");
                if( (value == null) || (!value.equals(getJntVntrNetProfitIntrstGrp())) ) {
                    setJntVntrNetProfitIntrstGrp(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_JntVntrPartOwnrEquityShr") ) {
                final Object value = (values).remove("_JntVntrPartOwnrEquityShr");
                if( value instanceof Iterable ) {
                    if( to_JntVntrPartOwnrEquityShr == null ) {
                        to_JntVntrPartOwnrEquityShr = Lists.newArrayList();
                    } else {
                        to_JntVntrPartOwnrEquityShr = Lists.newArrayList(to_JntVntrPartOwnrEquityShr);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        JntVntrPartEquityShr entity;
                        if( to_JntVntrPartOwnrEquityShr.size() > i ) {
                            entity = to_JntVntrPartOwnrEquityShr.get(i);
                        } else {
                            entity = new JntVntrPartEquityShr();
                            to_JntVntrPartOwnrEquityShr.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_JointVenture") ) {
                final Object value = (values).remove("_JointVenture");
                if( value instanceof Map ) {
                    if( to_JointVenture == null ) {
                        to_JointVenture = new JointVenture();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_JointVenture.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return JointVentureService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_JntVntrPartOwnrEquityShr != null ) {
            (values).put("_JntVntrPartOwnrEquityShr", to_JntVntrPartOwnrEquityShr);
        }
        if( to_JointVenture != null ) {
            (values).put("_JointVenture", to_JointVenture);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>JntVntrPartEquityShr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_JntVntrPartOwnrEquityShr</b>.
     * <p>
     * If the navigation property for an entity <b>JointVentureEquityGroup</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JntVntrPartOwnrEquityShr</b> is already loaded, the result
     *         will contain the <b>JntVntrPartEquityShr</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<JntVntrPartEquityShr>> getJntVntrPartOwnrEquityShrIfPresent()
    {
        return Option.of(to_JntVntrPartOwnrEquityShr);
    }

    /**
     * Overwrites the list of associated <b>JntVntrPartEquityShr</b> entities for the loaded navigation property
     * <b>_JntVntrPartOwnrEquityShr</b>.
     * <p>
     * If the navigation property <b>_JntVntrPartOwnrEquityShr</b> of a queried <b>JointVentureEquityGroup</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>JntVntrPartEquityShr</b> entities.
     */
    public void setJntVntrPartOwnrEquityShr( @Nonnull final List<JntVntrPartEquityShr> value )
    {
        if( to_JntVntrPartOwnrEquityShr == null ) {
            to_JntVntrPartOwnrEquityShr = Lists.newArrayList();
        }
        to_JntVntrPartOwnrEquityShr.clear();
        to_JntVntrPartOwnrEquityShr.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>JntVntrPartEquityShr</b> entities. This corresponds to the OData
     * navigation property <b>_JntVntrPartOwnrEquityShr</b>.
     * <p>
     * If the navigation property <b>_JntVntrPartOwnrEquityShr</b> of a queried <b>JointVentureEquityGroup</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>JntVntrPartEquityShr</b> entities.
     */
    public void addJntVntrPartOwnrEquityShr( JntVntrPartEquityShr... entity )
    {
        if( to_JntVntrPartOwnrEquityShr == null ) {
            to_JntVntrPartOwnrEquityShr = Lists.newArrayList();
        }
        to_JntVntrPartOwnrEquityShr.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>JointVenture</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_JointVenture</b>.
     * <p>
     * If the navigation property for an entity <b>JointVentureEquityGroup</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JointVenture</b> is already loaded, the result will
     *         contain the <b>JointVenture</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<JointVenture> getJointVentureIfPresent()
    {
        return Option.of(to_JointVenture);
    }

    /**
     * Overwrites the associated <b>JointVenture</b> entity for the loaded navigation property <b>_JointVenture</b>.
     * 
     * @param value
     *            New <b>JointVenture</b> entity.
     */
    public void setJointVenture( final JointVenture value )
    {
        to_JointVenture = value;
    }

    /**
     * Helper class to allow for fluent creation of JointVentureEquityGroup instances.
     * 
     */
    public final static class JointVentureEquityGroupBuilder
    {

        private List<JntVntrPartEquityShr> to_JntVntrPartOwnrEquityShr = Lists.newArrayList();
        private JointVenture to_JointVenture;
        private java.lang.String jointVenture = null;

        private JointVentureEquityGroup.JointVentureEquityGroupBuilder to_JntVntrPartOwnrEquityShr(
            final List<JntVntrPartEquityShr> value )
        {
            to_JntVntrPartOwnrEquityShr.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_JntVntrPartOwnrEquityShr</b> for <b>JointVentureEquityGroup</b> to multiple
         * <b>JntVntrPartEquityShr</b>.
         * 
         * @param value
         *            The JntVntrPartEquityShrs to build this JointVentureEquityGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JointVentureEquityGroup.JointVentureEquityGroupBuilder jntVntrPartOwnrEquityShr(
            JntVntrPartEquityShr... value )
        {
            return to_JntVntrPartOwnrEquityShr(Lists.newArrayList(value));
        }

        private JointVentureEquityGroup.JointVentureEquityGroupBuilder to_JointVenture( final JointVenture value )
        {
            to_JointVenture = value;
            return this;
        }

        /**
         * Navigation property <b>_JointVenture</b> for <b>JointVentureEquityGroup</b> to single <b>JointVenture</b>.
         * 
         * @param value
         *            The JointVenture to build this JointVentureEquityGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JointVentureEquityGroup.JointVentureEquityGroupBuilder jointVenture( final JointVenture value )
        {
            return to_JointVenture(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>JointVenture</b>
         * </p>
         * 
         * @param value
         *            The jointVenture to build this JointVentureEquityGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JointVentureEquityGroup.JointVentureEquityGroupBuilder jointVenture( final java.lang.String value )
        {
            jointVenture = value;
            return this;
        }

    }

}
