/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointventure;

import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.JointVentureService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Equity Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JointVentureEquityTypeType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class JointVentureEquityType extends VdmEntity<JointVentureEquityType> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_jointventure.v0001.A_JointVentureEquityTypeType";
    /**
     * Selector for all available fields of JointVentureEquityType.
     * 
     */
    public final static SimpleProperty<JointVentureEquityType> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<JointVentureEquityType> COMPANY_CODE =
        new SimpleProperty.String<JointVentureEquityType>(JointVentureEquityType.class, "CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     * 
     * @return Joint Venture
     */
    @Nullable
    @ElementName( "JointVenture" )
    private java.lang.String jointVenture;
    public final static SimpleProperty.String<JointVentureEquityType> JOINT_VENTURE =
        new SimpleProperty.String<JointVentureEquityType>(JointVentureEquityType.class, "JointVenture");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType</b>
     * </p>
     * 
     * @return Equity Type
     */
    @Nullable
    @ElementName( "JointVentureEquityType" )
    private java.lang.String jointVentureEquityType;
    public final static SimpleProperty.String<JointVentureEquityType> JOINT_VENTURE_EQUITY_TYPE =
        new SimpleProperty.String<JointVentureEquityType>(JointVentureEquityType.class, "JointVentureEquityType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityFundingDate</b>
     * </p>
     * 
     * @return Valid from date (inverted: 99999999 - YYYYMMDD)
     */
    @Nullable
    @ElementName( "JointVentureEquityFundingDate" )
    private java.lang.String jointVentureEquityFundingDate;
    public final static SimpleProperty.String<JointVentureEquityType> JOINT_VENTURE_EQUITY_FUNDING_DATE =
        new SimpleProperty.String<JointVentureEquityType>(
            JointVentureEquityType.class,
            "JointVentureEquityFundingDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityGroup</b>
     * </p>
     * 
     * @return Equity Group
     */
    @Nullable
    @ElementName( "JointVentureEquityGroup" )
    private java.lang.String jointVentureEquityGroup;
    public final static SimpleProperty.String<JointVentureEquityType> JOINT_VENTURE_EQUITY_GROUP =
        new SimpleProperty.String<JointVentureEquityType>(JointVentureEquityType.class, "JointVentureEquityGroup");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityGroupActive</b>
     * </p>
     * 
     * @return Equity Group Active Status
     */
    @Nullable
    @ElementName( "JointVentureEquityGroupActive" )
    private java.lang.Boolean jointVentureEquityGroupActive;
    public final static SimpleProperty.Boolean<JointVentureEquityType> JOINT_VENTURE_EQUITY_GROUP_ACTIVE =
        new SimpleProperty.Boolean<JointVentureEquityType>(
            JointVentureEquityType.class,
            "JointVentureEquityGroupActive");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureDefBillCurrency</b>
     * </p>
     * 
     * @return JV Default Billing Currency
     */
    @Nullable
    @ElementName( "JointVentureDefBillCurrency" )
    private java.lang.String jointVentureDefBillCurrency;
    public final static SimpleProperty.String<JointVentureEquityType> JOINT_VENTURE_DEF_BILL_CURRENCY =
        new SimpleProperty.String<JointVentureEquityType>(JointVentureEquityType.class, "JointVentureDefBillCurrency");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JointVentureEquityType, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JointVentureEquityType, SAP__Message>(
            JointVentureEquityType.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_JointVenture</b> for <b>JointVentureEquityType</b> to single <b>JointVenture</b>.
     * 
     */
    @ElementName( "_JointVenture" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private JointVenture to_JointVenture;
    /**
     * Use with available request builders to apply the <b>_JointVenture</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JointVentureEquityType, JointVenture> TO__JOINT_VENTURE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JointVentureEquityType, JointVenture>(
            JointVentureEquityType.class,
            "_JointVenture",
            JointVenture.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<JointVentureEquityType> getType()
    {
        return JointVentureEquityType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     * 
     * @param jointVenture
     *            Joint Venture
     */
    public void setJointVenture( @Nullable final java.lang.String jointVenture )
    {
        rememberChangedField("JointVenture", this.jointVenture);
        this.jointVenture = jointVenture;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType</b>
     * </p>
     * 
     * @param jointVentureEquityType
     *            Equity Type
     */
    public void setJointVentureEquityType( @Nullable final java.lang.String jointVentureEquityType )
    {
        rememberChangedField("JointVentureEquityType", this.jointVentureEquityType);
        this.jointVentureEquityType = jointVentureEquityType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityFundingDate</b>
     * </p>
     * 
     * @param jointVentureEquityFundingDate
     *            Valid from date (inverted: 99999999 - YYYYMMDD)
     */
    public void setJointVentureEquityFundingDate( @Nullable final java.lang.String jointVentureEquityFundingDate )
    {
        rememberChangedField("JointVentureEquityFundingDate", this.jointVentureEquityFundingDate);
        this.jointVentureEquityFundingDate = jointVentureEquityFundingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityGroup</b>
     * </p>
     * 
     * @param jointVentureEquityGroup
     *            Equity Group
     */
    public void setJointVentureEquityGroup( @Nullable final java.lang.String jointVentureEquityGroup )
    {
        rememberChangedField("JointVentureEquityGroup", this.jointVentureEquityGroup);
        this.jointVentureEquityGroup = jointVentureEquityGroup;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityGroupActive</b>
     * </p>
     * 
     * @param jointVentureEquityGroupActive
     *            Equity Group Active Status
     */
    public void setJointVentureEquityGroupActive( @Nullable final java.lang.Boolean jointVentureEquityGroupActive )
    {
        rememberChangedField("JointVentureEquityGroupActive", this.jointVentureEquityGroupActive);
        this.jointVentureEquityGroupActive = jointVentureEquityGroupActive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureDefBillCurrency</b>
     * </p>
     * 
     * @param jointVentureDefBillCurrency
     *            JV Default Billing Currency
     */
    public void setJointVentureDefBillCurrency( @Nullable final java.lang.String jointVentureDefBillCurrency )
    {
        rememberChangedField("JointVentureDefBillCurrency", this.jointVentureDefBillCurrency);
        this.jointVentureDefBillCurrency = jointVentureDefBillCurrency;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_JointVentureEquityType";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CompanyCode", getCompanyCode());
        entityKey.addKeyProperty("JointVenture", getJointVenture());
        entityKey.addKeyProperty("JointVentureEquityType", getJointVentureEquityType());
        entityKey.addKeyProperty("JointVentureEquityFundingDate", getJointVentureEquityFundingDate());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("JointVenture", getJointVenture());
        values.put("JointVentureEquityType", getJointVentureEquityType());
        values.put("JointVentureEquityFundingDate", getJointVentureEquityFundingDate());
        values.put("JointVentureEquityGroup", getJointVentureEquityGroup());
        values.put("JointVentureEquityGroupActive", getJointVentureEquityGroupActive());
        values.put("JointVentureDefBillCurrency", getJointVentureDefBillCurrency());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVenture") ) {
                final Object value = values.remove("JointVenture");
                if( (value == null) || (!value.equals(getJointVenture())) ) {
                    setJointVenture(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVentureEquityType") ) {
                final Object value = values.remove("JointVentureEquityType");
                if( (value == null) || (!value.equals(getJointVentureEquityType())) ) {
                    setJointVentureEquityType(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVentureEquityFundingDate") ) {
                final Object value = values.remove("JointVentureEquityFundingDate");
                if( (value == null) || (!value.equals(getJointVentureEquityFundingDate())) ) {
                    setJointVentureEquityFundingDate(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVentureEquityGroup") ) {
                final Object value = values.remove("JointVentureEquityGroup");
                if( (value == null) || (!value.equals(getJointVentureEquityGroup())) ) {
                    setJointVentureEquityGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVentureEquityGroupActive") ) {
                final Object value = values.remove("JointVentureEquityGroupActive");
                if( (value == null) || (!value.equals(getJointVentureEquityGroupActive())) ) {
                    setJointVentureEquityGroupActive(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JointVentureDefBillCurrency") ) {
                final Object value = values.remove("JointVentureDefBillCurrency");
                if( (value == null) || (!value.equals(getJointVentureDefBillCurrency())) ) {
                    setJointVentureDefBillCurrency(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_JointVenture") ) {
                final Object value = (values).remove("_JointVenture");
                if( value instanceof Map ) {
                    if( to_JointVenture == null ) {
                        to_JointVenture = new JointVenture();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_JointVenture.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return JointVentureService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_JointVenture != null ) {
            (values).put("_JointVenture", to_JointVenture);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>JointVenture</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_JointVenture</b>.
     * <p>
     * If the navigation property for an entity <b>JointVentureEquityType</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JointVenture</b> is already loaded, the result will
     *         contain the <b>JointVenture</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<JointVenture> getJointVentureIfPresent()
    {
        return Option.of(to_JointVenture);
    }

    /**
     * Overwrites the associated <b>JointVenture</b> entity for the loaded navigation property <b>_JointVenture</b>.
     * 
     * @param value
     *            New <b>JointVenture</b> entity.
     */
    public void setJointVenture( final JointVenture value )
    {
        to_JointVenture = value;
    }

    /**
     * Helper class to allow for fluent creation of JointVentureEquityType instances.
     * 
     */
    public final static class JointVentureEquityTypeBuilder
    {

        private JointVenture to_JointVenture;
        private java.lang.String jointVenture = null;

        private JointVentureEquityType.JointVentureEquityTypeBuilder to_JointVenture( final JointVenture value )
        {
            to_JointVenture = value;
            return this;
        }

        /**
         * Navigation property <b>_JointVenture</b> for <b>JointVentureEquityType</b> to single <b>JointVenture</b>.
         * 
         * @param value
         *            The JointVenture to build this JointVentureEquityType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JointVentureEquityType.JointVentureEquityTypeBuilder jointVenture( final JointVenture value )
        {
            return to_JointVenture(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>JointVenture</b>
         * </p>
         * 
         * @param value
         *            The jointVenture to build this JointVentureEquityType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JointVentureEquityType.JointVentureEquityTypeBuilder jointVenture( final java.lang.String value )
        {
            jointVenture = value;
            return this;
        }

    }

}
