/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintainflexibleconstraintsforpredictivematerialandresourceplanning;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MaintainFlexibleConstraintsForPredictiveMaterialAndResourcePlanningService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Flexible Constraint Product
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConstraintProductType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ConstraintProduct extends VdmEntity<ConstraintProduct> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_pmrpflexibleconstraint.v0001.ConstraintProductType";
    /**
     * Selector for all available fields of ConstraintProduct.
     * 
     */
    public final static SimpleProperty<ConstraintProduct> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlexibleConstraint</b>
     * </p>
     * 
     * @return pMRP Unique ID for Flexible Constraints
     */
    @Nullable
    @ElementName( "PMRPFlexibleConstraint" )
    private java.lang.String pMRPFlexibleConstraint;
    public final static SimpleProperty.String<ConstraintProduct> PMRP_FLEXIBLE_CONSTRAINT =
        new SimpleProperty.String<ConstraintProduct>(ConstraintProduct.class, "PMRPFlexibleConstraint");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintProductItem</b>
     * </p>
     * 
     * @return Item ID
     */
    @Nullable
    @ElementName( "PMRPConstraintProductItem" )
    private java.lang.String pMRPConstraintProductItem;
    public final static SimpleProperty.String<ConstraintProduct> PMRP_CONSTRAINT_PRODUCT_ITEM =
        new SimpleProperty.String<ConstraintProduct>(ConstraintProduct.class, "PMRPConstraintProductItem");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @return Material Number
     */
    @Nullable
    @ElementName( "Product" )
    private java.lang.String product;
    public final static SimpleProperty.String<ConstraintProduct> PRODUCT =
        new SimpleProperty.String<ConstraintProduct>(ConstraintProduct.class, "Product");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintBaseUnit</b>
     * </p>
     * 
     * @return pMRP: Base UoM for Flexible Constraints
     */
    @Nullable
    @ElementName( "PMRPConstraintBaseUnit" )
    private java.lang.String pMRPConstraintBaseUnit;
    public final static SimpleProperty.String<ConstraintProduct> PMRP_CONSTRAINT_BASE_UNIT =
        new SimpleProperty.String<ConstraintProduct>(ConstraintProduct.class, "PMRPConstraintBaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PMRPProductUnit</b>
     * </p>
     * 
     * @return pMRP: UoM of Product in Flexible Constraint
     */
    @Nullable
    @ElementName( "PMRPProductUnit" )
    private java.lang.String pMRPProductUnit;
    public final static SimpleProperty.String<ConstraintProduct> PMRP_PRODUCT_UNIT =
        new SimpleProperty.String<ConstraintProduct>(ConstraintProduct.class, "PMRPProductUnit");
    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlxblCstrtToBaseUoMNmrtr</b>
     * </p>
     * 
     * @return Numerator for Conversion to Base Units of Measure
     */
    @Nullable
    @ElementName( "PMRPFlxblCstrtToBaseUoMNmrtr" )
    @DecimalDescriptor( precision = 5, scale = 0 )
    private BigDecimal pMRPFlxblCstrtToBaseUoMNmrtr;
    public final static SimpleProperty.NumericDecimal<ConstraintProduct> PMRP_FLXBL_CSTRT_TO_BASE_UO_M_NMRTR =
        new SimpleProperty.NumericDecimal<ConstraintProduct>(ConstraintProduct.class, "PMRPFlxblCstrtToBaseUoMNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlxblCstrtToBaseUoMDnmntr</b>
     * </p>
     * 
     * @return Denominator for conversion to base units of measure
     */
    @Nullable
    @ElementName( "PMRPFlxblCstrtToBaseUoMDnmntr" )
    @DecimalDescriptor( precision = 5, scale = 0 )
    private BigDecimal pMRPFlxblCstrtToBaseUoMDnmntr;
    public final static SimpleProperty.NumericDecimal<ConstraintProduct> PMRP_FLXBL_CSTRT_TO_BASE_UO_M_DNMNTR =
        new SimpleProperty.NumericDecimal<ConstraintProduct>(ConstraintProduct.class, "PMRPFlxblCstrtToBaseUoMDnmntr");
    /**
     * Navigation property <b>_Constraint</b> for <b>ConstraintProduct</b> to single <b>PMRPFlexibleConstraint</b>.
     * 
     */
    @ElementName( "_Constraint" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PMRPFlexibleConstraint to_Constraint;
    /**
     * Use with available request builders to apply the <b>_Constraint</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ConstraintProduct, PMRPFlexibleConstraint> TO__CONSTRAINT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ConstraintProduct, PMRPFlexibleConstraint>(
            ConstraintProduct.class,
            "_Constraint",
            PMRPFlexibleConstraint.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ConstraintProduct> getType()
    {
        return ConstraintProduct.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlexibleConstraint</b>
     * </p>
     * 
     * @param pMRPFlexibleConstraint
     *            pMRP Unique ID for Flexible Constraints
     */
    public void setPMRPFlexibleConstraint( @Nullable final java.lang.String pMRPFlexibleConstraint )
    {
        rememberChangedField("PMRPFlexibleConstraint", this.pMRPFlexibleConstraint);
        this.pMRPFlexibleConstraint = pMRPFlexibleConstraint;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintProductItem</b>
     * </p>
     * 
     * @param pMRPConstraintProductItem
     *            Item ID
     */
    public void setPMRPConstraintProductItem( @Nullable final java.lang.String pMRPConstraintProductItem )
    {
        rememberChangedField("PMRPConstraintProductItem", this.pMRPConstraintProductItem);
        this.pMRPConstraintProductItem = pMRPConstraintProductItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final java.lang.String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintBaseUnit</b>
     * </p>
     * 
     * @param pMRPConstraintBaseUnit
     *            pMRP: Base UoM for Flexible Constraints
     */
    public void setPMRPConstraintBaseUnit( @Nullable final java.lang.String pMRPConstraintBaseUnit )
    {
        rememberChangedField("PMRPConstraintBaseUnit", this.pMRPConstraintBaseUnit);
        this.pMRPConstraintBaseUnit = pMRPConstraintBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PMRPProductUnit</b>
     * </p>
     * 
     * @param pMRPProductUnit
     *            pMRP: UoM of Product in Flexible Constraint
     */
    public void setPMRPProductUnit( @Nullable final java.lang.String pMRPProductUnit )
    {
        rememberChangedField("PMRPProductUnit", this.pMRPProductUnit);
        this.pMRPProductUnit = pMRPProductUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlxblCstrtToBaseUoMNmrtr</b>
     * </p>
     * 
     * @param pMRPFlxblCstrtToBaseUoMNmrtr
     *            Numerator for Conversion to Base Units of Measure
     */
    public void setPMRPFlxblCstrtToBaseUoMNmrtr( @Nullable final BigDecimal pMRPFlxblCstrtToBaseUoMNmrtr )
    {
        rememberChangedField("PMRPFlxblCstrtToBaseUoMNmrtr", this.pMRPFlxblCstrtToBaseUoMNmrtr);
        this.pMRPFlxblCstrtToBaseUoMNmrtr = pMRPFlxblCstrtToBaseUoMNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlxblCstrtToBaseUoMDnmntr</b>
     * </p>
     * 
     * @param pMRPFlxblCstrtToBaseUoMDnmntr
     *            Denominator for conversion to base units of measure
     */
    public void setPMRPFlxblCstrtToBaseUoMDnmntr( @Nullable final BigDecimal pMRPFlxblCstrtToBaseUoMDnmntr )
    {
        rememberChangedField("PMRPFlxblCstrtToBaseUoMDnmntr", this.pMRPFlxblCstrtToBaseUoMDnmntr);
        this.pMRPFlxblCstrtToBaseUoMDnmntr = pMRPFlxblCstrtToBaseUoMDnmntr;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ConstraintProduct";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("PMRPFlexibleConstraint", getPMRPFlexibleConstraint());
        entityKey.addKeyProperty("PMRPConstraintProductItem", getPMRPConstraintProductItem());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("PMRPFlexibleConstraint", getPMRPFlexibleConstraint());
        values.put("PMRPConstraintProductItem", getPMRPConstraintProductItem());
        values.put("Product", getProduct());
        values.put("PMRPConstraintBaseUnit", getPMRPConstraintBaseUnit());
        values.put("PMRPProductUnit", getPMRPProductUnit());
        values.put("PMRPFlxblCstrtToBaseUoMNmrtr", getPMRPFlxblCstrtToBaseUoMNmrtr());
        values.put("PMRPFlxblCstrtToBaseUoMDnmntr", getPMRPFlxblCstrtToBaseUoMDnmntr());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PMRPFlexibleConstraint") ) {
                final Object value = values.remove("PMRPFlexibleConstraint");
                if( (value == null) || (!value.equals(getPMRPFlexibleConstraint())) ) {
                    setPMRPFlexibleConstraint(((java.lang.String) value));
                }
            }
            if( values.containsKey("PMRPConstraintProductItem") ) {
                final Object value = values.remove("PMRPConstraintProductItem");
                if( (value == null) || (!value.equals(getPMRPConstraintProductItem())) ) {
                    setPMRPConstraintProductItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((java.lang.String) value));
                }
            }
            if( values.containsKey("PMRPConstraintBaseUnit") ) {
                final Object value = values.remove("PMRPConstraintBaseUnit");
                if( (value == null) || (!value.equals(getPMRPConstraintBaseUnit())) ) {
                    setPMRPConstraintBaseUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("PMRPProductUnit") ) {
                final Object value = values.remove("PMRPProductUnit");
                if( (value == null) || (!value.equals(getPMRPProductUnit())) ) {
                    setPMRPProductUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("PMRPFlxblCstrtToBaseUoMNmrtr") ) {
                final Object value = values.remove("PMRPFlxblCstrtToBaseUoMNmrtr");
                if( (value == null) || (!value.equals(getPMRPFlxblCstrtToBaseUoMNmrtr())) ) {
                    setPMRPFlxblCstrtToBaseUoMNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("PMRPFlxblCstrtToBaseUoMDnmntr") ) {
                final Object value = values.remove("PMRPFlxblCstrtToBaseUoMDnmntr");
                if( (value == null) || (!value.equals(getPMRPFlxblCstrtToBaseUoMDnmntr())) ) {
                    setPMRPFlxblCstrtToBaseUoMDnmntr(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_Constraint") ) {
                final Object value = (values).remove("_Constraint");
                if( value instanceof Map ) {
                    if( to_Constraint == null ) {
                        to_Constraint = new PMRPFlexibleConstraint();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_Constraint.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MaintainFlexibleConstraintsForPredictiveMaterialAndResourcePlanningService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_Constraint != null ) {
            (values).put("_Constraint", to_Constraint);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>PMRPFlexibleConstraint</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_Constraint</b>.
     * <p>
     * If the navigation property for an entity <b>ConstraintProduct</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Constraint</b> is already loaded, the result will contain
     *         the <b>PMRPFlexibleConstraint</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PMRPFlexibleConstraint> getConstraintIfPresent()
    {
        return Option.of(to_Constraint);
    }

    /**
     * Overwrites the associated <b>PMRPFlexibleConstraint</b> entity for the loaded navigation property
     * <b>_Constraint</b>.
     * 
     * @param value
     *            New <b>PMRPFlexibleConstraint</b> entity.
     */
    public void setConstraint( final PMRPFlexibleConstraint value )
    {
        to_Constraint = value;
    }

    /**
     * Helper class to allow for fluent creation of ConstraintProduct instances.
     * 
     */
    public final static class ConstraintProductBuilder
    {

        private PMRPFlexibleConstraint to_Constraint;

        private ConstraintProduct.ConstraintProductBuilder to_Constraint( final PMRPFlexibleConstraint value )
        {
            to_Constraint = value;
            return this;
        }

        /**
         * Navigation property <b>_Constraint</b> for <b>ConstraintProduct</b> to single <b>PMRPFlexibleConstraint</b>.
         * 
         * @param value
         *            The PMRPFlexibleConstraint to build this ConstraintProduct with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConstraintProduct.ConstraintProductBuilder constraint( final PMRPFlexibleConstraint value )
        {
            return to_Constraint(value);
        }

    }

}
