/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintainflexibleconstraintsforpredictivematerialandresourceplanning;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MaintainFlexibleConstraintsForPredictiveMaterialAndResourcePlanningService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Flexible Constraint
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PMRPFlexibleConstraintType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class PMRPFlexibleConstraint extends VdmEntity<PMRPFlexibleConstraint> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_pmrpflexibleconstraint.v0001.PMRPFlexibleConstraintType";
    /**
     * Selector for all available fields of PMRPFlexibleConstraint.
     * 
     */
    public final static SimpleProperty<PMRPFlexibleConstraint> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlexibleConstraint</b>
     * </p>
     * 
     * @return pMRP Unique ID for Flexible Constraints
     */
    @Nullable
    @ElementName( "PMRPFlexibleConstraint" )
    private java.lang.String pMRPFlexibleConstraint;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> PMRP_FLEXIBLE_CONSTRAINT =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "PMRPFlexibleConstraint");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintType</b>
     * </p>
     * 
     * @return pMRP Flexible Constraint Type
     */
    @Nullable
    @ElementName( "PMRPConstraintType" )
    private java.lang.String pMRPConstraintType;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> PMRP_CONSTRAINT_TYPE =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "PMRPConstraintType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintCategory</b>
     * </p>
     * 
     * @return pMRP Flexible Constraint Category
     */
    @Nullable
    @ElementName( "PMRPConstraintCategory" )
    private java.lang.String pMRPConstraintCategory;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> PMRP_CONSTRAINT_CATEGORY =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "PMRPConstraintCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlexibleConstraintScope</b>
     * </p>
     * 
     * @return Scope of a Constraint (Single or Multiple Materials)
     */
    @Nullable
    @ElementName( "PMRPFlexibleConstraintScope" )
    private java.lang.String pMRPFlexibleConstraintScope;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> PMRP_FLEXIBLE_CONSTRAINT_SCOPE =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "PMRPFlexibleConstraintScope");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintProductSelection</b>
     * </p>
     * 
     * @return Type of Selection Products for a PMRP Constraint
     */
    @Nullable
    @ElementName( "PMRPConstraintProductSelection" )
    private java.lang.String pMRPConstraintProductSelection;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> PMRP_CONSTRAINT_PRODUCT_SELECTION =
        new SimpleProperty.String<PMRPFlexibleConstraint>(
            PMRPFlexibleConstraint.class,
            "PMRPConstraintProductSelection");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintPeriodType</b>
     * </p>
     * 
     * @return pMRP: Period Type for Flexible Constraints
     */
    @Nullable
    @ElementName( "PMRPConstraintPeriodType" )
    private java.lang.String pMRPConstraintPeriodType;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> PMRP_CONSTRAINT_PERIOD_TYPE =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "PMRPConstraintPeriodType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @return Material Number
     */
    @Nullable
    @ElementName( "Product" )
    private java.lang.String product;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> PRODUCT =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "Product");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> PLANT =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "Plant");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionLine</b>
     * </p>
     * 
     * @return Production Line for Repetitive Manufacturing
     */
    @Nullable
    @ElementName( "ProductionLine" )
    private java.lang.String productionLine;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> PRODUCTION_LINE =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "ProductionLine");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     * 
     * @return Account Number of Supplier
     */
    @Nullable
    @ElementName( "Supplier" )
    private java.lang.String supplier;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> SUPPLIER =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     * 
     * @return Supplying (issuing) plant in case of stock transport order
     */
    @Nullable
    @ElementName( "SupplyingPlant" )
    private java.lang.String supplyingPlant;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> SUPPLYING_PLANT =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "SupplyingPlant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     * 
     * @return MRP Area
     */
    @Nullable
    @ElementName( "MRPArea" )
    private java.lang.String mRPArea;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> MRP_AREA =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "MRPArea");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     * 
     * @return Material Group
     */
    @Nullable
    @ElementName( "MaterialGroup" )
    private java.lang.String materialGroup;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> MATERIAL_GROUP =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintBaseUnit</b>
     * </p>
     * 
     * @return pMRP: Base UoM for Flexible Constraints
     */
    @Nullable
    @ElementName( "PMRPConstraintBaseUnit" )
    private java.lang.String pMRPConstraintBaseUnit;
    public final static SimpleProperty.String<PMRPFlexibleConstraint> PMRP_CONSTRAINT_BASE_UNIT =
        new SimpleProperty.String<PMRPFlexibleConstraint>(PMRPFlexibleConstraint.class, "PMRPConstraintBaseUnit");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<PMRPFlexibleConstraint, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<PMRPFlexibleConstraint, SAP__Message>(
            PMRPFlexibleConstraint.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_Period</b> for <b>PMRPFlexibleConstraint</b> to multiple <b>Period</b>.
     * 
     */
    @ElementName( "_Period" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<Period> to_Period;
    /**
     * Navigation property <b>_Product</b> for <b>PMRPFlexibleConstraint</b> to multiple <b>ConstraintProduct</b>.
     * 
     */
    @ElementName( "_Product" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConstraintProduct> to_Product;
    /**
     * Navigation property <b>_Text</b> for <b>PMRPFlexibleConstraint</b> to multiple <b>Text</b>.
     * 
     */
    @ElementName( "_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<Text> to_Text;
    /**
     * Use with available request builders to apply the <b>_Period</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<PMRPFlexibleConstraint, Period> TO__PERIOD =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<PMRPFlexibleConstraint, Period>(
            PMRPFlexibleConstraint.class,
            "_Period",
            Period.class);
    /**
     * Use with available request builders to apply the <b>_Product</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<PMRPFlexibleConstraint, ConstraintProduct> TO__PRODUCT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<PMRPFlexibleConstraint, ConstraintProduct>(
            PMRPFlexibleConstraint.class,
            "_Product",
            ConstraintProduct.class);
    /**
     * Use with available request builders to apply the <b>_Text</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<PMRPFlexibleConstraint, Text> TO__TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<PMRPFlexibleConstraint, Text>(
            PMRPFlexibleConstraint.class,
            "_Text",
            Text.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<PMRPFlexibleConstraint> getType()
    {
        return PMRPFlexibleConstraint.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlexibleConstraint</b>
     * </p>
     * 
     * @param pMRPFlexibleConstraint
     *            pMRP Unique ID for Flexible Constraints
     */
    public void setPMRPFlexibleConstraint( @Nullable final java.lang.String pMRPFlexibleConstraint )
    {
        rememberChangedField("PMRPFlexibleConstraint", this.pMRPFlexibleConstraint);
        this.pMRPFlexibleConstraint = pMRPFlexibleConstraint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintType</b>
     * </p>
     * 
     * @param pMRPConstraintType
     *            pMRP Flexible Constraint Type
     */
    public void setPMRPConstraintType( @Nullable final java.lang.String pMRPConstraintType )
    {
        rememberChangedField("PMRPConstraintType", this.pMRPConstraintType);
        this.pMRPConstraintType = pMRPConstraintType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintCategory</b>
     * </p>
     * 
     * @param pMRPConstraintCategory
     *            pMRP Flexible Constraint Category
     */
    public void setPMRPConstraintCategory( @Nullable final java.lang.String pMRPConstraintCategory )
    {
        rememberChangedField("PMRPConstraintCategory", this.pMRPConstraintCategory);
        this.pMRPConstraintCategory = pMRPConstraintCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlexibleConstraintScope</b>
     * </p>
     * 
     * @param pMRPFlexibleConstraintScope
     *            Scope of a Constraint (Single or Multiple Materials)
     */
    public void setPMRPFlexibleConstraintScope( @Nullable final java.lang.String pMRPFlexibleConstraintScope )
    {
        rememberChangedField("PMRPFlexibleConstraintScope", this.pMRPFlexibleConstraintScope);
        this.pMRPFlexibleConstraintScope = pMRPFlexibleConstraintScope;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintProductSelection</b>
     * </p>
     * 
     * @param pMRPConstraintProductSelection
     *            Type of Selection Products for a PMRP Constraint
     */
    public void setPMRPConstraintProductSelection( @Nullable final java.lang.String pMRPConstraintProductSelection )
    {
        rememberChangedField("PMRPConstraintProductSelection", this.pMRPConstraintProductSelection);
        this.pMRPConstraintProductSelection = pMRPConstraintProductSelection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintPeriodType</b>
     * </p>
     * 
     * @param pMRPConstraintPeriodType
     *            pMRP: Period Type for Flexible Constraints
     */
    public void setPMRPConstraintPeriodType( @Nullable final java.lang.String pMRPConstraintPeriodType )
    {
        rememberChangedField("PMRPConstraintPeriodType", this.pMRPConstraintPeriodType);
        this.pMRPConstraintPeriodType = pMRPConstraintPeriodType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final java.lang.String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProductionLine</b>
     * </p>
     * 
     * @param productionLine
     *            Production Line for Repetitive Manufacturing
     */
    public void setProductionLine( @Nullable final java.lang.String productionLine )
    {
        rememberChangedField("ProductionLine", this.productionLine);
        this.productionLine = productionLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     * 
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final java.lang.String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     * 
     * @param supplyingPlant
     *            Supplying (issuing) plant in case of stock transport order
     */
    public void setSupplyingPlant( @Nullable final java.lang.String supplyingPlant )
    {
        rememberChangedField("SupplyingPlant", this.supplyingPlant);
        this.supplyingPlant = supplyingPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     * 
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final java.lang.String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     * 
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final java.lang.String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintBaseUnit</b>
     * </p>
     * 
     * @param pMRPConstraintBaseUnit
     *            pMRP: Base UoM for Flexible Constraints
     */
    public void setPMRPConstraintBaseUnit( @Nullable final java.lang.String pMRPConstraintBaseUnit )
    {
        rememberChangedField("PMRPConstraintBaseUnit", this.pMRPConstraintBaseUnit);
        this.pMRPConstraintBaseUnit = pMRPConstraintBaseUnit;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "PMRPFlexibleConstraint";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("PMRPFlexibleConstraint", getPMRPFlexibleConstraint());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("PMRPFlexibleConstraint", getPMRPFlexibleConstraint());
        values.put("PMRPConstraintType", getPMRPConstraintType());
        values.put("PMRPConstraintCategory", getPMRPConstraintCategory());
        values.put("PMRPFlexibleConstraintScope", getPMRPFlexibleConstraintScope());
        values.put("PMRPConstraintProductSelection", getPMRPConstraintProductSelection());
        values.put("PMRPConstraintPeriodType", getPMRPConstraintPeriodType());
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("ProductionLine", getProductionLine());
        values.put("Supplier", getSupplier());
        values.put("SupplyingPlant", getSupplyingPlant());
        values.put("MRPArea", getMRPArea());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("PMRPConstraintBaseUnit", getPMRPConstraintBaseUnit());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PMRPFlexibleConstraint") ) {
                final Object value = values.remove("PMRPFlexibleConstraint");
                if( (value == null) || (!value.equals(getPMRPFlexibleConstraint())) ) {
                    setPMRPFlexibleConstraint(((java.lang.String) value));
                }
            }
            if( values.containsKey("PMRPConstraintType") ) {
                final Object value = values.remove("PMRPConstraintType");
                if( (value == null) || (!value.equals(getPMRPConstraintType())) ) {
                    setPMRPConstraintType(((java.lang.String) value));
                }
            }
            if( values.containsKey("PMRPConstraintCategory") ) {
                final Object value = values.remove("PMRPConstraintCategory");
                if( (value == null) || (!value.equals(getPMRPConstraintCategory())) ) {
                    setPMRPConstraintCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("PMRPFlexibleConstraintScope") ) {
                final Object value = values.remove("PMRPFlexibleConstraintScope");
                if( (value == null) || (!value.equals(getPMRPFlexibleConstraintScope())) ) {
                    setPMRPFlexibleConstraintScope(((java.lang.String) value));
                }
            }
            if( values.containsKey("PMRPConstraintProductSelection") ) {
                final Object value = values.remove("PMRPConstraintProductSelection");
                if( (value == null) || (!value.equals(getPMRPConstraintProductSelection())) ) {
                    setPMRPConstraintProductSelection(((java.lang.String) value));
                }
            }
            if( values.containsKey("PMRPConstraintPeriodType") ) {
                final Object value = values.remove("PMRPConstraintPeriodType");
                if( (value == null) || (!value.equals(getPMRPConstraintPeriodType())) ) {
                    setPMRPConstraintPeriodType(((java.lang.String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductionLine") ) {
                final Object value = values.remove("ProductionLine");
                if( (value == null) || (!value.equals(getProductionLine())) ) {
                    setProductionLine(((java.lang.String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupplyingPlant") ) {
                final Object value = values.remove("SupplyingPlant");
                if( (value == null) || (!value.equals(getSupplyingPlant())) ) {
                    setSupplyingPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("PMRPConstraintBaseUnit") ) {
                final Object value = values.remove("PMRPConstraintBaseUnit");
                if( (value == null) || (!value.equals(getPMRPConstraintBaseUnit())) ) {
                    setPMRPConstraintBaseUnit(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_Period") ) {
                final Object value = (values).remove("_Period");
                if( value instanceof Iterable ) {
                    if( to_Period == null ) {
                        to_Period = Lists.newArrayList();
                    } else {
                        to_Period = Lists.newArrayList(to_Period);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        Period entity;
                        if( to_Period.size() > i ) {
                            entity = to_Period.get(i);
                        } else {
                            entity = new Period();
                            to_Period.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_Product") ) {
                final Object value = (values).remove("_Product");
                if( value instanceof Iterable ) {
                    if( to_Product == null ) {
                        to_Product = Lists.newArrayList();
                    } else {
                        to_Product = Lists.newArrayList(to_Product);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConstraintProduct entity;
                        if( to_Product.size() > i ) {
                            entity = to_Product.get(i);
                        } else {
                            entity = new ConstraintProduct();
                            to_Product.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_Text") ) {
                final Object value = (values).remove("_Text");
                if( value instanceof Iterable ) {
                    if( to_Text == null ) {
                        to_Text = Lists.newArrayList();
                    } else {
                        to_Text = Lists.newArrayList(to_Text);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        Text entity;
                        if( to_Text.size() > i ) {
                            entity = to_Text.get(i);
                        } else {
                            entity = new Text();
                            to_Text.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MaintainFlexibleConstraintsForPredictiveMaterialAndResourcePlanningService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_Period != null ) {
            (values).put("_Period", to_Period);
        }
        if( to_Product != null ) {
            (values).put("_Product", to_Product);
        }
        if( to_Text != null ) {
            (values).put("_Text", to_Text);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>Period</b> entities (one to many). This corresponds to the OData navigation property
     * <b>_Period</b>.
     * <p>
     * If the navigation property for an entity <b>PMRPFlexibleConstraint</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Period</b> is already loaded, the result will contain the
     *         <b>Period</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<Period>> getPeriodIfPresent()
    {
        return Option.of(to_Period);
    }

    /**
     * Overwrites the list of associated <b>Period</b> entities for the loaded navigation property <b>_Period</b>.
     * <p>
     * If the navigation property <b>_Period</b> of a queried <b>PMRPFlexibleConstraint</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>Period</b> entities.
     */
    public void setPeriod( @Nonnull final List<Period> value )
    {
        if( to_Period == null ) {
            to_Period = Lists.newArrayList();
        }
        to_Period.clear();
        to_Period.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>Period</b> entities. This corresponds to the OData navigation property
     * <b>_Period</b>.
     * <p>
     * If the navigation property <b>_Period</b> of a queried <b>PMRPFlexibleConstraint</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>Period</b> entities.
     */
    public void addPeriod( Period... entity )
    {
        if( to_Period == null ) {
            to_Period = Lists.newArrayList();
        }
        to_Period.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>ConstraintProduct</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_Product</b>.
     * <p>
     * If the navigation property for an entity <b>PMRPFlexibleConstraint</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Product</b> is already loaded, the result will contain the
     *         <b>ConstraintProduct</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<ConstraintProduct>> getProductIfPresent()
    {
        return Option.of(to_Product);
    }

    /**
     * Overwrites the list of associated <b>ConstraintProduct</b> entities for the loaded navigation property
     * <b>_Product</b>.
     * <p>
     * If the navigation property <b>_Product</b> of a queried <b>PMRPFlexibleConstraint</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>ConstraintProduct</b> entities.
     */
    public void setProduct( @Nonnull final List<ConstraintProduct> value )
    {
        if( to_Product == null ) {
            to_Product = Lists.newArrayList();
        }
        to_Product.clear();
        to_Product.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConstraintProduct</b> entities. This corresponds to the OData
     * navigation property <b>_Product</b>.
     * <p>
     * If the navigation property <b>_Product</b> of a queried <b>PMRPFlexibleConstraint</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>ConstraintProduct</b> entities.
     */
    public void addProduct( ConstraintProduct... entity )
    {
        if( to_Product == null ) {
            to_Product = Lists.newArrayList();
        }
        to_Product.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>Text</b> entities (one to many). This corresponds to the OData navigation property
     * <b>_Text</b>.
     * <p>
     * If the navigation property for an entity <b>PMRPFlexibleConstraint</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Text</b> is already loaded, the result will contain the
     *         <b>Text</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<Text>> getTextIfPresent()
    {
        return Option.of(to_Text);
    }

    /**
     * Overwrites the list of associated <b>Text</b> entities for the loaded navigation property <b>_Text</b>.
     * <p>
     * If the navigation property <b>_Text</b> of a queried <b>PMRPFlexibleConstraint</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>Text</b> entities.
     */
    public void setText( @Nonnull final List<Text> value )
    {
        if( to_Text == null ) {
            to_Text = Lists.newArrayList();
        }
        to_Text.clear();
        to_Text.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>Text</b> entities. This corresponds to the OData navigation property
     * <b>_Text</b>.
     * <p>
     * If the navigation property <b>_Text</b> of a queried <b>PMRPFlexibleConstraint</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>Text</b> entities.
     */
    public void addText( Text... entity )
    {
        if( to_Text == null ) {
            to_Text = Lists.newArrayList();
        }
        to_Text.addAll(Lists.newArrayList(entity));
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param pMRPConstraintBaseUnit
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PMRPConstraintBaseUnit</b>
     *            </p>
     * @param pMRPConstraintQtyInBaseUnit
     *            Constraints: Not nullable, Precision: 13, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PMRPConstraintQtyInBaseUnit</b>
     *            </p>
     * @param pMRPFlxblCstrtPerdStrtDte
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PMRPFlxblCstrtPerdStrtDte</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<PMRPFlexibleConstraint, Period>
        definePeriodForDate(
            @Nonnull final LocalDate pMRPFlxblCstrtPerdStrtDte,
            @Nonnull final java.lang.String pMRPConstraintBaseUnit,
            @Nonnull final BigDecimal pMRPConstraintQtyInBaseUnit )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("PMRPFlxblCstrtPerdStrtDte", pMRPFlxblCstrtPerdStrtDte);
        parameters.put("PMRPConstraintBaseUnit", pMRPConstraintBaseUnit);
        parameters.put("PMRPConstraintQtyInBaseUnit", pMRPConstraintQtyInBaseUnit);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<PMRPFlexibleConstraint, Period>(
            PMRPFlexibleConstraint.class,
            Period.class,
            "com.sap.gateway.srvd_a2x.api_pmrpflexibleconstraint.v0001.DefinePeriodForDate",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of PMRPFlexibleConstraint instances.
     * 
     */
    public final static class PMRPFlexibleConstraintBuilder
    {

        private List<Period> to_Period = Lists.newArrayList();
        private List<ConstraintProduct> to_Product = Lists.newArrayList();
        private java.lang.String product = null;
        private List<Text> to_Text = Lists.newArrayList();

        private PMRPFlexibleConstraint.PMRPFlexibleConstraintBuilder to_Period( final List<Period> value )
        {
            to_Period.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_Period</b> for <b>PMRPFlexibleConstraint</b> to multiple <b>Period</b>.
         * 
         * @param value
         *            The Periods to build this PMRPFlexibleConstraint with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PMRPFlexibleConstraint.PMRPFlexibleConstraintBuilder period( Period... value )
        {
            return to_Period(Lists.newArrayList(value));
        }

        private PMRPFlexibleConstraint.PMRPFlexibleConstraintBuilder to_Product( final List<ConstraintProduct> value )
        {
            to_Product.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_Product</b> for <b>PMRPFlexibleConstraint</b> to multiple <b>ConstraintProduct</b>.
         * 
         * @param value
         *            The ConstraintProducts to build this PMRPFlexibleConstraint with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PMRPFlexibleConstraint.PMRPFlexibleConstraintBuilder product( ConstraintProduct... value )
        {
            return to_Product(Lists.newArrayList(value));
        }

        /**
         * Constraints: Not nullable, Maximum length: 18
         * <p>
         * Original property name from the Odata EDM: <b>Product</b>
         * </p>
         * 
         * @param value
         *            The product to build this PMRPFlexibleConstraint with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PMRPFlexibleConstraint.PMRPFlexibleConstraintBuilder product( final java.lang.String value )
        {
            product = value;
            return this;
        }

        private PMRPFlexibleConstraint.PMRPFlexibleConstraintBuilder to_Text( final List<Text> value )
        {
            to_Text.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_Text</b> for <b>PMRPFlexibleConstraint</b> to multiple <b>Text</b>.
         * 
         * @param value
         *            The Texts to build this PMRPFlexibleConstraint with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PMRPFlexibleConstraint.PMRPFlexibleConstraintBuilder text( Text... value )
        {
            return to_Text(Lists.newArrayList(value));
        }

    }

}
