/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintainflexibleconstraintsforpredictivematerialandresourceplanning;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MaintainFlexibleConstraintsForPredictiveMaterialAndResourcePlanningService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Flexible Constraint Period
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PeriodType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class Period extends VdmEntity<Period> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_pmrpflexibleconstraint.v0001.PeriodType";
    /**
     * Selector for all available fields of Period.
     * 
     */
    public final static SimpleProperty<Period> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlexibleConstraint</b>
     * </p>
     * 
     * @return pMRP Unique ID for Flexible Constraints
     */
    @Nullable
    @ElementName( "PMRPFlexibleConstraint" )
    private java.lang.String pMRPFlexibleConstraint;
    public final static SimpleProperty.String<Period> PMRP_FLEXIBLE_CONSTRAINT =
        new SimpleProperty.String<Period>(Period.class, "PMRPFlexibleConstraint");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BucketInternalID</b>
     * </p>
     * 
     * @return pMRP Evaluation Bucket ID
     */
    @Nullable
    @ElementName( "BucketInternalID" )
    private Integer bucketInternalID;
    public final static SimpleProperty.NumericInteger<Period> BUCKET_INTERNAL_ID =
        new SimpleProperty.NumericInteger<Period>(Period.class, "BucketInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintBaseUnit</b>
     * </p>
     * 
     * @return pMRP: Base UoM for Flexible Constraints
     */
    @Nullable
    @ElementName( "PMRPConstraintBaseUnit" )
    private java.lang.String pMRPConstraintBaseUnit;
    public final static SimpleProperty.String<Period> PMRP_CONSTRAINT_BASE_UNIT =
        new SimpleProperty.String<Period>(Period.class, "PMRPConstraintBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintQtyInBaseUnit</b>
     * </p>
     * 
     * @return The pMRPConstraintQtyInBaseUnit contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "PMRPConstraintQtyInBaseUnit" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal pMRPConstraintQtyInBaseUnit;
    public final static SimpleProperty.NumericDecimal<Period> PMRP_CONSTRAINT_QTY_IN_BASE_UNIT =
        new SimpleProperty.NumericDecimal<Period>(Period.class, "PMRPConstraintQtyInBaseUnit");
    /**
     * Navigation property <b>_Constraint</b> for <b>Period</b> to single <b>PMRPFlexibleConstraint</b>.
     * 
     */
    @ElementName( "_Constraint" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PMRPFlexibleConstraint to_Constraint;
    /**
     * Use with available request builders to apply the <b>_Constraint</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<Period, PMRPFlexibleConstraint> TO__CONSTRAINT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<Period, PMRPFlexibleConstraint>(
            Period.class,
            "_Constraint",
            PMRPFlexibleConstraint.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<Period> getType()
    {
        return Period.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlexibleConstraint</b>
     * </p>
     * 
     * @param pMRPFlexibleConstraint
     *            pMRP Unique ID for Flexible Constraints
     */
    public void setPMRPFlexibleConstraint( @Nullable final java.lang.String pMRPFlexibleConstraint )
    {
        rememberChangedField("PMRPFlexibleConstraint", this.pMRPFlexibleConstraint);
        this.pMRPFlexibleConstraint = pMRPFlexibleConstraint;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BucketInternalID</b>
     * </p>
     * 
     * @param bucketInternalID
     *            pMRP Evaluation Bucket ID
     */
    public void setBucketInternalID( @Nullable final Integer bucketInternalID )
    {
        rememberChangedField("BucketInternalID", this.bucketInternalID);
        this.bucketInternalID = bucketInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintBaseUnit</b>
     * </p>
     * 
     * @param pMRPConstraintBaseUnit
     *            pMRP: Base UoM for Flexible Constraints
     */
    public void setPMRPConstraintBaseUnit( @Nullable final java.lang.String pMRPConstraintBaseUnit )
    {
        rememberChangedField("PMRPConstraintBaseUnit", this.pMRPConstraintBaseUnit);
        this.pMRPConstraintBaseUnit = pMRPConstraintBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintQtyInBaseUnit</b>
     * </p>
     * 
     * @param pMRPConstraintQtyInBaseUnit
     *            The pMRPConstraintQtyInBaseUnit to set.
     */
    public void setPMRPConstraintQtyInBaseUnit( @Nullable final BigDecimal pMRPConstraintQtyInBaseUnit )
    {
        rememberChangedField("PMRPConstraintQtyInBaseUnit", this.pMRPConstraintQtyInBaseUnit);
        this.pMRPConstraintQtyInBaseUnit = pMRPConstraintQtyInBaseUnit;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "Period";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("PMRPFlexibleConstraint", getPMRPFlexibleConstraint());
        entityKey.addKeyProperty("BucketInternalID", getBucketInternalID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("PMRPFlexibleConstraint", getPMRPFlexibleConstraint());
        values.put("BucketInternalID", getBucketInternalID());
        values.put("PMRPConstraintBaseUnit", getPMRPConstraintBaseUnit());
        values.put("PMRPConstraintQtyInBaseUnit", getPMRPConstraintQtyInBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PMRPFlexibleConstraint") ) {
                final Object value = values.remove("PMRPFlexibleConstraint");
                if( (value == null) || (!value.equals(getPMRPFlexibleConstraint())) ) {
                    setPMRPFlexibleConstraint(((java.lang.String) value));
                }
            }
            if( values.containsKey("BucketInternalID") ) {
                final Object value = values.remove("BucketInternalID");
                if( (value == null) || (!value.equals(getBucketInternalID())) ) {
                    setBucketInternalID(((Integer) value));
                }
            }
            if( values.containsKey("PMRPConstraintBaseUnit") ) {
                final Object value = values.remove("PMRPConstraintBaseUnit");
                if( (value == null) || (!value.equals(getPMRPConstraintBaseUnit())) ) {
                    setPMRPConstraintBaseUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("PMRPConstraintQtyInBaseUnit") ) {
                final Object value = values.remove("PMRPConstraintQtyInBaseUnit");
                if( (value == null) || (!value.equals(getPMRPConstraintQtyInBaseUnit())) ) {
                    setPMRPConstraintQtyInBaseUnit(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_Constraint") ) {
                final Object value = (values).remove("_Constraint");
                if( value instanceof Map ) {
                    if( to_Constraint == null ) {
                        to_Constraint = new PMRPFlexibleConstraint();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_Constraint.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MaintainFlexibleConstraintsForPredictiveMaterialAndResourcePlanningService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_Constraint != null ) {
            (values).put("_Constraint", to_Constraint);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>PMRPFlexibleConstraint</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_Constraint</b>.
     * <p>
     * If the navigation property for an entity <b>Period</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Constraint</b> is already loaded, the result will contain
     *         the <b>PMRPFlexibleConstraint</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PMRPFlexibleConstraint> getConstraintIfPresent()
    {
        return Option.of(to_Constraint);
    }

    /**
     * Overwrites the associated <b>PMRPFlexibleConstraint</b> entity for the loaded navigation property
     * <b>_Constraint</b>.
     * 
     * @param value
     *            New <b>PMRPFlexibleConstraint</b> entity.
     */
    public void setConstraint( final PMRPFlexibleConstraint value )
    {
        to_Constraint = value;
    }

    /**
     * Helper class to allow for fluent creation of Period instances.
     * 
     */
    public final static class PeriodBuilder
    {

        private PMRPFlexibleConstraint to_Constraint;

        private Period.PeriodBuilder to_Constraint( final PMRPFlexibleConstraint value )
        {
            to_Constraint = value;
            return this;
        }

        /**
         * Navigation property <b>_Constraint</b> for <b>Period</b> to single <b>PMRPFlexibleConstraint</b>.
         * 
         * @param value
         *            The PMRPFlexibleConstraint to build this Period with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Period.PeriodBuilder constraint( final PMRPFlexibleConstraint value )
        {
            return to_Constraint(value);
        }

    }

}
