/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintainflexibleconstraintsforpredictivematerialandresourceplanning;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmComplex;
import com.sap.cloud.sdk.result.ElementName;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>SAP__Message</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SAP__Message extends VdmComplex<SAP__Message>
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_pmrpflexibleconstraint.v0001.SAP__Message";
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>code</b>
     * </p>
     * 
     * @return The code contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "code" )
    private java.lang.String code;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<SAP__Message> CODE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<SAP__Message>(SAP__Message.class, "code");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>message</b>
     * </p>
     * 
     * @return The message contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "message" )
    private java.lang.String message;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<SAP__Message> MESSAGE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<SAP__Message>(SAP__Message.class, "message");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>longtextUrl</b>
     * </p>
     * 
     * @return The longtextUrl contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "longtextUrl" )
    private java.lang.String longtextUrl;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<SAP__Message> LONGTEXT_URL =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<SAP__Message>(
            SAP__Message.class,
            "longtextUrl");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>numericSeverity</b>
     * </p>
     * 
     * @return The numericSeverity contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "numericSeverity" )
    private Short numericSeverity;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.NumericInteger<SAP__Message> NUMERIC_SEVERITY =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.NumericInteger<SAP__Message>(
            SAP__Message.class,
            "numericSeverity");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>target</b>
     * </p>
     * 
     * @return The target contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "target" )
    private java.lang.String target;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<SAP__Message> TARGET =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<SAP__Message>(SAP__Message.class, "target");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>transition</b>
     * </p>
     * 
     * @return The transition contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "transition" )
    private java.lang.Boolean transition;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Boolean<SAP__Message> TRANSITION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Boolean<SAP__Message>(
            SAP__Message.class,
            "transition");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SAP__Message> getType()
    {
        return SAP__Message.class;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("code", getCode());
        values.put("message", getMessage());
        values.put("longtextUrl", getLongtextUrl());
        values.put("numericSeverity", getNumericSeverity());
        values.put("target", getTarget());
        values.put("transition", getTransition());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("code") ) {
                final Object value = values.remove("code");
                if( (value == null) || (!value.equals(getCode())) ) {
                    setCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("message") ) {
                final Object value = values.remove("message");
                if( (value == null) || (!value.equals(getMessage())) ) {
                    setMessage(((java.lang.String) value));
                }
            }
            if( values.containsKey("longtextUrl") ) {
                final Object value = values.remove("longtextUrl");
                if( (value == null) || (!value.equals(getLongtextUrl())) ) {
                    setLongtextUrl(((java.lang.String) value));
                }
            }
            if( values.containsKey("numericSeverity") ) {
                final Object value = values.remove("numericSeverity");
                if( (value == null) || (!value.equals(getNumericSeverity())) ) {
                    setNumericSeverity(((Short) value));
                }
            }
            if( values.containsKey("target") ) {
                final Object value = values.remove("target");
                if( (value == null) || (!value.equals(getTarget())) ) {
                    setTarget(((java.lang.String) value));
                }
            }
            if( values.containsKey("transition") ) {
                final Object value = values.remove("transition");
                if( (value == null) || (!value.equals(getTransition())) ) {
                    setTransition(((java.lang.Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        return entityKey;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>code</b>
     * </p>
     * 
     * @param code
     *            The code to set.
     */
    public void setCode( @Nullable final java.lang.String code )
    {
        rememberChangedField("code", this.code);
        this.code = code;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>message</b>
     * </p>
     * 
     * @param message
     *            The message to set.
     */
    public void setMessage( @Nullable final java.lang.String message )
    {
        rememberChangedField("message", this.message);
        this.message = message;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>longtextUrl</b>
     * </p>
     * 
     * @param longtextUrl
     *            The longtextUrl to set.
     */
    public void setLongtextUrl( @Nullable final java.lang.String longtextUrl )
    {
        rememberChangedField("longtextUrl", this.longtextUrl);
        this.longtextUrl = longtextUrl;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>numericSeverity</b>
     * </p>
     * 
     * @param numericSeverity
     *            The numericSeverity to set.
     */
    public void setNumericSeverity( @Nullable final Short numericSeverity )
    {
        rememberChangedField("numericSeverity", this.numericSeverity);
        this.numericSeverity = numericSeverity;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>target</b>
     * </p>
     * 
     * @param target
     *            The target to set.
     */
    public void setTarget( @Nullable final java.lang.String target )
    {
        rememberChangedField("target", this.target);
        this.target = target;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>transition</b>
     * </p>
     * 
     * @param transition
     *            The transition to set.
     */
    public void setTransition( @Nullable final java.lang.Boolean transition )
    {
        rememberChangedField("transition", this.transition);
        this.transition = transition;
    }

}
