/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintainflexibleconstraintsforpredictivematerialandresourceplanning;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MaintainFlexibleConstraintsForPredictiveMaterialAndResourcePlanningService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Flexible Constraint Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class Text extends VdmEntity<Text> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_pmrpflexibleconstraint.v0001.TextType";
    /**
     * Selector for all available fields of Text.
     * 
     */
    public final static SimpleProperty<Text> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlexibleConstraint</b>
     * </p>
     * 
     * @return pMRP Unique ID for Flexible Constraints
     */
    @Nullable
    @ElementName( "PMRPFlexibleConstraint" )
    private java.lang.String pMRPFlexibleConstraint;
    public final static SimpleProperty.String<Text> PMRP_FLEXIBLE_CONSTRAINT =
        new SimpleProperty.String<Text>(Text.class, "PMRPFlexibleConstraint");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<Text> LANGUAGE = new SimpleProperty.String<Text>(Text.class, "Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintText</b>
     * </p>
     * 
     * @return pMRP: Text for Flexible Constraints
     */
    @Nullable
    @ElementName( "PMRPConstraintText" )
    private java.lang.String pMRPConstraintText;
    public final static SimpleProperty.String<Text> PMRP_CONSTRAINT_TEXT =
        new SimpleProperty.String<Text>(Text.class, "PMRPConstraintText");
    /**
     * Navigation property <b>_Constraint</b> for <b>Text</b> to single <b>PMRPFlexibleConstraint</b>.
     * 
     */
    @ElementName( "_Constraint" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PMRPFlexibleConstraint to_Constraint;
    /**
     * Use with available request builders to apply the <b>_Constraint</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<Text, PMRPFlexibleConstraint> TO__CONSTRAINT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<Text, PMRPFlexibleConstraint>(
            Text.class,
            "_Constraint",
            PMRPFlexibleConstraint.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<Text> getType()
    {
        return Text.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PMRPFlexibleConstraint</b>
     * </p>
     * 
     * @param pMRPFlexibleConstraint
     *            pMRP Unique ID for Flexible Constraints
     */
    public void setPMRPFlexibleConstraint( @Nullable final java.lang.String pMRPFlexibleConstraint )
    {
        rememberChangedField("PMRPFlexibleConstraint", this.pMRPFlexibleConstraint);
        this.pMRPFlexibleConstraint = pMRPFlexibleConstraint;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PMRPConstraintText</b>
     * </p>
     * 
     * @param pMRPConstraintText
     *            pMRP: Text for Flexible Constraints
     */
    public void setPMRPConstraintText( @Nullable final java.lang.String pMRPConstraintText )
    {
        rememberChangedField("PMRPConstraintText", this.pMRPConstraintText);
        this.pMRPConstraintText = pMRPConstraintText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "Text";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("PMRPFlexibleConstraint", getPMRPFlexibleConstraint());
        entityKey.addKeyProperty("Language", getLanguage());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("PMRPFlexibleConstraint", getPMRPFlexibleConstraint());
        values.put("Language", getLanguage());
        values.put("PMRPConstraintText", getPMRPConstraintText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PMRPFlexibleConstraint") ) {
                final Object value = values.remove("PMRPFlexibleConstraint");
                if( (value == null) || (!value.equals(getPMRPFlexibleConstraint())) ) {
                    setPMRPFlexibleConstraint(((java.lang.String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("PMRPConstraintText") ) {
                final Object value = values.remove("PMRPConstraintText");
                if( (value == null) || (!value.equals(getPMRPConstraintText())) ) {
                    setPMRPConstraintText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_Constraint") ) {
                final Object value = (values).remove("_Constraint");
                if( value instanceof Map ) {
                    if( to_Constraint == null ) {
                        to_Constraint = new PMRPFlexibleConstraint();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_Constraint.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MaintainFlexibleConstraintsForPredictiveMaterialAndResourcePlanningService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_Constraint != null ) {
            (values).put("_Constraint", to_Constraint);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>PMRPFlexibleConstraint</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_Constraint</b>.
     * <p>
     * If the navigation property for an entity <b>Text</b> has not been resolved yet, this method will <b>not query</b>
     * further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Constraint</b> is already loaded, the result will contain
     *         the <b>PMRPFlexibleConstraint</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PMRPFlexibleConstraint> getConstraintIfPresent()
    {
        return Option.of(to_Constraint);
    }

    /**
     * Overwrites the associated <b>PMRPFlexibleConstraint</b> entity for the loaded navigation property
     * <b>_Constraint</b>.
     * 
     * @param value
     *            New <b>PMRPFlexibleConstraint</b> entity.
     */
    public void setConstraint( final PMRPFlexibleConstraint value )
    {
        to_Constraint = value;
    }

    /**
     * Helper class to allow for fluent creation of Text instances.
     * 
     */
    public final static class TextBuilder
    {

        private PMRPFlexibleConstraint to_Constraint;

        private Text.TextBuilder to_Constraint( final PMRPFlexibleConstraint value )
        {
            to_Constraint = value;
            return this;
        }

        /**
         * Navigation property <b>_Constraint</b> for <b>Text</b> to single <b>PMRPFlexibleConstraint</b>.
         * 
         * @param value
         *            The PMRPFlexibleConstraint to build this Text with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Text.TextBuilder constraint( final PMRPFlexibleConstraint value )
        {
            return to_Constraint(value);
        }

    }

}
