/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MaintenanceTasklistService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceTaskListType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MaintenanceTaskList extends VdmEntity<MaintenanceTaskList> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_maintenancetasklist.v0001.MaintenanceTaskListType";
    /**
     * Selector for all available fields of MaintenanceTaskList.
     * 
     */
    public final static SimpleProperty<MaintenanceTaskList> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @return Task List Type
     */
    @Nullable
    @ElementName( "TaskListType" )
    private java.lang.String taskListType;
    public final static SimpleProperty.String<MaintenanceTaskList> TASK_LIST_TYPE =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "TaskListType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @return Key for Task List Group
     */
    @Nullable
    @ElementName( "TaskListGroup" )
    private java.lang.String taskListGroup;
    public final static SimpleProperty.String<MaintenanceTaskList> TASK_LIST_GROUP =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "TaskListGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @return Group Counter
     */
    @Nullable
    @ElementName( "TaskListGroupCounter" )
    private java.lang.String taskListGroupCounter;
    public final static SimpleProperty.String<MaintenanceTaskList> TASK_LIST_GROUP_COUNTER =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "TaskListGroupCounter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListVersionCounter</b>
     * </p>
     * 
     * @return Internal counter
     */
    @Nullable
    @ElementName( "TaskListVersionCounter" )
    private java.lang.String taskListVersionCounter;
    public final static SimpleProperty.String<MaintenanceTaskList> TASK_LIST_VERSION_COUNTER =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "TaskListVersionCounter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanningPlant</b>
     * </p>
     * 
     * @return Maintenance Planning Plant
     */
    @Nullable
    @ElementName( "MaintenancePlanningPlant" )
    private java.lang.String maintenancePlanningPlant;
    public final static SimpleProperty.String<MaintenanceTaskList> MAINTENANCE_PLANNING_PLANT =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "MaintenancePlanningPlant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaskListStatus</b>
     * </p>
     * 
     * @return Status
     */
    @Nullable
    @ElementName( "TaskListStatus" )
    private java.lang.String taskListStatus;
    public final static SimpleProperty.String<MaintenanceTaskList> TASK_LIST_STATUS =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "TaskListStatus");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TaskListStatusDesc</b>
     * </p>
     * 
     * @return Description of the Status
     */
    @Nullable
    @ElementName( "TaskListStatusDesc" )
    private java.lang.String taskListStatusDesc;
    public final static SimpleProperty.String<MaintenanceTaskList> TASK_LIST_STATUS_DESC =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "TaskListStatusDesc");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObject</b>
     * </p>
     * 
     * @return Technical Object
     */
    @Nullable
    @ElementName( "TechnicalObject" )
    private java.lang.String technicalObject;
    public final static SimpleProperty.String<MaintenanceTaskList> TECHNICAL_OBJECT =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "TechnicalObject");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaskListUsage</b>
     * </p>
     * 
     * @return Task List Usage
     */
    @Nullable
    @ElementName( "TaskListUsage" )
    private java.lang.String taskListUsage;
    public final static SimpleProperty.String<MaintenanceTaskList> TASK_LIST_USAGE =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "TaskListUsage");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TaskListDesc</b>
     * </p>
     * 
     * @return Routing Description
     */
    @Nullable
    @ElementName( "TaskListDesc" )
    private java.lang.String taskListDesc;
    public final static SimpleProperty.String<MaintenanceTaskList> TASK_LIST_DESC =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "TaskListDesc");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     * 
     * @return Work Center
     */
    @Nullable
    @ElementName( "WorkCenter" )
    private java.lang.String workCenter;
    public final static SimpleProperty.String<MaintenanceTaskList> WORK_CENTER =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStrategy</b>
     * </p>
     * 
     * @return Maintenance Strategy
     */
    @Nullable
    @ElementName( "MaintenanceStrategy" )
    private java.lang.String maintenanceStrategy;
    public final static SimpleProperty.String<MaintenanceTaskList> MAINTENANCE_STRATEGY =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "MaintenanceStrategy");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationSystemCondition</b>
     * </p>
     * 
     * @return System Condition
     */
    @Nullable
    @ElementName( "OperationSystemCondition" )
    private java.lang.String operationSystemCondition;
    public final static SimpleProperty.String<MaintenanceTaskList> OPERATION_SYSTEM_CONDITION =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "OperationSystemCondition");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     * 
     * @return Assembly
     */
    @Nullable
    @ElementName( "Assembly" )
    private java.lang.String assembly;
    public final static SimpleProperty.String<MaintenanceTaskList> ASSEMBLY =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "Assembly");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     * 
     * @return Change Number
     */
    @Nullable
    @ElementName( "ChangeNumber" )
    private java.lang.String changeNumber;
    public final static SimpleProperty.String<MaintenanceTaskList> CHANGE_NUMBER =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "ChangeNumber");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Valid-From Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<MaintenanceTaskList> VALIDITY_START_DATE =
        new SimpleProperty.Date<MaintenanceTaskList>(MaintenanceTaskList.class, "ValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Valid-To Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<MaintenanceTaskList> VALIDITY_END_DATE =
        new SimpleProperty.Date<MaintenanceTaskList>(MaintenanceTaskList.class, "ValidityEndDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     * 
     * @return Indicator: Delete completely in reorganization run
     */
    @Nullable
    @ElementName( "IsMarkedForDeletion" )
    private java.lang.Boolean isMarkedForDeletion;
    public final static SimpleProperty.Boolean<MaintenanceTaskList> IS_MARKED_FOR_DELETION =
        new SimpleProperty.Boolean<MaintenanceTaskList>(MaintenanceTaskList.class, "IsMarkedForDeletion");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     * 
     * @return Date of the last change made to the task list
     */
    @Nullable
    @ElementName( "LastChangeDate" )
    private LocalDate lastChangeDate;
    public final static SimpleProperty.Date<MaintenanceTaskList> LAST_CHANGE_DATE =
        new SimpleProperty.Date<MaintenanceTaskList>(MaintenanceTaskList.class, "LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Last Changed By User
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<MaintenanceTaskList> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Created By User
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<MaintenanceTaskList> CREATED_BY_USER =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "CreatedByUser");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return Date Record Created On
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<MaintenanceTaskList> CREATION_DATE =
        new SimpleProperty.Date<MaintenanceTaskList>(MaintenanceTaskList.class, "CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<MaintenanceTaskList> PLANT =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "Plant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePlannerGroup</b>
     * </p>
     * 
     * @return Responsible Planner Group or Department
     */
    @Nullable
    @ElementName( "ResponsiblePlannerGroup" )
    private java.lang.String responsiblePlannerGroup;
    public final static SimpleProperty.String<MaintenanceTaskList> RESPONSIBLE_PLANNER_GROUP =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "ResponsiblePlannerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     * 
     * @return Equipment Number
     */
    @Nullable
    @ElementName( "Equipment" )
    private java.lang.String equipment;
    public final static SimpleProperty.String<MaintenanceTaskList> EQUIPMENT =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     * 
     * @return Functional Location Label
     */
    @Nullable
    @ElementName( "FunctionalLocationLabelName" )
    private java.lang.String functionalLocationLabelName;
    public final static SimpleProperty.String<MaintenanceTaskList> FUNCTIONAL_LOCATION_LABEL_NAME =
        new SimpleProperty.String<MaintenanceTaskList>(MaintenanceTaskList.class, "FunctionalLocationLabelName");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TaskListIsHierarchical</b>
     * </p>
     * 
     * @return Sign: Task List Contains Hierarchical Operations
     */
    @Nullable
    @ElementName( "TaskListIsHierarchical" )
    private java.lang.Boolean taskListIsHierarchical;
    public final static SimpleProperty.Boolean<MaintenanceTaskList> TASK_LIST_IS_HIERARCHICAL =
        new SimpleProperty.Boolean<MaintenanceTaskList>(MaintenanceTaskList.class, "TaskListIsHierarchical");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskList, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskList, SAP__Message>(
            MaintenanceTaskList.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_LongText</b> for <b>MaintenanceTaskList</b> to single <b>MaintenanceTaskListLongText</b>.
     * 
     */
    @ElementName( "_LongText" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceTaskListLongText to_LongText;
    /**
     * Navigation property <b>_MaintPackage</b> for <b>MaintenanceTaskList</b> to multiple
     * <b>MaintenanceTaskListStrtgyPckg</b>.
     * 
     */
    @ElementName( "_MaintPackage" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceTaskListStrtgyPckg> to_MaintPackage;
    /**
     * Navigation property <b>_Operation</b> for <b>MaintenanceTaskList</b> to multiple
     * <b>MaintenanceTaskListOperation</b>.
     * 
     */
    @ElementName( "_Operation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceTaskListOperation> to_Operation;
    /**
     * Use with available request builders to apply the <b>_LongText</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MaintenanceTaskList, MaintenanceTaskListLongText> TO__LONG_TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MaintenanceTaskList, MaintenanceTaskListLongText>(
            MaintenanceTaskList.class,
            "_LongText",
            MaintenanceTaskListLongText.class);
    /**
     * Use with available request builders to apply the <b>_MaintPackage</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MaintenanceTaskList, MaintenanceTaskListStrtgyPckg> TO__MAINT_PACKAGE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MaintenanceTaskList, MaintenanceTaskListStrtgyPckg>(
            MaintenanceTaskList.class,
            "_MaintPackage",
            MaintenanceTaskListStrtgyPckg.class);
    /**
     * Use with available request builders to apply the <b>_Operation</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MaintenanceTaskList, MaintenanceTaskListOperation> TO__OPERATION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MaintenanceTaskList, MaintenanceTaskListOperation>(
            MaintenanceTaskList.class,
            "_Operation",
            MaintenanceTaskListOperation.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MaintenanceTaskList> getType()
    {
        return MaintenanceTaskList.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @param taskListType
     *            Task List Type
     */
    public void setTaskListType( @Nullable final java.lang.String taskListType )
    {
        rememberChangedField("TaskListType", this.taskListType);
        this.taskListType = taskListType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @param taskListGroup
     *            Key for Task List Group
     */
    public void setTaskListGroup( @Nullable final java.lang.String taskListGroup )
    {
        rememberChangedField("TaskListGroup", this.taskListGroup);
        this.taskListGroup = taskListGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @param taskListGroupCounter
     *            Group Counter
     */
    public void setTaskListGroupCounter( @Nullable final java.lang.String taskListGroupCounter )
    {
        rememberChangedField("TaskListGroupCounter", this.taskListGroupCounter);
        this.taskListGroupCounter = taskListGroupCounter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListVersionCounter</b>
     * </p>
     * 
     * @param taskListVersionCounter
     *            Internal counter
     */
    public void setTaskListVersionCounter( @Nullable final java.lang.String taskListVersionCounter )
    {
        rememberChangedField("TaskListVersionCounter", this.taskListVersionCounter);
        this.taskListVersionCounter = taskListVersionCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanningPlant</b>
     * </p>
     * 
     * @param maintenancePlanningPlant
     *            Maintenance Planning Plant
     */
    public void setMaintenancePlanningPlant( @Nullable final java.lang.String maintenancePlanningPlant )
    {
        rememberChangedField("MaintenancePlanningPlant", this.maintenancePlanningPlant);
        this.maintenancePlanningPlant = maintenancePlanningPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaskListStatus</b>
     * </p>
     * 
     * @param taskListStatus
     *            Status
     */
    public void setTaskListStatus( @Nullable final java.lang.String taskListStatus )
    {
        rememberChangedField("TaskListStatus", this.taskListStatus);
        this.taskListStatus = taskListStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TaskListStatusDesc</b>
     * </p>
     * 
     * @param taskListStatusDesc
     *            Description of the Status
     */
    public void setTaskListStatusDesc( @Nullable final java.lang.String taskListStatusDesc )
    {
        rememberChangedField("TaskListStatusDesc", this.taskListStatusDesc);
        this.taskListStatusDesc = taskListStatusDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObject</b>
     * </p>
     * 
     * @param technicalObject
     *            Technical Object
     */
    public void setTechnicalObject( @Nullable final java.lang.String technicalObject )
    {
        rememberChangedField("TechnicalObject", this.technicalObject);
        this.technicalObject = technicalObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaskListUsage</b>
     * </p>
     * 
     * @param taskListUsage
     *            Task List Usage
     */
    public void setTaskListUsage( @Nullable final java.lang.String taskListUsage )
    {
        rememberChangedField("TaskListUsage", this.taskListUsage);
        this.taskListUsage = taskListUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TaskListDesc</b>
     * </p>
     * 
     * @param taskListDesc
     *            Routing Description
     */
    public void setTaskListDesc( @Nullable final java.lang.String taskListDesc )
    {
        rememberChangedField("TaskListDesc", this.taskListDesc);
        this.taskListDesc = taskListDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     * 
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final java.lang.String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStrategy</b>
     * </p>
     * 
     * @param maintenanceStrategy
     *            Maintenance Strategy
     */
    public void setMaintenanceStrategy( @Nullable final java.lang.String maintenanceStrategy )
    {
        rememberChangedField("MaintenanceStrategy", this.maintenanceStrategy);
        this.maintenanceStrategy = maintenanceStrategy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationSystemCondition</b>
     * </p>
     * 
     * @param operationSystemCondition
     *            System Condition
     */
    public void setOperationSystemCondition( @Nullable final java.lang.String operationSystemCondition )
    {
        rememberChangedField("OperationSystemCondition", this.operationSystemCondition);
        this.operationSystemCondition = operationSystemCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     * 
     * @param assembly
     *            Assembly
     */
    public void setAssembly( @Nullable final java.lang.String assembly )
    {
        rememberChangedField("Assembly", this.assembly);
        this.assembly = assembly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     * 
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final java.lang.String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     * 
     * @param isMarkedForDeletion
     *            Indicator: Delete completely in reorganization run
     */
    public void setIsMarkedForDeletion( @Nullable final java.lang.Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     * 
     * @param lastChangeDate
     *            Date of the last change made to the task list
     */
    public void setLastChangeDate( @Nullable final LocalDate lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            Date Record Created On
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePlannerGroup</b>
     * </p>
     * 
     * @param responsiblePlannerGroup
     *            Responsible Planner Group or Department
     */
    public void setResponsiblePlannerGroup( @Nullable final java.lang.String responsiblePlannerGroup )
    {
        rememberChangedField("ResponsiblePlannerGroup", this.responsiblePlannerGroup);
        this.responsiblePlannerGroup = responsiblePlannerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     * 
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final java.lang.String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     * 
     * @param functionalLocationLabelName
     *            Functional Location Label
     */
    public void setFunctionalLocationLabelName( @Nullable final java.lang.String functionalLocationLabelName )
    {
        rememberChangedField("FunctionalLocationLabelName", this.functionalLocationLabelName);
        this.functionalLocationLabelName = functionalLocationLabelName;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TaskListIsHierarchical</b>
     * </p>
     * 
     * @param taskListIsHierarchical
     *            Sign: Task List Contains Hierarchical Operations
     */
    public void setTaskListIsHierarchical( @Nullable final java.lang.Boolean taskListIsHierarchical )
    {
        rememberChangedField("TaskListIsHierarchical", this.taskListIsHierarchical);
        this.taskListIsHierarchical = taskListIsHierarchical;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MaintenanceTaskList";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("TaskListType", getTaskListType());
        entityKey.addKeyProperty("TaskListGroup", getTaskListGroup());
        entityKey.addKeyProperty("TaskListGroupCounter", getTaskListGroupCounter());
        entityKey.addKeyProperty("TaskListVersionCounter", getTaskListVersionCounter());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("TaskListType", getTaskListType());
        values.put("TaskListGroup", getTaskListGroup());
        values.put("TaskListGroupCounter", getTaskListGroupCounter());
        values.put("TaskListVersionCounter", getTaskListVersionCounter());
        values.put("MaintenancePlanningPlant", getMaintenancePlanningPlant());
        values.put("TaskListStatus", getTaskListStatus());
        values.put("TaskListStatusDesc", getTaskListStatusDesc());
        values.put("TechnicalObject", getTechnicalObject());
        values.put("TaskListUsage", getTaskListUsage());
        values.put("TaskListDesc", getTaskListDesc());
        values.put("WorkCenter", getWorkCenter());
        values.put("MaintenanceStrategy", getMaintenanceStrategy());
        values.put("OperationSystemCondition", getOperationSystemCondition());
        values.put("Assembly", getAssembly());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("Plant", getPlant());
        values.put("ResponsiblePlannerGroup", getResponsiblePlannerGroup());
        values.put("Equipment", getEquipment());
        values.put("FunctionalLocationLabelName", getFunctionalLocationLabelName());
        values.put("TaskListIsHierarchical", getTaskListIsHierarchical());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("TaskListType") ) {
                final Object value = values.remove("TaskListType");
                if( (value == null) || (!value.equals(getTaskListType())) ) {
                    setTaskListType(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroup") ) {
                final Object value = values.remove("TaskListGroup");
                if( (value == null) || (!value.equals(getTaskListGroup())) ) {
                    setTaskListGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroupCounter") ) {
                final Object value = values.remove("TaskListGroupCounter");
                if( (value == null) || (!value.equals(getTaskListGroupCounter())) ) {
                    setTaskListGroupCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListVersionCounter") ) {
                final Object value = values.remove("TaskListVersionCounter");
                if( (value == null) || (!value.equals(getTaskListVersionCounter())) ) {
                    setTaskListVersionCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenancePlanningPlant") ) {
                final Object value = values.remove("MaintenancePlanningPlant");
                if( (value == null) || (!value.equals(getMaintenancePlanningPlant())) ) {
                    setMaintenancePlanningPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListStatus") ) {
                final Object value = values.remove("TaskListStatus");
                if( (value == null) || (!value.equals(getTaskListStatus())) ) {
                    setTaskListStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListStatusDesc") ) {
                final Object value = values.remove("TaskListStatusDesc");
                if( (value == null) || (!value.equals(getTaskListStatusDesc())) ) {
                    setTaskListStatusDesc(((java.lang.String) value));
                }
            }
            if( values.containsKey("TechnicalObject") ) {
                final Object value = values.remove("TechnicalObject");
                if( (value == null) || (!value.equals(getTechnicalObject())) ) {
                    setTechnicalObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListUsage") ) {
                final Object value = values.remove("TaskListUsage");
                if( (value == null) || (!value.equals(getTaskListUsage())) ) {
                    setTaskListUsage(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListDesc") ) {
                final Object value = values.remove("TaskListDesc");
                if( (value == null) || (!value.equals(getTaskListDesc())) ) {
                    setTaskListDesc(((java.lang.String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenanceStrategy") ) {
                final Object value = values.remove("MaintenanceStrategy");
                if( (value == null) || (!value.equals(getMaintenanceStrategy())) ) {
                    setMaintenanceStrategy(((java.lang.String) value));
                }
            }
            if( values.containsKey("OperationSystemCondition") ) {
                final Object value = values.remove("OperationSystemCondition");
                if( (value == null) || (!value.equals(getOperationSystemCondition())) ) {
                    setOperationSystemCondition(((java.lang.String) value));
                }
            }
            if( values.containsKey("Assembly") ) {
                final Object value = values.remove("Assembly");
                if( (value == null) || (!value.equals(getAssembly())) ) {
                    setAssembly(((java.lang.String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDate) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("ResponsiblePlannerGroup") ) {
                final Object value = values.remove("ResponsiblePlannerGroup");
                if( (value == null) || (!value.equals(getResponsiblePlannerGroup())) ) {
                    setResponsiblePlannerGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((java.lang.String) value));
                }
            }
            if( values.containsKey("FunctionalLocationLabelName") ) {
                final Object value = values.remove("FunctionalLocationLabelName");
                if( (value == null) || (!value.equals(getFunctionalLocationLabelName())) ) {
                    setFunctionalLocationLabelName(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListIsHierarchical") ) {
                final Object value = values.remove("TaskListIsHierarchical");
                if( (value == null) || (!value.equals(getTaskListIsHierarchical())) ) {
                    setTaskListIsHierarchical(((java.lang.Boolean) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_LongText") ) {
                final Object value = (values).remove("_LongText");
                if( value instanceof Map ) {
                    if( to_LongText == null ) {
                        to_LongText = new MaintenanceTaskListLongText();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_LongText.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_MaintPackage") ) {
                final Object value = (values).remove("_MaintPackage");
                if( value instanceof Iterable ) {
                    if( to_MaintPackage == null ) {
                        to_MaintPackage = Lists.newArrayList();
                    } else {
                        to_MaintPackage = Lists.newArrayList(to_MaintPackage);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceTaskListStrtgyPckg entity;
                        if( to_MaintPackage.size() > i ) {
                            entity = to_MaintPackage.get(i);
                        } else {
                            entity = new MaintenanceTaskListStrtgyPckg();
                            to_MaintPackage.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_Operation") ) {
                final Object value = (values).remove("_Operation");
                if( value instanceof Iterable ) {
                    if( to_Operation == null ) {
                        to_Operation = Lists.newArrayList();
                    } else {
                        to_Operation = Lists.newArrayList(to_Operation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceTaskListOperation entity;
                        if( to_Operation.size() > i ) {
                            entity = to_Operation.get(i);
                        } else {
                            entity = new MaintenanceTaskListOperation();
                            to_Operation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MaintenanceTasklistService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_LongText != null ) {
            (values).put("_LongText", to_LongText);
        }
        if( to_MaintPackage != null ) {
            (values).put("_MaintPackage", to_MaintPackage);
        }
        if( to_Operation != null ) {
            (values).put("_Operation", to_Operation);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>MaintenanceTaskListLongText</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_LongText</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceTaskList</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_LongText</b> is already loaded, the result will contain
     *         the <b>MaintenanceTaskListLongText</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceTaskListLongText> getLongTextIfPresent()
    {
        return Option.of(to_LongText);
    }

    /**
     * Overwrites the associated <b>MaintenanceTaskListLongText</b> entity for the loaded navigation property
     * <b>_LongText</b>.
     * 
     * @param value
     *            New <b>MaintenanceTaskListLongText</b> entity.
     */
    public void setLongText( final MaintenanceTaskListLongText value )
    {
        to_LongText = value;
    }

    /**
     * Retrieval of associated <b>MaintenanceTaskListStrtgyPckg</b> entities (one to many). This corresponds to the
     * OData navigation property <b>_MaintPackage</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceTaskList</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_MaintPackage</b> is already loaded, the result will
     *         contain the <b>MaintenanceTaskListStrtgyPckg</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceTaskListStrtgyPckg>> getMaintPackageIfPresent()
    {
        return Option.of(to_MaintPackage);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceTaskListStrtgyPckg</b> entities for the loaded navigation
     * property <b>_MaintPackage</b>.
     * <p>
     * If the navigation property <b>_MaintPackage</b> of a queried <b>MaintenanceTaskList</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>MaintenanceTaskListStrtgyPckg</b> entities.
     */
    public void setMaintPackage( @Nonnull final List<MaintenanceTaskListStrtgyPckg> value )
    {
        if( to_MaintPackage == null ) {
            to_MaintPackage = Lists.newArrayList();
        }
        to_MaintPackage.clear();
        to_MaintPackage.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceTaskListStrtgyPckg</b> entities. This corresponds to the
     * OData navigation property <b>_MaintPackage</b>.
     * <p>
     * If the navigation property <b>_MaintPackage</b> of a queried <b>MaintenanceTaskList</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>MaintenanceTaskListStrtgyPckg</b> entities.
     */
    public void addMaintPackage( MaintenanceTaskListStrtgyPckg... entity )
    {
        if( to_MaintPackage == null ) {
            to_MaintPackage = Lists.newArrayList();
        }
        to_MaintPackage.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>MaintenanceTaskListOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_Operation</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceTaskList</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Operation</b> is already loaded, the result will contain
     *         the <b>MaintenanceTaskListOperation</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceTaskListOperation>> getOperationIfPresent()
    {
        return Option.of(to_Operation);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceTaskListOperation</b> entities for the loaded navigation property
     * <b>_Operation</b>.
     * <p>
     * If the navigation property <b>_Operation</b> of a queried <b>MaintenanceTaskList</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>MaintenanceTaskListOperation</b> entities.
     */
    public void setOperation( @Nonnull final List<MaintenanceTaskListOperation> value )
    {
        if( to_Operation == null ) {
            to_Operation = Lists.newArrayList();
        }
        to_Operation.clear();
        to_Operation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceTaskListOperation</b> entities. This corresponds to the
     * OData navigation property <b>_Operation</b>.
     * <p>
     * If the navigation property <b>_Operation</b> of a queried <b>MaintenanceTaskList</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>MaintenanceTaskListOperation</b> entities.
     */
    public void addOperation( MaintenanceTaskListOperation... entity )
    {
        if( to_Operation == null ) {
            to_Operation = Lists.newArrayList();
        }
        to_Operation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param maintTskListValidityStartDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintTskListValidityStartDate</b>
     *            </p>
     * @param relationshipCopyIsRequested
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RelationshipCopyIsRequested</b>
     *            </p>
     * @param documentCopyIsRequested
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentCopyIsRequested</b>
     *            </p>
     * @param descriptionCopyIsRequested
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DescriptionCopyIsRequested</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MaintenanceTaskList, MaintenanceTaskList>
        createWithReference(
            @Nonnull final java.lang.Boolean documentCopyIsRequested,
            @Nonnull final java.lang.Boolean relationshipCopyIsRequested,
            @Nonnull final java.lang.Boolean descriptionCopyIsRequested,
            @Nonnull final LocalDate maintTskListValidityStartDate )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("DocumentCopyIsRequested", documentCopyIsRequested);
        parameters.put("RelationshipCopyIsRequested", relationshipCopyIsRequested);
        parameters.put("DescriptionCopyIsRequested", descriptionCopyIsRequested);
        parameters.put("MaintTskListValidityStartDate", maintTskListValidityStartDate);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MaintenanceTaskList, MaintenanceTaskList>(
            MaintenanceTaskList.class,
            MaintenanceTaskList.class,
            "com.sap.gateway.srvd_a2x.api_maintenancetasklist.v0001.CreateWithReference",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceTaskList instances.
     * 
     */
    public final static class MaintenanceTaskListBuilder
    {

        private MaintenanceTaskListLongText to_LongText;
        private List<MaintenanceTaskListStrtgyPckg> to_MaintPackage = Lists.newArrayList();
        private List<MaintenanceTaskListOperation> to_Operation = Lists.newArrayList();

        private MaintenanceTaskList.MaintenanceTaskListBuilder to_LongText( final MaintenanceTaskListLongText value )
        {
            to_LongText = value;
            return this;
        }

        /**
         * Navigation property <b>_LongText</b> for <b>MaintenanceTaskList</b> to single
         * <b>MaintenanceTaskListLongText</b>.
         * 
         * @param value
         *            The MaintenanceTaskListLongText to build this MaintenanceTaskList with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceTaskList.MaintenanceTaskListBuilder longText( final MaintenanceTaskListLongText value )
        {
            return to_LongText(value);
        }

        private MaintenanceTaskList.MaintenanceTaskListBuilder to_MaintPackage(
            final List<MaintenanceTaskListStrtgyPckg> value )
        {
            to_MaintPackage.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_MaintPackage</b> for <b>MaintenanceTaskList</b> to multiple
         * <b>MaintenanceTaskListStrtgyPckg</b>.
         * 
         * @param value
         *            The MaintenanceTaskListStrtgyPckgs to build this MaintenanceTaskList with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceTaskList.MaintenanceTaskListBuilder maintPackage( MaintenanceTaskListStrtgyPckg... value )
        {
            return to_MaintPackage(Lists.newArrayList(value));
        }

        private MaintenanceTaskList.MaintenanceTaskListBuilder to_Operation(
            final List<MaintenanceTaskListOperation> value )
        {
            to_Operation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_Operation</b> for <b>MaintenanceTaskList</b> to multiple
         * <b>MaintenanceTaskListOperation</b>.
         * 
         * @param value
         *            The MaintenanceTaskListOperations to build this MaintenanceTaskList with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceTaskList.MaintenanceTaskListBuilder operation( MaintenanceTaskListOperation... value )
        {
            return to_Operation(Lists.newArrayList(value));
        }

    }

}
