/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist;

import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MaintenanceTasklistService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Operation Long Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceTaskListOpLongTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MaintenanceTaskListOpLongText extends VdmEntity<MaintenanceTaskListOpLongText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_maintenancetasklist.v0001.MaintenanceTaskListOpLongTextType";
    /**
     * Selector for all available fields of MaintenanceTaskListOpLongText.
     * 
     */
    public final static SimpleProperty<MaintenanceTaskListOpLongText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @return Task List Type
     */
    @Nullable
    @ElementName( "TaskListType" )
    private java.lang.String taskListType;
    public final static SimpleProperty.String<MaintenanceTaskListOpLongText> TASK_LIST_TYPE =
        new SimpleProperty.String<MaintenanceTaskListOpLongText>(MaintenanceTaskListOpLongText.class, "TaskListType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @return Key for Task List Group
     */
    @Nullable
    @ElementName( "TaskListGroup" )
    private java.lang.String taskListGroup;
    public final static SimpleProperty.String<MaintenanceTaskListOpLongText> TASK_LIST_GROUP =
        new SimpleProperty.String<MaintenanceTaskListOpLongText>(MaintenanceTaskListOpLongText.class, "TaskListGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @return Group Counter
     */
    @Nullable
    @ElementName( "TaskListGroupCounter" )
    private java.lang.String taskListGroupCounter;
    public final static SimpleProperty.String<MaintenanceTaskListOpLongText> TASK_LIST_GROUP_COUNTER =
        new SimpleProperty.String<MaintenanceTaskListOpLongText>(
            MaintenanceTaskListOpLongText.class,
            "TaskListGroupCounter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaskListSequence</b>
     * </p>
     * 
     * @return Sequence
     */
    @Nullable
    @ElementName( "TaskListSequence" )
    private java.lang.String taskListSequence;
    public final static SimpleProperty.String<MaintenanceTaskListOpLongText> TASK_LIST_SEQUENCE =
        new SimpleProperty.String<MaintenanceTaskListOpLongText>(
            MaintenanceTaskListOpLongText.class,
            "TaskListSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOperationInternalId</b>
     * </p>
     * 
     * @return Number of the Task List Node
     */
    @Nullable
    @ElementName( "TaskListOperationInternalId" )
    private java.lang.String taskListOperationInternalId;
    public final static SimpleProperty.String<MaintenanceTaskListOpLongText> TASK_LIST_OPERATION_INTERNAL_ID =
        new SimpleProperty.String<MaintenanceTaskListOpLongText>(
            MaintenanceTaskListOpLongText.class,
            "TaskListOperationInternalId");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOpBOMItmIntVersCounter</b>
     * </p>
     * 
     * @return Internal counter
     */
    @Nullable
    @ElementName( "TaskListOpBOMItmIntVersCounter" )
    private java.lang.String taskListOpBOMItmIntVersCounter;
    public final static SimpleProperty.String<MaintenanceTaskListOpLongText> TASK_LIST_OP_BOM_ITM_INT_VERS_COUNTER =
        new SimpleProperty.String<MaintenanceTaskListOpLongText>(
            MaintenanceTaskListOpLongText.class,
            "TaskListOpBOMItmIntVersCounter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListOperation</b>
     * </p>
     * 
     * @return Operation / Phase Number
     */
    @Nullable
    @ElementName( "MaintenanceTaskListOperation" )
    private java.lang.String maintenanceTaskListOperation;
    public final static SimpleProperty.String<MaintenanceTaskListOpLongText> MAINTENANCE_TASK_LIST_OPERATION =
        new SimpleProperty.String<MaintenanceTaskListOpLongText>(
            MaintenanceTaskListOpLongText.class,
            "MaintenanceTaskListOperation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectKey</b>
     * </p>
     * 
     * @return Name
     */
    @Nullable
    @ElementName( "TextObjectKey" )
    private java.lang.String textObjectKey;
    public final static SimpleProperty.String<MaintenanceTaskListOpLongText> TEXT_OBJECT_KEY =
        new SimpleProperty.String<MaintenanceTaskListOpLongText>(MaintenanceTaskListOpLongText.class, "TextObjectKey");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     * 
     * @return Long Text
     */
    @Nullable
    @ElementName( "PlainLongText" )
    private java.lang.String plainLongText;
    public final static SimpleProperty.String<MaintenanceTaskListOpLongText> PLAIN_LONG_TEXT =
        new SimpleProperty.String<MaintenanceTaskListOpLongText>(MaintenanceTaskListOpLongText.class, "PlainLongText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<MaintenanceTaskListOpLongText> LANGUAGE =
        new SimpleProperty.String<MaintenanceTaskListOpLongText>(MaintenanceTaskListOpLongText.class, "Language");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskListOpLongText, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskListOpLongText, SAP__Message>(
            MaintenanceTaskListOpLongText.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_Operation</b> for <b>MaintenanceTaskListOpLongText</b> to single
     * <b>MaintenanceTaskListOperation</b>.
     * 
     */
    @ElementName( "_Operation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceTaskListOperation to_Operation;
    /**
     * Use with available request builders to apply the <b>_Operation</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MaintenanceTaskListOpLongText, MaintenanceTaskListOperation> TO__OPERATION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MaintenanceTaskListOpLongText, MaintenanceTaskListOperation>(
            MaintenanceTaskListOpLongText.class,
            "_Operation",
            MaintenanceTaskListOperation.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MaintenanceTaskListOpLongText> getType()
    {
        return MaintenanceTaskListOpLongText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @param taskListType
     *            Task List Type
     */
    public void setTaskListType( @Nullable final java.lang.String taskListType )
    {
        rememberChangedField("TaskListType", this.taskListType);
        this.taskListType = taskListType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @param taskListGroup
     *            Key for Task List Group
     */
    public void setTaskListGroup( @Nullable final java.lang.String taskListGroup )
    {
        rememberChangedField("TaskListGroup", this.taskListGroup);
        this.taskListGroup = taskListGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @param taskListGroupCounter
     *            Group Counter
     */
    public void setTaskListGroupCounter( @Nullable final java.lang.String taskListGroupCounter )
    {
        rememberChangedField("TaskListGroupCounter", this.taskListGroupCounter);
        this.taskListGroupCounter = taskListGroupCounter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaskListSequence</b>
     * </p>
     * 
     * @param taskListSequence
     *            Sequence
     */
    public void setTaskListSequence( @Nullable final java.lang.String taskListSequence )
    {
        rememberChangedField("TaskListSequence", this.taskListSequence);
        this.taskListSequence = taskListSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOperationInternalId</b>
     * </p>
     * 
     * @param taskListOperationInternalId
     *            Number of the Task List Node
     */
    public void setTaskListOperationInternalId( @Nullable final java.lang.String taskListOperationInternalId )
    {
        rememberChangedField("TaskListOperationInternalId", this.taskListOperationInternalId);
        this.taskListOperationInternalId = taskListOperationInternalId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOpBOMItmIntVersCounter</b>
     * </p>
     * 
     * @param taskListOpBOMItmIntVersCounter
     *            Internal counter
     */
    public void setTaskListOpBOMItmIntVersCounter( @Nullable final java.lang.String taskListOpBOMItmIntVersCounter )
    {
        rememberChangedField("TaskListOpBOMItmIntVersCounter", this.taskListOpBOMItmIntVersCounter);
        this.taskListOpBOMItmIntVersCounter = taskListOpBOMItmIntVersCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListOperation</b>
     * </p>
     * 
     * @param maintenanceTaskListOperation
     *            Operation / Phase Number
     */
    public void setMaintenanceTaskListOperation( @Nullable final java.lang.String maintenanceTaskListOperation )
    {
        rememberChangedField("MaintenanceTaskListOperation", this.maintenanceTaskListOperation);
        this.maintenanceTaskListOperation = maintenanceTaskListOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectKey</b>
     * </p>
     * 
     * @param textObjectKey
     *            Name
     */
    public void setTextObjectKey( @Nullable final java.lang.String textObjectKey )
    {
        rememberChangedField("TextObjectKey", this.textObjectKey);
        this.textObjectKey = textObjectKey;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     * 
     * @param plainLongText
     *            Long Text
     */
    public void setPlainLongText( @Nullable final java.lang.String plainLongText )
    {
        rememberChangedField("PlainLongText", this.plainLongText);
        this.plainLongText = plainLongText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MaintenanceTaskListOpLongText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("TaskListType", getTaskListType());
        entityKey.addKeyProperty("TaskListGroup", getTaskListGroup());
        entityKey.addKeyProperty("TaskListGroupCounter", getTaskListGroupCounter());
        entityKey.addKeyProperty("TaskListSequence", getTaskListSequence());
        entityKey.addKeyProperty("TaskListOperationInternalId", getTaskListOperationInternalId());
        entityKey.addKeyProperty("TaskListOpBOMItmIntVersCounter", getTaskListOpBOMItmIntVersCounter());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("TaskListType", getTaskListType());
        values.put("TaskListGroup", getTaskListGroup());
        values.put("TaskListGroupCounter", getTaskListGroupCounter());
        values.put("TaskListSequence", getTaskListSequence());
        values.put("TaskListOperationInternalId", getTaskListOperationInternalId());
        values.put("TaskListOpBOMItmIntVersCounter", getTaskListOpBOMItmIntVersCounter());
        values.put("MaintenanceTaskListOperation", getMaintenanceTaskListOperation());
        values.put("TextObjectKey", getTextObjectKey());
        values.put("PlainLongText", getPlainLongText());
        values.put("Language", getLanguage());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("TaskListType") ) {
                final Object value = values.remove("TaskListType");
                if( (value == null) || (!value.equals(getTaskListType())) ) {
                    setTaskListType(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroup") ) {
                final Object value = values.remove("TaskListGroup");
                if( (value == null) || (!value.equals(getTaskListGroup())) ) {
                    setTaskListGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroupCounter") ) {
                final Object value = values.remove("TaskListGroupCounter");
                if( (value == null) || (!value.equals(getTaskListGroupCounter())) ) {
                    setTaskListGroupCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListSequence") ) {
                final Object value = values.remove("TaskListSequence");
                if( (value == null) || (!value.equals(getTaskListSequence())) ) {
                    setTaskListSequence(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListOperationInternalId") ) {
                final Object value = values.remove("TaskListOperationInternalId");
                if( (value == null) || (!value.equals(getTaskListOperationInternalId())) ) {
                    setTaskListOperationInternalId(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListOpBOMItmIntVersCounter") ) {
                final Object value = values.remove("TaskListOpBOMItmIntVersCounter");
                if( (value == null) || (!value.equals(getTaskListOpBOMItmIntVersCounter())) ) {
                    setTaskListOpBOMItmIntVersCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenanceTaskListOperation") ) {
                final Object value = values.remove("MaintenanceTaskListOperation");
                if( (value == null) || (!value.equals(getMaintenanceTaskListOperation())) ) {
                    setMaintenanceTaskListOperation(((java.lang.String) value));
                }
            }
            if( values.containsKey("TextObjectKey") ) {
                final Object value = values.remove("TextObjectKey");
                if( (value == null) || (!value.equals(getTextObjectKey())) ) {
                    setTextObjectKey(((java.lang.String) value));
                }
            }
            if( values.containsKey("PlainLongText") ) {
                final Object value = values.remove("PlainLongText");
                if( (value == null) || (!value.equals(getPlainLongText())) ) {
                    setPlainLongText(((java.lang.String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_Operation") ) {
                final Object value = (values).remove("_Operation");
                if( value instanceof Map ) {
                    if( to_Operation == null ) {
                        to_Operation = new MaintenanceTaskListOperation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_Operation.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MaintenanceTasklistService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_Operation != null ) {
            (values).put("_Operation", to_Operation);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>MaintenanceTaskListOperation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_Operation</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceTaskListOpLongText</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Operation</b> is already loaded, the result will contain
     *         the <b>MaintenanceTaskListOperation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceTaskListOperation> getOperationIfPresent()
    {
        return Option.of(to_Operation);
    }

    /**
     * Overwrites the associated <b>MaintenanceTaskListOperation</b> entity for the loaded navigation property
     * <b>_Operation</b>.
     * 
     * @param value
     *            New <b>MaintenanceTaskListOperation</b> entity.
     */
    public void setOperation( final MaintenanceTaskListOperation value )
    {
        to_Operation = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceTaskListOpLongText instances.
     * 
     */
    public final static class MaintenanceTaskListOpLongTextBuilder
    {

        private MaintenanceTaskListOperation to_Operation;

        private MaintenanceTaskListOpLongText.MaintenanceTaskListOpLongTextBuilder to_Operation(
            final MaintenanceTaskListOperation value )
        {
            to_Operation = value;
            return this;
        }

        /**
         * Navigation property <b>_Operation</b> for <b>MaintenanceTaskListOpLongText</b> to single
         * <b>MaintenanceTaskListOperation</b>.
         * 
         * @param value
         *            The MaintenanceTaskListOperation to build this MaintenanceTaskListOpLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceTaskListOpLongText.MaintenanceTaskListOpLongTextBuilder operation(
            final MaintenanceTaskListOperation value )
        {
            return to_Operation(value);
        }

    }

}
