/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MaintenanceTasklistService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Operation Materials
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceTaskListOpMatType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MaintenanceTaskListOpMat extends VdmEntity<MaintenanceTaskListOpMat> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_maintenancetasklist.v0001.MaintenanceTaskListOpMatType";
    /**
     * Selector for all available fields of MaintenanceTaskListOpMat.
     * 
     */
    public final static SimpleProperty<MaintenanceTaskListOpMat> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @return Task List Type
     */
    @Nullable
    @ElementName( "TaskListType" )
    private java.lang.String taskListType;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> TASK_LIST_TYPE =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(MaintenanceTaskListOpMat.class, "TaskListType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @return Key for Task List Group
     */
    @Nullable
    @ElementName( "TaskListGroup" )
    private java.lang.String taskListGroup;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> TASK_LIST_GROUP =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(MaintenanceTaskListOpMat.class, "TaskListGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @return Group Counter
     */
    @Nullable
    @ElementName( "TaskListGroupCounter" )
    private java.lang.String taskListGroupCounter;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> TASK_LIST_GROUP_COUNTER =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(MaintenanceTaskListOpMat.class, "TaskListGroupCounter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaskListSequence</b>
     * </p>
     * 
     * @return Sequence
     */
    @Nullable
    @ElementName( "TaskListSequence" )
    private java.lang.String taskListSequence;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> TASK_LIST_SEQUENCE =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(MaintenanceTaskListOpMat.class, "TaskListSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOperationInternalId</b>
     * </p>
     * 
     * @return Task list node number for operation
     */
    @Nullable
    @ElementName( "TaskListOperationInternalId" )
    private java.lang.String taskListOperationInternalId;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> TASK_LIST_OPERATION_INTERNAL_ID =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(
            MaintenanceTaskListOpMat.class,
            "TaskListOperationInternalId");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOpBOMItmInternalID</b>
     * </p>
     * 
     * @return No. for material comp. allocation to task list
     */
    @Nullable
    @ElementName( "TaskListOpBOMItmInternalID" )
    private java.lang.String taskListOpBOMItmInternalID;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> TASK_LIST_OP_BOM_ITM_INTERNAL_ID =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(
            MaintenanceTaskListOpMat.class,
            "TaskListOpBOMItmInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOpBOMItmIntVersCounter</b>
     * </p>
     * 
     * @return Internal counter
     */
    @Nullable
    @ElementName( "TaskListOpBOMItmIntVersCounter" )
    private java.lang.String taskListOpBOMItmIntVersCounter;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> TASK_LIST_OP_BOM_ITM_INT_VERS_COUNTER =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(
            MaintenanceTaskListOpMat.class,
            "TaskListOpBOMItmIntVersCounter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListOperation</b>
     * </p>
     * 
     * @return Operation / Phase Number
     */
    @Nullable
    @ElementName( "MaintenanceTaskListOperation" )
    private java.lang.String maintenanceTaskListOperation;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> MAINTENANCE_TASK_LIST_OPERATION =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(
            MaintenanceTaskListOpMat.class,
            "MaintenanceTaskListOperation");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     * 
     * @return BOM component
     */
    @Nullable
    @ElementName( "Material" )
    private java.lang.String material;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> MATERIAL =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(MaintenanceTaskListOpMat.class, "Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     * 
     * @return Material Description
     */
    @Nullable
    @ElementName( "MaterialName" )
    private java.lang.String materialName;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> MATERIAL_NAME =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(MaintenanceTaskListOpMat.class, "MaterialName");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemQuantity</b>
     * </p>
     * 
     * @return The billOfMaterialItemQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "BillOfMaterialItemQuantity" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal billOfMaterialItemQuantity;
    public final static SimpleProperty.NumericDecimal<MaintenanceTaskListOpMat> BILL_OF_MATERIAL_ITEM_QUANTITY =
        new SimpleProperty.NumericDecimal<MaintenanceTaskListOpMat>(
            MaintenanceTaskListOpMat.class,
            "BillOfMaterialItemQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     * </p>
     * 
     * @return Item category (bill of material)
     */
    @Nullable
    @ElementName( "BillOfMaterialItemCategory" )
    private java.lang.String billOfMaterialItemCategory;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> BILL_OF_MATERIAL_ITEM_CATEGORY =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(
            MaintenanceTaskListOpMat.class,
            "BillOfMaterialItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemUnit</b>
     * </p>
     * 
     * @return Component Unit of Measure
     */
    @Nullable
    @ElementName( "BillOfMaterialItemUnit" )
    private java.lang.String billOfMaterialItemUnit;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> BILL_OF_MATERIAL_ITEM_UNIT =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(MaintenanceTaskListOpMat.class, "BillOfMaterialItemUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ResvnIsMRPRlvtOrPurReqnIsCrted</b>
     * </p>
     * 
     * @return Relevancy to Materials Planning/Generation of Purchase Req.
     */
    @Nullable
    @ElementName( "ResvnIsMRPRlvtOrPurReqnIsCrted" )
    private java.lang.String resvnIsMRPRlvtOrPurReqnIsCrted;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> RESVN_IS_MRP_RLVT_OR_PUR_REQN_IS_CRTED =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(
            MaintenanceTaskListOpMat.class,
            "ResvnIsMRPRlvtOrPurReqnIsCrted");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     * 
     * @return Indicator: Backflush
     */
    @Nullable
    @ElementName( "MatlCompIsMarkedForBackflush" )
    private java.lang.Boolean matlCompIsMarkedForBackflush;
    public final static SimpleProperty.Boolean<MaintenanceTaskListOpMat> MATL_COMP_IS_MARKED_FOR_BACKFLUSH =
        new SimpleProperty.Boolean<MaintenanceTaskListOpMat>(
            MaintenanceTaskListOpMat.class,
            "MatlCompIsMarkedForBackflush");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SafetyRelevantObject</b>
     * </p>
     * 
     * @return Object ID of Safety Measure
     */
    @Nullable
    @ElementName( "SafetyRelevantObject" )
    private java.lang.String safetyRelevantObject;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> SAFETY_RELEVANT_OBJECT =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(MaintenanceTaskListOpMat.class, "SafetyRelevantObject");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategoryDesc</b>
     * </p>
     * 
     * @return Item category text
     */
    @Nullable
    @ElementName( "BillOfMaterialItemCategoryDesc" )
    private java.lang.String billOfMaterialItemCategoryDesc;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> BILL_OF_MATERIAL_ITEM_CATEGORY_DESC =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(
            MaintenanceTaskListOpMat.class,
            "BillOfMaterialItemCategoryDesc");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MatlsPlngRelevancyCodeName</b>
     * </p>
     * 
     * @return Short Text for Fixed Values
     */
    @Nullable
    @ElementName( "MatlsPlngRelevancyCodeName" )
    private java.lang.String matlsPlngRelevancyCodeName;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> MATLS_PLNG_RELEVANCY_CODE_NAME =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(
            MaintenanceTaskListOpMat.class,
            "MatlsPlngRelevancyCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SafetyRelevanceActionDesc</b>
     * </p>
     * 
     * @return Safety Relevance/Action Description
     */
    @Nullable
    @ElementName( "SafetyRelevanceActionDesc" )
    private java.lang.String safetyRelevanceActionDesc;
    public final static SimpleProperty.String<MaintenanceTaskListOpMat> SAFETY_RELEVANCE_ACTION_DESC =
        new SimpleProperty.String<MaintenanceTaskListOpMat>(
            MaintenanceTaskListOpMat.class,
            "SafetyRelevanceActionDesc");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskListOpMat, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskListOpMat, SAP__Message>(
            MaintenanceTaskListOpMat.class,
            "SAP__Messages",
            SAP__Message.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MaintenanceTaskListOpMat> getType()
    {
        return MaintenanceTaskListOpMat.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @param taskListType
     *            Task List Type
     */
    public void setTaskListType( @Nullable final java.lang.String taskListType )
    {
        rememberChangedField("TaskListType", this.taskListType);
        this.taskListType = taskListType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @param taskListGroup
     *            Key for Task List Group
     */
    public void setTaskListGroup( @Nullable final java.lang.String taskListGroup )
    {
        rememberChangedField("TaskListGroup", this.taskListGroup);
        this.taskListGroup = taskListGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @param taskListGroupCounter
     *            Group Counter
     */
    public void setTaskListGroupCounter( @Nullable final java.lang.String taskListGroupCounter )
    {
        rememberChangedField("TaskListGroupCounter", this.taskListGroupCounter);
        this.taskListGroupCounter = taskListGroupCounter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaskListSequence</b>
     * </p>
     * 
     * @param taskListSequence
     *            Sequence
     */
    public void setTaskListSequence( @Nullable final java.lang.String taskListSequence )
    {
        rememberChangedField("TaskListSequence", this.taskListSequence);
        this.taskListSequence = taskListSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOperationInternalId</b>
     * </p>
     * 
     * @param taskListOperationInternalId
     *            Task list node number for operation
     */
    public void setTaskListOperationInternalId( @Nullable final java.lang.String taskListOperationInternalId )
    {
        rememberChangedField("TaskListOperationInternalId", this.taskListOperationInternalId);
        this.taskListOperationInternalId = taskListOperationInternalId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOpBOMItmInternalID</b>
     * </p>
     * 
     * @param taskListOpBOMItmInternalID
     *            No. for material comp. allocation to task list
     */
    public void setTaskListOpBOMItmInternalID( @Nullable final java.lang.String taskListOpBOMItmInternalID )
    {
        rememberChangedField("TaskListOpBOMItmInternalID", this.taskListOpBOMItmInternalID);
        this.taskListOpBOMItmInternalID = taskListOpBOMItmInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOpBOMItmIntVersCounter</b>
     * </p>
     * 
     * @param taskListOpBOMItmIntVersCounter
     *            Internal counter
     */
    public void setTaskListOpBOMItmIntVersCounter( @Nullable final java.lang.String taskListOpBOMItmIntVersCounter )
    {
        rememberChangedField("TaskListOpBOMItmIntVersCounter", this.taskListOpBOMItmIntVersCounter);
        this.taskListOpBOMItmIntVersCounter = taskListOpBOMItmIntVersCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListOperation</b>
     * </p>
     * 
     * @param maintenanceTaskListOperation
     *            Operation / Phase Number
     */
    public void setMaintenanceTaskListOperation( @Nullable final java.lang.String maintenanceTaskListOperation )
    {
        rememberChangedField("MaintenanceTaskListOperation", this.maintenanceTaskListOperation);
        this.maintenanceTaskListOperation = maintenanceTaskListOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     * 
     * @param material
     *            BOM component
     */
    public void setMaterial( @Nullable final java.lang.String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     * 
     * @param materialName
     *            Material Description
     */
    public void setMaterialName( @Nullable final java.lang.String materialName )
    {
        rememberChangedField("MaterialName", this.materialName);
        this.materialName = materialName;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemQuantity</b>
     * </p>
     * 
     * @param billOfMaterialItemQuantity
     *            The billOfMaterialItemQuantity to set.
     */
    public void setBillOfMaterialItemQuantity( @Nullable final BigDecimal billOfMaterialItemQuantity )
    {
        rememberChangedField("BillOfMaterialItemQuantity", this.billOfMaterialItemQuantity);
        this.billOfMaterialItemQuantity = billOfMaterialItemQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     * </p>
     * 
     * @param billOfMaterialItemCategory
     *            Item category (bill of material)
     */
    public void setBillOfMaterialItemCategory( @Nullable final java.lang.String billOfMaterialItemCategory )
    {
        rememberChangedField("BillOfMaterialItemCategory", this.billOfMaterialItemCategory);
        this.billOfMaterialItemCategory = billOfMaterialItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemUnit</b>
     * </p>
     * 
     * @param billOfMaterialItemUnit
     *            Component Unit of Measure
     */
    public void setBillOfMaterialItemUnit( @Nullable final java.lang.String billOfMaterialItemUnit )
    {
        rememberChangedField("BillOfMaterialItemUnit", this.billOfMaterialItemUnit);
        this.billOfMaterialItemUnit = billOfMaterialItemUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ResvnIsMRPRlvtOrPurReqnIsCrted</b>
     * </p>
     * 
     * @param resvnIsMRPRlvtOrPurReqnIsCrted
     *            Relevancy to Materials Planning/Generation of Purchase Req.
     */
    public void setResvnIsMRPRlvtOrPurReqnIsCrted( @Nullable final java.lang.String resvnIsMRPRlvtOrPurReqnIsCrted )
    {
        rememberChangedField("ResvnIsMRPRlvtOrPurReqnIsCrted", this.resvnIsMRPRlvtOrPurReqnIsCrted);
        this.resvnIsMRPRlvtOrPurReqnIsCrted = resvnIsMRPRlvtOrPurReqnIsCrted;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     * 
     * @param matlCompIsMarkedForBackflush
     *            Indicator: Backflush
     */
    public void setMatlCompIsMarkedForBackflush( @Nullable final java.lang.Boolean matlCompIsMarkedForBackflush )
    {
        rememberChangedField("MatlCompIsMarkedForBackflush", this.matlCompIsMarkedForBackflush);
        this.matlCompIsMarkedForBackflush = matlCompIsMarkedForBackflush;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SafetyRelevantObject</b>
     * </p>
     * 
     * @param safetyRelevantObject
     *            Object ID of Safety Measure
     */
    public void setSafetyRelevantObject( @Nullable final java.lang.String safetyRelevantObject )
    {
        rememberChangedField("SafetyRelevantObject", this.safetyRelevantObject);
        this.safetyRelevantObject = safetyRelevantObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategoryDesc</b>
     * </p>
     * 
     * @param billOfMaterialItemCategoryDesc
     *            Item category text
     */
    public void setBillOfMaterialItemCategoryDesc( @Nullable final java.lang.String billOfMaterialItemCategoryDesc )
    {
        rememberChangedField("BillOfMaterialItemCategoryDesc", this.billOfMaterialItemCategoryDesc);
        this.billOfMaterialItemCategoryDesc = billOfMaterialItemCategoryDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MatlsPlngRelevancyCodeName</b>
     * </p>
     * 
     * @param matlsPlngRelevancyCodeName
     *            Short Text for Fixed Values
     */
    public void setMatlsPlngRelevancyCodeName( @Nullable final java.lang.String matlsPlngRelevancyCodeName )
    {
        rememberChangedField("MatlsPlngRelevancyCodeName", this.matlsPlngRelevancyCodeName);
        this.matlsPlngRelevancyCodeName = matlsPlngRelevancyCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SafetyRelevanceActionDesc</b>
     * </p>
     * 
     * @param safetyRelevanceActionDesc
     *            Safety Relevance/Action Description
     */
    public void setSafetyRelevanceActionDesc( @Nullable final java.lang.String safetyRelevanceActionDesc )
    {
        rememberChangedField("SafetyRelevanceActionDesc", this.safetyRelevanceActionDesc);
        this.safetyRelevanceActionDesc = safetyRelevanceActionDesc;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MaintenanceTaskListOpMat";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("TaskListType", getTaskListType());
        entityKey.addKeyProperty("TaskListGroup", getTaskListGroup());
        entityKey.addKeyProperty("TaskListGroupCounter", getTaskListGroupCounter());
        entityKey.addKeyProperty("TaskListSequence", getTaskListSequence());
        entityKey.addKeyProperty("TaskListOperationInternalId", getTaskListOperationInternalId());
        entityKey.addKeyProperty("TaskListOpBOMItmInternalID", getTaskListOpBOMItmInternalID());
        entityKey.addKeyProperty("TaskListOpBOMItmIntVersCounter", getTaskListOpBOMItmIntVersCounter());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("TaskListType", getTaskListType());
        values.put("TaskListGroup", getTaskListGroup());
        values.put("TaskListGroupCounter", getTaskListGroupCounter());
        values.put("TaskListSequence", getTaskListSequence());
        values.put("TaskListOperationInternalId", getTaskListOperationInternalId());
        values.put("TaskListOpBOMItmInternalID", getTaskListOpBOMItmInternalID());
        values.put("TaskListOpBOMItmIntVersCounter", getTaskListOpBOMItmIntVersCounter());
        values.put("MaintenanceTaskListOperation", getMaintenanceTaskListOperation());
        values.put("Material", getMaterial());
        values.put("MaterialName", getMaterialName());
        values.put("BillOfMaterialItemQuantity", getBillOfMaterialItemQuantity());
        values.put("BillOfMaterialItemCategory", getBillOfMaterialItemCategory());
        values.put("BillOfMaterialItemUnit", getBillOfMaterialItemUnit());
        values.put("ResvnIsMRPRlvtOrPurReqnIsCrted", getResvnIsMRPRlvtOrPurReqnIsCrted());
        values.put("MatlCompIsMarkedForBackflush", getMatlCompIsMarkedForBackflush());
        values.put("SafetyRelevantObject", getSafetyRelevantObject());
        values.put("BillOfMaterialItemCategoryDesc", getBillOfMaterialItemCategoryDesc());
        values.put("MatlsPlngRelevancyCodeName", getMatlsPlngRelevancyCodeName());
        values.put("SafetyRelevanceActionDesc", getSafetyRelevanceActionDesc());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("TaskListType") ) {
                final Object value = values.remove("TaskListType");
                if( (value == null) || (!value.equals(getTaskListType())) ) {
                    setTaskListType(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroup") ) {
                final Object value = values.remove("TaskListGroup");
                if( (value == null) || (!value.equals(getTaskListGroup())) ) {
                    setTaskListGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroupCounter") ) {
                final Object value = values.remove("TaskListGroupCounter");
                if( (value == null) || (!value.equals(getTaskListGroupCounter())) ) {
                    setTaskListGroupCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListSequence") ) {
                final Object value = values.remove("TaskListSequence");
                if( (value == null) || (!value.equals(getTaskListSequence())) ) {
                    setTaskListSequence(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListOperationInternalId") ) {
                final Object value = values.remove("TaskListOperationInternalId");
                if( (value == null) || (!value.equals(getTaskListOperationInternalId())) ) {
                    setTaskListOperationInternalId(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListOpBOMItmInternalID") ) {
                final Object value = values.remove("TaskListOpBOMItmInternalID");
                if( (value == null) || (!value.equals(getTaskListOpBOMItmInternalID())) ) {
                    setTaskListOpBOMItmInternalID(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListOpBOMItmIntVersCounter") ) {
                final Object value = values.remove("TaskListOpBOMItmIntVersCounter");
                if( (value == null) || (!value.equals(getTaskListOpBOMItmIntVersCounter())) ) {
                    setTaskListOpBOMItmIntVersCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenanceTaskListOperation") ) {
                final Object value = values.remove("MaintenanceTaskListOperation");
                if( (value == null) || (!value.equals(getMaintenanceTaskListOperation())) ) {
                    setMaintenanceTaskListOperation(((java.lang.String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaterialName") ) {
                final Object value = values.remove("MaterialName");
                if( (value == null) || (!value.equals(getMaterialName())) ) {
                    setMaterialName(((java.lang.String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemQuantity") ) {
                final Object value = values.remove("BillOfMaterialItemQuantity");
                if( (value == null) || (!value.equals(getBillOfMaterialItemQuantity())) ) {
                    setBillOfMaterialItemQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemCategory") ) {
                final Object value = values.remove("BillOfMaterialItemCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialItemCategory())) ) {
                    setBillOfMaterialItemCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemUnit") ) {
                final Object value = values.remove("BillOfMaterialItemUnit");
                if( (value == null) || (!value.equals(getBillOfMaterialItemUnit())) ) {
                    setBillOfMaterialItemUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ResvnIsMRPRlvtOrPurReqnIsCrted") ) {
                final Object value = values.remove("ResvnIsMRPRlvtOrPurReqnIsCrted");
                if( (value == null) || (!value.equals(getResvnIsMRPRlvtOrPurReqnIsCrted())) ) {
                    setResvnIsMRPRlvtOrPurReqnIsCrted(((java.lang.String) value));
                }
            }
            if( values.containsKey("MatlCompIsMarkedForBackflush") ) {
                final Object value = values.remove("MatlCompIsMarkedForBackflush");
                if( (value == null) || (!value.equals(getMatlCompIsMarkedForBackflush())) ) {
                    setMatlCompIsMarkedForBackflush(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("SafetyRelevantObject") ) {
                final Object value = values.remove("SafetyRelevantObject");
                if( (value == null) || (!value.equals(getSafetyRelevantObject())) ) {
                    setSafetyRelevantObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemCategoryDesc") ) {
                final Object value = values.remove("BillOfMaterialItemCategoryDesc");
                if( (value == null) || (!value.equals(getBillOfMaterialItemCategoryDesc())) ) {
                    setBillOfMaterialItemCategoryDesc(((java.lang.String) value));
                }
            }
            if( values.containsKey("MatlsPlngRelevancyCodeName") ) {
                final Object value = values.remove("MatlsPlngRelevancyCodeName");
                if( (value == null) || (!value.equals(getMatlsPlngRelevancyCodeName())) ) {
                    setMatlsPlngRelevancyCodeName(((java.lang.String) value));
                }
            }
            if( values.containsKey("SafetyRelevanceActionDesc") ) {
                final Object value = values.remove("SafetyRelevanceActionDesc");
                if( (value == null) || (!value.equals(getSafetyRelevanceActionDesc())) ) {
                    setSafetyRelevanceActionDesc(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MaintenanceTasklistService.DEFAULT_SERVICE_PATH;
    }

}
