/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MaintenanceTasklistService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Operation Relationships
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceTaskListOpReltnshpType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MaintenanceTaskListOpReltnshp extends VdmEntity<MaintenanceTaskListOpReltnshp> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_maintenancetasklist.v0001.MaintenanceTaskListOpReltnshpType";
    /**
     * Selector for all available fields of MaintenanceTaskListOpReltnshp.
     * 
     */
    public final static SimpleProperty<MaintenanceTaskListOpReltnshp> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @return Header
     */
    @Nullable
    @ElementName( "TaskListType" )
    private java.lang.String taskListType;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> TASK_LIST_TYPE =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(MaintenanceTaskListOpReltnshp.class, "TaskListType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @return Number of the Standard Network
     */
    @Nullable
    @ElementName( "TaskListGroup" )
    private java.lang.String taskListGroup;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> TASK_LIST_GROUP =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(MaintenanceTaskListOpReltnshp.class, "TaskListGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @return Group Counter
     */
    @Nullable
    @ElementName( "TaskListGroupCounter" )
    private java.lang.String taskListGroupCounter;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> TASK_LIST_GROUP_COUNTER =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "TaskListGroupCounter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaskListSequence</b>
     * </p>
     * 
     * @return Sequence
     */
    @Nullable
    @ElementName( "TaskListSequence" )
    private java.lang.String taskListSequence;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> TASK_LIST_SEQUENCE =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "TaskListSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOperationInternalId</b>
     * </p>
     * 
     * @return Number of the Task List Node
     */
    @Nullable
    @ElementName( "TaskListOperationInternalId" )
    private java.lang.String taskListOperationInternalId;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> TASK_LIST_OPERATION_INTERNAL_ID =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "TaskListOperationInternalId");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOpBOMItmIntVersCounter</b>
     * </p>
     * 
     * @return Internal counter
     */
    @Nullable
    @ElementName( "TaskListOpBOMItmIntVersCounter" )
    private java.lang.String taskListOpBOMItmIntVersCounter;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> TASK_LIST_OP_BOM_ITM_INT_VERS_COUNTER =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "TaskListOpBOMItmIntVersCounter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListOperation</b>
     * </p>
     * 
     * @return Operation / Phase Number
     */
    @Nullable
    @ElementName( "MaintenanceTaskListOperation" )
    private java.lang.String maintenanceTaskListOperation;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> MAINTENANCE_TASK_LIST_OPERATION =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "MaintenanceTaskListOperation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorOperation</b>
     * </p>
     * 
     * @return Operation / Phase Number
     */
    @Nullable
    @ElementName( "SuperiorOperation" )
    private java.lang.String superiorOperation;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> SUPERIOR_OPERATION =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "SuperiorOperation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     * 
     * @return Operation Short Text
     */
    @Nullable
    @ElementName( "OperationText" )
    private java.lang.String operationText;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> OPERATION_TEXT =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(MaintenanceTaskListOpReltnshp.class, "OperationText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeRelationshipType</b>
     * </p>
     * 
     * @return Type of relationship
     */
    @Nullable
    @ElementName( "MasterRecipeRelationshipType" )
    private java.lang.String masterRecipeRelationshipType;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> MASTER_RECIPE_RELATIONSHIP_TYPE =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "MasterRecipeRelationshipType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsSuccessor</b>
     * </p>
     * 
     * @return Indicator: maintained after successor
     */
    @Nullable
    @ElementName( "OperationIsSuccessor" )
    private java.lang.Boolean operationIsSuccessor;
    public final static SimpleProperty.Boolean<MaintenanceTaskListOpReltnshp> OPERATION_IS_SUCCESSOR =
        new SimpleProperty.Boolean<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "OperationIsSuccessor");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     * 
     * @return Factory Calendar
     */
    @Nullable
    @ElementName( "FactoryCalendar" )
    private java.lang.String factoryCalendar;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> FACTORY_CALENDAR =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "FactoryCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     * 
     * @return Work Center
     */
    @Nullable
    @ElementName( "WorkCenter" )
    private java.lang.String workCenter;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> WORK_CENTER =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(MaintenanceTaskListOpReltnshp.class, "WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> PLANT =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(MaintenanceTaskListOpReltnshp.class, "Plant");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaxTimeIntvlIsUsedForSchedg</b>
     * </p>
     * 
     * @return Indicates whether maximum time interval will be considered
     */
    @Nullable
    @ElementName( "MaxTimeIntvlIsUsedForSchedg" )
    private java.lang.Boolean maxTimeIntvlIsUsedForSchedg;
    public final static SimpleProperty.Boolean<MaintenanceTaskListOpReltnshp> MAX_TIME_INTVL_IS_USED_FOR_SCHEDG =
        new SimpleProperty.Boolean<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "MaxTimeIntvlIsUsedForSchedg");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOORelationshipType</b>
     * </p>
     * 
     * @return Key for type of relationship
     */
    @Nullable
    @ElementName( "BOORelationshipType" )
    private java.lang.String bOORelationshipType;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> BOO_RELATIONSHIP_TYPE =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "BOORelationshipType");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>TimeIntvlBtwnRelshp</b>
     * </p>
     * 
     * @return Time Interval Between Relationships
     */
    @Nullable
    @ElementName( "TimeIntvlBtwnRelshp" )
    @DecimalDescriptor( precision = 5, scale = 1 )
    private BigDecimal timeIntvlBtwnRelshp;
    public final static SimpleProperty.NumericDecimal<MaintenanceTaskListOpReltnshp> TIME_INTVL_BTWN_RELSHP =
        new SimpleProperty.NumericDecimal<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "TimeIntvlBtwnRelshp");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TimeIntvlBtwnRelshpUnit</b>
     * </p>
     * 
     * @return Unit for the time interval between relationships
     */
    @Nullable
    @ElementName( "TimeIntvlBtwnRelshpUnit" )
    private java.lang.String timeIntvlBtwnRelshpUnit;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> TIME_INTVL_BTWN_RELSHP_UNIT =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "TimeIntvlBtwnRelshpUnit");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     * 
     * @return Object ID
     */
    @Nullable
    @ElementName( "WorkCenterInternalID" )
    private java.lang.String workCenterInternalID;
    public final static SimpleProperty.String<MaintenanceTaskListOpReltnshp> WORK_CENTER_INTERNAL_ID =
        new SimpleProperty.String<MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOpReltnshp.class,
            "WorkCenterInternalID");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskListOpReltnshp, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskListOpReltnshp, SAP__Message>(
            MaintenanceTaskListOpReltnshp.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_Operation</b> for <b>MaintenanceTaskListOpReltnshp</b> to multiple
     * <b>MaintenanceTaskListOperation</b>.
     * 
     */
    @ElementName( "_Operation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceTaskListOperation> to_Operation;
    /**
     * Use with available request builders to apply the <b>_Operation</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MaintenanceTaskListOpReltnshp, MaintenanceTaskListOperation> TO__OPERATION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MaintenanceTaskListOpReltnshp, MaintenanceTaskListOperation>(
            MaintenanceTaskListOpReltnshp.class,
            "_Operation",
            MaintenanceTaskListOperation.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MaintenanceTaskListOpReltnshp> getType()
    {
        return MaintenanceTaskListOpReltnshp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @param taskListType
     *            Header
     */
    public void setTaskListType( @Nullable final java.lang.String taskListType )
    {
        rememberChangedField("TaskListType", this.taskListType);
        this.taskListType = taskListType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @param taskListGroup
     *            Number of the Standard Network
     */
    public void setTaskListGroup( @Nullable final java.lang.String taskListGroup )
    {
        rememberChangedField("TaskListGroup", this.taskListGroup);
        this.taskListGroup = taskListGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @param taskListGroupCounter
     *            Group Counter
     */
    public void setTaskListGroupCounter( @Nullable final java.lang.String taskListGroupCounter )
    {
        rememberChangedField("TaskListGroupCounter", this.taskListGroupCounter);
        this.taskListGroupCounter = taskListGroupCounter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaskListSequence</b>
     * </p>
     * 
     * @param taskListSequence
     *            Sequence
     */
    public void setTaskListSequence( @Nullable final java.lang.String taskListSequence )
    {
        rememberChangedField("TaskListSequence", this.taskListSequence);
        this.taskListSequence = taskListSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOperationInternalId</b>
     * </p>
     * 
     * @param taskListOperationInternalId
     *            Number of the Task List Node
     */
    public void setTaskListOperationInternalId( @Nullable final java.lang.String taskListOperationInternalId )
    {
        rememberChangedField("TaskListOperationInternalId", this.taskListOperationInternalId);
        this.taskListOperationInternalId = taskListOperationInternalId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOpBOMItmIntVersCounter</b>
     * </p>
     * 
     * @param taskListOpBOMItmIntVersCounter
     *            Internal counter
     */
    public void setTaskListOpBOMItmIntVersCounter( @Nullable final java.lang.String taskListOpBOMItmIntVersCounter )
    {
        rememberChangedField("TaskListOpBOMItmIntVersCounter", this.taskListOpBOMItmIntVersCounter);
        this.taskListOpBOMItmIntVersCounter = taskListOpBOMItmIntVersCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListOperation</b>
     * </p>
     * 
     * @param maintenanceTaskListOperation
     *            Operation / Phase Number
     */
    public void setMaintenanceTaskListOperation( @Nullable final java.lang.String maintenanceTaskListOperation )
    {
        rememberChangedField("MaintenanceTaskListOperation", this.maintenanceTaskListOperation);
        this.maintenanceTaskListOperation = maintenanceTaskListOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorOperation</b>
     * </p>
     * 
     * @param superiorOperation
     *            Operation / Phase Number
     */
    public void setSuperiorOperation( @Nullable final java.lang.String superiorOperation )
    {
        rememberChangedField("SuperiorOperation", this.superiorOperation);
        this.superiorOperation = superiorOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     * 
     * @param operationText
     *            Operation Short Text
     */
    public void setOperationText( @Nullable final java.lang.String operationText )
    {
        rememberChangedField("OperationText", this.operationText);
        this.operationText = operationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MasterRecipeRelationshipType</b>
     * </p>
     * 
     * @param masterRecipeRelationshipType
     *            Type of relationship
     */
    public void setMasterRecipeRelationshipType( @Nullable final java.lang.String masterRecipeRelationshipType )
    {
        rememberChangedField("MasterRecipeRelationshipType", this.masterRecipeRelationshipType);
        this.masterRecipeRelationshipType = masterRecipeRelationshipType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsSuccessor</b>
     * </p>
     * 
     * @param operationIsSuccessor
     *            Indicator: maintained after successor
     */
    public void setOperationIsSuccessor( @Nullable final java.lang.Boolean operationIsSuccessor )
    {
        rememberChangedField("OperationIsSuccessor", this.operationIsSuccessor);
        this.operationIsSuccessor = operationIsSuccessor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     * 
     * @param factoryCalendar
     *            Factory Calendar
     */
    public void setFactoryCalendar( @Nullable final java.lang.String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     * 
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final java.lang.String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaxTimeIntvlIsUsedForSchedg</b>
     * </p>
     * 
     * @param maxTimeIntvlIsUsedForSchedg
     *            Indicates whether maximum time interval will be considered
     */
    public void setMaxTimeIntvlIsUsedForSchedg( @Nullable final java.lang.Boolean maxTimeIntvlIsUsedForSchedg )
    {
        rememberChangedField("MaxTimeIntvlIsUsedForSchedg", this.maxTimeIntvlIsUsedForSchedg);
        this.maxTimeIntvlIsUsedForSchedg = maxTimeIntvlIsUsedForSchedg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOORelationshipType</b>
     * </p>
     * 
     * @param bOORelationshipType
     *            Key for type of relationship
     */
    public void setBOORelationshipType( @Nullable final java.lang.String bOORelationshipType )
    {
        rememberChangedField("BOORelationshipType", this.bOORelationshipType);
        this.bOORelationshipType = bOORelationshipType;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>TimeIntvlBtwnRelshp</b>
     * </p>
     * 
     * @param timeIntvlBtwnRelshp
     *            Time Interval Between Relationships
     */
    public void setTimeIntvlBtwnRelshp( @Nullable final BigDecimal timeIntvlBtwnRelshp )
    {
        rememberChangedField("TimeIntvlBtwnRelshp", this.timeIntvlBtwnRelshp);
        this.timeIntvlBtwnRelshp = timeIntvlBtwnRelshp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TimeIntvlBtwnRelshpUnit</b>
     * </p>
     * 
     * @param timeIntvlBtwnRelshpUnit
     *            Unit for the time interval between relationships
     */
    public void setTimeIntvlBtwnRelshpUnit( @Nullable final java.lang.String timeIntvlBtwnRelshpUnit )
    {
        rememberChangedField("TimeIntvlBtwnRelshpUnit", this.timeIntvlBtwnRelshpUnit);
        this.timeIntvlBtwnRelshpUnit = timeIntvlBtwnRelshpUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     * 
     * @param workCenterInternalID
     *            Object ID
     */
    public void setWorkCenterInternalID( @Nullable final java.lang.String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MaintenanceTaskListOpReltnshp";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("TaskListType", getTaskListType());
        entityKey.addKeyProperty("TaskListGroup", getTaskListGroup());
        entityKey.addKeyProperty("TaskListGroupCounter", getTaskListGroupCounter());
        entityKey.addKeyProperty("TaskListSequence", getTaskListSequence());
        entityKey.addKeyProperty("TaskListOperationInternalId", getTaskListOperationInternalId());
        entityKey.addKeyProperty("TaskListOpBOMItmIntVersCounter", getTaskListOpBOMItmIntVersCounter());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("TaskListType", getTaskListType());
        values.put("TaskListGroup", getTaskListGroup());
        values.put("TaskListGroupCounter", getTaskListGroupCounter());
        values.put("TaskListSequence", getTaskListSequence());
        values.put("TaskListOperationInternalId", getTaskListOperationInternalId());
        values.put("TaskListOpBOMItmIntVersCounter", getTaskListOpBOMItmIntVersCounter());
        values.put("MaintenanceTaskListOperation", getMaintenanceTaskListOperation());
        values.put("SuperiorOperation", getSuperiorOperation());
        values.put("OperationText", getOperationText());
        values.put("MasterRecipeRelationshipType", getMasterRecipeRelationshipType());
        values.put("OperationIsSuccessor", getOperationIsSuccessor());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("WorkCenter", getWorkCenter());
        values.put("Plant", getPlant());
        values.put("MaxTimeIntvlIsUsedForSchedg", getMaxTimeIntvlIsUsedForSchedg());
        values.put("BOORelationshipType", getBOORelationshipType());
        values.put("TimeIntvlBtwnRelshp", getTimeIntvlBtwnRelshp());
        values.put("TimeIntvlBtwnRelshpUnit", getTimeIntvlBtwnRelshpUnit());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("TaskListType") ) {
                final Object value = values.remove("TaskListType");
                if( (value == null) || (!value.equals(getTaskListType())) ) {
                    setTaskListType(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroup") ) {
                final Object value = values.remove("TaskListGroup");
                if( (value == null) || (!value.equals(getTaskListGroup())) ) {
                    setTaskListGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroupCounter") ) {
                final Object value = values.remove("TaskListGroupCounter");
                if( (value == null) || (!value.equals(getTaskListGroupCounter())) ) {
                    setTaskListGroupCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListSequence") ) {
                final Object value = values.remove("TaskListSequence");
                if( (value == null) || (!value.equals(getTaskListSequence())) ) {
                    setTaskListSequence(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListOperationInternalId") ) {
                final Object value = values.remove("TaskListOperationInternalId");
                if( (value == null) || (!value.equals(getTaskListOperationInternalId())) ) {
                    setTaskListOperationInternalId(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListOpBOMItmIntVersCounter") ) {
                final Object value = values.remove("TaskListOpBOMItmIntVersCounter");
                if( (value == null) || (!value.equals(getTaskListOpBOMItmIntVersCounter())) ) {
                    setTaskListOpBOMItmIntVersCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenanceTaskListOperation") ) {
                final Object value = values.remove("MaintenanceTaskListOperation");
                if( (value == null) || (!value.equals(getMaintenanceTaskListOperation())) ) {
                    setMaintenanceTaskListOperation(((java.lang.String) value));
                }
            }
            if( values.containsKey("SuperiorOperation") ) {
                final Object value = values.remove("SuperiorOperation");
                if( (value == null) || (!value.equals(getSuperiorOperation())) ) {
                    setSuperiorOperation(((java.lang.String) value));
                }
            }
            if( values.containsKey("OperationText") ) {
                final Object value = values.remove("OperationText");
                if( (value == null) || (!value.equals(getOperationText())) ) {
                    setOperationText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MasterRecipeRelationshipType") ) {
                final Object value = values.remove("MasterRecipeRelationshipType");
                if( (value == null) || (!value.equals(getMasterRecipeRelationshipType())) ) {
                    setMasterRecipeRelationshipType(((java.lang.String) value));
                }
            }
            if( values.containsKey("OperationIsSuccessor") ) {
                final Object value = values.remove("OperationIsSuccessor");
                if( (value == null) || (!value.equals(getOperationIsSuccessor())) ) {
                    setOperationIsSuccessor(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((java.lang.String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaxTimeIntvlIsUsedForSchedg") ) {
                final Object value = values.remove("MaxTimeIntvlIsUsedForSchedg");
                if( (value == null) || (!value.equals(getMaxTimeIntvlIsUsedForSchedg())) ) {
                    setMaxTimeIntvlIsUsedForSchedg(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("BOORelationshipType") ) {
                final Object value = values.remove("BOORelationshipType");
                if( (value == null) || (!value.equals(getBOORelationshipType())) ) {
                    setBOORelationshipType(((java.lang.String) value));
                }
            }
            if( values.containsKey("TimeIntvlBtwnRelshp") ) {
                final Object value = values.remove("TimeIntvlBtwnRelshp");
                if( (value == null) || (!value.equals(getTimeIntvlBtwnRelshp())) ) {
                    setTimeIntvlBtwnRelshp(((BigDecimal) value));
                }
            }
            if( values.containsKey("TimeIntvlBtwnRelshpUnit") ) {
                final Object value = values.remove("TimeIntvlBtwnRelshpUnit");
                if( (value == null) || (!value.equals(getTimeIntvlBtwnRelshpUnit())) ) {
                    setTimeIntvlBtwnRelshpUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_Operation") ) {
                final Object value = (values).remove("_Operation");
                if( value instanceof Iterable ) {
                    if( to_Operation == null ) {
                        to_Operation = Lists.newArrayList();
                    } else {
                        to_Operation = Lists.newArrayList(to_Operation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceTaskListOperation entity;
                        if( to_Operation.size() > i ) {
                            entity = to_Operation.get(i);
                        } else {
                            entity = new MaintenanceTaskListOperation();
                            to_Operation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MaintenanceTasklistService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_Operation != null ) {
            (values).put("_Operation", to_Operation);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>MaintenanceTaskListOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_Operation</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceTaskListOpReltnshp</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Operation</b> is already loaded, the result will contain
     *         the <b>MaintenanceTaskListOperation</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceTaskListOperation>> getOperationIfPresent()
    {
        return Option.of(to_Operation);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceTaskListOperation</b> entities for the loaded navigation property
     * <b>_Operation</b>.
     * <p>
     * If the navigation property <b>_Operation</b> of a queried <b>MaintenanceTaskListOpReltnshp</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>MaintenanceTaskListOperation</b> entities.
     */
    public void setOperation( @Nonnull final List<MaintenanceTaskListOperation> value )
    {
        if( to_Operation == null ) {
            to_Operation = Lists.newArrayList();
        }
        to_Operation.clear();
        to_Operation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceTaskListOperation</b> entities. This corresponds to the
     * OData navigation property <b>_Operation</b>.
     * <p>
     * If the navigation property <b>_Operation</b> of a queried <b>MaintenanceTaskListOpReltnshp</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>MaintenanceTaskListOperation</b> entities.
     */
    public void addOperation( MaintenanceTaskListOperation... entity )
    {
        if( to_Operation == null ) {
            to_Operation = Lists.newArrayList();
        }
        to_Operation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceTaskListOpReltnshp instances.
     * 
     */
    public final static class MaintenanceTaskListOpReltnshpBuilder
    {

        private List<MaintenanceTaskListOperation> to_Operation = Lists.newArrayList();

        private MaintenanceTaskListOpReltnshp.MaintenanceTaskListOpReltnshpBuilder to_Operation(
            final List<MaintenanceTaskListOperation> value )
        {
            to_Operation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_Operation</b> for <b>MaintenanceTaskListOpReltnshp</b> to multiple
         * <b>MaintenanceTaskListOperation</b>.
         * 
         * @param value
         *            The MaintenanceTaskListOperations to build this MaintenanceTaskListOpReltnshp with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceTaskListOpReltnshp.MaintenanceTaskListOpReltnshpBuilder operation(
            MaintenanceTaskListOperation... value )
        {
            return to_Operation(Lists.newArrayList(value));
        }

    }

}
