/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MaintenanceTasklistService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Operations
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceTaskListOperationType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MaintenanceTaskListOperation extends VdmEntity<MaintenanceTaskListOperation> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_maintenancetasklist.v0001.MaintenanceTaskListOperationType";
    /**
     * Selector for all available fields of MaintenanceTaskListOperation.
     * 
     */
    public final static SimpleProperty<MaintenanceTaskListOperation> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @return Task List Type
     */
    @Nullable
    @ElementName( "TaskListType" )
    private java.lang.String taskListType;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> TASK_LIST_TYPE =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "TaskListType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @return Key for Task List Group
     */
    @Nullable
    @ElementName( "TaskListGroup" )
    private java.lang.String taskListGroup;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> TASK_LIST_GROUP =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "TaskListGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @return Group Counter
     */
    @Nullable
    @ElementName( "TaskListGroupCounter" )
    private java.lang.String taskListGroupCounter;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> TASK_LIST_GROUP_COUNTER =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "TaskListGroupCounter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaskListSequence</b>
     * </p>
     * 
     * @return Sequence
     */
    @Nullable
    @ElementName( "TaskListSequence" )
    private java.lang.String taskListSequence;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> TASK_LIST_SEQUENCE =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "TaskListSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOperationInternalId</b>
     * </p>
     * 
     * @return Number of the Task List Node
     */
    @Nullable
    @ElementName( "TaskListOperationInternalId" )
    private java.lang.String taskListOperationInternalId;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> TASK_LIST_OPERATION_INTERNAL_ID =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "TaskListOperationInternalId");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOpBOMItmIntVersCounter</b>
     * </p>
     * 
     * @return Internal counter
     */
    @Nullable
    @ElementName( "TaskListOpBOMItmIntVersCounter" )
    private java.lang.String taskListOpBOMItmIntVersCounter;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> TASK_LIST_OP_BOM_ITM_INT_VERS_COUNTER =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "TaskListOpBOMItmIntVersCounter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListOperation</b>
     * </p>
     * 
     * @return Operation / Phase Number
     */
    @Nullable
    @ElementName( "MaintenanceTaskListOperation" )
    private java.lang.String maintenanceTaskListOperation;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> MAINTENANCE_TASK_LIST_OPERATION =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "MaintenanceTaskListOperation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOperationExecStageCode</b>
     * </p>
     * 
     * @return PRE MAIN POST
     */
    @Nullable
    @ElementName( "MaintOperationExecStageCode" )
    private java.lang.String maintOperationExecStageCode;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> MAINT_OPERATION_EXEC_STAGE_CODE =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "MaintOperationExecStageCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     * 
     * @return Operation Short Text
     */
    @Nullable
    @ElementName( "OperationText" )
    private java.lang.String operationText;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> OPERATION_TEXT =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "OperationText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     * 
     * @return Control Key
     */
    @Nullable
    @ElementName( "OperationControlProfile" )
    private java.lang.String operationControlProfile;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> OPERATION_CONTROL_PROFILE =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "OperationControlProfile");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     * 
     * @return Work Center
     */
    @Nullable
    @ElementName( "WorkCenter" )
    private java.lang.String workCenter;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> WORK_CENTER =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> PLANT =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "Plant");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     * 
     * @return Assembly
     */
    @Nullable
    @ElementName( "Assembly" )
    private java.lang.String assembly;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> ASSEMBLY =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "Assembly");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationCalculationControl</b>
     * </p>
     * 
     * @return Key for calculation
     */
    @Nullable
    @ElementName( "OperationCalculationControl" )
    private java.lang.String operationCalculationControl;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> OPERATION_CALCULATION_CONTROL =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "OperationCalculationControl");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OpPlannedWorkQuantity</b>
     * </p>
     * 
     * @return The opPlannedWorkQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "OpPlannedWorkQuantity" )
    @DecimalDescriptor( precision = 7, scale = 1 )
    private BigDecimal opPlannedWorkQuantity;
    public final static SimpleProperty.NumericDecimal<MaintenanceTaskListOperation> OP_PLANNED_WORK_QUANTITY =
        new SimpleProperty.NumericDecimal<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "OpPlannedWorkQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit</b>
     * </p>
     * 
     * @return Unit for Work
     */
    @Nullable
    @ElementName( "OpWorkQuantityUnit" )
    private java.lang.String opWorkQuantityUnit;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> OP_WORK_QUANTITY_UNIT =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "OpWorkQuantityUnit");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfCapacities</b>
     * </p>
     * 
     * @return Number of capacities required
     */
    @Nullable
    @ElementName( "NumberOfCapacities" )
    private Short numberOfCapacities;
    public final static SimpleProperty.NumericInteger<MaintenanceTaskListOperation> NUMBER_OF_CAPACITIES =
        new SimpleProperty.NumericInteger<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "NumberOfCapacities");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQty</b>
     * </p>
     * 
     * @return The purchaseOrderQty contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "PurchaseOrderQty" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal purchaseOrderQty;
    public final static SimpleProperty.NumericDecimal<MaintenanceTaskListOperation> PURCHASE_ORDER_QTY =
        new SimpleProperty.NumericDecimal<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "PurchaseOrderQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     * 
     * @return Operation order quantity unit
     */
    @Nullable
    @ElementName( "PurchaseOrderQuantityUnit" )
    private java.lang.String purchaseOrderQuantityUnit;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> PURCHASE_ORDER_QUANTITY_UNIT =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "PurchaseOrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationStandardDuration</b>
     * </p>
     * 
     * @return Normal Duration of Activity
     */
    @Nullable
    @ElementName( "OperationStandardDuration" )
    @DecimalDescriptor( precision = 5, scale = 1 )
    private BigDecimal operationStandardDuration;
    public final static SimpleProperty.NumericDecimal<MaintenanceTaskListOperation> OPERATION_STANDARD_DURATION =
        new SimpleProperty.NumericDecimal<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "OperationStandardDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationStandardDurationUnit</b>
     * </p>
     * 
     * @return Normal Duration/Unit
     */
    @Nullable
    @ElementName( "OperationStandardDurationUnit" )
    private java.lang.String operationStandardDurationUnit;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> OPERATION_STANDARD_DURATION_UNIT =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "OperationStandardDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     * 
     * @return Activity Type
     */
    @Nullable
    @ElementName( "CostCtrActivityType" )
    private java.lang.String costCtrActivityType;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> COST_CTR_ACTIVITY_TYPE =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "CostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     * 
     * @return Material Group
     */
    @Nullable
    @ElementName( "MaterialGroup" )
    private java.lang.String materialGroup;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> MATERIAL_GROUP =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "MaterialGroup");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingPrice</b>
     * </p>
     * 
     * @return The opExternalProcessingPrice contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "OpExternalProcessingPrice" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal opExternalProcessingPrice;
    public final static SimpleProperty.NumericDecimal<MaintenanceTaskListOperation> OP_EXTERNAL_PROCESSING_PRICE =
        new SimpleProperty.NumericDecimal<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "OpExternalProcessingPrice");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingCurrency</b>
     * </p>
     * 
     * @return Currency Key
     */
    @Nullable
    @ElementName( "OpExternalProcessingCurrency" )
    private java.lang.String opExternalProcessingCurrency;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> OP_EXTERNAL_PROCESSING_CURRENCY =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "OpExternalProcessingCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostElement</b>
     * </p>
     * 
     * @return Cost Element
     */
    @Nullable
    @ElementName( "CostElement" )
    private java.lang.String costElement;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> COST_ELEMENT =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "CostElement");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     * 
     * @return Purchasing Group for External Processing Activity
     */
    @Nullable
    @ElementName( "PurchasingGroup" )
    private java.lang.String purchasingGroup;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> PURCHASING_GROUP =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     * 
     * @return Purchasing Organization
     */
    @Nullable
    @ElementName( "PurchasingOrganization" )
    private java.lang.String purchasingOrganization;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> PURCHASING_ORGANIZATION =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     * 
     * @return Purchasing Document Number
     */
    @Nullable
    @ElementName( "PurchaseContract" )
    private java.lang.String purchaseContract;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> PURCHASE_CONTRACT =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "PurchaseContract");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     * 
     * @return Item Number of Purchasing Document
     */
    @Nullable
    @ElementName( "PurchaseContractItem" )
    private java.lang.String purchaseContractItem;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> PURCHASE_CONTRACT_ITEM =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "PurchaseContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     * 
     * @return Account Number of Supplier
     */
    @Nullable
    @ElementName( "Supplier" )
    private java.lang.String supplier;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> SUPPLIER =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     * 
     * @return Change Number
     */
    @Nullable
    @ElementName( "ChangeNumber" )
    private java.lang.String changeNumber;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> CHANGE_NUMBER =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     * 
     * @return Number of purchasing info record
     */
    @Nullable
    @ElementName( "PurchasingInfoRecord" )
    private java.lang.String purchasingInfoRecord;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> PURCHASING_INFO_RECORD =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "PurchasingInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     * 
     * @return Business Purpose Completed Flag
     */
    @Nullable
    @ElementName( "IsBusinessPurposeCompleted" )
    private java.lang.String isBusinessPurposeCompleted;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> IS_BUSINESS_PURPOSE_COMPLETED =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "IsBusinessPurposeCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplierAccountGroup</b>
     * </p>
     * 
     * @return Supplier Account Group
     */
    @Nullable
    @ElementName( "SupplierAccountGroup" )
    private java.lang.String supplierAccountGroup;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> SUPPLIER_ACCOUNT_GROUP =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "SupplierAccountGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     * 
     * @return Authorization Group
     */
    @Nullable
    @ElementName( "AuthorizationGroup" )
    private java.lang.String authorizationGroup;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> AUTHORIZATION_GROUP =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "AuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaskListStatus</b>
     * </p>
     * 
     * @return Status
     */
    @Nullable
    @ElementName( "TaskListStatus" )
    private java.lang.String taskListStatus;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> TASK_LIST_STATUS =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "TaskListStatus");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePlannerGroup</b>
     * </p>
     * 
     * @return Responsible Planner Group or Department
     */
    @Nullable
    @ElementName( "ResponsiblePlannerGroup" )
    private java.lang.String responsiblePlannerGroup;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> RESPONSIBLE_PLANNER_GROUP =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "ResponsiblePlannerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanningPlant</b>
     * </p>
     * 
     * @return Maintenance Planning Plant
     */
    @Nullable
    @ElementName( "MaintenancePlanningPlant" )
    private java.lang.String maintenancePlanningPlant;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> MAINTENANCE_PLANNING_PLANT =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "MaintenancePlanningPlant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlannerGroup</b>
     * </p>
     * 
     * @return Planner Group for Customer Service and Plant Maintenance
     */
    @Nullable
    @ElementName( "MaintenancePlannerGroup" )
    private java.lang.String maintenancePlannerGroup;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> MAINTENANCE_PLANNER_GROUP =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "MaintenancePlannerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     * 
     * @return Controlling Area
     */
    @Nullable
    @ElementName( "ControllingArea" )
    private java.lang.String controllingArea;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> CONTROLLING_AREA =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     * 
     * @return Cost Center
     */
    @Nullable
    @ElementName( "CostCenter" )
    private java.lang.String costCenter;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> COST_CENTER =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlant</b>
     * </p>
     * 
     * @return Maintenance Plant
     */
    @Nullable
    @ElementName( "MaintenancePlant" )
    private java.lang.String maintenancePlant;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> MAINTENANCE_PLANT =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "MaintenancePlant");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Valid-From Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<MaintenanceTaskListOperation> VALIDITY_START_DATE =
        new SimpleProperty.Date<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "ValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Valid-To Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<MaintenanceTaskListOperation> VALIDITY_END_DATE =
        new SimpleProperty.Date<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObject</b>
     * </p>
     * 
     * @return Technical Object
     */
    @Nullable
    @ElementName( "TechnicalObject" )
    private java.lang.String technicalObject;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> TECHNICAL_OBJECT =
        new SimpleProperty.String<MaintenanceTaskListOperation>(MaintenanceTaskListOperation.class, "TechnicalObject");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TechObjIsEquipOrFuncnlLoc</b>
     * </p>
     * 
     * @return Technical Object Type
     */
    @Nullable
    @ElementName( "TechObjIsEquipOrFuncnlLoc" )
    private java.lang.String techObjIsEquipOrFuncnlLoc;
    public final static SimpleProperty.String<MaintenanceTaskListOperation> TECH_OBJ_IS_EQUIP_OR_FUNCNL_LOC =
        new SimpleProperty.String<MaintenanceTaskListOperation>(
            MaintenanceTaskListOperation.class,
            "TechObjIsEquipOrFuncnlLoc");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskListOperation, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskListOperation, SAP__Message>(
            MaintenanceTaskListOperation.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_OpLongText</b> for <b>MaintenanceTaskListOperation</b> to single
     * <b>MaintenanceTaskListOpLongText</b>.
     * 
     */
    @ElementName( "_OpLongText" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceTaskListOpLongText to_OpLongText;
    /**
     * Navigation property <b>_OpMaterial</b> for <b>MaintenanceTaskListOperation</b> to multiple
     * <b>MaintenanceTaskListOpMat</b>.
     * 
     */
    @ElementName( "_OpMaterial" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceTaskListOpMat> to_OpMaterial;
    /**
     * Navigation property <b>_OpRelation</b> for <b>MaintenanceTaskListOperation</b> to multiple
     * <b>MaintenanceTaskListOpReltnshp</b>.
     * 
     */
    @ElementName( "_OpRelation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceTaskListOpReltnshp> to_OpRelation;
    /**
     * Navigation property <b>_SubOp</b> for <b>MaintenanceTaskListOperation</b> to multiple
     * <b>MaintenanceTaskListSubOp</b>.
     * 
     */
    @ElementName( "_SubOp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceTaskListSubOp> to_SubOp;
    /**
     * Use with available request builders to apply the <b>_OpLongText</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MaintenanceTaskListOperation, MaintenanceTaskListOpLongText> TO__OP_LONG_TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MaintenanceTaskListOperation, MaintenanceTaskListOpLongText>(
            MaintenanceTaskListOperation.class,
            "_OpLongText",
            MaintenanceTaskListOpLongText.class);
    /**
     * Use with available request builders to apply the <b>_OpMaterial</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MaintenanceTaskListOperation, MaintenanceTaskListOpMat> TO__OP_MATERIAL =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MaintenanceTaskListOperation, MaintenanceTaskListOpMat>(
            MaintenanceTaskListOperation.class,
            "_OpMaterial",
            MaintenanceTaskListOpMat.class);
    /**
     * Use with available request builders to apply the <b>_OpRelation</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MaintenanceTaskListOperation, MaintenanceTaskListOpReltnshp> TO__OP_RELATION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MaintenanceTaskListOperation, MaintenanceTaskListOpReltnshp>(
            MaintenanceTaskListOperation.class,
            "_OpRelation",
            MaintenanceTaskListOpReltnshp.class);
    /**
     * Use with available request builders to apply the <b>_SubOp</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MaintenanceTaskListOperation, MaintenanceTaskListSubOp> TO__SUB_OP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MaintenanceTaskListOperation, MaintenanceTaskListSubOp>(
            MaintenanceTaskListOperation.class,
            "_SubOp",
            MaintenanceTaskListSubOp.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MaintenanceTaskListOperation> getType()
    {
        return MaintenanceTaskListOperation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @param taskListType
     *            Task List Type
     */
    public void setTaskListType( @Nullable final java.lang.String taskListType )
    {
        rememberChangedField("TaskListType", this.taskListType);
        this.taskListType = taskListType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @param taskListGroup
     *            Key for Task List Group
     */
    public void setTaskListGroup( @Nullable final java.lang.String taskListGroup )
    {
        rememberChangedField("TaskListGroup", this.taskListGroup);
        this.taskListGroup = taskListGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @param taskListGroupCounter
     *            Group Counter
     */
    public void setTaskListGroupCounter( @Nullable final java.lang.String taskListGroupCounter )
    {
        rememberChangedField("TaskListGroupCounter", this.taskListGroupCounter);
        this.taskListGroupCounter = taskListGroupCounter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaskListSequence</b>
     * </p>
     * 
     * @param taskListSequence
     *            Sequence
     */
    public void setTaskListSequence( @Nullable final java.lang.String taskListSequence )
    {
        rememberChangedField("TaskListSequence", this.taskListSequence);
        this.taskListSequence = taskListSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOperationInternalId</b>
     * </p>
     * 
     * @param taskListOperationInternalId
     *            Number of the Task List Node
     */
    public void setTaskListOperationInternalId( @Nullable final java.lang.String taskListOperationInternalId )
    {
        rememberChangedField("TaskListOperationInternalId", this.taskListOperationInternalId);
        this.taskListOperationInternalId = taskListOperationInternalId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOpBOMItmIntVersCounter</b>
     * </p>
     * 
     * @param taskListOpBOMItmIntVersCounter
     *            Internal counter
     */
    public void setTaskListOpBOMItmIntVersCounter( @Nullable final java.lang.String taskListOpBOMItmIntVersCounter )
    {
        rememberChangedField("TaskListOpBOMItmIntVersCounter", this.taskListOpBOMItmIntVersCounter);
        this.taskListOpBOMItmIntVersCounter = taskListOpBOMItmIntVersCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListOperation</b>
     * </p>
     * 
     * @param maintenanceTaskListOperation
     *            Operation / Phase Number
     */
    public void setMaintenanceTaskListOperation( @Nullable final java.lang.String maintenanceTaskListOperation )
    {
        rememberChangedField("MaintenanceTaskListOperation", this.maintenanceTaskListOperation);
        this.maintenanceTaskListOperation = maintenanceTaskListOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOperationExecStageCode</b>
     * </p>
     * 
     * @param maintOperationExecStageCode
     *            PRE MAIN POST
     */
    public void setMaintOperationExecStageCode( @Nullable final java.lang.String maintOperationExecStageCode )
    {
        rememberChangedField("MaintOperationExecStageCode", this.maintOperationExecStageCode);
        this.maintOperationExecStageCode = maintOperationExecStageCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     * 
     * @param operationText
     *            Operation Short Text
     */
    public void setOperationText( @Nullable final java.lang.String operationText )
    {
        rememberChangedField("OperationText", this.operationText);
        this.operationText = operationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     * 
     * @param operationControlProfile
     *            Control Key
     */
    public void setOperationControlProfile( @Nullable final java.lang.String operationControlProfile )
    {
        rememberChangedField("OperationControlProfile", this.operationControlProfile);
        this.operationControlProfile = operationControlProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     * 
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final java.lang.String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     * 
     * @param assembly
     *            Assembly
     */
    public void setAssembly( @Nullable final java.lang.String assembly )
    {
        rememberChangedField("Assembly", this.assembly);
        this.assembly = assembly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationCalculationControl</b>
     * </p>
     * 
     * @param operationCalculationControl
     *            Key for calculation
     */
    public void setOperationCalculationControl( @Nullable final java.lang.String operationCalculationControl )
    {
        rememberChangedField("OperationCalculationControl", this.operationCalculationControl);
        this.operationCalculationControl = operationCalculationControl;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OpPlannedWorkQuantity</b>
     * </p>
     * 
     * @param opPlannedWorkQuantity
     *            The opPlannedWorkQuantity to set.
     */
    public void setOpPlannedWorkQuantity( @Nullable final BigDecimal opPlannedWorkQuantity )
    {
        rememberChangedField("OpPlannedWorkQuantity", this.opPlannedWorkQuantity);
        this.opPlannedWorkQuantity = opPlannedWorkQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpWorkQuantityUnit</b>
     * </p>
     * 
     * @param opWorkQuantityUnit
     *            Unit for Work
     */
    public void setOpWorkQuantityUnit( @Nullable final java.lang.String opWorkQuantityUnit )
    {
        rememberChangedField("OpWorkQuantityUnit", this.opWorkQuantityUnit);
        this.opWorkQuantityUnit = opWorkQuantityUnit;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfCapacities</b>
     * </p>
     * 
     * @param numberOfCapacities
     *            Number of capacities required
     */
    public void setNumberOfCapacities( @Nullable final Short numberOfCapacities )
    {
        rememberChangedField("NumberOfCapacities", this.numberOfCapacities);
        this.numberOfCapacities = numberOfCapacities;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQty</b>
     * </p>
     * 
     * @param purchaseOrderQty
     *            The purchaseOrderQty to set.
     */
    public void setPurchaseOrderQty( @Nullable final BigDecimal purchaseOrderQty )
    {
        rememberChangedField("PurchaseOrderQty", this.purchaseOrderQty);
        this.purchaseOrderQty = purchaseOrderQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderQuantityUnit</b>
     * </p>
     * 
     * @param purchaseOrderQuantityUnit
     *            Operation order quantity unit
     */
    public void setPurchaseOrderQuantityUnit( @Nullable final java.lang.String purchaseOrderQuantityUnit )
    {
        rememberChangedField("PurchaseOrderQuantityUnit", this.purchaseOrderQuantityUnit);
        this.purchaseOrderQuantityUnit = purchaseOrderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationStandardDuration</b>
     * </p>
     * 
     * @param operationStandardDuration
     *            Normal Duration of Activity
     */
    public void setOperationStandardDuration( @Nullable final BigDecimal operationStandardDuration )
    {
        rememberChangedField("OperationStandardDuration", this.operationStandardDuration);
        this.operationStandardDuration = operationStandardDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationStandardDurationUnit</b>
     * </p>
     * 
     * @param operationStandardDurationUnit
     *            Normal Duration/Unit
     */
    public void setOperationStandardDurationUnit( @Nullable final java.lang.String operationStandardDurationUnit )
    {
        rememberChangedField("OperationStandardDurationUnit", this.operationStandardDurationUnit);
        this.operationStandardDurationUnit = operationStandardDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     * 
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final java.lang.String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     * 
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final java.lang.String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingPrice</b>
     * </p>
     * 
     * @param opExternalProcessingPrice
     *            The opExternalProcessingPrice to set.
     */
    public void setOpExternalProcessingPrice( @Nullable final BigDecimal opExternalProcessingPrice )
    {
        rememberChangedField("OpExternalProcessingPrice", this.opExternalProcessingPrice);
        this.opExternalProcessingPrice = opExternalProcessingPrice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingCurrency</b>
     * </p>
     * 
     * @param opExternalProcessingCurrency
     *            Currency Key
     */
    public void setOpExternalProcessingCurrency( @Nullable final java.lang.String opExternalProcessingCurrency )
    {
        rememberChangedField("OpExternalProcessingCurrency", this.opExternalProcessingCurrency);
        this.opExternalProcessingCurrency = opExternalProcessingCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostElement</b>
     * </p>
     * 
     * @param costElement
     *            Cost Element
     */
    public void setCostElement( @Nullable final java.lang.String costElement )
    {
        rememberChangedField("CostElement", this.costElement);
        this.costElement = costElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     * 
     * @param purchasingGroup
     *            Purchasing Group for External Processing Activity
     */
    public void setPurchasingGroup( @Nullable final java.lang.String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     * 
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final java.lang.String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     * 
     * @param purchaseContract
     *            Purchasing Document Number
     */
    public void setPurchaseContract( @Nullable final java.lang.String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     * 
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseContractItem( @Nullable final java.lang.String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     * 
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final java.lang.String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     * 
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final java.lang.String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     * 
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setPurchasingInfoRecord( @Nullable final java.lang.String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     * 
     * @param isBusinessPurposeCompleted
     *            Business Purpose Completed Flag
     */
    public void setIsBusinessPurposeCompleted( @Nullable final java.lang.String isBusinessPurposeCompleted )
    {
        rememberChangedField("IsBusinessPurposeCompleted", this.isBusinessPurposeCompleted);
        this.isBusinessPurposeCompleted = isBusinessPurposeCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplierAccountGroup</b>
     * </p>
     * 
     * @param supplierAccountGroup
     *            Supplier Account Group
     */
    public void setSupplierAccountGroup( @Nullable final java.lang.String supplierAccountGroup )
    {
        rememberChangedField("SupplierAccountGroup", this.supplierAccountGroup);
        this.supplierAccountGroup = supplierAccountGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     * 
     * @param authorizationGroup
     *            Authorization Group
     */
    public void setAuthorizationGroup( @Nullable final java.lang.String authorizationGroup )
    {
        rememberChangedField("AuthorizationGroup", this.authorizationGroup);
        this.authorizationGroup = authorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaskListStatus</b>
     * </p>
     * 
     * @param taskListStatus
     *            Status
     */
    public void setTaskListStatus( @Nullable final java.lang.String taskListStatus )
    {
        rememberChangedField("TaskListStatus", this.taskListStatus);
        this.taskListStatus = taskListStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePlannerGroup</b>
     * </p>
     * 
     * @param responsiblePlannerGroup
     *            Responsible Planner Group or Department
     */
    public void setResponsiblePlannerGroup( @Nullable final java.lang.String responsiblePlannerGroup )
    {
        rememberChangedField("ResponsiblePlannerGroup", this.responsiblePlannerGroup);
        this.responsiblePlannerGroup = responsiblePlannerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanningPlant</b>
     * </p>
     * 
     * @param maintenancePlanningPlant
     *            Maintenance Planning Plant
     */
    public void setMaintenancePlanningPlant( @Nullable final java.lang.String maintenancePlanningPlant )
    {
        rememberChangedField("MaintenancePlanningPlant", this.maintenancePlanningPlant);
        this.maintenancePlanningPlant = maintenancePlanningPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlannerGroup</b>
     * </p>
     * 
     * @param maintenancePlannerGroup
     *            Planner Group for Customer Service and Plant Maintenance
     */
    public void setMaintenancePlannerGroup( @Nullable final java.lang.String maintenancePlannerGroup )
    {
        rememberChangedField("MaintenancePlannerGroup", this.maintenancePlannerGroup);
        this.maintenancePlannerGroup = maintenancePlannerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     * 
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final java.lang.String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     * 
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final java.lang.String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlant</b>
     * </p>
     * 
     * @param maintenancePlant
     *            Maintenance Plant
     */
    public void setMaintenancePlant( @Nullable final java.lang.String maintenancePlant )
    {
        rememberChangedField("MaintenancePlant", this.maintenancePlant);
        this.maintenancePlant = maintenancePlant;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObject</b>
     * </p>
     * 
     * @param technicalObject
     *            Technical Object
     */
    public void setTechnicalObject( @Nullable final java.lang.String technicalObject )
    {
        rememberChangedField("TechnicalObject", this.technicalObject);
        this.technicalObject = technicalObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TechObjIsEquipOrFuncnlLoc</b>
     * </p>
     * 
     * @param techObjIsEquipOrFuncnlLoc
     *            Technical Object Type
     */
    public void setTechObjIsEquipOrFuncnlLoc( @Nullable final java.lang.String techObjIsEquipOrFuncnlLoc )
    {
        rememberChangedField("TechObjIsEquipOrFuncnlLoc", this.techObjIsEquipOrFuncnlLoc);
        this.techObjIsEquipOrFuncnlLoc = techObjIsEquipOrFuncnlLoc;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MaintenanceTaskListOperation";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("TaskListType", getTaskListType());
        entityKey.addKeyProperty("TaskListGroup", getTaskListGroup());
        entityKey.addKeyProperty("TaskListGroupCounter", getTaskListGroupCounter());
        entityKey.addKeyProperty("TaskListSequence", getTaskListSequence());
        entityKey.addKeyProperty("TaskListOperationInternalId", getTaskListOperationInternalId());
        entityKey.addKeyProperty("TaskListOpBOMItmIntVersCounter", getTaskListOpBOMItmIntVersCounter());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("TaskListType", getTaskListType());
        values.put("TaskListGroup", getTaskListGroup());
        values.put("TaskListGroupCounter", getTaskListGroupCounter());
        values.put("TaskListSequence", getTaskListSequence());
        values.put("TaskListOperationInternalId", getTaskListOperationInternalId());
        values.put("TaskListOpBOMItmIntVersCounter", getTaskListOpBOMItmIntVersCounter());
        values.put("MaintenanceTaskListOperation", getMaintenanceTaskListOperation());
        values.put("MaintOperationExecStageCode", getMaintOperationExecStageCode());
        values.put("OperationText", getOperationText());
        values.put("OperationControlProfile", getOperationControlProfile());
        values.put("WorkCenter", getWorkCenter());
        values.put("Plant", getPlant());
        values.put("Assembly", getAssembly());
        values.put("OperationCalculationControl", getOperationCalculationControl());
        values.put("OpPlannedWorkQuantity", getOpPlannedWorkQuantity());
        values.put("OpWorkQuantityUnit", getOpWorkQuantityUnit());
        values.put("NumberOfCapacities", getNumberOfCapacities());
        values.put("PurchaseOrderQty", getPurchaseOrderQty());
        values.put("PurchaseOrderQuantityUnit", getPurchaseOrderQuantityUnit());
        values.put("OperationStandardDuration", getOperationStandardDuration());
        values.put("OperationStandardDurationUnit", getOperationStandardDurationUnit());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("OpExternalProcessingPrice", getOpExternalProcessingPrice());
        values.put("OpExternalProcessingCurrency", getOpExternalProcessingCurrency());
        values.put("CostElement", getCostElement());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchaseContract", getPurchaseContract());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("Supplier", getSupplier());
        values.put("ChangeNumber", getChangeNumber());
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        values.put("IsBusinessPurposeCompleted", getIsBusinessPurposeCompleted());
        values.put("SupplierAccountGroup", getSupplierAccountGroup());
        values.put("AuthorizationGroup", getAuthorizationGroup());
        values.put("TaskListStatus", getTaskListStatus());
        values.put("ResponsiblePlannerGroup", getResponsiblePlannerGroup());
        values.put("MaintenancePlanningPlant", getMaintenancePlanningPlant());
        values.put("MaintenancePlannerGroup", getMaintenancePlannerGroup());
        values.put("ControllingArea", getControllingArea());
        values.put("CostCenter", getCostCenter());
        values.put("MaintenancePlant", getMaintenancePlant());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("TechnicalObject", getTechnicalObject());
        values.put("TechObjIsEquipOrFuncnlLoc", getTechObjIsEquipOrFuncnlLoc());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("TaskListType") ) {
                final Object value = values.remove("TaskListType");
                if( (value == null) || (!value.equals(getTaskListType())) ) {
                    setTaskListType(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroup") ) {
                final Object value = values.remove("TaskListGroup");
                if( (value == null) || (!value.equals(getTaskListGroup())) ) {
                    setTaskListGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroupCounter") ) {
                final Object value = values.remove("TaskListGroupCounter");
                if( (value == null) || (!value.equals(getTaskListGroupCounter())) ) {
                    setTaskListGroupCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListSequence") ) {
                final Object value = values.remove("TaskListSequence");
                if( (value == null) || (!value.equals(getTaskListSequence())) ) {
                    setTaskListSequence(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListOperationInternalId") ) {
                final Object value = values.remove("TaskListOperationInternalId");
                if( (value == null) || (!value.equals(getTaskListOperationInternalId())) ) {
                    setTaskListOperationInternalId(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListOpBOMItmIntVersCounter") ) {
                final Object value = values.remove("TaskListOpBOMItmIntVersCounter");
                if( (value == null) || (!value.equals(getTaskListOpBOMItmIntVersCounter())) ) {
                    setTaskListOpBOMItmIntVersCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenanceTaskListOperation") ) {
                final Object value = values.remove("MaintenanceTaskListOperation");
                if( (value == null) || (!value.equals(getMaintenanceTaskListOperation())) ) {
                    setMaintenanceTaskListOperation(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintOperationExecStageCode") ) {
                final Object value = values.remove("MaintOperationExecStageCode");
                if( (value == null) || (!value.equals(getMaintOperationExecStageCode())) ) {
                    setMaintOperationExecStageCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("OperationText") ) {
                final Object value = values.remove("OperationText");
                if( (value == null) || (!value.equals(getOperationText())) ) {
                    setOperationText(((java.lang.String) value));
                }
            }
            if( values.containsKey("OperationControlProfile") ) {
                final Object value = values.remove("OperationControlProfile");
                if( (value == null) || (!value.equals(getOperationControlProfile())) ) {
                    setOperationControlProfile(((java.lang.String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("Assembly") ) {
                final Object value = values.remove("Assembly");
                if( (value == null) || (!value.equals(getAssembly())) ) {
                    setAssembly(((java.lang.String) value));
                }
            }
            if( values.containsKey("OperationCalculationControl") ) {
                final Object value = values.remove("OperationCalculationControl");
                if( (value == null) || (!value.equals(getOperationCalculationControl())) ) {
                    setOperationCalculationControl(((java.lang.String) value));
                }
            }
            if( values.containsKey("OpPlannedWorkQuantity") ) {
                final Object value = values.remove("OpPlannedWorkQuantity");
                if( (value == null) || (!value.equals(getOpPlannedWorkQuantity())) ) {
                    setOpPlannedWorkQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit") ) {
                final Object value = values.remove("OpWorkQuantityUnit");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit())) ) {
                    setOpWorkQuantityUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("NumberOfCapacities") ) {
                final Object value = values.remove("NumberOfCapacities");
                if( (value == null) || (!value.equals(getNumberOfCapacities())) ) {
                    setNumberOfCapacities(((Short) value));
                }
            }
            if( values.containsKey("PurchaseOrderQty") ) {
                final Object value = values.remove("PurchaseOrderQty");
                if( (value == null) || (!value.equals(getPurchaseOrderQty())) ) {
                    setPurchaseOrderQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchaseOrderQuantityUnit") ) {
                final Object value = values.remove("PurchaseOrderQuantityUnit");
                if( (value == null) || (!value.equals(getPurchaseOrderQuantityUnit())) ) {
                    setPurchaseOrderQuantityUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("OperationStandardDuration") ) {
                final Object value = values.remove("OperationStandardDuration");
                if( (value == null) || (!value.equals(getOperationStandardDuration())) ) {
                    setOperationStandardDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("OperationStandardDurationUnit") ) {
                final Object value = values.remove("OperationStandardDurationUnit");
                if( (value == null) || (!value.equals(getOperationStandardDurationUnit())) ) {
                    setOperationStandardDurationUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("OpExternalProcessingPrice") ) {
                final Object value = values.remove("OpExternalProcessingPrice");
                if( (value == null) || (!value.equals(getOpExternalProcessingPrice())) ) {
                    setOpExternalProcessingPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpExternalProcessingCurrency") ) {
                final Object value = values.remove("OpExternalProcessingCurrency");
                if( (value == null) || (!value.equals(getOpExternalProcessingCurrency())) ) {
                    setOpExternalProcessingCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CostElement") ) {
                final Object value = values.remove("CostElement");
                if( (value == null) || (!value.equals(getCostElement())) ) {
                    setCostElement(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((java.lang.String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((java.lang.String) value));
                }
            }
            if( values.containsKey("IsBusinessPurposeCompleted") ) {
                final Object value = values.remove("IsBusinessPurposeCompleted");
                if( (value == null) || (!value.equals(getIsBusinessPurposeCompleted())) ) {
                    setIsBusinessPurposeCompleted(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupplierAccountGroup") ) {
                final Object value = values.remove("SupplierAccountGroup");
                if( (value == null) || (!value.equals(getSupplierAccountGroup())) ) {
                    setSupplierAccountGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("AuthorizationGroup") ) {
                final Object value = values.remove("AuthorizationGroup");
                if( (value == null) || (!value.equals(getAuthorizationGroup())) ) {
                    setAuthorizationGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListStatus") ) {
                final Object value = values.remove("TaskListStatus");
                if( (value == null) || (!value.equals(getTaskListStatus())) ) {
                    setTaskListStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("ResponsiblePlannerGroup") ) {
                final Object value = values.remove("ResponsiblePlannerGroup");
                if( (value == null) || (!value.equals(getResponsiblePlannerGroup())) ) {
                    setResponsiblePlannerGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenancePlanningPlant") ) {
                final Object value = values.remove("MaintenancePlanningPlant");
                if( (value == null) || (!value.equals(getMaintenancePlanningPlant())) ) {
                    setMaintenancePlanningPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenancePlannerGroup") ) {
                final Object value = values.remove("MaintenancePlannerGroup");
                if( (value == null) || (!value.equals(getMaintenancePlannerGroup())) ) {
                    setMaintenancePlannerGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenancePlant") ) {
                final Object value = values.remove("MaintenancePlant");
                if( (value == null) || (!value.equals(getMaintenancePlant())) ) {
                    setMaintenancePlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("TechnicalObject") ) {
                final Object value = values.remove("TechnicalObject");
                if( (value == null) || (!value.equals(getTechnicalObject())) ) {
                    setTechnicalObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("TechObjIsEquipOrFuncnlLoc") ) {
                final Object value = values.remove("TechObjIsEquipOrFuncnlLoc");
                if( (value == null) || (!value.equals(getTechObjIsEquipOrFuncnlLoc())) ) {
                    setTechObjIsEquipOrFuncnlLoc(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_OpLongText") ) {
                final Object value = (values).remove("_OpLongText");
                if( value instanceof Map ) {
                    if( to_OpLongText == null ) {
                        to_OpLongText = new MaintenanceTaskListOpLongText();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_OpLongText.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_OpMaterial") ) {
                final Object value = (values).remove("_OpMaterial");
                if( value instanceof Iterable ) {
                    if( to_OpMaterial == null ) {
                        to_OpMaterial = Lists.newArrayList();
                    } else {
                        to_OpMaterial = Lists.newArrayList(to_OpMaterial);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceTaskListOpMat entity;
                        if( to_OpMaterial.size() > i ) {
                            entity = to_OpMaterial.get(i);
                        } else {
                            entity = new MaintenanceTaskListOpMat();
                            to_OpMaterial.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_OpRelation") ) {
                final Object value = (values).remove("_OpRelation");
                if( value instanceof Iterable ) {
                    if( to_OpRelation == null ) {
                        to_OpRelation = Lists.newArrayList();
                    } else {
                        to_OpRelation = Lists.newArrayList(to_OpRelation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceTaskListOpReltnshp entity;
                        if( to_OpRelation.size() > i ) {
                            entity = to_OpRelation.get(i);
                        } else {
                            entity = new MaintenanceTaskListOpReltnshp();
                            to_OpRelation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_SubOp") ) {
                final Object value = (values).remove("_SubOp");
                if( value instanceof Iterable ) {
                    if( to_SubOp == null ) {
                        to_SubOp = Lists.newArrayList();
                    } else {
                        to_SubOp = Lists.newArrayList(to_SubOp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceTaskListSubOp entity;
                        if( to_SubOp.size() > i ) {
                            entity = to_SubOp.get(i);
                        } else {
                            entity = new MaintenanceTaskListSubOp();
                            to_SubOp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MaintenanceTasklistService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_OpLongText != null ) {
            (values).put("_OpLongText", to_OpLongText);
        }
        if( to_OpMaterial != null ) {
            (values).put("_OpMaterial", to_OpMaterial);
        }
        if( to_OpRelation != null ) {
            (values).put("_OpRelation", to_OpRelation);
        }
        if( to_SubOp != null ) {
            (values).put("_SubOp", to_SubOp);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>MaintenanceTaskListOpLongText</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_OpLongText</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceTaskListOperation</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_OpLongText</b> is already loaded, the result will contain
     *         the <b>MaintenanceTaskListOpLongText</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceTaskListOpLongText> getOpLongTextIfPresent()
    {
        return Option.of(to_OpLongText);
    }

    /**
     * Overwrites the associated <b>MaintenanceTaskListOpLongText</b> entity for the loaded navigation property
     * <b>_OpLongText</b>.
     * 
     * @param value
     *            New <b>MaintenanceTaskListOpLongText</b> entity.
     */
    public void setOpLongText( final MaintenanceTaskListOpLongText value )
    {
        to_OpLongText = value;
    }

    /**
     * Retrieval of associated <b>MaintenanceTaskListOpMat</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_OpMaterial</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceTaskListOperation</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_OpMaterial</b> is already loaded, the result will contain
     *         the <b>MaintenanceTaskListOpMat</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceTaskListOpMat>> getOpMaterialIfPresent()
    {
        return Option.of(to_OpMaterial);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceTaskListOpMat</b> entities for the loaded navigation property
     * <b>_OpMaterial</b>.
     * <p>
     * If the navigation property <b>_OpMaterial</b> of a queried <b>MaintenanceTaskListOperation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>MaintenanceTaskListOpMat</b> entities.
     */
    public void setOpMaterial( @Nonnull final List<MaintenanceTaskListOpMat> value )
    {
        if( to_OpMaterial == null ) {
            to_OpMaterial = Lists.newArrayList();
        }
        to_OpMaterial.clear();
        to_OpMaterial.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceTaskListOpMat</b> entities. This corresponds to the OData
     * navigation property <b>_OpMaterial</b>.
     * <p>
     * If the navigation property <b>_OpMaterial</b> of a queried <b>MaintenanceTaskListOperation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>MaintenanceTaskListOpMat</b> entities.
     */
    public void addOpMaterial( MaintenanceTaskListOpMat... entity )
    {
        if( to_OpMaterial == null ) {
            to_OpMaterial = Lists.newArrayList();
        }
        to_OpMaterial.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>MaintenanceTaskListOpReltnshp</b> entities (one to many). This corresponds to the
     * OData navigation property <b>_OpRelation</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceTaskListOperation</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_OpRelation</b> is already loaded, the result will contain
     *         the <b>MaintenanceTaskListOpReltnshp</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceTaskListOpReltnshp>> getOpRelationIfPresent()
    {
        return Option.of(to_OpRelation);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceTaskListOpReltnshp</b> entities for the loaded navigation
     * property <b>_OpRelation</b>.
     * <p>
     * If the navigation property <b>_OpRelation</b> of a queried <b>MaintenanceTaskListOperation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>MaintenanceTaskListOpReltnshp</b> entities.
     */
    public void setOpRelation( @Nonnull final List<MaintenanceTaskListOpReltnshp> value )
    {
        if( to_OpRelation == null ) {
            to_OpRelation = Lists.newArrayList();
        }
        to_OpRelation.clear();
        to_OpRelation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceTaskListOpReltnshp</b> entities. This corresponds to the
     * OData navigation property <b>_OpRelation</b>.
     * <p>
     * If the navigation property <b>_OpRelation</b> of a queried <b>MaintenanceTaskListOperation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>MaintenanceTaskListOpReltnshp</b> entities.
     */
    public void addOpRelation( MaintenanceTaskListOpReltnshp... entity )
    {
        if( to_OpRelation == null ) {
            to_OpRelation = Lists.newArrayList();
        }
        to_OpRelation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>MaintenanceTaskListSubOp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SubOp</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceTaskListOperation</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SubOp</b> is already loaded, the result will contain the
     *         <b>MaintenanceTaskListSubOp</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceTaskListSubOp>> getSubOpIfPresent()
    {
        return Option.of(to_SubOp);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceTaskListSubOp</b> entities for the loaded navigation property
     * <b>_SubOp</b>.
     * <p>
     * If the navigation property <b>_SubOp</b> of a queried <b>MaintenanceTaskListOperation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>MaintenanceTaskListSubOp</b> entities.
     */
    public void setSubOp( @Nonnull final List<MaintenanceTaskListSubOp> value )
    {
        if( to_SubOp == null ) {
            to_SubOp = Lists.newArrayList();
        }
        to_SubOp.clear();
        to_SubOp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceTaskListSubOp</b> entities. This corresponds to the OData
     * navigation property <b>_SubOp</b>.
     * <p>
     * If the navigation property <b>_SubOp</b> of a queried <b>MaintenanceTaskListOperation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>MaintenanceTaskListSubOp</b> entities.
     */
    public void addSubOp( MaintenanceTaskListSubOp... entity )
    {
        if( to_SubOp == null ) {
            to_SubOp = Lists.newArrayList();
        }
        to_SubOp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceTaskListOperation instances.
     * 
     */
    public final static class MaintenanceTaskListOperationBuilder
    {

        private MaintenanceTaskListOpLongText to_OpLongText;
        private List<MaintenanceTaskListOpMat> to_OpMaterial = Lists.newArrayList();
        private List<MaintenanceTaskListOpReltnshp> to_OpRelation = Lists.newArrayList();
        private List<MaintenanceTaskListSubOp> to_SubOp = Lists.newArrayList();

        private MaintenanceTaskListOperation.MaintenanceTaskListOperationBuilder to_OpLongText(
            final MaintenanceTaskListOpLongText value )
        {
            to_OpLongText = value;
            return this;
        }

        /**
         * Navigation property <b>_OpLongText</b> for <b>MaintenanceTaskListOperation</b> to single
         * <b>MaintenanceTaskListOpLongText</b>.
         * 
         * @param value
         *            The MaintenanceTaskListOpLongText to build this MaintenanceTaskListOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceTaskListOperation.MaintenanceTaskListOperationBuilder opLongText(
            final MaintenanceTaskListOpLongText value )
        {
            return to_OpLongText(value);
        }

        private MaintenanceTaskListOperation.MaintenanceTaskListOperationBuilder to_OpMaterial(
            final List<MaintenanceTaskListOpMat> value )
        {
            to_OpMaterial.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_OpMaterial</b> for <b>MaintenanceTaskListOperation</b> to multiple
         * <b>MaintenanceTaskListOpMat</b>.
         * 
         * @param value
         *            The MaintenanceTaskListOpMats to build this MaintenanceTaskListOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceTaskListOperation.MaintenanceTaskListOperationBuilder opMaterial(
            MaintenanceTaskListOpMat... value )
        {
            return to_OpMaterial(Lists.newArrayList(value));
        }

        private MaintenanceTaskListOperation.MaintenanceTaskListOperationBuilder to_OpRelation(
            final List<MaintenanceTaskListOpReltnshp> value )
        {
            to_OpRelation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_OpRelation</b> for <b>MaintenanceTaskListOperation</b> to multiple
         * <b>MaintenanceTaskListOpReltnshp</b>.
         * 
         * @param value
         *            The MaintenanceTaskListOpReltnshps to build this MaintenanceTaskListOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceTaskListOperation.MaintenanceTaskListOperationBuilder opRelation(
            MaintenanceTaskListOpReltnshp... value )
        {
            return to_OpRelation(Lists.newArrayList(value));
        }

        private MaintenanceTaskListOperation.MaintenanceTaskListOperationBuilder to_SubOp(
            final List<MaintenanceTaskListSubOp> value )
        {
            to_SubOp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SubOp</b> for <b>MaintenanceTaskListOperation</b> to multiple
         * <b>MaintenanceTaskListSubOp</b>.
         * 
         * @param value
         *            The MaintenanceTaskListSubOps to build this MaintenanceTaskListOperation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceTaskListOperation.MaintenanceTaskListOperationBuilder subOp(
            MaintenanceTaskListSubOp... value )
        {
            return to_SubOp(Lists.newArrayList(value));
        }

    }

}
