/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist;

import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MaintenanceTasklistService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Packages
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceTaskListStrtgyPckgType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MaintenanceTaskListStrtgyPckg extends VdmEntity<MaintenanceTaskListStrtgyPckg> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_maintenancetasklist.v0001.MaintenanceTaskListStrtgyPckgType";
    /**
     * Selector for all available fields of MaintenanceTaskListStrtgyPckg.
     * 
     */
    public final static SimpleProperty<MaintenanceTaskListStrtgyPckg> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @return Task List Type
     */
    @Nullable
    @ElementName( "TaskListType" )
    private java.lang.String taskListType;
    public final static SimpleProperty.String<MaintenanceTaskListStrtgyPckg> TASK_LIST_TYPE =
        new SimpleProperty.String<MaintenanceTaskListStrtgyPckg>(MaintenanceTaskListStrtgyPckg.class, "TaskListType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @return Key for Task List Group
     */
    @Nullable
    @ElementName( "TaskListGroup" )
    private java.lang.String taskListGroup;
    public final static SimpleProperty.String<MaintenanceTaskListStrtgyPckg> TASK_LIST_GROUP =
        new SimpleProperty.String<MaintenanceTaskListStrtgyPckg>(MaintenanceTaskListStrtgyPckg.class, "TaskListGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @return Group Counter
     */
    @Nullable
    @ElementName( "TaskListGroupCounter" )
    private java.lang.String taskListGroupCounter;
    public final static SimpleProperty.String<MaintenanceTaskListStrtgyPckg> TASK_LIST_GROUP_COUNTER =
        new SimpleProperty.String<MaintenanceTaskListStrtgyPckg>(
            MaintenanceTaskListStrtgyPckg.class,
            "TaskListGroupCounter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaskListSequence</b>
     * </p>
     * 
     * @return Sequence
     */
    @Nullable
    @ElementName( "TaskListSequence" )
    private java.lang.String taskListSequence;
    public final static SimpleProperty.String<MaintenanceTaskListStrtgyPckg> TASK_LIST_SEQUENCE =
        new SimpleProperty.String<MaintenanceTaskListStrtgyPckg>(
            MaintenanceTaskListStrtgyPckg.class,
            "TaskListSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOperationInternalId</b>
     * </p>
     * 
     * @return Number of the Task List Node
     */
    @Nullable
    @ElementName( "TaskListOperationInternalId" )
    private java.lang.String taskListOperationInternalId;
    public final static SimpleProperty.String<MaintenanceTaskListStrtgyPckg> TASK_LIST_OPERATION_INTERNAL_ID =
        new SimpleProperty.String<MaintenanceTaskListStrtgyPckg>(
            MaintenanceTaskListStrtgyPckg.class,
            "TaskListOperationInternalId");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePackage</b>
     * </p>
     * 
     * @return Maintenance Package Number
     */
    @Nullable
    @ElementName( "MaintenancePackage" )
    private java.lang.String maintenancePackage;
    public final static SimpleProperty.String<MaintenanceTaskListStrtgyPckg> MAINTENANCE_PACKAGE =
        new SimpleProperty.String<MaintenanceTaskListStrtgyPckg>(
            MaintenanceTaskListStrtgyPckg.class,
            "MaintenancePackage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintPckgTskListOpAllocIntNmbr</b>
     * </p>
     * 
     * @return Internal counter
     */
    @Nullable
    @ElementName( "MaintPckgTskListOpAllocIntNmbr" )
    private java.lang.String maintPckgTskListOpAllocIntNmbr;
    public final static SimpleProperty.String<MaintenanceTaskListStrtgyPckg> MAINT_PCKG_TSK_LIST_OP_ALLOC_INT_NMBR =
        new SimpleProperty.String<MaintenanceTaskListStrtgyPckg>(
            MaintenanceTaskListStrtgyPckg.class,
            "MaintPckgTskListOpAllocIntNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePackageText</b>
     * </p>
     * 
     * @return Text for maintenance package/cycle (time/performance)
     */
    @Nullable
    @ElementName( "MaintenancePackageText" )
    private java.lang.String maintenancePackageText;
    public final static SimpleProperty.String<MaintenanceTaskListStrtgyPckg> MAINTENANCE_PACKAGE_TEXT =
        new SimpleProperty.String<MaintenanceTaskListStrtgyPckg>(
            MaintenanceTaskListStrtgyPckg.class,
            "MaintenancePackageText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListOperation</b>
     * </p>
     * 
     * @return Operation / Phase Number
     */
    @Nullable
    @ElementName( "MaintenanceTaskListOperation" )
    private java.lang.String maintenanceTaskListOperation;
    public final static SimpleProperty.String<MaintenanceTaskListStrtgyPckg> MAINTENANCE_TASK_LIST_OPERATION =
        new SimpleProperty.String<MaintenanceTaskListStrtgyPckg>(
            MaintenanceTaskListStrtgyPckg.class,
            "MaintenanceTaskListOperation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     * 
     * @return Operation Short Text
     */
    @Nullable
    @ElementName( "OperationText" )
    private java.lang.String operationText;
    public final static SimpleProperty.String<MaintenanceTaskListStrtgyPckg> OPERATION_TEXT =
        new SimpleProperty.String<MaintenanceTaskListStrtgyPckg>(MaintenanceTaskListStrtgyPckg.class, "OperationText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintTaskListSubOperation</b>
     * </p>
     * 
     * @return Operation / Phase Number
     */
    @Nullable
    @ElementName( "MaintTaskListSubOperation" )
    private java.lang.String maintTaskListSubOperation;
    public final static SimpleProperty.String<MaintenanceTaskListStrtgyPckg> MAINT_TASK_LIST_SUB_OPERATION =
        new SimpleProperty.String<MaintenanceTaskListStrtgyPckg>(
            MaintenanceTaskListStrtgyPckg.class,
            "MaintTaskListSubOperation");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     * 
     * @return Change Number
     */
    @Nullable
    @ElementName( "ChangeNumber" )
    private java.lang.String changeNumber;
    public final static SimpleProperty.String<MaintenanceTaskListStrtgyPckg> CHANGE_NUMBER =
        new SimpleProperty.String<MaintenanceTaskListStrtgyPckg>(MaintenanceTaskListStrtgyPckg.class, "ChangeNumber");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskListStrtgyPckg, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskListStrtgyPckg, SAP__Message>(
            MaintenanceTaskListStrtgyPckg.class,
            "SAP__Messages",
            SAP__Message.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MaintenanceTaskListStrtgyPckg> getType()
    {
        return MaintenanceTaskListStrtgyPckg.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @param taskListType
     *            Task List Type
     */
    public void setTaskListType( @Nullable final java.lang.String taskListType )
    {
        rememberChangedField("TaskListType", this.taskListType);
        this.taskListType = taskListType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @param taskListGroup
     *            Key for Task List Group
     */
    public void setTaskListGroup( @Nullable final java.lang.String taskListGroup )
    {
        rememberChangedField("TaskListGroup", this.taskListGroup);
        this.taskListGroup = taskListGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @param taskListGroupCounter
     *            Group Counter
     */
    public void setTaskListGroupCounter( @Nullable final java.lang.String taskListGroupCounter )
    {
        rememberChangedField("TaskListGroupCounter", this.taskListGroupCounter);
        this.taskListGroupCounter = taskListGroupCounter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaskListSequence</b>
     * </p>
     * 
     * @param taskListSequence
     *            Sequence
     */
    public void setTaskListSequence( @Nullable final java.lang.String taskListSequence )
    {
        rememberChangedField("TaskListSequence", this.taskListSequence);
        this.taskListSequence = taskListSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOperationInternalId</b>
     * </p>
     * 
     * @param taskListOperationInternalId
     *            Number of the Task List Node
     */
    public void setTaskListOperationInternalId( @Nullable final java.lang.String taskListOperationInternalId )
    {
        rememberChangedField("TaskListOperationInternalId", this.taskListOperationInternalId);
        this.taskListOperationInternalId = taskListOperationInternalId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePackage</b>
     * </p>
     * 
     * @param maintenancePackage
     *            Maintenance Package Number
     */
    public void setMaintenancePackage( @Nullable final java.lang.String maintenancePackage )
    {
        rememberChangedField("MaintenancePackage", this.maintenancePackage);
        this.maintenancePackage = maintenancePackage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintPckgTskListOpAllocIntNmbr</b>
     * </p>
     * 
     * @param maintPckgTskListOpAllocIntNmbr
     *            Internal counter
     */
    public void setMaintPckgTskListOpAllocIntNmbr( @Nullable final java.lang.String maintPckgTskListOpAllocIntNmbr )
    {
        rememberChangedField("MaintPckgTskListOpAllocIntNmbr", this.maintPckgTskListOpAllocIntNmbr);
        this.maintPckgTskListOpAllocIntNmbr = maintPckgTskListOpAllocIntNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePackageText</b>
     * </p>
     * 
     * @param maintenancePackageText
     *            Text for maintenance package/cycle (time/performance)
     */
    public void setMaintenancePackageText( @Nullable final java.lang.String maintenancePackageText )
    {
        rememberChangedField("MaintenancePackageText", this.maintenancePackageText);
        this.maintenancePackageText = maintenancePackageText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListOperation</b>
     * </p>
     * 
     * @param maintenanceTaskListOperation
     *            Operation / Phase Number
     */
    public void setMaintenanceTaskListOperation( @Nullable final java.lang.String maintenanceTaskListOperation )
    {
        rememberChangedField("MaintenanceTaskListOperation", this.maintenanceTaskListOperation);
        this.maintenanceTaskListOperation = maintenanceTaskListOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     * 
     * @param operationText
     *            Operation Short Text
     */
    public void setOperationText( @Nullable final java.lang.String operationText )
    {
        rememberChangedField("OperationText", this.operationText);
        this.operationText = operationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintTaskListSubOperation</b>
     * </p>
     * 
     * @param maintTaskListSubOperation
     *            Operation / Phase Number
     */
    public void setMaintTaskListSubOperation( @Nullable final java.lang.String maintTaskListSubOperation )
    {
        rememberChangedField("MaintTaskListSubOperation", this.maintTaskListSubOperation);
        this.maintTaskListSubOperation = maintTaskListSubOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     * 
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final java.lang.String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MaintenanceTaskListStrtgyPckg";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("TaskListType", getTaskListType());
        entityKey.addKeyProperty("TaskListGroup", getTaskListGroup());
        entityKey.addKeyProperty("TaskListGroupCounter", getTaskListGroupCounter());
        entityKey.addKeyProperty("TaskListSequence", getTaskListSequence());
        entityKey.addKeyProperty("TaskListOperationInternalId", getTaskListOperationInternalId());
        entityKey.addKeyProperty("MaintenancePackage", getMaintenancePackage());
        entityKey.addKeyProperty("MaintPckgTskListOpAllocIntNmbr", getMaintPckgTskListOpAllocIntNmbr());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("TaskListType", getTaskListType());
        values.put("TaskListGroup", getTaskListGroup());
        values.put("TaskListGroupCounter", getTaskListGroupCounter());
        values.put("TaskListSequence", getTaskListSequence());
        values.put("TaskListOperationInternalId", getTaskListOperationInternalId());
        values.put("MaintenancePackage", getMaintenancePackage());
        values.put("MaintPckgTskListOpAllocIntNmbr", getMaintPckgTskListOpAllocIntNmbr());
        values.put("MaintenancePackageText", getMaintenancePackageText());
        values.put("MaintenanceTaskListOperation", getMaintenanceTaskListOperation());
        values.put("OperationText", getOperationText());
        values.put("MaintTaskListSubOperation", getMaintTaskListSubOperation());
        values.put("ChangeNumber", getChangeNumber());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("TaskListType") ) {
                final Object value = values.remove("TaskListType");
                if( (value == null) || (!value.equals(getTaskListType())) ) {
                    setTaskListType(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroup") ) {
                final Object value = values.remove("TaskListGroup");
                if( (value == null) || (!value.equals(getTaskListGroup())) ) {
                    setTaskListGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroupCounter") ) {
                final Object value = values.remove("TaskListGroupCounter");
                if( (value == null) || (!value.equals(getTaskListGroupCounter())) ) {
                    setTaskListGroupCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListSequence") ) {
                final Object value = values.remove("TaskListSequence");
                if( (value == null) || (!value.equals(getTaskListSequence())) ) {
                    setTaskListSequence(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListOperationInternalId") ) {
                final Object value = values.remove("TaskListOperationInternalId");
                if( (value == null) || (!value.equals(getTaskListOperationInternalId())) ) {
                    setTaskListOperationInternalId(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenancePackage") ) {
                final Object value = values.remove("MaintenancePackage");
                if( (value == null) || (!value.equals(getMaintenancePackage())) ) {
                    setMaintenancePackage(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintPckgTskListOpAllocIntNmbr") ) {
                final Object value = values.remove("MaintPckgTskListOpAllocIntNmbr");
                if( (value == null) || (!value.equals(getMaintPckgTskListOpAllocIntNmbr())) ) {
                    setMaintPckgTskListOpAllocIntNmbr(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenancePackageText") ) {
                final Object value = values.remove("MaintenancePackageText");
                if( (value == null) || (!value.equals(getMaintenancePackageText())) ) {
                    setMaintenancePackageText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenanceTaskListOperation") ) {
                final Object value = values.remove("MaintenanceTaskListOperation");
                if( (value == null) || (!value.equals(getMaintenanceTaskListOperation())) ) {
                    setMaintenanceTaskListOperation(((java.lang.String) value));
                }
            }
            if( values.containsKey("OperationText") ) {
                final Object value = values.remove("OperationText");
                if( (value == null) || (!value.equals(getOperationText())) ) {
                    setOperationText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintTaskListSubOperation") ) {
                final Object value = values.remove("MaintTaskListSubOperation");
                if( (value == null) || (!value.equals(getMaintTaskListSubOperation())) ) {
                    setMaintTaskListSubOperation(((java.lang.String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MaintenanceTasklistService.DEFAULT_SERVICE_PATH;
    }

}
