/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MaintenanceTasklistService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Suboperations
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceTaskListSubOpType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MaintenanceTaskListSubOp extends VdmEntity<MaintenanceTaskListSubOp> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_maintenancetasklist.v0001.MaintenanceTaskListSubOpType";
    /**
     * Selector for all available fields of MaintenanceTaskListSubOp.
     * 
     */
    public final static SimpleProperty<MaintenanceTaskListSubOp> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @return Task List Type
     */
    @Nullable
    @ElementName( "TaskListType" )
    private java.lang.String taskListType;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> TASK_LIST_TYPE =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "TaskListType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @return Key for Task List Group
     */
    @Nullable
    @ElementName( "TaskListGroup" )
    private java.lang.String taskListGroup;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> TASK_LIST_GROUP =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "TaskListGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @return Group Counter
     */
    @Nullable
    @ElementName( "TaskListGroupCounter" )
    private java.lang.String taskListGroupCounter;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> TASK_LIST_GROUP_COUNTER =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "TaskListGroupCounter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaskListSequence</b>
     * </p>
     * 
     * @return Sequence
     */
    @Nullable
    @ElementName( "TaskListSequence" )
    private java.lang.String taskListSequence;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> TASK_LIST_SEQUENCE =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "TaskListSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOperationInternalId</b>
     * </p>
     * 
     * @return Number of the Task List Node
     */
    @Nullable
    @ElementName( "TaskListOperationInternalId" )
    private java.lang.String taskListOperationInternalId;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> TASK_LIST_OPERATION_INTERNAL_ID =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(
            MaintenanceTaskListSubOp.class,
            "TaskListOperationInternalId");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOpBOMItmIntVersCounter</b>
     * </p>
     * 
     * @return Internal counter
     */
    @Nullable
    @ElementName( "TaskListOpBOMItmIntVersCounter" )
    private java.lang.String taskListOpBOMItmIntVersCounter;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> TASK_LIST_OP_BOM_ITM_INT_VERS_COUNTER =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(
            MaintenanceTaskListSubOp.class,
            "TaskListOpBOMItmIntVersCounter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOperationExecStageCode</b>
     * </p>
     * 
     * @return PRE MAIN POST
     */
    @Nullable
    @ElementName( "MaintOperationExecStageCode" )
    private java.lang.String maintOperationExecStageCode;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> MAINT_OPERATION_EXEC_STAGE_CODE =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(
            MaintenanceTaskListSubOp.class,
            "MaintOperationExecStageCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListOperation</b>
     * </p>
     * 
     * @return Operation / Phase Number
     */
    @Nullable
    @ElementName( "MaintenanceTaskListOperation" )
    private java.lang.String maintenanceTaskListOperation;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> MAINTENANCE_TASK_LIST_OPERATION =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(
            MaintenanceTaskListSubOp.class,
            "MaintenanceTaskListOperation");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     * 
     * @return Work Center
     */
    @Nullable
    @ElementName( "WorkCenter" )
    private java.lang.String workCenter;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> WORK_CENTER =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SubOperation</b>
     * </p>
     * 
     * @return Sub Operation / Secondary Resource Number
     */
    @Nullable
    @ElementName( "SubOperation" )
    private java.lang.String subOperation;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> SUB_OPERATION =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "SubOperation");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorOperationInternalID</b>
     * </p>
     * 
     * @return Node Number of the Superior Operation
     */
    @Nullable
    @ElementName( "SuperiorOperationInternalID" )
    private java.lang.String superiorOperationInternalID;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> SUPERIOR_OPERATION_INTERNAL_ID =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(
            MaintenanceTaskListSubOp.class,
            "SuperiorOperationInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SubOperationText</b>
     * </p>
     * 
     * @return Operation Short Text
     */
    @Nullable
    @ElementName( "SubOperationText" )
    private java.lang.String subOperationText;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> SUB_OPERATION_TEXT =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "SubOperationText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LongTextLanguageCode</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "LongTextLanguageCode" )
    private java.lang.String longTextLanguageCode;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> LONG_TEXT_LANGUAGE_CODE =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "LongTextLanguageCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> PLANT =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     * 
     * @return Control Key
     */
    @Nullable
    @ElementName( "OperationControlProfile" )
    private java.lang.String operationControlProfile;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> OPERATION_CONTROL_PROFILE =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "OperationControlProfile");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     * 
     * @return Factory Calendar
     */
    @Nullable
    @ElementName( "FactoryCalendar" )
    private java.lang.String factoryCalendar;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> FACTORY_CALENDAR =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "FactoryCalendar");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return Date Record Created On
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<MaintenanceTaskListSubOp> CREATION_DATE =
        new SimpleProperty.Date<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Created By User
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> CREATED_BY_USER =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "CreatedByUser");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     * 
     * @return Date of Last Change
     */
    @Nullable
    @ElementName( "LastChangeDate" )
    private LocalDate lastChangeDate;
    public final static SimpleProperty.Date<MaintenanceTaskListSubOp> LAST_CHANGE_DATE =
        new SimpleProperty.Date<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Last Changed By User
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "LastChangedByUser");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Valid-From Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<MaintenanceTaskListSubOp> VALIDITY_START_DATE =
        new SimpleProperty.Date<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "ValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Valid-To Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<MaintenanceTaskListSubOp> VALIDITY_END_DATE =
        new SimpleProperty.Date<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     * 
     * @return Number of purchasing info record
     */
    @Nullable
    @ElementName( "PurchasingInfoRecord" )
    private java.lang.String purchasingInfoRecord;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> PURCHASING_INFO_RECORD =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "PurchasingInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     * 
     * @return Purchasing Organization
     */
    @Nullable
    @ElementName( "PurchasingOrganization" )
    private java.lang.String purchasingOrganization;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> PURCHASING_ORGANIZATION =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     * 
     * @return Purchasing Document Number
     */
    @Nullable
    @ElementName( "PurchaseContract" )
    private java.lang.String purchaseContract;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> PURCHASE_CONTRACT =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "PurchaseContract");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     * 
     * @return Item Number of Purchasing Document
     */
    @Nullable
    @ElementName( "PurchaseContractItem" )
    private java.lang.String purchaseContractItem;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> PURCHASE_CONTRACT_ITEM =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "PurchaseContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecdAddlGrpgName</b>
     * </p>
     * 
     * @return Sort Term for Non-Stock Info Records
     */
    @Nullable
    @ElementName( "PurchasingInfoRecdAddlGrpgName" )
    private java.lang.String purchasingInfoRecdAddlGrpgName;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> PURCHASING_INFO_RECD_ADDL_GRPG_NAME =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(
            MaintenanceTaskListSubOp.class,
            "PurchasingInfoRecdAddlGrpgName");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     * 
     * @return Material Group
     */
    @Nullable
    @ElementName( "MaterialGroup" )
    private java.lang.String materialGroup;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> MATERIAL_GROUP =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     * 
     * @return Purchasing Group for External Processing Activity
     */
    @Nullable
    @ElementName( "PurchasingGroup" )
    private java.lang.String purchasingGroup;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> PURCHASING_GROUP =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     * 
     * @return Account Number of Supplier
     */
    @Nullable
    @ElementName( "Supplier" )
    private java.lang.String supplier;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> SUPPLIER =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(MaintenanceTaskListSubOp.class, "Supplier");
    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDuration</b>
     * </p>
     * 
     * @return Planned Delivery Time in Days
     */
    @Nullable
    @ElementName( "PlannedDeliveryDuration" )
    @DecimalDescriptor( precision = 3, scale = 0 )
    private BigDecimal plannedDeliveryDuration;
    public final static SimpleProperty.NumericDecimal<MaintenanceTaskListSubOp> PLANNED_DELIVERY_DURATION =
        new SimpleProperty.NumericDecimal<MaintenanceTaskListSubOp>(
            MaintenanceTaskListSubOp.class,
            "PlannedDeliveryDuration");
    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfOperationPriceUnits</b>
     * </p>
     * 
     * @return Price unit
     */
    @Nullable
    @ElementName( "NumberOfOperationPriceUnits" )
    @DecimalDescriptor( precision = 5, scale = 0 )
    private BigDecimal numberOfOperationPriceUnits;
    public final static SimpleProperty.NumericDecimal<MaintenanceTaskListSubOp> NUMBER_OF_OPERATION_PRICE_UNITS =
        new SimpleProperty.NumericDecimal<MaintenanceTaskListSubOp>(
            MaintenanceTaskListSubOp.class,
            "NumberOfOperationPriceUnits");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingPrice</b>
     * </p>
     * 
     * @return The opExternalProcessingPrice contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "OpExternalProcessingPrice" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal opExternalProcessingPrice;
    public final static SimpleProperty.NumericDecimal<MaintenanceTaskListSubOp> OP_EXTERNAL_PROCESSING_PRICE =
        new SimpleProperty.NumericDecimal<MaintenanceTaskListSubOp>(
            MaintenanceTaskListSubOp.class,
            "OpExternalProcessingPrice");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingCurrency</b>
     * </p>
     * 
     * @return Currency Key
     */
    @Nullable
    @ElementName( "OpExternalProcessingCurrency" )
    private java.lang.String opExternalProcessingCurrency;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> OP_EXTERNAL_PROCESSING_CURRENCY =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(
            MaintenanceTaskListSubOp.class,
            "OpExternalProcessingCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationCostingRelevancyType</b>
     * </p>
     * 
     * @return Operation Costing Relevancy Type
     */
    @Nullable
    @ElementName( "OperationCostingRelevancyType" )
    private java.lang.String operationCostingRelevancyType;
    public final static SimpleProperty.String<MaintenanceTaskListSubOp> OPERATION_COSTING_RELEVANCY_TYPE =
        new SimpleProperty.String<MaintenanceTaskListSubOp>(
            MaintenanceTaskListSubOp.class,
            "OperationCostingRelevancyType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskListSubOp, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MaintenanceTaskListSubOp, SAP__Message>(
            MaintenanceTaskListSubOp.class,
            "SAP__Messages",
            SAP__Message.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MaintenanceTaskListSubOp> getType()
    {
        return MaintenanceTaskListSubOp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     * 
     * @param taskListType
     *            Task List Type
     */
    public void setTaskListType( @Nullable final java.lang.String taskListType )
    {
        rememberChangedField("TaskListType", this.taskListType);
        this.taskListType = taskListType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     * 
     * @param taskListGroup
     *            Key for Task List Group
     */
    public void setTaskListGroup( @Nullable final java.lang.String taskListGroup )
    {
        rememberChangedField("TaskListGroup", this.taskListGroup);
        this.taskListGroup = taskListGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     * 
     * @param taskListGroupCounter
     *            Group Counter
     */
    public void setTaskListGroupCounter( @Nullable final java.lang.String taskListGroupCounter )
    {
        rememberChangedField("TaskListGroupCounter", this.taskListGroupCounter);
        this.taskListGroupCounter = taskListGroupCounter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaskListSequence</b>
     * </p>
     * 
     * @param taskListSequence
     *            Sequence
     */
    public void setTaskListSequence( @Nullable final java.lang.String taskListSequence )
    {
        rememberChangedField("TaskListSequence", this.taskListSequence);
        this.taskListSequence = taskListSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOperationInternalId</b>
     * </p>
     * 
     * @param taskListOperationInternalId
     *            Number of the Task List Node
     */
    public void setTaskListOperationInternalId( @Nullable final java.lang.String taskListOperationInternalId )
    {
        rememberChangedField("TaskListOperationInternalId", this.taskListOperationInternalId);
        this.taskListOperationInternalId = taskListOperationInternalId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListOpBOMItmIntVersCounter</b>
     * </p>
     * 
     * @param taskListOpBOMItmIntVersCounter
     *            Internal counter
     */
    public void setTaskListOpBOMItmIntVersCounter( @Nullable final java.lang.String taskListOpBOMItmIntVersCounter )
    {
        rememberChangedField("TaskListOpBOMItmIntVersCounter", this.taskListOpBOMItmIntVersCounter);
        this.taskListOpBOMItmIntVersCounter = taskListOpBOMItmIntVersCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOperationExecStageCode</b>
     * </p>
     * 
     * @param maintOperationExecStageCode
     *            PRE MAIN POST
     */
    public void setMaintOperationExecStageCode( @Nullable final java.lang.String maintOperationExecStageCode )
    {
        rememberChangedField("MaintOperationExecStageCode", this.maintOperationExecStageCode);
        this.maintOperationExecStageCode = maintOperationExecStageCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskListOperation</b>
     * </p>
     * 
     * @param maintenanceTaskListOperation
     *            Operation / Phase Number
     */
    public void setMaintenanceTaskListOperation( @Nullable final java.lang.String maintenanceTaskListOperation )
    {
        rememberChangedField("MaintenanceTaskListOperation", this.maintenanceTaskListOperation);
        this.maintenanceTaskListOperation = maintenanceTaskListOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     * 
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final java.lang.String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SubOperation</b>
     * </p>
     * 
     * @param subOperation
     *            Sub Operation / Secondary Resource Number
     */
    public void setSubOperation( @Nullable final java.lang.String subOperation )
    {
        rememberChangedField("SubOperation", this.subOperation);
        this.subOperation = subOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>SuperiorOperationInternalID</b>
     * </p>
     * 
     * @param superiorOperationInternalID
     *            Node Number of the Superior Operation
     */
    public void setSuperiorOperationInternalID( @Nullable final java.lang.String superiorOperationInternalID )
    {
        rememberChangedField("SuperiorOperationInternalID", this.superiorOperationInternalID);
        this.superiorOperationInternalID = superiorOperationInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SubOperationText</b>
     * </p>
     * 
     * @param subOperationText
     *            Operation Short Text
     */
    public void setSubOperationText( @Nullable final java.lang.String subOperationText )
    {
        rememberChangedField("SubOperationText", this.subOperationText);
        this.subOperationText = subOperationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LongTextLanguageCode</b>
     * </p>
     * 
     * @param longTextLanguageCode
     *            Language Key
     */
    public void setLongTextLanguageCode( @Nullable final java.lang.String longTextLanguageCode )
    {
        rememberChangedField("LongTextLanguageCode", this.longTextLanguageCode);
        this.longTextLanguageCode = longTextLanguageCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     * 
     * @param operationControlProfile
     *            Control Key
     */
    public void setOperationControlProfile( @Nullable final java.lang.String operationControlProfile )
    {
        rememberChangedField("OperationControlProfile", this.operationControlProfile);
        this.operationControlProfile = operationControlProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     * 
     * @param factoryCalendar
     *            Factory Calendar
     */
    public void setFactoryCalendar( @Nullable final java.lang.String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            Date Record Created On
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     * 
     * @param lastChangeDate
     *            Date of Last Change
     */
    public void setLastChangeDate( @Nullable final LocalDate lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     * 
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setPurchasingInfoRecord( @Nullable final java.lang.String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     * 
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final java.lang.String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     * 
     * @param purchaseContract
     *            Purchasing Document Number
     */
    public void setPurchaseContract( @Nullable final java.lang.String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     * 
     * @param purchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setPurchaseContractItem( @Nullable final java.lang.String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecdAddlGrpgName</b>
     * </p>
     * 
     * @param purchasingInfoRecdAddlGrpgName
     *            Sort Term for Non-Stock Info Records
     */
    public void setPurchasingInfoRecdAddlGrpgName( @Nullable final java.lang.String purchasingInfoRecdAddlGrpgName )
    {
        rememberChangedField("PurchasingInfoRecdAddlGrpgName", this.purchasingInfoRecdAddlGrpgName);
        this.purchasingInfoRecdAddlGrpgName = purchasingInfoRecdAddlGrpgName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     * 
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final java.lang.String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     * 
     * @param purchasingGroup
     *            Purchasing Group for External Processing Activity
     */
    public void setPurchasingGroup( @Nullable final java.lang.String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     * 
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final java.lang.String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDuration</b>
     * </p>
     * 
     * @param plannedDeliveryDuration
     *            Planned Delivery Time in Days
     */
    public void setPlannedDeliveryDuration( @Nullable final BigDecimal plannedDeliveryDuration )
    {
        rememberChangedField("PlannedDeliveryDuration", this.plannedDeliveryDuration);
        this.plannedDeliveryDuration = plannedDeliveryDuration;
    }

    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfOperationPriceUnits</b>
     * </p>
     * 
     * @param numberOfOperationPriceUnits
     *            Price unit
     */
    public void setNumberOfOperationPriceUnits( @Nullable final BigDecimal numberOfOperationPriceUnits )
    {
        rememberChangedField("NumberOfOperationPriceUnits", this.numberOfOperationPriceUnits);
        this.numberOfOperationPriceUnits = numberOfOperationPriceUnits;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingPrice</b>
     * </p>
     * 
     * @param opExternalProcessingPrice
     *            The opExternalProcessingPrice to set.
     */
    public void setOpExternalProcessingPrice( @Nullable final BigDecimal opExternalProcessingPrice )
    {
        rememberChangedField("OpExternalProcessingPrice", this.opExternalProcessingPrice);
        this.opExternalProcessingPrice = opExternalProcessingPrice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OpExternalProcessingCurrency</b>
     * </p>
     * 
     * @param opExternalProcessingCurrency
     *            Currency Key
     */
    public void setOpExternalProcessingCurrency( @Nullable final java.lang.String opExternalProcessingCurrency )
    {
        rememberChangedField("OpExternalProcessingCurrency", this.opExternalProcessingCurrency);
        this.opExternalProcessingCurrency = opExternalProcessingCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationCostingRelevancyType</b>
     * </p>
     * 
     * @param operationCostingRelevancyType
     *            Operation Costing Relevancy Type
     */
    public void setOperationCostingRelevancyType( @Nullable final java.lang.String operationCostingRelevancyType )
    {
        rememberChangedField("OperationCostingRelevancyType", this.operationCostingRelevancyType);
        this.operationCostingRelevancyType = operationCostingRelevancyType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MaintenanceTaskListSubOp";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("TaskListType", getTaskListType());
        entityKey.addKeyProperty("TaskListGroup", getTaskListGroup());
        entityKey.addKeyProperty("TaskListGroupCounter", getTaskListGroupCounter());
        entityKey.addKeyProperty("TaskListSequence", getTaskListSequence());
        entityKey.addKeyProperty("TaskListOperationInternalId", getTaskListOperationInternalId());
        entityKey.addKeyProperty("TaskListOpBOMItmIntVersCounter", getTaskListOpBOMItmIntVersCounter());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("TaskListType", getTaskListType());
        values.put("TaskListGroup", getTaskListGroup());
        values.put("TaskListGroupCounter", getTaskListGroupCounter());
        values.put("TaskListSequence", getTaskListSequence());
        values.put("TaskListOperationInternalId", getTaskListOperationInternalId());
        values.put("TaskListOpBOMItmIntVersCounter", getTaskListOpBOMItmIntVersCounter());
        values.put("MaintOperationExecStageCode", getMaintOperationExecStageCode());
        values.put("MaintenanceTaskListOperation", getMaintenanceTaskListOperation());
        values.put("WorkCenter", getWorkCenter());
        values.put("SubOperation", getSubOperation());
        values.put("SuperiorOperationInternalID", getSuperiorOperationInternalID());
        values.put("SubOperationText", getSubOperationText());
        values.put("LongTextLanguageCode", getLongTextLanguageCode());
        values.put("Plant", getPlant());
        values.put("OperationControlProfile", getOperationControlProfile());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchaseContract", getPurchaseContract());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("PurchasingInfoRecdAddlGrpgName", getPurchasingInfoRecdAddlGrpgName());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("Supplier", getSupplier());
        values.put("PlannedDeliveryDuration", getPlannedDeliveryDuration());
        values.put("NumberOfOperationPriceUnits", getNumberOfOperationPriceUnits());
        values.put("OpExternalProcessingPrice", getOpExternalProcessingPrice());
        values.put("OpExternalProcessingCurrency", getOpExternalProcessingCurrency());
        values.put("OperationCostingRelevancyType", getOperationCostingRelevancyType());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("TaskListType") ) {
                final Object value = values.remove("TaskListType");
                if( (value == null) || (!value.equals(getTaskListType())) ) {
                    setTaskListType(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroup") ) {
                final Object value = values.remove("TaskListGroup");
                if( (value == null) || (!value.equals(getTaskListGroup())) ) {
                    setTaskListGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListGroupCounter") ) {
                final Object value = values.remove("TaskListGroupCounter");
                if( (value == null) || (!value.equals(getTaskListGroupCounter())) ) {
                    setTaskListGroupCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListSequence") ) {
                final Object value = values.remove("TaskListSequence");
                if( (value == null) || (!value.equals(getTaskListSequence())) ) {
                    setTaskListSequence(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListOperationInternalId") ) {
                final Object value = values.remove("TaskListOperationInternalId");
                if( (value == null) || (!value.equals(getTaskListOperationInternalId())) ) {
                    setTaskListOperationInternalId(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaskListOpBOMItmIntVersCounter") ) {
                final Object value = values.remove("TaskListOpBOMItmIntVersCounter");
                if( (value == null) || (!value.equals(getTaskListOpBOMItmIntVersCounter())) ) {
                    setTaskListOpBOMItmIntVersCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintOperationExecStageCode") ) {
                final Object value = values.remove("MaintOperationExecStageCode");
                if( (value == null) || (!value.equals(getMaintOperationExecStageCode())) ) {
                    setMaintOperationExecStageCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenanceTaskListOperation") ) {
                final Object value = values.remove("MaintenanceTaskListOperation");
                if( (value == null) || (!value.equals(getMaintenanceTaskListOperation())) ) {
                    setMaintenanceTaskListOperation(((java.lang.String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("SubOperation") ) {
                final Object value = values.remove("SubOperation");
                if( (value == null) || (!value.equals(getSubOperation())) ) {
                    setSubOperation(((java.lang.String) value));
                }
            }
            if( values.containsKey("SuperiorOperationInternalID") ) {
                final Object value = values.remove("SuperiorOperationInternalID");
                if( (value == null) || (!value.equals(getSuperiorOperationInternalID())) ) {
                    setSuperiorOperationInternalID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SubOperationText") ) {
                final Object value = values.remove("SubOperationText");
                if( (value == null) || (!value.equals(getSubOperationText())) ) {
                    setSubOperationText(((java.lang.String) value));
                }
            }
            if( values.containsKey("LongTextLanguageCode") ) {
                final Object value = values.remove("LongTextLanguageCode");
                if( (value == null) || (!value.equals(getLongTextLanguageCode())) ) {
                    setLongTextLanguageCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("OperationControlProfile") ) {
                final Object value = values.remove("OperationControlProfile");
                if( (value == null) || (!value.equals(getOperationControlProfile())) ) {
                    setOperationControlProfile(((java.lang.String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDate) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecdAddlGrpgName") ) {
                final Object value = values.remove("PurchasingInfoRecdAddlGrpgName");
                if( (value == null) || (!value.equals(getPurchasingInfoRecdAddlGrpgName())) ) {
                    setPurchasingInfoRecdAddlGrpgName(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((java.lang.String) value));
                }
            }
            if( values.containsKey("PlannedDeliveryDuration") ) {
                final Object value = values.remove("PlannedDeliveryDuration");
                if( (value == null) || (!value.equals(getPlannedDeliveryDuration())) ) {
                    setPlannedDeliveryDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("NumberOfOperationPriceUnits") ) {
                final Object value = values.remove("NumberOfOperationPriceUnits");
                if( (value == null) || (!value.equals(getNumberOfOperationPriceUnits())) ) {
                    setNumberOfOperationPriceUnits(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpExternalProcessingPrice") ) {
                final Object value = values.remove("OpExternalProcessingPrice");
                if( (value == null) || (!value.equals(getOpExternalProcessingPrice())) ) {
                    setOpExternalProcessingPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpExternalProcessingCurrency") ) {
                final Object value = values.remove("OpExternalProcessingCurrency");
                if( (value == null) || (!value.equals(getOpExternalProcessingCurrency())) ) {
                    setOpExternalProcessingCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("OperationCostingRelevancyType") ) {
                final Object value = values.remove("OperationCostingRelevancyType");
                if( (value == null) || (!value.equals(getOperationCostingRelevancyType())) ) {
                    setOperationCostingRelevancyType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MaintenanceTasklistService.DEFAULT_SERVICE_PATH;
    }

}
