/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measurementdocument;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MeasurementDocumentService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Failed Measurement Document Reading
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>FailedMeasurementReadingType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class FailedMeasurementReading extends VdmEntity<FailedMeasurementReading> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_measurementdocument.v0001.FailedMeasurementReadingType";
    /**
     * Selector for all available fields of FailedMeasurementReading.
     * 
     */
    public final static SimpleProperty<FailedMeasurementReading> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngDate</b>
     * </p>
     * 
     * @return Date of the Measurement
     */
    @Nullable
    @ElementName( "MsmtRdngDate" )
    private LocalDate msmtRdngDate;
    public final static SimpleProperty.Date<FailedMeasurementReading> MSMT_RDNG_DATE =
        new SimpleProperty.Date<FailedMeasurementReading>(FailedMeasurementReading.class, "MsmtRdngDate");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngTime</b>
     * </p>
     * 
     * @return Time of Measurement
     */
    @Nullable
    @ElementName( "MsmtRdngTime" )
    private LocalTime msmtRdngTime;
    public final static SimpleProperty.Time<FailedMeasurementReading> MSMT_RDNG_TIME =
        new SimpleProperty.Time<FailedMeasurementReading>(FailedMeasurementReading.class, "MsmtRdngTime");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngSourceMeasurementDoc</b>
     * </p>
     * 
     * @return Source Document for Measurement Reading Transfer
     */
    @Nullable
    @ElementName( "MsmtRdngSourceMeasurementDoc" )
    private java.lang.String msmtRdngSourceMeasurementDoc;
    public final static SimpleProperty.String<FailedMeasurementReading> MSMT_RDNG_SOURCE_MEASUREMENT_DOC =
        new SimpleProperty.String<FailedMeasurementReading>(
            FailedMeasurementReading.class,
            "MsmtRdngSourceMeasurementDoc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPoint</b>
     * </p>
     * 
     * @return Measuring Point
     */
    @Nullable
    @ElementName( "MeasuringPoint" )
    private java.lang.String measuringPoint;
    public final static SimpleProperty.String<FailedMeasurementReading> MEASURING_POINT =
        new SimpleProperty.String<FailedMeasurementReading>(FailedMeasurementReading.class, "MeasuringPoint");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngTransfFailedMsgNumber</b>
     * </p>
     * 
     * @return Message Number
     */
    @Nullable
    @ElementName( "MsmtRdngTransfFailedMsgNumber" )
    private java.lang.String msmtRdngTransfFailedMsgNumber;
    public final static SimpleProperty.String<FailedMeasurementReading> MSMT_RDNG_TRANSF_FAILED_MSG_NUMBER =
        new SimpleProperty.String<FailedMeasurementReading>(
            FailedMeasurementReading.class,
            "MsmtRdngTransfFailedMsgNumber");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<FailedMeasurementReading, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<FailedMeasurementReading, SAP__Message>(
            FailedMeasurementReading.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_MeasurementDocument</b> for <b>FailedMeasurementReading</b> to single
     * <b>MeasurementDocument</b>.
     * 
     */
    @ElementName( "_MeasurementDocument" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MeasurementDocument to_MeasurementDocument;
    /**
     * Use with available request builders to apply the <b>_MeasurementDocument</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<FailedMeasurementReading, MeasurementDocument> TO__MEASUREMENT_DOCUMENT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<FailedMeasurementReading, MeasurementDocument>(
            FailedMeasurementReading.class,
            "_MeasurementDocument",
            MeasurementDocument.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<FailedMeasurementReading> getType()
    {
        return FailedMeasurementReading.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngDate</b>
     * </p>
     * 
     * @param msmtRdngDate
     *            Date of the Measurement
     */
    public void setMsmtRdngDate( @Nullable final LocalDate msmtRdngDate )
    {
        rememberChangedField("MsmtRdngDate", this.msmtRdngDate);
        this.msmtRdngDate = msmtRdngDate;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngTime</b>
     * </p>
     * 
     * @param msmtRdngTime
     *            Time of Measurement
     */
    public void setMsmtRdngTime( @Nullable final LocalTime msmtRdngTime )
    {
        rememberChangedField("MsmtRdngTime", this.msmtRdngTime);
        this.msmtRdngTime = msmtRdngTime;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngSourceMeasurementDoc</b>
     * </p>
     * 
     * @param msmtRdngSourceMeasurementDoc
     *            Source Document for Measurement Reading Transfer
     */
    public void setMsmtRdngSourceMeasurementDoc( @Nullable final java.lang.String msmtRdngSourceMeasurementDoc )
    {
        rememberChangedField("MsmtRdngSourceMeasurementDoc", this.msmtRdngSourceMeasurementDoc);
        this.msmtRdngSourceMeasurementDoc = msmtRdngSourceMeasurementDoc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPoint</b>
     * </p>
     * 
     * @param measuringPoint
     *            Measuring Point
     */
    public void setMeasuringPoint( @Nullable final java.lang.String measuringPoint )
    {
        rememberChangedField("MeasuringPoint", this.measuringPoint);
        this.measuringPoint = measuringPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngTransfFailedMsgNumber</b>
     * </p>
     * 
     * @param msmtRdngTransfFailedMsgNumber
     *            Message Number
     */
    public void setMsmtRdngTransfFailedMsgNumber( @Nullable final java.lang.String msmtRdngTransfFailedMsgNumber )
    {
        rememberChangedField("MsmtRdngTransfFailedMsgNumber", this.msmtRdngTransfFailedMsgNumber);
        this.msmtRdngTransfFailedMsgNumber = msmtRdngTransfFailedMsgNumber;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "FailedMeasurementReading";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("MsmtRdngDate", getMsmtRdngDate());
        entityKey.addKeyProperty("MsmtRdngTime", getMsmtRdngTime());
        entityKey.addKeyProperty("MsmtRdngSourceMeasurementDoc", getMsmtRdngSourceMeasurementDoc());
        entityKey.addKeyProperty("MeasuringPoint", getMeasuringPoint());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("MsmtRdngDate", getMsmtRdngDate());
        values.put("MsmtRdngTime", getMsmtRdngTime());
        values.put("MsmtRdngSourceMeasurementDoc", getMsmtRdngSourceMeasurementDoc());
        values.put("MeasuringPoint", getMeasuringPoint());
        values.put("MsmtRdngTransfFailedMsgNumber", getMsmtRdngTransfFailedMsgNumber());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MsmtRdngDate") ) {
                final Object value = values.remove("MsmtRdngDate");
                if( (value == null) || (!value.equals(getMsmtRdngDate())) ) {
                    setMsmtRdngDate(((LocalDate) value));
                }
            }
            if( values.containsKey("MsmtRdngTime") ) {
                final Object value = values.remove("MsmtRdngTime");
                if( (value == null) || (!value.equals(getMsmtRdngTime())) ) {
                    setMsmtRdngTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MsmtRdngSourceMeasurementDoc") ) {
                final Object value = values.remove("MsmtRdngSourceMeasurementDoc");
                if( (value == null) || (!value.equals(getMsmtRdngSourceMeasurementDoc())) ) {
                    setMsmtRdngSourceMeasurementDoc(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasuringPoint") ) {
                final Object value = values.remove("MeasuringPoint");
                if( (value == null) || (!value.equals(getMeasuringPoint())) ) {
                    setMeasuringPoint(((java.lang.String) value));
                }
            }
            if( values.containsKey("MsmtRdngTransfFailedMsgNumber") ) {
                final Object value = values.remove("MsmtRdngTransfFailedMsgNumber");
                if( (value == null) || (!value.equals(getMsmtRdngTransfFailedMsgNumber())) ) {
                    setMsmtRdngTransfFailedMsgNumber(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_MeasurementDocument") ) {
                final Object value = (values).remove("_MeasurementDocument");
                if( value instanceof Map ) {
                    if( to_MeasurementDocument == null ) {
                        to_MeasurementDocument = new MeasurementDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_MeasurementDocument.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MeasurementDocumentService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_MeasurementDocument != null ) {
            (values).put("_MeasurementDocument", to_MeasurementDocument);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>MeasurementDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_MeasurementDocument</b>.
     * <p>
     * If the navigation property for an entity <b>FailedMeasurementReading</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_MeasurementDocument</b> is already loaded, the result will
     *         contain the <b>MeasurementDocument</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MeasurementDocument> getMeasurementDocumentIfPresent()
    {
        return Option.of(to_MeasurementDocument);
    }

    /**
     * Overwrites the associated <b>MeasurementDocument</b> entity for the loaded navigation property
     * <b>_MeasurementDocument</b>.
     * 
     * @param value
     *            New <b>MeasurementDocument</b> entity.
     */
    public void setMeasurementDocument( final MeasurementDocument value )
    {
        to_MeasurementDocument = value;
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<FailedMeasurementReading, FailedMeasurementReading>
        repeatMsmtReadingTransfer()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<FailedMeasurementReading, FailedMeasurementReading>(
            FailedMeasurementReading.class,
            FailedMeasurementReading.class,
            "com.sap.gateway.srvd_a2x.api_measurementdocument.v0001.RepeatMsmtReadingTransfer",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of FailedMeasurementReading instances.
     * 
     */
    public final static class FailedMeasurementReadingBuilder
    {

        private MeasurementDocument to_MeasurementDocument;

        private FailedMeasurementReading.FailedMeasurementReadingBuilder to_MeasurementDocument(
            final MeasurementDocument value )
        {
            to_MeasurementDocument = value;
            return this;
        }

        /**
         * Navigation property <b>_MeasurementDocument</b> for <b>FailedMeasurementReading</b> to single
         * <b>MeasurementDocument</b>.
         * 
         * @param value
         *            The MeasurementDocument to build this FailedMeasurementReading with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FailedMeasurementReading.FailedMeasurementReadingBuilder measurementDocument(
            final MeasurementDocument value )
        {
            return to_MeasurementDocument(value);
        }

    }

}
