/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measurementdocument;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MeasurementDocumentService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Measurement Documents
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MeasurementDocumentType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MeasurementDocument extends VdmEntity<MeasurementDocument> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_measurementdocument.v0001.MeasurementDocumentType";
    /**
     * Selector for all available fields of MeasurementDocument.
     * 
     */
    public final static SimpleProperty<MeasurementDocument> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementDocument</b>
     * </p>
     * 
     * @return Measurement Document
     */
    @Nullable
    @ElementName( "MeasurementDocument" )
    private java.lang.String measurementDocument;
    public final static SimpleProperty.String<MeasurementDocument> MEASUREMENT_DOCUMENT =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "MeasurementDocument");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPoint</b>
     * </p>
     * 
     * @return Measuring Point
     */
    @Nullable
    @ElementName( "MeasuringPoint" )
    private java.lang.String measuringPoint;
    public final static SimpleProperty.String<MeasurementDocument> MEASURING_POINT =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "MeasuringPoint");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointPositionNumber</b>
     * </p>
     * 
     * @return Position Number of the Object Measuring Point (Sort Field)
     */
    @Nullable
    @ElementName( "MeasuringPointPositionNumber" )
    private java.lang.String measuringPointPositionNumber;
    public final static SimpleProperty.String<MeasurementDocument> MEASURING_POINT_POSITION_NUMBER =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "MeasuringPointPositionNumber");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngDate</b>
     * </p>
     * 
     * @return Date of the Measurement
     */
    @Nullable
    @ElementName( "MsmtRdngDate" )
    private LocalDate msmtRdngDate;
    public final static SimpleProperty.Date<MeasurementDocument> MSMT_RDNG_DATE =
        new SimpleProperty.Date<MeasurementDocument>(MeasurementDocument.class, "MsmtRdngDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngTime</b>
     * </p>
     * 
     * @return Time of Measurement
     */
    @Nullable
    @ElementName( "MsmtRdngTime" )
    private LocalTime msmtRdngTime;
    public final static SimpleProperty.Time<MeasurementDocument> MSMT_RDNG_TIME =
        new SimpleProperty.Time<MeasurementDocument>(MeasurementDocument.class, "MsmtRdngTime");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     * 
     * @return Characteristic Name
     */
    @Nullable
    @ElementName( "Characteristic" )
    private java.lang.String characteristic;
    public final static SimpleProperty.String<MeasurementDocument> CHARACTERISTIC =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "Characteristic");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MsmtDocumentReferredOrder</b>
     * </p>
     * 
     * @return Object Number of Order
     */
    @Nullable
    @ElementName( "MsmtDocumentReferredOrder" )
    private java.lang.String msmtDocumentReferredOrder;
    public final static SimpleProperty.String<MeasurementDocument> MSMT_DOCUMENT_REFERRED_ORDER =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "MsmtDocumentReferredOrder");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>RefdMaintOrderOpStatusObject</b>
     * </p>
     * 
     * @return Object Number of Order Operation/Confirmation Counter etc.
     */
    @Nullable
    @ElementName( "RefdMaintOrderOpStatusObject" )
    private java.lang.String refdMaintOrderOpStatusObject;
    public final static SimpleProperty.String<MeasurementDocument> REFD_MAINT_ORDER_OP_STATUS_OBJECT =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "RefdMaintOrderOpStatusObject");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     * 
     * @return Order Operation
     */
    @Nullable
    @ElementName( "MaintenanceOrderOperation" )
    private java.lang.String maintenanceOrderOperation;
    public final static SimpleProperty.String<MeasurementDocument> MAINTENANCE_ORDER_OPERATION =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "MaintenanceOrderOperation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     * 
     * @return Order Operation
     */
    @Nullable
    @ElementName( "MaintenanceOrderSubOperation" )
    private java.lang.String maintenanceOrderSubOperation;
    public final static SimpleProperty.String<MeasurementDocument> MAINTENANCE_ORDER_SUB_OPERATION =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "MaintenanceOrderSubOperation");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtIsDoneAfterTaskCompltn</b>
     * </p>
     * 
     * @return Indicator: MeasDoc. Created After Associated Task
     */
    @Nullable
    @ElementName( "MsmtIsDoneAfterTaskCompltn" )
    private java.lang.Boolean msmtIsDoneAfterTaskCompltn;
    public final static SimpleProperty.Boolean<MeasurementDocument> MSMT_IS_DONE_AFTER_TASK_COMPLTN =
        new SimpleProperty.Boolean<MeasurementDocument>(MeasurementDocument.class, "MsmtIsDoneAfterTaskCompltn");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueUnit</b>
     * </p>
     * 
     * @return Unit of Measurement
     */
    @Nullable
    @ElementName( "CharcValueUnit" )
    private java.lang.String charcValueUnit;
    public final static SimpleProperty.String<MeasurementDocument> CHARC_VALUE_UNIT =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "CharcValueUnit");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementReading</b>
     * </p>
     * 
     * @return The measurementReading contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "MeasurementReading" )
    private Double measurementReading;
    public final static SimpleProperty.NumericDecimal<MeasurementDocument> MEASUREMENT_READING =
        new SimpleProperty.NumericDecimal<MeasurementDocument>(MeasurementDocument.class, "MeasurementReading");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementReadingInEntryUoM</b>
     * </p>
     * 
     * @return The measurementReadingInEntryUoM contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "MeasurementReadingInEntryUoM" )
    private Double measurementReadingInEntryUoM;
    public final static SimpleProperty.NumericDecimal<MeasurementDocument> MEASUREMENT_READING_IN_ENTRY_UO_M =
        new SimpleProperty.NumericDecimal<MeasurementDocument>(
            MeasurementDocument.class,
            "MeasurementReadingInEntryUoM");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementReadingEntryUoM</b>
     * </p>
     * 
     * @return Unit of Measurement for Document Entry
     */
    @Nullable
    @ElementName( "MeasurementReadingEntryUoM" )
    private java.lang.String measurementReadingEntryUoM;
    public final static SimpleProperty.String<MeasurementDocument> MEASUREMENT_READING_ENTRY_UO_M =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "MeasurementReadingEntryUoM");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementCounterReading</b>
     * </p>
     * 
     * @return The measurementCounterReading contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "MeasurementCounterReading" )
    private Double measurementCounterReading;
    public final static SimpleProperty.NumericDecimal<MeasurementDocument> MEASUREMENT_COUNTER_READING =
        new SimpleProperty.NumericDecimal<MeasurementDocument>(MeasurementDocument.class, "MeasurementCounterReading");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtCounterReadingDifference</b>
     * </p>
     * 
     * @return The msmtCounterReadingDifference contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "MsmtCounterReadingDifference" )
    private Double msmtCounterReadingDifference;
    public final static SimpleProperty.NumericDecimal<MeasurementDocument> MSMT_COUNTER_READING_DIFFERENCE =
        new SimpleProperty.NumericDecimal<MeasurementDocument>(
            MeasurementDocument.class,
            "MsmtCounterReadingDifference");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TotalMsmtRdngIsSetExternally</b>
     * </p>
     * 
     * @return Indicator: Total Counter Reading Set Externally
     */
    @Nullable
    @ElementName( "TotalMsmtRdngIsSetExternally" )
    private java.lang.Boolean totalMsmtRdngIsSetExternally;
    public final static SimpleProperty.Boolean<MeasurementDocument> TOTAL_MSMT_RDNG_IS_SET_EXTERNALLY =
        new SimpleProperty.Boolean<MeasurementDocument>(MeasurementDocument.class, "TotalMsmtRdngIsSetExternally");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointTargetValue</b>
     * </p>
     * 
     * @return Measuring Point Target Value
     */
    @Nullable
    @ElementName( "MeasuringPointTargetValue" )
    private Double measuringPointTargetValue;
    public final static SimpleProperty.NumericDecimal<MeasurementDocument> MEASURING_POINT_TARGET_VALUE =
        new SimpleProperty.NumericDecimal<MeasurementDocument>(MeasurementDocument.class, "MeasuringPointTargetValue");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MsmtValuationCode</b>
     * </p>
     * 
     * @return Valuation Code
     */
    @Nullable
    @ElementName( "MsmtValuationCode" )
    private java.lang.String msmtValuationCode;
    public final static SimpleProperty.String<MeasurementDocument> MSMT_VALUATION_CODE =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "MsmtValuationCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementDocumentText</b>
     * </p>
     * 
     * @return Measurement Document Text
     */
    @Nullable
    @ElementName( "MeasurementDocumentText" )
    private java.lang.String measurementDocumentText;
    public final static SimpleProperty.String<MeasurementDocument> MEASUREMENT_DOCUMENT_TEXT =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "MeasurementDocumentText");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementDocumentHasLongText</b>
     * </p>
     * 
     * @return Long Text Exists
     */
    @Nullable
    @ElementName( "MeasurementDocumentHasLongText" )
    private java.lang.Boolean measurementDocumentHasLongText;
    public final static SimpleProperty.Boolean<MeasurementDocument> MEASUREMENT_DOCUMENT_HAS_LONG_TEXT =
        new SimpleProperty.Boolean<MeasurementDocument>(MeasurementDocument.class, "MeasurementDocumentHasLongText");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngByUser</b>
     * </p>
     * 
     * @return Person who Took the Measurement Reading
     */
    @Nullable
    @ElementName( "MsmtRdngByUser" )
    private java.lang.String msmtRdngByUser;
    public final static SimpleProperty.String<MeasurementDocument> MSMT_RDNG_BY_USER =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "MsmtRdngByUser");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngStatus</b>
     * </p>
     * 
     * @return Processing Status
     */
    @Nullable
    @ElementName( "MsmtRdngStatus" )
    private java.lang.String msmtRdngStatus;
    public final static SimpleProperty.String<MeasurementDocument> MSMT_RDNG_STATUS =
        new SimpleProperty.String<MeasurementDocument>(MeasurementDocument.class, "MsmtRdngStatus");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtCntrReadingDiffIsEntered</b>
     * </p>
     * 
     * @return Indicator: Counter Reading Entered as Difference
     */
    @Nullable
    @ElementName( "MsmtCntrReadingDiffIsEntered" )
    private java.lang.Boolean msmtCntrReadingDiffIsEntered;
    public final static SimpleProperty.Boolean<MeasurementDocument> MSMT_CNTR_READING_DIFF_IS_ENTERED =
        new SimpleProperty.Boolean<MeasurementDocument>(MeasurementDocument.class, "MsmtCntrReadingDiffIsEntered");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngIsReversed</b>
     * </p>
     * 
     * @return Reversal Indicator
     */
    @Nullable
    @ElementName( "MsmtRdngIsReversed" )
    private java.lang.Boolean msmtRdngIsReversed;
    public final static SimpleProperty.Boolean<MeasurementDocument> MSMT_RDNG_IS_REVERSED =
        new SimpleProperty.Boolean<MeasurementDocument>(MeasurementDocument.class, "MsmtRdngIsReversed");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MeasurementDocument, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MeasurementDocument, SAP__Message>(
            MeasurementDocument.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_FailedMeasurementReading</b> for <b>MeasurementDocument</b> to multiple
     * <b>FailedMeasurementReading</b>.
     * 
     */
    @ElementName( "_FailedMeasurementReading" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FailedMeasurementReading> to_FailedMeasurementReading;
    /**
     * Navigation property <b>_MeasurementDocumentLongText</b> for <b>MeasurementDocument</b> to single
     * <b>MsmtDocumentLongText</b>.
     * 
     */
    @ElementName( "_MeasurementDocumentLongText" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MsmtDocumentLongText to_MeasurementDocumentLongText;
    /**
     * Use with available request builders to apply the <b>_FailedMeasurementReading</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MeasurementDocument, FailedMeasurementReading> TO__FAILED_MEASUREMENT_READING =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<MeasurementDocument, FailedMeasurementReading>(
            MeasurementDocument.class,
            "_FailedMeasurementReading",
            FailedMeasurementReading.class);
    /**
     * Use with available request builders to apply the <b>_MeasurementDocumentLongText</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MeasurementDocument, MsmtDocumentLongText> TO__MEASUREMENT_DOCUMENT_LONG_TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MeasurementDocument, MsmtDocumentLongText>(
            MeasurementDocument.class,
            "_MeasurementDocumentLongText",
            MsmtDocumentLongText.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MeasurementDocument> getType()
    {
        return MeasurementDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementDocument</b>
     * </p>
     * 
     * @param measurementDocument
     *            Measurement Document
     */
    public void setMeasurementDocument( @Nullable final java.lang.String measurementDocument )
    {
        rememberChangedField("MeasurementDocument", this.measurementDocument);
        this.measurementDocument = measurementDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPoint</b>
     * </p>
     * 
     * @param measuringPoint
     *            Measuring Point
     */
    public void setMeasuringPoint( @Nullable final java.lang.String measuringPoint )
    {
        rememberChangedField("MeasuringPoint", this.measuringPoint);
        this.measuringPoint = measuringPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointPositionNumber</b>
     * </p>
     * 
     * @param measuringPointPositionNumber
     *            Position Number of the Object Measuring Point (Sort Field)
     */
    public void setMeasuringPointPositionNumber( @Nullable final java.lang.String measuringPointPositionNumber )
    {
        rememberChangedField("MeasuringPointPositionNumber", this.measuringPointPositionNumber);
        this.measuringPointPositionNumber = measuringPointPositionNumber;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngDate</b>
     * </p>
     * 
     * @param msmtRdngDate
     *            Date of the Measurement
     */
    public void setMsmtRdngDate( @Nullable final LocalDate msmtRdngDate )
    {
        rememberChangedField("MsmtRdngDate", this.msmtRdngDate);
        this.msmtRdngDate = msmtRdngDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngTime</b>
     * </p>
     * 
     * @param msmtRdngTime
     *            Time of Measurement
     */
    public void setMsmtRdngTime( @Nullable final LocalTime msmtRdngTime )
    {
        rememberChangedField("MsmtRdngTime", this.msmtRdngTime);
        this.msmtRdngTime = msmtRdngTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     * 
     * @param characteristic
     *            Characteristic Name
     */
    public void setCharacteristic( @Nullable final java.lang.String characteristic )
    {
        rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MsmtDocumentReferredOrder</b>
     * </p>
     * 
     * @param msmtDocumentReferredOrder
     *            Object Number of Order
     */
    public void setMsmtDocumentReferredOrder( @Nullable final java.lang.String msmtDocumentReferredOrder )
    {
        rememberChangedField("MsmtDocumentReferredOrder", this.msmtDocumentReferredOrder);
        this.msmtDocumentReferredOrder = msmtDocumentReferredOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>RefdMaintOrderOpStatusObject</b>
     * </p>
     * 
     * @param refdMaintOrderOpStatusObject
     *            Object Number of Order Operation/Confirmation Counter etc.
     */
    public void setRefdMaintOrderOpStatusObject( @Nullable final java.lang.String refdMaintOrderOpStatusObject )
    {
        rememberChangedField("RefdMaintOrderOpStatusObject", this.refdMaintOrderOpStatusObject);
        this.refdMaintOrderOpStatusObject = refdMaintOrderOpStatusObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     * 
     * @param maintenanceOrderOperation
     *            Order Operation
     */
    public void setMaintenanceOrderOperation( @Nullable final java.lang.String maintenanceOrderOperation )
    {
        rememberChangedField("MaintenanceOrderOperation", this.maintenanceOrderOperation);
        this.maintenanceOrderOperation = maintenanceOrderOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     * 
     * @param maintenanceOrderSubOperation
     *            Order Operation
     */
    public void setMaintenanceOrderSubOperation( @Nullable final java.lang.String maintenanceOrderSubOperation )
    {
        rememberChangedField("MaintenanceOrderSubOperation", this.maintenanceOrderSubOperation);
        this.maintenanceOrderSubOperation = maintenanceOrderSubOperation;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtIsDoneAfterTaskCompltn</b>
     * </p>
     * 
     * @param msmtIsDoneAfterTaskCompltn
     *            Indicator: MeasDoc. Created After Associated Task
     */
    public void setMsmtIsDoneAfterTaskCompltn( @Nullable final java.lang.Boolean msmtIsDoneAfterTaskCompltn )
    {
        rememberChangedField("MsmtIsDoneAfterTaskCompltn", this.msmtIsDoneAfterTaskCompltn);
        this.msmtIsDoneAfterTaskCompltn = msmtIsDoneAfterTaskCompltn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueUnit</b>
     * </p>
     * 
     * @param charcValueUnit
     *            Unit of Measurement
     */
    public void setCharcValueUnit( @Nullable final java.lang.String charcValueUnit )
    {
        rememberChangedField("CharcValueUnit", this.charcValueUnit);
        this.charcValueUnit = charcValueUnit;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementReading</b>
     * </p>
     * 
     * @param measurementReading
     *            The measurementReading to set.
     */
    public void setMeasurementReading( @Nullable final Double measurementReading )
    {
        rememberChangedField("MeasurementReading", this.measurementReading);
        this.measurementReading = measurementReading;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementReadingInEntryUoM</b>
     * </p>
     * 
     * @param measurementReadingInEntryUoM
     *            The measurementReadingInEntryUoM to set.
     */
    public void setMeasurementReadingInEntryUoM( @Nullable final Double measurementReadingInEntryUoM )
    {
        rememberChangedField("MeasurementReadingInEntryUoM", this.measurementReadingInEntryUoM);
        this.measurementReadingInEntryUoM = measurementReadingInEntryUoM;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementReadingEntryUoM</b>
     * </p>
     * 
     * @param measurementReadingEntryUoM
     *            Unit of Measurement for Document Entry
     */
    public void setMeasurementReadingEntryUoM( @Nullable final java.lang.String measurementReadingEntryUoM )
    {
        rememberChangedField("MeasurementReadingEntryUoM", this.measurementReadingEntryUoM);
        this.measurementReadingEntryUoM = measurementReadingEntryUoM;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementCounterReading</b>
     * </p>
     * 
     * @param measurementCounterReading
     *            The measurementCounterReading to set.
     */
    public void setMeasurementCounterReading( @Nullable final Double measurementCounterReading )
    {
        rememberChangedField("MeasurementCounterReading", this.measurementCounterReading);
        this.measurementCounterReading = measurementCounterReading;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtCounterReadingDifference</b>
     * </p>
     * 
     * @param msmtCounterReadingDifference
     *            The msmtCounterReadingDifference to set.
     */
    public void setMsmtCounterReadingDifference( @Nullable final Double msmtCounterReadingDifference )
    {
        rememberChangedField("MsmtCounterReadingDifference", this.msmtCounterReadingDifference);
        this.msmtCounterReadingDifference = msmtCounterReadingDifference;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TotalMsmtRdngIsSetExternally</b>
     * </p>
     * 
     * @param totalMsmtRdngIsSetExternally
     *            Indicator: Total Counter Reading Set Externally
     */
    public void setTotalMsmtRdngIsSetExternally( @Nullable final java.lang.Boolean totalMsmtRdngIsSetExternally )
    {
        rememberChangedField("TotalMsmtRdngIsSetExternally", this.totalMsmtRdngIsSetExternally);
        this.totalMsmtRdngIsSetExternally = totalMsmtRdngIsSetExternally;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointTargetValue</b>
     * </p>
     * 
     * @param measuringPointTargetValue
     *            Measuring Point Target Value
     */
    public void setMeasuringPointTargetValue( @Nullable final Double measuringPointTargetValue )
    {
        rememberChangedField("MeasuringPointTargetValue", this.measuringPointTargetValue);
        this.measuringPointTargetValue = measuringPointTargetValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MsmtValuationCode</b>
     * </p>
     * 
     * @param msmtValuationCode
     *            Valuation Code
     */
    public void setMsmtValuationCode( @Nullable final java.lang.String msmtValuationCode )
    {
        rememberChangedField("MsmtValuationCode", this.msmtValuationCode);
        this.msmtValuationCode = msmtValuationCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementDocumentText</b>
     * </p>
     * 
     * @param measurementDocumentText
     *            Measurement Document Text
     */
    public void setMeasurementDocumentText( @Nullable final java.lang.String measurementDocumentText )
    {
        rememberChangedField("MeasurementDocumentText", this.measurementDocumentText);
        this.measurementDocumentText = measurementDocumentText;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementDocumentHasLongText</b>
     * </p>
     * 
     * @param measurementDocumentHasLongText
     *            Long Text Exists
     */
    public void setMeasurementDocumentHasLongText( @Nullable final java.lang.Boolean measurementDocumentHasLongText )
    {
        rememberChangedField("MeasurementDocumentHasLongText", this.measurementDocumentHasLongText);
        this.measurementDocumentHasLongText = measurementDocumentHasLongText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngByUser</b>
     * </p>
     * 
     * @param msmtRdngByUser
     *            Person who Took the Measurement Reading
     */
    public void setMsmtRdngByUser( @Nullable final java.lang.String msmtRdngByUser )
    {
        rememberChangedField("MsmtRdngByUser", this.msmtRdngByUser);
        this.msmtRdngByUser = msmtRdngByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngStatus</b>
     * </p>
     * 
     * @param msmtRdngStatus
     *            Processing Status
     */
    public void setMsmtRdngStatus( @Nullable final java.lang.String msmtRdngStatus )
    {
        rememberChangedField("MsmtRdngStatus", this.msmtRdngStatus);
        this.msmtRdngStatus = msmtRdngStatus;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtCntrReadingDiffIsEntered</b>
     * </p>
     * 
     * @param msmtCntrReadingDiffIsEntered
     *            Indicator: Counter Reading Entered as Difference
     */
    public void setMsmtCntrReadingDiffIsEntered( @Nullable final java.lang.Boolean msmtCntrReadingDiffIsEntered )
    {
        rememberChangedField("MsmtCntrReadingDiffIsEntered", this.msmtCntrReadingDiffIsEntered);
        this.msmtCntrReadingDiffIsEntered = msmtCntrReadingDiffIsEntered;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngIsReversed</b>
     * </p>
     * 
     * @param msmtRdngIsReversed
     *            Reversal Indicator
     */
    public void setMsmtRdngIsReversed( @Nullable final java.lang.Boolean msmtRdngIsReversed )
    {
        rememberChangedField("MsmtRdngIsReversed", this.msmtRdngIsReversed);
        this.msmtRdngIsReversed = msmtRdngIsReversed;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MeasurementDocument";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("MeasurementDocument", getMeasurementDocument());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("MeasurementDocument", getMeasurementDocument());
        values.put("MeasuringPoint", getMeasuringPoint());
        values.put("MeasuringPointPositionNumber", getMeasuringPointPositionNumber());
        values.put("MsmtRdngDate", getMsmtRdngDate());
        values.put("MsmtRdngTime", getMsmtRdngTime());
        values.put("Characteristic", getCharacteristic());
        values.put("MsmtDocumentReferredOrder", getMsmtDocumentReferredOrder());
        values.put("RefdMaintOrderOpStatusObject", getRefdMaintOrderOpStatusObject());
        values.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        values.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        values.put("MsmtIsDoneAfterTaskCompltn", getMsmtIsDoneAfterTaskCompltn());
        values.put("CharcValueUnit", getCharcValueUnit());
        values.put("MeasurementReading", getMeasurementReading());
        values.put("MeasurementReadingInEntryUoM", getMeasurementReadingInEntryUoM());
        values.put("MeasurementReadingEntryUoM", getMeasurementReadingEntryUoM());
        values.put("MeasurementCounterReading", getMeasurementCounterReading());
        values.put("MsmtCounterReadingDifference", getMsmtCounterReadingDifference());
        values.put("TotalMsmtRdngIsSetExternally", getTotalMsmtRdngIsSetExternally());
        values.put("MeasuringPointTargetValue", getMeasuringPointTargetValue());
        values.put("MsmtValuationCode", getMsmtValuationCode());
        values.put("MeasurementDocumentText", getMeasurementDocumentText());
        values.put("MeasurementDocumentHasLongText", getMeasurementDocumentHasLongText());
        values.put("MsmtRdngByUser", getMsmtRdngByUser());
        values.put("MsmtRdngStatus", getMsmtRdngStatus());
        values.put("MsmtCntrReadingDiffIsEntered", getMsmtCntrReadingDiffIsEntered());
        values.put("MsmtRdngIsReversed", getMsmtRdngIsReversed());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MeasurementDocument") ) {
                final Object value = values.remove("MeasurementDocument");
                if( (value == null) || (!value.equals(getMeasurementDocument())) ) {
                    setMeasurementDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasuringPoint") ) {
                final Object value = values.remove("MeasuringPoint");
                if( (value == null) || (!value.equals(getMeasuringPoint())) ) {
                    setMeasuringPoint(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasuringPointPositionNumber") ) {
                final Object value = values.remove("MeasuringPointPositionNumber");
                if( (value == null) || (!value.equals(getMeasuringPointPositionNumber())) ) {
                    setMeasuringPointPositionNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("MsmtRdngDate") ) {
                final Object value = values.remove("MsmtRdngDate");
                if( (value == null) || (!value.equals(getMsmtRdngDate())) ) {
                    setMsmtRdngDate(((LocalDate) value));
                }
            }
            if( values.containsKey("MsmtRdngTime") ) {
                final Object value = values.remove("MsmtRdngTime");
                if( (value == null) || (!value.equals(getMsmtRdngTime())) ) {
                    setMsmtRdngTime(((LocalTime) value));
                }
            }
            if( values.containsKey("Characteristic") ) {
                final Object value = values.remove("Characteristic");
                if( (value == null) || (!value.equals(getCharacteristic())) ) {
                    setCharacteristic(((java.lang.String) value));
                }
            }
            if( values.containsKey("MsmtDocumentReferredOrder") ) {
                final Object value = values.remove("MsmtDocumentReferredOrder");
                if( (value == null) || (!value.equals(getMsmtDocumentReferredOrder())) ) {
                    setMsmtDocumentReferredOrder(((java.lang.String) value));
                }
            }
            if( values.containsKey("RefdMaintOrderOpStatusObject") ) {
                final Object value = values.remove("RefdMaintOrderOpStatusObject");
                if( (value == null) || (!value.equals(getRefdMaintOrderOpStatusObject())) ) {
                    setRefdMaintOrderOpStatusObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderOperation") ) {
                final Object value = values.remove("MaintenanceOrderOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderOperation())) ) {
                    setMaintenanceOrderOperation(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderSubOperation") ) {
                final Object value = values.remove("MaintenanceOrderSubOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderSubOperation())) ) {
                    setMaintenanceOrderSubOperation(((java.lang.String) value));
                }
            }
            if( values.containsKey("MsmtIsDoneAfterTaskCompltn") ) {
                final Object value = values.remove("MsmtIsDoneAfterTaskCompltn");
                if( (value == null) || (!value.equals(getMsmtIsDoneAfterTaskCompltn())) ) {
                    setMsmtIsDoneAfterTaskCompltn(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CharcValueUnit") ) {
                final Object value = values.remove("CharcValueUnit");
                if( (value == null) || (!value.equals(getCharcValueUnit())) ) {
                    setCharcValueUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasurementReading") ) {
                final Object value = values.remove("MeasurementReading");
                if( (value == null) || (!value.equals(getMeasurementReading())) ) {
                    setMeasurementReading(((Double) value));
                }
            }
            if( values.containsKey("MeasurementReadingInEntryUoM") ) {
                final Object value = values.remove("MeasurementReadingInEntryUoM");
                if( (value == null) || (!value.equals(getMeasurementReadingInEntryUoM())) ) {
                    setMeasurementReadingInEntryUoM(((Double) value));
                }
            }
            if( values.containsKey("MeasurementReadingEntryUoM") ) {
                final Object value = values.remove("MeasurementReadingEntryUoM");
                if( (value == null) || (!value.equals(getMeasurementReadingEntryUoM())) ) {
                    setMeasurementReadingEntryUoM(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasurementCounterReading") ) {
                final Object value = values.remove("MeasurementCounterReading");
                if( (value == null) || (!value.equals(getMeasurementCounterReading())) ) {
                    setMeasurementCounterReading(((Double) value));
                }
            }
            if( values.containsKey("MsmtCounterReadingDifference") ) {
                final Object value = values.remove("MsmtCounterReadingDifference");
                if( (value == null) || (!value.equals(getMsmtCounterReadingDifference())) ) {
                    setMsmtCounterReadingDifference(((Double) value));
                }
            }
            if( values.containsKey("TotalMsmtRdngIsSetExternally") ) {
                final Object value = values.remove("TotalMsmtRdngIsSetExternally");
                if( (value == null) || (!value.equals(getTotalMsmtRdngIsSetExternally())) ) {
                    setTotalMsmtRdngIsSetExternally(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("MeasuringPointTargetValue") ) {
                final Object value = values.remove("MeasuringPointTargetValue");
                if( (value == null) || (!value.equals(getMeasuringPointTargetValue())) ) {
                    setMeasuringPointTargetValue(((Double) value));
                }
            }
            if( values.containsKey("MsmtValuationCode") ) {
                final Object value = values.remove("MsmtValuationCode");
                if( (value == null) || (!value.equals(getMsmtValuationCode())) ) {
                    setMsmtValuationCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasurementDocumentText") ) {
                final Object value = values.remove("MeasurementDocumentText");
                if( (value == null) || (!value.equals(getMeasurementDocumentText())) ) {
                    setMeasurementDocumentText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasurementDocumentHasLongText") ) {
                final Object value = values.remove("MeasurementDocumentHasLongText");
                if( (value == null) || (!value.equals(getMeasurementDocumentHasLongText())) ) {
                    setMeasurementDocumentHasLongText(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("MsmtRdngByUser") ) {
                final Object value = values.remove("MsmtRdngByUser");
                if( (value == null) || (!value.equals(getMsmtRdngByUser())) ) {
                    setMsmtRdngByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("MsmtRdngStatus") ) {
                final Object value = values.remove("MsmtRdngStatus");
                if( (value == null) || (!value.equals(getMsmtRdngStatus())) ) {
                    setMsmtRdngStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("MsmtCntrReadingDiffIsEntered") ) {
                final Object value = values.remove("MsmtCntrReadingDiffIsEntered");
                if( (value == null) || (!value.equals(getMsmtCntrReadingDiffIsEntered())) ) {
                    setMsmtCntrReadingDiffIsEntered(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("MsmtRdngIsReversed") ) {
                final Object value = values.remove("MsmtRdngIsReversed");
                if( (value == null) || (!value.equals(getMsmtRdngIsReversed())) ) {
                    setMsmtRdngIsReversed(((java.lang.Boolean) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_FailedMeasurementReading") ) {
                final Object value = (values).remove("_FailedMeasurementReading");
                if( value instanceof Iterable ) {
                    if( to_FailedMeasurementReading == null ) {
                        to_FailedMeasurementReading = Lists.newArrayList();
                    } else {
                        to_FailedMeasurementReading = Lists.newArrayList(to_FailedMeasurementReading);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FailedMeasurementReading entity;
                        if( to_FailedMeasurementReading.size() > i ) {
                            entity = to_FailedMeasurementReading.get(i);
                        } else {
                            entity = new FailedMeasurementReading();
                            to_FailedMeasurementReading.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_MeasurementDocumentLongText") ) {
                final Object value = (values).remove("_MeasurementDocumentLongText");
                if( value instanceof Map ) {
                    if( to_MeasurementDocumentLongText == null ) {
                        to_MeasurementDocumentLongText = new MsmtDocumentLongText();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_MeasurementDocumentLongText.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MeasurementDocumentService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_FailedMeasurementReading != null ) {
            (values).put("_FailedMeasurementReading", to_FailedMeasurementReading);
        }
        if( to_MeasurementDocumentLongText != null ) {
            (values).put("_MeasurementDocumentLongText", to_MeasurementDocumentLongText);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>FailedMeasurementReading</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_FailedMeasurementReading</b>.
     * <p>
     * If the navigation property for an entity <b>MeasurementDocument</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_FailedMeasurementReading</b> is already loaded, the result
     *         will contain the <b>FailedMeasurementReading</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FailedMeasurementReading>> getFailedMeasurementReadingIfPresent()
    {
        return Option.of(to_FailedMeasurementReading);
    }

    /**
     * Overwrites the list of associated <b>FailedMeasurementReading</b> entities for the loaded navigation property
     * <b>_FailedMeasurementReading</b>.
     * <p>
     * If the navigation property <b>_FailedMeasurementReading</b> of a queried <b>MeasurementDocument</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>FailedMeasurementReading</b> entities.
     */
    public void setFailedMeasurementReading( @Nonnull final List<FailedMeasurementReading> value )
    {
        if( to_FailedMeasurementReading == null ) {
            to_FailedMeasurementReading = Lists.newArrayList();
        }
        to_FailedMeasurementReading.clear();
        to_FailedMeasurementReading.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FailedMeasurementReading</b> entities. This corresponds to the OData
     * navigation property <b>_FailedMeasurementReading</b>.
     * <p>
     * If the navigation property <b>_FailedMeasurementReading</b> of a queried <b>MeasurementDocument</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>FailedMeasurementReading</b> entities.
     */
    public void addFailedMeasurementReading( FailedMeasurementReading... entity )
    {
        if( to_FailedMeasurementReading == null ) {
            to_FailedMeasurementReading = Lists.newArrayList();
        }
        to_FailedMeasurementReading.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>MsmtDocumentLongText</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_MeasurementDocumentLongText</b>.
     * <p>
     * If the navigation property for an entity <b>MeasurementDocument</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_MeasurementDocumentLongText</b> is already loaded, the
     *         result will contain the <b>MsmtDocumentLongText</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MsmtDocumentLongText> getMeasurementDocumentLongTextIfPresent()
    {
        return Option.of(to_MeasurementDocumentLongText);
    }

    /**
     * Overwrites the associated <b>MsmtDocumentLongText</b> entity for the loaded navigation property
     * <b>_MeasurementDocumentLongText</b>.
     * 
     * @param value
     *            New <b>MsmtDocumentLongText</b> entity.
     */
    public void setMeasurementDocumentLongText( final MsmtDocumentLongText value )
    {
        to_MeasurementDocumentLongText = value;
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasurementDocument, MeasurementDocument>
        deactivateReversalIndicator()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasurementDocument, MeasurementDocument>(
            MeasurementDocument.class,
            MeasurementDocument.class,
            "com.sap.gateway.srvd_a2x.api_measurementdocument.v0001.DeactivateReversalIndicator",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasurementDocument, MeasurementDocument>
        activateReversalIndicator()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasurementDocument, MeasurementDocument>(
            MeasurementDocument.class,
            MeasurementDocument.class,
            "com.sap.gateway.srvd_a2x.api_measurementdocument.v0001.ActivateReversalIndicator",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of MeasurementDocument instances.
     * 
     */
    public final static class MeasurementDocumentBuilder
    {

        private List<FailedMeasurementReading> to_FailedMeasurementReading = Lists.newArrayList();
        private MsmtDocumentLongText to_MeasurementDocumentLongText;

        private MeasurementDocument.MeasurementDocumentBuilder to_FailedMeasurementReading(
            final List<FailedMeasurementReading> value )
        {
            to_FailedMeasurementReading.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_FailedMeasurementReading</b> for <b>MeasurementDocument</b> to multiple
         * <b>FailedMeasurementReading</b>.
         * 
         * @param value
         *            The FailedMeasurementReadings to build this MeasurementDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MeasurementDocument.MeasurementDocumentBuilder failedMeasurementReading(
            FailedMeasurementReading... value )
        {
            return to_FailedMeasurementReading(Lists.newArrayList(value));
        }

        private MeasurementDocument.MeasurementDocumentBuilder to_MeasurementDocumentLongText(
            final MsmtDocumentLongText value )
        {
            to_MeasurementDocumentLongText = value;
            return this;
        }

        /**
         * Navigation property <b>_MeasurementDocumentLongText</b> for <b>MeasurementDocument</b> to single
         * <b>MsmtDocumentLongText</b>.
         * 
         * @param value
         *            The MsmtDocumentLongText to build this MeasurementDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MeasurementDocument.MeasurementDocumentBuilder measurementDocumentLongText(
            final MsmtDocumentLongText value )
        {
            return to_MeasurementDocumentLongText(value);
        }

    }

}
