/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measurementdocument;

import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MeasurementDocumentService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Measurement Document Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MsmtDocumentLongTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MsmtDocumentLongText extends VdmEntity<MsmtDocumentLongText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_measurementdocument.v0001.MsmtDocumentLongTextType";
    /**
     * Selector for all available fields of MsmtDocumentLongText.
     * 
     */
    public final static SimpleProperty<MsmtDocumentLongText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementDocument</b>
     * </p>
     * 
     * @return Measurement Document
     */
    @Nullable
    @ElementName( "MeasurementDocument" )
    private java.lang.String measurementDocument;
    public final static SimpleProperty.String<MsmtDocumentLongText> MEASUREMENT_DOCUMENT =
        new SimpleProperty.String<MsmtDocumentLongText>(MsmtDocumentLongText.class, "MeasurementDocument");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementDocumentLongText</b>
     * </p>
     * 
     * @return Long Text
     */
    @Nullable
    @ElementName( "MeasurementDocumentLongText" )
    private java.lang.String measurementDocumentLongText;
    public final static SimpleProperty.String<MsmtDocumentLongText> MEASUREMENT_DOCUMENT_LONG_TEXT =
        new SimpleProperty.String<MsmtDocumentLongText>(MsmtDocumentLongText.class, "MeasurementDocumentLongText");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MsmtDocumentLongText, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MsmtDocumentLongText, SAP__Message>(
            MsmtDocumentLongText.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_MeasurementDocument</b> for <b>MsmtDocumentLongText</b> to single
     * <b>MeasurementDocument</b>.
     * 
     */
    @ElementName( "_MeasurementDocument" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MeasurementDocument to_MeasurementDocument;
    /**
     * Use with available request builders to apply the <b>_MeasurementDocument</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MsmtDocumentLongText, MeasurementDocument> TO__MEASUREMENT_DOCUMENT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MsmtDocumentLongText, MeasurementDocument>(
            MsmtDocumentLongText.class,
            "_MeasurementDocument",
            MeasurementDocument.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MsmtDocumentLongText> getType()
    {
        return MsmtDocumentLongText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementDocument</b>
     * </p>
     * 
     * @param measurementDocument
     *            Measurement Document
     */
    public void setMeasurementDocument( @Nullable final java.lang.String measurementDocument )
    {
        rememberChangedField("MeasurementDocument", this.measurementDocument);
        this.measurementDocument = measurementDocument;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementDocumentLongText</b>
     * </p>
     * 
     * @param measurementDocumentLongText
     *            Long Text
     */
    public void setMeasurementDocumentLongText( @Nullable final java.lang.String measurementDocumentLongText )
    {
        rememberChangedField("MeasurementDocumentLongText", this.measurementDocumentLongText);
        this.measurementDocumentLongText = measurementDocumentLongText;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MsmtDocumentLongText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("MeasurementDocument", getMeasurementDocument());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("MeasurementDocument", getMeasurementDocument());
        values.put("MeasurementDocumentLongText", getMeasurementDocumentLongText());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MeasurementDocument") ) {
                final Object value = values.remove("MeasurementDocument");
                if( (value == null) || (!value.equals(getMeasurementDocument())) ) {
                    setMeasurementDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasurementDocumentLongText") ) {
                final Object value = values.remove("MeasurementDocumentLongText");
                if( (value == null) || (!value.equals(getMeasurementDocumentLongText())) ) {
                    setMeasurementDocumentLongText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_MeasurementDocument") ) {
                final Object value = (values).remove("_MeasurementDocument");
                if( value instanceof Map ) {
                    if( to_MeasurementDocument == null ) {
                        to_MeasurementDocument = new MeasurementDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_MeasurementDocument.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MeasurementDocumentService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_MeasurementDocument != null ) {
            (values).put("_MeasurementDocument", to_MeasurementDocument);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>MeasurementDocument</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_MeasurementDocument</b>.
     * <p>
     * If the navigation property for an entity <b>MsmtDocumentLongText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_MeasurementDocument</b> is already loaded, the result will
     *         contain the <b>MeasurementDocument</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MeasurementDocument> getMeasurementDocumentIfPresent()
    {
        return Option.of(to_MeasurementDocument);
    }

    /**
     * Overwrites the associated <b>MeasurementDocument</b> entity for the loaded navigation property
     * <b>_MeasurementDocument</b>.
     * 
     * @param value
     *            New <b>MeasurementDocument</b> entity.
     */
    public void setMeasurementDocument( final MeasurementDocument value )
    {
        to_MeasurementDocument = value;
    }

    /**
     * Helper class to allow for fluent creation of MsmtDocumentLongText instances.
     * 
     */
    public final static class MsmtDocumentLongTextBuilder
    {

        private MeasurementDocument to_MeasurementDocument;
        private java.lang.String measurementDocument = null;

        private MsmtDocumentLongText.MsmtDocumentLongTextBuilder to_MeasurementDocument(
            final MeasurementDocument value )
        {
            to_MeasurementDocument = value;
            return this;
        }

        /**
         * Navigation property <b>_MeasurementDocument</b> for <b>MsmtDocumentLongText</b> to single
         * <b>MeasurementDocument</b>.
         * 
         * @param value
         *            The MeasurementDocument to build this MsmtDocumentLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MsmtDocumentLongText.MsmtDocumentLongTextBuilder measurementDocument( final MeasurementDocument value )
        {
            return to_MeasurementDocument(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 20
         * <p>
         * Original property name from the Odata EDM: <b>MeasurementDocument</b>
         * </p>
         * 
         * @param value
         *            The measurementDocument to build this MsmtDocumentLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MsmtDocumentLongText.MsmtDocumentLongTextBuilder measurementDocument( final java.lang.String value )
        {
            measurementDocument = value;
            return this;
        }

    }

}
