/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MeasuringPointService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Measuring Points
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MeasuringPointType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MeasuringPoint extends VdmEntity<MeasuringPoint> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_measuringpoint.v0001.MeasuringPointType";
    /**
     * Selector for all available fields of MeasuringPoint.
     * 
     */
    public final static SimpleProperty<MeasuringPoint> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPoint</b>
     * </p>
     * 
     * @return Measuring Point
     */
    @Nullable
    @ElementName( "MeasuringPoint" )
    private java.lang.String measuringPoint;
    public final static SimpleProperty.String<MeasuringPoint> MEASURING_POINT =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "MeasuringPoint");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointDescription</b>
     * </p>
     * 
     * @return Description of Measuring Point
     */
    @Nullable
    @ElementName( "MeasuringPointDescription" )
    private java.lang.String measuringPointDescription;
    public final static SimpleProperty.String<MeasuringPoint> MEASURING_POINT_DESCRIPTION =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointDescription");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointObjectIdentifier</b>
     * </p>
     * 
     * @return Object Number for the Measuring Point Object
     */
    @Nullable
    @ElementName( "MeasuringPointObjectIdentifier" )
    private java.lang.String measuringPointObjectIdentifier;
    public final static SimpleProperty.String<MeasuringPoint> MEASURING_POINT_OBJECT_IDENTIFIER =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointObjectIdentifier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectType</b>
     * </p>
     * 
     * @return Type of Technical Object
     */
    @Nullable
    @ElementName( "TechnicalObjectType" )
    private java.lang.String technicalObjectType;
    public final static SimpleProperty.String<MeasuringPoint> TECHNICAL_OBJECT_TYPE =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "TechnicalObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointPositionNumber</b>
     * </p>
     * 
     * @return Position Number of the Object Measuring Point (Sort Field)
     */
    @Nullable
    @ElementName( "MeasuringPointPositionNumber" )
    private java.lang.String measuringPointPositionNumber;
    public final static SimpleProperty.String<MeasuringPoint> MEASURING_POINT_POSITION_NUMBER =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointPositionNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointCategory</b>
     * </p>
     * 
     * @return Measuring Point Category
     */
    @Nullable
    @ElementName( "MeasuringPointCategory" )
    private java.lang.String measuringPointCategory;
    public final static SimpleProperty.String<MeasuringPoint> MEASURING_POINT_CATEGORY =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointCategory");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointIsCounter</b>
     * </p>
     * 
     * @return Indicator to Show that Measuring Point Is a Counter
     */
    @Nullable
    @ElementName( "MeasuringPointIsCounter" )
    private java.lang.Boolean measuringPointIsCounter;
    public final static SimpleProperty.Boolean<MeasuringPoint> MEASURING_POINT_IS_COUNTER =
        new SimpleProperty.Boolean<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointIsCounter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MsrgPtInternalCharacteristic</b>
     * </p>
     * 
     * @return Characteristic Internal ID
     */
    @Nullable
    @ElementName( "MsrgPtInternalCharacteristic" )
    private java.lang.String msrgPtInternalCharacteristic;
    public final static SimpleProperty.String<MeasuringPoint> MSRG_PT_INTERNAL_CHARACTERISTIC =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "MsrgPtInternalCharacteristic");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueUnit</b>
     * </p>
     * 
     * @return Unit of Measurement
     */
    @Nullable
    @ElementName( "CharcValueUnit" )
    private java.lang.String charcValueUnit;
    public final static SimpleProperty.String<MeasuringPoint> CHARC_VALUE_UNIT =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "CharcValueUnit");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointDecimalPlaces</b>
     * </p>
     * 
     * @return Number of Decimal Places for Number Display
     */
    @Nullable
    @ElementName( "MeasuringPointDecimalPlaces" )
    private Short measuringPointDecimalPlaces;
    public final static SimpleProperty.NumericInteger<MeasuringPoint> MEASURING_POINT_DECIMAL_PLACES =
        new SimpleProperty.NumericInteger<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointDecimalPlaces");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointExponent</b>
     * </p>
     * 
     * @return Power of Ten Exponent for Floating Point Display
     */
    @Nullable
    @ElementName( "MeasuringPointExponent" )
    private Short measuringPointExponent;
    public final static SimpleProperty.NumericInteger<MeasuringPoint> MEASURING_POINT_EXPONENT =
        new SimpleProperty.NumericInteger<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointExponent");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointCodeGroup</b>
     * </p>
     * 
     * @return Code Group - Measurement Reading Valuation Code
     */
    @Nullable
    @ElementName( "MeasuringPointCodeGroup" )
    private java.lang.String measuringPointCodeGroup;
    public final static SimpleProperty.String<MeasuringPoint> MEASURING_POINT_CODE_GROUP =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointCodeGroup");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValuationCodeIsSufficient</b>
     * </p>
     * 
     * @return Indicator: Valuation Code Sufficient for Measurmnt. Document
     */
    @Nullable
    @ElementName( "ValuationCodeIsSufficient" )
    private java.lang.Boolean valuationCodeIsSufficient;
    public final static SimpleProperty.Boolean<MeasuringPoint> VALUATION_CODE_IS_SUFFICIENT =
        new SimpleProperty.Boolean<MeasuringPoint>(MeasuringPoint.class, "ValuationCodeIsSufficient");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     * 
     * @return Assembly for Localization of Measuring Point
     */
    @Nullable
    @ElementName( "Assembly" )
    private java.lang.String assembly;
    public final static SimpleProperty.String<MeasuringPoint> ASSEMBLY =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "Assembly");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointIsInactive</b>
     * </p>
     * 
     * @return Indicator: Measuring Point Inactive
     */
    @Nullable
    @ElementName( "MeasuringPointIsInactive" )
    private java.lang.Boolean measuringPointIsInactive;
    public final static SimpleProperty.Boolean<MeasuringPoint> MEASURING_POINT_IS_INACTIVE =
        new SimpleProperty.Boolean<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointIsInactive");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointShortText</b>
     * </p>
     * 
     * @return Aditional Short Text for Measuring Point
     */
    @Nullable
    @ElementName( "MeasuringPointShortText" )
    private java.lang.String measuringPointShortText;
    public final static SimpleProperty.String<MeasuringPoint> MEASURING_POINT_SHORT_TEXT =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointShortText");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementRangeUnit</b>
     * </p>
     * 
     * @return Measurement Range Unit
     */
    @Nullable
    @ElementName( "MeasurementRangeUnit" )
    private java.lang.String measurementRangeUnit;
    public final static SimpleProperty.String<MeasuringPoint> MEASUREMENT_RANGE_UNIT =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "MeasurementRangeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngSourceMeasuringPoint</b>
     * </p>
     * 
     * @return Measuring Point from Which Meas. Reading Was Transferred
     */
    @Nullable
    @ElementName( "MsmtRdngSourceMeasuringPoint" )
    private java.lang.String msmtRdngSourceMeasuringPoint;
    public final static SimpleProperty.String<MeasuringPoint> MSMT_RDNG_SOURCE_MEASURING_POINT =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "MsmtRdngSourceMeasuringPoint");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointTargetValue</b>
     * </p>
     * 
     * @return Measuring Point Target Value
     */
    @Nullable
    @ElementName( "MeasuringPointTargetValue" )
    private Double measuringPointTargetValue;
    public final static SimpleProperty.NumericDecimal<MeasuringPoint> MEASURING_POINT_TARGET_VALUE =
        new SimpleProperty.NumericDecimal<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointTargetValue");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointMaximumThreshold</b>
     * </p>
     * 
     * @return Upper Measurement Range Limit/Maximum Total Counter Reading
     */
    @Nullable
    @ElementName( "MeasuringPointMaximumThreshold" )
    private Double measuringPointMaximumThreshold;
    public final static SimpleProperty.NumericDecimal<MeasuringPoint> MEASURING_POINT_MAXIMUM_THRESHOLD =
        new SimpleProperty.NumericDecimal<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointMaximumThreshold");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointMinimumThreshold</b>
     * </p>
     * 
     * @return Lower Measurement Range Limit/Minimum Total Counter Reading
     */
    @Nullable
    @ElementName( "MeasuringPointMinimumThreshold" )
    private Double measuringPointMinimumThreshold;
    public final static SimpleProperty.NumericDecimal<MeasuringPoint> MEASURING_POINT_MINIMUM_THRESHOLD =
        new SimpleProperty.NumericDecimal<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointMinimumThreshold");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointAnnualEstimate</b>
     * </p>
     * 
     * @return Annual Estimate in SI Unit
     */
    @Nullable
    @ElementName( "MeasuringPointAnnualEstimate" )
    private Double measuringPointAnnualEstimate;
    public final static SimpleProperty.NumericDecimal<MeasuringPoint> MEASURING_POINT_ANNUAL_ESTIMATE =
        new SimpleProperty.NumericDecimal<MeasuringPoint>(MeasuringPoint.class, "MeasuringPointAnnualEstimate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CounterOverflowRdngThreshold</b>
     * </p>
     * 
     * @return Counter Overflow Reading in SI Unit
     */
    @Nullable
    @ElementName( "CounterOverflowRdngThreshold" )
    private Double counterOverflowRdngThreshold;
    public final static SimpleProperty.NumericDecimal<MeasuringPoint> COUNTER_OVERFLOW_RDNG_THRESHOLD =
        new SimpleProperty.NumericDecimal<MeasuringPoint>(MeasuringPoint.class, "CounterOverflowRdngThreshold");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsrgPtIsCountingBackwards</b>
     * </p>
     * 
     * @return Indicator: Counter Runs Backwards
     */
    @Nullable
    @ElementName( "MsrgPtIsCountingBackwards" )
    private java.lang.Boolean msrgPtIsCountingBackwards;
    public final static SimpleProperty.Boolean<MeasuringPoint> MSRG_PT_IS_COUNTING_BACKWARDS =
        new SimpleProperty.Boolean<MeasuringPoint>(MeasuringPoint.class, "MsrgPtIsCountingBackwards");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementTransferIsSupported</b>
     * </p>
     * 
     * @return Indicator That Measurement Reading Transfer is Supported
     */
    @Nullable
    @ElementName( "MeasurementTransferIsSupported" )
    private java.lang.Boolean measurementTransferIsSupported;
    public final static SimpleProperty.Boolean<MeasuringPoint> MEASUREMENT_TRANSFER_IS_SUPPORTED =
        new SimpleProperty.Boolean<MeasuringPoint>(MeasuringPoint.class, "MeasurementTransferIsSupported");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     * 
     * @return Functional location
     */
    @Nullable
    @ElementName( "FunctionalLocation" )
    private java.lang.String functionalLocation;
    public final static SimpleProperty.String<MeasuringPoint> FUNCTIONAL_LOCATION =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "FunctionalLocation");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     * 
     * @return Equipment Number
     */
    @Nullable
    @ElementName( "Equipment" )
    private java.lang.String equipment;
    public final static SimpleProperty.String<MeasuringPoint> EQUIPMENT =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngTransferMode</b>
     * </p>
     * 
     * @return Mode of Counter Reading Transfer
     */
    @Nullable
    @ElementName( "MsmtRdngTransferMode" )
    private java.lang.String msmtRdngTransferMode;
    public final static SimpleProperty.String<MeasuringPoint> MSMT_RDNG_TRANSFER_MODE =
        new SimpleProperty.String<MeasuringPoint>(MeasuringPoint.class, "MsmtRdngTransferMode");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MeasuringPoint, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MeasuringPoint, SAP__Message>(
            MeasuringPoint.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_LongText</b> for <b>MeasuringPoint</b> to single <b>MeasuringPointLongText</b>.
     * 
     */
    @ElementName( "_LongText" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MeasuringPointLongText to_LongText;
    /**
     * Use with available request builders to apply the <b>_LongText</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MeasuringPoint, MeasuringPointLongText> TO__LONG_TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MeasuringPoint, MeasuringPointLongText>(
            MeasuringPoint.class,
            "_LongText",
            MeasuringPointLongText.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MeasuringPoint> getType()
    {
        return MeasuringPoint.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPoint</b>
     * </p>
     * 
     * @param measuringPoint
     *            Measuring Point
     */
    public void setMeasuringPoint( @Nullable final java.lang.String measuringPoint )
    {
        rememberChangedField("MeasuringPoint", this.measuringPoint);
        this.measuringPoint = measuringPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointDescription</b>
     * </p>
     * 
     * @param measuringPointDescription
     *            Description of Measuring Point
     */
    public void setMeasuringPointDescription( @Nullable final java.lang.String measuringPointDescription )
    {
        rememberChangedField("MeasuringPointDescription", this.measuringPointDescription);
        this.measuringPointDescription = measuringPointDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointObjectIdentifier</b>
     * </p>
     * 
     * @param measuringPointObjectIdentifier
     *            Object Number for the Measuring Point Object
     */
    public void setMeasuringPointObjectIdentifier( @Nullable final java.lang.String measuringPointObjectIdentifier )
    {
        rememberChangedField("MeasuringPointObjectIdentifier", this.measuringPointObjectIdentifier);
        this.measuringPointObjectIdentifier = measuringPointObjectIdentifier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectType</b>
     * </p>
     * 
     * @param technicalObjectType
     *            Type of Technical Object
     */
    public void setTechnicalObjectType( @Nullable final java.lang.String technicalObjectType )
    {
        rememberChangedField("TechnicalObjectType", this.technicalObjectType);
        this.technicalObjectType = technicalObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointPositionNumber</b>
     * </p>
     * 
     * @param measuringPointPositionNumber
     *            Position Number of the Object Measuring Point (Sort Field)
     */
    public void setMeasuringPointPositionNumber( @Nullable final java.lang.String measuringPointPositionNumber )
    {
        rememberChangedField("MeasuringPointPositionNumber", this.measuringPointPositionNumber);
        this.measuringPointPositionNumber = measuringPointPositionNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointCategory</b>
     * </p>
     * 
     * @param measuringPointCategory
     *            Measuring Point Category
     */
    public void setMeasuringPointCategory( @Nullable final java.lang.String measuringPointCategory )
    {
        rememberChangedField("MeasuringPointCategory", this.measuringPointCategory);
        this.measuringPointCategory = measuringPointCategory;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointIsCounter</b>
     * </p>
     * 
     * @param measuringPointIsCounter
     *            Indicator to Show that Measuring Point Is a Counter
     */
    public void setMeasuringPointIsCounter( @Nullable final java.lang.Boolean measuringPointIsCounter )
    {
        rememberChangedField("MeasuringPointIsCounter", this.measuringPointIsCounter);
        this.measuringPointIsCounter = measuringPointIsCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MsrgPtInternalCharacteristic</b>
     * </p>
     * 
     * @param msrgPtInternalCharacteristic
     *            Characteristic Internal ID
     */
    public void setMsrgPtInternalCharacteristic( @Nullable final java.lang.String msrgPtInternalCharacteristic )
    {
        rememberChangedField("MsrgPtInternalCharacteristic", this.msrgPtInternalCharacteristic);
        this.msrgPtInternalCharacteristic = msrgPtInternalCharacteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueUnit</b>
     * </p>
     * 
     * @param charcValueUnit
     *            Unit of Measurement
     */
    public void setCharcValueUnit( @Nullable final java.lang.String charcValueUnit )
    {
        rememberChangedField("CharcValueUnit", this.charcValueUnit);
        this.charcValueUnit = charcValueUnit;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointDecimalPlaces</b>
     * </p>
     * 
     * @param measuringPointDecimalPlaces
     *            Number of Decimal Places for Number Display
     */
    public void setMeasuringPointDecimalPlaces( @Nullable final Short measuringPointDecimalPlaces )
    {
        rememberChangedField("MeasuringPointDecimalPlaces", this.measuringPointDecimalPlaces);
        this.measuringPointDecimalPlaces = measuringPointDecimalPlaces;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointExponent</b>
     * </p>
     * 
     * @param measuringPointExponent
     *            Power of Ten Exponent for Floating Point Display
     */
    public void setMeasuringPointExponent( @Nullable final Short measuringPointExponent )
    {
        rememberChangedField("MeasuringPointExponent", this.measuringPointExponent);
        this.measuringPointExponent = measuringPointExponent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointCodeGroup</b>
     * </p>
     * 
     * @param measuringPointCodeGroup
     *            Code Group - Measurement Reading Valuation Code
     */
    public void setMeasuringPointCodeGroup( @Nullable final java.lang.String measuringPointCodeGroup )
    {
        rememberChangedField("MeasuringPointCodeGroup", this.measuringPointCodeGroup);
        this.measuringPointCodeGroup = measuringPointCodeGroup;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValuationCodeIsSufficient</b>
     * </p>
     * 
     * @param valuationCodeIsSufficient
     *            Indicator: Valuation Code Sufficient for Measurmnt. Document
     */
    public void setValuationCodeIsSufficient( @Nullable final java.lang.Boolean valuationCodeIsSufficient )
    {
        rememberChangedField("ValuationCodeIsSufficient", this.valuationCodeIsSufficient);
        this.valuationCodeIsSufficient = valuationCodeIsSufficient;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     * 
     * @param assembly
     *            Assembly for Localization of Measuring Point
     */
    public void setAssembly( @Nullable final java.lang.String assembly )
    {
        rememberChangedField("Assembly", this.assembly);
        this.assembly = assembly;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointIsInactive</b>
     * </p>
     * 
     * @param measuringPointIsInactive
     *            Indicator: Measuring Point Inactive
     */
    public void setMeasuringPointIsInactive( @Nullable final java.lang.Boolean measuringPointIsInactive )
    {
        rememberChangedField("MeasuringPointIsInactive", this.measuringPointIsInactive);
        this.measuringPointIsInactive = measuringPointIsInactive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointShortText</b>
     * </p>
     * 
     * @param measuringPointShortText
     *            Aditional Short Text for Measuring Point
     */
    public void setMeasuringPointShortText( @Nullable final java.lang.String measuringPointShortText )
    {
        rememberChangedField("MeasuringPointShortText", this.measuringPointShortText);
        this.measuringPointShortText = measuringPointShortText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementRangeUnit</b>
     * </p>
     * 
     * @param measurementRangeUnit
     *            Measurement Range Unit
     */
    public void setMeasurementRangeUnit( @Nullable final java.lang.String measurementRangeUnit )
    {
        rememberChangedField("MeasurementRangeUnit", this.measurementRangeUnit);
        this.measurementRangeUnit = measurementRangeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngSourceMeasuringPoint</b>
     * </p>
     * 
     * @param msmtRdngSourceMeasuringPoint
     *            Measuring Point from Which Meas. Reading Was Transferred
     */
    public void setMsmtRdngSourceMeasuringPoint( @Nullable final java.lang.String msmtRdngSourceMeasuringPoint )
    {
        rememberChangedField("MsmtRdngSourceMeasuringPoint", this.msmtRdngSourceMeasuringPoint);
        this.msmtRdngSourceMeasuringPoint = msmtRdngSourceMeasuringPoint;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointTargetValue</b>
     * </p>
     * 
     * @param measuringPointTargetValue
     *            Measuring Point Target Value
     */
    public void setMeasuringPointTargetValue( @Nullable final Double measuringPointTargetValue )
    {
        rememberChangedField("MeasuringPointTargetValue", this.measuringPointTargetValue);
        this.measuringPointTargetValue = measuringPointTargetValue;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointMaximumThreshold</b>
     * </p>
     * 
     * @param measuringPointMaximumThreshold
     *            Upper Measurement Range Limit/Maximum Total Counter Reading
     */
    public void setMeasuringPointMaximumThreshold( @Nullable final Double measuringPointMaximumThreshold )
    {
        rememberChangedField("MeasuringPointMaximumThreshold", this.measuringPointMaximumThreshold);
        this.measuringPointMaximumThreshold = measuringPointMaximumThreshold;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointMinimumThreshold</b>
     * </p>
     * 
     * @param measuringPointMinimumThreshold
     *            Lower Measurement Range Limit/Minimum Total Counter Reading
     */
    public void setMeasuringPointMinimumThreshold( @Nullable final Double measuringPointMinimumThreshold )
    {
        rememberChangedField("MeasuringPointMinimumThreshold", this.measuringPointMinimumThreshold);
        this.measuringPointMinimumThreshold = measuringPointMinimumThreshold;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointAnnualEstimate</b>
     * </p>
     * 
     * @param measuringPointAnnualEstimate
     *            Annual Estimate in SI Unit
     */
    public void setMeasuringPointAnnualEstimate( @Nullable final Double measuringPointAnnualEstimate )
    {
        rememberChangedField("MeasuringPointAnnualEstimate", this.measuringPointAnnualEstimate);
        this.measuringPointAnnualEstimate = measuringPointAnnualEstimate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CounterOverflowRdngThreshold</b>
     * </p>
     * 
     * @param counterOverflowRdngThreshold
     *            Counter Overflow Reading in SI Unit
     */
    public void setCounterOverflowRdngThreshold( @Nullable final Double counterOverflowRdngThreshold )
    {
        rememberChangedField("CounterOverflowRdngThreshold", this.counterOverflowRdngThreshold);
        this.counterOverflowRdngThreshold = counterOverflowRdngThreshold;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MsrgPtIsCountingBackwards</b>
     * </p>
     * 
     * @param msrgPtIsCountingBackwards
     *            Indicator: Counter Runs Backwards
     */
    public void setMsrgPtIsCountingBackwards( @Nullable final java.lang.Boolean msrgPtIsCountingBackwards )
    {
        rememberChangedField("MsrgPtIsCountingBackwards", this.msrgPtIsCountingBackwards);
        this.msrgPtIsCountingBackwards = msrgPtIsCountingBackwards;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasurementTransferIsSupported</b>
     * </p>
     * 
     * @param measurementTransferIsSupported
     *            Indicator That Measurement Reading Transfer is Supported
     */
    public void setMeasurementTransferIsSupported( @Nullable final java.lang.Boolean measurementTransferIsSupported )
    {
        rememberChangedField("MeasurementTransferIsSupported", this.measurementTransferIsSupported);
        this.measurementTransferIsSupported = measurementTransferIsSupported;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     * 
     * @param functionalLocation
     *            Functional location
     */
    public void setFunctionalLocation( @Nullable final java.lang.String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     * 
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final java.lang.String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MsmtRdngTransferMode</b>
     * </p>
     * 
     * @param msmtRdngTransferMode
     *            Mode of Counter Reading Transfer
     */
    public void setMsmtRdngTransferMode( @Nullable final java.lang.String msmtRdngTransferMode )
    {
        rememberChangedField("MsmtRdngTransferMode", this.msmtRdngTransferMode);
        this.msmtRdngTransferMode = msmtRdngTransferMode;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MeasuringPoint";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("MeasuringPoint", getMeasuringPoint());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("MeasuringPoint", getMeasuringPoint());
        values.put("MeasuringPointDescription", getMeasuringPointDescription());
        values.put("MeasuringPointObjectIdentifier", getMeasuringPointObjectIdentifier());
        values.put("TechnicalObjectType", getTechnicalObjectType());
        values.put("MeasuringPointPositionNumber", getMeasuringPointPositionNumber());
        values.put("MeasuringPointCategory", getMeasuringPointCategory());
        values.put("MeasuringPointIsCounter", getMeasuringPointIsCounter());
        values.put("MsrgPtInternalCharacteristic", getMsrgPtInternalCharacteristic());
        values.put("CharcValueUnit", getCharcValueUnit());
        values.put("MeasuringPointDecimalPlaces", getMeasuringPointDecimalPlaces());
        values.put("MeasuringPointExponent", getMeasuringPointExponent());
        values.put("MeasuringPointCodeGroup", getMeasuringPointCodeGroup());
        values.put("ValuationCodeIsSufficient", getValuationCodeIsSufficient());
        values.put("Assembly", getAssembly());
        values.put("MeasuringPointIsInactive", getMeasuringPointIsInactive());
        values.put("MeasuringPointShortText", getMeasuringPointShortText());
        values.put("MeasurementRangeUnit", getMeasurementRangeUnit());
        values.put("MsmtRdngSourceMeasuringPoint", getMsmtRdngSourceMeasuringPoint());
        values.put("MeasuringPointTargetValue", getMeasuringPointTargetValue());
        values.put("MeasuringPointMaximumThreshold", getMeasuringPointMaximumThreshold());
        values.put("MeasuringPointMinimumThreshold", getMeasuringPointMinimumThreshold());
        values.put("MeasuringPointAnnualEstimate", getMeasuringPointAnnualEstimate());
        values.put("CounterOverflowRdngThreshold", getCounterOverflowRdngThreshold());
        values.put("MsrgPtIsCountingBackwards", getMsrgPtIsCountingBackwards());
        values.put("MeasurementTransferIsSupported", getMeasurementTransferIsSupported());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("Equipment", getEquipment());
        values.put("MsmtRdngTransferMode", getMsmtRdngTransferMode());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MeasuringPoint") ) {
                final Object value = values.remove("MeasuringPoint");
                if( (value == null) || (!value.equals(getMeasuringPoint())) ) {
                    setMeasuringPoint(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasuringPointDescription") ) {
                final Object value = values.remove("MeasuringPointDescription");
                if( (value == null) || (!value.equals(getMeasuringPointDescription())) ) {
                    setMeasuringPointDescription(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasuringPointObjectIdentifier") ) {
                final Object value = values.remove("MeasuringPointObjectIdentifier");
                if( (value == null) || (!value.equals(getMeasuringPointObjectIdentifier())) ) {
                    setMeasuringPointObjectIdentifier(((java.lang.String) value));
                }
            }
            if( values.containsKey("TechnicalObjectType") ) {
                final Object value = values.remove("TechnicalObjectType");
                if( (value == null) || (!value.equals(getTechnicalObjectType())) ) {
                    setTechnicalObjectType(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasuringPointPositionNumber") ) {
                final Object value = values.remove("MeasuringPointPositionNumber");
                if( (value == null) || (!value.equals(getMeasuringPointPositionNumber())) ) {
                    setMeasuringPointPositionNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasuringPointCategory") ) {
                final Object value = values.remove("MeasuringPointCategory");
                if( (value == null) || (!value.equals(getMeasuringPointCategory())) ) {
                    setMeasuringPointCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasuringPointIsCounter") ) {
                final Object value = values.remove("MeasuringPointIsCounter");
                if( (value == null) || (!value.equals(getMeasuringPointIsCounter())) ) {
                    setMeasuringPointIsCounter(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("MsrgPtInternalCharacteristic") ) {
                final Object value = values.remove("MsrgPtInternalCharacteristic");
                if( (value == null) || (!value.equals(getMsrgPtInternalCharacteristic())) ) {
                    setMsrgPtInternalCharacteristic(((java.lang.String) value));
                }
            }
            if( values.containsKey("CharcValueUnit") ) {
                final Object value = values.remove("CharcValueUnit");
                if( (value == null) || (!value.equals(getCharcValueUnit())) ) {
                    setCharcValueUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasuringPointDecimalPlaces") ) {
                final Object value = values.remove("MeasuringPointDecimalPlaces");
                if( (value == null) || (!value.equals(getMeasuringPointDecimalPlaces())) ) {
                    setMeasuringPointDecimalPlaces(((Short) value));
                }
            }
            if( values.containsKey("MeasuringPointExponent") ) {
                final Object value = values.remove("MeasuringPointExponent");
                if( (value == null) || (!value.equals(getMeasuringPointExponent())) ) {
                    setMeasuringPointExponent(((Short) value));
                }
            }
            if( values.containsKey("MeasuringPointCodeGroup") ) {
                final Object value = values.remove("MeasuringPointCodeGroup");
                if( (value == null) || (!value.equals(getMeasuringPointCodeGroup())) ) {
                    setMeasuringPointCodeGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValuationCodeIsSufficient") ) {
                final Object value = values.remove("ValuationCodeIsSufficient");
                if( (value == null) || (!value.equals(getValuationCodeIsSufficient())) ) {
                    setValuationCodeIsSufficient(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("Assembly") ) {
                final Object value = values.remove("Assembly");
                if( (value == null) || (!value.equals(getAssembly())) ) {
                    setAssembly(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasuringPointIsInactive") ) {
                final Object value = values.remove("MeasuringPointIsInactive");
                if( (value == null) || (!value.equals(getMeasuringPointIsInactive())) ) {
                    setMeasuringPointIsInactive(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("MeasuringPointShortText") ) {
                final Object value = values.remove("MeasuringPointShortText");
                if( (value == null) || (!value.equals(getMeasuringPointShortText())) ) {
                    setMeasuringPointShortText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasurementRangeUnit") ) {
                final Object value = values.remove("MeasurementRangeUnit");
                if( (value == null) || (!value.equals(getMeasurementRangeUnit())) ) {
                    setMeasurementRangeUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("MsmtRdngSourceMeasuringPoint") ) {
                final Object value = values.remove("MsmtRdngSourceMeasuringPoint");
                if( (value == null) || (!value.equals(getMsmtRdngSourceMeasuringPoint())) ) {
                    setMsmtRdngSourceMeasuringPoint(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasuringPointTargetValue") ) {
                final Object value = values.remove("MeasuringPointTargetValue");
                if( (value == null) || (!value.equals(getMeasuringPointTargetValue())) ) {
                    setMeasuringPointTargetValue(((Double) value));
                }
            }
            if( values.containsKey("MeasuringPointMaximumThreshold") ) {
                final Object value = values.remove("MeasuringPointMaximumThreshold");
                if( (value == null) || (!value.equals(getMeasuringPointMaximumThreshold())) ) {
                    setMeasuringPointMaximumThreshold(((Double) value));
                }
            }
            if( values.containsKey("MeasuringPointMinimumThreshold") ) {
                final Object value = values.remove("MeasuringPointMinimumThreshold");
                if( (value == null) || (!value.equals(getMeasuringPointMinimumThreshold())) ) {
                    setMeasuringPointMinimumThreshold(((Double) value));
                }
            }
            if( values.containsKey("MeasuringPointAnnualEstimate") ) {
                final Object value = values.remove("MeasuringPointAnnualEstimate");
                if( (value == null) || (!value.equals(getMeasuringPointAnnualEstimate())) ) {
                    setMeasuringPointAnnualEstimate(((Double) value));
                }
            }
            if( values.containsKey("CounterOverflowRdngThreshold") ) {
                final Object value = values.remove("CounterOverflowRdngThreshold");
                if( (value == null) || (!value.equals(getCounterOverflowRdngThreshold())) ) {
                    setCounterOverflowRdngThreshold(((Double) value));
                }
            }
            if( values.containsKey("MsrgPtIsCountingBackwards") ) {
                final Object value = values.remove("MsrgPtIsCountingBackwards");
                if( (value == null) || (!value.equals(getMsrgPtIsCountingBackwards())) ) {
                    setMsrgPtIsCountingBackwards(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("MeasurementTransferIsSupported") ) {
                final Object value = values.remove("MeasurementTransferIsSupported");
                if( (value == null) || (!value.equals(getMeasurementTransferIsSupported())) ) {
                    setMeasurementTransferIsSupported(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((java.lang.String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((java.lang.String) value));
                }
            }
            if( values.containsKey("MsmtRdngTransferMode") ) {
                final Object value = values.remove("MsmtRdngTransferMode");
                if( (value == null) || (!value.equals(getMsmtRdngTransferMode())) ) {
                    setMsmtRdngTransferMode(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_LongText") ) {
                final Object value = (values).remove("_LongText");
                if( value instanceof Map ) {
                    if( to_LongText == null ) {
                        to_LongText = new MeasuringPointLongText();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_LongText.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MeasuringPointService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_LongText != null ) {
            (values).put("_LongText", to_LongText);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>MeasuringPointLongText</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_LongText</b>.
     * <p>
     * If the navigation property for an entity <b>MeasuringPoint</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_LongText</b> is already loaded, the result will contain
     *         the <b>MeasuringPointLongText</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MeasuringPointLongText> getLongTextIfPresent()
    {
        return Option.of(to_LongText);
    }

    /**
     * Overwrites the associated <b>MeasuringPointLongText</b> entity for the loaded navigation property
     * <b>_LongText</b>.
     * 
     * @param value
     *            New <b>MeasuringPointLongText</b> entity.
     */
    public void setLongText( final MeasuringPointLongText value )
    {
        to_LongText = value;
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param msmtRdngIntervalStartDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MsmtRdngIntervalStartDate</b>
     *            </p>
     * @param msmtRdngIntervalEndDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MsmtRdngIntervalEndDate</b>
     *            </p>
     * @param msmtRdngSourceMeasuringPoint
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MsmtRdngSourceMeasuringPoint</b>
     *            </p>
     * @param msmtRdngTransferMode
     *            Constraints: Not nullable, Maximum length: 1
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MsmtRdngTransferMode</b>
     *            </p>
     * @param msmtRdngIntervalEndTime
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MsmtRdngIntervalEndTime</b>
     *            </p>
     * @param msmtRdngIntervalStartTime
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MsmtRdngIntervalStartTime</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasuringPoint, MeasuringPoint>
        startMsmtReadingTransfer(
            @Nonnull final LocalDate msmtRdngIntervalStartDate,
            @Nonnull final LocalTime msmtRdngIntervalStartTime,
            @Nonnull final LocalDate msmtRdngIntervalEndDate,
            @Nonnull final LocalTime msmtRdngIntervalEndTime,
            @Nonnull final java.lang.String msmtRdngSourceMeasuringPoint,
            @Nonnull final java.lang.String msmtRdngTransferMode )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("MsmtRdngIntervalStartDate", msmtRdngIntervalStartDate);
        parameters.put("MsmtRdngIntervalStartTime", msmtRdngIntervalStartTime);
        parameters.put("MsmtRdngIntervalEndDate", msmtRdngIntervalEndDate);
        parameters.put("MsmtRdngIntervalEndTime", msmtRdngIntervalEndTime);
        parameters.put("MsmtRdngSourceMeasuringPoint", msmtRdngSourceMeasuringPoint);
        parameters.put("MsmtRdngTransferMode", msmtRdngTransferMode);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasuringPoint, MeasuringPoint>(
            MeasuringPoint.class,
            MeasuringPoint.class,
            "com.sap.gateway.srvd_a2x.api_measuringpoint.v0001.StartMsmtReadingTransfer",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasuringPoint, MeasuringPoint>
        deactivateMeasuringPoint()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasuringPoint, MeasuringPoint>(
            MeasuringPoint.class,
            MeasuringPoint.class,
            "com.sap.gateway.srvd_a2x.api_measuringpoint.v0001.DeactivateMeasuringPoint",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param msmtRdngIntervalEndDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MsmtRdngIntervalEndDate</b>
     *            </p>
     * @param msmtRdngIntervalEndTime
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MsmtRdngIntervalEndTime</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasuringPoint, MeasuringPoint>
        cancelMsmtReadingTransfer(
            @Nonnull final LocalDate msmtRdngIntervalEndDate,
            @Nonnull final LocalTime msmtRdngIntervalEndTime )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("MsmtRdngIntervalEndDate", msmtRdngIntervalEndDate);
        parameters.put("MsmtRdngIntervalEndTime", msmtRdngIntervalEndTime);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasuringPoint, MeasuringPoint>(
            MeasuringPoint.class,
            MeasuringPoint.class,
            "com.sap.gateway.srvd_a2x.api_measuringpoint.v0001.CancelMsmtReadingTransfer",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param measuringPointCategory
     *            Constraints: Not nullable, Maximum length: 1
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MeasuringPointCategory</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasuringPoint, MeasuringPoint>
        changeMeasuringPointCategory( @Nonnull final java.lang.String measuringPointCategory )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("MeasuringPointCategory", measuringPointCategory);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasuringPoint, MeasuringPoint>(
            MeasuringPoint.class,
            MeasuringPoint.class,
            "com.sap.gateway.srvd_a2x.api_measuringpoint.v0001.ChangeMeasuringPointCategory",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasuringPoint, MeasuringPoint>
        activateMeasuringPoint()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<MeasuringPoint, MeasuringPoint>(
            MeasuringPoint.class,
            MeasuringPoint.class,
            "com.sap.gateway.srvd_a2x.api_measuringpoint.v0001.ActivateMeasuringPoint",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of MeasuringPoint instances.
     * 
     */
    public final static class MeasuringPointBuilder
    {

        private MeasuringPointLongText to_LongText;

        private MeasuringPoint.MeasuringPointBuilder to_LongText( final MeasuringPointLongText value )
        {
            to_LongText = value;
            return this;
        }

        /**
         * Navigation property <b>_LongText</b> for <b>MeasuringPoint</b> to single <b>MeasuringPointLongText</b>.
         * 
         * @param value
         *            The MeasuringPointLongText to build this MeasuringPoint with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MeasuringPoint.MeasuringPointBuilder longText( final MeasuringPointLongText value )
        {
            return to_LongText(value);
        }

    }

}
