/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint;

import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.MeasuringPointService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Measuring Point Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MeasuringPointLongTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MeasuringPointLongText extends VdmEntity<MeasuringPointLongText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_measuringpoint.v0001.MeasuringPointLongTextType";
    /**
     * Selector for all available fields of MeasuringPointLongText.
     * 
     */
    public final static SimpleProperty<MeasuringPointLongText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPoint</b>
     * </p>
     * 
     * @return Measuring Point
     */
    @Nullable
    @ElementName( "MeasuringPoint" )
    private java.lang.String measuringPoint;
    public final static SimpleProperty.String<MeasuringPointLongText> MEASURING_POINT =
        new SimpleProperty.String<MeasuringPointLongText>(MeasuringPointLongText.class, "MeasuringPoint");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointLongText</b>
     * </p>
     * 
     * @return Long Text
     */
    @Nullable
    @ElementName( "MeasuringPointLongText" )
    private java.lang.String measuringPointLongText;
    public final static SimpleProperty.String<MeasuringPointLongText> MEASURING_POINT_LONG_TEXT =
        new SimpleProperty.String<MeasuringPointLongText>(MeasuringPointLongText.class, "MeasuringPointLongText");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MeasuringPointLongText, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<MeasuringPointLongText, SAP__Message>(
            MeasuringPointLongText.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_MeasuringPoint</b> for <b>MeasuringPointLongText</b> to single <b>MeasuringPoint</b>.
     * 
     */
    @ElementName( "_MeasuringPoint" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MeasuringPoint to_MeasuringPoint;
    /**
     * Use with available request builders to apply the <b>_MeasuringPoint</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MeasuringPointLongText, MeasuringPoint> TO__MEASURING_POINT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<MeasuringPointLongText, MeasuringPoint>(
            MeasuringPointLongText.class,
            "_MeasuringPoint",
            MeasuringPoint.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MeasuringPointLongText> getType()
    {
        return MeasuringPointLongText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPoint</b>
     * </p>
     * 
     * @param measuringPoint
     *            Measuring Point
     */
    public void setMeasuringPoint( @Nullable final java.lang.String measuringPoint )
    {
        rememberChangedField("MeasuringPoint", this.measuringPoint);
        this.measuringPoint = measuringPoint;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPointLongText</b>
     * </p>
     * 
     * @param measuringPointLongText
     *            Long Text
     */
    public void setMeasuringPointLongText( @Nullable final java.lang.String measuringPointLongText )
    {
        rememberChangedField("MeasuringPointLongText", this.measuringPointLongText);
        this.measuringPointLongText = measuringPointLongText;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MeasuringPointLongText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("MeasuringPoint", getMeasuringPoint());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("MeasuringPoint", getMeasuringPoint());
        values.put("MeasuringPointLongText", getMeasuringPointLongText());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MeasuringPoint") ) {
                final Object value = values.remove("MeasuringPoint");
                if( (value == null) || (!value.equals(getMeasuringPoint())) ) {
                    setMeasuringPoint(((java.lang.String) value));
                }
            }
            if( values.containsKey("MeasuringPointLongText") ) {
                final Object value = values.remove("MeasuringPointLongText");
                if( (value == null) || (!value.equals(getMeasuringPointLongText())) ) {
                    setMeasuringPointLongText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_MeasuringPoint") ) {
                final Object value = (values).remove("_MeasuringPoint");
                if( value instanceof Map ) {
                    if( to_MeasuringPoint == null ) {
                        to_MeasuringPoint = new MeasuringPoint();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_MeasuringPoint.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return MeasuringPointService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_MeasuringPoint != null ) {
            (values).put("_MeasuringPoint", to_MeasuringPoint);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>MeasuringPoint</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_MeasuringPoint</b>.
     * <p>
     * If the navigation property for an entity <b>MeasuringPointLongText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_MeasuringPoint</b> is already loaded, the result will
     *         contain the <b>MeasuringPoint</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MeasuringPoint> getMeasuringPointIfPresent()
    {
        return Option.of(to_MeasuringPoint);
    }

    /**
     * Overwrites the associated <b>MeasuringPoint</b> entity for the loaded navigation property <b>_MeasuringPoint</b>.
     * 
     * @param value
     *            New <b>MeasuringPoint</b> entity.
     */
    public void setMeasuringPoint( final MeasuringPoint value )
    {
        to_MeasuringPoint = value;
    }

    /**
     * Helper class to allow for fluent creation of MeasuringPointLongText instances.
     * 
     */
    public final static class MeasuringPointLongTextBuilder
    {

        private MeasuringPoint to_MeasuringPoint;
        private java.lang.String measuringPoint = null;

        private MeasuringPointLongText.MeasuringPointLongTextBuilder to_MeasuringPoint( final MeasuringPoint value )
        {
            to_MeasuringPoint = value;
            return this;
        }

        /**
         * Navigation property <b>_MeasuringPoint</b> for <b>MeasuringPointLongText</b> to single <b>MeasuringPoint</b>.
         * 
         * @param value
         *            The MeasuringPoint to build this MeasuringPointLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MeasuringPointLongText.MeasuringPointLongTextBuilder measuringPoint( final MeasuringPoint value )
        {
            return to_MeasuringPoint(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MeasuringPoint</b>
         * </p>
         * 
         * @param value
         *            The measuringPoint to build this MeasuringPointLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MeasuringPointLongText.MeasuringPointLongTextBuilder measuringPoint( final java.lang.String value )
        {
            measuringPoint = value;
            return this;
        }

    }

}
