/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductExclusionService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Product Substitution Exclusion
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProdSubstnExclsnType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProdSubstnExclsn extends VdmEntity<ProdSubstnExclsn> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_prodsubstnexclsn.v0001.A_ProdSubstnExclsnType";
    /**
     * Selector for all available fields of ProdSubstnExclsn.
     * 
     */
    public final static SimpleProperty<ProdSubstnExclsn> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnUUID</b>
     * </p>
     * 
     * @return Substitution UUID
     */
    @Nullable
    @ElementName( "MDSubstnUUID" )
    private UUID mDSubstnUUID;
    public final static SimpleProperty.Guid<ProdSubstnExclsn> MD_SUBSTN_UUID =
        new SimpleProperty.Guid<ProdSubstnExclsn>(ProdSubstnExclsn.class, "MDSubstnUUID");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @return Product Number
     */
    @Nullable
    @ElementName( "Product" )
    private java.lang.String product;
    public final static SimpleProperty.String<ProdSubstnExclsn> PRODUCT =
        new SimpleProperty.String<ProdSubstnExclsn>(ProdSubstnExclsn.class, "Product");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<ProdSubstnExclsn> PLANT =
        new SimpleProperty.String<ProdSubstnExclsn>(ProdSubstnExclsn.class, "Plant");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnGroup</b>
     * </p>
     * 
     * @return Group Name
     */
    @Nullable
    @ElementName( "MDSubstnGroup" )
    private java.lang.String mDSubstnGroup;
    public final static SimpleProperty.String<ProdSubstnExclsn> MD_SUBSTN_GROUP =
        new SimpleProperty.String<ProdSubstnExclsn>(ProdSubstnExclsn.class, "MDSubstnGroup");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnValidityStartDate</b>
     * </p>
     * 
     * @return Valid From Date
     */
    @Nullable
    @ElementName( "MDSubstnValidityStartDate" )
    private LocalDate mDSubstnValidityStartDate;
    public final static SimpleProperty.Date<ProdSubstnExclsn> MD_SUBSTN_VALIDITY_START_DATE =
        new SimpleProperty.Date<ProdSubstnExclsn>(ProdSubstnExclsn.class, "MDSubstnValidityStartDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnValidityStartTime</b>
     * </p>
     * 
     * @return Valid From Time
     */
    @Nullable
    @ElementName( "MDSubstnValidityStartTime" )
    private LocalTime mDSubstnValidityStartTime;
    public final static SimpleProperty.Time<ProdSubstnExclsn> MD_SUBSTN_VALIDITY_START_TIME =
        new SimpleProperty.Time<ProdSubstnExclsn>(ProdSubstnExclsn.class, "MDSubstnValidityStartTime");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnValidityEndDate</b>
     * </p>
     * 
     * @return Valid To Date
     */
    @Nullable
    @ElementName( "MDSubstnValidityEndDate" )
    private LocalDate mDSubstnValidityEndDate;
    public final static SimpleProperty.Date<ProdSubstnExclsn> MD_SUBSTN_VALIDITY_END_DATE =
        new SimpleProperty.Date<ProdSubstnExclsn>(ProdSubstnExclsn.class, "MDSubstnValidityEndDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnValidityEndTime</b>
     * </p>
     * 
     * @return Valid To Time
     */
    @Nullable
    @ElementName( "MDSubstnValidityEndTime" )
    private LocalTime mDSubstnValidityEndTime;
    public final static SimpleProperty.Time<ProdSubstnExclsn> MD_SUBSTN_VALIDITY_END_TIME =
        new SimpleProperty.Time<ProdSubstnExclsn>(ProdSubstnExclsn.class, "MDSubstnValidityEndTime");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TimeZoneID</b>
     * </p>
     * 
     * @return Time Zone
     */
    @Nullable
    @ElementName( "TimeZoneID" )
    private java.lang.String timeZoneID;
    public final static SimpleProperty.String<ProdSubstnExclsn> TIME_ZONE_ID =
        new SimpleProperty.String<ProdSubstnExclsn>(ProdSubstnExclsn.class, "TimeZoneID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnReason</b>
     * </p>
     * 
     * @return Reason
     */
    @Nullable
    @ElementName( "MDSubstnReason" )
    private java.lang.String mDSubstnReason;
    public final static SimpleProperty.String<ProdSubstnExclsn> MD_SUBSTN_REASON =
        new SimpleProperty.String<ProdSubstnExclsn>(ProdSubstnExclsn.class, "MDSubstnReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnStatus</b>
     * </p>
     * 
     * @return Substitution Status
     */
    @Nullable
    @ElementName( "MDSubstnStatus" )
    private java.lang.String mDSubstnStatus;
    public final static SimpleProperty.String<ProdSubstnExclsn> MD_SUBSTN_STATUS =
        new SimpleProperty.String<ProdSubstnExclsn>(ProdSubstnExclsn.class, "MDSubstnStatus");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnIsRlvtForATPProd</b>
     * </p>
     * 
     * @return aATP Relevant
     */
    @Nullable
    @ElementName( "MDSubstnIsRlvtForATPProd" )
    private java.lang.Boolean mDSubstnIsRlvtForATPProd;
    public final static SimpleProperty.Boolean<ProdSubstnExclsn> MD_SUBSTN_IS_RLVT_FOR_ATP_PROD =
        new SimpleProperty.Boolean<ProdSubstnExclsn>(ProdSubstnExclsn.class, "MDSubstnIsRlvtForATPProd");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Created By User
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<ProdSubstnExclsn> CREATED_BY_USER =
        new SimpleProperty.String<ProdSubstnExclsn>(ProdSubstnExclsn.class, "CreatedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @return Substitution Creation Date
     */
    @Nullable
    @ElementName( "CreationDateTime" )
    private OffsetDateTime creationDateTime;
    public final static SimpleProperty.DateTime<ProdSubstnExclsn> CREATION_DATE_TIME =
        new SimpleProperty.DateTime<ProdSubstnExclsn>(ProdSubstnExclsn.class, "CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Last Changed By User
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<ProdSubstnExclsn> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<ProdSubstnExclsn>(ProdSubstnExclsn.class, "LastChangedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @return Substitution Last Changed Date
     */
    @Nullable
    @ElementName( "LastChangeDateTime" )
    private OffsetDateTime lastChangeDateTime;
    public final static SimpleProperty.DateTime<ProdSubstnExclsn> LAST_CHANGE_DATE_TIME =
        new SimpleProperty.DateTime<ProdSubstnExclsn>(ProdSubstnExclsn.class, "LastChangeDateTime");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<ProdSubstnExclsn, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<ProdSubstnExclsn, SAP__Message>(
            ProdSubstnExclsn.class,
            "SAP__Messages",
            SAP__Message.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProdSubstnExclsn> getType()
    {
        return ProdSubstnExclsn.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnUUID</b>
     * </p>
     * 
     * @param mDSubstnUUID
     *            Substitution UUID
     */
    public void setMDSubstnUUID( @Nullable final UUID mDSubstnUUID )
    {
        rememberChangedField("MDSubstnUUID", this.mDSubstnUUID);
        this.mDSubstnUUID = mDSubstnUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final java.lang.String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnGroup</b>
     * </p>
     * 
     * @param mDSubstnGroup
     *            Group Name
     */
    public void setMDSubstnGroup( @Nullable final java.lang.String mDSubstnGroup )
    {
        rememberChangedField("MDSubstnGroup", this.mDSubstnGroup);
        this.mDSubstnGroup = mDSubstnGroup;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnValidityStartDate</b>
     * </p>
     * 
     * @param mDSubstnValidityStartDate
     *            Valid From Date
     */
    public void setMDSubstnValidityStartDate( @Nullable final LocalDate mDSubstnValidityStartDate )
    {
        rememberChangedField("MDSubstnValidityStartDate", this.mDSubstnValidityStartDate);
        this.mDSubstnValidityStartDate = mDSubstnValidityStartDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnValidityStartTime</b>
     * </p>
     * 
     * @param mDSubstnValidityStartTime
     *            Valid From Time
     */
    public void setMDSubstnValidityStartTime( @Nullable final LocalTime mDSubstnValidityStartTime )
    {
        rememberChangedField("MDSubstnValidityStartTime", this.mDSubstnValidityStartTime);
        this.mDSubstnValidityStartTime = mDSubstnValidityStartTime;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnValidityEndDate</b>
     * </p>
     * 
     * @param mDSubstnValidityEndDate
     *            Valid To Date
     */
    public void setMDSubstnValidityEndDate( @Nullable final LocalDate mDSubstnValidityEndDate )
    {
        rememberChangedField("MDSubstnValidityEndDate", this.mDSubstnValidityEndDate);
        this.mDSubstnValidityEndDate = mDSubstnValidityEndDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnValidityEndTime</b>
     * </p>
     * 
     * @param mDSubstnValidityEndTime
     *            Valid To Time
     */
    public void setMDSubstnValidityEndTime( @Nullable final LocalTime mDSubstnValidityEndTime )
    {
        rememberChangedField("MDSubstnValidityEndTime", this.mDSubstnValidityEndTime);
        this.mDSubstnValidityEndTime = mDSubstnValidityEndTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TimeZoneID</b>
     * </p>
     * 
     * @param timeZoneID
     *            Time Zone
     */
    public void setTimeZoneID( @Nullable final java.lang.String timeZoneID )
    {
        rememberChangedField("TimeZoneID", this.timeZoneID);
        this.timeZoneID = timeZoneID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnReason</b>
     * </p>
     * 
     * @param mDSubstnReason
     *            Reason
     */
    public void setMDSubstnReason( @Nullable final java.lang.String mDSubstnReason )
    {
        rememberChangedField("MDSubstnReason", this.mDSubstnReason);
        this.mDSubstnReason = mDSubstnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnStatus</b>
     * </p>
     * 
     * @param mDSubstnStatus
     *            Substitution Status
     */
    public void setMDSubstnStatus( @Nullable final java.lang.String mDSubstnStatus )
    {
        rememberChangedField("MDSubstnStatus", this.mDSubstnStatus);
        this.mDSubstnStatus = mDSubstnStatus;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MDSubstnIsRlvtForATPProd</b>
     * </p>
     * 
     * @param mDSubstnIsRlvtForATPProd
     *            aATP Relevant
     */
    public void setMDSubstnIsRlvtForATPProd( @Nullable final java.lang.Boolean mDSubstnIsRlvtForATPProd )
    {
        rememberChangedField("MDSubstnIsRlvtForATPProd", this.mDSubstnIsRlvtForATPProd);
        this.mDSubstnIsRlvtForATPProd = mDSubstnIsRlvtForATPProd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @param creationDateTime
     *            Substitution Creation Date
     */
    public void setCreationDateTime( @Nullable final OffsetDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @param lastChangeDateTime
     *            Substitution Last Changed Date
     */
    public void setLastChangeDateTime( @Nullable final OffsetDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_ProdSubstnExclsn";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("MDSubstnUUID", getMDSubstnUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("MDSubstnUUID", getMDSubstnUUID());
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("MDSubstnGroup", getMDSubstnGroup());
        values.put("MDSubstnValidityStartDate", getMDSubstnValidityStartDate());
        values.put("MDSubstnValidityStartTime", getMDSubstnValidityStartTime());
        values.put("MDSubstnValidityEndDate", getMDSubstnValidityEndDate());
        values.put("MDSubstnValidityEndTime", getMDSubstnValidityEndTime());
        values.put("TimeZoneID", getTimeZoneID());
        values.put("MDSubstnReason", getMDSubstnReason());
        values.put("MDSubstnStatus", getMDSubstnStatus());
        values.put("MDSubstnIsRlvtForATPProd", getMDSubstnIsRlvtForATPProd());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MDSubstnUUID") ) {
                final Object value = values.remove("MDSubstnUUID");
                if( (value == null) || (!value.equals(getMDSubstnUUID())) ) {
                    setMDSubstnUUID(((UUID) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("MDSubstnGroup") ) {
                final Object value = values.remove("MDSubstnGroup");
                if( (value == null) || (!value.equals(getMDSubstnGroup())) ) {
                    setMDSubstnGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("MDSubstnValidityStartDate") ) {
                final Object value = values.remove("MDSubstnValidityStartDate");
                if( (value == null) || (!value.equals(getMDSubstnValidityStartDate())) ) {
                    setMDSubstnValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("MDSubstnValidityStartTime") ) {
                final Object value = values.remove("MDSubstnValidityStartTime");
                if( (value == null) || (!value.equals(getMDSubstnValidityStartTime())) ) {
                    setMDSubstnValidityStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MDSubstnValidityEndDate") ) {
                final Object value = values.remove("MDSubstnValidityEndDate");
                if( (value == null) || (!value.equals(getMDSubstnValidityEndDate())) ) {
                    setMDSubstnValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("MDSubstnValidityEndTime") ) {
                final Object value = values.remove("MDSubstnValidityEndTime");
                if( (value == null) || (!value.equals(getMDSubstnValidityEndTime())) ) {
                    setMDSubstnValidityEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("TimeZoneID") ) {
                final Object value = values.remove("TimeZoneID");
                if( (value == null) || (!value.equals(getTimeZoneID())) ) {
                    setTimeZoneID(((java.lang.String) value));
                }
            }
            if( values.containsKey("MDSubstnReason") ) {
                final Object value = values.remove("MDSubstnReason");
                if( (value == null) || (!value.equals(getMDSubstnReason())) ) {
                    setMDSubstnReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("MDSubstnStatus") ) {
                final Object value = values.remove("MDSubstnStatus");
                if( (value == null) || (!value.equals(getMDSubstnStatus())) ) {
                    setMDSubstnStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("MDSubstnIsRlvtForATPProd") ) {
                final Object value = values.remove("MDSubstnIsRlvtForATPProd");
                if( (value == null) || (!value.equals(getMDSubstnIsRlvtForATPProd())) ) {
                    setMDSubstnIsRlvtForATPProd(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((OffsetDateTime) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ProductExclusionService.DEFAULT_SERVICE_PATH;
    }

}
