/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productgroupdata;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductGroupDataService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product Group
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProductGroupType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProductGroup extends VdmEntity<ProductGroup> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_productgroup_2.v0001.ProductGroupType";
    /**
     * Selector for all available fields of ProductGroup.
     * 
     */
    public final static SimpleProperty<ProductGroup> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     * 
     * @return Product Group
     */
    @Nullable
    @ElementName( "ProductGroup" )
    private java.lang.String productGroup;
    public final static SimpleProperty.String<ProductGroup> PRODUCT_GROUP =
        new SimpleProperty.String<ProductGroup>(ProductGroup.class, "ProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroupName</b>
     * </p>
     * 
     * @return Product Group Description
     */
    @Nullable
    @ElementName( "ProductGroupName" )
    private java.lang.String productGroupName;
    public final static SimpleProperty.String<ProductGroup> PRODUCT_GROUP_NAME =
        new SimpleProperty.String<ProductGroup>(ProductGroup.class, "ProductGroupName");
    /**
     * Navigation property <b>_Text</b> for <b>ProductGroup</b> to multiple <b>ProductGroupText</b>.
     * 
     */
    @ElementName( "_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductGroupText> to_Text;
    /**
     * Use with available request builders to apply the <b>_Text</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ProductGroup, ProductGroupText> TO__TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ProductGroup, ProductGroupText>(
            ProductGroup.class,
            "_Text",
            ProductGroupText.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProductGroup> getType()
    {
        return ProductGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     * 
     * @param productGroup
     *            Product Group
     */
    public void setProductGroup( @Nullable final java.lang.String productGroup )
    {
        rememberChangedField("ProductGroup", this.productGroup);
        this.productGroup = productGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroupName</b>
     * </p>
     * 
     * @param productGroupName
     *            Product Group Description
     */
    public void setProductGroupName( @Nullable final java.lang.String productGroupName )
    {
        rememberChangedField("ProductGroupName", this.productGroupName);
        this.productGroupName = productGroupName;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ProductGroup";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ProductGroup", getProductGroup());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ProductGroup", getProductGroup());
        values.put("ProductGroupName", getProductGroupName());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductGroup") ) {
                final Object value = values.remove("ProductGroup");
                if( (value == null) || (!value.equals(getProductGroup())) ) {
                    setProductGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductGroupName") ) {
                final Object value = values.remove("ProductGroupName");
                if( (value == null) || (!value.equals(getProductGroupName())) ) {
                    setProductGroupName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_Text") ) {
                final Object value = (values).remove("_Text");
                if( value instanceof Iterable ) {
                    if( to_Text == null ) {
                        to_Text = Lists.newArrayList();
                    } else {
                        to_Text = Lists.newArrayList(to_Text);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductGroupText entity;
                        if( to_Text.size() > i ) {
                            entity = to_Text.get(i);
                        } else {
                            entity = new ProductGroupText();
                            to_Text.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ProductGroupDataService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_Text != null ) {
            (values).put("_Text", to_Text);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ProductGroupText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ProductGroup</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Text</b> is already loaded, the result will contain the
     *         <b>ProductGroupText</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<ProductGroupText>> getTextIfPresent()
    {
        return Option.of(to_Text);
    }

    /**
     * Overwrites the list of associated <b>ProductGroupText</b> entities for the loaded navigation property
     * <b>_Text</b>.
     * <p>
     * If the navigation property <b>_Text</b> of a queried <b>ProductGroup</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>ProductGroupText</b> entities.
     */
    public void setText( @Nonnull final List<ProductGroupText> value )
    {
        if( to_Text == null ) {
            to_Text = Lists.newArrayList();
        }
        to_Text.clear();
        to_Text.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductGroupText</b> entities. This corresponds to the OData
     * navigation property <b>_Text</b>.
     * <p>
     * If the navigation property <b>_Text</b> of a queried <b>ProductGroup</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>ProductGroupText</b> entities.
     */
    public void addText( ProductGroupText... entity )
    {
        if( to_Text == null ) {
            to_Text = Lists.newArrayList();
        }
        to_Text.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProductGroup instances.
     * 
     */
    public final static class ProductGroupBuilder
    {

        private List<ProductGroupText> to_Text = Lists.newArrayList();

        private ProductGroup.ProductGroupBuilder to_Text( final List<ProductGroupText> value )
        {
            to_Text.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_Text</b> for <b>ProductGroup</b> to multiple <b>ProductGroupText</b>.
         * 
         * @param value
         *            The ProductGroupTexts to build this ProductGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductGroup.ProductGroupBuilder text( ProductGroupText... value )
        {
            return to_Text(Lists.newArrayList(value));
        }

    }

}
