/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productgroupdata;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductGroupDataService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>ProductGroupTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProductGroupText extends VdmEntity<ProductGroupText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_productgroup_2.v0001.ProductGroupTextType";
    /**
     * Selector for all available fields of ProductGroupText.
     * 
     */
    public final static SimpleProperty<ProductGroupText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     * 
     * @return Product Group
     */
    @Nullable
    @ElementName( "ProductGroup" )
    private java.lang.String productGroup;
    public final static SimpleProperty.String<ProductGroupText> PRODUCT_GROUP =
        new SimpleProperty.String<ProductGroupText>(ProductGroupText.class, "ProductGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<ProductGroupText> LANGUAGE =
        new SimpleProperty.String<ProductGroupText>(ProductGroupText.class, "Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroupName</b>
     * </p>
     * 
     * @return Product Group Description
     */
    @Nullable
    @ElementName( "ProductGroupName" )
    private java.lang.String productGroupName;
    public final static SimpleProperty.String<ProductGroupText> PRODUCT_GROUP_NAME =
        new SimpleProperty.String<ProductGroupText>(ProductGroupText.class, "ProductGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroupText</b>
     * </p>
     * 
     * @return Description of the Material Group
     */
    @Nullable
    @ElementName( "ProductGroupText" )
    private java.lang.String productGroupText;
    public final static SimpleProperty.String<ProductGroupText> PRODUCT_GROUP_TEXT =
        new SimpleProperty.String<ProductGroupText>(ProductGroupText.class, "ProductGroupText");
    /**
     * Navigation property <b>_ProductGroup</b> for <b>ProductGroupText</b> to single <b>ProductGroup</b>.
     * 
     */
    @ElementName( "_ProductGroup" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProductGroup to_ProductGroup;
    /**
     * Use with available request builders to apply the <b>_ProductGroup</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ProductGroupText, ProductGroup> TO__PRODUCT_GROUP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ProductGroupText, ProductGroup>(
            ProductGroupText.class,
            "_ProductGroup",
            ProductGroup.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProductGroupText> getType()
    {
        return ProductGroupText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     * 
     * @param productGroup
     *            Product Group
     */
    public void setProductGroup( @Nullable final java.lang.String productGroup )
    {
        rememberChangedField("ProductGroup", this.productGroup);
        this.productGroup = productGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroupName</b>
     * </p>
     * 
     * @param productGroupName
     *            Product Group Description
     */
    public void setProductGroupName( @Nullable final java.lang.String productGroupName )
    {
        rememberChangedField("ProductGroupName", this.productGroupName);
        this.productGroupName = productGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroupText</b>
     * </p>
     * 
     * @param productGroupText
     *            Description of the Material Group
     */
    public void setProductGroupText( @Nullable final java.lang.String productGroupText )
    {
        rememberChangedField("ProductGroupText", this.productGroupText);
        this.productGroupText = productGroupText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ProductGroupText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ProductGroup", getProductGroup());
        entityKey.addKeyProperty("Language", getLanguage());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ProductGroup", getProductGroup());
        values.put("Language", getLanguage());
        values.put("ProductGroupName", getProductGroupName());
        values.put("ProductGroupText", getProductGroupText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductGroup") ) {
                final Object value = values.remove("ProductGroup");
                if( (value == null) || (!value.equals(getProductGroup())) ) {
                    setProductGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductGroupName") ) {
                final Object value = values.remove("ProductGroupName");
                if( (value == null) || (!value.equals(getProductGroupName())) ) {
                    setProductGroupName(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductGroupText") ) {
                final Object value = values.remove("ProductGroupText");
                if( (value == null) || (!value.equals(getProductGroupText())) ) {
                    setProductGroupText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ProductGroup") ) {
                final Object value = (values).remove("_ProductGroup");
                if( value instanceof Map ) {
                    if( to_ProductGroup == null ) {
                        to_ProductGroup = new ProductGroup();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ProductGroup.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ProductGroupDataService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ProductGroup != null ) {
            (values).put("_ProductGroup", to_ProductGroup);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ProductGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_ProductGroup</b>.
     * <p>
     * If the navigation property for an entity <b>ProductGroupText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ProductGroup</b> is already loaded, the result will
     *         contain the <b>ProductGroup</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProductGroup> getProductGroupIfPresent()
    {
        return Option.of(to_ProductGroup);
    }

    /**
     * Overwrites the associated <b>ProductGroup</b> entity for the loaded navigation property <b>_ProductGroup</b>.
     * 
     * @param value
     *            New <b>ProductGroup</b> entity.
     */
    public void setProductGroup( final ProductGroup value )
    {
        to_ProductGroup = value;
    }

    /**
     * Helper class to allow for fluent creation of ProductGroupText instances.
     * 
     */
    public final static class ProductGroupTextBuilder
    {

        private ProductGroup to_ProductGroup;
        private java.lang.String productGroup = null;

        private ProductGroupText.ProductGroupTextBuilder to_ProductGroup( final ProductGroup value )
        {
            to_ProductGroup = value;
            return this;
        }

        /**
         * Navigation property <b>_ProductGroup</b> for <b>ProductGroupText</b> to single <b>ProductGroup</b>.
         * 
         * @param value
         *            The ProductGroup to build this ProductGroupText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductGroupText.ProductGroupTextBuilder productGroup( final ProductGroup value )
        {
            return to_ProductGroup(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 9
         * <p>
         * Original property name from the Odata EDM: <b>ProductGroup</b>
         * </p>
         * 
         * @param value
         *            The productGroup to build this ProductGroupText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductGroupText.ProductGroupTextBuilder productGroup( final java.lang.String value )
        {
            productGroup = value;
            return this;
        }

    }

}
