/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode;

import java.time.LocalDate;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductHierarchyNodeService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>ProdUnivHierNodeByHierIDType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProdUnivHierNodeByHierID extends VdmEntity<ProdUnivHierNodeByHierID> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_prod_hier_nodes_srv.v0001.ProdUnivHierNodeByHierIDType";
    /**
     * Selector for all available fields of ProdUnivHierNodeByHierID.
     * 
     */
    public final static SimpleProperty<ProdUnivHierNodeByHierID> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProdUnivHierarchy</b>
     * </p>
     * 
     * @return Product Hierarchy
     */
    @Nullable
    @ElementName( "ProdUnivHierarchy" )
    private java.lang.String prodUnivHierarchy;
    public final static SimpleProperty.String<ProdUnivHierNodeByHierID> PROD_UNIV_HIERARCHY =
        new SimpleProperty.String<ProdUnivHierNodeByHierID>(ProdUnivHierNodeByHierID.class, "ProdUnivHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     * 
     * @return Hierarchy node
     */
    @Nullable
    @ElementName( "HierarchyNode" )
    private java.lang.String hierarchyNode;
    public final static SimpleProperty.String<ProdUnivHierNodeByHierID> HIERARCHY_NODE =
        new SimpleProperty.String<ProdUnivHierNodeByHierID>(ProdUnivHierNodeByHierID.class, "HierarchyNode");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ProdHierarchyValidityEndDate" )
    private LocalDate prodHierarchyValidityEndDate;
    public final static SimpleProperty.Date<ProdUnivHierNodeByHierID> PROD_HIERARCHY_VALIDITY_END_DATE =
        new SimpleProperty.Date<ProdUnivHierNodeByHierID>(
            ProdUnivHierNodeByHierID.class,
            "ProdHierarchyValidityEndDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ProdHierarchyValidityStartDate" )
    private LocalDate prodHierarchyValidityStartDate;
    public final static SimpleProperty.Date<ProdUnivHierNodeByHierID> PROD_HIERARCHY_VALIDITY_START_DATE =
        new SimpleProperty.Date<ProdUnivHierNodeByHierID>(
            ProdUnivHierNodeByHierID.class,
            "ProdHierarchyValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     * 
     * @return Product Hierarchy Parent Node
     */
    @Nullable
    @ElementName( "ParentNode" )
    private java.lang.String parentNode;
    public final static SimpleProperty.String<ProdUnivHierNodeByHierID> PARENT_NODE =
        new SimpleProperty.String<ProdUnivHierNodeByHierID>(ProdUnivHierNodeByHierID.class, "ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     * 
     * @return Hierarchy node type
     */
    @Nullable
    @ElementName( "NodeType" )
    private java.lang.String nodeType;
    public final static SimpleProperty.String<ProdUnivHierNodeByHierID> NODE_TYPE =
        new SimpleProperty.String<ProdUnivHierNodeByHierID>(ProdUnivHierNodeByHierID.class, "NodeType");
    /**
     * Navigation property <b>_ProdUniversalHierarchy</b> for <b>ProdUnivHierNodeByHierID</b> to single
     * <b>ProdUniversalHierarchy</b>.
     * 
     */
    @ElementName( "_ProdUniversalHierarchy" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProdUniversalHierarchy to_ProdUniversalHierarchy;
    /**
     * Use with available request builders to apply the <b>_ProdUniversalHierarchy</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ProdUnivHierNodeByHierID, ProdUniversalHierarchy> TO__PROD_UNIVERSAL_HIERARCHY =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ProdUnivHierNodeByHierID, ProdUniversalHierarchy>(
            ProdUnivHierNodeByHierID.class,
            "_ProdUniversalHierarchy",
            ProdUniversalHierarchy.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProdUnivHierNodeByHierID> getType()
    {
        return ProdUnivHierNodeByHierID.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProdUnivHierarchy</b>
     * </p>
     * 
     * @param prodUnivHierarchy
     *            Product Hierarchy
     */
    public void setProdUnivHierarchy( @Nullable final java.lang.String prodUnivHierarchy )
    {
        rememberChangedField("ProdUnivHierarchy", this.prodUnivHierarchy);
        this.prodUnivHierarchy = prodUnivHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     * 
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final java.lang.String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityEndDate</b>
     * </p>
     * 
     * @param prodHierarchyValidityEndDate
     *            Validity End Date
     */
    public void setProdHierarchyValidityEndDate( @Nullable final LocalDate prodHierarchyValidityEndDate )
    {
        rememberChangedField("ProdHierarchyValidityEndDate", this.prodHierarchyValidityEndDate);
        this.prodHierarchyValidityEndDate = prodHierarchyValidityEndDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityStartDate</b>
     * </p>
     * 
     * @param prodHierarchyValidityStartDate
     *            Validity Start Date
     */
    public void setProdHierarchyValidityStartDate( @Nullable final LocalDate prodHierarchyValidityStartDate )
    {
        rememberChangedField("ProdHierarchyValidityStartDate", this.prodHierarchyValidityStartDate);
        this.prodHierarchyValidityStartDate = prodHierarchyValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     * 
     * @param parentNode
     *            Product Hierarchy Parent Node
     */
    public void setParentNode( @Nullable final java.lang.String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     * 
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final java.lang.String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ProdUnivHierNodeByHierID";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ProdUnivHierarchy", getProdUnivHierarchy());
        entityKey.addKeyProperty("HierarchyNode", getHierarchyNode());
        entityKey.addKeyProperty("ProdHierarchyValidityEndDate", getProdHierarchyValidityEndDate());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ProdUnivHierarchy", getProdUnivHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("ProdHierarchyValidityEndDate", getProdHierarchyValidityEndDate());
        values.put("ProdHierarchyValidityStartDate", getProdHierarchyValidityStartDate());
        values.put("ParentNode", getParentNode());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProdUnivHierarchy") ) {
                final Object value = values.remove("ProdUnivHierarchy");
                if( (value == null) || (!value.equals(getProdUnivHierarchy())) ) {
                    setProdUnivHierarchy(((java.lang.String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProdHierarchyValidityEndDate") ) {
                final Object value = values.remove("ProdHierarchyValidityEndDate");
                if( (value == null) || (!value.equals(getProdHierarchyValidityEndDate())) ) {
                    setProdHierarchyValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ProdHierarchyValidityStartDate") ) {
                final Object value = values.remove("ProdHierarchyValidityStartDate");
                if( (value == null) || (!value.equals(getProdHierarchyValidityStartDate())) ) {
                    setProdHierarchyValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((java.lang.String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ProdUniversalHierarchy") ) {
                final Object value = (values).remove("_ProdUniversalHierarchy");
                if( value instanceof Map ) {
                    if( to_ProdUniversalHierarchy == null ) {
                        to_ProdUniversalHierarchy = new ProdUniversalHierarchy();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ProdUniversalHierarchy.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ProductHierarchyNodeService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ProdUniversalHierarchy != null ) {
            (values).put("_ProdUniversalHierarchy", to_ProdUniversalHierarchy);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ProdUniversalHierarchy</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_ProdUniversalHierarchy</b>.
     * <p>
     * If the navigation property for an entity <b>ProdUnivHierNodeByHierID</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ProdUniversalHierarchy</b> is already loaded, the result
     *         will contain the <b>ProdUniversalHierarchy</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProdUniversalHierarchy> getProdUniversalHierarchyIfPresent()
    {
        return Option.of(to_ProdUniversalHierarchy);
    }

    /**
     * Overwrites the associated <b>ProdUniversalHierarchy</b> entity for the loaded navigation property
     * <b>_ProdUniversalHierarchy</b>.
     * 
     * @param value
     *            New <b>ProdUniversalHierarchy</b> entity.
     */
    public void setProdUniversalHierarchy( final ProdUniversalHierarchy value )
    {
        to_ProdUniversalHierarchy = value;
    }

    /**
     * Helper class to allow for fluent creation of ProdUnivHierNodeByHierID instances.
     * 
     */
    public final static class ProdUnivHierNodeByHierIDBuilder
    {

        private ProdUniversalHierarchy to_ProdUniversalHierarchy;

        private ProdUnivHierNodeByHierID.ProdUnivHierNodeByHierIDBuilder to_ProdUniversalHierarchy(
            final ProdUniversalHierarchy value )
        {
            to_ProdUniversalHierarchy = value;
            return this;
        }

        /**
         * Navigation property <b>_ProdUniversalHierarchy</b> for <b>ProdUnivHierNodeByHierID</b> to single
         * <b>ProdUniversalHierarchy</b>.
         * 
         * @param value
         *            The ProdUniversalHierarchy to build this ProdUnivHierNodeByHierID with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdUnivHierNodeByHierID.ProdUnivHierNodeByHierIDBuilder prodUniversalHierarchy(
            final ProdUniversalHierarchy value )
        {
            return to_ProdUniversalHierarchy(value);
        }

    }

}
