/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductHierarchyNodeService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>ProdUniversalHierarchyType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProdUniversalHierarchy extends VdmEntity<ProdUniversalHierarchy> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_prod_hier_nodes_srv.v0001.ProdUniversalHierarchyType";
    /**
     * Selector for all available fields of ProdUniversalHierarchy.
     * 
     */
    public final static SimpleProperty<ProdUniversalHierarchy> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProdUnivHierarchy</b>
     * </p>
     * 
     * @return Product Hierarchy
     */
    @Nullable
    @ElementName( "ProdUnivHierarchy" )
    private java.lang.String prodUnivHierarchy;
    public final static SimpleProperty.String<ProdUniversalHierarchy> PROD_UNIV_HIERARCHY =
        new SimpleProperty.String<ProdUniversalHierarchy>(ProdUniversalHierarchy.class, "ProdUnivHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ProdUnivHierarchy_Text</b>
     * </p>
     * 
     * @return Hierarchy description
     */
    @Nullable
    @ElementName( "ProdUnivHierarchy_Text" )
    private java.lang.String prodUnivHierarchy_Text;
    public final static SimpleProperty.String<ProdUniversalHierarchy> PROD_UNIV_HIERARCHY_TEXT =
        new SimpleProperty.String<ProdUniversalHierarchy>(ProdUniversalHierarchy.class, "ProdUnivHierarchy_Text");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ProdHierarchyValidityEndDate" )
    private LocalDate prodHierarchyValidityEndDate;
    public final static SimpleProperty.Date<ProdUniversalHierarchy> PROD_HIERARCHY_VALIDITY_END_DATE =
        new SimpleProperty.Date<ProdUniversalHierarchy>(ProdUniversalHierarchy.class, "ProdHierarchyValidityEndDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ProdHierarchyValidityStartDate" )
    private LocalDate prodHierarchyValidityStartDate;
    public final static SimpleProperty.Date<ProdUniversalHierarchy> PROD_HIERARCHY_VALIDITY_START_DATE =
        new SimpleProperty.Date<ProdUniversalHierarchy>(ProdUniversalHierarchy.class, "ProdHierarchyValidityStartDate");
    /**
     * Navigation property <b>_ProdUnivHierNodeByHierID</b> for <b>ProdUniversalHierarchy</b> to multiple
     * <b>ProdUnivHierNodeByHierID</b>.
     * 
     */
    @ElementName( "_ProdUnivHierNodeByHierID" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProdUnivHierNodeByHierID> to_ProdUnivHierNodeByHierID;
    /**
     * Use with available request builders to apply the <b>_ProdUnivHierNodeByHierID</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ProdUniversalHierarchy, ProdUnivHierNodeByHierID> TO__PROD_UNIV_HIER_NODE_BY_HIER_ID =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ProdUniversalHierarchy, ProdUnivHierNodeByHierID>(
            ProdUniversalHierarchy.class,
            "_ProdUnivHierNodeByHierID",
            ProdUnivHierNodeByHierID.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProdUniversalHierarchy> getType()
    {
        return ProdUniversalHierarchy.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProdUnivHierarchy</b>
     * </p>
     * 
     * @param prodUnivHierarchy
     *            Product Hierarchy
     */
    public void setProdUnivHierarchy( @Nullable final java.lang.String prodUnivHierarchy )
    {
        rememberChangedField("ProdUnivHierarchy", this.prodUnivHierarchy);
        this.prodUnivHierarchy = prodUnivHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ProdUnivHierarchy_Text</b>
     * </p>
     * 
     * @param prodUnivHierarchy_Text
     *            Hierarchy description
     */
    public void setProdUnivHierarchy_Text( @Nullable final java.lang.String prodUnivHierarchy_Text )
    {
        rememberChangedField("ProdUnivHierarchy_Text", this.prodUnivHierarchy_Text);
        this.prodUnivHierarchy_Text = prodUnivHierarchy_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityEndDate</b>
     * </p>
     * 
     * @param prodHierarchyValidityEndDate
     *            Validity End Date
     */
    public void setProdHierarchyValidityEndDate( @Nullable final LocalDate prodHierarchyValidityEndDate )
    {
        rememberChangedField("ProdHierarchyValidityEndDate", this.prodHierarchyValidityEndDate);
        this.prodHierarchyValidityEndDate = prodHierarchyValidityEndDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityStartDate</b>
     * </p>
     * 
     * @param prodHierarchyValidityStartDate
     *            Validity Start Date
     */
    public void setProdHierarchyValidityStartDate( @Nullable final LocalDate prodHierarchyValidityStartDate )
    {
        rememberChangedField("ProdHierarchyValidityStartDate", this.prodHierarchyValidityStartDate);
        this.prodHierarchyValidityStartDate = prodHierarchyValidityStartDate;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ProdUniversalHierarchy";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ProdUnivHierarchy", getProdUnivHierarchy());
        entityKey.addKeyProperty("ProdHierarchyValidityEndDate", getProdHierarchyValidityEndDate());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ProdUnivHierarchy", getProdUnivHierarchy());
        values.put("ProdUnivHierarchy_Text", getProdUnivHierarchy_Text());
        values.put("ProdHierarchyValidityEndDate", getProdHierarchyValidityEndDate());
        values.put("ProdHierarchyValidityStartDate", getProdHierarchyValidityStartDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProdUnivHierarchy") ) {
                final Object value = values.remove("ProdUnivHierarchy");
                if( (value == null) || (!value.equals(getProdUnivHierarchy())) ) {
                    setProdUnivHierarchy(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProdUnivHierarchy_Text") ) {
                final Object value = values.remove("ProdUnivHierarchy_Text");
                if( (value == null) || (!value.equals(getProdUnivHierarchy_Text())) ) {
                    setProdUnivHierarchy_Text(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProdHierarchyValidityEndDate") ) {
                final Object value = values.remove("ProdHierarchyValidityEndDate");
                if( (value == null) || (!value.equals(getProdHierarchyValidityEndDate())) ) {
                    setProdHierarchyValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ProdHierarchyValidityStartDate") ) {
                final Object value = values.remove("ProdHierarchyValidityStartDate");
                if( (value == null) || (!value.equals(getProdHierarchyValidityStartDate())) ) {
                    setProdHierarchyValidityStartDate(((LocalDate) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ProdUnivHierNodeByHierID") ) {
                final Object value = (values).remove("_ProdUnivHierNodeByHierID");
                if( value instanceof Iterable ) {
                    if( to_ProdUnivHierNodeByHierID == null ) {
                        to_ProdUnivHierNodeByHierID = Lists.newArrayList();
                    } else {
                        to_ProdUnivHierNodeByHierID = Lists.newArrayList(to_ProdUnivHierNodeByHierID);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProdUnivHierNodeByHierID entity;
                        if( to_ProdUnivHierNodeByHierID.size() > i ) {
                            entity = to_ProdUnivHierNodeByHierID.get(i);
                        } else {
                            entity = new ProdUnivHierNodeByHierID();
                            to_ProdUnivHierNodeByHierID.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ProductHierarchyNodeService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ProdUnivHierNodeByHierID != null ) {
            (values).put("_ProdUnivHierNodeByHierID", to_ProdUnivHierNodeByHierID);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ProdUnivHierNodeByHierID</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_ProdUnivHierNodeByHierID</b>.
     * <p>
     * If the navigation property for an entity <b>ProdUniversalHierarchy</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ProdUnivHierNodeByHierID</b> is already loaded, the result
     *         will contain the <b>ProdUnivHierNodeByHierID</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProdUnivHierNodeByHierID>> getProdUnivHierNodeByHierIDIfPresent()
    {
        return Option.of(to_ProdUnivHierNodeByHierID);
    }

    /**
     * Overwrites the list of associated <b>ProdUnivHierNodeByHierID</b> entities for the loaded navigation property
     * <b>_ProdUnivHierNodeByHierID</b>.
     * <p>
     * If the navigation property <b>_ProdUnivHierNodeByHierID</b> of a queried <b>ProdUniversalHierarchy</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>ProdUnivHierNodeByHierID</b> entities.
     */
    public void setProdUnivHierNodeByHierID( @Nonnull final List<ProdUnivHierNodeByHierID> value )
    {
        if( to_ProdUnivHierNodeByHierID == null ) {
            to_ProdUnivHierNodeByHierID = Lists.newArrayList();
        }
        to_ProdUnivHierNodeByHierID.clear();
        to_ProdUnivHierNodeByHierID.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProdUnivHierNodeByHierID</b> entities. This corresponds to the OData
     * navigation property <b>_ProdUnivHierNodeByHierID</b>.
     * <p>
     * If the navigation property <b>_ProdUnivHierNodeByHierID</b> of a queried <b>ProdUniversalHierarchy</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>ProdUnivHierNodeByHierID</b> entities.
     */
    public void addProdUnivHierNodeByHierID( ProdUnivHierNodeByHierID... entity )
    {
        if( to_ProdUnivHierNodeByHierID == null ) {
            to_ProdUnivHierNodeByHierID = Lists.newArrayList();
        }
        to_ProdUnivHierNodeByHierID.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProdUniversalHierarchy instances.
     * 
     */
    public final static class ProdUniversalHierarchyBuilder
    {

        private List<ProdUnivHierNodeByHierID> to_ProdUnivHierNodeByHierID = Lists.newArrayList();

        private ProdUniversalHierarchy.ProdUniversalHierarchyBuilder to_ProdUnivHierNodeByHierID(
            final List<ProdUnivHierNodeByHierID> value )
        {
            to_ProdUnivHierNodeByHierID.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_ProdUnivHierNodeByHierID</b> for <b>ProdUniversalHierarchy</b> to multiple
         * <b>ProdUnivHierNodeByHierID</b>.
         * 
         * @param value
         *            The ProdUnivHierNodeByHierIDs to build this ProdUniversalHierarchy with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdUniversalHierarchy.ProdUniversalHierarchyBuilder prodUnivHierNodeByHierID(
            ProdUnivHierNodeByHierID... value )
        {
            return to_ProdUnivHierNodeByHierID(Lists.newArrayList(value));
        }

    }

}
