/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productstoproducthierarchiesassignment;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductsToProductHierarchiesAssignmentService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>ProdUnivHierNormalNodeType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProdUnivHierNormalNode extends VdmEntity<ProdUnivHierNormalNode> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_prod_hier_prods_srv.v0001.ProdUnivHierNormalNodeType";
    /**
     * Selector for all available fields of ProdUnivHierNormalNode.
     * 
     */
    public final static SimpleProperty<ProdUnivHierNormalNode> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProdUnivHierarchy</b>
     * </p>
     * 
     * @return Product Hierarchy
     */
    @Nullable
    @ElementName( "ProdUnivHierarchy" )
    private java.lang.String prodUnivHierarchy;
    public final static SimpleProperty.String<ProdUnivHierNormalNode> PROD_UNIV_HIERARCHY =
        new SimpleProperty.String<ProdUnivHierNormalNode>(ProdUnivHierNormalNode.class, "ProdUnivHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     * 
     * @return Hierarchy node
     */
    @Nullable
    @ElementName( "HierarchyNode" )
    private java.lang.String hierarchyNode;
    public final static SimpleProperty.String<ProdUnivHierNormalNode> HIERARCHY_NODE =
        new SimpleProperty.String<ProdUnivHierNormalNode>(ProdUnivHierNormalNode.class, "HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     * 
     * @return Product Hierarchy Node Value Text
     */
    @Nullable
    @ElementName( "HierarchyNode_Text" )
    private java.lang.String hierarchyNode_Text;
    public final static SimpleProperty.String<ProdUnivHierNormalNode> HIERARCHY_NODE_TEXT =
        new SimpleProperty.String<ProdUnivHierNormalNode>(ProdUnivHierNormalNode.class, "HierarchyNode_Text");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ProdHierarchyValidityEndDate" )
    private LocalDate prodHierarchyValidityEndDate;
    public final static SimpleProperty.Date<ProdUnivHierNormalNode> PROD_HIERARCHY_VALIDITY_END_DATE =
        new SimpleProperty.Date<ProdUnivHierNormalNode>(ProdUnivHierNormalNode.class, "ProdHierarchyValidityEndDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ProdHierarchyValidityStartDate" )
    private LocalDate prodHierarchyValidityStartDate;
    public final static SimpleProperty.Date<ProdUnivHierNormalNode> PROD_HIERARCHY_VALIDITY_START_DATE =
        new SimpleProperty.Date<ProdUnivHierNormalNode>(ProdUnivHierNormalNode.class, "ProdHierarchyValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     * 
     * @return Product Hierarchy Parent Node
     */
    @Nullable
    @ElementName( "ParentNode" )
    private java.lang.String parentNode;
    public final static SimpleProperty.String<ProdUnivHierNormalNode> PARENT_NODE =
        new SimpleProperty.String<ProdUnivHierNormalNode>(ProdUnivHierNormalNode.class, "ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     * 
     * @return Hierarchy node type
     */
    @Nullable
    @ElementName( "NodeType" )
    private java.lang.String nodeType;
    public final static SimpleProperty.String<ProdUnivHierNormalNode> NODE_TYPE =
        new SimpleProperty.String<ProdUnivHierNormalNode>(ProdUnivHierNormalNode.class, "NodeType");
    /**
     * Navigation property <b>_ProdUnivHierProdByHierNode</b> for <b>ProdUnivHierNormalNode</b> to multiple
     * <b>ProdUnivHierProdByHierNode</b>.
     * 
     */
    @ElementName( "_ProdUnivHierProdByHierNode" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProdUnivHierProdByHierNode> to_ProdUnivHierProdByHierNode;
    /**
     * Use with available request builders to apply the <b>_ProdUnivHierProdByHierNode</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ProdUnivHierNormalNode, ProdUnivHierProdByHierNode> TO__PROD_UNIV_HIER_PROD_BY_HIER_NODE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ProdUnivHierNormalNode, ProdUnivHierProdByHierNode>(
            ProdUnivHierNormalNode.class,
            "_ProdUnivHierProdByHierNode",
            ProdUnivHierProdByHierNode.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProdUnivHierNormalNode> getType()
    {
        return ProdUnivHierNormalNode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProdUnivHierarchy</b>
     * </p>
     * 
     * @param prodUnivHierarchy
     *            Product Hierarchy
     */
    public void setProdUnivHierarchy( @Nullable final java.lang.String prodUnivHierarchy )
    {
        rememberChangedField("ProdUnivHierarchy", this.prodUnivHierarchy);
        this.prodUnivHierarchy = prodUnivHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     * 
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final java.lang.String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     * 
     * @param hierarchyNode_Text
     *            Product Hierarchy Node Value Text
     */
    public void setHierarchyNode_Text( @Nullable final java.lang.String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityEndDate</b>
     * </p>
     * 
     * @param prodHierarchyValidityEndDate
     *            Validity End Date
     */
    public void setProdHierarchyValidityEndDate( @Nullable final LocalDate prodHierarchyValidityEndDate )
    {
        rememberChangedField("ProdHierarchyValidityEndDate", this.prodHierarchyValidityEndDate);
        this.prodHierarchyValidityEndDate = prodHierarchyValidityEndDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityStartDate</b>
     * </p>
     * 
     * @param prodHierarchyValidityStartDate
     *            Validity Start Date
     */
    public void setProdHierarchyValidityStartDate( @Nullable final LocalDate prodHierarchyValidityStartDate )
    {
        rememberChangedField("ProdHierarchyValidityStartDate", this.prodHierarchyValidityStartDate);
        this.prodHierarchyValidityStartDate = prodHierarchyValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     * 
     * @param parentNode
     *            Product Hierarchy Parent Node
     */
    public void setParentNode( @Nullable final java.lang.String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     * 
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final java.lang.String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ProdUnivHierNormalNode";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ProdUnivHierarchy", getProdUnivHierarchy());
        entityKey.addKeyProperty("HierarchyNode", getHierarchyNode());
        entityKey.addKeyProperty("ProdHierarchyValidityEndDate", getProdHierarchyValidityEndDate());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ProdUnivHierarchy", getProdUnivHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ProdHierarchyValidityEndDate", getProdHierarchyValidityEndDate());
        values.put("ProdHierarchyValidityStartDate", getProdHierarchyValidityStartDate());
        values.put("ParentNode", getParentNode());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProdUnivHierarchy") ) {
                final Object value = values.remove("ProdUnivHierarchy");
                if( (value == null) || (!value.equals(getProdUnivHierarchy())) ) {
                    setProdUnivHierarchy(((java.lang.String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((java.lang.String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProdHierarchyValidityEndDate") ) {
                final Object value = values.remove("ProdHierarchyValidityEndDate");
                if( (value == null) || (!value.equals(getProdHierarchyValidityEndDate())) ) {
                    setProdHierarchyValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ProdHierarchyValidityStartDate") ) {
                final Object value = values.remove("ProdHierarchyValidityStartDate");
                if( (value == null) || (!value.equals(getProdHierarchyValidityStartDate())) ) {
                    setProdHierarchyValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((java.lang.String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ProdUnivHierProdByHierNode") ) {
                final Object value = (values).remove("_ProdUnivHierProdByHierNode");
                if( value instanceof Iterable ) {
                    if( to_ProdUnivHierProdByHierNode == null ) {
                        to_ProdUnivHierProdByHierNode = Lists.newArrayList();
                    } else {
                        to_ProdUnivHierProdByHierNode = Lists.newArrayList(to_ProdUnivHierProdByHierNode);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProdUnivHierProdByHierNode entity;
                        if( to_ProdUnivHierProdByHierNode.size() > i ) {
                            entity = to_ProdUnivHierProdByHierNode.get(i);
                        } else {
                            entity = new ProdUnivHierProdByHierNode();
                            to_ProdUnivHierProdByHierNode.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ProductsToProductHierarchiesAssignmentService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ProdUnivHierProdByHierNode != null ) {
            (values).put("_ProdUnivHierProdByHierNode", to_ProdUnivHierProdByHierNode);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ProdUnivHierProdByHierNode</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_ProdUnivHierProdByHierNode</b>.
     * <p>
     * If the navigation property for an entity <b>ProdUnivHierNormalNode</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ProdUnivHierProdByHierNode</b> is already loaded, the
     *         result will contain the <b>ProdUnivHierProdByHierNode</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProdUnivHierProdByHierNode>> getProdUnivHierProdByHierNodeIfPresent()
    {
        return Option.of(to_ProdUnivHierProdByHierNode);
    }

    /**
     * Overwrites the list of associated <b>ProdUnivHierProdByHierNode</b> entities for the loaded navigation property
     * <b>_ProdUnivHierProdByHierNode</b>.
     * <p>
     * If the navigation property <b>_ProdUnivHierProdByHierNode</b> of a queried <b>ProdUnivHierNormalNode</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>ProdUnivHierProdByHierNode</b> entities.
     */
    public void setProdUnivHierProdByHierNode( @Nonnull final List<ProdUnivHierProdByHierNode> value )
    {
        if( to_ProdUnivHierProdByHierNode == null ) {
            to_ProdUnivHierProdByHierNode = Lists.newArrayList();
        }
        to_ProdUnivHierProdByHierNode.clear();
        to_ProdUnivHierProdByHierNode.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProdUnivHierProdByHierNode</b> entities. This corresponds to the OData
     * navigation property <b>_ProdUnivHierProdByHierNode</b>.
     * <p>
     * If the navigation property <b>_ProdUnivHierProdByHierNode</b> of a queried <b>ProdUnivHierNormalNode</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>ProdUnivHierProdByHierNode</b> entities.
     */
    public void addProdUnivHierProdByHierNode( ProdUnivHierProdByHierNode... entity )
    {
        if( to_ProdUnivHierProdByHierNode == null ) {
            to_ProdUnivHierProdByHierNode = Lists.newArrayList();
        }
        to_ProdUnivHierProdByHierNode.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProdUnivHierNormalNode instances.
     * 
     */
    public final static class ProdUnivHierNormalNodeBuilder
    {

        private List<ProdUnivHierProdByHierNode> to_ProdUnivHierProdByHierNode = Lists.newArrayList();

        private ProdUnivHierNormalNode.ProdUnivHierNormalNodeBuilder to_ProdUnivHierProdByHierNode(
            final List<ProdUnivHierProdByHierNode> value )
        {
            to_ProdUnivHierProdByHierNode.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_ProdUnivHierProdByHierNode</b> for <b>ProdUnivHierNormalNode</b> to multiple
         * <b>ProdUnivHierProdByHierNode</b>.
         * 
         * @param value
         *            The ProdUnivHierProdByHierNodes to build this ProdUnivHierNormalNode with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdUnivHierNormalNode.ProdUnivHierNormalNodeBuilder prodUnivHierProdByHierNode(
            ProdUnivHierProdByHierNode... value )
        {
            return to_ProdUnivHierProdByHierNode(Lists.newArrayList(value));
        }

    }

}
