/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productstoproducthierarchiesassignment;

import java.time.LocalDate;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductsToProductHierarchiesAssignmentService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>ProdUnivHierProdByHierNodeType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProdUnivHierProdByHierNode extends VdmEntity<ProdUnivHierProdByHierNode> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_prod_hier_prods_srv.v0001.ProdUnivHierProdByHierNodeType";
    /**
     * Selector for all available fields of ProdUnivHierProdByHierNode.
     * 
     */
    public final static SimpleProperty<ProdUnivHierProdByHierNode> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProdUnivHierarchy</b>
     * </p>
     * 
     * @return Product Hierarchy
     */
    @Nullable
    @ElementName( "ProdUnivHierarchy" )
    private java.lang.String prodUnivHierarchy;
    public final static SimpleProperty.String<ProdUnivHierProdByHierNode> PROD_UNIV_HIERARCHY =
        new SimpleProperty.String<ProdUnivHierProdByHierNode>(ProdUnivHierProdByHierNode.class, "ProdUnivHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     * 
     * @return Hierarchy node
     */
    @Nullable
    @ElementName( "HierarchyNode" )
    private java.lang.String hierarchyNode;
    public final static SimpleProperty.String<ProdUnivHierProdByHierNode> HIERARCHY_NODE =
        new SimpleProperty.String<ProdUnivHierProdByHierNode>(ProdUnivHierProdByHierNode.class, "HierarchyNode");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ProdHierarchyValidityEndDate" )
    private LocalDate prodHierarchyValidityEndDate;
    public final static SimpleProperty.Date<ProdUnivHierProdByHierNode> PROD_HIERARCHY_VALIDITY_END_DATE =
        new SimpleProperty.Date<ProdUnivHierProdByHierNode>(
            ProdUnivHierProdByHierNode.class,
            "ProdHierarchyValidityEndDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @return Product Number
     */
    @Nullable
    @ElementName( "Product" )
    private java.lang.String product;
    public final static SimpleProperty.String<ProdUnivHierProdByHierNode> PRODUCT =
        new SimpleProperty.String<ProdUnivHierProdByHierNode>(ProdUnivHierProdByHierNode.class, "Product");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product_Text</b>
     * </p>
     * 
     * @return Product Description
     */
    @Nullable
    @ElementName( "Product_Text" )
    private java.lang.String product_Text;
    public final static SimpleProperty.String<ProdUnivHierProdByHierNode> PRODUCT_TEXT =
        new SimpleProperty.String<ProdUnivHierProdByHierNode>(ProdUnivHierProdByHierNode.class, "Product_Text");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ProdHierarchyValidityStartDate" )
    private LocalDate prodHierarchyValidityStartDate;
    public final static SimpleProperty.Date<ProdUnivHierProdByHierNode> PROD_HIERARCHY_VALIDITY_START_DATE =
        new SimpleProperty.Date<ProdUnivHierProdByHierNode>(
            ProdUnivHierProdByHierNode.class,
            "ProdHierarchyValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     * 
     * @return Product Hierarchy Parent Node
     */
    @Nullable
    @ElementName( "ParentNode" )
    private java.lang.String parentNode;
    public final static SimpleProperty.String<ProdUnivHierProdByHierNode> PARENT_NODE =
        new SimpleProperty.String<ProdUnivHierProdByHierNode>(ProdUnivHierProdByHierNode.class, "ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     * 
     * @return Hierarchy node type
     */
    @Nullable
    @ElementName( "NodeType" )
    private java.lang.String nodeType;
    public final static SimpleProperty.String<ProdUnivHierProdByHierNode> NODE_TYPE =
        new SimpleProperty.String<ProdUnivHierProdByHierNode>(ProdUnivHierProdByHierNode.class, "NodeType");
    /**
     * Navigation property <b>_ProdUnivHierNormalNode</b> for <b>ProdUnivHierProdByHierNode</b> to single
     * <b>ProdUnivHierNormalNode</b>.
     * 
     */
    @ElementName( "_ProdUnivHierNormalNode" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProdUnivHierNormalNode to_ProdUnivHierNormalNode;
    /**
     * Use with available request builders to apply the <b>_ProdUnivHierNormalNode</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ProdUnivHierProdByHierNode, ProdUnivHierNormalNode> TO__PROD_UNIV_HIER_NORMAL_NODE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ProdUnivHierProdByHierNode, ProdUnivHierNormalNode>(
            ProdUnivHierProdByHierNode.class,
            "_ProdUnivHierNormalNode",
            ProdUnivHierNormalNode.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProdUnivHierProdByHierNode> getType()
    {
        return ProdUnivHierProdByHierNode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProdUnivHierarchy</b>
     * </p>
     * 
     * @param prodUnivHierarchy
     *            Product Hierarchy
     */
    public void setProdUnivHierarchy( @Nullable final java.lang.String prodUnivHierarchy )
    {
        rememberChangedField("ProdUnivHierarchy", this.prodUnivHierarchy);
        this.prodUnivHierarchy = prodUnivHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     * 
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final java.lang.String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityEndDate</b>
     * </p>
     * 
     * @param prodHierarchyValidityEndDate
     *            Validity End Date
     */
    public void setProdHierarchyValidityEndDate( @Nullable final LocalDate prodHierarchyValidityEndDate )
    {
        rememberChangedField("ProdHierarchyValidityEndDate", this.prodHierarchyValidityEndDate);
        this.prodHierarchyValidityEndDate = prodHierarchyValidityEndDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final java.lang.String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product_Text</b>
     * </p>
     * 
     * @param product_Text
     *            Product Description
     */
    public void setProduct_Text( @Nullable final java.lang.String product_Text )
    {
        rememberChangedField("Product_Text", this.product_Text);
        this.product_Text = product_Text;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProdHierarchyValidityStartDate</b>
     * </p>
     * 
     * @param prodHierarchyValidityStartDate
     *            Validity Start Date
     */
    public void setProdHierarchyValidityStartDate( @Nullable final LocalDate prodHierarchyValidityStartDate )
    {
        rememberChangedField("ProdHierarchyValidityStartDate", this.prodHierarchyValidityStartDate);
        this.prodHierarchyValidityStartDate = prodHierarchyValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     * 
     * @param parentNode
     *            Product Hierarchy Parent Node
     */
    public void setParentNode( @Nullable final java.lang.String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     * 
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final java.lang.String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ProdUnivHierProdByHierNode";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ProdUnivHierarchy", getProdUnivHierarchy());
        entityKey.addKeyProperty("HierarchyNode", getHierarchyNode());
        entityKey.addKeyProperty("ProdHierarchyValidityEndDate", getProdHierarchyValidityEndDate());
        entityKey.addKeyProperty("Product", getProduct());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ProdUnivHierarchy", getProdUnivHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("ProdHierarchyValidityEndDate", getProdHierarchyValidityEndDate());
        values.put("Product", getProduct());
        values.put("Product_Text", getProduct_Text());
        values.put("ProdHierarchyValidityStartDate", getProdHierarchyValidityStartDate());
        values.put("ParentNode", getParentNode());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProdUnivHierarchy") ) {
                final Object value = values.remove("ProdUnivHierarchy");
                if( (value == null) || (!value.equals(getProdUnivHierarchy())) ) {
                    setProdUnivHierarchy(((java.lang.String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProdHierarchyValidityEndDate") ) {
                final Object value = values.remove("ProdHierarchyValidityEndDate");
                if( (value == null) || (!value.equals(getProdHierarchyValidityEndDate())) ) {
                    setProdHierarchyValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((java.lang.String) value));
                }
            }
            if( values.containsKey("Product_Text") ) {
                final Object value = values.remove("Product_Text");
                if( (value == null) || (!value.equals(getProduct_Text())) ) {
                    setProduct_Text(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProdHierarchyValidityStartDate") ) {
                final Object value = values.remove("ProdHierarchyValidityStartDate");
                if( (value == null) || (!value.equals(getProdHierarchyValidityStartDate())) ) {
                    setProdHierarchyValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((java.lang.String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ProdUnivHierNormalNode") ) {
                final Object value = (values).remove("_ProdUnivHierNormalNode");
                if( value instanceof Map ) {
                    if( to_ProdUnivHierNormalNode == null ) {
                        to_ProdUnivHierNormalNode = new ProdUnivHierNormalNode();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ProdUnivHierNormalNode.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ProductsToProductHierarchiesAssignmentService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ProdUnivHierNormalNode != null ) {
            (values).put("_ProdUnivHierNormalNode", to_ProdUnivHierNormalNode);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ProdUnivHierNormalNode</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_ProdUnivHierNormalNode</b>.
     * <p>
     * If the navigation property for an entity <b>ProdUnivHierProdByHierNode</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ProdUnivHierNormalNode</b> is already loaded, the result
     *         will contain the <b>ProdUnivHierNormalNode</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProdUnivHierNormalNode> getProdUnivHierNormalNodeIfPresent()
    {
        return Option.of(to_ProdUnivHierNormalNode);
    }

    /**
     * Overwrites the associated <b>ProdUnivHierNormalNode</b> entity for the loaded navigation property
     * <b>_ProdUnivHierNormalNode</b>.
     * 
     * @param value
     *            New <b>ProdUnivHierNormalNode</b> entity.
     */
    public void setProdUnivHierNormalNode( final ProdUnivHierNormalNode value )
    {
        to_ProdUnivHierNormalNode = value;
    }

    /**
     * Helper class to allow for fluent creation of ProdUnivHierProdByHierNode instances.
     * 
     */
    public final static class ProdUnivHierProdByHierNodeBuilder
    {

        private ProdUnivHierNormalNode to_ProdUnivHierNormalNode;

        private ProdUnivHierProdByHierNode.ProdUnivHierProdByHierNodeBuilder to_ProdUnivHierNormalNode(
            final ProdUnivHierNormalNode value )
        {
            to_ProdUnivHierNormalNode = value;
            return this;
        }

        /**
         * Navigation property <b>_ProdUnivHierNormalNode</b> for <b>ProdUnivHierProdByHierNode</b> to single
         * <b>ProdUnivHierNormalNode</b>.
         * 
         * @param value
         *            The ProdUnivHierNormalNode to build this ProdUnivHierProdByHierNode with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProdUnivHierProdByHierNode.ProdUnivHierProdByHierNodeBuilder prodUnivHierNormalNode(
            final ProdUnivHierNormalNode value )
        {
            return to_ProdUnivHierNormalNode(value);
        }

    }

}
