/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producttype;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductTypeService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProductTypeType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProductType extends VdmEntity<ProductType> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_producttype.v0001.ProductTypeType";
    /**
     * Selector for all available fields of ProductType.
     * 
     */
    public final static SimpleProperty<ProductType> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     * 
     * @return Product Type
     */
    @Nullable
    @ElementName( "ProductType" )
    private java.lang.String productType;
    public final static SimpleProperty.String<ProductType> PRODUCT_TYPE =
        new SimpleProperty.String<ProductType>(ProductType.class, "ProductType");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ProductTypeName</b>
     * </p>
     * 
     * @return Description of product type
     */
    @Nullable
    @ElementName( "ProductTypeName" )
    private java.lang.String productTypeName;
    public final static SimpleProperty.String<ProductType> PRODUCT_TYPE_NAME =
        new SimpleProperty.String<ProductType>(ProductType.class, "ProductTypeName");
    /**
     * Navigation property <b>_Text</b> for <b>ProductType</b> to multiple <b>ProductTypeText</b>.
     * 
     */
    @ElementName( "_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductTypeText> to_Text;
    /**
     * Use with available request builders to apply the <b>_Text</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ProductType, ProductTypeText> TO__TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ProductType, ProductTypeText>(
            ProductType.class,
            "_Text",
            ProductTypeText.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProductType> getType()
    {
        return ProductType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     * 
     * @param productType
     *            Product Type
     */
    public void setProductType( @Nullable final java.lang.String productType )
    {
        rememberChangedField("ProductType", this.productType);
        this.productType = productType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ProductTypeName</b>
     * </p>
     * 
     * @param productTypeName
     *            Description of product type
     */
    public void setProductTypeName( @Nullable final java.lang.String productTypeName )
    {
        rememberChangedField("ProductTypeName", this.productTypeName);
        this.productTypeName = productTypeName;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ProductType";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ProductType", getProductType());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ProductType", getProductType());
        values.put("ProductTypeName", getProductTypeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductType") ) {
                final Object value = values.remove("ProductType");
                if( (value == null) || (!value.equals(getProductType())) ) {
                    setProductType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductTypeName") ) {
                final Object value = values.remove("ProductTypeName");
                if( (value == null) || (!value.equals(getProductTypeName())) ) {
                    setProductTypeName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_Text") ) {
                final Object value = (values).remove("_Text");
                if( value instanceof Iterable ) {
                    if( to_Text == null ) {
                        to_Text = Lists.newArrayList();
                    } else {
                        to_Text = Lists.newArrayList(to_Text);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductTypeText entity;
                        if( to_Text.size() > i ) {
                            entity = to_Text.get(i);
                        } else {
                            entity = new ProductTypeText();
                            to_Text.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ProductTypeService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_Text != null ) {
            (values).put("_Text", to_Text);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ProductTypeText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ProductType</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Text</b> is already loaded, the result will contain the
     *         <b>ProductTypeText</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<ProductTypeText>> getTextIfPresent()
    {
        return Option.of(to_Text);
    }

    /**
     * Overwrites the list of associated <b>ProductTypeText</b> entities for the loaded navigation property
     * <b>_Text</b>.
     * <p>
     * If the navigation property <b>_Text</b> of a queried <b>ProductType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>ProductTypeText</b> entities.
     */
    public void setText( @Nonnull final List<ProductTypeText> value )
    {
        if( to_Text == null ) {
            to_Text = Lists.newArrayList();
        }
        to_Text.clear();
        to_Text.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductTypeText</b> entities. This corresponds to the OData navigation
     * property <b>_Text</b>.
     * <p>
     * If the navigation property <b>_Text</b> of a queried <b>ProductType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>ProductTypeText</b> entities.
     */
    public void addText( ProductTypeText... entity )
    {
        if( to_Text == null ) {
            to_Text = Lists.newArrayList();
        }
        to_Text.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProductType instances.
     * 
     */
    public final static class ProductTypeBuilder
    {

        private List<ProductTypeText> to_Text = Lists.newArrayList();

        private ProductType.ProductTypeBuilder to_Text( final List<ProductTypeText> value )
        {
            to_Text.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_Text</b> for <b>ProductType</b> to multiple <b>ProductTypeText</b>.
         * 
         * @param value
         *            The ProductTypeTexts to build this ProductType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductType.ProductTypeBuilder text( ProductTypeText... value )
        {
            return to_Text(Lists.newArrayList(value));
        }

    }

}
