/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producttype;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ProductTypeService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>ProductTypeTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProductTypeText extends VdmEntity<ProductTypeText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_producttype.v0001.ProductTypeTextType";
    /**
     * Selector for all available fields of ProductTypeText.
     * 
     */
    public final static SimpleProperty<ProductTypeText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     * 
     * @return Product Type
     */
    @Nullable
    @ElementName( "ProductType" )
    private java.lang.String productType;
    public final static SimpleProperty.String<ProductTypeText> PRODUCT_TYPE =
        new SimpleProperty.String<ProductTypeText>(ProductTypeText.class, "ProductType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<ProductTypeText> LANGUAGE =
        new SimpleProperty.String<ProductTypeText>(ProductTypeText.class, "Language");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ProductTypeName</b>
     * </p>
     * 
     * @return Description of product type
     */
    @Nullable
    @ElementName( "ProductTypeName" )
    private java.lang.String productTypeName;
    public final static SimpleProperty.String<ProductTypeText> PRODUCT_TYPE_NAME =
        new SimpleProperty.String<ProductTypeText>(ProductTypeText.class, "ProductTypeName");
    /**
     * Navigation property <b>_ProductType</b> for <b>ProductTypeText</b> to single <b>ProductType</b>.
     * 
     */
    @ElementName( "_ProductType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProductType to_ProductType;
    /**
     * Use with available request builders to apply the <b>_ProductType</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ProductTypeText, ProductType> TO__PRODUCT_TYPE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ProductTypeText, ProductType>(
            ProductTypeText.class,
            "_ProductType",
            ProductType.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProductTypeText> getType()
    {
        return ProductTypeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     * 
     * @param productType
     *            Product Type
     */
    public void setProductType( @Nullable final java.lang.String productType )
    {
        rememberChangedField("ProductType", this.productType);
        this.productType = productType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ProductTypeName</b>
     * </p>
     * 
     * @param productTypeName
     *            Description of product type
     */
    public void setProductTypeName( @Nullable final java.lang.String productTypeName )
    {
        rememberChangedField("ProductTypeName", this.productTypeName);
        this.productTypeName = productTypeName;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ProductTypeText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ProductType", getProductType());
        entityKey.addKeyProperty("Language", getLanguage());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ProductType", getProductType());
        values.put("Language", getLanguage());
        values.put("ProductTypeName", getProductTypeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProductType") ) {
                final Object value = values.remove("ProductType");
                if( (value == null) || (!value.equals(getProductType())) ) {
                    setProductType(((java.lang.String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductTypeName") ) {
                final Object value = values.remove("ProductTypeName");
                if( (value == null) || (!value.equals(getProductTypeName())) ) {
                    setProductTypeName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ProductType") ) {
                final Object value = (values).remove("_ProductType");
                if( value instanceof Map ) {
                    if( to_ProductType == null ) {
                        to_ProductType = new ProductType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ProductType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ProductTypeService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ProductType != null ) {
            (values).put("_ProductType", to_ProductType);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ProductType</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_ProductType</b>.
     * <p>
     * If the navigation property for an entity <b>ProductTypeText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ProductType</b> is already loaded, the result will contain
     *         the <b>ProductType</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<ProductType> getProductTypeIfPresent()
    {
        return Option.of(to_ProductType);
    }

    /**
     * Overwrites the associated <b>ProductType</b> entity for the loaded navigation property <b>_ProductType</b>.
     * 
     * @param value
     *            New <b>ProductType</b> entity.
     */
    public void setProductType( final ProductType value )
    {
        to_ProductType = value;
    }

    /**
     * Helper class to allow for fluent creation of ProductTypeText instances.
     * 
     */
    public final static class ProductTypeTextBuilder
    {

        private ProductType to_ProductType;
        private java.lang.String productType = null;

        private ProductTypeText.ProductTypeTextBuilder to_ProductType( final ProductType value )
        {
            to_ProductType = value;
            return this;
        }

        /**
         * Navigation property <b>_ProductType</b> for <b>ProductTypeText</b> to single <b>ProductType</b>.
         * 
         * @param value
         *            The ProductType to build this ProductTypeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductTypeText.ProductTypeTextBuilder productType( final ProductType value )
        {
            return to_ProductType(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>ProductType</b>
         * </p>
         * 
         * @param value
         *            The productType to build this ProductTypeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProductTypeText.ProductTypeTextBuilder productType( final java.lang.String value )
        {
            productType = value;
            return this;
        }

    }

}
