/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrAdjustmentTermType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrAdjustmentTerm extends VdmEntity<REContrAdjustmentTerm> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrAdjustmentTermType";
    /**
     * Selector for all available fields of REContrAdjustmentTerm.
     * 
     */
    public final static SimpleProperty<REContrAdjustmentTerm> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrAdjustmentTerm> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "InternalRealEstateNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @return Term Number
     */
    @Nullable
    @ElementName( "RETermNumber" )
    private java.lang.String rETermNumber;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_TERM_NUMBER =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "RETermNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentRule</b>
     * </p>
     * 
     * @return Adjustment Rule
     */
    @Nullable
    @ElementName( "REAdjustmentRule" )
    private java.lang.String rEAdjustmentRule;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_RULE =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentRule");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentElementaryRule</b>
     * </p>
     * 
     * @return Elementary Adjustment Rule (Part of Comb. Rule)
     */
    @Nullable
    @ElementName( "REAdjustmentElementaryRule" )
    private java.lang.String rEAdjustmentElementaryRule;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_ELEMENTARY_RULE =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentElementaryRule");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @return Date from to (RAP Key)
     */
    @Nullable
    @ElementName( "ValidityStartEndDateValue" )
    private java.lang.String validityStartEndDateValue;
    public final static SimpleProperty.String<REContrAdjustmentTerm> VALIDITY_START_END_DATE_VALUE =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "ValidityStartEndDateValue");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<REContrAdjustmentTerm> VALIDITY_START_DATE =
        new SimpleProperty.Date<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "ValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<REContrAdjustmentTerm> VALIDITY_END_DATE =
        new SimpleProperty.Date<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentMethod</b>
     * </p>
     * 
     * @return Adjustment Method
     */
    @Nullable
    @ElementName( "REAdjustmentMethod" )
    private java.lang.String rEAdjustmentMethod;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_METHOD =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentMethod");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsIndivGlobParam</b>
     * </p>
     * 
     * @return Indicator: Specify global param. individ. for contract/obj.
     */
    @Nullable
    @ElementName( "REAdjustmentIsIndivGlobParam" )
    private java.lang.Boolean rEAdjustmentIsIndivGlobParam;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_ADJUSTMENT_IS_INDIV_GLOB_PARAM =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIsIndivGlobParam");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsIndivSpcfcParam</b>
     * </p>
     * 
     * @return Indicator: Specify Spec. Param. Individ. for Contract/Obj.
     */
    @Nullable
    @ElementName( "REAdjustmentIsIndivSpcfcParam" )
    private java.lang.Boolean rEAdjustmentIsIndivSpcfcParam;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_ADJUSTMENT_IS_INDIV_SPCFC_PARAM =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIsIndivSpcfcParam");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @return Name of Term
     */
    @Nullable
    @ElementName( "RETermName" )
    private java.lang.String rETermName;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_TERM_NAME =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "RETermName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateObjectType</b>
     * </p>
     * 
     * @return Object Type
     */
    @Nullable
    @ElementName( "RealEstateObjectType" )
    private java.lang.String realEstateObjectType;
    public final static SimpleProperty.String<REContrAdjustmentTerm> REAL_ESTATE_OBJECT_TYPE =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "RealEstateObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObject</b>
     * </p>
     * 
     * @return Object Number
     */
    @Nullable
    @ElementName( "REStatusObject" )
    private java.lang.String rEStatusObject;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_STATUS_OBJECT =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REStatusObject");
    /**
     * Constraints: Not nullable, Maximum length: 45
     * <p>
     * Original property name from the Odata EDM: <b>REIdentificationKey</b>
     * </p>
     * 
     * @return ID Part Key, for example "1000/123"
     */
    @Nullable
    @ElementName( "REIdentificationKey" )
    private java.lang.String rEIdentificationKey;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_IDENTIFICATION_KEY =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REIdentificationKey");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RERuleIsUsingDefaults</b>
     * </p>
     * 
     * @return Bool: Use Customizing Defaults When Values Initial
     */
    @Nullable
    @ElementName( "RERuleIsUsingDefaults" )
    private java.lang.Boolean rERuleIsUsingDefaults;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_RULE_IS_USING_DEFAULTS =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "RERuleIsUsingDefaults");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsRuleApprovalRequired</b>
     * </p>
     * 
     * @return Indicator: Approval for Adjustment Required?
     */
    @Nullable
    @ElementName( "REIsRuleApprovalRequired" )
    private java.lang.Boolean rEIsRuleApprovalRequired;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_IS_RULE_APPROVAL_REQUIRED =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REIsRuleApprovalRequired");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsActvtnWithoutApprvl</b>
     * </p>
     * 
     * @return Indicator: Activation Without Approval Possible
     */
    @Nullable
    @ElementName( "REIsActvtnWithoutApprvl" )
    private java.lang.Boolean rEIsActvtnWithoutApprvl;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_IS_ACTVTN_WITHOUT_APPRVL =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REIsActvtnWithoutApprvl");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsDueDateChangeable</b>
     * </p>
     * 
     * @return Indicator: Is valid-from date manually changeable?
     */
    @Nullable
    @ElementName( "REIsDueDateChangeable" )
    private java.lang.Boolean rEIsDueDateChangeable;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_IS_DUE_DATE_CHANGEABLE =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REIsDueDateChangeable");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentPercentPassedValue</b>
     * </p>
     * 
     * @return Percentage with Which the Adjustment Amount Is Passed-On
     */
    @Nullable
    @ElementName( "REAdjustmentPercentPassedValue" )
    @DecimalDescriptor( precision = 5, scale = 2 )
    private BigDecimal rEAdjustmentPercentPassedValue;
    public final static SimpleProperty.NumericDecimal<REContrAdjustmentTerm> RE_ADJUSTMENT_PERCENT_PASSED_VALUE =
        new SimpleProperty.NumericDecimal<REContrAdjustmentTerm>(
            REContrAdjustmentTerm.class,
            "REAdjustmentPercentPassedValue");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REHasRentalObjectIncrease</b>
     * </p>
     * 
     * @return Consider Percentage Rate of Increase of Rental Object
     */
    @Nullable
    @ElementName( "REHasRentalObjectIncrease" )
    private java.lang.Boolean rEHasRentalObjectIncrease;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_HAS_RENTAL_OBJECT_INCREASE =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REHasRentalObjectIncrease");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentDirection</b>
     * </p>
     * 
     * @return In which direction (+/-/=) can the amount change?
     */
    @Nullable
    @ElementName( "REAdjustmentDirection" )
    private java.lang.String rEAdjustmentDirection;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_DIRECTION =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentDirection");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentChangeDirection</b>
     * </p>
     * 
     * @return How (+/-/=) Can the Amount Be Changed After Adjustment
     */
    @Nullable
    @ElementName( "REAdjustmentChangeDirection" )
    private java.lang.String rEAdjustmentChangeDirection;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_CHANGE_DIRECTION =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentChangeDirection");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentFrequency</b>
     * </p>
     * 
     * @return Adjustment Frequency
     */
    @Nullable
    @ElementName( "REAdjustmentFrequency" )
    private java.lang.String rEAdjustmentFrequency;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_FREQUENCY =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentFrequency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REFrequencyUnit</b>
     * </p>
     * 
     * @return Adjustment Frequency: Unit
     */
    @Nullable
    @ElementName( "REFrequencyUnit" )
    private java.lang.String rEFrequencyUnit;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_FREQUENCY_UNIT =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REFrequencyUnit");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsIntervalFromFrqcyStart</b>
     * </p>
     * 
     * @return Indicator: Calculate Minimum Interval from Frequency Start?
     */
    @Nullable
    @ElementName( "REIsIntervalFromFrqcyStart" )
    private java.lang.Boolean rEIsIntervalFromFrqcyStart;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_IS_INTERVAL_FROM_FRQCY_START =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REIsIntervalFromFrqcyStart");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsSimulationRule</b>
     * </p>
     * 
     * @return Indicator: Adjustment Rule Is Allowed for Simulation Only
     */
    @Nullable
    @ElementName( "REIsSimulationRule" )
    private java.lang.Boolean rEIsSimulationRule;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_IS_SIMULATION_RULE =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REIsSimulationRule");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RERuleHasNoDocument</b>
     * </p>
     * 
     * @return Indicator: No Adjustment Document
     */
    @Nullable
    @ElementName( "RERuleHasNoDocument" )
    private java.lang.Boolean rERuleHasNoDocument;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_RULE_HAS_NO_DOCUMENT =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "RERuleHasNoDocument");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentSubsqntCondition</b>
     * </p>
     * 
     * @return Influence on Subsequent Conditions
     */
    @Nullable
    @ElementName( "REAdjustmentSubsqntCondition" )
    private java.lang.String rEAdjustmentSubsqntCondition;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_SUBSQNT_CONDITION =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentSubsqntCondition");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsOnNextNotice</b>
     * </p>
     * 
     * @return Adjustment on Next Possible Notice Date
     */
    @Nullable
    @ElementName( "REAdjustmentIsOnNextNotice" )
    private java.lang.Boolean rEAdjustmentIsOnNextNotice;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_ADJUSTMENT_IS_ON_NEXT_NOTICE =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIsOnNextNotice");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentBase</b>
     * </p>
     * 
     * @return Adjustment Basis
     */
    @Nullable
    @ElementName( "REAdjustmentBase" )
    private java.lang.String rEAdjustmentBase;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_BASE =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentBase");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsAutoDefault</b>
     * </p>
     * 
     * @return Automatic Default Only
     */
    @Nullable
    @ElementName( "REAdjustmentIsAutoDefault" )
    private java.lang.Boolean rEAdjustmentIsAutoDefault;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_ADJUSTMENT_IS_AUTO_DEFAULT =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIsAutoDefault");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsNotifRequired</b>
     * </p>
     * 
     * @return Notification Required for Adjustment?
     */
    @Nullable
    @ElementName( "REAdjustmentIsNotifRequired" )
    private java.lang.Boolean rEAdjustmentIsNotifRequired;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_ADJUSTMENT_IS_NOTIF_REQUIRED =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIsNotifRequired");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsTimeDependent</b>
     * </p>
     * 
     * @return Consideration of Time-Dependency
     */
    @Nullable
    @ElementName( "REAdjustmentIsTimeDependent" )
    private java.lang.String rEAdjustmentIsTimeDependent;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_IS_TIME_DEPENDENT =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIsTimeDependent");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentDueDateIsMandatory</b>
     * </p>
     * 
     * @return Due Date Required for Follow-Up Postings
     */
    @Nullable
    @ElementName( "REAdjustmentDueDateIsMandatory" )
    private java.lang.Boolean rEAdjustmentDueDateIsMandatory;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_ADJUSTMENT_DUE_DATE_IS_MANDATORY =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(
            REContrAdjustmentTerm.class,
            "REAdjustmentDueDateIsMandatory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsNotRetroActive</b>
     * </p>
     * 
     * @return No Retroactive Adjustment
     */
    @Nullable
    @ElementName( "REAdjustmentIsNotRetroActive" )
    private java.lang.String rEAdjustmentIsNotRetroActive;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_IS_NOT_RETRO_ACTIVE =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIsNotRetroActive");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentBlockReason</b>
     * </p>
     * 
     * @return Reason for Adjustment Lock
     */
    @Nullable
    @ElementName( "REAdjustmentBlockReason" )
    private java.lang.String rEAdjustmentBlockReason;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_BLOCK_REASON =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REConditionType</b>
     * </p>
     * 
     * @return Condition Type of Dependent Condition
     */
    @Nullable
    @ElementName( "REConditionType" )
    private java.lang.String rEConditionType;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_CONDITION_TYPE =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REConditionType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RERuleSortOrder</b>
     * </p>
     * 
     * @return Sort Sequence of Rules for Adjustment Process
     */
    @Nullable
    @ElementName( "RERuleSortOrder" )
    private java.lang.String rERuleSortOrder;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_RULE_SORT_ORDER =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "RERuleSortOrder");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RECurrencyTranslationRule</b>
     * </p>
     * 
     * @return Currency Translation Rule
     */
    @Nullable
    @ElementName( "RECurrencyTranslationRule" )
    private java.lang.String rECurrencyTranslationRule;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_CURRENCY_TRANSLATION_RULE =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "RECurrencyTranslationRule");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIndexSeries</b>
     * </p>
     * 
     * @return Index Series on Which the Adjustment Is Based
     */
    @Nullable
    @ElementName( "REAdjustmentIndexSeries" )
    private java.lang.String rEAdjustmentIndexSeries;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_INDEX_SERIES =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIndexSeries");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIndexBaseYear</b>
     * </p>
     * 
     * @return Base Year for an Index Series
     */
    @Nullable
    @ElementName( "REAdjustmentIndexBaseYear" )
    private java.lang.String rEAdjustmentIndexBaseYear;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_INDEX_BASE_YEAR =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIndexBaseYear");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIdxIsAlwaysBaseYr</b>
     * </p>
     * 
     * @return Always Use Current Base Year
     */
    @Nullable
    @ElementName( "REAdjustmentIdxIsAlwaysBaseYr" )
    private java.lang.Boolean rEAdjustmentIdxIsAlwaysBaseYr;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_ADJUSTMENT_IDX_IS_ALWAYS_BASE_YR =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIdxIsAlwaysBaseYr");
    /**
     * Constraints: Not nullable, Precision: 8, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIdxMinChgPointsVal</b>
     * </p>
     * 
     * @return Minimum Change of Index Series Since Last Adjust. in Points
     */
    @Nullable
    @ElementName( "REAdjustmentIdxMinChgPointsVal" )
    @DecimalDescriptor( precision = 8, scale = 3 )
    private BigDecimal rEAdjustmentIdxMinChgPointsVal;
    public final static SimpleProperty.NumericDecimal<REContrAdjustmentTerm> RE_ADJUSTMENT_IDX_MIN_CHG_POINTS_VAL =
        new SimpleProperty.NumericDecimal<REContrAdjustmentTerm>(
            REContrAdjustmentTerm.class,
            "REAdjustmentIdxMinChgPointsVal");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIdxMinChgPercent</b>
     * </p>
     * 
     * @return Minimum Change of Index Series Since Last Adjust. in Percent
     */
    @Nullable
    @ElementName( "REAdjustmentIdxMinChgPercent" )
    @DecimalDescriptor( precision = 7, scale = 4 )
    private BigDecimal rEAdjustmentIdxMinChgPercent;
    public final static SimpleProperty.NumericDecimal<REContrAdjustmentTerm> RE_ADJUSTMENT_IDX_MIN_CHG_PERCENT =
        new SimpleProperty.NumericDecimal<REContrAdjustmentTerm>(
            REContrAdjustmentTerm.class,
            "REAdjustmentIdxMinChgPercent");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsIdxChgPointsExcd</b>
     * </p>
     * 
     * @return Adjust When Difference in Points Is Exceeded
     */
    @Nullable
    @ElementName( "REAdjustmentIsIdxChgPointsExcd" )
    private java.lang.Boolean rEAdjustmentIsIdxChgPointsExcd;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_ADJUSTMENT_IS_IDX_CHG_POINTS_EXCD =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(
            REContrAdjustmentTerm.class,
            "REAdjustmentIsIdxChgPointsExcd");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsIdxChgPctExcd</b>
     * </p>
     * 
     * @return Adjust When Percentage Difference Exceeded
     */
    @Nullable
    @ElementName( "REAdjustmentIsIdxChgPctExcd" )
    private java.lang.Boolean rEAdjustmentIsIdxChgPctExcd;
    public final static SimpleProperty.Boolean<REContrAdjustmentTerm> RE_ADJUSTMENT_IS_IDX_CHG_PCT_EXCD =
        new SimpleProperty.Boolean<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIsIdxChgPctExcd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentRhythmFlexible</b>
     * </p>
     * 
     * @return Flexibility of Adjustment Frequency (Set, Earliest, ...)
     */
    @Nullable
    @ElementName( "REAdjustmentRhythmFlexible" )
    private java.lang.String rEAdjustmentRhythmFlexible;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_RHYTHM_FLEXIBLE =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentRhythmFlexible");
    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentDelayInMonths</b>
     * </p>
     * 
     * @return Adjustment Delay in Months
     */
    @Nullable
    @ElementName( "REAdjustmentDelayInMonths" )
    @DecimalDescriptor( precision = 3, scale = 0 )
    private BigDecimal rEAdjustmentDelayInMonths;
    public final static SimpleProperty.NumericDecimal<REContrAdjustmentTerm> RE_ADJUSTMENT_DELAY_IN_MONTHS =
        new SimpleProperty.NumericDecimal<REContrAdjustmentTerm>(
            REContrAdjustmentTerm.class,
            "REAdjustmentDelayInMonths");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentDelayUnit</b>
     * </p>
     * 
     * @return Possible Adjustment Dates
     */
    @Nullable
    @ElementName( "REAdjustmentDelayUnit" )
    private java.lang.String rEAdjustmentDelayUnit;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_DELAY_UNIT =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentDelayUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIndexBasis</b>
     * </p>
     * 
     * @return Adjustment Basis
     */
    @Nullable
    @ElementName( "REAdjustmentIndexBasis" )
    private java.lang.String rEAdjustmentIndexBasis;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_INDEX_BASIS =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIndexBasis");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIndexOrSpread</b>
     * </p>
     * 
     * @return Index-Linked Contract: Index or Spread Clause
     */
    @Nullable
    @ElementName( "REAdjustmentIndexOrSpread" )
    private java.lang.String rEAdjustmentIndexOrSpread;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_INDEX_OR_SPREAD =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIndexOrSpread");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIndexOrPerformance</b>
     * </p>
     * 
     * @return Index-Linked Contract: Performance Provision or Index Clause
     */
    @Nullable
    @ElementName( "REAdjustmentIndexOrPerformance" )
    private java.lang.String rEAdjustmentIndexOrPerformance;
    public final static SimpleProperty.String<REContrAdjustmentTerm> RE_ADJUSTMENT_INDEX_OR_PERFORMANCE =
        new SimpleProperty.String<REContrAdjustmentTerm>(REContrAdjustmentTerm.class, "REAdjustmentIndexOrPerformance");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrAdjustmentTerm, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrAdjustmentTerm, SAP__Message>(
            REContrAdjustmentTerm.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrAdjustmentTerm</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrAdjustmentTerm, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrAdjustmentTerm, REContract>(
            REContrAdjustmentTerm.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrAdjustmentTerm> getType()
    {
        return REContrAdjustmentTerm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @param rETermNumber
     *            Term Number
     */
    public void setRETermNumber( @Nullable final java.lang.String rETermNumber )
    {
        rememberChangedField("RETermNumber", this.rETermNumber);
        this.rETermNumber = rETermNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentRule</b>
     * </p>
     * 
     * @param rEAdjustmentRule
     *            Adjustment Rule
     */
    public void setREAdjustmentRule( @Nullable final java.lang.String rEAdjustmentRule )
    {
        rememberChangedField("REAdjustmentRule", this.rEAdjustmentRule);
        this.rEAdjustmentRule = rEAdjustmentRule;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentElementaryRule</b>
     * </p>
     * 
     * @param rEAdjustmentElementaryRule
     *            Elementary Adjustment Rule (Part of Comb. Rule)
     */
    public void setREAdjustmentElementaryRule( @Nullable final java.lang.String rEAdjustmentElementaryRule )
    {
        rememberChangedField("REAdjustmentElementaryRule", this.rEAdjustmentElementaryRule);
        this.rEAdjustmentElementaryRule = rEAdjustmentElementaryRule;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     */
    public void setValidityStartEndDateValue( @Nullable final java.lang.String validityStartEndDateValue )
    {
        rememberChangedField("ValidityStartEndDateValue", this.validityStartEndDateValue);
        this.validityStartEndDateValue = validityStartEndDateValue;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentMethod</b>
     * </p>
     * 
     * @param rEAdjustmentMethod
     *            Adjustment Method
     */
    public void setREAdjustmentMethod( @Nullable final java.lang.String rEAdjustmentMethod )
    {
        rememberChangedField("REAdjustmentMethod", this.rEAdjustmentMethod);
        this.rEAdjustmentMethod = rEAdjustmentMethod;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsIndivGlobParam</b>
     * </p>
     * 
     * @param rEAdjustmentIsIndivGlobParam
     *            Indicator: Specify global param. individ. for contract/obj.
     */
    public void setREAdjustmentIsIndivGlobParam( @Nullable final java.lang.Boolean rEAdjustmentIsIndivGlobParam )
    {
        rememberChangedField("REAdjustmentIsIndivGlobParam", this.rEAdjustmentIsIndivGlobParam);
        this.rEAdjustmentIsIndivGlobParam = rEAdjustmentIsIndivGlobParam;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsIndivSpcfcParam</b>
     * </p>
     * 
     * @param rEAdjustmentIsIndivSpcfcParam
     *            Indicator: Specify Spec. Param. Individ. for Contract/Obj.
     */
    public void setREAdjustmentIsIndivSpcfcParam( @Nullable final java.lang.Boolean rEAdjustmentIsIndivSpcfcParam )
    {
        rememberChangedField("REAdjustmentIsIndivSpcfcParam", this.rEAdjustmentIsIndivSpcfcParam);
        this.rEAdjustmentIsIndivSpcfcParam = rEAdjustmentIsIndivSpcfcParam;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @param rETermName
     *            Name of Term
     */
    public void setRETermName( @Nullable final java.lang.String rETermName )
    {
        rememberChangedField("RETermName", this.rETermName);
        this.rETermName = rETermName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateObjectType</b>
     * </p>
     * 
     * @param realEstateObjectType
     *            Object Type
     */
    public void setRealEstateObjectType( @Nullable final java.lang.String realEstateObjectType )
    {
        rememberChangedField("RealEstateObjectType", this.realEstateObjectType);
        this.realEstateObjectType = realEstateObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObject</b>
     * </p>
     * 
     * @param rEStatusObject
     *            Object Number
     */
    public void setREStatusObject( @Nullable final java.lang.String rEStatusObject )
    {
        rememberChangedField("REStatusObject", this.rEStatusObject);
        this.rEStatusObject = rEStatusObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 45
     * <p>
     * Original property name from the Odata EDM: <b>REIdentificationKey</b>
     * </p>
     * 
     * @param rEIdentificationKey
     *            ID Part Key, for example "1000/123"
     */
    public void setREIdentificationKey( @Nullable final java.lang.String rEIdentificationKey )
    {
        rememberChangedField("REIdentificationKey", this.rEIdentificationKey);
        this.rEIdentificationKey = rEIdentificationKey;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RERuleIsUsingDefaults</b>
     * </p>
     * 
     * @param rERuleIsUsingDefaults
     *            Bool: Use Customizing Defaults When Values Initial
     */
    public void setRERuleIsUsingDefaults( @Nullable final java.lang.Boolean rERuleIsUsingDefaults )
    {
        rememberChangedField("RERuleIsUsingDefaults", this.rERuleIsUsingDefaults);
        this.rERuleIsUsingDefaults = rERuleIsUsingDefaults;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsRuleApprovalRequired</b>
     * </p>
     * 
     * @param rEIsRuleApprovalRequired
     *            Indicator: Approval for Adjustment Required?
     */
    public void setREIsRuleApprovalRequired( @Nullable final java.lang.Boolean rEIsRuleApprovalRequired )
    {
        rememberChangedField("REIsRuleApprovalRequired", this.rEIsRuleApprovalRequired);
        this.rEIsRuleApprovalRequired = rEIsRuleApprovalRequired;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsActvtnWithoutApprvl</b>
     * </p>
     * 
     * @param rEIsActvtnWithoutApprvl
     *            Indicator: Activation Without Approval Possible
     */
    public void setREIsActvtnWithoutApprvl( @Nullable final java.lang.Boolean rEIsActvtnWithoutApprvl )
    {
        rememberChangedField("REIsActvtnWithoutApprvl", this.rEIsActvtnWithoutApprvl);
        this.rEIsActvtnWithoutApprvl = rEIsActvtnWithoutApprvl;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsDueDateChangeable</b>
     * </p>
     * 
     * @param rEIsDueDateChangeable
     *            Indicator: Is valid-from date manually changeable?
     */
    public void setREIsDueDateChangeable( @Nullable final java.lang.Boolean rEIsDueDateChangeable )
    {
        rememberChangedField("REIsDueDateChangeable", this.rEIsDueDateChangeable);
        this.rEIsDueDateChangeable = rEIsDueDateChangeable;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentPercentPassedValue</b>
     * </p>
     * 
     * @param rEAdjustmentPercentPassedValue
     *            Percentage with Which the Adjustment Amount Is Passed-On
     */
    public void setREAdjustmentPercentPassedValue( @Nullable final BigDecimal rEAdjustmentPercentPassedValue )
    {
        rememberChangedField("REAdjustmentPercentPassedValue", this.rEAdjustmentPercentPassedValue);
        this.rEAdjustmentPercentPassedValue = rEAdjustmentPercentPassedValue;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REHasRentalObjectIncrease</b>
     * </p>
     * 
     * @param rEHasRentalObjectIncrease
     *            Consider Percentage Rate of Increase of Rental Object
     */
    public void setREHasRentalObjectIncrease( @Nullable final java.lang.Boolean rEHasRentalObjectIncrease )
    {
        rememberChangedField("REHasRentalObjectIncrease", this.rEHasRentalObjectIncrease);
        this.rEHasRentalObjectIncrease = rEHasRentalObjectIncrease;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentDirection</b>
     * </p>
     * 
     * @param rEAdjustmentDirection
     *            In which direction (+/-/=) can the amount change?
     */
    public void setREAdjustmentDirection( @Nullable final java.lang.String rEAdjustmentDirection )
    {
        rememberChangedField("REAdjustmentDirection", this.rEAdjustmentDirection);
        this.rEAdjustmentDirection = rEAdjustmentDirection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentChangeDirection</b>
     * </p>
     * 
     * @param rEAdjustmentChangeDirection
     *            How (+/-/=) Can the Amount Be Changed After Adjustment
     */
    public void setREAdjustmentChangeDirection( @Nullable final java.lang.String rEAdjustmentChangeDirection )
    {
        rememberChangedField("REAdjustmentChangeDirection", this.rEAdjustmentChangeDirection);
        this.rEAdjustmentChangeDirection = rEAdjustmentChangeDirection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentFrequency</b>
     * </p>
     * 
     * @param rEAdjustmentFrequency
     *            Adjustment Frequency
     */
    public void setREAdjustmentFrequency( @Nullable final java.lang.String rEAdjustmentFrequency )
    {
        rememberChangedField("REAdjustmentFrequency", this.rEAdjustmentFrequency);
        this.rEAdjustmentFrequency = rEAdjustmentFrequency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REFrequencyUnit</b>
     * </p>
     * 
     * @param rEFrequencyUnit
     *            Adjustment Frequency: Unit
     */
    public void setREFrequencyUnit( @Nullable final java.lang.String rEFrequencyUnit )
    {
        rememberChangedField("REFrequencyUnit", this.rEFrequencyUnit);
        this.rEFrequencyUnit = rEFrequencyUnit;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsIntervalFromFrqcyStart</b>
     * </p>
     * 
     * @param rEIsIntervalFromFrqcyStart
     *            Indicator: Calculate Minimum Interval from Frequency Start?
     */
    public void setREIsIntervalFromFrqcyStart( @Nullable final java.lang.Boolean rEIsIntervalFromFrqcyStart )
    {
        rememberChangedField("REIsIntervalFromFrqcyStart", this.rEIsIntervalFromFrqcyStart);
        this.rEIsIntervalFromFrqcyStart = rEIsIntervalFromFrqcyStart;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsSimulationRule</b>
     * </p>
     * 
     * @param rEIsSimulationRule
     *            Indicator: Adjustment Rule Is Allowed for Simulation Only
     */
    public void setREIsSimulationRule( @Nullable final java.lang.Boolean rEIsSimulationRule )
    {
        rememberChangedField("REIsSimulationRule", this.rEIsSimulationRule);
        this.rEIsSimulationRule = rEIsSimulationRule;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RERuleHasNoDocument</b>
     * </p>
     * 
     * @param rERuleHasNoDocument
     *            Indicator: No Adjustment Document
     */
    public void setRERuleHasNoDocument( @Nullable final java.lang.Boolean rERuleHasNoDocument )
    {
        rememberChangedField("RERuleHasNoDocument", this.rERuleHasNoDocument);
        this.rERuleHasNoDocument = rERuleHasNoDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentSubsqntCondition</b>
     * </p>
     * 
     * @param rEAdjustmentSubsqntCondition
     *            Influence on Subsequent Conditions
     */
    public void setREAdjustmentSubsqntCondition( @Nullable final java.lang.String rEAdjustmentSubsqntCondition )
    {
        rememberChangedField("REAdjustmentSubsqntCondition", this.rEAdjustmentSubsqntCondition);
        this.rEAdjustmentSubsqntCondition = rEAdjustmentSubsqntCondition;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsOnNextNotice</b>
     * </p>
     * 
     * @param rEAdjustmentIsOnNextNotice
     *            Adjustment on Next Possible Notice Date
     */
    public void setREAdjustmentIsOnNextNotice( @Nullable final java.lang.Boolean rEAdjustmentIsOnNextNotice )
    {
        rememberChangedField("REAdjustmentIsOnNextNotice", this.rEAdjustmentIsOnNextNotice);
        this.rEAdjustmentIsOnNextNotice = rEAdjustmentIsOnNextNotice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentBase</b>
     * </p>
     * 
     * @param rEAdjustmentBase
     *            Adjustment Basis
     */
    public void setREAdjustmentBase( @Nullable final java.lang.String rEAdjustmentBase )
    {
        rememberChangedField("REAdjustmentBase", this.rEAdjustmentBase);
        this.rEAdjustmentBase = rEAdjustmentBase;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsAutoDefault</b>
     * </p>
     * 
     * @param rEAdjustmentIsAutoDefault
     *            Automatic Default Only
     */
    public void setREAdjustmentIsAutoDefault( @Nullable final java.lang.Boolean rEAdjustmentIsAutoDefault )
    {
        rememberChangedField("REAdjustmentIsAutoDefault", this.rEAdjustmentIsAutoDefault);
        this.rEAdjustmentIsAutoDefault = rEAdjustmentIsAutoDefault;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsNotifRequired</b>
     * </p>
     * 
     * @param rEAdjustmentIsNotifRequired
     *            Notification Required for Adjustment?
     */
    public void setREAdjustmentIsNotifRequired( @Nullable final java.lang.Boolean rEAdjustmentIsNotifRequired )
    {
        rememberChangedField("REAdjustmentIsNotifRequired", this.rEAdjustmentIsNotifRequired);
        this.rEAdjustmentIsNotifRequired = rEAdjustmentIsNotifRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsTimeDependent</b>
     * </p>
     * 
     * @param rEAdjustmentIsTimeDependent
     *            Consideration of Time-Dependency
     */
    public void setREAdjustmentIsTimeDependent( @Nullable final java.lang.String rEAdjustmentIsTimeDependent )
    {
        rememberChangedField("REAdjustmentIsTimeDependent", this.rEAdjustmentIsTimeDependent);
        this.rEAdjustmentIsTimeDependent = rEAdjustmentIsTimeDependent;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentDueDateIsMandatory</b>
     * </p>
     * 
     * @param rEAdjustmentDueDateIsMandatory
     *            Due Date Required for Follow-Up Postings
     */
    public void setREAdjustmentDueDateIsMandatory( @Nullable final java.lang.Boolean rEAdjustmentDueDateIsMandatory )
    {
        rememberChangedField("REAdjustmentDueDateIsMandatory", this.rEAdjustmentDueDateIsMandatory);
        this.rEAdjustmentDueDateIsMandatory = rEAdjustmentDueDateIsMandatory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsNotRetroActive</b>
     * </p>
     * 
     * @param rEAdjustmentIsNotRetroActive
     *            No Retroactive Adjustment
     */
    public void setREAdjustmentIsNotRetroActive( @Nullable final java.lang.String rEAdjustmentIsNotRetroActive )
    {
        rememberChangedField("REAdjustmentIsNotRetroActive", this.rEAdjustmentIsNotRetroActive);
        this.rEAdjustmentIsNotRetroActive = rEAdjustmentIsNotRetroActive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentBlockReason</b>
     * </p>
     * 
     * @param rEAdjustmentBlockReason
     *            Reason for Adjustment Lock
     */
    public void setREAdjustmentBlockReason( @Nullable final java.lang.String rEAdjustmentBlockReason )
    {
        rememberChangedField("REAdjustmentBlockReason", this.rEAdjustmentBlockReason);
        this.rEAdjustmentBlockReason = rEAdjustmentBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REConditionType</b>
     * </p>
     * 
     * @param rEConditionType
     *            Condition Type of Dependent Condition
     */
    public void setREConditionType( @Nullable final java.lang.String rEConditionType )
    {
        rememberChangedField("REConditionType", this.rEConditionType);
        this.rEConditionType = rEConditionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RERuleSortOrder</b>
     * </p>
     * 
     * @param rERuleSortOrder
     *            Sort Sequence of Rules for Adjustment Process
     */
    public void setRERuleSortOrder( @Nullable final java.lang.String rERuleSortOrder )
    {
        rememberChangedField("RERuleSortOrder", this.rERuleSortOrder);
        this.rERuleSortOrder = rERuleSortOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RECurrencyTranslationRule</b>
     * </p>
     * 
     * @param rECurrencyTranslationRule
     *            Currency Translation Rule
     */
    public void setRECurrencyTranslationRule( @Nullable final java.lang.String rECurrencyTranslationRule )
    {
        rememberChangedField("RECurrencyTranslationRule", this.rECurrencyTranslationRule);
        this.rECurrencyTranslationRule = rECurrencyTranslationRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIndexSeries</b>
     * </p>
     * 
     * @param rEAdjustmentIndexSeries
     *            Index Series on Which the Adjustment Is Based
     */
    public void setREAdjustmentIndexSeries( @Nullable final java.lang.String rEAdjustmentIndexSeries )
    {
        rememberChangedField("REAdjustmentIndexSeries", this.rEAdjustmentIndexSeries);
        this.rEAdjustmentIndexSeries = rEAdjustmentIndexSeries;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIndexBaseYear</b>
     * </p>
     * 
     * @param rEAdjustmentIndexBaseYear
     *            Base Year for an Index Series
     */
    public void setREAdjustmentIndexBaseYear( @Nullable final java.lang.String rEAdjustmentIndexBaseYear )
    {
        rememberChangedField("REAdjustmentIndexBaseYear", this.rEAdjustmentIndexBaseYear);
        this.rEAdjustmentIndexBaseYear = rEAdjustmentIndexBaseYear;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIdxIsAlwaysBaseYr</b>
     * </p>
     * 
     * @param rEAdjustmentIdxIsAlwaysBaseYr
     *            Always Use Current Base Year
     */
    public void setREAdjustmentIdxIsAlwaysBaseYr( @Nullable final java.lang.Boolean rEAdjustmentIdxIsAlwaysBaseYr )
    {
        rememberChangedField("REAdjustmentIdxIsAlwaysBaseYr", this.rEAdjustmentIdxIsAlwaysBaseYr);
        this.rEAdjustmentIdxIsAlwaysBaseYr = rEAdjustmentIdxIsAlwaysBaseYr;
    }

    /**
     * Constraints: Not nullable, Precision: 8, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIdxMinChgPointsVal</b>
     * </p>
     * 
     * @param rEAdjustmentIdxMinChgPointsVal
     *            Minimum Change of Index Series Since Last Adjust. in Points
     */
    public void setREAdjustmentIdxMinChgPointsVal( @Nullable final BigDecimal rEAdjustmentIdxMinChgPointsVal )
    {
        rememberChangedField("REAdjustmentIdxMinChgPointsVal", this.rEAdjustmentIdxMinChgPointsVal);
        this.rEAdjustmentIdxMinChgPointsVal = rEAdjustmentIdxMinChgPointsVal;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIdxMinChgPercent</b>
     * </p>
     * 
     * @param rEAdjustmentIdxMinChgPercent
     *            Minimum Change of Index Series Since Last Adjust. in Percent
     */
    public void setREAdjustmentIdxMinChgPercent( @Nullable final BigDecimal rEAdjustmentIdxMinChgPercent )
    {
        rememberChangedField("REAdjustmentIdxMinChgPercent", this.rEAdjustmentIdxMinChgPercent);
        this.rEAdjustmentIdxMinChgPercent = rEAdjustmentIdxMinChgPercent;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsIdxChgPointsExcd</b>
     * </p>
     * 
     * @param rEAdjustmentIsIdxChgPointsExcd
     *            Adjust When Difference in Points Is Exceeded
     */
    public void setREAdjustmentIsIdxChgPointsExcd( @Nullable final java.lang.Boolean rEAdjustmentIsIdxChgPointsExcd )
    {
        rememberChangedField("REAdjustmentIsIdxChgPointsExcd", this.rEAdjustmentIsIdxChgPointsExcd);
        this.rEAdjustmentIsIdxChgPointsExcd = rEAdjustmentIsIdxChgPointsExcd;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIsIdxChgPctExcd</b>
     * </p>
     * 
     * @param rEAdjustmentIsIdxChgPctExcd
     *            Adjust When Percentage Difference Exceeded
     */
    public void setREAdjustmentIsIdxChgPctExcd( @Nullable final java.lang.Boolean rEAdjustmentIsIdxChgPctExcd )
    {
        rememberChangedField("REAdjustmentIsIdxChgPctExcd", this.rEAdjustmentIsIdxChgPctExcd);
        this.rEAdjustmentIsIdxChgPctExcd = rEAdjustmentIsIdxChgPctExcd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentRhythmFlexible</b>
     * </p>
     * 
     * @param rEAdjustmentRhythmFlexible
     *            Flexibility of Adjustment Frequency (Set, Earliest, ...)
     */
    public void setREAdjustmentRhythmFlexible( @Nullable final java.lang.String rEAdjustmentRhythmFlexible )
    {
        rememberChangedField("REAdjustmentRhythmFlexible", this.rEAdjustmentRhythmFlexible);
        this.rEAdjustmentRhythmFlexible = rEAdjustmentRhythmFlexible;
    }

    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentDelayInMonths</b>
     * </p>
     * 
     * @param rEAdjustmentDelayInMonths
     *            Adjustment Delay in Months
     */
    public void setREAdjustmentDelayInMonths( @Nullable final BigDecimal rEAdjustmentDelayInMonths )
    {
        rememberChangedField("REAdjustmentDelayInMonths", this.rEAdjustmentDelayInMonths);
        this.rEAdjustmentDelayInMonths = rEAdjustmentDelayInMonths;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentDelayUnit</b>
     * </p>
     * 
     * @param rEAdjustmentDelayUnit
     *            Possible Adjustment Dates
     */
    public void setREAdjustmentDelayUnit( @Nullable final java.lang.String rEAdjustmentDelayUnit )
    {
        rememberChangedField("REAdjustmentDelayUnit", this.rEAdjustmentDelayUnit);
        this.rEAdjustmentDelayUnit = rEAdjustmentDelayUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIndexBasis</b>
     * </p>
     * 
     * @param rEAdjustmentIndexBasis
     *            Adjustment Basis
     */
    public void setREAdjustmentIndexBasis( @Nullable final java.lang.String rEAdjustmentIndexBasis )
    {
        rememberChangedField("REAdjustmentIndexBasis", this.rEAdjustmentIndexBasis);
        this.rEAdjustmentIndexBasis = rEAdjustmentIndexBasis;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIndexOrSpread</b>
     * </p>
     * 
     * @param rEAdjustmentIndexOrSpread
     *            Index-Linked Contract: Index or Spread Clause
     */
    public void setREAdjustmentIndexOrSpread( @Nullable final java.lang.String rEAdjustmentIndexOrSpread )
    {
        rememberChangedField("REAdjustmentIndexOrSpread", this.rEAdjustmentIndexOrSpread);
        this.rEAdjustmentIndexOrSpread = rEAdjustmentIndexOrSpread;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentIndexOrPerformance</b>
     * </p>
     * 
     * @param rEAdjustmentIndexOrPerformance
     *            Index-Linked Contract: Performance Provision or Index Clause
     */
    public void setREAdjustmentIndexOrPerformance( @Nullable final java.lang.String rEAdjustmentIndexOrPerformance )
    {
        rememberChangedField("REAdjustmentIndexOrPerformance", this.rEAdjustmentIndexOrPerformance);
        this.rEAdjustmentIndexOrPerformance = rEAdjustmentIndexOrPerformance;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrAdjustmentTerm";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        entityKey.addKeyProperty("RETermNumber", getRETermNumber());
        entityKey.addKeyProperty("REAdjustmentRule", getREAdjustmentRule());
        entityKey.addKeyProperty("REAdjustmentElementaryRule", getREAdjustmentElementaryRule());
        entityKey.addKeyProperty("ValidityStartEndDateValue", getValidityStartEndDateValue());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("RETermNumber", getRETermNumber());
        values.put("REAdjustmentRule", getREAdjustmentRule());
        values.put("REAdjustmentElementaryRule", getREAdjustmentElementaryRule());
        values.put("ValidityStartEndDateValue", getValidityStartEndDateValue());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("REAdjustmentMethod", getREAdjustmentMethod());
        values.put("REAdjustmentIsIndivGlobParam", getREAdjustmentIsIndivGlobParam());
        values.put("REAdjustmentIsIndivSpcfcParam", getREAdjustmentIsIndivSpcfcParam());
        values.put("RETermName", getRETermName());
        values.put("RealEstateObjectType", getRealEstateObjectType());
        values.put("REStatusObject", getREStatusObject());
        values.put("REIdentificationKey", getREIdentificationKey());
        values.put("RERuleIsUsingDefaults", getRERuleIsUsingDefaults());
        values.put("REIsRuleApprovalRequired", getREIsRuleApprovalRequired());
        values.put("REIsActvtnWithoutApprvl", getREIsActvtnWithoutApprvl());
        values.put("REIsDueDateChangeable", getREIsDueDateChangeable());
        values.put("REAdjustmentPercentPassedValue", getREAdjustmentPercentPassedValue());
        values.put("REHasRentalObjectIncrease", getREHasRentalObjectIncrease());
        values.put("REAdjustmentDirection", getREAdjustmentDirection());
        values.put("REAdjustmentChangeDirection", getREAdjustmentChangeDirection());
        values.put("REAdjustmentFrequency", getREAdjustmentFrequency());
        values.put("REFrequencyUnit", getREFrequencyUnit());
        values.put("REIsIntervalFromFrqcyStart", getREIsIntervalFromFrqcyStart());
        values.put("REIsSimulationRule", getREIsSimulationRule());
        values.put("RERuleHasNoDocument", getRERuleHasNoDocument());
        values.put("REAdjustmentSubsqntCondition", getREAdjustmentSubsqntCondition());
        values.put("REAdjustmentIsOnNextNotice", getREAdjustmentIsOnNextNotice());
        values.put("REAdjustmentBase", getREAdjustmentBase());
        values.put("REAdjustmentIsAutoDefault", getREAdjustmentIsAutoDefault());
        values.put("REAdjustmentIsNotifRequired", getREAdjustmentIsNotifRequired());
        values.put("REAdjustmentIsTimeDependent", getREAdjustmentIsTimeDependent());
        values.put("REAdjustmentDueDateIsMandatory", getREAdjustmentDueDateIsMandatory());
        values.put("REAdjustmentIsNotRetroActive", getREAdjustmentIsNotRetroActive());
        values.put("REAdjustmentBlockReason", getREAdjustmentBlockReason());
        values.put("REConditionType", getREConditionType());
        values.put("RERuleSortOrder", getRERuleSortOrder());
        values.put("RECurrencyTranslationRule", getRECurrencyTranslationRule());
        values.put("REAdjustmentIndexSeries", getREAdjustmentIndexSeries());
        values.put("REAdjustmentIndexBaseYear", getREAdjustmentIndexBaseYear());
        values.put("REAdjustmentIdxIsAlwaysBaseYr", getREAdjustmentIdxIsAlwaysBaseYr());
        values.put("REAdjustmentIdxMinChgPointsVal", getREAdjustmentIdxMinChgPointsVal());
        values.put("REAdjustmentIdxMinChgPercent", getREAdjustmentIdxMinChgPercent());
        values.put("REAdjustmentIsIdxChgPointsExcd", getREAdjustmentIsIdxChgPointsExcd());
        values.put("REAdjustmentIsIdxChgPctExcd", getREAdjustmentIsIdxChgPctExcd());
        values.put("REAdjustmentRhythmFlexible", getREAdjustmentRhythmFlexible());
        values.put("REAdjustmentDelayInMonths", getREAdjustmentDelayInMonths());
        values.put("REAdjustmentDelayUnit", getREAdjustmentDelayUnit());
        values.put("REAdjustmentIndexBasis", getREAdjustmentIndexBasis());
        values.put("REAdjustmentIndexOrSpread", getREAdjustmentIndexOrSpread());
        values.put("REAdjustmentIndexOrPerformance", getREAdjustmentIndexOrPerformance());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermNumber") ) {
                final Object value = values.remove("RETermNumber");
                if( (value == null) || (!value.equals(getRETermNumber())) ) {
                    setRETermNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentRule") ) {
                final Object value = values.remove("REAdjustmentRule");
                if( (value == null) || (!value.equals(getREAdjustmentRule())) ) {
                    setREAdjustmentRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentElementaryRule") ) {
                final Object value = values.remove("REAdjustmentElementaryRule");
                if( (value == null) || (!value.equals(getREAdjustmentElementaryRule())) ) {
                    setREAdjustmentElementaryRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartEndDateValue") ) {
                final Object value = values.remove("ValidityStartEndDateValue");
                if( (value == null) || (!value.equals(getValidityStartEndDateValue())) ) {
                    setValidityStartEndDateValue(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REAdjustmentMethod") ) {
                final Object value = values.remove("REAdjustmentMethod");
                if( (value == null) || (!value.equals(getREAdjustmentMethod())) ) {
                    setREAdjustmentMethod(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentIsIndivGlobParam") ) {
                final Object value = values.remove("REAdjustmentIsIndivGlobParam");
                if( (value == null) || (!value.equals(getREAdjustmentIsIndivGlobParam())) ) {
                    setREAdjustmentIsIndivGlobParam(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REAdjustmentIsIndivSpcfcParam") ) {
                final Object value = values.remove("REAdjustmentIsIndivSpcfcParam");
                if( (value == null) || (!value.equals(getREAdjustmentIsIndivSpcfcParam())) ) {
                    setREAdjustmentIsIndivSpcfcParam(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("RETermName") ) {
                final Object value = values.remove("RETermName");
                if( (value == null) || (!value.equals(getRETermName())) ) {
                    setRETermName(((java.lang.String) value));
                }
            }
            if( values.containsKey("RealEstateObjectType") ) {
                final Object value = values.remove("RealEstateObjectType");
                if( (value == null) || (!value.equals(getRealEstateObjectType())) ) {
                    setRealEstateObjectType(((java.lang.String) value));
                }
            }
            if( values.containsKey("REStatusObject") ) {
                final Object value = values.remove("REStatusObject");
                if( (value == null) || (!value.equals(getREStatusObject())) ) {
                    setREStatusObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("REIdentificationKey") ) {
                final Object value = values.remove("REIdentificationKey");
                if( (value == null) || (!value.equals(getREIdentificationKey())) ) {
                    setREIdentificationKey(((java.lang.String) value));
                }
            }
            if( values.containsKey("RERuleIsUsingDefaults") ) {
                final Object value = values.remove("RERuleIsUsingDefaults");
                if( (value == null) || (!value.equals(getRERuleIsUsingDefaults())) ) {
                    setRERuleIsUsingDefaults(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REIsRuleApprovalRequired") ) {
                final Object value = values.remove("REIsRuleApprovalRequired");
                if( (value == null) || (!value.equals(getREIsRuleApprovalRequired())) ) {
                    setREIsRuleApprovalRequired(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REIsActvtnWithoutApprvl") ) {
                final Object value = values.remove("REIsActvtnWithoutApprvl");
                if( (value == null) || (!value.equals(getREIsActvtnWithoutApprvl())) ) {
                    setREIsActvtnWithoutApprvl(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REIsDueDateChangeable") ) {
                final Object value = values.remove("REIsDueDateChangeable");
                if( (value == null) || (!value.equals(getREIsDueDateChangeable())) ) {
                    setREIsDueDateChangeable(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REAdjustmentPercentPassedValue") ) {
                final Object value = values.remove("REAdjustmentPercentPassedValue");
                if( (value == null) || (!value.equals(getREAdjustmentPercentPassedValue())) ) {
                    setREAdjustmentPercentPassedValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("REHasRentalObjectIncrease") ) {
                final Object value = values.remove("REHasRentalObjectIncrease");
                if( (value == null) || (!value.equals(getREHasRentalObjectIncrease())) ) {
                    setREHasRentalObjectIncrease(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REAdjustmentDirection") ) {
                final Object value = values.remove("REAdjustmentDirection");
                if( (value == null) || (!value.equals(getREAdjustmentDirection())) ) {
                    setREAdjustmentDirection(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentChangeDirection") ) {
                final Object value = values.remove("REAdjustmentChangeDirection");
                if( (value == null) || (!value.equals(getREAdjustmentChangeDirection())) ) {
                    setREAdjustmentChangeDirection(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentFrequency") ) {
                final Object value = values.remove("REAdjustmentFrequency");
                if( (value == null) || (!value.equals(getREAdjustmentFrequency())) ) {
                    setREAdjustmentFrequency(((java.lang.String) value));
                }
            }
            if( values.containsKey("REFrequencyUnit") ) {
                final Object value = values.remove("REFrequencyUnit");
                if( (value == null) || (!value.equals(getREFrequencyUnit())) ) {
                    setREFrequencyUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("REIsIntervalFromFrqcyStart") ) {
                final Object value = values.remove("REIsIntervalFromFrqcyStart");
                if( (value == null) || (!value.equals(getREIsIntervalFromFrqcyStart())) ) {
                    setREIsIntervalFromFrqcyStart(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REIsSimulationRule") ) {
                final Object value = values.remove("REIsSimulationRule");
                if( (value == null) || (!value.equals(getREIsSimulationRule())) ) {
                    setREIsSimulationRule(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("RERuleHasNoDocument") ) {
                final Object value = values.remove("RERuleHasNoDocument");
                if( (value == null) || (!value.equals(getRERuleHasNoDocument())) ) {
                    setRERuleHasNoDocument(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REAdjustmentSubsqntCondition") ) {
                final Object value = values.remove("REAdjustmentSubsqntCondition");
                if( (value == null) || (!value.equals(getREAdjustmentSubsqntCondition())) ) {
                    setREAdjustmentSubsqntCondition(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentIsOnNextNotice") ) {
                final Object value = values.remove("REAdjustmentIsOnNextNotice");
                if( (value == null) || (!value.equals(getREAdjustmentIsOnNextNotice())) ) {
                    setREAdjustmentIsOnNextNotice(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REAdjustmentBase") ) {
                final Object value = values.remove("REAdjustmentBase");
                if( (value == null) || (!value.equals(getREAdjustmentBase())) ) {
                    setREAdjustmentBase(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentIsAutoDefault") ) {
                final Object value = values.remove("REAdjustmentIsAutoDefault");
                if( (value == null) || (!value.equals(getREAdjustmentIsAutoDefault())) ) {
                    setREAdjustmentIsAutoDefault(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REAdjustmentIsNotifRequired") ) {
                final Object value = values.remove("REAdjustmentIsNotifRequired");
                if( (value == null) || (!value.equals(getREAdjustmentIsNotifRequired())) ) {
                    setREAdjustmentIsNotifRequired(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REAdjustmentIsTimeDependent") ) {
                final Object value = values.remove("REAdjustmentIsTimeDependent");
                if( (value == null) || (!value.equals(getREAdjustmentIsTimeDependent())) ) {
                    setREAdjustmentIsTimeDependent(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentDueDateIsMandatory") ) {
                final Object value = values.remove("REAdjustmentDueDateIsMandatory");
                if( (value == null) || (!value.equals(getREAdjustmentDueDateIsMandatory())) ) {
                    setREAdjustmentDueDateIsMandatory(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REAdjustmentIsNotRetroActive") ) {
                final Object value = values.remove("REAdjustmentIsNotRetroActive");
                if( (value == null) || (!value.equals(getREAdjustmentIsNotRetroActive())) ) {
                    setREAdjustmentIsNotRetroActive(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentBlockReason") ) {
                final Object value = values.remove("REAdjustmentBlockReason");
                if( (value == null) || (!value.equals(getREAdjustmentBlockReason())) ) {
                    setREAdjustmentBlockReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("REConditionType") ) {
                final Object value = values.remove("REConditionType");
                if( (value == null) || (!value.equals(getREConditionType())) ) {
                    setREConditionType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RERuleSortOrder") ) {
                final Object value = values.remove("RERuleSortOrder");
                if( (value == null) || (!value.equals(getRERuleSortOrder())) ) {
                    setRERuleSortOrder(((java.lang.String) value));
                }
            }
            if( values.containsKey("RECurrencyTranslationRule") ) {
                final Object value = values.remove("RECurrencyTranslationRule");
                if( (value == null) || (!value.equals(getRECurrencyTranslationRule())) ) {
                    setRECurrencyTranslationRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentIndexSeries") ) {
                final Object value = values.remove("REAdjustmentIndexSeries");
                if( (value == null) || (!value.equals(getREAdjustmentIndexSeries())) ) {
                    setREAdjustmentIndexSeries(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentIndexBaseYear") ) {
                final Object value = values.remove("REAdjustmentIndexBaseYear");
                if( (value == null) || (!value.equals(getREAdjustmentIndexBaseYear())) ) {
                    setREAdjustmentIndexBaseYear(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentIdxIsAlwaysBaseYr") ) {
                final Object value = values.remove("REAdjustmentIdxIsAlwaysBaseYr");
                if( (value == null) || (!value.equals(getREAdjustmentIdxIsAlwaysBaseYr())) ) {
                    setREAdjustmentIdxIsAlwaysBaseYr(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REAdjustmentIdxMinChgPointsVal") ) {
                final Object value = values.remove("REAdjustmentIdxMinChgPointsVal");
                if( (value == null) || (!value.equals(getREAdjustmentIdxMinChgPointsVal())) ) {
                    setREAdjustmentIdxMinChgPointsVal(((BigDecimal) value));
                }
            }
            if( values.containsKey("REAdjustmentIdxMinChgPercent") ) {
                final Object value = values.remove("REAdjustmentIdxMinChgPercent");
                if( (value == null) || (!value.equals(getREAdjustmentIdxMinChgPercent())) ) {
                    setREAdjustmentIdxMinChgPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("REAdjustmentIsIdxChgPointsExcd") ) {
                final Object value = values.remove("REAdjustmentIsIdxChgPointsExcd");
                if( (value == null) || (!value.equals(getREAdjustmentIsIdxChgPointsExcd())) ) {
                    setREAdjustmentIsIdxChgPointsExcd(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REAdjustmentIsIdxChgPctExcd") ) {
                final Object value = values.remove("REAdjustmentIsIdxChgPctExcd");
                if( (value == null) || (!value.equals(getREAdjustmentIsIdxChgPctExcd())) ) {
                    setREAdjustmentIsIdxChgPctExcd(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REAdjustmentRhythmFlexible") ) {
                final Object value = values.remove("REAdjustmentRhythmFlexible");
                if( (value == null) || (!value.equals(getREAdjustmentRhythmFlexible())) ) {
                    setREAdjustmentRhythmFlexible(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentDelayInMonths") ) {
                final Object value = values.remove("REAdjustmentDelayInMonths");
                if( (value == null) || (!value.equals(getREAdjustmentDelayInMonths())) ) {
                    setREAdjustmentDelayInMonths(((BigDecimal) value));
                }
            }
            if( values.containsKey("REAdjustmentDelayUnit") ) {
                final Object value = values.remove("REAdjustmentDelayUnit");
                if( (value == null) || (!value.equals(getREAdjustmentDelayUnit())) ) {
                    setREAdjustmentDelayUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentIndexBasis") ) {
                final Object value = values.remove("REAdjustmentIndexBasis");
                if( (value == null) || (!value.equals(getREAdjustmentIndexBasis())) ) {
                    setREAdjustmentIndexBasis(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentIndexOrSpread") ) {
                final Object value = values.remove("REAdjustmentIndexOrSpread");
                if( (value == null) || (!value.equals(getREAdjustmentIndexOrSpread())) ) {
                    setREAdjustmentIndexOrSpread(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentIndexOrPerformance") ) {
                final Object value = values.remove("REAdjustmentIndexOrPerformance");
                if( (value == null) || (!value.equals(getREAdjustmentIndexOrPerformance())) ) {
                    setREAdjustmentIndexOrPerformance(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrAdjustmentTerm</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrAdjustmentTerm instances.
     * 
     */
    public final static class REContrAdjustmentTermBuilder
    {

        private REContract to_REContract;

        private REContrAdjustmentTerm.REContrAdjustmentTermBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrAdjustmentTerm</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrAdjustmentTerm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrAdjustmentTerm.REContrAdjustmentTermBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
