/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrConditionType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrCondition extends VdmEntity<REContrCondition> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrConditionType";
    /**
     * Selector for all available fields of REContrCondition.
     * 
     */
    public final static SimpleProperty<REContrCondition> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrCondition> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "InternalRealEstateNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectCalculation</b>
     * </p>
     * 
     * @return Object Number for Calculation
     */
    @Nullable
    @ElementName( "REStatusObjectCalculation" )
    private java.lang.String rEStatusObjectCalculation;
    public final static SimpleProperty.String<REContrCondition> RE_STATUS_OBJECT_CALCULATION =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REStatusObjectCalculation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REConditionType</b>
     * </p>
     * 
     * @return Condition Type
     */
    @Nullable
    @ElementName( "REConditionType" )
    private java.lang.String rEConditionType;
    public final static SimpleProperty.String<REContrCondition> RE_CONDITION_TYPE =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REConditionType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REExtConditionPurpose</b>
     * </p>
     * 
     * @return Conditions - External Purpose
     */
    @Nullable
    @ElementName( "REExtConditionPurpose" )
    private java.lang.String rEExtConditionPurpose;
    public final static SimpleProperty.String<REContrCondition> RE_EXT_CONDITION_PURPOSE =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REExtConditionPurpose");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @return Date from to (RAP Key)
     */
    @Nullable
    @ElementName( "ValidityStartEndDateValue" )
    private java.lang.String validityStartEndDateValue;
    public final static SimpleProperty.String<REContrCondition> VALIDITY_START_END_DATE_VALUE =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "ValidityStartEndDateValue");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<REContrCondition> VALIDITY_START_DATE =
        new SimpleProperty.Date<REContrCondition>(REContrCondition.class, "ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REExtConditionPurposeForEdit</b>
     * </p>
     * 
     * @return Conditions - External Purpose
     */
    @Nullable
    @ElementName( "REExtConditionPurposeForEdit" )
    private java.lang.String rEExtConditionPurposeForEdit;
    public final static SimpleProperty.String<REContrCondition> RE_EXT_CONDITION_PURPOSE_FOR_EDIT =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REExtConditionPurposeForEdit");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectDistribution</b>
     * </p>
     * 
     * @return Object Number for Distribution
     */
    @Nullable
    @ElementName( "REStatusObjectDistribution" )
    private java.lang.String rEStatusObjectDistribution;
    public final static SimpleProperty.String<REContrCondition> RE_STATUS_OBJECT_DISTRIBUTION =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REStatusObjectDistribution");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REObjectTypeDistribution</b>
     * </p>
     * 
     * @return Object Type for Distribution
     */
    @Nullable
    @ElementName( "REObjectTypeDistribution" )
    private java.lang.String rEObjectTypeDistribution;
    public final static SimpleProperty.String<REContrCondition> RE_OBJECT_TYPE_DISTRIBUTION =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REObjectTypeDistribution");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REObjectTypePosting</b>
     * </p>
     * 
     * @return Object Type for Posting
     */
    @Nullable
    @ElementName( "REObjectTypePosting" )
    private java.lang.String rEObjectTypePosting;
    public final static SimpleProperty.String<REContrCondition> RE_OBJECT_TYPE_POSTING =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REObjectTypePosting");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<REContrCondition> VALIDITY_END_DATE =
        new SimpleProperty.Date<REContrCondition>(REContrCondition.class, "ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Entered By
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<REContrCondition> CREATED_BY_USER =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 15
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @return The creationDateTime contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CreationDateTime" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal creationDateTime;
    public final static SimpleProperty.NumericDecimal<REContrCondition> CREATION_DATE_TIME =
        new SimpleProperty.NumericDecimal<REContrCondition>(REContrCondition.class, "CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RESourceOfCreation</b>
     * </p>
     * 
     * @return Source of Initial Entry
     */
    @Nullable
    @ElementName( "RESourceOfCreation" )
    private java.lang.String rESourceOfCreation;
    public final static SimpleProperty.String<REContrCondition> RE_SOURCE_OF_CREATION =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "RESourceOfCreation");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Employee ID
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<REContrCondition> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 15
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @return The lastChangeDateTime contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "LastChangeDateTime" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal lastChangeDateTime;
    public final static SimpleProperty.NumericDecimal<REContrCondition> LAST_CHANGE_DATE_TIME =
        new SimpleProperty.NumericDecimal<REContrCondition>(REContrCondition.class, "LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RESourceOfChange</b>
     * </p>
     * 
     * @return Editing Source
     */
    @Nullable
    @ElementName( "RESourceOfChange" )
    private java.lang.String rESourceOfChange;
    public final static SimpleProperty.String<REContrCondition> RE_SOURCE_OF_CHANGE =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "RESourceOfChange");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsOneTimeCondition</b>
     * </p>
     * 
     * @return Condition Is One-Time Condition
     */
    @Nullable
    @ElementName( "REIsOneTimeCondition" )
    private java.lang.Boolean rEIsOneTimeCondition;
    public final static SimpleProperty.Boolean<REContrCondition> RE_IS_ONE_TIME_CONDITION =
        new SimpleProperty.Boolean<REContrCondition>(REContrCondition.class, "REIsOneTimeCondition");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REConditionIsStatistical</b>
     * </p>
     * 
     * @return Statistical or Informational Condition
     */
    @Nullable
    @ElementName( "REConditionIsStatistical" )
    private java.lang.Boolean rEConditionIsStatistical;
    public final static SimpleProperty.Boolean<REContrCondition> RE_CONDITION_IS_STATISTICAL =
        new SimpleProperty.Boolean<REContrCondition>(REContrCondition.class, "REConditionIsStatistical");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REPostingTerm</b>
     * </p>
     * 
     * @return Number of Posting Term
     */
    @Nullable
    @ElementName( "REPostingTerm" )
    private java.lang.String rEPostingTerm;
    public final static SimpleProperty.String<REContrCondition> RE_POSTING_TERM =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REPostingTerm");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RERhythmTerm</b>
     * </p>
     * 
     * @return Number of Frequency Term
     */
    @Nullable
    @ElementName( "RERhythmTerm" )
    private java.lang.String rERhythmTerm;
    public final static SimpleProperty.String<REContrCondition> RE_RHYTHM_TERM =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "RERhythmTerm");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentNumber</b>
     * </p>
     * 
     * @return Number of Adjustment Term
     */
    @Nullable
    @ElementName( "REAdjustmentNumber" )
    private java.lang.String rEAdjustmentNumber;
    public final static SimpleProperty.String<REContrCondition> RE_ADJUSTMENT_NUMBER =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REAdjustmentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REOrgAssignmentTerm</b>
     * </p>
     * 
     * @return Number of Organizational Assignment Term
     */
    @Nullable
    @ElementName( "REOrgAssignmentTerm" )
    private java.lang.String rEOrgAssignmentTerm;
    public final static SimpleProperty.String<REContrCondition> RE_ORG_ASSIGNMENT_TERM =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REOrgAssignmentTerm");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RESalesTerm</b>
     * </p>
     * 
     * @return Number of Sales Term
     */
    @Nullable
    @ElementName( "RESalesTerm" )
    private java.lang.String rESalesTerm;
    public final static SimpleProperty.String<REContrCondition> RE_SALES_TERM =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "RESalesTerm");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REPeakSalesTerm</b>
     * </p>
     * 
     * @return Number of Peak Sales Term
     */
    @Nullable
    @ElementName( "REPeakSalesTerm" )
    private java.lang.String rEPeakSalesTerm;
    public final static SimpleProperty.String<REContrCondition> RE_PEAK_SALES_TERM =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REPeakSalesTerm");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RESrvcChrgSettlementPostingTrm</b>
     * </p>
     * 
     * @return Service Charge Settlement Posting Term
     */
    @Nullable
    @ElementName( "RESrvcChrgSettlementPostingTrm" )
    private java.lang.String rESrvcChrgSettlementPostingTrm;
    public final static SimpleProperty.String<REContrCondition> RE_SRVC_CHRG_SETTLEMENT_POSTING_TRM =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "RESrvcChrgSettlementPostingTrm");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REWithholdingTaxTerm</b>
     * </p>
     * 
     * @return Number of Withholding Tax Term
     */
    @Nullable
    @ElementName( "REWithholdingTaxTerm" )
    private java.lang.String rEWithholdingTaxTerm;
    public final static SimpleProperty.String<REContrCondition> RE_WITHHOLDING_TAX_TERM =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REWithholdingTaxTerm");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RECalculationRule</b>
     * </p>
     * 
     * @return Calculation Formula
     */
    @Nullable
    @ElementName( "RECalculationRule" )
    private java.lang.String rECalculationRule;
    public final static SimpleProperty.String<REContrCondition> RE_CALCULATION_RULE =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "RECalculationRule");
    /**
     * Constraints: Not nullable, Precision: 19, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>REUnitPrice</b>
     * </p>
     * 
     * @return Unit Price
     */
    @Nullable
    @ElementName( "REUnitPrice" )
    @DecimalDescriptor( precision = 19, scale = 6 )
    private BigDecimal rEUnitPrice;
    public final static SimpleProperty.NumericDecimal<REContrCondition> RE_UNIT_PRICE =
        new SimpleProperty.NumericDecimal<REContrCondition>(REContrCondition.class, "REUnitPrice");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>REConditionCurrency</b>
     * </p>
     * 
     * @return Currency of condition item
     */
    @Nullable
    @ElementName( "REConditionCurrency" )
    private java.lang.String rEConditionCurrency;
    public final static SimpleProperty.String<REContrCondition> RE_CONDITION_CURRENCY =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REConditionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>RECalculationRuleParam1</b>
     * </p>
     * 
     * @return Untypified Parameter for a Calculation Formula
     */
    @Nullable
    @ElementName( "RECalculationRuleParam1" )
    private java.lang.String rECalculationRuleParam1;
    public final static SimpleProperty.String<REContrCondition> RE_CALCULATION_RULE_PARAM1 =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "RECalculationRuleParam1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>RECalculationRuleParam2</b>
     * </p>
     * 
     * @return Untypified Parameter for a Calculation Formula
     */
    @Nullable
    @ElementName( "RECalculationRuleParam2" )
    private java.lang.String rECalculationRuleParam2;
    public final static SimpleProperty.String<REContrCondition> RE_CALCULATION_RULE_PARAM2 =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "RECalculationRuleParam2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REDistributionRule</b>
     * </p>
     * 
     * @return Distribution Formula
     */
    @Nullable
    @ElementName( "REDistributionRule" )
    private java.lang.String rEDistributionRule;
    public final static SimpleProperty.String<REContrCondition> RE_DISTRIBUTION_RULE =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REDistributionRule");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>REDistributionRuleParam1</b>
     * </p>
     * 
     * @return Untypified Parameter for a Distribution Formula
     */
    @Nullable
    @ElementName( "REDistributionRuleParam1" )
    private java.lang.String rEDistributionRuleParam1;
    public final static SimpleProperty.String<REContrCondition> RE_DISTRIBUTION_RULE_PARAM1 =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REDistributionRuleParam1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>REDistributionRuleParam2</b>
     * </p>
     * 
     * @return Untypified Parameter for a Distribution Formula
     */
    @Nullable
    @ElementName( "REDistributionRuleParam2" )
    private java.lang.String rEDistributionRuleParam2;
    public final static SimpleProperty.String<REContrCondition> RE_DISTRIBUTION_RULE_PARAM2 =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REDistributionRuleParam2");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REReasonForChange</b>
     * </p>
     * 
     * @return Reason for Change
     */
    @Nullable
    @ElementName( "REReasonForChange" )
    private java.lang.String rEReasonForChange;
    public final static SimpleProperty.String<REContrCondition> RE_REASON_FOR_CHANGE =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REReasonForChange");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStsObjectParamCalculation</b>
     * </p>
     * 
     * @return Object Number in Calculation/Distribution Parameter
     */
    @Nullable
    @ElementName( "REStsObjectParamCalculation" )
    private java.lang.String rEStsObjectParamCalculation;
    public final static SimpleProperty.String<REContrCondition> RE_STS_OBJECT_PARAM_CALCULATION =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REStsObjectParamCalculation");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStsObjectParamDistribution</b>
     * </p>
     * 
     * @return Object Number in Calculation/Distribution Parameter
     */
    @Nullable
    @ElementName( "REStsObjectParamDistribution" )
    private java.lang.String rEStsObjectParamDistribution;
    public final static SimpleProperty.String<REContrCondition> RE_STS_OBJECT_PARAM_DISTRIBUTION =
        new SimpleProperty.String<REContrCondition>(REContrCondition.class, "REStsObjectParamDistribution");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrCondition, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrCondition, SAP__Message>(
            REContrCondition.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrCondition</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrCondition, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrCondition, REContract>(
            REContrCondition.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrCondition> getType()
    {
        return REContrCondition.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectCalculation</b>
     * </p>
     * 
     * @param rEStatusObjectCalculation
     *            Object Number for Calculation
     */
    public void setREStatusObjectCalculation( @Nullable final java.lang.String rEStatusObjectCalculation )
    {
        rememberChangedField("REStatusObjectCalculation", this.rEStatusObjectCalculation);
        this.rEStatusObjectCalculation = rEStatusObjectCalculation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REConditionType</b>
     * </p>
     * 
     * @param rEConditionType
     *            Condition Type
     */
    public void setREConditionType( @Nullable final java.lang.String rEConditionType )
    {
        rememberChangedField("REConditionType", this.rEConditionType);
        this.rEConditionType = rEConditionType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REExtConditionPurpose</b>
     * </p>
     * 
     * @param rEExtConditionPurpose
     *            Conditions - External Purpose
     */
    public void setREExtConditionPurpose( @Nullable final java.lang.String rEExtConditionPurpose )
    {
        rememberChangedField("REExtConditionPurpose", this.rEExtConditionPurpose);
        this.rEExtConditionPurpose = rEExtConditionPurpose;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     */
    public void setValidityStartEndDateValue( @Nullable final java.lang.String validityStartEndDateValue )
    {
        rememberChangedField("ValidityStartEndDateValue", this.validityStartEndDateValue);
        this.validityStartEndDateValue = validityStartEndDateValue;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REExtConditionPurposeForEdit</b>
     * </p>
     * 
     * @param rEExtConditionPurposeForEdit
     *            Conditions - External Purpose
     */
    public void setREExtConditionPurposeForEdit( @Nullable final java.lang.String rEExtConditionPurposeForEdit )
    {
        rememberChangedField("REExtConditionPurposeForEdit", this.rEExtConditionPurposeForEdit);
        this.rEExtConditionPurposeForEdit = rEExtConditionPurposeForEdit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectDistribution</b>
     * </p>
     * 
     * @param rEStatusObjectDistribution
     *            Object Number for Distribution
     */
    public void setREStatusObjectDistribution( @Nullable final java.lang.String rEStatusObjectDistribution )
    {
        rememberChangedField("REStatusObjectDistribution", this.rEStatusObjectDistribution);
        this.rEStatusObjectDistribution = rEStatusObjectDistribution;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REObjectTypeDistribution</b>
     * </p>
     * 
     * @param rEObjectTypeDistribution
     *            Object Type for Distribution
     */
    public void setREObjectTypeDistribution( @Nullable final java.lang.String rEObjectTypeDistribution )
    {
        rememberChangedField("REObjectTypeDistribution", this.rEObjectTypeDistribution);
        this.rEObjectTypeDistribution = rEObjectTypeDistribution;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REObjectTypePosting</b>
     * </p>
     * 
     * @param rEObjectTypePosting
     *            Object Type for Posting
     */
    public void setREObjectTypePosting( @Nullable final java.lang.String rEObjectTypePosting )
    {
        rememberChangedField("REObjectTypePosting", this.rEObjectTypePosting);
        this.rEObjectTypePosting = rEObjectTypePosting;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Entered By
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 15
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @param creationDateTime
     *            The creationDateTime to set.
     */
    public void setCreationDateTime( @Nullable final BigDecimal creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RESourceOfCreation</b>
     * </p>
     * 
     * @param rESourceOfCreation
     *            Source of Initial Entry
     */
    public void setRESourceOfCreation( @Nullable final java.lang.String rESourceOfCreation )
    {
        rememberChangedField("RESourceOfCreation", this.rESourceOfCreation);
        this.rESourceOfCreation = rESourceOfCreation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Employee ID
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 15
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @param lastChangeDateTime
     *            The lastChangeDateTime to set.
     */
    public void setLastChangeDateTime( @Nullable final BigDecimal lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RESourceOfChange</b>
     * </p>
     * 
     * @param rESourceOfChange
     *            Editing Source
     */
    public void setRESourceOfChange( @Nullable final java.lang.String rESourceOfChange )
    {
        rememberChangedField("RESourceOfChange", this.rESourceOfChange);
        this.rESourceOfChange = rESourceOfChange;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsOneTimeCondition</b>
     * </p>
     * 
     * @param rEIsOneTimeCondition
     *            Condition Is One-Time Condition
     */
    public void setREIsOneTimeCondition( @Nullable final java.lang.Boolean rEIsOneTimeCondition )
    {
        rememberChangedField("REIsOneTimeCondition", this.rEIsOneTimeCondition);
        this.rEIsOneTimeCondition = rEIsOneTimeCondition;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REConditionIsStatistical</b>
     * </p>
     * 
     * @param rEConditionIsStatistical
     *            Statistical or Informational Condition
     */
    public void setREConditionIsStatistical( @Nullable final java.lang.Boolean rEConditionIsStatistical )
    {
        rememberChangedField("REConditionIsStatistical", this.rEConditionIsStatistical);
        this.rEConditionIsStatistical = rEConditionIsStatistical;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REPostingTerm</b>
     * </p>
     * 
     * @param rEPostingTerm
     *            Number of Posting Term
     */
    public void setREPostingTerm( @Nullable final java.lang.String rEPostingTerm )
    {
        rememberChangedField("REPostingTerm", this.rEPostingTerm);
        this.rEPostingTerm = rEPostingTerm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RERhythmTerm</b>
     * </p>
     * 
     * @param rERhythmTerm
     *            Number of Frequency Term
     */
    public void setRERhythmTerm( @Nullable final java.lang.String rERhythmTerm )
    {
        rememberChangedField("RERhythmTerm", this.rERhythmTerm);
        this.rERhythmTerm = rERhythmTerm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REAdjustmentNumber</b>
     * </p>
     * 
     * @param rEAdjustmentNumber
     *            Number of Adjustment Term
     */
    public void setREAdjustmentNumber( @Nullable final java.lang.String rEAdjustmentNumber )
    {
        rememberChangedField("REAdjustmentNumber", this.rEAdjustmentNumber);
        this.rEAdjustmentNumber = rEAdjustmentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REOrgAssignmentTerm</b>
     * </p>
     * 
     * @param rEOrgAssignmentTerm
     *            Number of Organizational Assignment Term
     */
    public void setREOrgAssignmentTerm( @Nullable final java.lang.String rEOrgAssignmentTerm )
    {
        rememberChangedField("REOrgAssignmentTerm", this.rEOrgAssignmentTerm);
        this.rEOrgAssignmentTerm = rEOrgAssignmentTerm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RESalesTerm</b>
     * </p>
     * 
     * @param rESalesTerm
     *            Number of Sales Term
     */
    public void setRESalesTerm( @Nullable final java.lang.String rESalesTerm )
    {
        rememberChangedField("RESalesTerm", this.rESalesTerm);
        this.rESalesTerm = rESalesTerm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REPeakSalesTerm</b>
     * </p>
     * 
     * @param rEPeakSalesTerm
     *            Number of Peak Sales Term
     */
    public void setREPeakSalesTerm( @Nullable final java.lang.String rEPeakSalesTerm )
    {
        rememberChangedField("REPeakSalesTerm", this.rEPeakSalesTerm);
        this.rEPeakSalesTerm = rEPeakSalesTerm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RESrvcChrgSettlementPostingTrm</b>
     * </p>
     * 
     * @param rESrvcChrgSettlementPostingTrm
     *            Service Charge Settlement Posting Term
     */
    public void setRESrvcChrgSettlementPostingTrm( @Nullable final java.lang.String rESrvcChrgSettlementPostingTrm )
    {
        rememberChangedField("RESrvcChrgSettlementPostingTrm", this.rESrvcChrgSettlementPostingTrm);
        this.rESrvcChrgSettlementPostingTrm = rESrvcChrgSettlementPostingTrm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REWithholdingTaxTerm</b>
     * </p>
     * 
     * @param rEWithholdingTaxTerm
     *            Number of Withholding Tax Term
     */
    public void setREWithholdingTaxTerm( @Nullable final java.lang.String rEWithholdingTaxTerm )
    {
        rememberChangedField("REWithholdingTaxTerm", this.rEWithholdingTaxTerm);
        this.rEWithholdingTaxTerm = rEWithholdingTaxTerm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RECalculationRule</b>
     * </p>
     * 
     * @param rECalculationRule
     *            Calculation Formula
     */
    public void setRECalculationRule( @Nullable final java.lang.String rECalculationRule )
    {
        rememberChangedField("RECalculationRule", this.rECalculationRule);
        this.rECalculationRule = rECalculationRule;
    }

    /**
     * Constraints: Not nullable, Precision: 19, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>REUnitPrice</b>
     * </p>
     * 
     * @param rEUnitPrice
     *            Unit Price
     */
    public void setREUnitPrice( @Nullable final BigDecimal rEUnitPrice )
    {
        rememberChangedField("REUnitPrice", this.rEUnitPrice);
        this.rEUnitPrice = rEUnitPrice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>REConditionCurrency</b>
     * </p>
     * 
     * @param rEConditionCurrency
     *            Currency of condition item
     */
    public void setREConditionCurrency( @Nullable final java.lang.String rEConditionCurrency )
    {
        rememberChangedField("REConditionCurrency", this.rEConditionCurrency);
        this.rEConditionCurrency = rEConditionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>RECalculationRuleParam1</b>
     * </p>
     * 
     * @param rECalculationRuleParam1
     *            Untypified Parameter for a Calculation Formula
     */
    public void setRECalculationRuleParam1( @Nullable final java.lang.String rECalculationRuleParam1 )
    {
        rememberChangedField("RECalculationRuleParam1", this.rECalculationRuleParam1);
        this.rECalculationRuleParam1 = rECalculationRuleParam1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>RECalculationRuleParam2</b>
     * </p>
     * 
     * @param rECalculationRuleParam2
     *            Untypified Parameter for a Calculation Formula
     */
    public void setRECalculationRuleParam2( @Nullable final java.lang.String rECalculationRuleParam2 )
    {
        rememberChangedField("RECalculationRuleParam2", this.rECalculationRuleParam2);
        this.rECalculationRuleParam2 = rECalculationRuleParam2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REDistributionRule</b>
     * </p>
     * 
     * @param rEDistributionRule
     *            Distribution Formula
     */
    public void setREDistributionRule( @Nullable final java.lang.String rEDistributionRule )
    {
        rememberChangedField("REDistributionRule", this.rEDistributionRule);
        this.rEDistributionRule = rEDistributionRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>REDistributionRuleParam1</b>
     * </p>
     * 
     * @param rEDistributionRuleParam1
     *            Untypified Parameter for a Distribution Formula
     */
    public void setREDistributionRuleParam1( @Nullable final java.lang.String rEDistributionRuleParam1 )
    {
        rememberChangedField("REDistributionRuleParam1", this.rEDistributionRuleParam1);
        this.rEDistributionRuleParam1 = rEDistributionRuleParam1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>REDistributionRuleParam2</b>
     * </p>
     * 
     * @param rEDistributionRuleParam2
     *            Untypified Parameter for a Distribution Formula
     */
    public void setREDistributionRuleParam2( @Nullable final java.lang.String rEDistributionRuleParam2 )
    {
        rememberChangedField("REDistributionRuleParam2", this.rEDistributionRuleParam2);
        this.rEDistributionRuleParam2 = rEDistributionRuleParam2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REReasonForChange</b>
     * </p>
     * 
     * @param rEReasonForChange
     *            Reason for Change
     */
    public void setREReasonForChange( @Nullable final java.lang.String rEReasonForChange )
    {
        rememberChangedField("REReasonForChange", this.rEReasonForChange);
        this.rEReasonForChange = rEReasonForChange;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStsObjectParamCalculation</b>
     * </p>
     * 
     * @param rEStsObjectParamCalculation
     *            Object Number in Calculation/Distribution Parameter
     */
    public void setREStsObjectParamCalculation( @Nullable final java.lang.String rEStsObjectParamCalculation )
    {
        rememberChangedField("REStsObjectParamCalculation", this.rEStsObjectParamCalculation);
        this.rEStsObjectParamCalculation = rEStsObjectParamCalculation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStsObjectParamDistribution</b>
     * </p>
     * 
     * @param rEStsObjectParamDistribution
     *            Object Number in Calculation/Distribution Parameter
     */
    public void setREStsObjectParamDistribution( @Nullable final java.lang.String rEStsObjectParamDistribution )
    {
        rememberChangedField("REStsObjectParamDistribution", this.rEStsObjectParamDistribution);
        this.rEStsObjectParamDistribution = rEStsObjectParamDistribution;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrCondition";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        entityKey.addKeyProperty("REStatusObjectCalculation", getREStatusObjectCalculation());
        entityKey.addKeyProperty("REConditionType", getREConditionType());
        entityKey.addKeyProperty("REExtConditionPurpose", getREExtConditionPurpose());
        entityKey.addKeyProperty("ValidityStartEndDateValue", getValidityStartEndDateValue());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("REStatusObjectCalculation", getREStatusObjectCalculation());
        values.put("REConditionType", getREConditionType());
        values.put("REExtConditionPurpose", getREExtConditionPurpose());
        values.put("ValidityStartEndDateValue", getValidityStartEndDateValue());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("REExtConditionPurposeForEdit", getREExtConditionPurposeForEdit());
        values.put("REStatusObjectDistribution", getREStatusObjectDistribution());
        values.put("REObjectTypeDistribution", getREObjectTypeDistribution());
        values.put("REObjectTypePosting", getREObjectTypePosting());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("RESourceOfCreation", getRESourceOfCreation());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("RESourceOfChange", getRESourceOfChange());
        values.put("REIsOneTimeCondition", getREIsOneTimeCondition());
        values.put("REConditionIsStatistical", getREConditionIsStatistical());
        values.put("REPostingTerm", getREPostingTerm());
        values.put("RERhythmTerm", getRERhythmTerm());
        values.put("REAdjustmentNumber", getREAdjustmentNumber());
        values.put("REOrgAssignmentTerm", getREOrgAssignmentTerm());
        values.put("RESalesTerm", getRESalesTerm());
        values.put("REPeakSalesTerm", getREPeakSalesTerm());
        values.put("RESrvcChrgSettlementPostingTrm", getRESrvcChrgSettlementPostingTrm());
        values.put("REWithholdingTaxTerm", getREWithholdingTaxTerm());
        values.put("RECalculationRule", getRECalculationRule());
        values.put("REUnitPrice", getREUnitPrice());
        values.put("REConditionCurrency", getREConditionCurrency());
        values.put("RECalculationRuleParam1", getRECalculationRuleParam1());
        values.put("RECalculationRuleParam2", getRECalculationRuleParam2());
        values.put("REDistributionRule", getREDistributionRule());
        values.put("REDistributionRuleParam1", getREDistributionRuleParam1());
        values.put("REDistributionRuleParam2", getREDistributionRuleParam2());
        values.put("REReasonForChange", getREReasonForChange());
        values.put("REStsObjectParamCalculation", getREStsObjectParamCalculation());
        values.put("REStsObjectParamDistribution", getREStsObjectParamDistribution());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("REStatusObjectCalculation") ) {
                final Object value = values.remove("REStatusObjectCalculation");
                if( (value == null) || (!value.equals(getREStatusObjectCalculation())) ) {
                    setREStatusObjectCalculation(((java.lang.String) value));
                }
            }
            if( values.containsKey("REConditionType") ) {
                final Object value = values.remove("REConditionType");
                if( (value == null) || (!value.equals(getREConditionType())) ) {
                    setREConditionType(((java.lang.String) value));
                }
            }
            if( values.containsKey("REExtConditionPurpose") ) {
                final Object value = values.remove("REExtConditionPurpose");
                if( (value == null) || (!value.equals(getREExtConditionPurpose())) ) {
                    setREExtConditionPurpose(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartEndDateValue") ) {
                final Object value = values.remove("ValidityStartEndDateValue");
                if( (value == null) || (!value.equals(getValidityStartEndDateValue())) ) {
                    setValidityStartEndDateValue(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REExtConditionPurposeForEdit") ) {
                final Object value = values.remove("REExtConditionPurposeForEdit");
                if( (value == null) || (!value.equals(getREExtConditionPurposeForEdit())) ) {
                    setREExtConditionPurposeForEdit(((java.lang.String) value));
                }
            }
            if( values.containsKey("REStatusObjectDistribution") ) {
                final Object value = values.remove("REStatusObjectDistribution");
                if( (value == null) || (!value.equals(getREStatusObjectDistribution())) ) {
                    setREStatusObjectDistribution(((java.lang.String) value));
                }
            }
            if( values.containsKey("REObjectTypeDistribution") ) {
                final Object value = values.remove("REObjectTypeDistribution");
                if( (value == null) || (!value.equals(getREObjectTypeDistribution())) ) {
                    setREObjectTypeDistribution(((java.lang.String) value));
                }
            }
            if( values.containsKey("REObjectTypePosting") ) {
                final Object value = values.remove("REObjectTypePosting");
                if( (value == null) || (!value.equals(getREObjectTypePosting())) ) {
                    setREObjectTypePosting(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("RESourceOfCreation") ) {
                final Object value = values.remove("RESourceOfCreation");
                if( (value == null) || (!value.equals(getRESourceOfCreation())) ) {
                    setRESourceOfCreation(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("RESourceOfChange") ) {
                final Object value = values.remove("RESourceOfChange");
                if( (value == null) || (!value.equals(getRESourceOfChange())) ) {
                    setRESourceOfChange(((java.lang.String) value));
                }
            }
            if( values.containsKey("REIsOneTimeCondition") ) {
                final Object value = values.remove("REIsOneTimeCondition");
                if( (value == null) || (!value.equals(getREIsOneTimeCondition())) ) {
                    setREIsOneTimeCondition(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REConditionIsStatistical") ) {
                final Object value = values.remove("REConditionIsStatistical");
                if( (value == null) || (!value.equals(getREConditionIsStatistical())) ) {
                    setREConditionIsStatistical(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REPostingTerm") ) {
                final Object value = values.remove("REPostingTerm");
                if( (value == null) || (!value.equals(getREPostingTerm())) ) {
                    setREPostingTerm(((java.lang.String) value));
                }
            }
            if( values.containsKey("RERhythmTerm") ) {
                final Object value = values.remove("RERhythmTerm");
                if( (value == null) || (!value.equals(getRERhythmTerm())) ) {
                    setRERhythmTerm(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAdjustmentNumber") ) {
                final Object value = values.remove("REAdjustmentNumber");
                if( (value == null) || (!value.equals(getREAdjustmentNumber())) ) {
                    setREAdjustmentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("REOrgAssignmentTerm") ) {
                final Object value = values.remove("REOrgAssignmentTerm");
                if( (value == null) || (!value.equals(getREOrgAssignmentTerm())) ) {
                    setREOrgAssignmentTerm(((java.lang.String) value));
                }
            }
            if( values.containsKey("RESalesTerm") ) {
                final Object value = values.remove("RESalesTerm");
                if( (value == null) || (!value.equals(getRESalesTerm())) ) {
                    setRESalesTerm(((java.lang.String) value));
                }
            }
            if( values.containsKey("REPeakSalesTerm") ) {
                final Object value = values.remove("REPeakSalesTerm");
                if( (value == null) || (!value.equals(getREPeakSalesTerm())) ) {
                    setREPeakSalesTerm(((java.lang.String) value));
                }
            }
            if( values.containsKey("RESrvcChrgSettlementPostingTrm") ) {
                final Object value = values.remove("RESrvcChrgSettlementPostingTrm");
                if( (value == null) || (!value.equals(getRESrvcChrgSettlementPostingTrm())) ) {
                    setRESrvcChrgSettlementPostingTrm(((java.lang.String) value));
                }
            }
            if( values.containsKey("REWithholdingTaxTerm") ) {
                final Object value = values.remove("REWithholdingTaxTerm");
                if( (value == null) || (!value.equals(getREWithholdingTaxTerm())) ) {
                    setREWithholdingTaxTerm(((java.lang.String) value));
                }
            }
            if( values.containsKey("RECalculationRule") ) {
                final Object value = values.remove("RECalculationRule");
                if( (value == null) || (!value.equals(getRECalculationRule())) ) {
                    setRECalculationRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("REUnitPrice") ) {
                final Object value = values.remove("REUnitPrice");
                if( (value == null) || (!value.equals(getREUnitPrice())) ) {
                    setREUnitPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("REConditionCurrency") ) {
                final Object value = values.remove("REConditionCurrency");
                if( (value == null) || (!value.equals(getREConditionCurrency())) ) {
                    setREConditionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("RECalculationRuleParam1") ) {
                final Object value = values.remove("RECalculationRuleParam1");
                if( (value == null) || (!value.equals(getRECalculationRuleParam1())) ) {
                    setRECalculationRuleParam1(((java.lang.String) value));
                }
            }
            if( values.containsKey("RECalculationRuleParam2") ) {
                final Object value = values.remove("RECalculationRuleParam2");
                if( (value == null) || (!value.equals(getRECalculationRuleParam2())) ) {
                    setRECalculationRuleParam2(((java.lang.String) value));
                }
            }
            if( values.containsKey("REDistributionRule") ) {
                final Object value = values.remove("REDistributionRule");
                if( (value == null) || (!value.equals(getREDistributionRule())) ) {
                    setREDistributionRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("REDistributionRuleParam1") ) {
                final Object value = values.remove("REDistributionRuleParam1");
                if( (value == null) || (!value.equals(getREDistributionRuleParam1())) ) {
                    setREDistributionRuleParam1(((java.lang.String) value));
                }
            }
            if( values.containsKey("REDistributionRuleParam2") ) {
                final Object value = values.remove("REDistributionRuleParam2");
                if( (value == null) || (!value.equals(getREDistributionRuleParam2())) ) {
                    setREDistributionRuleParam2(((java.lang.String) value));
                }
            }
            if( values.containsKey("REReasonForChange") ) {
                final Object value = values.remove("REReasonForChange");
                if( (value == null) || (!value.equals(getREReasonForChange())) ) {
                    setREReasonForChange(((java.lang.String) value));
                }
            }
            if( values.containsKey("REStsObjectParamCalculation") ) {
                final Object value = values.remove("REStsObjectParamCalculation");
                if( (value == null) || (!value.equals(getREStsObjectParamCalculation())) ) {
                    setREStsObjectParamCalculation(((java.lang.String) value));
                }
            }
            if( values.containsKey("REStsObjectParamDistribution") ) {
                final Object value = values.remove("REStsObjectParamDistribution");
                if( (value == null) || (!value.equals(getREStsObjectParamDistribution())) ) {
                    setREStsObjectParamDistribution(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrCondition</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrCondition instances.
     * 
     */
    public final static class REContrConditionBuilder
    {

        private REContract to_REContract;

        private REContrCondition.REContrConditionBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrCondition</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrCondition with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrCondition.REContrConditionBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
