/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Notice Terms
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrNoticeTermType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrNoticeTerm extends VdmEntity<REContrNoticeTerm> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrNoticeTermType";
    /**
     * Selector for all available fields of REContrNoticeTerm.
     * 
     */
    public final static SimpleProperty<REContrNoticeTerm> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrNoticeTerm> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "InternalRealEstateNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermType</b>
     * </p>
     * 
     * @return Term Category
     */
    @Nullable
    @ElementName( "RETermType" )
    private java.lang.String rETermType;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_TERM_TYPE =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RETermType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @return Term Number
     */
    @Nullable
    @ElementName( "RETermNumber" )
    private java.lang.String rETermNumber;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_TERM_NUMBER =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RETermNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeRule</b>
     * </p>
     * 
     * @return Notice rule
     */
    @Nullable
    @ElementName( "RENoticeRule" )
    private java.lang.String rENoticeRule;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_RULE =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeRule");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeSequenceNo</b>
     * </p>
     * 
     * @return Sequence Number for Description of Notice Rule
     */
    @Nullable
    @ElementName( "RENoticeSequenceNo" )
    private java.lang.String rENoticeSequenceNo;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_SEQUENCE_NO =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeSequenceNo");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @return Name of Term
     */
    @Nullable
    @ElementName( "RETermName" )
    private java.lang.String rETermName;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_TERM_NAME =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RETermName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeType</b>
     * </p>
     * 
     * @return Notice Type of RE Contract
     */
    @Nullable
    @ElementName( "RENoticeType" )
    private java.lang.String rENoticeType;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_TYPE =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeProcedure</b>
     * </p>
     * 
     * @return Notice Procedure
     */
    @Nullable
    @ElementName( "RENoticeProcedure" )
    private java.lang.String rENoticeProcedure;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_PROCEDURE =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeGivingParty</b>
     * </p>
     * 
     * @return Party Giving Notice in Notice Procedure
     */
    @Nullable
    @ElementName( "RENoticeGivingParty" )
    private java.lang.String rENoticeGivingParty;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_GIVING_PARTY =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeGivingParty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeRuleType</b>
     * </p>
     * 
     * @return Type of Notice Rule
     */
    @Nullable
    @ElementName( "RENoticeRuleType" )
    private java.lang.String rENoticeRuleType;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_RULE_TYPE =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeRuleType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeRuleDescription</b>
     * </p>
     * 
     * @return Name of Notice Rule
     */
    @Nullable
    @ElementName( "RENoticeRuleDescription" )
    private java.lang.String rENoticeRuleDescription;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_RULE_DESCRIPTION =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeRuleDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RETermPeriodInYears</b>
     * </p>
     * 
     * @return Term in Years
     */
    @Nullable
    @ElementName( "RETermPeriodInYears" )
    private java.lang.String rETermPeriodInYears;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_TERM_PERIOD_IN_YEARS =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RETermPeriodInYears");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RETermPeriodInMonths</b>
     * </p>
     * 
     * @return Term in Months
     */
    @Nullable
    @ElementName( "RETermPeriodInMonths" )
    private java.lang.String rETermPeriodInMonths;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_TERM_PERIOD_IN_MONTHS =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RETermPeriodInMonths");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RETermPeriodInDays</b>
     * </p>
     * 
     * @return Term in Days
     */
    @Nullable
    @ElementName( "RETermPeriodInDays" )
    private java.lang.String rETermPeriodInDays;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_TERM_PERIOD_IN_DAYS =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RETermPeriodInDays");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REPeriodEndRhythmType</b>
     * </p>
     * 
     * @return Type of Period End for Period Regulation
     */
    @Nullable
    @ElementName( "REPeriodEndRhythmType" )
    private java.lang.String rEPeriodEndRhythmType;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_PERIOD_END_RHYTHM_TYPE =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "REPeriodEndRhythmType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticePeriodInMonths</b>
     * </p>
     * 
     * @return Notice Period in Months
     */
    @Nullable
    @ElementName( "RENoticePeriodInMonths" )
    private java.lang.String rENoticePeriodInMonths;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_PERIOD_IN_MONTHS =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticePeriodInMonths");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticePeriodInWeeks</b>
     * </p>
     * 
     * @return Notice Period in Weeks
     */
    @Nullable
    @ElementName( "RENoticePeriodInWeeks" )
    private java.lang.String rENoticePeriodInWeeks;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_PERIOD_IN_WEEKS =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticePeriodInWeeks");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticePeriodInDays</b>
     * </p>
     * 
     * @return Notice Period in Days
     */
    @Nullable
    @ElementName( "RENoticePeriodInDays" )
    private java.lang.String rENoticePeriodInDays;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_PERIOD_IN_DAYS =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticePeriodInDays");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeGracePeriod</b>
     * </p>
     * 
     * @return Grace Days for Notice Period
     */
    @Nullable
    @ElementName( "RENoticeGracePeriod" )
    private java.lang.String rENoticeGracePeriod;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_GRACE_PERIOD =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeGracePeriod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REGracePeriodCalOrWorkDays</b>
     * </p>
     * 
     * @return Grace Days as Calendar or Business Days?
     */
    @Nullable
    @ElementName( "REGracePeriodCalOrWorkDays" )
    private java.lang.String rEGracePeriodCalOrWorkDays;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_GRACE_PERIOD_CAL_OR_WORK_DAYS =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "REGracePeriodCalOrWorkDays");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticePeriodCalendar</b>
     * </p>
     * 
     * @return Calendar for Calculation of Calendar or Business Days
     */
    @Nullable
    @ElementName( "RENoticePeriodCalendar" )
    private java.lang.String rENoticePeriodCalendar;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_PERIOD_CALENDAR =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticePeriodCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeYear</b>
     * </p>
     * 
     * @return Notice Year
     */
    @Nullable
    @ElementName( "RENoticeYear" )
    private java.lang.String rENoticeYear;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_YEAR =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeYear");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeMonth</b>
     * </p>
     * 
     * @return Notice Month
     */
    @Nullable
    @ElementName( "RENoticeMonth" )
    private java.lang.String rENoticeMonth;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_MONTH =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeMonth");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeDay</b>
     * </p>
     * 
     * @return Notice Day
     */
    @Nullable
    @ElementName( "RENoticeDay" )
    private java.lang.String rENoticeDay;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_DAY =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeDay");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeReceiptYear</b>
     * </p>
     * 
     * @return Receipt year
     */
    @Nullable
    @ElementName( "RENoticeReceiptYear" )
    private java.lang.String rENoticeReceiptYear;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_RECEIPT_YEAR =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeReceiptYear");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeReceiptMonth</b>
     * </p>
     * 
     * @return Received month
     */
    @Nullable
    @ElementName( "RENoticeReceiptMonth" )
    private java.lang.String rENoticeReceiptMonth;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_RECEIPT_MONTH =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeReceiptMonth");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeReceiptDay</b>
     * </p>
     * 
     * @return Received On
     */
    @Nullable
    @ElementName( "RENoticeReceiptDay" )
    private java.lang.String rENoticeReceiptDay;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_RECEIPT_DAY =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeReceiptDay");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeRcptCalOrWorkDays</b>
     * </p>
     * 
     * @return Grace Days as Calendar or Business Days?
     */
    @Nullable
    @ElementName( "RENoticeRcptCalOrWorkDays" )
    private java.lang.String rENoticeRcptCalOrWorkDays;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_RCPT_CAL_OR_WORK_DAYS =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeRcptCalOrWorkDays");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeReceiptCalendar</b>
     * </p>
     * 
     * @return Calendar for Calculation of Calendar or Business Days
     */
    @Nullable
    @ElementName( "RENoticeReceiptCalendar" )
    private java.lang.String rENoticeReceiptCalendar;
    public final static SimpleProperty.String<REContrNoticeTerm> RE_NOTICE_RECEIPT_CALENDAR =
        new SimpleProperty.String<REContrNoticeTerm>(REContrNoticeTerm.class, "RENoticeReceiptCalendar");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrNoticeTerm, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrNoticeTerm, SAP__Message>(
            REContrNoticeTerm.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrNoticeTerm</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrNoticeTerm, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrNoticeTerm, REContract>(
            REContrNoticeTerm.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrNoticeTerm> getType()
    {
        return REContrNoticeTerm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermType</b>
     * </p>
     * 
     * @param rETermType
     *            Term Category
     */
    public void setRETermType( @Nullable final java.lang.String rETermType )
    {
        rememberChangedField("RETermType", this.rETermType);
        this.rETermType = rETermType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @param rETermNumber
     *            Term Number
     */
    public void setRETermNumber( @Nullable final java.lang.String rETermNumber )
    {
        rememberChangedField("RETermNumber", this.rETermNumber);
        this.rETermNumber = rETermNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeRule</b>
     * </p>
     * 
     * @param rENoticeRule
     *            Notice rule
     */
    public void setRENoticeRule( @Nullable final java.lang.String rENoticeRule )
    {
        rememberChangedField("RENoticeRule", this.rENoticeRule);
        this.rENoticeRule = rENoticeRule;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeSequenceNo</b>
     * </p>
     * 
     * @param rENoticeSequenceNo
     *            Sequence Number for Description of Notice Rule
     */
    public void setRENoticeSequenceNo( @Nullable final java.lang.String rENoticeSequenceNo )
    {
        rememberChangedField("RENoticeSequenceNo", this.rENoticeSequenceNo);
        this.rENoticeSequenceNo = rENoticeSequenceNo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @param rETermName
     *            Name of Term
     */
    public void setRETermName( @Nullable final java.lang.String rETermName )
    {
        rememberChangedField("RETermName", this.rETermName);
        this.rETermName = rETermName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeType</b>
     * </p>
     * 
     * @param rENoticeType
     *            Notice Type of RE Contract
     */
    public void setRENoticeType( @Nullable final java.lang.String rENoticeType )
    {
        rememberChangedField("RENoticeType", this.rENoticeType);
        this.rENoticeType = rENoticeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeProcedure</b>
     * </p>
     * 
     * @param rENoticeProcedure
     *            Notice Procedure
     */
    public void setRENoticeProcedure( @Nullable final java.lang.String rENoticeProcedure )
    {
        rememberChangedField("RENoticeProcedure", this.rENoticeProcedure);
        this.rENoticeProcedure = rENoticeProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeGivingParty</b>
     * </p>
     * 
     * @param rENoticeGivingParty
     *            Party Giving Notice in Notice Procedure
     */
    public void setRENoticeGivingParty( @Nullable final java.lang.String rENoticeGivingParty )
    {
        rememberChangedField("RENoticeGivingParty", this.rENoticeGivingParty);
        this.rENoticeGivingParty = rENoticeGivingParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeRuleType</b>
     * </p>
     * 
     * @param rENoticeRuleType
     *            Type of Notice Rule
     */
    public void setRENoticeRuleType( @Nullable final java.lang.String rENoticeRuleType )
    {
        rememberChangedField("RENoticeRuleType", this.rENoticeRuleType);
        this.rENoticeRuleType = rENoticeRuleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeRuleDescription</b>
     * </p>
     * 
     * @param rENoticeRuleDescription
     *            Name of Notice Rule
     */
    public void setRENoticeRuleDescription( @Nullable final java.lang.String rENoticeRuleDescription )
    {
        rememberChangedField("RENoticeRuleDescription", this.rENoticeRuleDescription);
        this.rENoticeRuleDescription = rENoticeRuleDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RETermPeriodInYears</b>
     * </p>
     * 
     * @param rETermPeriodInYears
     *            Term in Years
     */
    public void setRETermPeriodInYears( @Nullable final java.lang.String rETermPeriodInYears )
    {
        rememberChangedField("RETermPeriodInYears", this.rETermPeriodInYears);
        this.rETermPeriodInYears = rETermPeriodInYears;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RETermPeriodInMonths</b>
     * </p>
     * 
     * @param rETermPeriodInMonths
     *            Term in Months
     */
    public void setRETermPeriodInMonths( @Nullable final java.lang.String rETermPeriodInMonths )
    {
        rememberChangedField("RETermPeriodInMonths", this.rETermPeriodInMonths);
        this.rETermPeriodInMonths = rETermPeriodInMonths;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RETermPeriodInDays</b>
     * </p>
     * 
     * @param rETermPeriodInDays
     *            Term in Days
     */
    public void setRETermPeriodInDays( @Nullable final java.lang.String rETermPeriodInDays )
    {
        rememberChangedField("RETermPeriodInDays", this.rETermPeriodInDays);
        this.rETermPeriodInDays = rETermPeriodInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REPeriodEndRhythmType</b>
     * </p>
     * 
     * @param rEPeriodEndRhythmType
     *            Type of Period End for Period Regulation
     */
    public void setREPeriodEndRhythmType( @Nullable final java.lang.String rEPeriodEndRhythmType )
    {
        rememberChangedField("REPeriodEndRhythmType", this.rEPeriodEndRhythmType);
        this.rEPeriodEndRhythmType = rEPeriodEndRhythmType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticePeriodInMonths</b>
     * </p>
     * 
     * @param rENoticePeriodInMonths
     *            Notice Period in Months
     */
    public void setRENoticePeriodInMonths( @Nullable final java.lang.String rENoticePeriodInMonths )
    {
        rememberChangedField("RENoticePeriodInMonths", this.rENoticePeriodInMonths);
        this.rENoticePeriodInMonths = rENoticePeriodInMonths;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticePeriodInWeeks</b>
     * </p>
     * 
     * @param rENoticePeriodInWeeks
     *            Notice Period in Weeks
     */
    public void setRENoticePeriodInWeeks( @Nullable final java.lang.String rENoticePeriodInWeeks )
    {
        rememberChangedField("RENoticePeriodInWeeks", this.rENoticePeriodInWeeks);
        this.rENoticePeriodInWeeks = rENoticePeriodInWeeks;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticePeriodInDays</b>
     * </p>
     * 
     * @param rENoticePeriodInDays
     *            Notice Period in Days
     */
    public void setRENoticePeriodInDays( @Nullable final java.lang.String rENoticePeriodInDays )
    {
        rememberChangedField("RENoticePeriodInDays", this.rENoticePeriodInDays);
        this.rENoticePeriodInDays = rENoticePeriodInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeGracePeriod</b>
     * </p>
     * 
     * @param rENoticeGracePeriod
     *            Grace Days for Notice Period
     */
    public void setRENoticeGracePeriod( @Nullable final java.lang.String rENoticeGracePeriod )
    {
        rememberChangedField("RENoticeGracePeriod", this.rENoticeGracePeriod);
        this.rENoticeGracePeriod = rENoticeGracePeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REGracePeriodCalOrWorkDays</b>
     * </p>
     * 
     * @param rEGracePeriodCalOrWorkDays
     *            Grace Days as Calendar or Business Days?
     */
    public void setREGracePeriodCalOrWorkDays( @Nullable final java.lang.String rEGracePeriodCalOrWorkDays )
    {
        rememberChangedField("REGracePeriodCalOrWorkDays", this.rEGracePeriodCalOrWorkDays);
        this.rEGracePeriodCalOrWorkDays = rEGracePeriodCalOrWorkDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticePeriodCalendar</b>
     * </p>
     * 
     * @param rENoticePeriodCalendar
     *            Calendar for Calculation of Calendar or Business Days
     */
    public void setRENoticePeriodCalendar( @Nullable final java.lang.String rENoticePeriodCalendar )
    {
        rememberChangedField("RENoticePeriodCalendar", this.rENoticePeriodCalendar);
        this.rENoticePeriodCalendar = rENoticePeriodCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeYear</b>
     * </p>
     * 
     * @param rENoticeYear
     *            Notice Year
     */
    public void setRENoticeYear( @Nullable final java.lang.String rENoticeYear )
    {
        rememberChangedField("RENoticeYear", this.rENoticeYear);
        this.rENoticeYear = rENoticeYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeMonth</b>
     * </p>
     * 
     * @param rENoticeMonth
     *            Notice Month
     */
    public void setRENoticeMonth( @Nullable final java.lang.String rENoticeMonth )
    {
        rememberChangedField("RENoticeMonth", this.rENoticeMonth);
        this.rENoticeMonth = rENoticeMonth;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeDay</b>
     * </p>
     * 
     * @param rENoticeDay
     *            Notice Day
     */
    public void setRENoticeDay( @Nullable final java.lang.String rENoticeDay )
    {
        rememberChangedField("RENoticeDay", this.rENoticeDay);
        this.rENoticeDay = rENoticeDay;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeReceiptYear</b>
     * </p>
     * 
     * @param rENoticeReceiptYear
     *            Receipt year
     */
    public void setRENoticeReceiptYear( @Nullable final java.lang.String rENoticeReceiptYear )
    {
        rememberChangedField("RENoticeReceiptYear", this.rENoticeReceiptYear);
        this.rENoticeReceiptYear = rENoticeReceiptYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeReceiptMonth</b>
     * </p>
     * 
     * @param rENoticeReceiptMonth
     *            Received month
     */
    public void setRENoticeReceiptMonth( @Nullable final java.lang.String rENoticeReceiptMonth )
    {
        rememberChangedField("RENoticeReceiptMonth", this.rENoticeReceiptMonth);
        this.rENoticeReceiptMonth = rENoticeReceiptMonth;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeReceiptDay</b>
     * </p>
     * 
     * @param rENoticeReceiptDay
     *            Received On
     */
    public void setRENoticeReceiptDay( @Nullable final java.lang.String rENoticeReceiptDay )
    {
        rememberChangedField("RENoticeReceiptDay", this.rENoticeReceiptDay);
        this.rENoticeReceiptDay = rENoticeReceiptDay;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeRcptCalOrWorkDays</b>
     * </p>
     * 
     * @param rENoticeRcptCalOrWorkDays
     *            Grace Days as Calendar or Business Days?
     */
    public void setRENoticeRcptCalOrWorkDays( @Nullable final java.lang.String rENoticeRcptCalOrWorkDays )
    {
        rememberChangedField("RENoticeRcptCalOrWorkDays", this.rENoticeRcptCalOrWorkDays);
        this.rENoticeRcptCalOrWorkDays = rENoticeRcptCalOrWorkDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENoticeReceiptCalendar</b>
     * </p>
     * 
     * @param rENoticeReceiptCalendar
     *            Calendar for Calculation of Calendar or Business Days
     */
    public void setRENoticeReceiptCalendar( @Nullable final java.lang.String rENoticeReceiptCalendar )
    {
        rememberChangedField("RENoticeReceiptCalendar", this.rENoticeReceiptCalendar);
        this.rENoticeReceiptCalendar = rENoticeReceiptCalendar;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrNoticeTerm";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        entityKey.addKeyProperty("RETermType", getRETermType());
        entityKey.addKeyProperty("RETermNumber", getRETermNumber());
        entityKey.addKeyProperty("RENoticeRule", getRENoticeRule());
        entityKey.addKeyProperty("RENoticeSequenceNo", getRENoticeSequenceNo());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("RETermType", getRETermType());
        values.put("RETermNumber", getRETermNumber());
        values.put("RENoticeRule", getRENoticeRule());
        values.put("RENoticeSequenceNo", getRENoticeSequenceNo());
        values.put("RETermName", getRETermName());
        values.put("RENoticeType", getRENoticeType());
        values.put("RENoticeProcedure", getRENoticeProcedure());
        values.put("RENoticeGivingParty", getRENoticeGivingParty());
        values.put("RENoticeRuleType", getRENoticeRuleType());
        values.put("RENoticeRuleDescription", getRENoticeRuleDescription());
        values.put("RETermPeriodInYears", getRETermPeriodInYears());
        values.put("RETermPeriodInMonths", getRETermPeriodInMonths());
        values.put("RETermPeriodInDays", getRETermPeriodInDays());
        values.put("REPeriodEndRhythmType", getREPeriodEndRhythmType());
        values.put("RENoticePeriodInMonths", getRENoticePeriodInMonths());
        values.put("RENoticePeriodInWeeks", getRENoticePeriodInWeeks());
        values.put("RENoticePeriodInDays", getRENoticePeriodInDays());
        values.put("RENoticeGracePeriod", getRENoticeGracePeriod());
        values.put("REGracePeriodCalOrWorkDays", getREGracePeriodCalOrWorkDays());
        values.put("RENoticePeriodCalendar", getRENoticePeriodCalendar());
        values.put("RENoticeYear", getRENoticeYear());
        values.put("RENoticeMonth", getRENoticeMonth());
        values.put("RENoticeDay", getRENoticeDay());
        values.put("RENoticeReceiptYear", getRENoticeReceiptYear());
        values.put("RENoticeReceiptMonth", getRENoticeReceiptMonth());
        values.put("RENoticeReceiptDay", getRENoticeReceiptDay());
        values.put("RENoticeRcptCalOrWorkDays", getRENoticeRcptCalOrWorkDays());
        values.put("RENoticeReceiptCalendar", getRENoticeReceiptCalendar());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermType") ) {
                final Object value = values.remove("RETermType");
                if( (value == null) || (!value.equals(getRETermType())) ) {
                    setRETermType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermNumber") ) {
                final Object value = values.remove("RETermNumber");
                if( (value == null) || (!value.equals(getRETermNumber())) ) {
                    setRETermNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeRule") ) {
                final Object value = values.remove("RENoticeRule");
                if( (value == null) || (!value.equals(getRENoticeRule())) ) {
                    setRENoticeRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeSequenceNo") ) {
                final Object value = values.remove("RENoticeSequenceNo");
                if( (value == null) || (!value.equals(getRENoticeSequenceNo())) ) {
                    setRENoticeSequenceNo(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermName") ) {
                final Object value = values.remove("RETermName");
                if( (value == null) || (!value.equals(getRETermName())) ) {
                    setRETermName(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeType") ) {
                final Object value = values.remove("RENoticeType");
                if( (value == null) || (!value.equals(getRENoticeType())) ) {
                    setRENoticeType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeProcedure") ) {
                final Object value = values.remove("RENoticeProcedure");
                if( (value == null) || (!value.equals(getRENoticeProcedure())) ) {
                    setRENoticeProcedure(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeGivingParty") ) {
                final Object value = values.remove("RENoticeGivingParty");
                if( (value == null) || (!value.equals(getRENoticeGivingParty())) ) {
                    setRENoticeGivingParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeRuleType") ) {
                final Object value = values.remove("RENoticeRuleType");
                if( (value == null) || (!value.equals(getRENoticeRuleType())) ) {
                    setRENoticeRuleType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeRuleDescription") ) {
                final Object value = values.remove("RENoticeRuleDescription");
                if( (value == null) || (!value.equals(getRENoticeRuleDescription())) ) {
                    setRENoticeRuleDescription(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermPeriodInYears") ) {
                final Object value = values.remove("RETermPeriodInYears");
                if( (value == null) || (!value.equals(getRETermPeriodInYears())) ) {
                    setRETermPeriodInYears(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermPeriodInMonths") ) {
                final Object value = values.remove("RETermPeriodInMonths");
                if( (value == null) || (!value.equals(getRETermPeriodInMonths())) ) {
                    setRETermPeriodInMonths(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermPeriodInDays") ) {
                final Object value = values.remove("RETermPeriodInDays");
                if( (value == null) || (!value.equals(getRETermPeriodInDays())) ) {
                    setRETermPeriodInDays(((java.lang.String) value));
                }
            }
            if( values.containsKey("REPeriodEndRhythmType") ) {
                final Object value = values.remove("REPeriodEndRhythmType");
                if( (value == null) || (!value.equals(getREPeriodEndRhythmType())) ) {
                    setREPeriodEndRhythmType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticePeriodInMonths") ) {
                final Object value = values.remove("RENoticePeriodInMonths");
                if( (value == null) || (!value.equals(getRENoticePeriodInMonths())) ) {
                    setRENoticePeriodInMonths(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticePeriodInWeeks") ) {
                final Object value = values.remove("RENoticePeriodInWeeks");
                if( (value == null) || (!value.equals(getRENoticePeriodInWeeks())) ) {
                    setRENoticePeriodInWeeks(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticePeriodInDays") ) {
                final Object value = values.remove("RENoticePeriodInDays");
                if( (value == null) || (!value.equals(getRENoticePeriodInDays())) ) {
                    setRENoticePeriodInDays(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeGracePeriod") ) {
                final Object value = values.remove("RENoticeGracePeriod");
                if( (value == null) || (!value.equals(getRENoticeGracePeriod())) ) {
                    setRENoticeGracePeriod(((java.lang.String) value));
                }
            }
            if( values.containsKey("REGracePeriodCalOrWorkDays") ) {
                final Object value = values.remove("REGracePeriodCalOrWorkDays");
                if( (value == null) || (!value.equals(getREGracePeriodCalOrWorkDays())) ) {
                    setREGracePeriodCalOrWorkDays(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticePeriodCalendar") ) {
                final Object value = values.remove("RENoticePeriodCalendar");
                if( (value == null) || (!value.equals(getRENoticePeriodCalendar())) ) {
                    setRENoticePeriodCalendar(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeYear") ) {
                final Object value = values.remove("RENoticeYear");
                if( (value == null) || (!value.equals(getRENoticeYear())) ) {
                    setRENoticeYear(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeMonth") ) {
                final Object value = values.remove("RENoticeMonth");
                if( (value == null) || (!value.equals(getRENoticeMonth())) ) {
                    setRENoticeMonth(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeDay") ) {
                final Object value = values.remove("RENoticeDay");
                if( (value == null) || (!value.equals(getRENoticeDay())) ) {
                    setRENoticeDay(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeReceiptYear") ) {
                final Object value = values.remove("RENoticeReceiptYear");
                if( (value == null) || (!value.equals(getRENoticeReceiptYear())) ) {
                    setRENoticeReceiptYear(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeReceiptMonth") ) {
                final Object value = values.remove("RENoticeReceiptMonth");
                if( (value == null) || (!value.equals(getRENoticeReceiptMonth())) ) {
                    setRENoticeReceiptMonth(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeReceiptDay") ) {
                final Object value = values.remove("RENoticeReceiptDay");
                if( (value == null) || (!value.equals(getRENoticeReceiptDay())) ) {
                    setRENoticeReceiptDay(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeRcptCalOrWorkDays") ) {
                final Object value = values.remove("RENoticeRcptCalOrWorkDays");
                if( (value == null) || (!value.equals(getRENoticeRcptCalOrWorkDays())) ) {
                    setRENoticeRcptCalOrWorkDays(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoticeReceiptCalendar") ) {
                final Object value = values.remove("RENoticeReceiptCalendar");
                if( (value == null) || (!value.equals(getRENoticeReceiptCalendar())) ) {
                    setRENoticeReceiptCalendar(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrNoticeTerm</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrNoticeTerm instances.
     * 
     */
    public final static class REContrNoticeTermBuilder
    {

        private REContract to_REContract;

        private REContrNoticeTerm.REContrNoticeTermBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrNoticeTerm</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrNoticeTerm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrNoticeTerm.REContrNoticeTermBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
