/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrObjAssgmtType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrObjAssgmt extends VdmEntity<REContrObjAssgmt> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrObjAssgmtType";
    /**
     * Selector for all available fields of REContrObjAssgmt.
     * 
     */
    public final static SimpleProperty<REContrObjAssgmt> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectSource</b>
     * </p>
     * 
     * @return Object Number
     */
    @Nullable
    @ElementName( "REStatusObjectSource" )
    private java.lang.String rEStatusObjectSource;
    public final static SimpleProperty.String<REContrObjAssgmt> RE_STATUS_OBJECT_SOURCE =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "REStatusObjectSource");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REObjectAssignmentType</b>
     * </p>
     * 
     * @return Type of Object Assignment
     */
    @Nullable
    @ElementName( "REObjectAssignmentType" )
    private java.lang.String rEObjectAssignmentType;
    public final static SimpleProperty.String<REContrObjAssgmt> RE_OBJECT_ASSIGNMENT_TYPE =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "REObjectAssignmentType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectTarget</b>
     * </p>
     * 
     * @return Object Number
     */
    @Nullable
    @ElementName( "REStatusObjectTarget" )
    private java.lang.String rEStatusObjectTarget;
    public final static SimpleProperty.String<REContrObjAssgmt> RE_STATUS_OBJECT_TARGET =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "REStatusObjectTarget");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @return Date from to (RAP Key)
     */
    @Nullable
    @ElementName( "ValidityStartEndDateValue" )
    private java.lang.String validityStartEndDateValue;
    public final static SimpleProperty.String<REContrObjAssgmt> VALIDITY_START_END_DATE_VALUE =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "ValidityStartEndDateValue");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrObjAssgmt> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "InternalRealEstateNumber");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<REContrObjAssgmt> VALIDITY_START_DATE =
        new SimpleProperty.Date<REContrObjAssgmt>(REContrObjAssgmt.class, "ValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<REContrObjAssgmt> VALIDITY_END_DATE =
        new SimpleProperty.Date<REContrObjAssgmt>(REContrObjAssgmt.class, "ValidityEndDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REOnlyInfoAssgmt</b>
     * </p>
     * 
     * @return Informational Assignment
     */
    @Nullable
    @ElementName( "REOnlyInfoAssgmt" )
    private java.lang.Boolean rEOnlyInfoAssgmt;
    public final static SimpleProperty.Boolean<REContrObjAssgmt> RE_ONLY_INFO_ASSGMT =
        new SimpleProperty.Boolean<REContrObjAssgmt>(REContrObjAssgmt.class, "REOnlyInfoAssgmt");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectSourceIsArchived</b>
     * </p>
     * 
     * @return Source Object Was Archived
     */
    @Nullable
    @ElementName( "REStatusObjectSourceIsArchived" )
    private java.lang.Boolean rEStatusObjectSourceIsArchived;
    public final static SimpleProperty.Boolean<REContrObjAssgmt> RE_STATUS_OBJECT_SOURCE_IS_ARCHIVED =
        new SimpleProperty.Boolean<REContrObjAssgmt>(REContrObjAssgmt.class, "REStatusObjectSourceIsArchived");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REGenerationType</b>
     * </p>
     * 
     * @return Generation Type Functional Location
     */
    @Nullable
    @ElementName( "REGenerationType" )
    private java.lang.String rEGenerationType;
    public final static SimpleProperty.String<REContrObjAssgmt> RE_GENERATION_TYPE =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "REGenerationType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsMainAsset</b>
     * </p>
     * 
     * @return Asset Is Leading Asset
     */
    @Nullable
    @ElementName( "REIsMainAsset" )
    private java.lang.Boolean rEIsMainAsset;
    public final static SimpleProperty.Boolean<REContrObjAssgmt> RE_IS_MAIN_ASSET =
        new SimpleProperty.Boolean<REContrObjAssgmt>(REContrObjAssgmt.class, "REIsMainAsset");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAssignmentHasMultiple</b>
     * </p>
     * 
     * @return Generated Entry for Multiple Assignment
     */
    @Nullable
    @ElementName( "REAssignmentHasMultiple" )
    private java.lang.Boolean rEAssignmentHasMultiple;
    public final static SimpleProperty.Boolean<REContrObjAssgmt> RE_ASSIGNMENT_HAS_MULTIPLE =
        new SimpleProperty.Boolean<REContrObjAssgmt>(REContrObjAssgmt.class, "REAssignmentHasMultiple");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REObjectPossessionStartDate</b>
     * </p>
     * 
     * @return Date From Which the Object Is Made Available for Use
     */
    @Nullable
    @ElementName( "REObjectPossessionStartDate" )
    private LocalDate rEObjectPossessionStartDate;
    public final static SimpleProperty.Date<REContrObjAssgmt> RE_OBJECT_POSSESSION_START_DATE =
        new SimpleProperty.Date<REContrObjAssgmt>(REContrObjAssgmt.class, "REObjectPossessionStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REObjectPossessionEndDate</b>
     * </p>
     * 
     * @return Date Up to Which the Object Is Used
     */
    @Nullable
    @ElementName( "REObjectPossessionEndDate" )
    private LocalDate rEObjectPossessionEndDate;
    public final static SimpleProperty.Date<REContrObjAssgmt> RE_OBJECT_POSSESSION_END_DATE =
        new SimpleProperty.Date<REContrObjAssgmt>(REContrObjAssgmt.class, "REObjectPossessionEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REGroupNumber</b>
     * </p>
     * 
     * @return Group Number
     */
    @Nullable
    @ElementName( "REGroupNumber" )
    private java.lang.String rEGroupNumber;
    public final static SimpleProperty.String<REContrObjAssgmt> RE_GROUP_NUMBER =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "REGroupNumber");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>REObjectGroupName</b>
     * </p>
     * 
     * @return Name of Object Groups
     */
    @Nullable
    @ElementName( "REObjectGroupName" )
    private java.lang.String rEObjectGroupName;
    public final static SimpleProperty.String<REContrObjAssgmt> RE_OBJECT_GROUP_NAME =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "REObjectGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REContractSubjectNumber</b>
     * </p>
     * 
     * @return Group Number
     */
    @Nullable
    @ElementName( "REContractSubjectNumber" )
    private java.lang.String rEContractSubjectNumber;
    public final static SimpleProperty.String<REContrObjAssgmt> RE_CONTRACT_SUBJECT_NUMBER =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "REContractSubjectNumber");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>REContractSubjectDescription</b>
     * </p>
     * 
     * @return Name for Contract Item
     */
    @Nullable
    @ElementName( "REContractSubjectDescription" )
    private java.lang.String rEContractSubjectDescription;
    public final static SimpleProperty.String<REContrObjAssgmt> RE_CONTRACT_SUBJECT_DESCRIPTION =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "REContractSubjectDescription");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REContractSubjectClass</b>
     * </p>
     * 
     * @return Contract Object Class
     */
    @Nullable
    @ElementName( "REContractSubjectClass" )
    private java.lang.String rEContractSubjectClass;
    public final static SimpleProperty.String<REContrObjAssgmt> RE_CONTRACT_SUBJECT_CLASS =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "REContractSubjectClass");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>REContractSubjectType</b>
     * </p>
     * 
     * @return Type of Contract Object
     */
    @Nullable
    @ElementName( "REContractSubjectType" )
    private java.lang.String rEContractSubjectType;
    public final static SimpleProperty.String<REContrObjAssgmt> RE_CONTRACT_SUBJECT_TYPE =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "REContractSubjectType");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>ExternalId</b>
     * </p>
     * 
     * @return External Identification for Contract Object
     */
    @Nullable
    @ElementName( "ExternalId" )
    private java.lang.String externalId;
    public final static SimpleProperty.String<REContrObjAssgmt> EXTERNAL_ID =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "ExternalId");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REAccountingObject</b>
     * </p>
     * 
     * @return Object Number Account Assignment
     */
    @Nullable
    @ElementName( "REAccountingObject" )
    private java.lang.String rEAccountingObject;
    public final static SimpleProperty.String<REContrObjAssgmt> RE_ACCOUNTING_OBJECT =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "REAccountingObject");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REAccountingObjectType</b>
     * </p>
     * 
     * @return Object Type
     */
    @Nullable
    @ElementName( "REAccountingObjectType" )
    private java.lang.String rEAccountingObjectType;
    public final static SimpleProperty.String<REContrObjAssgmt> RE_ACCOUNTING_OBJECT_TYPE =
        new SimpleProperty.String<REContrObjAssgmt>(REContrObjAssgmt.class, "REAccountingObjectType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrObjAssgmt, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrObjAssgmt, SAP__Message>(
            REContrObjAssgmt.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrObjAssgmt</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrObjAssgmt, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrObjAssgmt, REContract>(
            REContrObjAssgmt.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrObjAssgmt> getType()
    {
        return REContrObjAssgmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectSource</b>
     * </p>
     * 
     * @param rEStatusObjectSource
     *            Object Number
     */
    public void setREStatusObjectSource( @Nullable final java.lang.String rEStatusObjectSource )
    {
        rememberChangedField("REStatusObjectSource", this.rEStatusObjectSource);
        this.rEStatusObjectSource = rEStatusObjectSource;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REObjectAssignmentType</b>
     * </p>
     * 
     * @param rEObjectAssignmentType
     *            Type of Object Assignment
     */
    public void setREObjectAssignmentType( @Nullable final java.lang.String rEObjectAssignmentType )
    {
        rememberChangedField("REObjectAssignmentType", this.rEObjectAssignmentType);
        this.rEObjectAssignmentType = rEObjectAssignmentType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectTarget</b>
     * </p>
     * 
     * @param rEStatusObjectTarget
     *            Object Number
     */
    public void setREStatusObjectTarget( @Nullable final java.lang.String rEStatusObjectTarget )
    {
        rememberChangedField("REStatusObjectTarget", this.rEStatusObjectTarget);
        this.rEStatusObjectTarget = rEStatusObjectTarget;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     */
    public void setValidityStartEndDateValue( @Nullable final java.lang.String validityStartEndDateValue )
    {
        rememberChangedField("ValidityStartEndDateValue", this.validityStartEndDateValue);
        this.validityStartEndDateValue = validityStartEndDateValue;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REOnlyInfoAssgmt</b>
     * </p>
     * 
     * @param rEOnlyInfoAssgmt
     *            Informational Assignment
     */
    public void setREOnlyInfoAssgmt( @Nullable final java.lang.Boolean rEOnlyInfoAssgmt )
    {
        rememberChangedField("REOnlyInfoAssgmt", this.rEOnlyInfoAssgmt);
        this.rEOnlyInfoAssgmt = rEOnlyInfoAssgmt;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectSourceIsArchived</b>
     * </p>
     * 
     * @param rEStatusObjectSourceIsArchived
     *            Source Object Was Archived
     */
    public void setREStatusObjectSourceIsArchived( @Nullable final java.lang.Boolean rEStatusObjectSourceIsArchived )
    {
        rememberChangedField("REStatusObjectSourceIsArchived", this.rEStatusObjectSourceIsArchived);
        this.rEStatusObjectSourceIsArchived = rEStatusObjectSourceIsArchived;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REGenerationType</b>
     * </p>
     * 
     * @param rEGenerationType
     *            Generation Type Functional Location
     */
    public void setREGenerationType( @Nullable final java.lang.String rEGenerationType )
    {
        rememberChangedField("REGenerationType", this.rEGenerationType);
        this.rEGenerationType = rEGenerationType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsMainAsset</b>
     * </p>
     * 
     * @param rEIsMainAsset
     *            Asset Is Leading Asset
     */
    public void setREIsMainAsset( @Nullable final java.lang.Boolean rEIsMainAsset )
    {
        rememberChangedField("REIsMainAsset", this.rEIsMainAsset);
        this.rEIsMainAsset = rEIsMainAsset;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAssignmentHasMultiple</b>
     * </p>
     * 
     * @param rEAssignmentHasMultiple
     *            Generated Entry for Multiple Assignment
     */
    public void setREAssignmentHasMultiple( @Nullable final java.lang.Boolean rEAssignmentHasMultiple )
    {
        rememberChangedField("REAssignmentHasMultiple", this.rEAssignmentHasMultiple);
        this.rEAssignmentHasMultiple = rEAssignmentHasMultiple;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REObjectPossessionStartDate</b>
     * </p>
     * 
     * @param rEObjectPossessionStartDate
     *            Date From Which the Object Is Made Available for Use
     */
    public void setREObjectPossessionStartDate( @Nullable final LocalDate rEObjectPossessionStartDate )
    {
        rememberChangedField("REObjectPossessionStartDate", this.rEObjectPossessionStartDate);
        this.rEObjectPossessionStartDate = rEObjectPossessionStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REObjectPossessionEndDate</b>
     * </p>
     * 
     * @param rEObjectPossessionEndDate
     *            Date Up to Which the Object Is Used
     */
    public void setREObjectPossessionEndDate( @Nullable final LocalDate rEObjectPossessionEndDate )
    {
        rememberChangedField("REObjectPossessionEndDate", this.rEObjectPossessionEndDate);
        this.rEObjectPossessionEndDate = rEObjectPossessionEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REGroupNumber</b>
     * </p>
     * 
     * @param rEGroupNumber
     *            Group Number
     */
    public void setREGroupNumber( @Nullable final java.lang.String rEGroupNumber )
    {
        rememberChangedField("REGroupNumber", this.rEGroupNumber);
        this.rEGroupNumber = rEGroupNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>REObjectGroupName</b>
     * </p>
     * 
     * @param rEObjectGroupName
     *            Name of Object Groups
     */
    public void setREObjectGroupName( @Nullable final java.lang.String rEObjectGroupName )
    {
        rememberChangedField("REObjectGroupName", this.rEObjectGroupName);
        this.rEObjectGroupName = rEObjectGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REContractSubjectNumber</b>
     * </p>
     * 
     * @param rEContractSubjectNumber
     *            Group Number
     */
    public void setREContractSubjectNumber( @Nullable final java.lang.String rEContractSubjectNumber )
    {
        rememberChangedField("REContractSubjectNumber", this.rEContractSubjectNumber);
        this.rEContractSubjectNumber = rEContractSubjectNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>REContractSubjectDescription</b>
     * </p>
     * 
     * @param rEContractSubjectDescription
     *            Name for Contract Item
     */
    public void setREContractSubjectDescription( @Nullable final java.lang.String rEContractSubjectDescription )
    {
        rememberChangedField("REContractSubjectDescription", this.rEContractSubjectDescription);
        this.rEContractSubjectDescription = rEContractSubjectDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REContractSubjectClass</b>
     * </p>
     * 
     * @param rEContractSubjectClass
     *            Contract Object Class
     */
    public void setREContractSubjectClass( @Nullable final java.lang.String rEContractSubjectClass )
    {
        rememberChangedField("REContractSubjectClass", this.rEContractSubjectClass);
        this.rEContractSubjectClass = rEContractSubjectClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>REContractSubjectType</b>
     * </p>
     * 
     * @param rEContractSubjectType
     *            Type of Contract Object
     */
    public void setREContractSubjectType( @Nullable final java.lang.String rEContractSubjectType )
    {
        rememberChangedField("REContractSubjectType", this.rEContractSubjectType);
        this.rEContractSubjectType = rEContractSubjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>ExternalId</b>
     * </p>
     * 
     * @param externalId
     *            External Identification for Contract Object
     */
    public void setExternalId( @Nullable final java.lang.String externalId )
    {
        rememberChangedField("ExternalId", this.externalId);
        this.externalId = externalId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REAccountingObject</b>
     * </p>
     * 
     * @param rEAccountingObject
     *            Object Number Account Assignment
     */
    public void setREAccountingObject( @Nullable final java.lang.String rEAccountingObject )
    {
        rememberChangedField("REAccountingObject", this.rEAccountingObject);
        this.rEAccountingObject = rEAccountingObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REAccountingObjectType</b>
     * </p>
     * 
     * @param rEAccountingObjectType
     *            Object Type
     */
    public void setREAccountingObjectType( @Nullable final java.lang.String rEAccountingObjectType )
    {
        rememberChangedField("REAccountingObjectType", this.rEAccountingObjectType);
        this.rEAccountingObjectType = rEAccountingObjectType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrObjAssgmt";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("REStatusObjectSource", getREStatusObjectSource());
        entityKey.addKeyProperty("REObjectAssignmentType", getREObjectAssignmentType());
        entityKey.addKeyProperty("REStatusObjectTarget", getREStatusObjectTarget());
        entityKey.addKeyProperty("ValidityStartEndDateValue", getValidityStartEndDateValue());
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("REStatusObjectSource", getREStatusObjectSource());
        values.put("REObjectAssignmentType", getREObjectAssignmentType());
        values.put("REStatusObjectTarget", getREStatusObjectTarget());
        values.put("ValidityStartEndDateValue", getValidityStartEndDateValue());
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("REOnlyInfoAssgmt", getREOnlyInfoAssgmt());
        values.put("REStatusObjectSourceIsArchived", getREStatusObjectSourceIsArchived());
        values.put("REGenerationType", getREGenerationType());
        values.put("REIsMainAsset", getREIsMainAsset());
        values.put("REAssignmentHasMultiple", getREAssignmentHasMultiple());
        values.put("REObjectPossessionStartDate", getREObjectPossessionStartDate());
        values.put("REObjectPossessionEndDate", getREObjectPossessionEndDate());
        values.put("REGroupNumber", getREGroupNumber());
        values.put("REObjectGroupName", getREObjectGroupName());
        values.put("REContractSubjectNumber", getREContractSubjectNumber());
        values.put("REContractSubjectDescription", getREContractSubjectDescription());
        values.put("REContractSubjectClass", getREContractSubjectClass());
        values.put("REContractSubjectType", getREContractSubjectType());
        values.put("ExternalId", getExternalId());
        values.put("REAccountingObject", getREAccountingObject());
        values.put("REAccountingObjectType", getREAccountingObjectType());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("REStatusObjectSource") ) {
                final Object value = values.remove("REStatusObjectSource");
                if( (value == null) || (!value.equals(getREStatusObjectSource())) ) {
                    setREStatusObjectSource(((java.lang.String) value));
                }
            }
            if( values.containsKey("REObjectAssignmentType") ) {
                final Object value = values.remove("REObjectAssignmentType");
                if( (value == null) || (!value.equals(getREObjectAssignmentType())) ) {
                    setREObjectAssignmentType(((java.lang.String) value));
                }
            }
            if( values.containsKey("REStatusObjectTarget") ) {
                final Object value = values.remove("REStatusObjectTarget");
                if( (value == null) || (!value.equals(getREStatusObjectTarget())) ) {
                    setREStatusObjectTarget(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartEndDateValue") ) {
                final Object value = values.remove("ValidityStartEndDateValue");
                if( (value == null) || (!value.equals(getValidityStartEndDateValue())) ) {
                    setValidityStartEndDateValue(((java.lang.String) value));
                }
            }
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REOnlyInfoAssgmt") ) {
                final Object value = values.remove("REOnlyInfoAssgmt");
                if( (value == null) || (!value.equals(getREOnlyInfoAssgmt())) ) {
                    setREOnlyInfoAssgmt(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REStatusObjectSourceIsArchived") ) {
                final Object value = values.remove("REStatusObjectSourceIsArchived");
                if( (value == null) || (!value.equals(getREStatusObjectSourceIsArchived())) ) {
                    setREStatusObjectSourceIsArchived(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REGenerationType") ) {
                final Object value = values.remove("REGenerationType");
                if( (value == null) || (!value.equals(getREGenerationType())) ) {
                    setREGenerationType(((java.lang.String) value));
                }
            }
            if( values.containsKey("REIsMainAsset") ) {
                final Object value = values.remove("REIsMainAsset");
                if( (value == null) || (!value.equals(getREIsMainAsset())) ) {
                    setREIsMainAsset(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REAssignmentHasMultiple") ) {
                final Object value = values.remove("REAssignmentHasMultiple");
                if( (value == null) || (!value.equals(getREAssignmentHasMultiple())) ) {
                    setREAssignmentHasMultiple(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REObjectPossessionStartDate") ) {
                final Object value = values.remove("REObjectPossessionStartDate");
                if( (value == null) || (!value.equals(getREObjectPossessionStartDate())) ) {
                    setREObjectPossessionStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REObjectPossessionEndDate") ) {
                final Object value = values.remove("REObjectPossessionEndDate");
                if( (value == null) || (!value.equals(getREObjectPossessionEndDate())) ) {
                    setREObjectPossessionEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REGroupNumber") ) {
                final Object value = values.remove("REGroupNumber");
                if( (value == null) || (!value.equals(getREGroupNumber())) ) {
                    setREGroupNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("REObjectGroupName") ) {
                final Object value = values.remove("REObjectGroupName");
                if( (value == null) || (!value.equals(getREObjectGroupName())) ) {
                    setREObjectGroupName(((java.lang.String) value));
                }
            }
            if( values.containsKey("REContractSubjectNumber") ) {
                final Object value = values.remove("REContractSubjectNumber");
                if( (value == null) || (!value.equals(getREContractSubjectNumber())) ) {
                    setREContractSubjectNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("REContractSubjectDescription") ) {
                final Object value = values.remove("REContractSubjectDescription");
                if( (value == null) || (!value.equals(getREContractSubjectDescription())) ) {
                    setREContractSubjectDescription(((java.lang.String) value));
                }
            }
            if( values.containsKey("REContractSubjectClass") ) {
                final Object value = values.remove("REContractSubjectClass");
                if( (value == null) || (!value.equals(getREContractSubjectClass())) ) {
                    setREContractSubjectClass(((java.lang.String) value));
                }
            }
            if( values.containsKey("REContractSubjectType") ) {
                final Object value = values.remove("REContractSubjectType");
                if( (value == null) || (!value.equals(getREContractSubjectType())) ) {
                    setREContractSubjectType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ExternalId") ) {
                final Object value = values.remove("ExternalId");
                if( (value == null) || (!value.equals(getExternalId())) ) {
                    setExternalId(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAccountingObject") ) {
                final Object value = values.remove("REAccountingObject");
                if( (value == null) || (!value.equals(getREAccountingObject())) ) {
                    setREAccountingObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAccountingObjectType") ) {
                final Object value = values.remove("REAccountingObjectType");
                if( (value == null) || (!value.equals(getREAccountingObjectType())) ) {
                    setREAccountingObjectType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrObjAssgmt</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrObjAssgmt instances.
     * 
     */
    public final static class REContrObjAssgmtBuilder
    {

        private REContract to_REContract;

        private REContrObjAssgmt.REContrObjAssgmtBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrObjAssgmt</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrObjAssgmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrObjAssgmt.REContrObjAssgmtBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
