/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrOrglAssgmtTermType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrOrglAssgmtTerm extends VdmEntity<REContrOrglAssgmtTerm> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrOrglAssgmtTermType";
    /**
     * Selector for all available fields of REContrOrglAssgmtTerm.
     * 
     */
    public final static SimpleProperty<REContrOrglAssgmtTerm> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "InternalRealEstateNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermType</b>
     * </p>
     * 
     * @return Term Category
     */
    @Nullable
    @ElementName( "RETermType" )
    private java.lang.String rETermType;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> RE_TERM_TYPE =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "RETermType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @return Term Number
     */
    @Nullable
    @ElementName( "RETermNumber" )
    private java.lang.String rETermNumber;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> RE_TERM_NUMBER =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "RETermNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @return Date from to (RAP Key)
     */
    @Nullable
    @ElementName( "ValidityStartEndDateValue" )
    private java.lang.String validityStartEndDateValue;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> VALIDITY_START_END_DATE_VALUE =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "ValidityStartEndDateValue");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<REContrOrglAssgmtTerm> VALIDITY_START_DATE =
        new SimpleProperty.Date<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "ValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<REContrOrglAssgmtTerm> VALIDITY_END_DATE =
        new SimpleProperty.Date<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @return Name of Term
     */
    @Nullable
    @ElementName( "RETermName" )
    private java.lang.String rETermName;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> RE_TERM_NAME =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "RETermName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     * 
     * @return Business Area
     */
    @Nullable
    @ElementName( "BusinessArea" )
    private java.lang.String businessArea;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> BUSINESS_AREA =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     * 
     * @return Profit Center
     */
    @Nullable
    @ElementName( "ProfitCenter" )
    private java.lang.String profitCenter;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> PROFIT_CENTER =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObject</b>
     * </p>
     * 
     * @return Object Number for Additional Account Assignment
     */
    @Nullable
    @ElementName( "REStatusObject" )
    private java.lang.String rEStatusObject;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> RE_STATUS_OBJECT =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "REStatusObject");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     * 
     * @return Tax Jurisdiction
     */
    @Nullable
    @ElementName( "TaxJurisdiction" )
    private java.lang.String taxJurisdiction;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> TAX_JURISDICTION =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     * 
     * @return Fund
     */
    @Nullable
    @ElementName( "Fund" )
    private java.lang.String fund;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> FUND =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "Fund");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     * 
     * @return Funds Center
     */
    @Nullable
    @ElementName( "FundsCenter" )
    private java.lang.String fundsCenter;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> FUNDS_CENTER =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "FundsCenter");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     * 
     * @return Name
     */
    @Nullable
    @ElementName( "CommitmentItem" )
    private java.lang.String commitmentItem;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> COMMITMENT_ITEM =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "CommitmentItem");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     * 
     * @return Functional Area
     */
    @Nullable
    @ElementName( "FunctionalArea" )
    private java.lang.String functionalArea;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> FUNCTIONAL_AREA =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     * 
     * @return FM: Budget Period
     */
    @Nullable
    @ElementName( "BudgetPeriod" )
    private java.lang.String budgetPeriod;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> BUDGET_PERIOD =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "BudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxCalculationProcedure</b>
     * </p>
     * 
     * @return Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    @Nullable
    @ElementName( "TaxCalculationProcedure" )
    private java.lang.String taxCalculationProcedure;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> TAX_CALCULATION_PROCEDURE =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "TaxCalculationProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     * 
     * @return Financial Management Area
     */
    @Nullable
    @ElementName( "FinancialManagementArea" )
    private java.lang.String financialManagementArea;
    public final static SimpleProperty.String<REContrOrglAssgmtTerm> FINANCIAL_MANAGEMENT_AREA =
        new SimpleProperty.String<REContrOrglAssgmtTerm>(REContrOrglAssgmtTerm.class, "FinancialManagementArea");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrOrglAssgmtTerm, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrOrglAssgmtTerm, SAP__Message>(
            REContrOrglAssgmtTerm.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrOrglAssgmtTerm</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrOrglAssgmtTerm, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrOrglAssgmtTerm, REContract>(
            REContrOrglAssgmtTerm.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrOrglAssgmtTerm> getType()
    {
        return REContrOrglAssgmtTerm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermType</b>
     * </p>
     * 
     * @param rETermType
     *            Term Category
     */
    public void setRETermType( @Nullable final java.lang.String rETermType )
    {
        rememberChangedField("RETermType", this.rETermType);
        this.rETermType = rETermType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @param rETermNumber
     *            Term Number
     */
    public void setRETermNumber( @Nullable final java.lang.String rETermNumber )
    {
        rememberChangedField("RETermNumber", this.rETermNumber);
        this.rETermNumber = rETermNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     */
    public void setValidityStartEndDateValue( @Nullable final java.lang.String validityStartEndDateValue )
    {
        rememberChangedField("ValidityStartEndDateValue", this.validityStartEndDateValue);
        this.validityStartEndDateValue = validityStartEndDateValue;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @param rETermName
     *            Name of Term
     */
    public void setRETermName( @Nullable final java.lang.String rETermName )
    {
        rememberChangedField("RETermName", this.rETermName);
        this.rETermName = rETermName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     * 
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final java.lang.String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     * 
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final java.lang.String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObject</b>
     * </p>
     * 
     * @param rEStatusObject
     *            Object Number for Additional Account Assignment
     */
    public void setREStatusObject( @Nullable final java.lang.String rEStatusObject )
    {
        rememberChangedField("REStatusObject", this.rEStatusObject);
        this.rEStatusObject = rEStatusObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     * 
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final java.lang.String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     * 
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final java.lang.String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     * 
     * @param fundsCenter
     *            Funds Center
     */
    public void setFundsCenter( @Nullable final java.lang.String fundsCenter )
    {
        rememberChangedField("FundsCenter", this.fundsCenter);
        this.fundsCenter = fundsCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     * 
     * @param commitmentItem
     *            Name
     */
    public void setCommitmentItem( @Nullable final java.lang.String commitmentItem )
    {
        rememberChangedField("CommitmentItem", this.commitmentItem);
        this.commitmentItem = commitmentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     * 
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final java.lang.String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     * 
     * @param budgetPeriod
     *            FM: Budget Period
     */
    public void setBudgetPeriod( @Nullable final java.lang.String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxCalculationProcedure</b>
     * </p>
     * 
     * @param taxCalculationProcedure
     *            Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    public void setTaxCalculationProcedure( @Nullable final java.lang.String taxCalculationProcedure )
    {
        rememberChangedField("TaxCalculationProcedure", this.taxCalculationProcedure);
        this.taxCalculationProcedure = taxCalculationProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     * 
     * @param financialManagementArea
     *            Financial Management Area
     */
    public void setFinancialManagementArea( @Nullable final java.lang.String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrOrglAssgmtTerm";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        entityKey.addKeyProperty("RETermType", getRETermType());
        entityKey.addKeyProperty("RETermNumber", getRETermNumber());
        entityKey.addKeyProperty("ValidityStartEndDateValue", getValidityStartEndDateValue());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("RETermType", getRETermType());
        values.put("RETermNumber", getRETermNumber());
        values.put("ValidityStartEndDateValue", getValidityStartEndDateValue());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("RETermName", getRETermName());
        values.put("BusinessArea", getBusinessArea());
        values.put("ProfitCenter", getProfitCenter());
        values.put("REStatusObject", getREStatusObject());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("Fund", getFund());
        values.put("FundsCenter", getFundsCenter());
        values.put("CommitmentItem", getCommitmentItem());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("TaxCalculationProcedure", getTaxCalculationProcedure());
        values.put("FinancialManagementArea", getFinancialManagementArea());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermType") ) {
                final Object value = values.remove("RETermType");
                if( (value == null) || (!value.equals(getRETermType())) ) {
                    setRETermType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermNumber") ) {
                final Object value = values.remove("RETermNumber");
                if( (value == null) || (!value.equals(getRETermNumber())) ) {
                    setRETermNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartEndDateValue") ) {
                final Object value = values.remove("ValidityStartEndDateValue");
                if( (value == null) || (!value.equals(getValidityStartEndDateValue())) ) {
                    setValidityStartEndDateValue(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("RETermName") ) {
                final Object value = values.remove("RETermName");
                if( (value == null) || (!value.equals(getRETermName())) ) {
                    setRETermName(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("REStatusObject") ) {
                final Object value = values.remove("REStatusObject");
                if( (value == null) || (!value.equals(getREStatusObject())) ) {
                    setREStatusObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((java.lang.String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((java.lang.String) value));
                }
            }
            if( values.containsKey("FundsCenter") ) {
                final Object value = values.remove("FundsCenter");
                if( (value == null) || (!value.equals(getFundsCenter())) ) {
                    setFundsCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("CommitmentItem") ) {
                final Object value = values.remove("CommitmentItem");
                if( (value == null) || (!value.equals(getCommitmentItem())) ) {
                    setCommitmentItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxCalculationProcedure") ) {
                final Object value = values.remove("TaxCalculationProcedure");
                if( (value == null) || (!value.equals(getTaxCalculationProcedure())) ) {
                    setTaxCalculationProcedure(((java.lang.String) value));
                }
            }
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrOrglAssgmtTerm</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrOrglAssgmtTerm instances.
     * 
     */
    public final static class REContrOrglAssgmtTermBuilder
    {

        private REContract to_REContract;

        private REContrOrglAssgmtTerm.REContrOrglAssgmtTermBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrOrglAssgmtTerm</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrOrglAssgmtTerm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrOrglAssgmtTerm.REContrOrglAssgmtTermBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
