/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrPartAssgmtType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrPartAssgmt extends VdmEntity<REContrPartAssgmt> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrPartAssgmtType";
    /**
     * Selector for all available fields of REContrPartAssgmt.
     * 
     */
    public final static SimpleProperty<REContrPartAssgmt> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrPartAssgmt> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrPartAssgmt>(REContrPartAssgmt.class, "InternalRealEstateNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @return Business Partner Number
     */
    @Nullable
    @ElementName( "BusinessPartner" )
    private java.lang.String businessPartner;
    public final static SimpleProperty.String<REContrPartAssgmt> BUSINESS_PARTNER =
        new SimpleProperty.String<REContrPartAssgmt>(REContrPartAssgmt.class, "BusinessPartner");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerRole</b>
     * </p>
     * 
     * @return Business Partner: Role
     */
    @Nullable
    @ElementName( "BusinessPartnerRole" )
    private java.lang.String businessPartnerRole;
    public final static SimpleProperty.String<REContrPartAssgmt> BUSINESS_PARTNER_ROLE =
        new SimpleProperty.String<REContrPartAssgmt>(REContrPartAssgmt.class, "BusinessPartnerRole");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @return Date from to (RAP Key)
     */
    @Nullable
    @ElementName( "ValidityStartEndDateValue" )
    private java.lang.String validityStartEndDateValue;
    public final static SimpleProperty.String<REContrPartAssgmt> VALIDITY_START_END_DATE_VALUE =
        new SimpleProperty.String<REContrPartAssgmt>(REContrPartAssgmt.class, "ValidityStartEndDateValue");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<REContrPartAssgmt> VALIDITY_START_DATE =
        new SimpleProperty.Date<REContrPartAssgmt>(REContrPartAssgmt.class, "ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REPartnerRoleType</b>
     * </p>
     * 
     * @return Business Partner: Role Type
     */
    @Nullable
    @ElementName( "REPartnerRoleType" )
    private java.lang.String rEPartnerRoleType;
    public final static SimpleProperty.String<REContrPartAssgmt> RE_PARTNER_ROLE_TYPE =
        new SimpleProperty.String<REContrPartAssgmt>(REContrPartAssgmt.class, "REPartnerRoleType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressType</b>
     * </p>
     * 
     * @return Address Type
     */
    @Nullable
    @ElementName( "AddressType" )
    private java.lang.String addressType;
    public final static SimpleProperty.String<REContrPartAssgmt> ADDRESS_TYPE =
        new SimpleProperty.String<REContrPartAssgmt>(REContrPartAssgmt.class, "AddressType");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<REContrPartAssgmt> VALIDITY_END_DATE =
        new SimpleProperty.Date<REContrPartAssgmt>(REContrPartAssgmt.class, "ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>REFractionalPrptyShrRatio</b>
     * </p>
     * 
     * @return Fractional share of property
     */
    @Nullable
    @ElementName( "REFractionalPrptyShrRatio" )
    @DecimalDescriptor( precision = 9, scale = 3 )
    private BigDecimal rEFractionalPrptyShrRatio;
    public final static SimpleProperty.NumericDecimal<REContrPartAssgmt> RE_FRACTIONAL_PRPTY_SHR_RATIO =
        new SimpleProperty.NumericDecimal<REContrPartAssgmt>(REContrPartAssgmt.class, "REFractionalPrptyShrRatio");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>REOwnershipShrRatio</b>
     * </p>
     * 
     * @return Co-ownership share
     */
    @Nullable
    @ElementName( "REOwnershipShrRatio" )
    @DecimalDescriptor( precision = 9, scale = 3 )
    private BigDecimal rEOwnershipShrRatio;
    public final static SimpleProperty.NumericDecimal<REContrPartAssgmt> RE_OWNERSHIP_SHR_RATIO =
        new SimpleProperty.NumericDecimal<REContrPartAssgmt>(REContrPartAssgmt.class, "REOwnershipShrRatio");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RECoOwnershipShrRatio</b>
     * </p>
     * 
     * @return Ownership share
     */
    @Nullable
    @ElementName( "RECoOwnershipShrRatio" )
    @DecimalDescriptor( precision = 6, scale = 2 )
    private BigDecimal rECoOwnershipShrRatio;
    public final static SimpleProperty.NumericDecimal<REContrPartAssgmt> RE_CO_OWNERSHIP_SHR_RATIO =
        new SimpleProperty.NumericDecimal<REContrPartAssgmt>(REContrPartAssgmt.class, "RECoOwnershipShrRatio");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>REFractionalShrCnvrsnRatio</b>
     * </p>
     * 
     * @return Conversion factor for fractional share of property
     */
    @Nullable
    @ElementName( "REFractionalShrCnvrsnRatio" )
    private java.lang.String rEFractionalShrCnvrsnRatio;
    public final static SimpleProperty.String<REContrPartAssgmt> RE_FRACTIONAL_SHR_CNVRSN_RATIO =
        new SimpleProperty.String<REContrPartAssgmt>(REContrPartAssgmt.class, "REFractionalShrCnvrsnRatio");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     * 
     * @return Contract Account Number
     */
    @Nullable
    @ElementName( "ContractAccount" )
    private java.lang.String contractAccount;
    public final static SimpleProperty.String<REContrPartAssgmt> CONTRACT_ACCOUNT =
        new SimpleProperty.String<REContrPartAssgmt>(REContrPartAssgmt.class, "ContractAccount");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrPartAssgmt, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrPartAssgmt, SAP__Message>(
            REContrPartAssgmt.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrPartAssgmt</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrPartAssgmt, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrPartAssgmt, REContract>(
            REContrPartAssgmt.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrPartAssgmt> getType()
    {
        return REContrPartAssgmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final java.lang.String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerRole</b>
     * </p>
     * 
     * @param businessPartnerRole
     *            Business Partner: Role
     */
    public void setBusinessPartnerRole( @Nullable final java.lang.String businessPartnerRole )
    {
        rememberChangedField("BusinessPartnerRole", this.businessPartnerRole);
        this.businessPartnerRole = businessPartnerRole;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     */
    public void setValidityStartEndDateValue( @Nullable final java.lang.String validityStartEndDateValue )
    {
        rememberChangedField("ValidityStartEndDateValue", this.validityStartEndDateValue);
        this.validityStartEndDateValue = validityStartEndDateValue;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REPartnerRoleType</b>
     * </p>
     * 
     * @param rEPartnerRoleType
     *            Business Partner: Role Type
     */
    public void setREPartnerRoleType( @Nullable final java.lang.String rEPartnerRoleType )
    {
        rememberChangedField("REPartnerRoleType", this.rEPartnerRoleType);
        this.rEPartnerRoleType = rEPartnerRoleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressType</b>
     * </p>
     * 
     * @param addressType
     *            Address Type
     */
    public void setAddressType( @Nullable final java.lang.String addressType )
    {
        rememberChangedField("AddressType", this.addressType);
        this.addressType = addressType;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>REFractionalPrptyShrRatio</b>
     * </p>
     * 
     * @param rEFractionalPrptyShrRatio
     *            Fractional share of property
     */
    public void setREFractionalPrptyShrRatio( @Nullable final BigDecimal rEFractionalPrptyShrRatio )
    {
        rememberChangedField("REFractionalPrptyShrRatio", this.rEFractionalPrptyShrRatio);
        this.rEFractionalPrptyShrRatio = rEFractionalPrptyShrRatio;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>REOwnershipShrRatio</b>
     * </p>
     * 
     * @param rEOwnershipShrRatio
     *            Co-ownership share
     */
    public void setREOwnershipShrRatio( @Nullable final BigDecimal rEOwnershipShrRatio )
    {
        rememberChangedField("REOwnershipShrRatio", this.rEOwnershipShrRatio);
        this.rEOwnershipShrRatio = rEOwnershipShrRatio;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RECoOwnershipShrRatio</b>
     * </p>
     * 
     * @param rECoOwnershipShrRatio
     *            Ownership share
     */
    public void setRECoOwnershipShrRatio( @Nullable final BigDecimal rECoOwnershipShrRatio )
    {
        rememberChangedField("RECoOwnershipShrRatio", this.rECoOwnershipShrRatio);
        this.rECoOwnershipShrRatio = rECoOwnershipShrRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>REFractionalShrCnvrsnRatio</b>
     * </p>
     * 
     * @param rEFractionalShrCnvrsnRatio
     *            Conversion factor for fractional share of property
     */
    public void setREFractionalShrCnvrsnRatio( @Nullable final java.lang.String rEFractionalShrCnvrsnRatio )
    {
        rememberChangedField("REFractionalShrCnvrsnRatio", this.rEFractionalShrCnvrsnRatio);
        this.rEFractionalShrCnvrsnRatio = rEFractionalShrCnvrsnRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     * 
     * @param contractAccount
     *            Contract Account Number
     */
    public void setContractAccount( @Nullable final java.lang.String contractAccount )
    {
        rememberChangedField("ContractAccount", this.contractAccount);
        this.contractAccount = contractAccount;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrPartAssgmt";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        entityKey.addKeyProperty("BusinessPartner", getBusinessPartner());
        entityKey.addKeyProperty("BusinessPartnerRole", getBusinessPartnerRole());
        entityKey.addKeyProperty("ValidityStartEndDateValue", getValidityStartEndDateValue());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("BusinessPartner", getBusinessPartner());
        values.put("BusinessPartnerRole", getBusinessPartnerRole());
        values.put("ValidityStartEndDateValue", getValidityStartEndDateValue());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("REPartnerRoleType", getREPartnerRoleType());
        values.put("AddressType", getAddressType());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("REFractionalPrptyShrRatio", getREFractionalPrptyShrRatio());
        values.put("REOwnershipShrRatio", getREOwnershipShrRatio());
        values.put("RECoOwnershipShrRatio", getRECoOwnershipShrRatio());
        values.put("REFractionalShrCnvrsnRatio", getREFractionalShrCnvrsnRatio());
        values.put("ContractAccount", getContractAccount());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPartnerRole") ) {
                final Object value = values.remove("BusinessPartnerRole");
                if( (value == null) || (!value.equals(getBusinessPartnerRole())) ) {
                    setBusinessPartnerRole(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartEndDateValue") ) {
                final Object value = values.remove("ValidityStartEndDateValue");
                if( (value == null) || (!value.equals(getValidityStartEndDateValue())) ) {
                    setValidityStartEndDateValue(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REPartnerRoleType") ) {
                final Object value = values.remove("REPartnerRoleType");
                if( (value == null) || (!value.equals(getREPartnerRoleType())) ) {
                    setREPartnerRoleType(((java.lang.String) value));
                }
            }
            if( values.containsKey("AddressType") ) {
                final Object value = values.remove("AddressType");
                if( (value == null) || (!value.equals(getAddressType())) ) {
                    setAddressType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REFractionalPrptyShrRatio") ) {
                final Object value = values.remove("REFractionalPrptyShrRatio");
                if( (value == null) || (!value.equals(getREFractionalPrptyShrRatio())) ) {
                    setREFractionalPrptyShrRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("REOwnershipShrRatio") ) {
                final Object value = values.remove("REOwnershipShrRatio");
                if( (value == null) || (!value.equals(getREOwnershipShrRatio())) ) {
                    setREOwnershipShrRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("RECoOwnershipShrRatio") ) {
                final Object value = values.remove("RECoOwnershipShrRatio");
                if( (value == null) || (!value.equals(getRECoOwnershipShrRatio())) ) {
                    setRECoOwnershipShrRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("REFractionalShrCnvrsnRatio") ) {
                final Object value = values.remove("REFractionalShrCnvrsnRatio");
                if( (value == null) || (!value.equals(getREFractionalShrCnvrsnRatio())) ) {
                    setREFractionalShrCnvrsnRatio(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContractAccount") ) {
                final Object value = values.remove("ContractAccount");
                if( (value == null) || (!value.equals(getContractAccount())) ) {
                    setContractAccount(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrPartAssgmt</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrPartAssgmt instances.
     * 
     */
    public final static class REContrPartAssgmtBuilder
    {

        private REContract to_REContract;

        private REContrPartAssgmt.REContrPartAssgmtBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrPartAssgmt</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrPartAssgmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrPartAssgmt.REContrPartAssgmtBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
