/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrPostingTermType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrPostingTerm extends VdmEntity<REContrPostingTerm> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrPostingTermType";
    /**
     * Selector for all available fields of REContrPostingTerm.
     * 
     */
    public final static SimpleProperty<REContrPostingTerm> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrPostingTerm> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "InternalRealEstateNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermType</b>
     * </p>
     * 
     * @return Term Category
     */
    @Nullable
    @ElementName( "RETermType" )
    private java.lang.String rETermType;
    public final static SimpleProperty.String<REContrPostingTerm> RE_TERM_TYPE =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "RETermType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @return Term Number
     */
    @Nullable
    @ElementName( "RETermNumber" )
    private java.lang.String rETermNumber;
    public final static SimpleProperty.String<REContrPostingTerm> RE_TERM_NUMBER =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "RETermNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @return Date from to (RAP Key)
     */
    @Nullable
    @ElementName( "ValidityStartEndDateValue" )
    private java.lang.String validityStartEndDateValue;
    public final static SimpleProperty.String<REContrPostingTerm> VALIDITY_START_END_DATE_VALUE =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "ValidityStartEndDateValue");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<REContrPostingTerm> VALIDITY_START_DATE =
        new SimpleProperty.Date<REContrPostingTerm>(REContrPostingTerm.class, "ValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<REContrPostingTerm> VALIDITY_END_DATE =
        new SimpleProperty.Date<REContrPostingTerm>(REContrPostingTerm.class, "ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @return Name of Term
     */
    @Nullable
    @ElementName( "RETermName" )
    private java.lang.String rETermName;
    public final static SimpleProperty.String<REContrPostingTerm> RE_TERM_NAME =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "RETermName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     * 
     * @return Payment Method
     */
    @Nullable
    @ElementName( "PaymentMethod" )
    private java.lang.String paymentMethod;
    public final static SimpleProperty.String<REContrPostingTerm> PAYMENT_METHOD =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "PaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REPaymentMethodCreditMemo</b>
     * </p>
     * 
     * @return Payment Method for Credit Memos
     */
    @Nullable
    @ElementName( "REPaymentMethodCreditMemo" )
    private java.lang.String rEPaymentMethodCreditMemo;
    public final static SimpleProperty.String<REContrPostingTerm> RE_PAYMENT_METHOD_CREDIT_MEMO =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "REPaymentMethodCreditMemo");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentBlockingReason</b>
     * </p>
     * 
     * @return Payment block key
     */
    @Nullable
    @ElementName( "PaymentBlockingReason" )
    private java.lang.String paymentBlockingReason;
    public final static SimpleProperty.String<REContrPostingTerm> PAYMENT_BLOCKING_REASON =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "PaymentBlockingReason");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     * 
     * @return Terms of Payment Key
     */
    @Nullable
    @ElementName( "PaymentTerms" )
    private java.lang.String paymentTerms;
    public final static SimpleProperty.String<REContrPostingTerm> PAYMENT_TERMS =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     * 
     * @return Key for House Bank
     */
    @Nullable
    @ElementName( "HouseBank" )
    private java.lang.String houseBank;
    public final static SimpleProperty.String<REContrPostingTerm> HOUSE_BANK =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "HouseBank");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     * 
     * @return Key for House Bank Account
     */
    @Nullable
    @ElementName( "HouseBankAccount" )
    private java.lang.String houseBankAccount;
    public final static SimpleProperty.String<REContrPostingTerm> HOUSE_BANK_ACCOUNT =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "HouseBankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BankIdentification</b>
     * </p>
     * 
     * @return Bank Details ID
     */
    @Nullable
    @ElementName( "BankIdentification" )
    private java.lang.String bankIdentification;
    public final static SimpleProperty.String<REContrPostingTerm> BANK_IDENTIFICATION =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "BankIdentification");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>RENoteToPayeeText</b>
     * </p>
     * 
     * @return Note to Payee
     */
    @Nullable
    @ElementName( "RENoteToPayeeText" )
    private java.lang.String rENoteToPayeeText;
    public final static SimpleProperty.String<REContrPostingTerm> RE_NOTE_TO_PAYEE_TEXT =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "RENoteToPayeeText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DunningArea</b>
     * </p>
     * 
     * @return Dunning Area
     */
    @Nullable
    @ElementName( "DunningArea" )
    private java.lang.String dunningArea;
    public final static SimpleProperty.String<REContrPostingTerm> DUNNING_AREA =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "DunningArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DunningKey</b>
     * </p>
     * 
     * @return Dunning Keys
     */
    @Nullable
    @ElementName( "DunningKey" )
    private java.lang.String dunningKey;
    public final static SimpleProperty.String<REContrPostingTerm> DUNNING_KEY =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "DunningKey");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DunningBlockingReason</b>
     * </p>
     * 
     * @return Dunning Block
     */
    @Nullable
    @ElementName( "DunningBlockingReason" )
    private java.lang.String dunningBlockingReason;
    public final static SimpleProperty.String<REContrPostingTerm> DUNNING_BLOCKING_REASON =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "DunningBlockingReason");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REAcctDeterminationKey</b>
     * </p>
     * 
     * @return Account Determination Value
     */
    @Nullable
    @ElementName( "REAcctDeterminationKey" )
    private java.lang.String rEAcctDeterminationKey;
    public final static SimpleProperty.String<REContrPostingTerm> RE_ACCT_DETERMINATION_KEY =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "REAcctDeterminationKey");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETaxType</b>
     * </p>
     * 
     * @return Tax Type
     */
    @Nullable
    @ElementName( "RETaxType" )
    private java.lang.String rETaxType;
    public final static SimpleProperty.String<REContrPostingTerm> RE_TAX_TYPE =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "RETaxType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TaxGroup</b>
     * </p>
     * 
     * @return Tax Group
     */
    @Nullable
    @ElementName( "TaxGroup" )
    private java.lang.String taxGroup;
    public final static SimpleProperty.String<REContrPostingTerm> TAX_GROUP =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "TaxGroup");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsConditionGrossAmount</b>
     * </p>
     * 
     * @return Condition Amount Is Gross Amount
     */
    @Nullable
    @ElementName( "REIsConditionGrossAmount" )
    private java.lang.Boolean rEIsConditionGrossAmount;
    public final static SimpleProperty.Boolean<REContrPostingTerm> RE_IS_CONDITION_GROSS_AMOUNT =
        new SimpleProperty.Boolean<REContrPostingTerm>(REContrPostingTerm.class, "REIsConditionGrossAmount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     * 
     * @return Alternative Tax Reporting Country
     */
    @Nullable
    @ElementName( "TaxCountry" )
    private java.lang.String taxCountry;
    public final static SimpleProperty.String<REContrPostingTerm> TAX_COUNTRY =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "TaxCountry");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @return Business Partner Number
     */
    @Nullable
    @ElementName( "BusinessPartner" )
    private java.lang.String businessPartner;
    public final static SimpleProperty.String<REContrPostingTerm> BUSINESS_PARTNER =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "BusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REAccountingObject</b>
     * </p>
     * 
     * @return Object Number for Internal Use
     */
    @Nullable
    @ElementName( "REAccountingObject" )
    private java.lang.String rEAccountingObject;
    public final static SimpleProperty.String<REContrPostingTerm> RE_ACCOUNTING_OBJECT =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "REAccountingObject");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     * 
     * @return Tax Jurisdiction
     */
    @Nullable
    @ElementName( "TaxJurisdiction" )
    private java.lang.String taxJurisdiction;
    public final static SimpleProperty.String<REContrPostingTerm> TAX_JURISDICTION =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "TaxJurisdiction");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsConditionSplit</b>
     * </p>
     * 
     * @return Condition Split
     */
    @Nullable
    @ElementName( "REIsConditionSplit" )
    private java.lang.Boolean rEIsConditionSplit;
    public final static SimpleProperty.Boolean<REContrPostingTerm> RE_IS_CONDITION_SPLIT =
        new SimpleProperty.Boolean<REContrPostingTerm>(REContrPostingTerm.class, "REIsConditionSplit");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RECurrencyTranslationRule</b>
     * </p>
     * 
     * @return Currency Translation Rule
     */
    @Nullable
    @ElementName( "RECurrencyTranslationRule" )
    private java.lang.String rECurrencyTranslationRule;
    public final static SimpleProperty.String<REContrPostingTerm> RE_CURRENCY_TRANSLATION_RULE =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "RECurrencyTranslationRule");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsPartnerBlocked</b>
     * </p>
     * 
     * @return Lock of Partner Data in Posting Term
     */
    @Nullable
    @ElementName( "REIsPartnerBlocked" )
    private java.lang.Boolean rEIsPartnerBlocked;
    public final static SimpleProperty.Boolean<REContrPostingTerm> RE_IS_PARTNER_BLOCKED =
        new SimpleProperty.Boolean<REContrPostingTerm>(REContrPostingTerm.class, "REIsPartnerBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     * 
     * @return SEPA Mandate: Unique Reference to Mandate per Vendor
     */
    @Nullable
    @ElementName( "SEPAMandate" )
    private java.lang.String sEPAMandate;
    public final static SimpleProperty.String<REContrPostingTerm> SEPA_MANDATE =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "SEPAMandate");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateCreditor</b>
     * </p>
     * 
     * @return SEPA Mandate: Creditor ID
     */
    @Nullable
    @ElementName( "SEPAMandateCreditor" )
    private java.lang.String sEPAMandateCreditor;
    public final static SimpleProperty.String<REContrPostingTerm> SEPA_MANDATE_CREDITOR =
        new SimpleProperty.String<REContrPostingTerm>(REContrPostingTerm.class, "SEPAMandateCreditor");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrPostingTerm, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrPostingTerm, SAP__Message>(
            REContrPostingTerm.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrPostingTerm</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrPostingTerm, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrPostingTerm, REContract>(
            REContrPostingTerm.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrPostingTerm> getType()
    {
        return REContrPostingTerm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermType</b>
     * </p>
     * 
     * @param rETermType
     *            Term Category
     */
    public void setRETermType( @Nullable final java.lang.String rETermType )
    {
        rememberChangedField("RETermType", this.rETermType);
        this.rETermType = rETermType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @param rETermNumber
     *            Term Number
     */
    public void setRETermNumber( @Nullable final java.lang.String rETermNumber )
    {
        rememberChangedField("RETermNumber", this.rETermNumber);
        this.rETermNumber = rETermNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     */
    public void setValidityStartEndDateValue( @Nullable final java.lang.String validityStartEndDateValue )
    {
        rememberChangedField("ValidityStartEndDateValue", this.validityStartEndDateValue);
        this.validityStartEndDateValue = validityStartEndDateValue;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @param rETermName
     *            Name of Term
     */
    public void setRETermName( @Nullable final java.lang.String rETermName )
    {
        rememberChangedField("RETermName", this.rETermName);
        this.rETermName = rETermName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     * 
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final java.lang.String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REPaymentMethodCreditMemo</b>
     * </p>
     * 
     * @param rEPaymentMethodCreditMemo
     *            Payment Method for Credit Memos
     */
    public void setREPaymentMethodCreditMemo( @Nullable final java.lang.String rEPaymentMethodCreditMemo )
    {
        rememberChangedField("REPaymentMethodCreditMemo", this.rEPaymentMethodCreditMemo);
        this.rEPaymentMethodCreditMemo = rEPaymentMethodCreditMemo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentBlockingReason</b>
     * </p>
     * 
     * @param paymentBlockingReason
     *            Payment block key
     */
    public void setPaymentBlockingReason( @Nullable final java.lang.String paymentBlockingReason )
    {
        rememberChangedField("PaymentBlockingReason", this.paymentBlockingReason);
        this.paymentBlockingReason = paymentBlockingReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     * 
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final java.lang.String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     * 
     * @param houseBank
     *            Key for House Bank
     */
    public void setHouseBank( @Nullable final java.lang.String houseBank )
    {
        rememberChangedField("HouseBank", this.houseBank);
        this.houseBank = houseBank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     * 
     * @param houseBankAccount
     *            Key for House Bank Account
     */
    public void setHouseBankAccount( @Nullable final java.lang.String houseBankAccount )
    {
        rememberChangedField("HouseBankAccount", this.houseBankAccount);
        this.houseBankAccount = houseBankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BankIdentification</b>
     * </p>
     * 
     * @param bankIdentification
     *            Bank Details ID
     */
    public void setBankIdentification( @Nullable final java.lang.String bankIdentification )
    {
        rememberChangedField("BankIdentification", this.bankIdentification);
        this.bankIdentification = bankIdentification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>RENoteToPayeeText</b>
     * </p>
     * 
     * @param rENoteToPayeeText
     *            Note to Payee
     */
    public void setRENoteToPayeeText( @Nullable final java.lang.String rENoteToPayeeText )
    {
        rememberChangedField("RENoteToPayeeText", this.rENoteToPayeeText);
        this.rENoteToPayeeText = rENoteToPayeeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DunningArea</b>
     * </p>
     * 
     * @param dunningArea
     *            Dunning Area
     */
    public void setDunningArea( @Nullable final java.lang.String dunningArea )
    {
        rememberChangedField("DunningArea", this.dunningArea);
        this.dunningArea = dunningArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DunningKey</b>
     * </p>
     * 
     * @param dunningKey
     *            Dunning Keys
     */
    public void setDunningKey( @Nullable final java.lang.String dunningKey )
    {
        rememberChangedField("DunningKey", this.dunningKey);
        this.dunningKey = dunningKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DunningBlockingReason</b>
     * </p>
     * 
     * @param dunningBlockingReason
     *            Dunning Block
     */
    public void setDunningBlockingReason( @Nullable final java.lang.String dunningBlockingReason )
    {
        rememberChangedField("DunningBlockingReason", this.dunningBlockingReason);
        this.dunningBlockingReason = dunningBlockingReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REAcctDeterminationKey</b>
     * </p>
     * 
     * @param rEAcctDeterminationKey
     *            Account Determination Value
     */
    public void setREAcctDeterminationKey( @Nullable final java.lang.String rEAcctDeterminationKey )
    {
        rememberChangedField("REAcctDeterminationKey", this.rEAcctDeterminationKey);
        this.rEAcctDeterminationKey = rEAcctDeterminationKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETaxType</b>
     * </p>
     * 
     * @param rETaxType
     *            Tax Type
     */
    public void setRETaxType( @Nullable final java.lang.String rETaxType )
    {
        rememberChangedField("RETaxType", this.rETaxType);
        this.rETaxType = rETaxType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TaxGroup</b>
     * </p>
     * 
     * @param taxGroup
     *            Tax Group
     */
    public void setTaxGroup( @Nullable final java.lang.String taxGroup )
    {
        rememberChangedField("TaxGroup", this.taxGroup);
        this.taxGroup = taxGroup;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsConditionGrossAmount</b>
     * </p>
     * 
     * @param rEIsConditionGrossAmount
     *            Condition Amount Is Gross Amount
     */
    public void setREIsConditionGrossAmount( @Nullable final java.lang.Boolean rEIsConditionGrossAmount )
    {
        rememberChangedField("REIsConditionGrossAmount", this.rEIsConditionGrossAmount);
        this.rEIsConditionGrossAmount = rEIsConditionGrossAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     * 
     * @param taxCountry
     *            Alternative Tax Reporting Country
     */
    public void setTaxCountry( @Nullable final java.lang.String taxCountry )
    {
        rememberChangedField("TaxCountry", this.taxCountry);
        this.taxCountry = taxCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final java.lang.String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REAccountingObject</b>
     * </p>
     * 
     * @param rEAccountingObject
     *            Object Number for Internal Use
     */
    public void setREAccountingObject( @Nullable final java.lang.String rEAccountingObject )
    {
        rememberChangedField("REAccountingObject", this.rEAccountingObject);
        this.rEAccountingObject = rEAccountingObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     * 
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final java.lang.String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsConditionSplit</b>
     * </p>
     * 
     * @param rEIsConditionSplit
     *            Condition Split
     */
    public void setREIsConditionSplit( @Nullable final java.lang.Boolean rEIsConditionSplit )
    {
        rememberChangedField("REIsConditionSplit", this.rEIsConditionSplit);
        this.rEIsConditionSplit = rEIsConditionSplit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RECurrencyTranslationRule</b>
     * </p>
     * 
     * @param rECurrencyTranslationRule
     *            Currency Translation Rule
     */
    public void setRECurrencyTranslationRule( @Nullable final java.lang.String rECurrencyTranslationRule )
    {
        rememberChangedField("RECurrencyTranslationRule", this.rECurrencyTranslationRule);
        this.rECurrencyTranslationRule = rECurrencyTranslationRule;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsPartnerBlocked</b>
     * </p>
     * 
     * @param rEIsPartnerBlocked
     *            Lock of Partner Data in Posting Term
     */
    public void setREIsPartnerBlocked( @Nullable final java.lang.Boolean rEIsPartnerBlocked )
    {
        rememberChangedField("REIsPartnerBlocked", this.rEIsPartnerBlocked);
        this.rEIsPartnerBlocked = rEIsPartnerBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     * 
     * @param sEPAMandate
     *            SEPA Mandate: Unique Reference to Mandate per Vendor
     */
    public void setSEPAMandate( @Nullable final java.lang.String sEPAMandate )
    {
        rememberChangedField("SEPAMandate", this.sEPAMandate);
        this.sEPAMandate = sEPAMandate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateCreditor</b>
     * </p>
     * 
     * @param sEPAMandateCreditor
     *            SEPA Mandate: Creditor ID
     */
    public void setSEPAMandateCreditor( @Nullable final java.lang.String sEPAMandateCreditor )
    {
        rememberChangedField("SEPAMandateCreditor", this.sEPAMandateCreditor);
        this.sEPAMandateCreditor = sEPAMandateCreditor;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrPostingTerm";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        entityKey.addKeyProperty("RETermType", getRETermType());
        entityKey.addKeyProperty("RETermNumber", getRETermNumber());
        entityKey.addKeyProperty("ValidityStartEndDateValue", getValidityStartEndDateValue());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("RETermType", getRETermType());
        values.put("RETermNumber", getRETermNumber());
        values.put("ValidityStartEndDateValue", getValidityStartEndDateValue());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("RETermName", getRETermName());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("REPaymentMethodCreditMemo", getREPaymentMethodCreditMemo());
        values.put("PaymentBlockingReason", getPaymentBlockingReason());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("HouseBank", getHouseBank());
        values.put("HouseBankAccount", getHouseBankAccount());
        values.put("BankIdentification", getBankIdentification());
        values.put("RENoteToPayeeText", getRENoteToPayeeText());
        values.put("DunningArea", getDunningArea());
        values.put("DunningKey", getDunningKey());
        values.put("DunningBlockingReason", getDunningBlockingReason());
        values.put("REAcctDeterminationKey", getREAcctDeterminationKey());
        values.put("RETaxType", getRETaxType());
        values.put("TaxGroup", getTaxGroup());
        values.put("REIsConditionGrossAmount", getREIsConditionGrossAmount());
        values.put("TaxCountry", getTaxCountry());
        values.put("BusinessPartner", getBusinessPartner());
        values.put("REAccountingObject", getREAccountingObject());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("REIsConditionSplit", getREIsConditionSplit());
        values.put("RECurrencyTranslationRule", getRECurrencyTranslationRule());
        values.put("REIsPartnerBlocked", getREIsPartnerBlocked());
        values.put("SEPAMandate", getSEPAMandate());
        values.put("SEPAMandateCreditor", getSEPAMandateCreditor());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermType") ) {
                final Object value = values.remove("RETermType");
                if( (value == null) || (!value.equals(getRETermType())) ) {
                    setRETermType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermNumber") ) {
                final Object value = values.remove("RETermNumber");
                if( (value == null) || (!value.equals(getRETermNumber())) ) {
                    setRETermNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartEndDateValue") ) {
                final Object value = values.remove("ValidityStartEndDateValue");
                if( (value == null) || (!value.equals(getValidityStartEndDateValue())) ) {
                    setValidityStartEndDateValue(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("RETermName") ) {
                final Object value = values.remove("RETermName");
                if( (value == null) || (!value.equals(getRETermName())) ) {
                    setRETermName(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((java.lang.String) value));
                }
            }
            if( values.containsKey("REPaymentMethodCreditMemo") ) {
                final Object value = values.remove("REPaymentMethodCreditMemo");
                if( (value == null) || (!value.equals(getREPaymentMethodCreditMemo())) ) {
                    setREPaymentMethodCreditMemo(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentBlockingReason") ) {
                final Object value = values.remove("PaymentBlockingReason");
                if( (value == null) || (!value.equals(getPaymentBlockingReason())) ) {
                    setPaymentBlockingReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((java.lang.String) value));
                }
            }
            if( values.containsKey("HouseBank") ) {
                final Object value = values.remove("HouseBank");
                if( (value == null) || (!value.equals(getHouseBank())) ) {
                    setHouseBank(((java.lang.String) value));
                }
            }
            if( values.containsKey("HouseBankAccount") ) {
                final Object value = values.remove("HouseBankAccount");
                if( (value == null) || (!value.equals(getHouseBankAccount())) ) {
                    setHouseBankAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("BankIdentification") ) {
                final Object value = values.remove("BankIdentification");
                if( (value == null) || (!value.equals(getBankIdentification())) ) {
                    setBankIdentification(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENoteToPayeeText") ) {
                final Object value = values.remove("RENoteToPayeeText");
                if( (value == null) || (!value.equals(getRENoteToPayeeText())) ) {
                    setRENoteToPayeeText(((java.lang.String) value));
                }
            }
            if( values.containsKey("DunningArea") ) {
                final Object value = values.remove("DunningArea");
                if( (value == null) || (!value.equals(getDunningArea())) ) {
                    setDunningArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("DunningKey") ) {
                final Object value = values.remove("DunningKey");
                if( (value == null) || (!value.equals(getDunningKey())) ) {
                    setDunningKey(((java.lang.String) value));
                }
            }
            if( values.containsKey("DunningBlockingReason") ) {
                final Object value = values.remove("DunningBlockingReason");
                if( (value == null) || (!value.equals(getDunningBlockingReason())) ) {
                    setDunningBlockingReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAcctDeterminationKey") ) {
                final Object value = values.remove("REAcctDeterminationKey");
                if( (value == null) || (!value.equals(getREAcctDeterminationKey())) ) {
                    setREAcctDeterminationKey(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETaxType") ) {
                final Object value = values.remove("RETaxType");
                if( (value == null) || (!value.equals(getRETaxType())) ) {
                    setRETaxType(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxGroup") ) {
                final Object value = values.remove("TaxGroup");
                if( (value == null) || (!value.equals(getTaxGroup())) ) {
                    setTaxGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("REIsConditionGrossAmount") ) {
                final Object value = values.remove("REIsConditionGrossAmount");
                if( (value == null) || (!value.equals(getREIsConditionGrossAmount())) ) {
                    setREIsConditionGrossAmount(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("TaxCountry") ) {
                final Object value = values.remove("TaxCountry");
                if( (value == null) || (!value.equals(getTaxCountry())) ) {
                    setTaxCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAccountingObject") ) {
                final Object value = values.remove("REAccountingObject");
                if( (value == null) || (!value.equals(getREAccountingObject())) ) {
                    setREAccountingObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((java.lang.String) value));
                }
            }
            if( values.containsKey("REIsConditionSplit") ) {
                final Object value = values.remove("REIsConditionSplit");
                if( (value == null) || (!value.equals(getREIsConditionSplit())) ) {
                    setREIsConditionSplit(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("RECurrencyTranslationRule") ) {
                final Object value = values.remove("RECurrencyTranslationRule");
                if( (value == null) || (!value.equals(getRECurrencyTranslationRule())) ) {
                    setRECurrencyTranslationRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("REIsPartnerBlocked") ) {
                final Object value = values.remove("REIsPartnerBlocked");
                if( (value == null) || (!value.equals(getREIsPartnerBlocked())) ) {
                    setREIsPartnerBlocked(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("SEPAMandate") ) {
                final Object value = values.remove("SEPAMandate");
                if( (value == null) || (!value.equals(getSEPAMandate())) ) {
                    setSEPAMandate(((java.lang.String) value));
                }
            }
            if( values.containsKey("SEPAMandateCreditor") ) {
                final Object value = values.remove("SEPAMandateCreditor");
                if( (value == null) || (!value.equals(getSEPAMandateCreditor())) ) {
                    setSEPAMandateCreditor(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrPostingTerm</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrPostingTerm instances.
     * 
     */
    public final static class REContrPostingTermBuilder
    {

        private REContract to_REContract;

        private REContrPostingTerm.REContrPostingTermBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrPostingTerm</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrPostingTerm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrPostingTerm.REContrPostingTermBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
