/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrReminderDateType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrReminderDate extends VdmEntity<REContrReminderDate> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrReminderDateType";
    /**
     * Selector for all available fields of REContrReminderDate.
     * 
     */
    public final static SimpleProperty<REContrReminderDate> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrReminderDate> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrReminderDate>(REContrReminderDate.class, "InternalRealEstateNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderNumber</b>
     * </p>
     * 
     * @return Identification Number of Reminder Rule
     */
    @Nullable
    @ElementName( "REReminderNumber" )
    private java.lang.String rEReminderNumber;
    public final static SimpleProperty.String<REContrReminderDate> RE_REMINDER_NUMBER =
        new SimpleProperty.String<REContrReminderDate>(REContrReminderDate.class, "REReminderNumber");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderDate</b>
     * </p>
     * 
     * @return Reminder Date
     */
    @Nullable
    @ElementName( "REReminderDate" )
    private LocalDate rEReminderDate;
    public final static SimpleProperty.Date<REContrReminderDate> RE_REMINDER_DATE =
        new SimpleProperty.Date<REContrReminderDate>(REContrReminderDate.class, "REReminderDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderRule</b>
     * </p>
     * 
     * @return Reminder Rule
     */
    @Nullable
    @ElementName( "REReminderRule" )
    private java.lang.String rEReminderRule;
    public final static SimpleProperty.String<REContrReminderDate> RE_REMINDER_RULE =
        new SimpleProperty.String<REContrReminderDate>(REContrReminderDate.class, "REReminderRule");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderReason</b>
     * </p>
     * 
     * @return Reminder Reason
     */
    @Nullable
    @ElementName( "REReminderReason" )
    private java.lang.String rEReminderReason;
    public final static SimpleProperty.String<REContrReminderDate> RE_REMINDER_REASON =
        new SimpleProperty.String<REContrReminderDate>(REContrReminderDate.class, "REReminderReason");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Entered By
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<REContrReminderDate> CREATED_BY_USER =
        new SimpleProperty.String<REContrReminderDate>(REContrReminderDate.class, "CreatedByUser");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return First Entered On
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<REContrReminderDate> CREATION_DATE =
        new SimpleProperty.Date<REContrReminderDate>(REContrReminderDate.class, "CreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @return Time of Creation
     */
    @Nullable
    @ElementName( "CreationTime" )
    private LocalTime creationTime;
    public final static SimpleProperty.Time<REContrReminderDate> CREATION_TIME =
        new SimpleProperty.Time<REContrReminderDate>(REContrReminderDate.class, "CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RESourceOfCreation</b>
     * </p>
     * 
     * @return Source of Initial Entry
     */
    @Nullable
    @ElementName( "RESourceOfCreation" )
    private java.lang.String rESourceOfCreation;
    public final static SimpleProperty.String<REContrReminderDate> RE_SOURCE_OF_CREATION =
        new SimpleProperty.String<REContrReminderDate>(REContrReminderDate.class, "RESourceOfCreation");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Employee ID
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<REContrReminderDate> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<REContrReminderDate>(REContrReminderDate.class, "LastChangedByUser");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     * 
     * @return Last Edited On
     */
    @Nullable
    @ElementName( "LastChangeDate" )
    private LocalDate lastChangeDate;
    public final static SimpleProperty.Date<REContrReminderDate> LAST_CHANGE_DATE =
        new SimpleProperty.Date<REContrReminderDate>(REContrReminderDate.class, "LastChangeDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     * 
     * @return Last Edited At
     */
    @Nullable
    @ElementName( "LastChangeTime" )
    private LocalTime lastChangeTime;
    public final static SimpleProperty.Time<REContrReminderDate> LAST_CHANGE_TIME =
        new SimpleProperty.Time<REContrReminderDate>(REContrReminderDate.class, "LastChangeTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RESourceOfChange</b>
     * </p>
     * 
     * @return Editing Source
     */
    @Nullable
    @ElementName( "RESourceOfChange" )
    private java.lang.String rESourceOfChange;
    public final static SimpleProperty.String<REContrReminderDate> RE_SOURCE_OF_CHANGE =
        new SimpleProperty.String<REContrReminderDate>(REContrReminderDate.class, "RESourceOfChange");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Responsible</b>
     * </p>
     * 
     * @return Person Responsible
     */
    @Nullable
    @ElementName( "Responsible" )
    private java.lang.String responsible;
    public final static SimpleProperty.String<REContrReminderDate> RESPONSIBLE =
        new SimpleProperty.String<REContrReminderDate>(REContrReminderDate.class, "Responsible");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderWrkflwDate</b>
     * </p>
     * 
     * @return Date on which workflow event was created
     */
    @Nullable
    @ElementName( "REReminderWrkflwDate" )
    private LocalDate rEReminderWrkflwDate;
    public final static SimpleProperty.Date<REContrReminderDate> RE_REMINDER_WRKFLW_DATE =
        new SimpleProperty.Date<REContrReminderDate>(REContrReminderDate.class, "REReminderWrkflwDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderIsDone</b>
     * </p>
     * 
     * @return Reminder Date Completed
     */
    @Nullable
    @ElementName( "REReminderIsDone" )
    private java.lang.Boolean rEReminderIsDone;
    public final static SimpleProperty.Boolean<REContrReminderDate> RE_REMINDER_IS_DONE =
        new SimpleProperty.Boolean<REContrReminderDate>(REContrReminderDate.class, "REReminderIsDone");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderIsFix</b>
     * </p>
     * 
     * @return Reminder Date Fixed
     */
    @Nullable
    @ElementName( "REReminderIsFix" )
    private java.lang.Boolean rEReminderIsFix;
    public final static SimpleProperty.Boolean<REContrReminderDate> RE_REMINDER_IS_FIX =
        new SimpleProperty.Boolean<REContrReminderDate>(REContrReminderDate.class, "REReminderIsFix");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderIsWrkflwSend</b>
     * </p>
     * 
     * @return Send workflow event
     */
    @Nullable
    @ElementName( "REReminderIsWrkflwSend" )
    private java.lang.Boolean rEReminderIsWrkflwSend;
    public final static SimpleProperty.Boolean<REContrReminderDate> RE_REMINDER_IS_WRKFLW_SEND =
        new SimpleProperty.Boolean<REContrReminderDate>(REContrReminderDate.class, "REReminderIsWrkflwSend");
    /**
     * Constraints: Not nullable, Maximum length: 45
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectKey</b>
     * </p>
     * 
     * @return ID Part Key, for example "1000/123"
     */
    @Nullable
    @ElementName( "TextObjectKey" )
    private java.lang.String textObjectKey;
    public final static SimpleProperty.String<REContrReminderDate> TEXT_OBJECT_KEY =
        new SimpleProperty.String<REContrReminderDate>(REContrReminderDate.class, "TextObjectKey");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>REReminderInfoText</b>
     * </p>
     * 
     * @return Memo for Reminder Date
     */
    @Nullable
    @ElementName( "REReminderInfoText" )
    private java.lang.String rEReminderInfoText;
    public final static SimpleProperty.String<REContrReminderDate> RE_REMINDER_INFO_TEXT =
        new SimpleProperty.String<REContrReminderDate>(REContrReminderDate.class, "REReminderInfoText");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrReminderDate, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrReminderDate, SAP__Message>(
            REContrReminderDate.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrReminderDate</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrReminderDate, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrReminderDate, REContract>(
            REContrReminderDate.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrReminderDate> getType()
    {
        return REContrReminderDate.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderNumber</b>
     * </p>
     * 
     * @param rEReminderNumber
     *            Identification Number of Reminder Rule
     */
    public void setREReminderNumber( @Nullable final java.lang.String rEReminderNumber )
    {
        rememberChangedField("REReminderNumber", this.rEReminderNumber);
        this.rEReminderNumber = rEReminderNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderDate</b>
     * </p>
     * 
     * @param rEReminderDate
     *            Reminder Date
     */
    public void setREReminderDate( @Nullable final LocalDate rEReminderDate )
    {
        rememberChangedField("REReminderDate", this.rEReminderDate);
        this.rEReminderDate = rEReminderDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderRule</b>
     * </p>
     * 
     * @param rEReminderRule
     *            Reminder Rule
     */
    public void setREReminderRule( @Nullable final java.lang.String rEReminderRule )
    {
        rememberChangedField("REReminderRule", this.rEReminderRule);
        this.rEReminderRule = rEReminderRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderReason</b>
     * </p>
     * 
     * @param rEReminderReason
     *            Reminder Reason
     */
    public void setREReminderReason( @Nullable final java.lang.String rEReminderReason )
    {
        rememberChangedField("REReminderReason", this.rEReminderReason);
        this.rEReminderReason = rEReminderReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Entered By
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            First Entered On
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @param creationTime
     *            Time of Creation
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RESourceOfCreation</b>
     * </p>
     * 
     * @param rESourceOfCreation
     *            Source of Initial Entry
     */
    public void setRESourceOfCreation( @Nullable final java.lang.String rESourceOfCreation )
    {
        rememberChangedField("RESourceOfCreation", this.rESourceOfCreation);
        this.rESourceOfCreation = rESourceOfCreation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Employee ID
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     * 
     * @param lastChangeDate
     *            Last Edited On
     */
    public void setLastChangeDate( @Nullable final LocalDate lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     * 
     * @param lastChangeTime
     *            Last Edited At
     */
    public void setLastChangeTime( @Nullable final LocalTime lastChangeTime )
    {
        rememberChangedField("LastChangeTime", this.lastChangeTime);
        this.lastChangeTime = lastChangeTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RESourceOfChange</b>
     * </p>
     * 
     * @param rESourceOfChange
     *            Editing Source
     */
    public void setRESourceOfChange( @Nullable final java.lang.String rESourceOfChange )
    {
        rememberChangedField("RESourceOfChange", this.rESourceOfChange);
        this.rESourceOfChange = rESourceOfChange;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Responsible</b>
     * </p>
     * 
     * @param responsible
     *            Person Responsible
     */
    public void setResponsible( @Nullable final java.lang.String responsible )
    {
        rememberChangedField("Responsible", this.responsible);
        this.responsible = responsible;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderWrkflwDate</b>
     * </p>
     * 
     * @param rEReminderWrkflwDate
     *            Date on which workflow event was created
     */
    public void setREReminderWrkflwDate( @Nullable final LocalDate rEReminderWrkflwDate )
    {
        rememberChangedField("REReminderWrkflwDate", this.rEReminderWrkflwDate);
        this.rEReminderWrkflwDate = rEReminderWrkflwDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderIsDone</b>
     * </p>
     * 
     * @param rEReminderIsDone
     *            Reminder Date Completed
     */
    public void setREReminderIsDone( @Nullable final java.lang.Boolean rEReminderIsDone )
    {
        rememberChangedField("REReminderIsDone", this.rEReminderIsDone);
        this.rEReminderIsDone = rEReminderIsDone;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderIsFix</b>
     * </p>
     * 
     * @param rEReminderIsFix
     *            Reminder Date Fixed
     */
    public void setREReminderIsFix( @Nullable final java.lang.Boolean rEReminderIsFix )
    {
        rememberChangedField("REReminderIsFix", this.rEReminderIsFix);
        this.rEReminderIsFix = rEReminderIsFix;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderIsWrkflwSend</b>
     * </p>
     * 
     * @param rEReminderIsWrkflwSend
     *            Send workflow event
     */
    public void setREReminderIsWrkflwSend( @Nullable final java.lang.Boolean rEReminderIsWrkflwSend )
    {
        rememberChangedField("REReminderIsWrkflwSend", this.rEReminderIsWrkflwSend);
        this.rEReminderIsWrkflwSend = rEReminderIsWrkflwSend;
    }

    /**
     * Constraints: Not nullable, Maximum length: 45
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectKey</b>
     * </p>
     * 
     * @param textObjectKey
     *            ID Part Key, for example "1000/123"
     */
    public void setTextObjectKey( @Nullable final java.lang.String textObjectKey )
    {
        rememberChangedField("TextObjectKey", this.textObjectKey);
        this.textObjectKey = textObjectKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>REReminderInfoText</b>
     * </p>
     * 
     * @param rEReminderInfoText
     *            Memo for Reminder Date
     */
    public void setREReminderInfoText( @Nullable final java.lang.String rEReminderInfoText )
    {
        rememberChangedField("REReminderInfoText", this.rEReminderInfoText);
        this.rEReminderInfoText = rEReminderInfoText;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrReminderDate";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        entityKey.addKeyProperty("REReminderNumber", getREReminderNumber());
        entityKey.addKeyProperty("REReminderDate", getREReminderDate());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("REReminderNumber", getREReminderNumber());
        values.put("REReminderDate", getREReminderDate());
        values.put("REReminderRule", getREReminderRule());
        values.put("REReminderReason", getREReminderReason());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("RESourceOfCreation", getRESourceOfCreation());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeTime", getLastChangeTime());
        values.put("RESourceOfChange", getRESourceOfChange());
        values.put("Responsible", getResponsible());
        values.put("REReminderWrkflwDate", getREReminderWrkflwDate());
        values.put("REReminderIsDone", getREReminderIsDone());
        values.put("REReminderIsFix", getREReminderIsFix());
        values.put("REReminderIsWrkflwSend", getREReminderIsWrkflwSend());
        values.put("TextObjectKey", getTextObjectKey());
        values.put("REReminderInfoText", getREReminderInfoText());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("REReminderNumber") ) {
                final Object value = values.remove("REReminderNumber");
                if( (value == null) || (!value.equals(getREReminderNumber())) ) {
                    setREReminderNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("REReminderDate") ) {
                final Object value = values.remove("REReminderDate");
                if( (value == null) || (!value.equals(getREReminderDate())) ) {
                    setREReminderDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REReminderRule") ) {
                final Object value = values.remove("REReminderRule");
                if( (value == null) || (!value.equals(getREReminderRule())) ) {
                    setREReminderRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("REReminderReason") ) {
                final Object value = values.remove("REReminderReason");
                if( (value == null) || (!value.equals(getREReminderReason())) ) {
                    setREReminderReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("RESourceOfCreation") ) {
                final Object value = values.remove("RESourceOfCreation");
                if( (value == null) || (!value.equals(getRESourceOfCreation())) ) {
                    setRESourceOfCreation(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDate) value));
                }
            }
            if( values.containsKey("LastChangeTime") ) {
                final Object value = values.remove("LastChangeTime");
                if( (value == null) || (!value.equals(getLastChangeTime())) ) {
                    setLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("RESourceOfChange") ) {
                final Object value = values.remove("RESourceOfChange");
                if( (value == null) || (!value.equals(getRESourceOfChange())) ) {
                    setRESourceOfChange(((java.lang.String) value));
                }
            }
            if( values.containsKey("Responsible") ) {
                final Object value = values.remove("Responsible");
                if( (value == null) || (!value.equals(getResponsible())) ) {
                    setResponsible(((java.lang.String) value));
                }
            }
            if( values.containsKey("REReminderWrkflwDate") ) {
                final Object value = values.remove("REReminderWrkflwDate");
                if( (value == null) || (!value.equals(getREReminderWrkflwDate())) ) {
                    setREReminderWrkflwDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REReminderIsDone") ) {
                final Object value = values.remove("REReminderIsDone");
                if( (value == null) || (!value.equals(getREReminderIsDone())) ) {
                    setREReminderIsDone(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REReminderIsFix") ) {
                final Object value = values.remove("REReminderIsFix");
                if( (value == null) || (!value.equals(getREReminderIsFix())) ) {
                    setREReminderIsFix(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REReminderIsWrkflwSend") ) {
                final Object value = values.remove("REReminderIsWrkflwSend");
                if( (value == null) || (!value.equals(getREReminderIsWrkflwSend())) ) {
                    setREReminderIsWrkflwSend(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("TextObjectKey") ) {
                final Object value = values.remove("TextObjectKey");
                if( (value == null) || (!value.equals(getTextObjectKey())) ) {
                    setTextObjectKey(((java.lang.String) value));
                }
            }
            if( values.containsKey("REReminderInfoText") ) {
                final Object value = values.remove("REReminderInfoText");
                if( (value == null) || (!value.equals(getREReminderInfoText())) ) {
                    setREReminderInfoText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrReminderDate</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrReminderDate instances.
     * 
     */
    public final static class REContrReminderDateBuilder
    {

        private REContract to_REContract;

        private REContrReminderDate.REContrReminderDateBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrReminderDate</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrReminderDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrReminderDate.REContrReminderDateBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
