/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrReminderRuleType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrReminderRule extends VdmEntity<REContrReminderRule> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrReminderRuleType";
    /**
     * Selector for all available fields of REContrReminderRule.
     * 
     */
    public final static SimpleProperty<REContrReminderRule> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrReminderRule> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrReminderRule>(REContrReminderRule.class, "InternalRealEstateNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderNumber</b>
     * </p>
     * 
     * @return Identification Number of Reminder Rule
     */
    @Nullable
    @ElementName( "REReminderNumber" )
    private java.lang.String rEReminderNumber;
    public final static SimpleProperty.String<REContrReminderRule> RE_REMINDER_NUMBER =
        new SimpleProperty.String<REContrReminderRule>(REContrReminderRule.class, "REReminderNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REReminderRuleParamNumber</b>
     * </p>
     * 
     * @return Number of Parameter of Reminder Rule
     */
    @Nullable
    @ElementName( "REReminderRuleParamNumber" )
    private java.lang.String rEReminderRuleParamNumber;
    public final static SimpleProperty.String<REContrReminderRule> RE_REMINDER_RULE_PARAM_NUMBER =
        new SimpleProperty.String<REContrReminderRule>(REContrReminderRule.class, "REReminderRuleParamNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderRule</b>
     * </p>
     * 
     * @return Reminder Rule
     */
    @Nullable
    @ElementName( "REReminderRule" )
    private java.lang.String rEReminderRule;
    public final static SimpleProperty.String<REContrReminderRule> RE_REMINDER_RULE =
        new SimpleProperty.String<REContrReminderRule>(REContrReminderRule.class, "REReminderRule");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderReason</b>
     * </p>
     * 
     * @return Reminder Reason
     */
    @Nullable
    @ElementName( "REReminderReason" )
    private java.lang.String rEReminderReason;
    public final static SimpleProperty.String<REContrReminderRule> RE_REMINDER_REASON =
        new SimpleProperty.String<REContrReminderRule>(REContrReminderRule.class, "REReminderReason");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<REContrReminderRule> VALIDITY_START_DATE =
        new SimpleProperty.Date<REContrReminderRule>(REContrReminderRule.class, "ValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<REContrReminderRule> VALIDITY_END_DATE =
        new SimpleProperty.Date<REContrReminderRule>(REContrReminderRule.class, "ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REReminderParamType</b>
     * </p>
     * 
     * @return Type of Parameter of Reminder Rule
     */
    @Nullable
    @ElementName( "REReminderParamType" )
    private java.lang.String rEReminderParamType;
    public final static SimpleProperty.String<REContrReminderRule> RE_REMINDER_PARAM_TYPE =
        new SimpleProperty.String<REContrReminderRule>(REContrReminderRule.class, "REReminderParamType");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderParamDate</b>
     * </p>
     * 
     * @return Parameter of Reminder Rule: Date
     */
    @Nullable
    @ElementName( "REReminderParamDate" )
    private LocalDate rEReminderParamDate;
    public final static SimpleProperty.Date<REContrReminderRule> RE_REMINDER_PARAM_DATE =
        new SimpleProperty.Date<REContrReminderRule>(REContrReminderRule.class, "REReminderParamDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderParamNmbr</b>
     * </p>
     * 
     * @return Parameter of Reminder Rule: Number
     */
    @Nullable
    @ElementName( "REReminderParamNmbr" )
    private java.lang.String rEReminderParamNmbr;
    public final static SimpleProperty.String<REContrReminderRule> RE_REMINDER_PARAM_NMBR =
        new SimpleProperty.String<REContrReminderRule>(REContrReminderRule.class, "REReminderParamNmbr");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderParamIsBoolean</b>
     * </p>
     * 
     * @return Parameter of Reminder Rule: Y/N Field
     */
    @Nullable
    @ElementName( "REReminderParamIsBoolean" )
    private java.lang.Boolean rEReminderParamIsBoolean;
    public final static SimpleProperty.Boolean<REContrReminderRule> RE_REMINDER_PARAM_IS_BOOLEAN =
        new SimpleProperty.Boolean<REContrReminderRule>(REContrReminderRule.class, "REReminderParamIsBoolean");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>REReminderParamName</b>
     * </p>
     * 
     * @return Name of Parameter of Resubmission Rule
     */
    @Nullable
    @ElementName( "REReminderParamName" )
    private java.lang.String rEReminderParamName;
    public final static SimpleProperty.String<REContrReminderRule> RE_REMINDER_PARAM_NAME =
        new SimpleProperty.String<REContrReminderRule>(REContrReminderRule.class, "REReminderParamName");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrReminderRule, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrReminderRule, SAP__Message>(
            REContrReminderRule.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrReminderRule</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrReminderRule, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrReminderRule, REContract>(
            REContrReminderRule.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrReminderRule> getType()
    {
        return REContrReminderRule.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderNumber</b>
     * </p>
     * 
     * @param rEReminderNumber
     *            Identification Number of Reminder Rule
     */
    public void setREReminderNumber( @Nullable final java.lang.String rEReminderNumber )
    {
        rememberChangedField("REReminderNumber", this.rEReminderNumber);
        this.rEReminderNumber = rEReminderNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REReminderRuleParamNumber</b>
     * </p>
     * 
     * @param rEReminderRuleParamNumber
     *            Number of Parameter of Reminder Rule
     */
    public void setREReminderRuleParamNumber( @Nullable final java.lang.String rEReminderRuleParamNumber )
    {
        rememberChangedField("REReminderRuleParamNumber", this.rEReminderRuleParamNumber);
        this.rEReminderRuleParamNumber = rEReminderRuleParamNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderRule</b>
     * </p>
     * 
     * @param rEReminderRule
     *            Reminder Rule
     */
    public void setREReminderRule( @Nullable final java.lang.String rEReminderRule )
    {
        rememberChangedField("REReminderRule", this.rEReminderRule);
        this.rEReminderRule = rEReminderRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderReason</b>
     * </p>
     * 
     * @param rEReminderReason
     *            Reminder Reason
     */
    public void setREReminderReason( @Nullable final java.lang.String rEReminderReason )
    {
        rememberChangedField("REReminderReason", this.rEReminderReason);
        this.rEReminderReason = rEReminderReason;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REReminderParamType</b>
     * </p>
     * 
     * @param rEReminderParamType
     *            Type of Parameter of Reminder Rule
     */
    public void setREReminderParamType( @Nullable final java.lang.String rEReminderParamType )
    {
        rememberChangedField("REReminderParamType", this.rEReminderParamType);
        this.rEReminderParamType = rEReminderParamType;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderParamDate</b>
     * </p>
     * 
     * @param rEReminderParamDate
     *            Parameter of Reminder Rule: Date
     */
    public void setREReminderParamDate( @Nullable final LocalDate rEReminderParamDate )
    {
        rememberChangedField("REReminderParamDate", this.rEReminderParamDate);
        this.rEReminderParamDate = rEReminderParamDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REReminderParamNmbr</b>
     * </p>
     * 
     * @param rEReminderParamNmbr
     *            Parameter of Reminder Rule: Number
     */
    public void setREReminderParamNmbr( @Nullable final java.lang.String rEReminderParamNmbr )
    {
        rememberChangedField("REReminderParamNmbr", this.rEReminderParamNmbr);
        this.rEReminderParamNmbr = rEReminderParamNmbr;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REReminderParamIsBoolean</b>
     * </p>
     * 
     * @param rEReminderParamIsBoolean
     *            Parameter of Reminder Rule: Y/N Field
     */
    public void setREReminderParamIsBoolean( @Nullable final java.lang.Boolean rEReminderParamIsBoolean )
    {
        rememberChangedField("REReminderParamIsBoolean", this.rEReminderParamIsBoolean);
        this.rEReminderParamIsBoolean = rEReminderParamIsBoolean;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>REReminderParamName</b>
     * </p>
     * 
     * @param rEReminderParamName
     *            Name of Parameter of Resubmission Rule
     */
    public void setREReminderParamName( @Nullable final java.lang.String rEReminderParamName )
    {
        rememberChangedField("REReminderParamName", this.rEReminderParamName);
        this.rEReminderParamName = rEReminderParamName;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrReminderRule";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        entityKey.addKeyProperty("REReminderNumber", getREReminderNumber());
        entityKey.addKeyProperty("REReminderRuleParamNumber", getREReminderRuleParamNumber());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("REReminderNumber", getREReminderNumber());
        values.put("REReminderRuleParamNumber", getREReminderRuleParamNumber());
        values.put("REReminderRule", getREReminderRule());
        values.put("REReminderReason", getREReminderReason());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("REReminderParamType", getREReminderParamType());
        values.put("REReminderParamDate", getREReminderParamDate());
        values.put("REReminderParamNmbr", getREReminderParamNmbr());
        values.put("REReminderParamIsBoolean", getREReminderParamIsBoolean());
        values.put("REReminderParamName", getREReminderParamName());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("REReminderNumber") ) {
                final Object value = values.remove("REReminderNumber");
                if( (value == null) || (!value.equals(getREReminderNumber())) ) {
                    setREReminderNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("REReminderRuleParamNumber") ) {
                final Object value = values.remove("REReminderRuleParamNumber");
                if( (value == null) || (!value.equals(getREReminderRuleParamNumber())) ) {
                    setREReminderRuleParamNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("REReminderRule") ) {
                final Object value = values.remove("REReminderRule");
                if( (value == null) || (!value.equals(getREReminderRule())) ) {
                    setREReminderRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("REReminderReason") ) {
                final Object value = values.remove("REReminderReason");
                if( (value == null) || (!value.equals(getREReminderReason())) ) {
                    setREReminderReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REReminderParamType") ) {
                final Object value = values.remove("REReminderParamType");
                if( (value == null) || (!value.equals(getREReminderParamType())) ) {
                    setREReminderParamType(((java.lang.String) value));
                }
            }
            if( values.containsKey("REReminderParamDate") ) {
                final Object value = values.remove("REReminderParamDate");
                if( (value == null) || (!value.equals(getREReminderParamDate())) ) {
                    setREReminderParamDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REReminderParamNmbr") ) {
                final Object value = values.remove("REReminderParamNmbr");
                if( (value == null) || (!value.equals(getREReminderParamNmbr())) ) {
                    setREReminderParamNmbr(((java.lang.String) value));
                }
            }
            if( values.containsKey("REReminderParamIsBoolean") ) {
                final Object value = values.remove("REReminderParamIsBoolean");
                if( (value == null) || (!value.equals(getREReminderParamIsBoolean())) ) {
                    setREReminderParamIsBoolean(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REReminderParamName") ) {
                final Object value = values.remove("REReminderParamName");
                if( (value == null) || (!value.equals(getREReminderParamName())) ) {
                    setREReminderParamName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrReminderRule</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrReminderRule instances.
     * 
     */
    public final static class REContrReminderRuleBuilder
    {

        private REContract to_REContract;

        private REContrReminderRule.REContrReminderRuleBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrReminderRule</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrReminderRule with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrReminderRule.REContrReminderRuleBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
