/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Renewal Terms
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrRenewalTermType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrRenewalTerm extends VdmEntity<REContrRenewalTerm> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrRenewalTermType";
    /**
     * Selector for all available fields of REContrRenewalTerm.
     * 
     */
    public final static SimpleProperty<REContrRenewalTerm> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrRenewalTerm> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "InternalRealEstateNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermType</b>
     * </p>
     * 
     * @return Term Category
     */
    @Nullable
    @ElementName( "RETermType" )
    private java.lang.String rETermType;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_TERM_TYPE =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RETermType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @return Term Number
     */
    @Nullable
    @ElementName( "RETermNumber" )
    private java.lang.String rETermNumber;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_TERM_NUMBER =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RETermNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalType</b>
     * </p>
     * 
     * @return Type of Renewal of Real Estate Contract
     */
    @Nullable
    @ElementName( "RERenewalType" )
    private java.lang.String rERenewalType;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_RENEWAL_TYPE =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RERenewalType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalSequenceNumber</b>
     * </p>
     * 
     * @return Sequence Number of Extension Period
     */
    @Nullable
    @ElementName( "RERenewalSequenceNumber" )
    private java.lang.String rERenewalSequenceNumber;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_RENEWAL_SEQUENCE_NUMBER =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RERenewalSequenceNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalRuleType</b>
     * </p>
     * 
     * @return Type of Renewal Rule
     */
    @Nullable
    @ElementName( "RERenewalRuleType" )
    private java.lang.String rERenewalRuleType;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_RENEWAL_RULE_TYPE =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RERenewalRuleType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @return Name of Term
     */
    @Nullable
    @ElementName( "RETermName" )
    private java.lang.String rETermName;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_TERM_NAME =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RETermName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalRule</b>
     * </p>
     * 
     * @return Renewal Rule
     */
    @Nullable
    @ElementName( "RERenewalRule" )
    private java.lang.String rERenewalRule;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_RENEWAL_RULE =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RERenewalRule");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAutomaticRenewalType</b>
     * </p>
     * 
     * @return The rEAutomaticRenewalType contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "REAutomaticRenewalType" )
    private java.lang.String rEAutomaticRenewalType;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_AUTOMATIC_RENEWAL_TYPE =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "REAutomaticRenewalType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENumberOfRenewals</b>
     * </p>
     * 
     * @return Number of Renewals
     */
    @Nullable
    @ElementName( "RENumberOfRenewals" )
    private java.lang.String rENumberOfRenewals;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_NUMBER_OF_RENEWALS =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RENumberOfRenewals");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalPeriodInYears</b>
     * </p>
     * 
     * @return Contract Renewed for Number of Years
     */
    @Nullable
    @ElementName( "RERenewalPeriodInYears" )
    private java.lang.String rERenewalPeriodInYears;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_RENEWAL_PERIOD_IN_YEARS =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RERenewalPeriodInYears");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalPeriodInMonths</b>
     * </p>
     * 
     * @return Contract Renewed for Number of Months
     */
    @Nullable
    @ElementName( "RERenewalPeriodInMonths" )
    private java.lang.String rERenewalPeriodInMonths;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_RENEWAL_PERIOD_IN_MONTHS =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RERenewalPeriodInMonths");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalPeriodInDays</b>
     * </p>
     * 
     * @return Contract Renewed for Number of Days
     */
    @Nullable
    @ElementName( "RERenewalPeriodInDays" )
    private java.lang.String rERenewalPeriodInDays;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_RENEWAL_PERIOD_IN_DAYS =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RERenewalPeriodInDays");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalRoundingDateRule</b>
     * </p>
     * 
     * @return Rounding Rule for Determined Renewal Date
     */
    @Nullable
    @ElementName( "RERenewalRoundingDateRule" )
    private java.lang.String rERenewalRoundingDateRule;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_RENEWAL_ROUNDING_DATE_RULE =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RERenewalRoundingDateRule");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENotificationPeriodInYears</b>
     * </p>
     * 
     * @return Notification Must Be This No. of Years before Renewal Date
     */
    @Nullable
    @ElementName( "RENotificationPeriodInYears" )
    private java.lang.String rENotificationPeriodInYears;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_NOTIFICATION_PERIOD_IN_YEARS =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RENotificationPeriodInYears");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENotificationPeriodInMonths</b>
     * </p>
     * 
     * @return Notification Must Be This No. of Months before Renewal Date
     */
    @Nullable
    @ElementName( "RENotificationPeriodInMonths" )
    private java.lang.String rENotificationPeriodInMonths;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_NOTIFICATION_PERIOD_IN_MONTHS =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RENotificationPeriodInMonths");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENotificationPeriodInWeeks</b>
     * </p>
     * 
     * @return Notification Must Be This No. of Weeks before Renewal Date
     */
    @Nullable
    @ElementName( "RENotificationPeriodInWeeks" )
    private java.lang.String rENotificationPeriodInWeeks;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_NOTIFICATION_PERIOD_IN_WEEKS =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RENotificationPeriodInWeeks");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENotificationPeriodInDays</b>
     * </p>
     * 
     * @return Notification Must Be This No. of Days before Renewal Date
     */
    @Nullable
    @ElementName( "RENotificationPeriodInDays" )
    private java.lang.String rENotificationPeriodInDays;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_NOTIFICATION_PERIOD_IN_DAYS =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RENotificationPeriodInDays");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RENotificationRoundingDateRule</b>
     * </p>
     * 
     * @return Rounding Rule for Determined Notification Date
     */
    @Nullable
    @ElementName( "RENotificationRoundingDateRule" )
    private java.lang.String rENotificationRoundingDateRule;
    public final static SimpleProperty.String<REContrRenewalTerm> RE_NOTIFICATION_ROUNDING_DATE_RULE =
        new SimpleProperty.String<REContrRenewalTerm>(REContrRenewalTerm.class, "RENotificationRoundingDateRule");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrRenewalTerm, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrRenewalTerm, SAP__Message>(
            REContrRenewalTerm.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrRenewalTerm</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrRenewalTerm, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrRenewalTerm, REContract>(
            REContrRenewalTerm.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrRenewalTerm> getType()
    {
        return REContrRenewalTerm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermType</b>
     * </p>
     * 
     * @param rETermType
     *            Term Category
     */
    public void setRETermType( @Nullable final java.lang.String rETermType )
    {
        rememberChangedField("RETermType", this.rETermType);
        this.rETermType = rETermType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @param rETermNumber
     *            Term Number
     */
    public void setRETermNumber( @Nullable final java.lang.String rETermNumber )
    {
        rememberChangedField("RETermNumber", this.rETermNumber);
        this.rETermNumber = rETermNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalType</b>
     * </p>
     * 
     * @param rERenewalType
     *            Type of Renewal of Real Estate Contract
     */
    public void setRERenewalType( @Nullable final java.lang.String rERenewalType )
    {
        rememberChangedField("RERenewalType", this.rERenewalType);
        this.rERenewalType = rERenewalType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalSequenceNumber</b>
     * </p>
     * 
     * @param rERenewalSequenceNumber
     *            Sequence Number of Extension Period
     */
    public void setRERenewalSequenceNumber( @Nullable final java.lang.String rERenewalSequenceNumber )
    {
        rememberChangedField("RERenewalSequenceNumber", this.rERenewalSequenceNumber);
        this.rERenewalSequenceNumber = rERenewalSequenceNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalRuleType</b>
     * </p>
     * 
     * @param rERenewalRuleType
     *            Type of Renewal Rule
     */
    public void setRERenewalRuleType( @Nullable final java.lang.String rERenewalRuleType )
    {
        rememberChangedField("RERenewalRuleType", this.rERenewalRuleType);
        this.rERenewalRuleType = rERenewalRuleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @param rETermName
     *            Name of Term
     */
    public void setRETermName( @Nullable final java.lang.String rETermName )
    {
        rememberChangedField("RETermName", this.rETermName);
        this.rETermName = rETermName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalRule</b>
     * </p>
     * 
     * @param rERenewalRule
     *            Renewal Rule
     */
    public void setRERenewalRule( @Nullable final java.lang.String rERenewalRule )
    {
        rememberChangedField("RERenewalRule", this.rERenewalRule);
        this.rERenewalRule = rERenewalRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REAutomaticRenewalType</b>
     * </p>
     * 
     * @param rEAutomaticRenewalType
     *            The rEAutomaticRenewalType to set.
     */
    public void setREAutomaticRenewalType( @Nullable final java.lang.String rEAutomaticRenewalType )
    {
        rememberChangedField("REAutomaticRenewalType", this.rEAutomaticRenewalType);
        this.rEAutomaticRenewalType = rEAutomaticRenewalType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENumberOfRenewals</b>
     * </p>
     * 
     * @param rENumberOfRenewals
     *            Number of Renewals
     */
    public void setRENumberOfRenewals( @Nullable final java.lang.String rENumberOfRenewals )
    {
        rememberChangedField("RENumberOfRenewals", this.rENumberOfRenewals);
        this.rENumberOfRenewals = rENumberOfRenewals;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalPeriodInYears</b>
     * </p>
     * 
     * @param rERenewalPeriodInYears
     *            Contract Renewed for Number of Years
     */
    public void setRERenewalPeriodInYears( @Nullable final java.lang.String rERenewalPeriodInYears )
    {
        rememberChangedField("RERenewalPeriodInYears", this.rERenewalPeriodInYears);
        this.rERenewalPeriodInYears = rERenewalPeriodInYears;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalPeriodInMonths</b>
     * </p>
     * 
     * @param rERenewalPeriodInMonths
     *            Contract Renewed for Number of Months
     */
    public void setRERenewalPeriodInMonths( @Nullable final java.lang.String rERenewalPeriodInMonths )
    {
        rememberChangedField("RERenewalPeriodInMonths", this.rERenewalPeriodInMonths);
        this.rERenewalPeriodInMonths = rERenewalPeriodInMonths;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalPeriodInDays</b>
     * </p>
     * 
     * @param rERenewalPeriodInDays
     *            Contract Renewed for Number of Days
     */
    public void setRERenewalPeriodInDays( @Nullable final java.lang.String rERenewalPeriodInDays )
    {
        rememberChangedField("RERenewalPeriodInDays", this.rERenewalPeriodInDays);
        this.rERenewalPeriodInDays = rERenewalPeriodInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RERenewalRoundingDateRule</b>
     * </p>
     * 
     * @param rERenewalRoundingDateRule
     *            Rounding Rule for Determined Renewal Date
     */
    public void setRERenewalRoundingDateRule( @Nullable final java.lang.String rERenewalRoundingDateRule )
    {
        rememberChangedField("RERenewalRoundingDateRule", this.rERenewalRoundingDateRule);
        this.rERenewalRoundingDateRule = rERenewalRoundingDateRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENotificationPeriodInYears</b>
     * </p>
     * 
     * @param rENotificationPeriodInYears
     *            Notification Must Be This No. of Years before Renewal Date
     */
    public void setRENotificationPeriodInYears( @Nullable final java.lang.String rENotificationPeriodInYears )
    {
        rememberChangedField("RENotificationPeriodInYears", this.rENotificationPeriodInYears);
        this.rENotificationPeriodInYears = rENotificationPeriodInYears;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENotificationPeriodInMonths</b>
     * </p>
     * 
     * @param rENotificationPeriodInMonths
     *            Notification Must Be This No. of Months before Renewal Date
     */
    public void setRENotificationPeriodInMonths( @Nullable final java.lang.String rENotificationPeriodInMonths )
    {
        rememberChangedField("RENotificationPeriodInMonths", this.rENotificationPeriodInMonths);
        this.rENotificationPeriodInMonths = rENotificationPeriodInMonths;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENotificationPeriodInWeeks</b>
     * </p>
     * 
     * @param rENotificationPeriodInWeeks
     *            Notification Must Be This No. of Weeks before Renewal Date
     */
    public void setRENotificationPeriodInWeeks( @Nullable final java.lang.String rENotificationPeriodInWeeks )
    {
        rememberChangedField("RENotificationPeriodInWeeks", this.rENotificationPeriodInWeeks);
        this.rENotificationPeriodInWeeks = rENotificationPeriodInWeeks;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RENotificationPeriodInDays</b>
     * </p>
     * 
     * @param rENotificationPeriodInDays
     *            Notification Must Be This No. of Days before Renewal Date
     */
    public void setRENotificationPeriodInDays( @Nullable final java.lang.String rENotificationPeriodInDays )
    {
        rememberChangedField("RENotificationPeriodInDays", this.rENotificationPeriodInDays);
        this.rENotificationPeriodInDays = rENotificationPeriodInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RENotificationRoundingDateRule</b>
     * </p>
     * 
     * @param rENotificationRoundingDateRule
     *            Rounding Rule for Determined Notification Date
     */
    public void setRENotificationRoundingDateRule( @Nullable final java.lang.String rENotificationRoundingDateRule )
    {
        rememberChangedField("RENotificationRoundingDateRule", this.rENotificationRoundingDateRule);
        this.rENotificationRoundingDateRule = rENotificationRoundingDateRule;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrRenewalTerm";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        entityKey.addKeyProperty("RETermType", getRETermType());
        entityKey.addKeyProperty("RETermNumber", getRETermNumber());
        entityKey.addKeyProperty("RERenewalType", getRERenewalType());
        entityKey.addKeyProperty("RERenewalSequenceNumber", getRERenewalSequenceNumber());
        entityKey.addKeyProperty("RERenewalRuleType", getRERenewalRuleType());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("RETermType", getRETermType());
        values.put("RETermNumber", getRETermNumber());
        values.put("RERenewalType", getRERenewalType());
        values.put("RERenewalSequenceNumber", getRERenewalSequenceNumber());
        values.put("RERenewalRuleType", getRERenewalRuleType());
        values.put("RETermName", getRETermName());
        values.put("RERenewalRule", getRERenewalRule());
        values.put("REAutomaticRenewalType", getREAutomaticRenewalType());
        values.put("RENumberOfRenewals", getRENumberOfRenewals());
        values.put("RERenewalPeriodInYears", getRERenewalPeriodInYears());
        values.put("RERenewalPeriodInMonths", getRERenewalPeriodInMonths());
        values.put("RERenewalPeriodInDays", getRERenewalPeriodInDays());
        values.put("RERenewalRoundingDateRule", getRERenewalRoundingDateRule());
        values.put("RENotificationPeriodInYears", getRENotificationPeriodInYears());
        values.put("RENotificationPeriodInMonths", getRENotificationPeriodInMonths());
        values.put("RENotificationPeriodInWeeks", getRENotificationPeriodInWeeks());
        values.put("RENotificationPeriodInDays", getRENotificationPeriodInDays());
        values.put("RENotificationRoundingDateRule", getRENotificationRoundingDateRule());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermType") ) {
                final Object value = values.remove("RETermType");
                if( (value == null) || (!value.equals(getRETermType())) ) {
                    setRETermType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermNumber") ) {
                final Object value = values.remove("RETermNumber");
                if( (value == null) || (!value.equals(getRETermNumber())) ) {
                    setRETermNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("RERenewalType") ) {
                final Object value = values.remove("RERenewalType");
                if( (value == null) || (!value.equals(getRERenewalType())) ) {
                    setRERenewalType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RERenewalSequenceNumber") ) {
                final Object value = values.remove("RERenewalSequenceNumber");
                if( (value == null) || (!value.equals(getRERenewalSequenceNumber())) ) {
                    setRERenewalSequenceNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("RERenewalRuleType") ) {
                final Object value = values.remove("RERenewalRuleType");
                if( (value == null) || (!value.equals(getRERenewalRuleType())) ) {
                    setRERenewalRuleType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermName") ) {
                final Object value = values.remove("RETermName");
                if( (value == null) || (!value.equals(getRETermName())) ) {
                    setRETermName(((java.lang.String) value));
                }
            }
            if( values.containsKey("RERenewalRule") ) {
                final Object value = values.remove("RERenewalRule");
                if( (value == null) || (!value.equals(getRERenewalRule())) ) {
                    setRERenewalRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAutomaticRenewalType") ) {
                final Object value = values.remove("REAutomaticRenewalType");
                if( (value == null) || (!value.equals(getREAutomaticRenewalType())) ) {
                    setREAutomaticRenewalType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENumberOfRenewals") ) {
                final Object value = values.remove("RENumberOfRenewals");
                if( (value == null) || (!value.equals(getRENumberOfRenewals())) ) {
                    setRENumberOfRenewals(((java.lang.String) value));
                }
            }
            if( values.containsKey("RERenewalPeriodInYears") ) {
                final Object value = values.remove("RERenewalPeriodInYears");
                if( (value == null) || (!value.equals(getRERenewalPeriodInYears())) ) {
                    setRERenewalPeriodInYears(((java.lang.String) value));
                }
            }
            if( values.containsKey("RERenewalPeriodInMonths") ) {
                final Object value = values.remove("RERenewalPeriodInMonths");
                if( (value == null) || (!value.equals(getRERenewalPeriodInMonths())) ) {
                    setRERenewalPeriodInMonths(((java.lang.String) value));
                }
            }
            if( values.containsKey("RERenewalPeriodInDays") ) {
                final Object value = values.remove("RERenewalPeriodInDays");
                if( (value == null) || (!value.equals(getRERenewalPeriodInDays())) ) {
                    setRERenewalPeriodInDays(((java.lang.String) value));
                }
            }
            if( values.containsKey("RERenewalRoundingDateRule") ) {
                final Object value = values.remove("RERenewalRoundingDateRule");
                if( (value == null) || (!value.equals(getRERenewalRoundingDateRule())) ) {
                    setRERenewalRoundingDateRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENotificationPeriodInYears") ) {
                final Object value = values.remove("RENotificationPeriodInYears");
                if( (value == null) || (!value.equals(getRENotificationPeriodInYears())) ) {
                    setRENotificationPeriodInYears(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENotificationPeriodInMonths") ) {
                final Object value = values.remove("RENotificationPeriodInMonths");
                if( (value == null) || (!value.equals(getRENotificationPeriodInMonths())) ) {
                    setRENotificationPeriodInMonths(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENotificationPeriodInWeeks") ) {
                final Object value = values.remove("RENotificationPeriodInWeeks");
                if( (value == null) || (!value.equals(getRENotificationPeriodInWeeks())) ) {
                    setRENotificationPeriodInWeeks(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENotificationPeriodInDays") ) {
                final Object value = values.remove("RENotificationPeriodInDays");
                if( (value == null) || (!value.equals(getRENotificationPeriodInDays())) ) {
                    setRENotificationPeriodInDays(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENotificationRoundingDateRule") ) {
                final Object value = values.remove("RENotificationRoundingDateRule");
                if( (value == null) || (!value.equals(getRENotificationRoundingDateRule())) ) {
                    setRENotificationRoundingDateRule(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrRenewalTerm</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrRenewalTerm instances.
     * 
     */
    public final static class REContrRenewalTermBuilder
    {

        private REContract to_REContract;

        private REContrRenewalTerm.REContrRenewalTermBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrRenewalTerm</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrRenewalTerm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrRenewalTerm.REContrRenewalTermBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
