/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrRhythmTermType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrRhythmTerm extends VdmEntity<REContrRhythmTerm> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrRhythmTermType";
    /**
     * Selector for all available fields of REContrRhythmTerm.
     * 
     */
    public final static SimpleProperty<REContrRhythmTerm> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrRhythmTerm> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "InternalRealEstateNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermType</b>
     * </p>
     * 
     * @return Term Category
     */
    @Nullable
    @ElementName( "RETermType" )
    private java.lang.String rETermType;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_TERM_TYPE =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "RETermType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @return Term Number
     */
    @Nullable
    @ElementName( "RETermNumber" )
    private java.lang.String rETermNumber;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_TERM_NUMBER =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "RETermNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @return Date from to (RAP Key)
     */
    @Nullable
    @ElementName( "ValidityStartEndDateValue" )
    private java.lang.String validityStartEndDateValue;
    public final static SimpleProperty.String<REContrRhythmTerm> VALIDITY_START_END_DATE_VALUE =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "ValidityStartEndDateValue");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<REContrRhythmTerm> VALIDITY_START_DATE =
        new SimpleProperty.Date<REContrRhythmTerm>(REContrRhythmTerm.class, "ValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<REContrRhythmTerm> VALIDITY_END_DATE =
        new SimpleProperty.Date<REContrRhythmTerm>(REContrRhythmTerm.class, "ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @return Name of Term
     */
    @Nullable
    @ElementName( "RETermName" )
    private java.lang.String rETermName;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_TERM_NAME =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "RETermName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RENumberOfFrequencyUnits</b>
     * </p>
     * 
     * @return Number of Frequency Units of Period
     */
    @Nullable
    @ElementName( "RENumberOfFrequencyUnits" )
    private java.lang.String rENumberOfFrequencyUnits;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_NUMBER_OF_FREQUENCY_UNITS =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "RENumberOfFrequencyUnits");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REFrequencyUnit</b>
     * </p>
     * 
     * @return Frequency Unit
     */
    @Nullable
    @ElementName( "REFrequencyUnit" )
    private java.lang.String rEFrequencyUnit;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_FREQUENCY_UNIT =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "REFrequencyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REStartFrequencyWeek</b>
     * </p>
     * 
     * @return Start of Week for Weekly Frequencies
     */
    @Nullable
    @ElementName( "REStartFrequencyWeek" )
    private java.lang.String rEStartFrequencyWeek;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_START_FREQUENCY_WEEK =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "REStartFrequencyWeek");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REFrequencyStart</b>
     * </p>
     * 
     * @return Start of Frequency for Daily, Monthly, and Yearly Frequency
     */
    @Nullable
    @ElementName( "REFrequencyStart" )
    private java.lang.String rEFrequencyStart;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_FREQUENCY_START =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "REFrequencyStart");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REConditionAmountReference</b>
     * </p>
     * 
     * @return Condition Amount Reference
     */
    @Nullable
    @ElementName( "REConditionAmountReference" )
    private java.lang.String rEConditionAmountReference;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_CONDITION_AMOUNT_REFERENCE =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "REConditionAmountReference");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REConditionAmountDiff</b>
     * </p>
     * 
     * @return Condition Amount Reference Differences
     */
    @Nullable
    @ElementName( "REConditionAmountDiff" )
    private java.lang.String rEConditionAmountDiff;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_CONDITION_AMOUNT_DIFF =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "REConditionAmountDiff");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REProRataMethod</b>
     * </p>
     * 
     * @return Pro Rata Method
     */
    @Nullable
    @ElementName( "REProRataMethod" )
    private java.lang.String rEProRataMethod;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_PRO_RATA_METHOD =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "REProRataMethod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REProRataMethodCalc</b>
     * </p>
     * 
     * @return Calculation method for time-dependent periods
     */
    @Nullable
    @ElementName( "REProRataMethodCalc" )
    private java.lang.String rEProRataMethodCalc;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_PRO_RATA_METHOD_CALC =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "REProRataMethodCalc");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REPaymentForm</b>
     * </p>
     * 
     * @return Payment Form (Period Start, Mid-Period, In Arrears, Example)
     */
    @Nullable
    @ElementName( "REPaymentForm" )
    private java.lang.String rEPaymentForm;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_PAYMENT_FORM =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "REPaymentForm");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REFrequencyStartDate</b>
     * </p>
     * 
     * @return User-Selected Frequency Start Date
     */
    @Nullable
    @ElementName( "REFrequencyStartDate" )
    private LocalDate rEFrequencyStartDate;
    public final static SimpleProperty.Date<REContrRhythmTerm> RE_FREQUENCY_START_DATE =
        new SimpleProperty.Date<REContrRhythmTerm>(REContrRhythmTerm.class, "REFrequencyStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateCorrectionRule</b>
     * </p>
     * 
     * @return Due Date Correction Rule
     */
    @Nullable
    @ElementName( "REDueDateCorrectionRule" )
    private java.lang.String rEDueDateCorrectionRule;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_DUE_DATE_CORRECTION_RULE =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "REDueDateCorrectionRule");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateNumberOfCrrtnDays</b>
     * </p>
     * 
     * @return Number of Days for Correcting Due Date
     */
    @Nullable
    @ElementName( "REDueDateNumberOfCrrtnDays" )
    private Short rEDueDateNumberOfCrrtnDays;
    public final static SimpleProperty.NumericInteger<REContrRhythmTerm> RE_DUE_DATE_NUMBER_OF_CRRTN_DAYS =
        new SimpleProperty.NumericInteger<REContrRhythmTerm>(REContrRhythmTerm.class, "REDueDateNumberOfCrrtnDays");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateNumberOfCrrtnMonths</b>
     * </p>
     * 
     * @return Number of Months for Correcting Due Date
     */
    @Nullable
    @ElementName( "REDueDateNumberOfCrrtnMonths" )
    private Short rEDueDateNumberOfCrrtnMonths;
    public final static SimpleProperty.NumericInteger<REContrRhythmTerm> RE_DUE_DATE_NUMBER_OF_CRRTN_MONTHS =
        new SimpleProperty.NumericInteger<REContrRhythmTerm>(REContrRhythmTerm.class, "REDueDateNumberOfCrrtnMonths");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateNumberOfCrrtnYears</b>
     * </p>
     * 
     * @return Number of Years for Correcting Due Date
     */
    @Nullable
    @ElementName( "REDueDateNumberOfCrrtnYears" )
    private Short rEDueDateNumberOfCrrtnYears;
    public final static SimpleProperty.NumericInteger<REContrRhythmTerm> RE_DUE_DATE_NUMBER_OF_CRRTN_YEARS =
        new SimpleProperty.NumericInteger<REContrRhythmTerm>(REContrRhythmTerm.class, "REDueDateNumberOfCrrtnYears");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateNumberOfCrrtnCalendar</b>
     * </p>
     * 
     * @return Correction Number for Correction of Due Date by Calendar
     */
    @Nullable
    @ElementName( "REDueDateNumberOfCrrtnCalendar" )
    private Short rEDueDateNumberOfCrrtnCalendar;
    public final static SimpleProperty.NumericInteger<REContrRhythmTerm> RE_DUE_DATE_NUMBER_OF_CRRTN_CALENDAR =
        new SimpleProperty.NumericInteger<REContrRhythmTerm>(REContrRhythmTerm.class, "REDueDateNumberOfCrrtnCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateCrrtnCalendarUnit</b>
     * </p>
     * 
     * @return Unit for Correcting Due Date by Calendar
     */
    @Nullable
    @ElementName( "REDueDateCrrtnCalendarUnit" )
    private java.lang.String rEDueDateCrrtnCalendarUnit;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_DUE_DATE_CRRTN_CALENDAR_UNIT =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "REDueDateCrrtnCalendarUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     * 
     * @return Factory Calendar
     */
    @Nullable
    @ElementName( "FactoryCalendar" )
    private java.lang.String factoryCalendar;
    public final static SimpleProperty.String<REContrRhythmTerm> FACTORY_CALENDAR =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "FactoryCalendar");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateIsAtBeginning</b>
     * </p>
     * 
     * @return Move Due Date to Start
     */
    @Nullable
    @ElementName( "REDueDateIsAtBeginning" )
    private java.lang.Boolean rEDueDateIsAtBeginning;
    public final static SimpleProperty.Boolean<REContrRhythmTerm> RE_DUE_DATE_IS_AT_BEGINNING =
        new SimpleProperty.Boolean<REContrRhythmTerm>(REContrRhythmTerm.class, "REDueDateIsAtBeginning");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateIsAtEnd</b>
     * </p>
     * 
     * @return Move Due Date to End
     */
    @Nullable
    @ElementName( "REDueDateIsAtEnd" )
    private java.lang.Boolean rEDueDateIsAtEnd;
    public final static SimpleProperty.Boolean<REContrRhythmTerm> RE_DUE_DATE_IS_AT_END =
        new SimpleProperty.Boolean<REContrRhythmTerm>(REContrRhythmTerm.class, "REDueDateIsAtEnd");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REFixedPeriod</b>
     * </p>
     * 
     * @return Fixed Periods
     */
    @Nullable
    @ElementName( "REFixedPeriod" )
    private java.lang.String rEFixedPeriod;
    public final static SimpleProperty.String<REContrRhythmTerm> RE_FIXED_PERIOD =
        new SimpleProperty.String<REContrRhythmTerm>(REContrRhythmTerm.class, "REFixedPeriod");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrRhythmTerm, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrRhythmTerm, SAP__Message>(
            REContrRhythmTerm.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrRhythmTerm</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrRhythmTerm, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrRhythmTerm, REContract>(
            REContrRhythmTerm.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrRhythmTerm> getType()
    {
        return REContrRhythmTerm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermType</b>
     * </p>
     * 
     * @param rETermType
     *            Term Category
     */
    public void setRETermType( @Nullable final java.lang.String rETermType )
    {
        rememberChangedField("RETermType", this.rETermType);
        this.rETermType = rETermType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @param rETermNumber
     *            Term Number
     */
    public void setRETermNumber( @Nullable final java.lang.String rETermNumber )
    {
        rememberChangedField("RETermNumber", this.rETermNumber);
        this.rETermNumber = rETermNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     */
    public void setValidityStartEndDateValue( @Nullable final java.lang.String validityStartEndDateValue )
    {
        rememberChangedField("ValidityStartEndDateValue", this.validityStartEndDateValue);
        this.validityStartEndDateValue = validityStartEndDateValue;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @param rETermName
     *            Name of Term
     */
    public void setRETermName( @Nullable final java.lang.String rETermName )
    {
        rememberChangedField("RETermName", this.rETermName);
        this.rETermName = rETermName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RENumberOfFrequencyUnits</b>
     * </p>
     * 
     * @param rENumberOfFrequencyUnits
     *            Number of Frequency Units of Period
     */
    public void setRENumberOfFrequencyUnits( @Nullable final java.lang.String rENumberOfFrequencyUnits )
    {
        rememberChangedField("RENumberOfFrequencyUnits", this.rENumberOfFrequencyUnits);
        this.rENumberOfFrequencyUnits = rENumberOfFrequencyUnits;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REFrequencyUnit</b>
     * </p>
     * 
     * @param rEFrequencyUnit
     *            Frequency Unit
     */
    public void setREFrequencyUnit( @Nullable final java.lang.String rEFrequencyUnit )
    {
        rememberChangedField("REFrequencyUnit", this.rEFrequencyUnit);
        this.rEFrequencyUnit = rEFrequencyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REStartFrequencyWeek</b>
     * </p>
     * 
     * @param rEStartFrequencyWeek
     *            Start of Week for Weekly Frequencies
     */
    public void setREStartFrequencyWeek( @Nullable final java.lang.String rEStartFrequencyWeek )
    {
        rememberChangedField("REStartFrequencyWeek", this.rEStartFrequencyWeek);
        this.rEStartFrequencyWeek = rEStartFrequencyWeek;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REFrequencyStart</b>
     * </p>
     * 
     * @param rEFrequencyStart
     *            Start of Frequency for Daily, Monthly, and Yearly Frequency
     */
    public void setREFrequencyStart( @Nullable final java.lang.String rEFrequencyStart )
    {
        rememberChangedField("REFrequencyStart", this.rEFrequencyStart);
        this.rEFrequencyStart = rEFrequencyStart;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REConditionAmountReference</b>
     * </p>
     * 
     * @param rEConditionAmountReference
     *            Condition Amount Reference
     */
    public void setREConditionAmountReference( @Nullable final java.lang.String rEConditionAmountReference )
    {
        rememberChangedField("REConditionAmountReference", this.rEConditionAmountReference);
        this.rEConditionAmountReference = rEConditionAmountReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REConditionAmountDiff</b>
     * </p>
     * 
     * @param rEConditionAmountDiff
     *            Condition Amount Reference Differences
     */
    public void setREConditionAmountDiff( @Nullable final java.lang.String rEConditionAmountDiff )
    {
        rememberChangedField("REConditionAmountDiff", this.rEConditionAmountDiff);
        this.rEConditionAmountDiff = rEConditionAmountDiff;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REProRataMethod</b>
     * </p>
     * 
     * @param rEProRataMethod
     *            Pro Rata Method
     */
    public void setREProRataMethod( @Nullable final java.lang.String rEProRataMethod )
    {
        rememberChangedField("REProRataMethod", this.rEProRataMethod);
        this.rEProRataMethod = rEProRataMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REProRataMethodCalc</b>
     * </p>
     * 
     * @param rEProRataMethodCalc
     *            Calculation method for time-dependent periods
     */
    public void setREProRataMethodCalc( @Nullable final java.lang.String rEProRataMethodCalc )
    {
        rememberChangedField("REProRataMethodCalc", this.rEProRataMethodCalc);
        this.rEProRataMethodCalc = rEProRataMethodCalc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REPaymentForm</b>
     * </p>
     * 
     * @param rEPaymentForm
     *            Payment Form (Period Start, Mid-Period, In Arrears, Example)
     */
    public void setREPaymentForm( @Nullable final java.lang.String rEPaymentForm )
    {
        rememberChangedField("REPaymentForm", this.rEPaymentForm);
        this.rEPaymentForm = rEPaymentForm;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REFrequencyStartDate</b>
     * </p>
     * 
     * @param rEFrequencyStartDate
     *            User-Selected Frequency Start Date
     */
    public void setREFrequencyStartDate( @Nullable final LocalDate rEFrequencyStartDate )
    {
        rememberChangedField("REFrequencyStartDate", this.rEFrequencyStartDate);
        this.rEFrequencyStartDate = rEFrequencyStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateCorrectionRule</b>
     * </p>
     * 
     * @param rEDueDateCorrectionRule
     *            Due Date Correction Rule
     */
    public void setREDueDateCorrectionRule( @Nullable final java.lang.String rEDueDateCorrectionRule )
    {
        rememberChangedField("REDueDateCorrectionRule", this.rEDueDateCorrectionRule);
        this.rEDueDateCorrectionRule = rEDueDateCorrectionRule;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateNumberOfCrrtnDays</b>
     * </p>
     * 
     * @param rEDueDateNumberOfCrrtnDays
     *            Number of Days for Correcting Due Date
     */
    public void setREDueDateNumberOfCrrtnDays( @Nullable final Short rEDueDateNumberOfCrrtnDays )
    {
        rememberChangedField("REDueDateNumberOfCrrtnDays", this.rEDueDateNumberOfCrrtnDays);
        this.rEDueDateNumberOfCrrtnDays = rEDueDateNumberOfCrrtnDays;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateNumberOfCrrtnMonths</b>
     * </p>
     * 
     * @param rEDueDateNumberOfCrrtnMonths
     *            Number of Months for Correcting Due Date
     */
    public void setREDueDateNumberOfCrrtnMonths( @Nullable final Short rEDueDateNumberOfCrrtnMonths )
    {
        rememberChangedField("REDueDateNumberOfCrrtnMonths", this.rEDueDateNumberOfCrrtnMonths);
        this.rEDueDateNumberOfCrrtnMonths = rEDueDateNumberOfCrrtnMonths;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateNumberOfCrrtnYears</b>
     * </p>
     * 
     * @param rEDueDateNumberOfCrrtnYears
     *            Number of Years for Correcting Due Date
     */
    public void setREDueDateNumberOfCrrtnYears( @Nullable final Short rEDueDateNumberOfCrrtnYears )
    {
        rememberChangedField("REDueDateNumberOfCrrtnYears", this.rEDueDateNumberOfCrrtnYears);
        this.rEDueDateNumberOfCrrtnYears = rEDueDateNumberOfCrrtnYears;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateNumberOfCrrtnCalendar</b>
     * </p>
     * 
     * @param rEDueDateNumberOfCrrtnCalendar
     *            Correction Number for Correction of Due Date by Calendar
     */
    public void setREDueDateNumberOfCrrtnCalendar( @Nullable final Short rEDueDateNumberOfCrrtnCalendar )
    {
        rememberChangedField("REDueDateNumberOfCrrtnCalendar", this.rEDueDateNumberOfCrrtnCalendar);
        this.rEDueDateNumberOfCrrtnCalendar = rEDueDateNumberOfCrrtnCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateCrrtnCalendarUnit</b>
     * </p>
     * 
     * @param rEDueDateCrrtnCalendarUnit
     *            Unit for Correcting Due Date by Calendar
     */
    public void setREDueDateCrrtnCalendarUnit( @Nullable final java.lang.String rEDueDateCrrtnCalendarUnit )
    {
        rememberChangedField("REDueDateCrrtnCalendarUnit", this.rEDueDateCrrtnCalendarUnit);
        this.rEDueDateCrrtnCalendarUnit = rEDueDateCrrtnCalendarUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     * 
     * @param factoryCalendar
     *            Factory Calendar
     */
    public void setFactoryCalendar( @Nullable final java.lang.String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateIsAtBeginning</b>
     * </p>
     * 
     * @param rEDueDateIsAtBeginning
     *            Move Due Date to Start
     */
    public void setREDueDateIsAtBeginning( @Nullable final java.lang.Boolean rEDueDateIsAtBeginning )
    {
        rememberChangedField("REDueDateIsAtBeginning", this.rEDueDateIsAtBeginning);
        this.rEDueDateIsAtBeginning = rEDueDateIsAtBeginning;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REDueDateIsAtEnd</b>
     * </p>
     * 
     * @param rEDueDateIsAtEnd
     *            Move Due Date to End
     */
    public void setREDueDateIsAtEnd( @Nullable final java.lang.Boolean rEDueDateIsAtEnd )
    {
        rememberChangedField("REDueDateIsAtEnd", this.rEDueDateIsAtEnd);
        this.rEDueDateIsAtEnd = rEDueDateIsAtEnd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REFixedPeriod</b>
     * </p>
     * 
     * @param rEFixedPeriod
     *            Fixed Periods
     */
    public void setREFixedPeriod( @Nullable final java.lang.String rEFixedPeriod )
    {
        rememberChangedField("REFixedPeriod", this.rEFixedPeriod);
        this.rEFixedPeriod = rEFixedPeriod;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrRhythmTerm";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        entityKey.addKeyProperty("RETermType", getRETermType());
        entityKey.addKeyProperty("RETermNumber", getRETermNumber());
        entityKey.addKeyProperty("ValidityStartEndDateValue", getValidityStartEndDateValue());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("RETermType", getRETermType());
        values.put("RETermNumber", getRETermNumber());
        values.put("ValidityStartEndDateValue", getValidityStartEndDateValue());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("RETermName", getRETermName());
        values.put("RENumberOfFrequencyUnits", getRENumberOfFrequencyUnits());
        values.put("REFrequencyUnit", getREFrequencyUnit());
        values.put("REStartFrequencyWeek", getREStartFrequencyWeek());
        values.put("REFrequencyStart", getREFrequencyStart());
        values.put("REConditionAmountReference", getREConditionAmountReference());
        values.put("REConditionAmountDiff", getREConditionAmountDiff());
        values.put("REProRataMethod", getREProRataMethod());
        values.put("REProRataMethodCalc", getREProRataMethodCalc());
        values.put("REPaymentForm", getREPaymentForm());
        values.put("REFrequencyStartDate", getREFrequencyStartDate());
        values.put("REDueDateCorrectionRule", getREDueDateCorrectionRule());
        values.put("REDueDateNumberOfCrrtnDays", getREDueDateNumberOfCrrtnDays());
        values.put("REDueDateNumberOfCrrtnMonths", getREDueDateNumberOfCrrtnMonths());
        values.put("REDueDateNumberOfCrrtnYears", getREDueDateNumberOfCrrtnYears());
        values.put("REDueDateNumberOfCrrtnCalendar", getREDueDateNumberOfCrrtnCalendar());
        values.put("REDueDateCrrtnCalendarUnit", getREDueDateCrrtnCalendarUnit());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("REDueDateIsAtBeginning", getREDueDateIsAtBeginning());
        values.put("REDueDateIsAtEnd", getREDueDateIsAtEnd());
        values.put("REFixedPeriod", getREFixedPeriod());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermType") ) {
                final Object value = values.remove("RETermType");
                if( (value == null) || (!value.equals(getRETermType())) ) {
                    setRETermType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermNumber") ) {
                final Object value = values.remove("RETermNumber");
                if( (value == null) || (!value.equals(getRETermNumber())) ) {
                    setRETermNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartEndDateValue") ) {
                final Object value = values.remove("ValidityStartEndDateValue");
                if( (value == null) || (!value.equals(getValidityStartEndDateValue())) ) {
                    setValidityStartEndDateValue(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("RETermName") ) {
                final Object value = values.remove("RETermName");
                if( (value == null) || (!value.equals(getRETermName())) ) {
                    setRETermName(((java.lang.String) value));
                }
            }
            if( values.containsKey("RENumberOfFrequencyUnits") ) {
                final Object value = values.remove("RENumberOfFrequencyUnits");
                if( (value == null) || (!value.equals(getRENumberOfFrequencyUnits())) ) {
                    setRENumberOfFrequencyUnits(((java.lang.String) value));
                }
            }
            if( values.containsKey("REFrequencyUnit") ) {
                final Object value = values.remove("REFrequencyUnit");
                if( (value == null) || (!value.equals(getREFrequencyUnit())) ) {
                    setREFrequencyUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("REStartFrequencyWeek") ) {
                final Object value = values.remove("REStartFrequencyWeek");
                if( (value == null) || (!value.equals(getREStartFrequencyWeek())) ) {
                    setREStartFrequencyWeek(((java.lang.String) value));
                }
            }
            if( values.containsKey("REFrequencyStart") ) {
                final Object value = values.remove("REFrequencyStart");
                if( (value == null) || (!value.equals(getREFrequencyStart())) ) {
                    setREFrequencyStart(((java.lang.String) value));
                }
            }
            if( values.containsKey("REConditionAmountReference") ) {
                final Object value = values.remove("REConditionAmountReference");
                if( (value == null) || (!value.equals(getREConditionAmountReference())) ) {
                    setREConditionAmountReference(((java.lang.String) value));
                }
            }
            if( values.containsKey("REConditionAmountDiff") ) {
                final Object value = values.remove("REConditionAmountDiff");
                if( (value == null) || (!value.equals(getREConditionAmountDiff())) ) {
                    setREConditionAmountDiff(((java.lang.String) value));
                }
            }
            if( values.containsKey("REProRataMethod") ) {
                final Object value = values.remove("REProRataMethod");
                if( (value == null) || (!value.equals(getREProRataMethod())) ) {
                    setREProRataMethod(((java.lang.String) value));
                }
            }
            if( values.containsKey("REProRataMethodCalc") ) {
                final Object value = values.remove("REProRataMethodCalc");
                if( (value == null) || (!value.equals(getREProRataMethodCalc())) ) {
                    setREProRataMethodCalc(((java.lang.String) value));
                }
            }
            if( values.containsKey("REPaymentForm") ) {
                final Object value = values.remove("REPaymentForm");
                if( (value == null) || (!value.equals(getREPaymentForm())) ) {
                    setREPaymentForm(((java.lang.String) value));
                }
            }
            if( values.containsKey("REFrequencyStartDate") ) {
                final Object value = values.remove("REFrequencyStartDate");
                if( (value == null) || (!value.equals(getREFrequencyStartDate())) ) {
                    setREFrequencyStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REDueDateCorrectionRule") ) {
                final Object value = values.remove("REDueDateCorrectionRule");
                if( (value == null) || (!value.equals(getREDueDateCorrectionRule())) ) {
                    setREDueDateCorrectionRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("REDueDateNumberOfCrrtnDays") ) {
                final Object value = values.remove("REDueDateNumberOfCrrtnDays");
                if( (value == null) || (!value.equals(getREDueDateNumberOfCrrtnDays())) ) {
                    setREDueDateNumberOfCrrtnDays(((Short) value));
                }
            }
            if( values.containsKey("REDueDateNumberOfCrrtnMonths") ) {
                final Object value = values.remove("REDueDateNumberOfCrrtnMonths");
                if( (value == null) || (!value.equals(getREDueDateNumberOfCrrtnMonths())) ) {
                    setREDueDateNumberOfCrrtnMonths(((Short) value));
                }
            }
            if( values.containsKey("REDueDateNumberOfCrrtnYears") ) {
                final Object value = values.remove("REDueDateNumberOfCrrtnYears");
                if( (value == null) || (!value.equals(getREDueDateNumberOfCrrtnYears())) ) {
                    setREDueDateNumberOfCrrtnYears(((Short) value));
                }
            }
            if( values.containsKey("REDueDateNumberOfCrrtnCalendar") ) {
                final Object value = values.remove("REDueDateNumberOfCrrtnCalendar");
                if( (value == null) || (!value.equals(getREDueDateNumberOfCrrtnCalendar())) ) {
                    setREDueDateNumberOfCrrtnCalendar(((Short) value));
                }
            }
            if( values.containsKey("REDueDateCrrtnCalendarUnit") ) {
                final Object value = values.remove("REDueDateCrrtnCalendarUnit");
                if( (value == null) || (!value.equals(getREDueDateCrrtnCalendarUnit())) ) {
                    setREDueDateCrrtnCalendarUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((java.lang.String) value));
                }
            }
            if( values.containsKey("REDueDateIsAtBeginning") ) {
                final Object value = values.remove("REDueDateIsAtBeginning");
                if( (value == null) || (!value.equals(getREDueDateIsAtBeginning())) ) {
                    setREDueDateIsAtBeginning(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REDueDateIsAtEnd") ) {
                final Object value = values.remove("REDueDateIsAtEnd");
                if( (value == null) || (!value.equals(getREDueDateIsAtEnd())) ) {
                    setREDueDateIsAtEnd(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REFixedPeriod") ) {
                final Object value = values.remove("REFixedPeriod");
                if( (value == null) || (!value.equals(getREFixedPeriod())) ) {
                    setREFixedPeriod(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrRhythmTerm</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrRhythmTerm instances.
     * 
     */
    public final static class REContrRhythmTermBuilder
    {

        private REContract to_REContract;

        private REContrRhythmTerm.REContrRhythmTermBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrRhythmTerm</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrRhythmTerm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrRhythmTerm.REContrRhythmTermBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
