/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Valuation Terms
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrValuationType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrValuation extends VdmEntity<REContrValuation> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrValuationType";
    /**
     * Selector for all available fields of REContrValuation.
     * 
     */
    public final static SimpleProperty<REContrValuation> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrValuation> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "InternalRealEstateNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @return Term Number
     */
    @Nullable
    @ElementName( "RETermNumber" )
    private java.lang.String rETermNumber;
    public final static SimpleProperty.String<REContrValuation> RE_TERM_NUMBER =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "RETermNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @return Date from to (RAP Key)
     */
    @Nullable
    @ElementName( "ValidityStartEndDateValue" )
    private java.lang.String validityStartEndDateValue;
    public final static SimpleProperty.String<REContrValuation> VALIDITY_START_END_DATE_VALUE =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "ValidityStartEndDateValue");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermType</b>
     * </p>
     * 
     * @return Term Category
     */
    @Nullable
    @ElementName( "RETermType" )
    private java.lang.String rETermType;
    public final static SimpleProperty.String<REContrValuation> RE_TERM_TYPE =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "RETermType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @return Name of Term
     */
    @Nullable
    @ElementName( "RETermName" )
    private java.lang.String rETermName;
    public final static SimpleProperty.String<REContrValuation> RE_TERM_NAME =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "RETermName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REValuationRule</b>
     * </p>
     * 
     * @return Valuation Rule
     */
    @Nullable
    @ElementName( "REValuationRule" )
    private java.lang.String rEValuationRule;
    public final static SimpleProperty.String<REContrValuation> RE_VALUATION_RULE =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REValuationRule");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<REContrValuation> VALIDITY_START_DATE =
        new SimpleProperty.Date<REContrValuation>(REContrValuation.class, "ValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<REContrValuation> VALIDITY_END_DATE =
        new SimpleProperty.Date<REContrValuation>(REContrValuation.class, "ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObject</b>
     * </p>
     * 
     * @return Valuation Object Number
     */
    @Nullable
    @ElementName( "REStatusObject" )
    private java.lang.String rEStatusObject;
    public final static SimpleProperty.String<REContrValuation> RE_STATUS_OBJECT =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REStatusObject");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateObjectType</b>
     * </p>
     * 
     * @return Object Type
     */
    @Nullable
    @ElementName( "RealEstateObjectType" )
    private java.lang.String realEstateObjectType;
    public final static SimpleProperty.String<REContrValuation> REAL_ESTATE_OBJECT_TYPE =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "RealEstateObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>REIdentification</b>
     * </p>
     * 
     * @return Complete Object Identification, for Example BE 1000/123
     */
    @Nullable
    @ElementName( "REIdentification" )
    private java.lang.String rEIdentification;
    public final static SimpleProperty.String<REContrValuation> RE_IDENTIFICATION =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REIdentification");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ObjectValidFrom</b>
     * </p>
     * 
     * @return Date: Relationship Valid From
     */
    @Nullable
    @ElementName( "ObjectValidFrom" )
    private LocalDate objectValidFrom;
    public final static SimpleProperty.Date<REContrValuation> OBJECT_VALID_FROM =
        new SimpleProperty.Date<REContrValuation>(REContrValuation.class, "ObjectValidFrom");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REConsiderationStartDate</b>
     * </p>
     * 
     * @return Start of Consideration
     */
    @Nullable
    @ElementName( "REConsiderationStartDate" )
    private LocalDate rEConsiderationStartDate;
    public final static SimpleProperty.Date<REContrValuation> RE_CONSIDERATION_START_DATE =
        new SimpleProperty.Date<REContrValuation>(REContrValuation.class, "REConsiderationStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>RECashFlowPostingFromDate</b>
     * </p>
     * 
     * @return First Posting From
     */
    @Nullable
    @ElementName( "RECashFlowPostingFromDate" )
    private LocalDate rECashFlowPostingFromDate;
    public final static SimpleProperty.Date<REContrValuation> RE_CASH_FLOW_POSTING_FROM_DATE =
        new SimpleProperty.Date<REContrValuation>(REContrValuation.class, "RECashFlowPostingFromDate");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectAsset</b>
     * </p>
     * 
     * @return Object Number - Asset
     */
    @Nullable
    @ElementName( "REStatusObjectAsset" )
    private java.lang.String rEStatusObjectAsset;
    public final static SimpleProperty.String<REContrValuation> RE_STATUS_OBJECT_ASSET =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REStatusObjectAsset");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationClassification</b>
     * </p>
     * 
     * @return Valuation Classification
     */
    @Nullable
    @ElementName( "REValuationClassification" )
    private java.lang.String rEValuationClassification;
    public final static SimpleProperty.String<REContrValuation> RE_VALUATION_CLASSIFICATION =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REValuationClassification");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 10
     * <p>
     * Original property name from the Odata EDM: <b>REInterestRate</b>
     * </p>
     * 
     * @return Interest Rate
     */
    @Nullable
    @ElementName( "REInterestRate" )
    @DecimalDescriptor( precision = 15, scale = 10 )
    private BigDecimal rEInterestRate;
    public final static SimpleProperty.NumericDecimal<REContrValuation> RE_INTEREST_RATE =
        new SimpleProperty.NumericDecimal<REContrValuation>(REContrValuation.class, "REInterestRate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REFrequencyTerm</b>
     * </p>
     * 
     * @return Number of Frequency Term
     */
    @Nullable
    @ElementName( "REFrequencyTerm" )
    private java.lang.String rEFrequencyTerm;
    public final static SimpleProperty.String<REContrValuation> RE_FREQUENCY_TERM =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REFrequencyTerm");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REDistributionRule</b>
     * </p>
     * 
     * @return Distribution Formula
     */
    @Nullable
    @ElementName( "REDistributionRule" )
    private java.lang.String rEDistributionRule;
    public final static SimpleProperty.String<REContrValuation> RE_DISTRIBUTION_RULE =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REDistributionRule");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>REDistributionRuleParam1</b>
     * </p>
     * 
     * @return Untypified Parameter for a Distribution Formula
     */
    @Nullable
    @ElementName( "REDistributionRuleParam1" )
    private java.lang.String rEDistributionRuleParam1;
    public final static SimpleProperty.String<REContrValuation> RE_DISTRIBUTION_RULE_PARAM1 =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REDistributionRuleParam1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>REDistributionRuleParam2</b>
     * </p>
     * 
     * @return Untypified Parameter for a Distribution Formula
     */
    @Nullable
    @ElementName( "REDistributionRuleParam2" )
    private java.lang.String rEDistributionRuleParam2;
    public final static SimpleProperty.String<REContrValuation> RE_DISTRIBUTION_RULE_PARAM2 =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REDistributionRuleParam2");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REProbableEndDate</b>
     * </p>
     * 
     * @return Probable End
     */
    @Nullable
    @ElementName( "REProbableEndDate" )
    private LocalDate rEProbableEndDate;
    public final static SimpleProperty.Date<REContrValuation> RE_PROBABLE_END_DATE =
        new SimpleProperty.Date<REContrValuation>(REContrValuation.class, "REProbableEndDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAssetRightOfUseEndDate</b>
     * </p>
     * 
     * @return End of Usage RoU
     */
    @Nullable
    @ElementName( "REAssetRightOfUseEndDate" )
    private LocalDate rEAssetRightOfUseEndDate;
    public final static SimpleProperty.Date<REContrValuation> RE_ASSET_RIGHT_OF_USE_END_DATE =
        new SimpleProperty.Date<REContrValuation>(REContrValuation.class, "REAssetRightOfUseEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationRuleStatus</b>
     * </p>
     * 
     * @return Status for Valuation Rule
     */
    @Nullable
    @ElementName( "REValuationRuleStatus" )
    private java.lang.String rEValuationRuleStatus;
    public final static SimpleProperty.String<REContrValuation> RE_VALUATION_RULE_STATUS =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REValuationRuleStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationStatus</b>
     * </p>
     * 
     * @return Valuation Status
     */
    @Nullable
    @ElementName( "REValuationStatus" )
    private java.lang.String rEValuationStatus;
    public final static SimpleProperty.String<REContrValuation> RE_VALUATION_STATUS =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REValuationStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationStatusReason</b>
     * </p>
     * 
     * @return Status Reason for Valuation Rule
     */
    @Nullable
    @ElementName( "REValuationStatusReason" )
    private java.lang.String rEValuationStatusReason;
    public final static SimpleProperty.String<REContrValuation> RE_VALUATION_STATUS_REASON =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REValuationStatusReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationBehavior</b>
     * </p>
     * 
     * @return Valuation Behavior
     */
    @Nullable
    @ElementName( "REValuationBehavior" )
    private java.lang.String rEValuationBehavior;
    public final static SimpleProperty.String<REContrValuation> RE_VALUATION_BEHAVIOR =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REValuationBehavior");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETaxType</b>
     * </p>
     * 
     * @return Tax Type
     */
    @Nullable
    @ElementName( "RETaxType" )
    private java.lang.String rETaxType;
    public final static SimpleProperty.String<REContrValuation> RE_TAX_TYPE =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "RETaxType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TaxGroup</b>
     * </p>
     * 
     * @return Tax Group
     */
    @Nullable
    @ElementName( "TaxGroup" )
    private java.lang.String taxGroup;
    public final static SimpleProperty.String<REContrValuation> TAX_GROUP =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "TaxGroup");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REAccountingObject</b>
     * </p>
     * 
     * @return Object Number Valuation Account Assignment
     */
    @Nullable
    @ElementName( "REAccountingObject" )
    private java.lang.String rEAccountingObject;
    public final static SimpleProperty.String<REContrValuation> RE_ACCOUNTING_OBJECT =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REAccountingObject");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>REInfoText</b>
     * </p>
     * 
     * @return Valuation Note
     */
    @Nullable
    @ElementName( "REInfoText" )
    private java.lang.String rEInfoText;
    public final static SimpleProperty.String<REContrValuation> RE_INFO_TEXT =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REInfoText");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REValuationFactorNumerator</b>
     * </p>
     * 
     * @return Numerator Valuation Factor
     */
    @Nullable
    @ElementName( "REValuationFactorNumerator" )
    private Integer rEValuationFactorNumerator;
    public final static SimpleProperty.NumericInteger<REContrValuation> RE_VALUATION_FACTOR_NUMERATOR =
        new SimpleProperty.NumericInteger<REContrValuation>(REContrValuation.class, "REValuationFactorNumerator");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REValuationFactorDenominator</b>
     * </p>
     * 
     * @return Denominator Valuation Factor
     */
    @Nullable
    @ElementName( "REValuationFactorDenominator" )
    private Integer rEValuationFactorDenominator;
    public final static SimpleProperty.NumericInteger<REContrValuation> RE_VALUATION_FACTOR_DENOMINATOR =
        new SimpleProperty.NumericInteger<REContrValuation>(REContrValuation.class, "REValuationFactorDenominator");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCurrency</b>
     * </p>
     * 
     * @return Valuation Rule Currency
     */
    @Nullable
    @ElementName( "REValuationCurrency" )
    private java.lang.String rEValuationCurrency;
    public final static SimpleProperty.String<REContrValuation> RE_VALUATION_CURRENCY =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "REValuationCurrency");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REValuationQuestionnaireUUID</b>
     * </p>
     * 
     * @return GUID for Questionnaire
     */
    @Nullable
    @ElementName( "REValuationQuestionnaireUUID" )
    private UUID rEValuationQuestionnaireUUID;
    public final static SimpleProperty.Guid<REContrValuation> RE_VALUATION_QUESTIONNAIRE_UUID =
        new SimpleProperty.Guid<REContrValuation>(REContrValuation.class, "REValuationQuestionnaireUUID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     * 
     * @return Country Key
     */
    @Nullable
    @ElementName( "Country" )
    private java.lang.String country;
    public final static SimpleProperty.String<REContrValuation> COUNTRY =
        new SimpleProperty.String<REContrValuation>(REContrValuation.class, "Country");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrValuation, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrValuation, SAP__Message>(
            REContrValuation.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrValuation</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrValuation, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrValuation, REContract>(
            REContrValuation.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrValuation> getType()
    {
        return REContrValuation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @param rETermNumber
     *            Term Number
     */
    public void setRETermNumber( @Nullable final java.lang.String rETermNumber )
    {
        rememberChangedField("RETermNumber", this.rETermNumber);
        this.rETermNumber = rETermNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     */
    public void setValidityStartEndDateValue( @Nullable final java.lang.String validityStartEndDateValue )
    {
        rememberChangedField("ValidityStartEndDateValue", this.validityStartEndDateValue);
        this.validityStartEndDateValue = validityStartEndDateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermType</b>
     * </p>
     * 
     * @param rETermType
     *            Term Category
     */
    public void setRETermType( @Nullable final java.lang.String rETermType )
    {
        rememberChangedField("RETermType", this.rETermType);
        this.rETermType = rETermType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @param rETermName
     *            Name of Term
     */
    public void setRETermName( @Nullable final java.lang.String rETermName )
    {
        rememberChangedField("RETermName", this.rETermName);
        this.rETermName = rETermName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REValuationRule</b>
     * </p>
     * 
     * @param rEValuationRule
     *            Valuation Rule
     */
    public void setREValuationRule( @Nullable final java.lang.String rEValuationRule )
    {
        rememberChangedField("REValuationRule", this.rEValuationRule);
        this.rEValuationRule = rEValuationRule;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObject</b>
     * </p>
     * 
     * @param rEStatusObject
     *            Valuation Object Number
     */
    public void setREStatusObject( @Nullable final java.lang.String rEStatusObject )
    {
        rememberChangedField("REStatusObject", this.rEStatusObject);
        this.rEStatusObject = rEStatusObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateObjectType</b>
     * </p>
     * 
     * @param realEstateObjectType
     *            Object Type
     */
    public void setRealEstateObjectType( @Nullable final java.lang.String realEstateObjectType )
    {
        rememberChangedField("RealEstateObjectType", this.realEstateObjectType);
        this.realEstateObjectType = realEstateObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>REIdentification</b>
     * </p>
     * 
     * @param rEIdentification
     *            Complete Object Identification, for Example BE 1000/123
     */
    public void setREIdentification( @Nullable final java.lang.String rEIdentification )
    {
        rememberChangedField("REIdentification", this.rEIdentification);
        this.rEIdentification = rEIdentification;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ObjectValidFrom</b>
     * </p>
     * 
     * @param objectValidFrom
     *            Date: Relationship Valid From
     */
    public void setObjectValidFrom( @Nullable final LocalDate objectValidFrom )
    {
        rememberChangedField("ObjectValidFrom", this.objectValidFrom);
        this.objectValidFrom = objectValidFrom;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REConsiderationStartDate</b>
     * </p>
     * 
     * @param rEConsiderationStartDate
     *            Start of Consideration
     */
    public void setREConsiderationStartDate( @Nullable final LocalDate rEConsiderationStartDate )
    {
        rememberChangedField("REConsiderationStartDate", this.rEConsiderationStartDate);
        this.rEConsiderationStartDate = rEConsiderationStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>RECashFlowPostingFromDate</b>
     * </p>
     * 
     * @param rECashFlowPostingFromDate
     *            First Posting From
     */
    public void setRECashFlowPostingFromDate( @Nullable final LocalDate rECashFlowPostingFromDate )
    {
        rememberChangedField("RECashFlowPostingFromDate", this.rECashFlowPostingFromDate);
        this.rECashFlowPostingFromDate = rECashFlowPostingFromDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectAsset</b>
     * </p>
     * 
     * @param rEStatusObjectAsset
     *            Object Number - Asset
     */
    public void setREStatusObjectAsset( @Nullable final java.lang.String rEStatusObjectAsset )
    {
        rememberChangedField("REStatusObjectAsset", this.rEStatusObjectAsset);
        this.rEStatusObjectAsset = rEStatusObjectAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationClassification</b>
     * </p>
     * 
     * @param rEValuationClassification
     *            Valuation Classification
     */
    public void setREValuationClassification( @Nullable final java.lang.String rEValuationClassification )
    {
        rememberChangedField("REValuationClassification", this.rEValuationClassification);
        this.rEValuationClassification = rEValuationClassification;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 10
     * <p>
     * Original property name from the Odata EDM: <b>REInterestRate</b>
     * </p>
     * 
     * @param rEInterestRate
     *            Interest Rate
     */
    public void setREInterestRate( @Nullable final BigDecimal rEInterestRate )
    {
        rememberChangedField("REInterestRate", this.rEInterestRate);
        this.rEInterestRate = rEInterestRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REFrequencyTerm</b>
     * </p>
     * 
     * @param rEFrequencyTerm
     *            Number of Frequency Term
     */
    public void setREFrequencyTerm( @Nullable final java.lang.String rEFrequencyTerm )
    {
        rememberChangedField("REFrequencyTerm", this.rEFrequencyTerm);
        this.rEFrequencyTerm = rEFrequencyTerm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REDistributionRule</b>
     * </p>
     * 
     * @param rEDistributionRule
     *            Distribution Formula
     */
    public void setREDistributionRule( @Nullable final java.lang.String rEDistributionRule )
    {
        rememberChangedField("REDistributionRule", this.rEDistributionRule);
        this.rEDistributionRule = rEDistributionRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>REDistributionRuleParam1</b>
     * </p>
     * 
     * @param rEDistributionRuleParam1
     *            Untypified Parameter for a Distribution Formula
     */
    public void setREDistributionRuleParam1( @Nullable final java.lang.String rEDistributionRuleParam1 )
    {
        rememberChangedField("REDistributionRuleParam1", this.rEDistributionRuleParam1);
        this.rEDistributionRuleParam1 = rEDistributionRuleParam1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>REDistributionRuleParam2</b>
     * </p>
     * 
     * @param rEDistributionRuleParam2
     *            Untypified Parameter for a Distribution Formula
     */
    public void setREDistributionRuleParam2( @Nullable final java.lang.String rEDistributionRuleParam2 )
    {
        rememberChangedField("REDistributionRuleParam2", this.rEDistributionRuleParam2);
        this.rEDistributionRuleParam2 = rEDistributionRuleParam2;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REProbableEndDate</b>
     * </p>
     * 
     * @param rEProbableEndDate
     *            Probable End
     */
    public void setREProbableEndDate( @Nullable final LocalDate rEProbableEndDate )
    {
        rememberChangedField("REProbableEndDate", this.rEProbableEndDate);
        this.rEProbableEndDate = rEProbableEndDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REAssetRightOfUseEndDate</b>
     * </p>
     * 
     * @param rEAssetRightOfUseEndDate
     *            End of Usage RoU
     */
    public void setREAssetRightOfUseEndDate( @Nullable final LocalDate rEAssetRightOfUseEndDate )
    {
        rememberChangedField("REAssetRightOfUseEndDate", this.rEAssetRightOfUseEndDate);
        this.rEAssetRightOfUseEndDate = rEAssetRightOfUseEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationRuleStatus</b>
     * </p>
     * 
     * @param rEValuationRuleStatus
     *            Status for Valuation Rule
     */
    public void setREValuationRuleStatus( @Nullable final java.lang.String rEValuationRuleStatus )
    {
        rememberChangedField("REValuationRuleStatus", this.rEValuationRuleStatus);
        this.rEValuationRuleStatus = rEValuationRuleStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationStatus</b>
     * </p>
     * 
     * @param rEValuationStatus
     *            Valuation Status
     */
    public void setREValuationStatus( @Nullable final java.lang.String rEValuationStatus )
    {
        rememberChangedField("REValuationStatus", this.rEValuationStatus);
        this.rEValuationStatus = rEValuationStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationStatusReason</b>
     * </p>
     * 
     * @param rEValuationStatusReason
     *            Status Reason for Valuation Rule
     */
    public void setREValuationStatusReason( @Nullable final java.lang.String rEValuationStatusReason )
    {
        rememberChangedField("REValuationStatusReason", this.rEValuationStatusReason);
        this.rEValuationStatusReason = rEValuationStatusReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationBehavior</b>
     * </p>
     * 
     * @param rEValuationBehavior
     *            Valuation Behavior
     */
    public void setREValuationBehavior( @Nullable final java.lang.String rEValuationBehavior )
    {
        rememberChangedField("REValuationBehavior", this.rEValuationBehavior);
        this.rEValuationBehavior = rEValuationBehavior;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETaxType</b>
     * </p>
     * 
     * @param rETaxType
     *            Tax Type
     */
    public void setRETaxType( @Nullable final java.lang.String rETaxType )
    {
        rememberChangedField("RETaxType", this.rETaxType);
        this.rETaxType = rETaxType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>TaxGroup</b>
     * </p>
     * 
     * @param taxGroup
     *            Tax Group
     */
    public void setTaxGroup( @Nullable final java.lang.String taxGroup )
    {
        rememberChangedField("TaxGroup", this.taxGroup);
        this.taxGroup = taxGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REAccountingObject</b>
     * </p>
     * 
     * @param rEAccountingObject
     *            Object Number Valuation Account Assignment
     */
    public void setREAccountingObject( @Nullable final java.lang.String rEAccountingObject )
    {
        rememberChangedField("REAccountingObject", this.rEAccountingObject);
        this.rEAccountingObject = rEAccountingObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>REInfoText</b>
     * </p>
     * 
     * @param rEInfoText
     *            Valuation Note
     */
    public void setREInfoText( @Nullable final java.lang.String rEInfoText )
    {
        rememberChangedField("REInfoText", this.rEInfoText);
        this.rEInfoText = rEInfoText;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REValuationFactorNumerator</b>
     * </p>
     * 
     * @param rEValuationFactorNumerator
     *            Numerator Valuation Factor
     */
    public void setREValuationFactorNumerator( @Nullable final Integer rEValuationFactorNumerator )
    {
        rememberChangedField("REValuationFactorNumerator", this.rEValuationFactorNumerator);
        this.rEValuationFactorNumerator = rEValuationFactorNumerator;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REValuationFactorDenominator</b>
     * </p>
     * 
     * @param rEValuationFactorDenominator
     *            Denominator Valuation Factor
     */
    public void setREValuationFactorDenominator( @Nullable final Integer rEValuationFactorDenominator )
    {
        rememberChangedField("REValuationFactorDenominator", this.rEValuationFactorDenominator);
        this.rEValuationFactorDenominator = rEValuationFactorDenominator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCurrency</b>
     * </p>
     * 
     * @param rEValuationCurrency
     *            Valuation Rule Currency
     */
    public void setREValuationCurrency( @Nullable final java.lang.String rEValuationCurrency )
    {
        rememberChangedField("REValuationCurrency", this.rEValuationCurrency);
        this.rEValuationCurrency = rEValuationCurrency;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REValuationQuestionnaireUUID</b>
     * </p>
     * 
     * @param rEValuationQuestionnaireUUID
     *            GUID for Questionnaire
     */
    public void setREValuationQuestionnaireUUID( @Nullable final UUID rEValuationQuestionnaireUUID )
    {
        rememberChangedField("REValuationQuestionnaireUUID", this.rEValuationQuestionnaireUUID);
        this.rEValuationQuestionnaireUUID = rEValuationQuestionnaireUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     * 
     * @param country
     *            Country Key
     */
    public void setCountry( @Nullable final java.lang.String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrValuation";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        entityKey.addKeyProperty("RETermNumber", getRETermNumber());
        entityKey.addKeyProperty("ValidityStartEndDateValue", getValidityStartEndDateValue());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("RETermNumber", getRETermNumber());
        values.put("ValidityStartEndDateValue", getValidityStartEndDateValue());
        values.put("RETermType", getRETermType());
        values.put("RETermName", getRETermName());
        values.put("REValuationRule", getREValuationRule());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("REStatusObject", getREStatusObject());
        values.put("RealEstateObjectType", getRealEstateObjectType());
        values.put("REIdentification", getREIdentification());
        values.put("ObjectValidFrom", getObjectValidFrom());
        values.put("REConsiderationStartDate", getREConsiderationStartDate());
        values.put("RECashFlowPostingFromDate", getRECashFlowPostingFromDate());
        values.put("REStatusObjectAsset", getREStatusObjectAsset());
        values.put("REValuationClassification", getREValuationClassification());
        values.put("REInterestRate", getREInterestRate());
        values.put("REFrequencyTerm", getREFrequencyTerm());
        values.put("REDistributionRule", getREDistributionRule());
        values.put("REDistributionRuleParam1", getREDistributionRuleParam1());
        values.put("REDistributionRuleParam2", getREDistributionRuleParam2());
        values.put("REProbableEndDate", getREProbableEndDate());
        values.put("REAssetRightOfUseEndDate", getREAssetRightOfUseEndDate());
        values.put("REValuationRuleStatus", getREValuationRuleStatus());
        values.put("REValuationStatus", getREValuationStatus());
        values.put("REValuationStatusReason", getREValuationStatusReason());
        values.put("REValuationBehavior", getREValuationBehavior());
        values.put("RETaxType", getRETaxType());
        values.put("TaxGroup", getTaxGroup());
        values.put("REAccountingObject", getREAccountingObject());
        values.put("REInfoText", getREInfoText());
        values.put("REValuationFactorNumerator", getREValuationFactorNumerator());
        values.put("REValuationFactorDenominator", getREValuationFactorDenominator());
        values.put("REValuationCurrency", getREValuationCurrency());
        values.put("REValuationQuestionnaireUUID", getREValuationQuestionnaireUUID());
        values.put("Country", getCountry());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermNumber") ) {
                final Object value = values.remove("RETermNumber");
                if( (value == null) || (!value.equals(getRETermNumber())) ) {
                    setRETermNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartEndDateValue") ) {
                final Object value = values.remove("ValidityStartEndDateValue");
                if( (value == null) || (!value.equals(getValidityStartEndDateValue())) ) {
                    setValidityStartEndDateValue(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermType") ) {
                final Object value = values.remove("RETermType");
                if( (value == null) || (!value.equals(getRETermType())) ) {
                    setRETermType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermName") ) {
                final Object value = values.remove("RETermName");
                if( (value == null) || (!value.equals(getRETermName())) ) {
                    setRETermName(((java.lang.String) value));
                }
            }
            if( values.containsKey("REValuationRule") ) {
                final Object value = values.remove("REValuationRule");
                if( (value == null) || (!value.equals(getREValuationRule())) ) {
                    setREValuationRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REStatusObject") ) {
                final Object value = values.remove("REStatusObject");
                if( (value == null) || (!value.equals(getREStatusObject())) ) {
                    setREStatusObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("RealEstateObjectType") ) {
                final Object value = values.remove("RealEstateObjectType");
                if( (value == null) || (!value.equals(getRealEstateObjectType())) ) {
                    setRealEstateObjectType(((java.lang.String) value));
                }
            }
            if( values.containsKey("REIdentification") ) {
                final Object value = values.remove("REIdentification");
                if( (value == null) || (!value.equals(getREIdentification())) ) {
                    setREIdentification(((java.lang.String) value));
                }
            }
            if( values.containsKey("ObjectValidFrom") ) {
                final Object value = values.remove("ObjectValidFrom");
                if( (value == null) || (!value.equals(getObjectValidFrom())) ) {
                    setObjectValidFrom(((LocalDate) value));
                }
            }
            if( values.containsKey("REConsiderationStartDate") ) {
                final Object value = values.remove("REConsiderationStartDate");
                if( (value == null) || (!value.equals(getREConsiderationStartDate())) ) {
                    setREConsiderationStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("RECashFlowPostingFromDate") ) {
                final Object value = values.remove("RECashFlowPostingFromDate");
                if( (value == null) || (!value.equals(getRECashFlowPostingFromDate())) ) {
                    setRECashFlowPostingFromDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REStatusObjectAsset") ) {
                final Object value = values.remove("REStatusObjectAsset");
                if( (value == null) || (!value.equals(getREStatusObjectAsset())) ) {
                    setREStatusObjectAsset(((java.lang.String) value));
                }
            }
            if( values.containsKey("REValuationClassification") ) {
                final Object value = values.remove("REValuationClassification");
                if( (value == null) || (!value.equals(getREValuationClassification())) ) {
                    setREValuationClassification(((java.lang.String) value));
                }
            }
            if( values.containsKey("REInterestRate") ) {
                final Object value = values.remove("REInterestRate");
                if( (value == null) || (!value.equals(getREInterestRate())) ) {
                    setREInterestRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("REFrequencyTerm") ) {
                final Object value = values.remove("REFrequencyTerm");
                if( (value == null) || (!value.equals(getREFrequencyTerm())) ) {
                    setREFrequencyTerm(((java.lang.String) value));
                }
            }
            if( values.containsKey("REDistributionRule") ) {
                final Object value = values.remove("REDistributionRule");
                if( (value == null) || (!value.equals(getREDistributionRule())) ) {
                    setREDistributionRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("REDistributionRuleParam1") ) {
                final Object value = values.remove("REDistributionRuleParam1");
                if( (value == null) || (!value.equals(getREDistributionRuleParam1())) ) {
                    setREDistributionRuleParam1(((java.lang.String) value));
                }
            }
            if( values.containsKey("REDistributionRuleParam2") ) {
                final Object value = values.remove("REDistributionRuleParam2");
                if( (value == null) || (!value.equals(getREDistributionRuleParam2())) ) {
                    setREDistributionRuleParam2(((java.lang.String) value));
                }
            }
            if( values.containsKey("REProbableEndDate") ) {
                final Object value = values.remove("REProbableEndDate");
                if( (value == null) || (!value.equals(getREProbableEndDate())) ) {
                    setREProbableEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REAssetRightOfUseEndDate") ) {
                final Object value = values.remove("REAssetRightOfUseEndDate");
                if( (value == null) || (!value.equals(getREAssetRightOfUseEndDate())) ) {
                    setREAssetRightOfUseEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REValuationRuleStatus") ) {
                final Object value = values.remove("REValuationRuleStatus");
                if( (value == null) || (!value.equals(getREValuationRuleStatus())) ) {
                    setREValuationRuleStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("REValuationStatus") ) {
                final Object value = values.remove("REValuationStatus");
                if( (value == null) || (!value.equals(getREValuationStatus())) ) {
                    setREValuationStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("REValuationStatusReason") ) {
                final Object value = values.remove("REValuationStatusReason");
                if( (value == null) || (!value.equals(getREValuationStatusReason())) ) {
                    setREValuationStatusReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("REValuationBehavior") ) {
                final Object value = values.remove("REValuationBehavior");
                if( (value == null) || (!value.equals(getREValuationBehavior())) ) {
                    setREValuationBehavior(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETaxType") ) {
                final Object value = values.remove("RETaxType");
                if( (value == null) || (!value.equals(getRETaxType())) ) {
                    setRETaxType(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxGroup") ) {
                final Object value = values.remove("TaxGroup");
                if( (value == null) || (!value.equals(getTaxGroup())) ) {
                    setTaxGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAccountingObject") ) {
                final Object value = values.remove("REAccountingObject");
                if( (value == null) || (!value.equals(getREAccountingObject())) ) {
                    setREAccountingObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("REInfoText") ) {
                final Object value = values.remove("REInfoText");
                if( (value == null) || (!value.equals(getREInfoText())) ) {
                    setREInfoText(((java.lang.String) value));
                }
            }
            if( values.containsKey("REValuationFactorNumerator") ) {
                final Object value = values.remove("REValuationFactorNumerator");
                if( (value == null) || (!value.equals(getREValuationFactorNumerator())) ) {
                    setREValuationFactorNumerator(((Integer) value));
                }
            }
            if( values.containsKey("REValuationFactorDenominator") ) {
                final Object value = values.remove("REValuationFactorDenominator");
                if( (value == null) || (!value.equals(getREValuationFactorDenominator())) ) {
                    setREValuationFactorDenominator(((Integer) value));
                }
            }
            if( values.containsKey("REValuationCurrency") ) {
                final Object value = values.remove("REValuationCurrency");
                if( (value == null) || (!value.equals(getREValuationCurrency())) ) {
                    setREValuationCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("REValuationQuestionnaireUUID") ) {
                final Object value = values.remove("REValuationQuestionnaireUUID");
                if( (value == null) || (!value.equals(getREValuationQuestionnaireUUID())) ) {
                    setREValuationQuestionnaireUUID(((UUID) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrValuation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrValuation instances.
     * 
     */
    public final static class REContrValuationBuilder
    {

        private REContract to_REContract;

        private REContrValuation.REContrValuationBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrValuation</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrValuation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrValuation.REContrValuationBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
