/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContrValuationConditionType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContrValuationCondition extends VdmEntity<REContrValuationCondition> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContrValuationConditionType";
    /**
     * Selector for all available fields of REContrValuationCondition.
     * 
     */
    public final static SimpleProperty<REContrValuationCondition> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContrValuationCondition> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContrValuationCondition>(
            REContrValuationCondition.class,
            "InternalRealEstateNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @return Term Number
     */
    @Nullable
    @ElementName( "RETermNumber" )
    private java.lang.String rETermNumber;
    public final static SimpleProperty.String<REContrValuationCondition> RE_TERM_NUMBER =
        new SimpleProperty.String<REContrValuationCondition>(REContrValuationCondition.class, "RETermNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @return Date from to (RAP Key)
     */
    @Nullable
    @ElementName( "ValidityStartEndDateValue" )
    private java.lang.String validityStartEndDateValue;
    public final static SimpleProperty.String<REContrValuationCondition> VALIDITY_START_END_DATE_VALUE =
        new SimpleProperty.String<REContrValuationCondition>(
            REContrValuationCondition.class,
            "ValidityStartEndDateValue");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REConditionType</b>
     * </p>
     * 
     * @return Condition Type
     */
    @Nullable
    @ElementName( "REConditionType" )
    private java.lang.String rEConditionType;
    public final static SimpleProperty.String<REContrValuationCondition> RE_CONDITION_TYPE =
        new SimpleProperty.String<REContrValuationCondition>(REContrValuationCondition.class, "REConditionType");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REConditionValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "REConditionValidityStartDate" )
    private LocalDate rEConditionValidityStartDate;
    public final static SimpleProperty.Date<REContrValuationCondition> RE_CONDITION_VALIDITY_START_DATE =
        new SimpleProperty.Date<REContrValuationCondition>(
            REContrValuationCondition.class,
            "REConditionValidityStartDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REExtConditionPurpose</b>
     * </p>
     * 
     * @return Conditions - External Purpose
     */
    @Nullable
    @ElementName( "REExtConditionPurpose" )
    private java.lang.String rEExtConditionPurpose;
    public final static SimpleProperty.String<REContrValuationCondition> RE_EXT_CONDITION_PURPOSE =
        new SimpleProperty.String<REContrValuationCondition>(REContrValuationCondition.class, "REExtConditionPurpose");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectCalculation</b>
     * </p>
     * 
     * @return Object Number for Calculation
     */
    @Nullable
    @ElementName( "REStatusObjectCalculation" )
    private java.lang.String rEStatusObjectCalculation;
    public final static SimpleProperty.String<REContrValuationCondition> RE_STATUS_OBJECT_CALCULATION =
        new SimpleProperty.String<REContrValuationCondition>(
            REContrValuationCondition.class,
            "REStatusObjectCalculation");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @return Name of Term
     */
    @Nullable
    @ElementName( "RETermName" )
    private java.lang.String rETermName;
    public final static SimpleProperty.String<REContrValuationCondition> RE_TERM_NAME =
        new SimpleProperty.String<REContrValuationCondition>(REContrValuationCondition.class, "RETermName");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Validity Start Date
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<REContrValuationCondition> VALIDITY_START_DATE =
        new SimpleProperty.Date<REContrValuationCondition>(REContrValuationCondition.class, "ValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<REContrValuationCondition> VALIDITY_END_DATE =
        new SimpleProperty.Date<REContrValuationCondition>(REContrValuationCondition.class, "ValidityEndDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REConditionValidityEndDate</b>
     * </p>
     * 
     * @return Validity End Date
     */
    @Nullable
    @ElementName( "REConditionValidityEndDate" )
    private LocalDate rEConditionValidityEndDate;
    public final static SimpleProperty.Date<REContrValuationCondition> RE_CONDITION_VALIDITY_END_DATE =
        new SimpleProperty.Date<REContrValuationCondition>(
            REContrValuationCondition.class,
            "REConditionValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCndnProperty</b>
     * </p>
     * 
     * @return Condition Valuation Property
     */
    @Nullable
    @ElementName( "REValuationCndnProperty" )
    private java.lang.String rEValuationCndnProperty;
    public final static SimpleProperty.String<REContrValuationCondition> RE_VALUATION_CNDN_PROPERTY =
        new SimpleProperty.String<REContrValuationCondition>(
            REContrValuationCondition.class,
            "REValuationCndnProperty");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCndnConsdtn</b>
     * </p>
     * 
     * @return Condition Consideration
     */
    @Nullable
    @ElementName( "REValuationCndnConsdtn" )
    private java.lang.String rEValuationCndnConsdtn;
    public final static SimpleProperty.String<REContrValuationCondition> RE_VALUATION_CNDN_CONSDTN =
        new SimpleProperty.String<REContrValuationCondition>(REContrValuationCondition.class, "REValuationCndnConsdtn");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsValuationCndnConsdtn</b>
     * </p>
     * 
     * @return Indicator: Consider Condition?
     */
    @Nullable
    @ElementName( "REIsValuationCndnConsdtn" )
    private java.lang.Boolean rEIsValuationCndnConsdtn;
    public final static SimpleProperty.Boolean<REContrValuationCondition> RE_IS_VALUATION_CNDN_CONSDTN =
        new SimpleProperty.Boolean<REContrValuationCondition>(
            REContrValuationCondition.class,
            "REIsValuationCndnConsdtn");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCndnSharePercent</b>
     * </p>
     * 
     * @return Percentage Share of Condition
     */
    @Nullable
    @ElementName( "REValuationCndnSharePercent" )
    @DecimalDescriptor( precision = 7, scale = 4 )
    private BigDecimal rEValuationCndnSharePercent;
    public final static SimpleProperty.NumericDecimal<REContrValuationCondition> RE_VALUATION_CNDN_SHARE_PERCENT =
        new SimpleProperty.NumericDecimal<REContrValuationCondition>(
            REContrValuationCondition.class,
            "REValuationCndnSharePercent");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCndnShareAbsltAmt</b>
     * </p>
     * 
     * @return Absolute Share of Condition
     */
    @Nullable
    @ElementName( "REValuationCndnShareAbsltAmt" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal rEValuationCndnShareAbsltAmt;
    public final static SimpleProperty.NumericDecimal<REContrValuationCondition> RE_VALUATION_CNDN_SHARE_ABSLT_AMT =
        new SimpleProperty.NumericDecimal<REContrValuationCondition>(
            REContrValuationCondition.class,
            "REValuationCndnShareAbsltAmt");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCurrency</b>
     * </p>
     * 
     * @return Currency
     */
    @Nullable
    @ElementName( "REValuationCurrency" )
    private java.lang.String rEValuationCurrency;
    public final static SimpleProperty.String<REContrValuationCondition> RE_VALUATION_CURRENCY =
        new SimpleProperty.String<REContrValuationCondition>(REContrValuationCondition.class, "REValuationCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCndnStatus</b>
     * </p>
     * 
     * @return Status of Condition-Specific Valuation Rule
     */
    @Nullable
    @ElementName( "REValuationCndnStatus" )
    private java.lang.String rEValuationCndnStatus;
    public final static SimpleProperty.String<REContrValuationCondition> RE_VALUATION_CNDN_STATUS =
        new SimpleProperty.String<REContrValuationCondition>(REContrValuationCondition.class, "REValuationCndnStatus");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>REInfoText</b>
     * </p>
     * 
     * @return Valuation Note
     */
    @Nullable
    @ElementName( "REInfoText" )
    private java.lang.String rEInfoText;
    public final static SimpleProperty.String<REContrValuationCondition> RE_INFO_TEXT =
        new SimpleProperty.String<REContrValuationCondition>(REContrValuationCondition.class, "REInfoText");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrValuationCondition, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContrValuationCondition, SAP__Message>(
            REContrValuationCondition.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REContract</b> for <b>REContrValuationCondition</b> to single <b>REContract</b>.
     * 
     */
    @ElementName( "_REContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private REContract to_REContract;
    /**
     * Use with available request builders to apply the <b>_REContract</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrValuationCondition, REContract> TO__R_E_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<REContrValuationCondition, REContract>(
            REContrValuationCondition.class,
            "_REContract",
            REContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContrValuationCondition> getType()
    {
        return REContrValuationCondition.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RETermNumber</b>
     * </p>
     * 
     * @param rETermNumber
     *            Term Number
     */
    public void setRETermNumber( @Nullable final java.lang.String rETermNumber )
    {
        rememberChangedField("RETermNumber", this.rETermNumber);
        this.rETermNumber = rETermNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartEndDateValue</b>
     * </p>
     * 
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     */
    public void setValidityStartEndDateValue( @Nullable final java.lang.String validityStartEndDateValue )
    {
        rememberChangedField("ValidityStartEndDateValue", this.validityStartEndDateValue);
        this.validityStartEndDateValue = validityStartEndDateValue;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REConditionType</b>
     * </p>
     * 
     * @param rEConditionType
     *            Condition Type
     */
    public void setREConditionType( @Nullable final java.lang.String rEConditionType )
    {
        rememberChangedField("REConditionType", this.rEConditionType);
        this.rEConditionType = rEConditionType;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REConditionValidityStartDate</b>
     * </p>
     * 
     * @param rEConditionValidityStartDate
     *            Validity Start Date
     */
    public void setREConditionValidityStartDate( @Nullable final LocalDate rEConditionValidityStartDate )
    {
        rememberChangedField("REConditionValidityStartDate", this.rEConditionValidityStartDate);
        this.rEConditionValidityStartDate = rEConditionValidityStartDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REExtConditionPurpose</b>
     * </p>
     * 
     * @param rEExtConditionPurpose
     *            Conditions - External Purpose
     */
    public void setREExtConditionPurpose( @Nullable final java.lang.String rEExtConditionPurpose )
    {
        rememberChangedField("REExtConditionPurpose", this.rEExtConditionPurpose);
        this.rEExtConditionPurpose = rEExtConditionPurpose;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObjectCalculation</b>
     * </p>
     * 
     * @param rEStatusObjectCalculation
     *            Object Number for Calculation
     */
    public void setREStatusObjectCalculation( @Nullable final java.lang.String rEStatusObjectCalculation )
    {
        rememberChangedField("REStatusObjectCalculation", this.rEStatusObjectCalculation);
        this.rEStatusObjectCalculation = rEStatusObjectCalculation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RETermName</b>
     * </p>
     * 
     * @param rETermName
     *            Name of Term
     */
    public void setRETermName( @Nullable final java.lang.String rETermName )
    {
        rememberChangedField("RETermName", this.rETermName);
        this.rETermName = rETermName;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REConditionValidityEndDate</b>
     * </p>
     * 
     * @param rEConditionValidityEndDate
     *            Validity End Date
     */
    public void setREConditionValidityEndDate( @Nullable final LocalDate rEConditionValidityEndDate )
    {
        rememberChangedField("REConditionValidityEndDate", this.rEConditionValidityEndDate);
        this.rEConditionValidityEndDate = rEConditionValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCndnProperty</b>
     * </p>
     * 
     * @param rEValuationCndnProperty
     *            Condition Valuation Property
     */
    public void setREValuationCndnProperty( @Nullable final java.lang.String rEValuationCndnProperty )
    {
        rememberChangedField("REValuationCndnProperty", this.rEValuationCndnProperty);
        this.rEValuationCndnProperty = rEValuationCndnProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCndnConsdtn</b>
     * </p>
     * 
     * @param rEValuationCndnConsdtn
     *            Condition Consideration
     */
    public void setREValuationCndnConsdtn( @Nullable final java.lang.String rEValuationCndnConsdtn )
    {
        rememberChangedField("REValuationCndnConsdtn", this.rEValuationCndnConsdtn);
        this.rEValuationCndnConsdtn = rEValuationCndnConsdtn;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsValuationCndnConsdtn</b>
     * </p>
     * 
     * @param rEIsValuationCndnConsdtn
     *            Indicator: Consider Condition?
     */
    public void setREIsValuationCndnConsdtn( @Nullable final java.lang.Boolean rEIsValuationCndnConsdtn )
    {
        rememberChangedField("REIsValuationCndnConsdtn", this.rEIsValuationCndnConsdtn);
        this.rEIsValuationCndnConsdtn = rEIsValuationCndnConsdtn;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCndnSharePercent</b>
     * </p>
     * 
     * @param rEValuationCndnSharePercent
     *            Percentage Share of Condition
     */
    public void setREValuationCndnSharePercent( @Nullable final BigDecimal rEValuationCndnSharePercent )
    {
        rememberChangedField("REValuationCndnSharePercent", this.rEValuationCndnSharePercent);
        this.rEValuationCndnSharePercent = rEValuationCndnSharePercent;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCndnShareAbsltAmt</b>
     * </p>
     * 
     * @param rEValuationCndnShareAbsltAmt
     *            Absolute Share of Condition
     */
    public void setREValuationCndnShareAbsltAmt( @Nullable final BigDecimal rEValuationCndnShareAbsltAmt )
    {
        rememberChangedField("REValuationCndnShareAbsltAmt", this.rEValuationCndnShareAbsltAmt);
        this.rEValuationCndnShareAbsltAmt = rEValuationCndnShareAbsltAmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCurrency</b>
     * </p>
     * 
     * @param rEValuationCurrency
     *            Currency
     */
    public void setREValuationCurrency( @Nullable final java.lang.String rEValuationCurrency )
    {
        rememberChangedField("REValuationCurrency", this.rEValuationCurrency);
        this.rEValuationCurrency = rEValuationCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>REValuationCndnStatus</b>
     * </p>
     * 
     * @param rEValuationCndnStatus
     *            Status of Condition-Specific Valuation Rule
     */
    public void setREValuationCndnStatus( @Nullable final java.lang.String rEValuationCndnStatus )
    {
        rememberChangedField("REValuationCndnStatus", this.rEValuationCndnStatus);
        this.rEValuationCndnStatus = rEValuationCndnStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>REInfoText</b>
     * </p>
     * 
     * @param rEInfoText
     *            Valuation Note
     */
    public void setREInfoText( @Nullable final java.lang.String rEInfoText )
    {
        rememberChangedField("REInfoText", this.rEInfoText);
        this.rEInfoText = rEInfoText;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContrValuationCondition";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        entityKey.addKeyProperty("RETermNumber", getRETermNumber());
        entityKey.addKeyProperty("ValidityStartEndDateValue", getValidityStartEndDateValue());
        entityKey.addKeyProperty("REConditionType", getREConditionType());
        entityKey.addKeyProperty("REConditionValidityStartDate", getREConditionValidityStartDate());
        entityKey.addKeyProperty("REExtConditionPurpose", getREExtConditionPurpose());
        entityKey.addKeyProperty("REStatusObjectCalculation", getREStatusObjectCalculation());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("RETermNumber", getRETermNumber());
        values.put("ValidityStartEndDateValue", getValidityStartEndDateValue());
        values.put("REConditionType", getREConditionType());
        values.put("REConditionValidityStartDate", getREConditionValidityStartDate());
        values.put("REExtConditionPurpose", getREExtConditionPurpose());
        values.put("REStatusObjectCalculation", getREStatusObjectCalculation());
        values.put("RETermName", getRETermName());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("REConditionValidityEndDate", getREConditionValidityEndDate());
        values.put("REValuationCndnProperty", getREValuationCndnProperty());
        values.put("REValuationCndnConsdtn", getREValuationCndnConsdtn());
        values.put("REIsValuationCndnConsdtn", getREIsValuationCndnConsdtn());
        values.put("REValuationCndnSharePercent", getREValuationCndnSharePercent());
        values.put("REValuationCndnShareAbsltAmt", getREValuationCndnShareAbsltAmt());
        values.put("REValuationCurrency", getREValuationCurrency());
        values.put("REValuationCndnStatus", getREValuationCndnStatus());
        values.put("REInfoText", getREInfoText());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermNumber") ) {
                final Object value = values.remove("RETermNumber");
                if( (value == null) || (!value.equals(getRETermNumber())) ) {
                    setRETermNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartEndDateValue") ) {
                final Object value = values.remove("ValidityStartEndDateValue");
                if( (value == null) || (!value.equals(getValidityStartEndDateValue())) ) {
                    setValidityStartEndDateValue(((java.lang.String) value));
                }
            }
            if( values.containsKey("REConditionType") ) {
                final Object value = values.remove("REConditionType");
                if( (value == null) || (!value.equals(getREConditionType())) ) {
                    setREConditionType(((java.lang.String) value));
                }
            }
            if( values.containsKey("REConditionValidityStartDate") ) {
                final Object value = values.remove("REConditionValidityStartDate");
                if( (value == null) || (!value.equals(getREConditionValidityStartDate())) ) {
                    setREConditionValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REExtConditionPurpose") ) {
                final Object value = values.remove("REExtConditionPurpose");
                if( (value == null) || (!value.equals(getREExtConditionPurpose())) ) {
                    setREExtConditionPurpose(((java.lang.String) value));
                }
            }
            if( values.containsKey("REStatusObjectCalculation") ) {
                final Object value = values.remove("REStatusObjectCalculation");
                if( (value == null) || (!value.equals(getREStatusObjectCalculation())) ) {
                    setREStatusObjectCalculation(((java.lang.String) value));
                }
            }
            if( values.containsKey("RETermName") ) {
                final Object value = values.remove("RETermName");
                if( (value == null) || (!value.equals(getRETermName())) ) {
                    setRETermName(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REConditionValidityEndDate") ) {
                final Object value = values.remove("REConditionValidityEndDate");
                if( (value == null) || (!value.equals(getREConditionValidityEndDate())) ) {
                    setREConditionValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REValuationCndnProperty") ) {
                final Object value = values.remove("REValuationCndnProperty");
                if( (value == null) || (!value.equals(getREValuationCndnProperty())) ) {
                    setREValuationCndnProperty(((java.lang.String) value));
                }
            }
            if( values.containsKey("REValuationCndnConsdtn") ) {
                final Object value = values.remove("REValuationCndnConsdtn");
                if( (value == null) || (!value.equals(getREValuationCndnConsdtn())) ) {
                    setREValuationCndnConsdtn(((java.lang.String) value));
                }
            }
            if( values.containsKey("REIsValuationCndnConsdtn") ) {
                final Object value = values.remove("REIsValuationCndnConsdtn");
                if( (value == null) || (!value.equals(getREIsValuationCndnConsdtn())) ) {
                    setREIsValuationCndnConsdtn(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REValuationCndnSharePercent") ) {
                final Object value = values.remove("REValuationCndnSharePercent");
                if( (value == null) || (!value.equals(getREValuationCndnSharePercent())) ) {
                    setREValuationCndnSharePercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("REValuationCndnShareAbsltAmt") ) {
                final Object value = values.remove("REValuationCndnShareAbsltAmt");
                if( (value == null) || (!value.equals(getREValuationCndnShareAbsltAmt())) ) {
                    setREValuationCndnShareAbsltAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("REValuationCurrency") ) {
                final Object value = values.remove("REValuationCurrency");
                if( (value == null) || (!value.equals(getREValuationCurrency())) ) {
                    setREValuationCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("REValuationCndnStatus") ) {
                final Object value = values.remove("REValuationCndnStatus");
                if( (value == null) || (!value.equals(getREValuationCndnStatus())) ) {
                    setREValuationCndnStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("REInfoText") ) {
                final Object value = values.remove("REInfoText");
                if( (value == null) || (!value.equals(getREInfoText())) ) {
                    setREInfoText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REContract") ) {
                final Object value = (values).remove("_REContract");
                if( value instanceof Map ) {
                    if( to_REContract == null ) {
                        to_REContract = new REContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_REContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REContract != null ) {
            (values).put("_REContract", to_REContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContract</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_REContract</b>.
     * <p>
     * If the navigation property for an entity <b>REContrValuationCondition</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REContract</b> is already loaded, the result will contain
     *         the <b>REContract</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<REContract> getREContractIfPresent()
    {
        return Option.of(to_REContract);
    }

    /**
     * Overwrites the associated <b>REContract</b> entity for the loaded navigation property <b>_REContract</b>.
     * 
     * @param value
     *            New <b>REContract</b> entity.
     */
    public void setREContract( final REContract value )
    {
        to_REContract = value;
    }

    /**
     * Helper class to allow for fluent creation of REContrValuationCondition instances.
     * 
     */
    public final static class REContrValuationConditionBuilder
    {

        private REContract to_REContract;

        private REContrValuationCondition.REContrValuationConditionBuilder to_REContract( final REContract value )
        {
            to_REContract = value;
            return this;
        }

        /**
         * Navigation property <b>_REContract</b> for <b>REContrValuationCondition</b> to single <b>REContract</b>.
         * 
         * @param value
         *            The REContract to build this REContrValuationCondition with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContrValuationCondition.REContrValuationConditionBuilder reContract( final REContract value )
        {
            return to_REContract(value);
        }

    }

}
