/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.RealEstateContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_REContractType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class REContract extends VdmEntity<REContract> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_recontract.v0001.A_REContractType";
    /**
     * Selector for all available fields of REContract.
     * 
     */
    public final static SimpleProperty<REContract> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object
     */
    @Nullable
    @ElementName( "InternalRealEstateNumber" )
    private java.lang.String internalRealEstateNumber;
    public final static SimpleProperty.String<REContract> INTERNAL_REAL_ESTATE_NUMBER =
        new SimpleProperty.String<REContract>(REContract.class, "InternalRealEstateNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<REContract> COMPANY_CODE =
        new SimpleProperty.String<REContract>(REContract.class, "CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateContract</b>
     * </p>
     * 
     * @return Real Estate Contract
     */
    @Nullable
    @ElementName( "RealEstateContract" )
    private java.lang.String realEstateContract;
    public final static SimpleProperty.String<REContract> REAL_ESTATE_CONTRACT =
        new SimpleProperty.String<REContract>(REContract.class, "RealEstateContract");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObject</b>
     * </p>
     * 
     * @return Object Number
     */
    @Nullable
    @ElementName( "REStatusObject" )
    private java.lang.String rEStatusObject;
    public final static SimpleProperty.String<REContract> RE_STATUS_OBJECT =
        new SimpleProperty.String<REContract>(REContract.class, "REStatusObject");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>REInternalFinNumber</b>
     * </p>
     * 
     * @return Internal Key of Real Estate Object (FI)
     */
    @Nullable
    @ElementName( "REInternalFinNumber" )
    private java.lang.String rEInternalFinNumber;
    public final static SimpleProperty.String<REContract> RE_INTERNAL_FIN_NUMBER =
        new SimpleProperty.String<REContract>(REContract.class, "REInternalFinNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RECreationType</b>
     * </p>
     * 
     * @return How the Object Was Created
     */
    @Nullable
    @ElementName( "RECreationType" )
    private java.lang.String rECreationType;
    public final static SimpleProperty.String<REContract> RE_CREATION_TYPE =
        new SimpleProperty.String<REContract>(REContract.class, "RECreationType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Entered By
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<REContract> CREATED_BY_USER =
        new SimpleProperty.String<REContract>(REContract.class, "CreatedByUser");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return First Entered On
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<REContract> CREATION_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "CreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @return Time of Creation
     */
    @Nullable
    @ElementName( "CreationTime" )
    private LocalTime creationTime;
    public final static SimpleProperty.Time<REContract> CREATION_TIME =
        new SimpleProperty.Time<REContract>(REContract.class, "CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RESourceOfCreation</b>
     * </p>
     * 
     * @return Source of Initial Entry
     */
    @Nullable
    @ElementName( "RESourceOfCreation" )
    private java.lang.String rESourceOfCreation;
    public final static SimpleProperty.String<REContract> RE_SOURCE_OF_CREATION =
        new SimpleProperty.String<REContract>(REContract.class, "RESourceOfCreation");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Employee ID
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<REContract> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<REContract>(REContract.class, "LastChangedByUser");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     * 
     * @return Last Edited On
     */
    @Nullable
    @ElementName( "LastChangeDate" )
    private LocalDate lastChangeDate;
    public final static SimpleProperty.Date<REContract> LAST_CHANGE_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "LastChangeDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     * 
     * @return Last Edited At
     */
    @Nullable
    @ElementName( "LastChangeTime" )
    private LocalTime lastChangeTime;
    public final static SimpleProperty.Time<REContract> LAST_CHANGE_TIME =
        new SimpleProperty.Time<REContract>(REContract.class, "LastChangeTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RESourceOfChange</b>
     * </p>
     * 
     * @return Editing Source
     */
    @Nullable
    @ElementName( "RESourceOfChange" )
    private java.lang.String rESourceOfChange;
    public final static SimpleProperty.String<REContract> RE_SOURCE_OF_CHANGE =
        new SimpleProperty.String<REContract>(REContract.class, "RESourceOfChange");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Responsible</b>
     * </p>
     * 
     * @return Person Responsible
     */
    @Nullable
    @ElementName( "Responsible" )
    private java.lang.String responsible;
    public final static SimpleProperty.String<REContract> RESPONSIBLE =
        new SimpleProperty.String<REContract>(REContract.class, "Responsible");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>REUserExclusive</b>
     * </p>
     * 
     * @return User with Exclusive Change Authorization
     */
    @Nullable
    @ElementName( "REUserExclusive" )
    private java.lang.String rEUserExclusive;
    public final static SimpleProperty.String<REContract> RE_USER_EXCLUSIVE =
        new SimpleProperty.String<REContract>(REContract.class, "REUserExclusive");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>REAuthorizationGroup</b>
     * </p>
     * 
     * @return Authorization Group
     */
    @Nullable
    @ElementName( "REAuthorizationGroup" )
    private java.lang.String rEAuthorizationGroup;
    public final static SimpleProperty.String<REContract> RE_AUTHORIZATION_GROUP =
        new SimpleProperty.String<REContract>(REContract.class, "REAuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REContractType</b>
     * </p>
     * 
     * @return Contract Type
     */
    @Nullable
    @ElementName( "REContractType" )
    private java.lang.String rEContractType;
    public final static SimpleProperty.String<REContract> RE_CONTRACT_TYPE =
        new SimpleProperty.String<REContract>(REContract.class, "REContractType");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ContractStartDate</b>
     * </p>
     * 
     * @return Date of contract start
     */
    @Nullable
    @ElementName( "ContractStartDate" )
    private LocalDate contractStartDate;
    public final static SimpleProperty.Date<REContract> CONTRACT_START_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "ContractStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ContractEndDate</b>
     * </p>
     * 
     * @return End of Term
     */
    @Nullable
    @ElementName( "ContractEndDate" )
    private LocalDate contractEndDate;
    public final static SimpleProperty.Date<REContract> CONTRACT_END_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "ContractEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>REContractName</b>
     * </p>
     * 
     * @return Contract name
     */
    @Nullable
    @ElementName( "REContractName" )
    private java.lang.String rEContractName;
    public final static SimpleProperty.String<REContract> RE_CONTRACT_NAME =
        new SimpleProperty.String<REContract>(REContract.class, "REContractName");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractActivateDate</b>
     * </p>
     * 
     * @return Contract activation
     */
    @Nullable
    @ElementName( "REContractActivateDate" )
    private LocalDate rEContractActivateDate;
    public final static SimpleProperty.Date<REContract> RE_CONTRACT_ACTIVATE_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "REContractActivateDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RETenancyLaw</b>
     * </p>
     * 
     * @return Tenancy law
     */
    @Nullable
    @ElementName( "RETenancyLaw" )
    private java.lang.String rETenancyLaw;
    public final static SimpleProperty.String<REContract> RE_TENANCY_LAW =
        new SimpleProperty.String<REContract>(REContract.class, "RETenancyLaw");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>REContractNumberOld</b>
     * </p>
     * 
     * @return Number of old contract
     */
    @Nullable
    @ElementName( "REContractNumberOld" )
    private java.lang.String rEContractNumberOld;
    public final static SimpleProperty.String<REContract> RE_CONTRACT_NUMBER_OLD =
        new SimpleProperty.String<REContract>(REContract.class, "REContractNumberOld");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REMainContractCompanyCode</b>
     * </p>
     * 
     * @return Company code of main contract
     */
    @Nullable
    @ElementName( "REMainContractCompanyCode" )
    private java.lang.String rEMainContractCompanyCode;
    public final static SimpleProperty.String<REContract> RE_MAIN_CONTRACT_COMPANY_CODE =
        new SimpleProperty.String<REContract>(REContract.class, "REMainContractCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>REMainContract</b>
     * </p>
     * 
     * @return Number of Real Estate Main Contract
     */
    @Nullable
    @ElementName( "REMainContract" )
    private java.lang.String rEMainContract;
    public final static SimpleProperty.String<REContract> RE_MAIN_CONTRACT =
        new SimpleProperty.String<REContract>(REContract.class, "REMainContract");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>REContractCurrency</b>
     * </p>
     * 
     * @return Currency for Contract
     */
    @Nullable
    @ElementName( "REContractCurrency" )
    private java.lang.String rEContractCurrency;
    public final static SimpleProperty.String<REContract> RE_CONTRACT_CURRENCY =
        new SimpleProperty.String<REContract>(REContract.class, "REContractCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REIndustrySector</b>
     * </p>
     * 
     * @return Industry
     */
    @Nullable
    @ElementName( "REIndustrySector" )
    private java.lang.String rEIndustrySector;
    public final static SimpleProperty.String<REContract> RE_INDUSTRY_SECTOR =
        new SimpleProperty.String<REContract>(REContract.class, "REIndustrySector");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsSalesRelevant</b>
     * </p>
     * 
     * @return Relevant to Sales
     */
    @Nullable
    @ElementName( "REIsSalesRelevant" )
    private java.lang.Boolean rEIsSalesRelevant;
    public final static SimpleProperty.Boolean<REContract> RE_IS_SALES_RELEVANT =
        new SimpleProperty.Boolean<REContract>(REContract.class, "REIsSalesRelevant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REContractDepositType</b>
     * </p>
     * 
     * @return Security Deposit Type
     */
    @Nullable
    @ElementName( "REContractDepositType" )
    private java.lang.String rEContractDepositType;
    public final static SimpleProperty.String<REContract> RE_CONTRACT_DEPOSIT_TYPE =
        new SimpleProperty.String<REContract>(REContract.class, "REContractDepositType");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractSignDate</b>
     * </p>
     * 
     * @return Date of Contract Conclusion
     */
    @Nullable
    @ElementName( "REContractSignDate" )
    private LocalDate rEContractSignDate;
    public final static SimpleProperty.Date<REContract> RE_CONTRACT_SIGN_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "REContractSignDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContract2SignDate</b>
     * </p>
     * 
     * @return Date of Second Signature
     */
    @Nullable
    @ElementName( "REContract2SignDate" )
    private LocalDate rEContract2SignDate;
    public final static SimpleProperty.Date<REContract> RE_CONTRACT2_SIGN_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "REContract2SignDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractCashFlowDate</b>
     * </p>
     * 
     * @return Cash Flow Generated Starting On
     */
    @Nullable
    @ElementName( "REContractCashFlowDate" )
    private LocalDate rEContractCashFlowDate;
    public final static SimpleProperty.Date<REContract> RE_CONTRACT_CASH_FLOW_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "REContractCashFlowDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractFirstEndDate</b>
     * </p>
     * 
     * @return Date of First Contract End
     */
    @Nullable
    @ElementName( "REContractFirstEndDate" )
    private LocalDate rEContractFirstEndDate;
    public final static SimpleProperty.Date<REContract> RE_CONTRACT_FIRST_END_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "REContractFirstEndDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractNoticeDate</b>
     * </p>
     * 
     * @return Contract Notice Per
     */
    @Nullable
    @ElementName( "REContractNoticeDate" )
    private LocalDate rEContractNoticeDate;
    public final static SimpleProperty.Date<REContract> RE_CONTRACT_NOTICE_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "REContractNoticeDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractNoticeInDate</b>
     * </p>
     * 
     * @return Date of receipt of notice
     */
    @Nullable
    @ElementName( "REContractNoticeInDate" )
    private LocalDate rEContractNoticeInDate;
    public final static SimpleProperty.Date<REContract> RE_CONTRACT_NOTICE_IN_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "REContractNoticeInDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REContractNoticeReason</b>
     * </p>
     * 
     * @return Reason for Notice
     */
    @Nullable
    @ElementName( "REContractNoticeReason" )
    private java.lang.String rEContractNoticeReason;
    public final static SimpleProperty.String<REContract> RE_CONTRACT_NOTICE_REASON =
        new SimpleProperty.String<REContract>(REContract.class, "REContractNoticeReason");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractNoticeActivationDate</b>
     * </p>
     * 
     * @return Notice: Date of Activation
     */
    @Nullable
    @ElementName( "REContractNoticeActivationDate" )
    private LocalDate rEContractNoticeActivationDate;
    public final static SimpleProperty.Date<REContract> RE_CONTRACT_NOTICE_ACTIVATION_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "REContractNoticeActivationDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>RECashFlowArchivedToDate</b>
     * </p>
     * 
     * @return Date Up to Which the Cash Flow Is Archived
     */
    @Nullable
    @ElementName( "RECashFlowArchivedToDate" )
    private LocalDate rECashFlowArchivedToDate;
    public final static SimpleProperty.Date<REContract> RE_CASH_FLOW_ARCHIVED_TO_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "RECashFlowArchivedToDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>RECashFlowLockedToDate</b>
     * </p>
     * 
     * @return Date Until Which the Cash Flow Is Locked
     */
    @Nullable
    @ElementName( "RECashFlowLockedToDate" )
    private LocalDate rECashFlowLockedToDate;
    public final static SimpleProperty.Date<REContract> RE_CASH_FLOW_LOCKED_TO_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "RECashFlowLockedToDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>RECashFlowPostingFromDate</b>
     * </p>
     * 
     * @return First Posting From
     */
    @Nullable
    @ElementName( "RECashFlowPostingFromDate" )
    private LocalDate rECashFlowPostingFromDate;
    public final static SimpleProperty.Date<REContract> RE_CASH_FLOW_POSTING_FROM_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "RECashFlowPostingFromDate");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>REBusinessEntity</b>
     * </p>
     * 
     * @return RE Business Entity
     */
    @Nullable
    @ElementName( "REBusinessEntity" )
    private java.lang.String rEBusinessEntity;
    public final static SimpleProperty.String<REContract> RE_BUSINESS_ENTITY =
        new SimpleProperty.String<REContract>(REContract.class, "REBusinessEntity");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REPossessionStartDate</b>
     * </p>
     * 
     * @return Date From Which the Object Is Made Available for Use
     */
    @Nullable
    @ElementName( "REPossessionStartDate" )
    private LocalDate rEPossessionStartDate;
    public final static SimpleProperty.Date<REContract> RE_POSSESSION_START_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "REPossessionStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REPossessionEndDate</b>
     * </p>
     * 
     * @return Date Up to Which the Object Is Used
     */
    @Nullable
    @ElementName( "REPossessionEndDate" )
    private LocalDate rEPossessionEndDate;
    public final static SimpleProperty.Date<REContract> RE_POSSESSION_END_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "REPossessionEndDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REHasMultipleAssignments</b>
     * </p>
     * 
     * @return Multiple Assignment of Object to Group Allowed
     */
    @Nullable
    @ElementName( "REHasMultipleAssignments" )
    private java.lang.Boolean rEHasMultipleAssignments;
    public final static SimpleProperty.Boolean<REContract> RE_HAS_MULTIPLE_ASSIGNMENTS =
        new SimpleProperty.Boolean<REContract>(REContract.class, "REHasMultipleAssignments");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REObjectAvailableFromDate</b>
     * </p>
     * 
     * @return Transfer of Possession: Start Date
     */
    @Nullable
    @ElementName( "REObjectAvailableFromDate" )
    private LocalDate rEObjectAvailableFromDate;
    public final static SimpleProperty.Date<REContract> RE_OBJECT_AVAILABLE_FROM_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "REObjectAvailableFromDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REObjectAvailableToDate</b>
     * </p>
     * 
     * @return Field of type DATS
     */
    @Nullable
    @ElementName( "REObjectAvailableToDate" )
    private LocalDate rEObjectAvailableToDate;
    public final static SimpleProperty.Date<REContract> RE_OBJECT_AVAILABLE_TO_DATE =
        new SimpleProperty.Date<REContract>(REContract.class, "REObjectAvailableToDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationRelevance</b>
     * </p>
     * 
     * @return Valuation Relevance
     */
    @Nullable
    @ElementName( "ValuationRelevance" )
    private java.lang.String valuationRelevance;
    public final static SimpleProperty.String<REContract> VALUATION_RELEVANCE =
        new SimpleProperty.String<REContract>(REContract.class, "ValuationRelevance");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContract, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<REContract, SAP__Message>(
            REContract.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_REAdjustmentTermTP</b> for <b>REContract</b> to multiple <b>REContrAdjustmentTerm</b>.
     * 
     */
    @ElementName( "_REAdjustmentTermTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrAdjustmentTerm> to_REAdjustmentTermTP;
    /**
     * Navigation property <b>_REConditionTP</b> for <b>REContract</b> to multiple <b>REContrCondition</b>.
     * 
     */
    @ElementName( "_REConditionTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrCondition> to_REConditionTP;
    /**
     * Navigation property <b>_RENoticeTermForObjTP</b> for <b>REContract</b> to multiple
     * <b>REContrNoticeTermForObj</b>.
     * 
     */
    @ElementName( "_RENoticeTermForObjTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrNoticeTermForObj> to_RENoticeTermForObjTP;
    /**
     * Navigation property <b>_RENoticeTermTP</b> for <b>REContract</b> to multiple <b>REContrNoticeTerm</b>.
     * 
     */
    @ElementName( "_RENoticeTermTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrNoticeTerm> to_RENoticeTermTP;
    /**
     * Navigation property <b>_REObjAssgmtTP</b> for <b>REContract</b> to multiple <b>REContrObjAssgmt</b>.
     * 
     */
    @ElementName( "_REObjAssgmtTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrObjAssgmt> to_REObjAssgmtTP;
    /**
     * Navigation property <b>_REOrglAssgmtTermTP</b> for <b>REContract</b> to multiple <b>REContrOrglAssgmtTerm</b>.
     * 
     */
    @ElementName( "_REOrglAssgmtTermTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrOrglAssgmtTerm> to_REOrglAssgmtTermTP;
    /**
     * Navigation property <b>_REPartnerAssgmtTP</b> for <b>REContract</b> to multiple <b>REContrPartAssgmt</b>.
     * 
     */
    @ElementName( "_REPartnerAssgmtTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrPartAssgmt> to_REPartnerAssgmtTP;
    /**
     * Navigation property <b>_REPostingTermTP</b> for <b>REContract</b> to multiple <b>REContrPostingTerm</b>.
     * 
     */
    @ElementName( "_REPostingTermTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrPostingTerm> to_REPostingTermTP;
    /**
     * Navigation property <b>_REReminderDateTP</b> for <b>REContract</b> to multiple <b>REContrReminderDate</b>.
     * 
     */
    @ElementName( "_REReminderDateTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrReminderDate> to_REReminderDateTP;
    /**
     * Navigation property <b>_REReminderRuleTP</b> for <b>REContract</b> to multiple <b>REContrReminderRule</b>.
     * 
     */
    @ElementName( "_REReminderRuleTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrReminderRule> to_REReminderRuleTP;
    /**
     * Navigation property <b>_RERenewalTermTP</b> for <b>REContract</b> to multiple <b>REContrRenewalTerm</b>.
     * 
     */
    @ElementName( "_RERenewalTermTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrRenewalTerm> to_RERenewalTermTP;
    /**
     * Navigation property <b>_RERhythmTermTP</b> for <b>REContract</b> to multiple <b>REContrRhythmTerm</b>.
     * 
     */
    @ElementName( "_RERhythmTermTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrRhythmTerm> to_RERhythmTermTP;
    /**
     * Navigation property <b>_REValuationConditionTP</b> for <b>REContract</b> to multiple
     * <b>REContrValuationCondition</b>.
     * 
     */
    @ElementName( "_REValuationConditionTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrValuationCondition> to_REValuationConditionTP;
    /**
     * Navigation property <b>_REValuationTP</b> for <b>REContract</b> to multiple <b>REContrValuation</b>.
     * 
     */
    @ElementName( "_REValuationTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<REContrValuation> to_REValuationTP;
    /**
     * Use with available request builders to apply the <b>_REAdjustmentTermTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrAdjustmentTerm> TO__R_E_ADJUSTMENT_TERM_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrAdjustmentTerm>(
            REContract.class,
            "_REAdjustmentTermTP",
            REContrAdjustmentTerm.class);
    /**
     * Use with available request builders to apply the <b>_REConditionTP</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrCondition> TO__R_E_CONDITION_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrCondition>(
            REContract.class,
            "_REConditionTP",
            REContrCondition.class);
    /**
     * Use with available request builders to apply the <b>_RENoticeTermForObjTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrNoticeTermForObj> TO__R_E_NOTICE_TERM_FOR_OBJ_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrNoticeTermForObj>(
            REContract.class,
            "_RENoticeTermForObjTP",
            REContrNoticeTermForObj.class);
    /**
     * Use with available request builders to apply the <b>_RENoticeTermTP</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrNoticeTerm> TO__R_E_NOTICE_TERM_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrNoticeTerm>(
            REContract.class,
            "_RENoticeTermTP",
            REContrNoticeTerm.class);
    /**
     * Use with available request builders to apply the <b>_REObjAssgmtTP</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrObjAssgmt> TO__R_E_OBJ_ASSGMT_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrObjAssgmt>(
            REContract.class,
            "_REObjAssgmtTP",
            REContrObjAssgmt.class);
    /**
     * Use with available request builders to apply the <b>_REOrglAssgmtTermTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrOrglAssgmtTerm> TO__R_E_ORGL_ASSGMT_TERM_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrOrglAssgmtTerm>(
            REContract.class,
            "_REOrglAssgmtTermTP",
            REContrOrglAssgmtTerm.class);
    /**
     * Use with available request builders to apply the <b>_REPartnerAssgmtTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrPartAssgmt> TO__R_E_PARTNER_ASSGMT_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrPartAssgmt>(
            REContract.class,
            "_REPartnerAssgmtTP",
            REContrPartAssgmt.class);
    /**
     * Use with available request builders to apply the <b>_REPostingTermTP</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrPostingTerm> TO__R_E_POSTING_TERM_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrPostingTerm>(
            REContract.class,
            "_REPostingTermTP",
            REContrPostingTerm.class);
    /**
     * Use with available request builders to apply the <b>_REReminderDateTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrReminderDate> TO__R_E_REMINDER_DATE_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrReminderDate>(
            REContract.class,
            "_REReminderDateTP",
            REContrReminderDate.class);
    /**
     * Use with available request builders to apply the <b>_REReminderRuleTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrReminderRule> TO__R_E_REMINDER_RULE_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrReminderRule>(
            REContract.class,
            "_REReminderRuleTP",
            REContrReminderRule.class);
    /**
     * Use with available request builders to apply the <b>_RERenewalTermTP</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrRenewalTerm> TO__R_E_RENEWAL_TERM_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrRenewalTerm>(
            REContract.class,
            "_RERenewalTermTP",
            REContrRenewalTerm.class);
    /**
     * Use with available request builders to apply the <b>_RERhythmTermTP</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrRhythmTerm> TO__R_E_RHYTHM_TERM_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrRhythmTerm>(
            REContract.class,
            "_RERhythmTermTP",
            REContrRhythmTerm.class);
    /**
     * Use with available request builders to apply the <b>_REValuationConditionTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrValuationCondition> TO__R_E_VALUATION_CONDITION_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrValuationCondition>(
            REContract.class,
            "_REValuationConditionTP",
            REContrValuationCondition.class);
    /**
     * Use with available request builders to apply the <b>_REValuationTP</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrValuation> TO__R_E_VALUATION_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<REContract, REContrValuation>(
            REContract.class,
            "_REValuationTP",
            REContrValuation.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<REContract> getType()
    {
        return REContract.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>InternalRealEstateNumber</b>
     * </p>
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     */
    public void setInternalRealEstateNumber( @Nullable final java.lang.String internalRealEstateNumber )
    {
        rememberChangedField("InternalRealEstateNumber", this.internalRealEstateNumber);
        this.internalRealEstateNumber = internalRealEstateNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateContract</b>
     * </p>
     * 
     * @param realEstateContract
     *            Real Estate Contract
     */
    public void setRealEstateContract( @Nullable final java.lang.String realEstateContract )
    {
        rememberChangedField("RealEstateContract", this.realEstateContract);
        this.realEstateContract = realEstateContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>REStatusObject</b>
     * </p>
     * 
     * @param rEStatusObject
     *            Object Number
     */
    public void setREStatusObject( @Nullable final java.lang.String rEStatusObject )
    {
        rememberChangedField("REStatusObject", this.rEStatusObject);
        this.rEStatusObject = rEStatusObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>REInternalFinNumber</b>
     * </p>
     * 
     * @param rEInternalFinNumber
     *            Internal Key of Real Estate Object (FI)
     */
    public void setREInternalFinNumber( @Nullable final java.lang.String rEInternalFinNumber )
    {
        rememberChangedField("REInternalFinNumber", this.rEInternalFinNumber);
        this.rEInternalFinNumber = rEInternalFinNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RECreationType</b>
     * </p>
     * 
     * @param rECreationType
     *            How the Object Was Created
     */
    public void setRECreationType( @Nullable final java.lang.String rECreationType )
    {
        rememberChangedField("RECreationType", this.rECreationType);
        this.rECreationType = rECreationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Entered By
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            First Entered On
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @param creationTime
     *            Time of Creation
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RESourceOfCreation</b>
     * </p>
     * 
     * @param rESourceOfCreation
     *            Source of Initial Entry
     */
    public void setRESourceOfCreation( @Nullable final java.lang.String rESourceOfCreation )
    {
        rememberChangedField("RESourceOfCreation", this.rESourceOfCreation);
        this.rESourceOfCreation = rESourceOfCreation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Employee ID
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     * 
     * @param lastChangeDate
     *            Last Edited On
     */
    public void setLastChangeDate( @Nullable final LocalDate lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     * 
     * @param lastChangeTime
     *            Last Edited At
     */
    public void setLastChangeTime( @Nullable final LocalTime lastChangeTime )
    {
        rememberChangedField("LastChangeTime", this.lastChangeTime);
        this.lastChangeTime = lastChangeTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RESourceOfChange</b>
     * </p>
     * 
     * @param rESourceOfChange
     *            Editing Source
     */
    public void setRESourceOfChange( @Nullable final java.lang.String rESourceOfChange )
    {
        rememberChangedField("RESourceOfChange", this.rESourceOfChange);
        this.rESourceOfChange = rESourceOfChange;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Responsible</b>
     * </p>
     * 
     * @param responsible
     *            Person Responsible
     */
    public void setResponsible( @Nullable final java.lang.String responsible )
    {
        rememberChangedField("Responsible", this.responsible);
        this.responsible = responsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>REUserExclusive</b>
     * </p>
     * 
     * @param rEUserExclusive
     *            User with Exclusive Change Authorization
     */
    public void setREUserExclusive( @Nullable final java.lang.String rEUserExclusive )
    {
        rememberChangedField("REUserExclusive", this.rEUserExclusive);
        this.rEUserExclusive = rEUserExclusive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>REAuthorizationGroup</b>
     * </p>
     * 
     * @param rEAuthorizationGroup
     *            Authorization Group
     */
    public void setREAuthorizationGroup( @Nullable final java.lang.String rEAuthorizationGroup )
    {
        rememberChangedField("REAuthorizationGroup", this.rEAuthorizationGroup);
        this.rEAuthorizationGroup = rEAuthorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REContractType</b>
     * </p>
     * 
     * @param rEContractType
     *            Contract Type
     */
    public void setREContractType( @Nullable final java.lang.String rEContractType )
    {
        rememberChangedField("REContractType", this.rEContractType);
        this.rEContractType = rEContractType;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ContractStartDate</b>
     * </p>
     * 
     * @param contractStartDate
     *            Date of contract start
     */
    public void setContractStartDate( @Nullable final LocalDate contractStartDate )
    {
        rememberChangedField("ContractStartDate", this.contractStartDate);
        this.contractStartDate = contractStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ContractEndDate</b>
     * </p>
     * 
     * @param contractEndDate
     *            End of Term
     */
    public void setContractEndDate( @Nullable final LocalDate contractEndDate )
    {
        rememberChangedField("ContractEndDate", this.contractEndDate);
        this.contractEndDate = contractEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>REContractName</b>
     * </p>
     * 
     * @param rEContractName
     *            Contract name
     */
    public void setREContractName( @Nullable final java.lang.String rEContractName )
    {
        rememberChangedField("REContractName", this.rEContractName);
        this.rEContractName = rEContractName;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractActivateDate</b>
     * </p>
     * 
     * @param rEContractActivateDate
     *            Contract activation
     */
    public void setREContractActivateDate( @Nullable final LocalDate rEContractActivateDate )
    {
        rememberChangedField("REContractActivateDate", this.rEContractActivateDate);
        this.rEContractActivateDate = rEContractActivateDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RETenancyLaw</b>
     * </p>
     * 
     * @param rETenancyLaw
     *            Tenancy law
     */
    public void setRETenancyLaw( @Nullable final java.lang.String rETenancyLaw )
    {
        rememberChangedField("RETenancyLaw", this.rETenancyLaw);
        this.rETenancyLaw = rETenancyLaw;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>REContractNumberOld</b>
     * </p>
     * 
     * @param rEContractNumberOld
     *            Number of old contract
     */
    public void setREContractNumberOld( @Nullable final java.lang.String rEContractNumberOld )
    {
        rememberChangedField("REContractNumberOld", this.rEContractNumberOld);
        this.rEContractNumberOld = rEContractNumberOld;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REMainContractCompanyCode</b>
     * </p>
     * 
     * @param rEMainContractCompanyCode
     *            Company code of main contract
     */
    public void setREMainContractCompanyCode( @Nullable final java.lang.String rEMainContractCompanyCode )
    {
        rememberChangedField("REMainContractCompanyCode", this.rEMainContractCompanyCode);
        this.rEMainContractCompanyCode = rEMainContractCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>REMainContract</b>
     * </p>
     * 
     * @param rEMainContract
     *            Number of Real Estate Main Contract
     */
    public void setREMainContract( @Nullable final java.lang.String rEMainContract )
    {
        rememberChangedField("REMainContract", this.rEMainContract);
        this.rEMainContract = rEMainContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>REContractCurrency</b>
     * </p>
     * 
     * @param rEContractCurrency
     *            Currency for Contract
     */
    public void setREContractCurrency( @Nullable final java.lang.String rEContractCurrency )
    {
        rememberChangedField("REContractCurrency", this.rEContractCurrency);
        this.rEContractCurrency = rEContractCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>REIndustrySector</b>
     * </p>
     * 
     * @param rEIndustrySector
     *            Industry
     */
    public void setREIndustrySector( @Nullable final java.lang.String rEIndustrySector )
    {
        rememberChangedField("REIndustrySector", this.rEIndustrySector);
        this.rEIndustrySector = rEIndustrySector;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REIsSalesRelevant</b>
     * </p>
     * 
     * @param rEIsSalesRelevant
     *            Relevant to Sales
     */
    public void setREIsSalesRelevant( @Nullable final java.lang.Boolean rEIsSalesRelevant )
    {
        rememberChangedField("REIsSalesRelevant", this.rEIsSalesRelevant);
        this.rEIsSalesRelevant = rEIsSalesRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>REContractDepositType</b>
     * </p>
     * 
     * @param rEContractDepositType
     *            Security Deposit Type
     */
    public void setREContractDepositType( @Nullable final java.lang.String rEContractDepositType )
    {
        rememberChangedField("REContractDepositType", this.rEContractDepositType);
        this.rEContractDepositType = rEContractDepositType;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractSignDate</b>
     * </p>
     * 
     * @param rEContractSignDate
     *            Date of Contract Conclusion
     */
    public void setREContractSignDate( @Nullable final LocalDate rEContractSignDate )
    {
        rememberChangedField("REContractSignDate", this.rEContractSignDate);
        this.rEContractSignDate = rEContractSignDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContract2SignDate</b>
     * </p>
     * 
     * @param rEContract2SignDate
     *            Date of Second Signature
     */
    public void setREContract2SignDate( @Nullable final LocalDate rEContract2SignDate )
    {
        rememberChangedField("REContract2SignDate", this.rEContract2SignDate);
        this.rEContract2SignDate = rEContract2SignDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractCashFlowDate</b>
     * </p>
     * 
     * @param rEContractCashFlowDate
     *            Cash Flow Generated Starting On
     */
    public void setREContractCashFlowDate( @Nullable final LocalDate rEContractCashFlowDate )
    {
        rememberChangedField("REContractCashFlowDate", this.rEContractCashFlowDate);
        this.rEContractCashFlowDate = rEContractCashFlowDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractFirstEndDate</b>
     * </p>
     * 
     * @param rEContractFirstEndDate
     *            Date of First Contract End
     */
    public void setREContractFirstEndDate( @Nullable final LocalDate rEContractFirstEndDate )
    {
        rememberChangedField("REContractFirstEndDate", this.rEContractFirstEndDate);
        this.rEContractFirstEndDate = rEContractFirstEndDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractNoticeDate</b>
     * </p>
     * 
     * @param rEContractNoticeDate
     *            Contract Notice Per
     */
    public void setREContractNoticeDate( @Nullable final LocalDate rEContractNoticeDate )
    {
        rememberChangedField("REContractNoticeDate", this.rEContractNoticeDate);
        this.rEContractNoticeDate = rEContractNoticeDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractNoticeInDate</b>
     * </p>
     * 
     * @param rEContractNoticeInDate
     *            Date of receipt of notice
     */
    public void setREContractNoticeInDate( @Nullable final LocalDate rEContractNoticeInDate )
    {
        rememberChangedField("REContractNoticeInDate", this.rEContractNoticeInDate);
        this.rEContractNoticeInDate = rEContractNoticeInDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>REContractNoticeReason</b>
     * </p>
     * 
     * @param rEContractNoticeReason
     *            Reason for Notice
     */
    public void setREContractNoticeReason( @Nullable final java.lang.String rEContractNoticeReason )
    {
        rememberChangedField("REContractNoticeReason", this.rEContractNoticeReason);
        this.rEContractNoticeReason = rEContractNoticeReason;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REContractNoticeActivationDate</b>
     * </p>
     * 
     * @param rEContractNoticeActivationDate
     *            Notice: Date of Activation
     */
    public void setREContractNoticeActivationDate( @Nullable final LocalDate rEContractNoticeActivationDate )
    {
        rememberChangedField("REContractNoticeActivationDate", this.rEContractNoticeActivationDate);
        this.rEContractNoticeActivationDate = rEContractNoticeActivationDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>RECashFlowArchivedToDate</b>
     * </p>
     * 
     * @param rECashFlowArchivedToDate
     *            Date Up to Which the Cash Flow Is Archived
     */
    public void setRECashFlowArchivedToDate( @Nullable final LocalDate rECashFlowArchivedToDate )
    {
        rememberChangedField("RECashFlowArchivedToDate", this.rECashFlowArchivedToDate);
        this.rECashFlowArchivedToDate = rECashFlowArchivedToDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>RECashFlowLockedToDate</b>
     * </p>
     * 
     * @param rECashFlowLockedToDate
     *            Date Until Which the Cash Flow Is Locked
     */
    public void setRECashFlowLockedToDate( @Nullable final LocalDate rECashFlowLockedToDate )
    {
        rememberChangedField("RECashFlowLockedToDate", this.rECashFlowLockedToDate);
        this.rECashFlowLockedToDate = rECashFlowLockedToDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>RECashFlowPostingFromDate</b>
     * </p>
     * 
     * @param rECashFlowPostingFromDate
     *            First Posting From
     */
    public void setRECashFlowPostingFromDate( @Nullable final LocalDate rECashFlowPostingFromDate )
    {
        rememberChangedField("RECashFlowPostingFromDate", this.rECashFlowPostingFromDate);
        this.rECashFlowPostingFromDate = rECashFlowPostingFromDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>REBusinessEntity</b>
     * </p>
     * 
     * @param rEBusinessEntity
     *            RE Business Entity
     */
    public void setREBusinessEntity( @Nullable final java.lang.String rEBusinessEntity )
    {
        rememberChangedField("REBusinessEntity", this.rEBusinessEntity);
        this.rEBusinessEntity = rEBusinessEntity;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REPossessionStartDate</b>
     * </p>
     * 
     * @param rEPossessionStartDate
     *            Date From Which the Object Is Made Available for Use
     */
    public void setREPossessionStartDate( @Nullable final LocalDate rEPossessionStartDate )
    {
        rememberChangedField("REPossessionStartDate", this.rEPossessionStartDate);
        this.rEPossessionStartDate = rEPossessionStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REPossessionEndDate</b>
     * </p>
     * 
     * @param rEPossessionEndDate
     *            Date Up to Which the Object Is Used
     */
    public void setREPossessionEndDate( @Nullable final LocalDate rEPossessionEndDate )
    {
        rememberChangedField("REPossessionEndDate", this.rEPossessionEndDate);
        this.rEPossessionEndDate = rEPossessionEndDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>REHasMultipleAssignments</b>
     * </p>
     * 
     * @param rEHasMultipleAssignments
     *            Multiple Assignment of Object to Group Allowed
     */
    public void setREHasMultipleAssignments( @Nullable final java.lang.Boolean rEHasMultipleAssignments )
    {
        rememberChangedField("REHasMultipleAssignments", this.rEHasMultipleAssignments);
        this.rEHasMultipleAssignments = rEHasMultipleAssignments;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REObjectAvailableFromDate</b>
     * </p>
     * 
     * @param rEObjectAvailableFromDate
     *            Transfer of Possession: Start Date
     */
    public void setREObjectAvailableFromDate( @Nullable final LocalDate rEObjectAvailableFromDate )
    {
        rememberChangedField("REObjectAvailableFromDate", this.rEObjectAvailableFromDate);
        this.rEObjectAvailableFromDate = rEObjectAvailableFromDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>REObjectAvailableToDate</b>
     * </p>
     * 
     * @param rEObjectAvailableToDate
     *            Field of type DATS
     */
    public void setREObjectAvailableToDate( @Nullable final LocalDate rEObjectAvailableToDate )
    {
        rememberChangedField("REObjectAvailableToDate", this.rEObjectAvailableToDate);
        this.rEObjectAvailableToDate = rEObjectAvailableToDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ValuationRelevance</b>
     * </p>
     * 
     * @param valuationRelevance
     *            Valuation Relevance
     */
    public void setValuationRelevance( @Nullable final java.lang.String valuationRelevance )
    {
        rememberChangedField("ValuationRelevance", this.valuationRelevance);
        this.valuationRelevance = valuationRelevance;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_REContract";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InternalRealEstateNumber", getInternalRealEstateNumber());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InternalRealEstateNumber", getInternalRealEstateNumber());
        values.put("CompanyCode", getCompanyCode());
        values.put("RealEstateContract", getRealEstateContract());
        values.put("REStatusObject", getREStatusObject());
        values.put("REInternalFinNumber", getREInternalFinNumber());
        values.put("RECreationType", getRECreationType());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("RESourceOfCreation", getRESourceOfCreation());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeTime", getLastChangeTime());
        values.put("RESourceOfChange", getRESourceOfChange());
        values.put("Responsible", getResponsible());
        values.put("REUserExclusive", getREUserExclusive());
        values.put("REAuthorizationGroup", getREAuthorizationGroup());
        values.put("REContractType", getREContractType());
        values.put("ContractStartDate", getContractStartDate());
        values.put("ContractEndDate", getContractEndDate());
        values.put("REContractName", getREContractName());
        values.put("REContractActivateDate", getREContractActivateDate());
        values.put("RETenancyLaw", getRETenancyLaw());
        values.put("REContractNumberOld", getREContractNumberOld());
        values.put("REMainContractCompanyCode", getREMainContractCompanyCode());
        values.put("REMainContract", getREMainContract());
        values.put("REContractCurrency", getREContractCurrency());
        values.put("REIndustrySector", getREIndustrySector());
        values.put("REIsSalesRelevant", getREIsSalesRelevant());
        values.put("REContractDepositType", getREContractDepositType());
        values.put("REContractSignDate", getREContractSignDate());
        values.put("REContract2SignDate", getREContract2SignDate());
        values.put("REContractCashFlowDate", getREContractCashFlowDate());
        values.put("REContractFirstEndDate", getREContractFirstEndDate());
        values.put("REContractNoticeDate", getREContractNoticeDate());
        values.put("REContractNoticeInDate", getREContractNoticeInDate());
        values.put("REContractNoticeReason", getREContractNoticeReason());
        values.put("REContractNoticeActivationDate", getREContractNoticeActivationDate());
        values.put("RECashFlowArchivedToDate", getRECashFlowArchivedToDate());
        values.put("RECashFlowLockedToDate", getRECashFlowLockedToDate());
        values.put("RECashFlowPostingFromDate", getRECashFlowPostingFromDate());
        values.put("REBusinessEntity", getREBusinessEntity());
        values.put("REPossessionStartDate", getREPossessionStartDate());
        values.put("REPossessionEndDate", getREPossessionEndDate());
        values.put("REHasMultipleAssignments", getREHasMultipleAssignments());
        values.put("REObjectAvailableFromDate", getREObjectAvailableFromDate());
        values.put("REObjectAvailableToDate", getREObjectAvailableToDate());
        values.put("ValuationRelevance", getValuationRelevance());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalRealEstateNumber") ) {
                final Object value = values.remove("InternalRealEstateNumber");
                if( (value == null) || (!value.equals(getInternalRealEstateNumber())) ) {
                    setInternalRealEstateNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("RealEstateContract") ) {
                final Object value = values.remove("RealEstateContract");
                if( (value == null) || (!value.equals(getRealEstateContract())) ) {
                    setRealEstateContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("REStatusObject") ) {
                final Object value = values.remove("REStatusObject");
                if( (value == null) || (!value.equals(getREStatusObject())) ) {
                    setREStatusObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("REInternalFinNumber") ) {
                final Object value = values.remove("REInternalFinNumber");
                if( (value == null) || (!value.equals(getREInternalFinNumber())) ) {
                    setREInternalFinNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("RECreationType") ) {
                final Object value = values.remove("RECreationType");
                if( (value == null) || (!value.equals(getRECreationType())) ) {
                    setRECreationType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("RESourceOfCreation") ) {
                final Object value = values.remove("RESourceOfCreation");
                if( (value == null) || (!value.equals(getRESourceOfCreation())) ) {
                    setRESourceOfCreation(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDate) value));
                }
            }
            if( values.containsKey("LastChangeTime") ) {
                final Object value = values.remove("LastChangeTime");
                if( (value == null) || (!value.equals(getLastChangeTime())) ) {
                    setLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("RESourceOfChange") ) {
                final Object value = values.remove("RESourceOfChange");
                if( (value == null) || (!value.equals(getRESourceOfChange())) ) {
                    setRESourceOfChange(((java.lang.String) value));
                }
            }
            if( values.containsKey("Responsible") ) {
                final Object value = values.remove("Responsible");
                if( (value == null) || (!value.equals(getResponsible())) ) {
                    setResponsible(((java.lang.String) value));
                }
            }
            if( values.containsKey("REUserExclusive") ) {
                final Object value = values.remove("REUserExclusive");
                if( (value == null) || (!value.equals(getREUserExclusive())) ) {
                    setREUserExclusive(((java.lang.String) value));
                }
            }
            if( values.containsKey("REAuthorizationGroup") ) {
                final Object value = values.remove("REAuthorizationGroup");
                if( (value == null) || (!value.equals(getREAuthorizationGroup())) ) {
                    setREAuthorizationGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("REContractType") ) {
                final Object value = values.remove("REContractType");
                if( (value == null) || (!value.equals(getREContractType())) ) {
                    setREContractType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContractStartDate") ) {
                final Object value = values.remove("ContractStartDate");
                if( (value == null) || (!value.equals(getContractStartDate())) ) {
                    setContractStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ContractEndDate") ) {
                final Object value = values.remove("ContractEndDate");
                if( (value == null) || (!value.equals(getContractEndDate())) ) {
                    setContractEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REContractName") ) {
                final Object value = values.remove("REContractName");
                if( (value == null) || (!value.equals(getREContractName())) ) {
                    setREContractName(((java.lang.String) value));
                }
            }
            if( values.containsKey("REContractActivateDate") ) {
                final Object value = values.remove("REContractActivateDate");
                if( (value == null) || (!value.equals(getREContractActivateDate())) ) {
                    setREContractActivateDate(((LocalDate) value));
                }
            }
            if( values.containsKey("RETenancyLaw") ) {
                final Object value = values.remove("RETenancyLaw");
                if( (value == null) || (!value.equals(getRETenancyLaw())) ) {
                    setRETenancyLaw(((java.lang.String) value));
                }
            }
            if( values.containsKey("REContractNumberOld") ) {
                final Object value = values.remove("REContractNumberOld");
                if( (value == null) || (!value.equals(getREContractNumberOld())) ) {
                    setREContractNumberOld(((java.lang.String) value));
                }
            }
            if( values.containsKey("REMainContractCompanyCode") ) {
                final Object value = values.remove("REMainContractCompanyCode");
                if( (value == null) || (!value.equals(getREMainContractCompanyCode())) ) {
                    setREMainContractCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("REMainContract") ) {
                final Object value = values.remove("REMainContract");
                if( (value == null) || (!value.equals(getREMainContract())) ) {
                    setREMainContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("REContractCurrency") ) {
                final Object value = values.remove("REContractCurrency");
                if( (value == null) || (!value.equals(getREContractCurrency())) ) {
                    setREContractCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("REIndustrySector") ) {
                final Object value = values.remove("REIndustrySector");
                if( (value == null) || (!value.equals(getREIndustrySector())) ) {
                    setREIndustrySector(((java.lang.String) value));
                }
            }
            if( values.containsKey("REIsSalesRelevant") ) {
                final Object value = values.remove("REIsSalesRelevant");
                if( (value == null) || (!value.equals(getREIsSalesRelevant())) ) {
                    setREIsSalesRelevant(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REContractDepositType") ) {
                final Object value = values.remove("REContractDepositType");
                if( (value == null) || (!value.equals(getREContractDepositType())) ) {
                    setREContractDepositType(((java.lang.String) value));
                }
            }
            if( values.containsKey("REContractSignDate") ) {
                final Object value = values.remove("REContractSignDate");
                if( (value == null) || (!value.equals(getREContractSignDate())) ) {
                    setREContractSignDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REContract2SignDate") ) {
                final Object value = values.remove("REContract2SignDate");
                if( (value == null) || (!value.equals(getREContract2SignDate())) ) {
                    setREContract2SignDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REContractCashFlowDate") ) {
                final Object value = values.remove("REContractCashFlowDate");
                if( (value == null) || (!value.equals(getREContractCashFlowDate())) ) {
                    setREContractCashFlowDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REContractFirstEndDate") ) {
                final Object value = values.remove("REContractFirstEndDate");
                if( (value == null) || (!value.equals(getREContractFirstEndDate())) ) {
                    setREContractFirstEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REContractNoticeDate") ) {
                final Object value = values.remove("REContractNoticeDate");
                if( (value == null) || (!value.equals(getREContractNoticeDate())) ) {
                    setREContractNoticeDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REContractNoticeInDate") ) {
                final Object value = values.remove("REContractNoticeInDate");
                if( (value == null) || (!value.equals(getREContractNoticeInDate())) ) {
                    setREContractNoticeInDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REContractNoticeReason") ) {
                final Object value = values.remove("REContractNoticeReason");
                if( (value == null) || (!value.equals(getREContractNoticeReason())) ) {
                    setREContractNoticeReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("REContractNoticeActivationDate") ) {
                final Object value = values.remove("REContractNoticeActivationDate");
                if( (value == null) || (!value.equals(getREContractNoticeActivationDate())) ) {
                    setREContractNoticeActivationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("RECashFlowArchivedToDate") ) {
                final Object value = values.remove("RECashFlowArchivedToDate");
                if( (value == null) || (!value.equals(getRECashFlowArchivedToDate())) ) {
                    setRECashFlowArchivedToDate(((LocalDate) value));
                }
            }
            if( values.containsKey("RECashFlowLockedToDate") ) {
                final Object value = values.remove("RECashFlowLockedToDate");
                if( (value == null) || (!value.equals(getRECashFlowLockedToDate())) ) {
                    setRECashFlowLockedToDate(((LocalDate) value));
                }
            }
            if( values.containsKey("RECashFlowPostingFromDate") ) {
                final Object value = values.remove("RECashFlowPostingFromDate");
                if( (value == null) || (!value.equals(getRECashFlowPostingFromDate())) ) {
                    setRECashFlowPostingFromDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REBusinessEntity") ) {
                final Object value = values.remove("REBusinessEntity");
                if( (value == null) || (!value.equals(getREBusinessEntity())) ) {
                    setREBusinessEntity(((java.lang.String) value));
                }
            }
            if( values.containsKey("REPossessionStartDate") ) {
                final Object value = values.remove("REPossessionStartDate");
                if( (value == null) || (!value.equals(getREPossessionStartDate())) ) {
                    setREPossessionStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REPossessionEndDate") ) {
                final Object value = values.remove("REPossessionEndDate");
                if( (value == null) || (!value.equals(getREPossessionEndDate())) ) {
                    setREPossessionEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REHasMultipleAssignments") ) {
                final Object value = values.remove("REHasMultipleAssignments");
                if( (value == null) || (!value.equals(getREHasMultipleAssignments())) ) {
                    setREHasMultipleAssignments(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("REObjectAvailableFromDate") ) {
                final Object value = values.remove("REObjectAvailableFromDate");
                if( (value == null) || (!value.equals(getREObjectAvailableFromDate())) ) {
                    setREObjectAvailableFromDate(((LocalDate) value));
                }
            }
            if( values.containsKey("REObjectAvailableToDate") ) {
                final Object value = values.remove("REObjectAvailableToDate");
                if( (value == null) || (!value.equals(getREObjectAvailableToDate())) ) {
                    setREObjectAvailableToDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValuationRelevance") ) {
                final Object value = values.remove("ValuationRelevance");
                if( (value == null) || (!value.equals(getValuationRelevance())) ) {
                    setValuationRelevance(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_REAdjustmentTermTP") ) {
                final Object value = (values).remove("_REAdjustmentTermTP");
                if( value instanceof Iterable ) {
                    if( to_REAdjustmentTermTP == null ) {
                        to_REAdjustmentTermTP = Lists.newArrayList();
                    } else {
                        to_REAdjustmentTermTP = Lists.newArrayList(to_REAdjustmentTermTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrAdjustmentTerm entity;
                        if( to_REAdjustmentTermTP.size() > i ) {
                            entity = to_REAdjustmentTermTP.get(i);
                        } else {
                            entity = new REContrAdjustmentTerm();
                            to_REAdjustmentTermTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_REConditionTP") ) {
                final Object value = (values).remove("_REConditionTP");
                if( value instanceof Iterable ) {
                    if( to_REConditionTP == null ) {
                        to_REConditionTP = Lists.newArrayList();
                    } else {
                        to_REConditionTP = Lists.newArrayList(to_REConditionTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrCondition entity;
                        if( to_REConditionTP.size() > i ) {
                            entity = to_REConditionTP.get(i);
                        } else {
                            entity = new REContrCondition();
                            to_REConditionTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_RENoticeTermForObjTP") ) {
                final Object value = (values).remove("_RENoticeTermForObjTP");
                if( value instanceof Iterable ) {
                    if( to_RENoticeTermForObjTP == null ) {
                        to_RENoticeTermForObjTP = Lists.newArrayList();
                    } else {
                        to_RENoticeTermForObjTP = Lists.newArrayList(to_RENoticeTermForObjTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrNoticeTermForObj entity;
                        if( to_RENoticeTermForObjTP.size() > i ) {
                            entity = to_RENoticeTermForObjTP.get(i);
                        } else {
                            entity = new REContrNoticeTermForObj();
                            to_RENoticeTermForObjTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_RENoticeTermTP") ) {
                final Object value = (values).remove("_RENoticeTermTP");
                if( value instanceof Iterable ) {
                    if( to_RENoticeTermTP == null ) {
                        to_RENoticeTermTP = Lists.newArrayList();
                    } else {
                        to_RENoticeTermTP = Lists.newArrayList(to_RENoticeTermTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrNoticeTerm entity;
                        if( to_RENoticeTermTP.size() > i ) {
                            entity = to_RENoticeTermTP.get(i);
                        } else {
                            entity = new REContrNoticeTerm();
                            to_RENoticeTermTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_REObjAssgmtTP") ) {
                final Object value = (values).remove("_REObjAssgmtTP");
                if( value instanceof Iterable ) {
                    if( to_REObjAssgmtTP == null ) {
                        to_REObjAssgmtTP = Lists.newArrayList();
                    } else {
                        to_REObjAssgmtTP = Lists.newArrayList(to_REObjAssgmtTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrObjAssgmt entity;
                        if( to_REObjAssgmtTP.size() > i ) {
                            entity = to_REObjAssgmtTP.get(i);
                        } else {
                            entity = new REContrObjAssgmt();
                            to_REObjAssgmtTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_REOrglAssgmtTermTP") ) {
                final Object value = (values).remove("_REOrglAssgmtTermTP");
                if( value instanceof Iterable ) {
                    if( to_REOrglAssgmtTermTP == null ) {
                        to_REOrglAssgmtTermTP = Lists.newArrayList();
                    } else {
                        to_REOrglAssgmtTermTP = Lists.newArrayList(to_REOrglAssgmtTermTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrOrglAssgmtTerm entity;
                        if( to_REOrglAssgmtTermTP.size() > i ) {
                            entity = to_REOrglAssgmtTermTP.get(i);
                        } else {
                            entity = new REContrOrglAssgmtTerm();
                            to_REOrglAssgmtTermTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_REPartnerAssgmtTP") ) {
                final Object value = (values).remove("_REPartnerAssgmtTP");
                if( value instanceof Iterable ) {
                    if( to_REPartnerAssgmtTP == null ) {
                        to_REPartnerAssgmtTP = Lists.newArrayList();
                    } else {
                        to_REPartnerAssgmtTP = Lists.newArrayList(to_REPartnerAssgmtTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrPartAssgmt entity;
                        if( to_REPartnerAssgmtTP.size() > i ) {
                            entity = to_REPartnerAssgmtTP.get(i);
                        } else {
                            entity = new REContrPartAssgmt();
                            to_REPartnerAssgmtTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_REPostingTermTP") ) {
                final Object value = (values).remove("_REPostingTermTP");
                if( value instanceof Iterable ) {
                    if( to_REPostingTermTP == null ) {
                        to_REPostingTermTP = Lists.newArrayList();
                    } else {
                        to_REPostingTermTP = Lists.newArrayList(to_REPostingTermTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrPostingTerm entity;
                        if( to_REPostingTermTP.size() > i ) {
                            entity = to_REPostingTermTP.get(i);
                        } else {
                            entity = new REContrPostingTerm();
                            to_REPostingTermTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_REReminderDateTP") ) {
                final Object value = (values).remove("_REReminderDateTP");
                if( value instanceof Iterable ) {
                    if( to_REReminderDateTP == null ) {
                        to_REReminderDateTP = Lists.newArrayList();
                    } else {
                        to_REReminderDateTP = Lists.newArrayList(to_REReminderDateTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrReminderDate entity;
                        if( to_REReminderDateTP.size() > i ) {
                            entity = to_REReminderDateTP.get(i);
                        } else {
                            entity = new REContrReminderDate();
                            to_REReminderDateTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_REReminderRuleTP") ) {
                final Object value = (values).remove("_REReminderRuleTP");
                if( value instanceof Iterable ) {
                    if( to_REReminderRuleTP == null ) {
                        to_REReminderRuleTP = Lists.newArrayList();
                    } else {
                        to_REReminderRuleTP = Lists.newArrayList(to_REReminderRuleTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrReminderRule entity;
                        if( to_REReminderRuleTP.size() > i ) {
                            entity = to_REReminderRuleTP.get(i);
                        } else {
                            entity = new REContrReminderRule();
                            to_REReminderRuleTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_RERenewalTermTP") ) {
                final Object value = (values).remove("_RERenewalTermTP");
                if( value instanceof Iterable ) {
                    if( to_RERenewalTermTP == null ) {
                        to_RERenewalTermTP = Lists.newArrayList();
                    } else {
                        to_RERenewalTermTP = Lists.newArrayList(to_RERenewalTermTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrRenewalTerm entity;
                        if( to_RERenewalTermTP.size() > i ) {
                            entity = to_RERenewalTermTP.get(i);
                        } else {
                            entity = new REContrRenewalTerm();
                            to_RERenewalTermTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_RERhythmTermTP") ) {
                final Object value = (values).remove("_RERhythmTermTP");
                if( value instanceof Iterable ) {
                    if( to_RERhythmTermTP == null ) {
                        to_RERhythmTermTP = Lists.newArrayList();
                    } else {
                        to_RERhythmTermTP = Lists.newArrayList(to_RERhythmTermTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrRhythmTerm entity;
                        if( to_RERhythmTermTP.size() > i ) {
                            entity = to_RERhythmTermTP.get(i);
                        } else {
                            entity = new REContrRhythmTerm();
                            to_RERhythmTermTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_REValuationConditionTP") ) {
                final Object value = (values).remove("_REValuationConditionTP");
                if( value instanceof Iterable ) {
                    if( to_REValuationConditionTP == null ) {
                        to_REValuationConditionTP = Lists.newArrayList();
                    } else {
                        to_REValuationConditionTP = Lists.newArrayList(to_REValuationConditionTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrValuationCondition entity;
                        if( to_REValuationConditionTP.size() > i ) {
                            entity = to_REValuationConditionTP.get(i);
                        } else {
                            entity = new REContrValuationCondition();
                            to_REValuationConditionTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_REValuationTP") ) {
                final Object value = (values).remove("_REValuationTP");
                if( value instanceof Iterable ) {
                    if( to_REValuationTP == null ) {
                        to_REValuationTP = Lists.newArrayList();
                    } else {
                        to_REValuationTP = Lists.newArrayList(to_REValuationTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        REContrValuation entity;
                        if( to_REValuationTP.size() > i ) {
                            entity = to_REValuationTP.get(i);
                        } else {
                            entity = new REContrValuation();
                            to_REValuationTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return RealEstateContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_REAdjustmentTermTP != null ) {
            (values).put("_REAdjustmentTermTP", to_REAdjustmentTermTP);
        }
        if( to_REConditionTP != null ) {
            (values).put("_REConditionTP", to_REConditionTP);
        }
        if( to_RENoticeTermForObjTP != null ) {
            (values).put("_RENoticeTermForObjTP", to_RENoticeTermForObjTP);
        }
        if( to_RENoticeTermTP != null ) {
            (values).put("_RENoticeTermTP", to_RENoticeTermTP);
        }
        if( to_REObjAssgmtTP != null ) {
            (values).put("_REObjAssgmtTP", to_REObjAssgmtTP);
        }
        if( to_REOrglAssgmtTermTP != null ) {
            (values).put("_REOrglAssgmtTermTP", to_REOrglAssgmtTermTP);
        }
        if( to_REPartnerAssgmtTP != null ) {
            (values).put("_REPartnerAssgmtTP", to_REPartnerAssgmtTP);
        }
        if( to_REPostingTermTP != null ) {
            (values).put("_REPostingTermTP", to_REPostingTermTP);
        }
        if( to_REReminderDateTP != null ) {
            (values).put("_REReminderDateTP", to_REReminderDateTP);
        }
        if( to_REReminderRuleTP != null ) {
            (values).put("_REReminderRuleTP", to_REReminderRuleTP);
        }
        if( to_RERenewalTermTP != null ) {
            (values).put("_RERenewalTermTP", to_RERenewalTermTP);
        }
        if( to_RERhythmTermTP != null ) {
            (values).put("_RERhythmTermTP", to_RERhythmTermTP);
        }
        if( to_REValuationConditionTP != null ) {
            (values).put("_REValuationConditionTP", to_REValuationConditionTP);
        }
        if( to_REValuationTP != null ) {
            (values).put("_REValuationTP", to_REValuationTP);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>REContrAdjustmentTerm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_REAdjustmentTermTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REAdjustmentTermTP</b> is already loaded, the result will
     *         contain the <b>REContrAdjustmentTerm</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrAdjustmentTerm>> getREAdjustmentTermTPIfPresent()
    {
        return Option.of(to_REAdjustmentTermTP);
    }

    /**
     * Overwrites the list of associated <b>REContrAdjustmentTerm</b> entities for the loaded navigation property
     * <b>_REAdjustmentTermTP</b>.
     * <p>
     * If the navigation property <b>_REAdjustmentTermTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrAdjustmentTerm</b> entities.
     */
    public void setREAdjustmentTermTP( @Nonnull final List<REContrAdjustmentTerm> value )
    {
        if( to_REAdjustmentTermTP == null ) {
            to_REAdjustmentTermTP = Lists.newArrayList();
        }
        to_REAdjustmentTermTP.clear();
        to_REAdjustmentTermTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrAdjustmentTerm</b> entities. This corresponds to the OData
     * navigation property <b>_REAdjustmentTermTP</b>.
     * <p>
     * If the navigation property <b>_REAdjustmentTermTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrAdjustmentTerm</b> entities.
     */
    public void addREAdjustmentTermTP( REContrAdjustmentTerm... entity )
    {
        if( to_REAdjustmentTermTP == null ) {
            to_REAdjustmentTermTP = Lists.newArrayList();
        }
        to_REAdjustmentTermTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrCondition</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_REConditionTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REConditionTP</b> is already loaded, the result will
     *         contain the <b>REContrCondition</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrCondition>> getREConditionTPIfPresent()
    {
        return Option.of(to_REConditionTP);
    }

    /**
     * Overwrites the list of associated <b>REContrCondition</b> entities for the loaded navigation property
     * <b>_REConditionTP</b>.
     * <p>
     * If the navigation property <b>_REConditionTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrCondition</b> entities.
     */
    public void setREConditionTP( @Nonnull final List<REContrCondition> value )
    {
        if( to_REConditionTP == null ) {
            to_REConditionTP = Lists.newArrayList();
        }
        to_REConditionTP.clear();
        to_REConditionTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrCondition</b> entities. This corresponds to the OData
     * navigation property <b>_REConditionTP</b>.
     * <p>
     * If the navigation property <b>_REConditionTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrCondition</b> entities.
     */
    public void addREConditionTP( REContrCondition... entity )
    {
        if( to_REConditionTP == null ) {
            to_REConditionTP = Lists.newArrayList();
        }
        to_REConditionTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrNoticeTermForObj</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_RENoticeTermForObjTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_RENoticeTermForObjTP</b> is already loaded, the result
     *         will contain the <b>REContrNoticeTermForObj</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrNoticeTermForObj>> getRENoticeTermForObjTPIfPresent()
    {
        return Option.of(to_RENoticeTermForObjTP);
    }

    /**
     * Overwrites the list of associated <b>REContrNoticeTermForObj</b> entities for the loaded navigation property
     * <b>_RENoticeTermForObjTP</b>.
     * <p>
     * If the navigation property <b>_RENoticeTermForObjTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrNoticeTermForObj</b> entities.
     */
    public void setRENoticeTermForObjTP( @Nonnull final List<REContrNoticeTermForObj> value )
    {
        if( to_RENoticeTermForObjTP == null ) {
            to_RENoticeTermForObjTP = Lists.newArrayList();
        }
        to_RENoticeTermForObjTP.clear();
        to_RENoticeTermForObjTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrNoticeTermForObj</b> entities. This corresponds to the OData
     * navigation property <b>_RENoticeTermForObjTP</b>.
     * <p>
     * If the navigation property <b>_RENoticeTermForObjTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrNoticeTermForObj</b> entities.
     */
    public void addRENoticeTermForObjTP( REContrNoticeTermForObj... entity )
    {
        if( to_RENoticeTermForObjTP == null ) {
            to_RENoticeTermForObjTP = Lists.newArrayList();
        }
        to_RENoticeTermForObjTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrNoticeTerm</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_RENoticeTermTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_RENoticeTermTP</b> is already loaded, the result will
     *         contain the <b>REContrNoticeTerm</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrNoticeTerm>> getRENoticeTermTPIfPresent()
    {
        return Option.of(to_RENoticeTermTP);
    }

    /**
     * Overwrites the list of associated <b>REContrNoticeTerm</b> entities for the loaded navigation property
     * <b>_RENoticeTermTP</b>.
     * <p>
     * If the navigation property <b>_RENoticeTermTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrNoticeTerm</b> entities.
     */
    public void setRENoticeTermTP( @Nonnull final List<REContrNoticeTerm> value )
    {
        if( to_RENoticeTermTP == null ) {
            to_RENoticeTermTP = Lists.newArrayList();
        }
        to_RENoticeTermTP.clear();
        to_RENoticeTermTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrNoticeTerm</b> entities. This corresponds to the OData
     * navigation property <b>_RENoticeTermTP</b>.
     * <p>
     * If the navigation property <b>_RENoticeTermTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrNoticeTerm</b> entities.
     */
    public void addRENoticeTermTP( REContrNoticeTerm... entity )
    {
        if( to_RENoticeTermTP == null ) {
            to_RENoticeTermTP = Lists.newArrayList();
        }
        to_RENoticeTermTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrObjAssgmt</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_REObjAssgmtTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REObjAssgmtTP</b> is already loaded, the result will
     *         contain the <b>REContrObjAssgmt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrObjAssgmt>> getREObjAssgmtTPIfPresent()
    {
        return Option.of(to_REObjAssgmtTP);
    }

    /**
     * Overwrites the list of associated <b>REContrObjAssgmt</b> entities for the loaded navigation property
     * <b>_REObjAssgmtTP</b>.
     * <p>
     * If the navigation property <b>_REObjAssgmtTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrObjAssgmt</b> entities.
     */
    public void setREObjAssgmtTP( @Nonnull final List<REContrObjAssgmt> value )
    {
        if( to_REObjAssgmtTP == null ) {
            to_REObjAssgmtTP = Lists.newArrayList();
        }
        to_REObjAssgmtTP.clear();
        to_REObjAssgmtTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrObjAssgmt</b> entities. This corresponds to the OData
     * navigation property <b>_REObjAssgmtTP</b>.
     * <p>
     * If the navigation property <b>_REObjAssgmtTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrObjAssgmt</b> entities.
     */
    public void addREObjAssgmtTP( REContrObjAssgmt... entity )
    {
        if( to_REObjAssgmtTP == null ) {
            to_REObjAssgmtTP = Lists.newArrayList();
        }
        to_REObjAssgmtTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrOrglAssgmtTerm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_REOrglAssgmtTermTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REOrglAssgmtTermTP</b> is already loaded, the result will
     *         contain the <b>REContrOrglAssgmtTerm</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrOrglAssgmtTerm>> getREOrglAssgmtTermTPIfPresent()
    {
        return Option.of(to_REOrglAssgmtTermTP);
    }

    /**
     * Overwrites the list of associated <b>REContrOrglAssgmtTerm</b> entities for the loaded navigation property
     * <b>_REOrglAssgmtTermTP</b>.
     * <p>
     * If the navigation property <b>_REOrglAssgmtTermTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrOrglAssgmtTerm</b> entities.
     */
    public void setREOrglAssgmtTermTP( @Nonnull final List<REContrOrglAssgmtTerm> value )
    {
        if( to_REOrglAssgmtTermTP == null ) {
            to_REOrglAssgmtTermTP = Lists.newArrayList();
        }
        to_REOrglAssgmtTermTP.clear();
        to_REOrglAssgmtTermTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrOrglAssgmtTerm</b> entities. This corresponds to the OData
     * navigation property <b>_REOrglAssgmtTermTP</b>.
     * <p>
     * If the navigation property <b>_REOrglAssgmtTermTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrOrglAssgmtTerm</b> entities.
     */
    public void addREOrglAssgmtTermTP( REContrOrglAssgmtTerm... entity )
    {
        if( to_REOrglAssgmtTermTP == null ) {
            to_REOrglAssgmtTermTP = Lists.newArrayList();
        }
        to_REOrglAssgmtTermTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrPartAssgmt</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_REPartnerAssgmtTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REPartnerAssgmtTP</b> is already loaded, the result will
     *         contain the <b>REContrPartAssgmt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrPartAssgmt>> getREPartnerAssgmtTPIfPresent()
    {
        return Option.of(to_REPartnerAssgmtTP);
    }

    /**
     * Overwrites the list of associated <b>REContrPartAssgmt</b> entities for the loaded navigation property
     * <b>_REPartnerAssgmtTP</b>.
     * <p>
     * If the navigation property <b>_REPartnerAssgmtTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrPartAssgmt</b> entities.
     */
    public void setREPartnerAssgmtTP( @Nonnull final List<REContrPartAssgmt> value )
    {
        if( to_REPartnerAssgmtTP == null ) {
            to_REPartnerAssgmtTP = Lists.newArrayList();
        }
        to_REPartnerAssgmtTP.clear();
        to_REPartnerAssgmtTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrPartAssgmt</b> entities. This corresponds to the OData
     * navigation property <b>_REPartnerAssgmtTP</b>.
     * <p>
     * If the navigation property <b>_REPartnerAssgmtTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrPartAssgmt</b> entities.
     */
    public void addREPartnerAssgmtTP( REContrPartAssgmt... entity )
    {
        if( to_REPartnerAssgmtTP == null ) {
            to_REPartnerAssgmtTP = Lists.newArrayList();
        }
        to_REPartnerAssgmtTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrPostingTerm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_REPostingTermTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REPostingTermTP</b> is already loaded, the result will
     *         contain the <b>REContrPostingTerm</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrPostingTerm>> getREPostingTermTPIfPresent()
    {
        return Option.of(to_REPostingTermTP);
    }

    /**
     * Overwrites the list of associated <b>REContrPostingTerm</b> entities for the loaded navigation property
     * <b>_REPostingTermTP</b>.
     * <p>
     * If the navigation property <b>_REPostingTermTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrPostingTerm</b> entities.
     */
    public void setREPostingTermTP( @Nonnull final List<REContrPostingTerm> value )
    {
        if( to_REPostingTermTP == null ) {
            to_REPostingTermTP = Lists.newArrayList();
        }
        to_REPostingTermTP.clear();
        to_REPostingTermTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrPostingTerm</b> entities. This corresponds to the OData
     * navigation property <b>_REPostingTermTP</b>.
     * <p>
     * If the navigation property <b>_REPostingTermTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrPostingTerm</b> entities.
     */
    public void addREPostingTermTP( REContrPostingTerm... entity )
    {
        if( to_REPostingTermTP == null ) {
            to_REPostingTermTP = Lists.newArrayList();
        }
        to_REPostingTermTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrReminderDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_REReminderDateTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REReminderDateTP</b> is already loaded, the result will
     *         contain the <b>REContrReminderDate</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrReminderDate>> getREReminderDateTPIfPresent()
    {
        return Option.of(to_REReminderDateTP);
    }

    /**
     * Overwrites the list of associated <b>REContrReminderDate</b> entities for the loaded navigation property
     * <b>_REReminderDateTP</b>.
     * <p>
     * If the navigation property <b>_REReminderDateTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrReminderDate</b> entities.
     */
    public void setREReminderDateTP( @Nonnull final List<REContrReminderDate> value )
    {
        if( to_REReminderDateTP == null ) {
            to_REReminderDateTP = Lists.newArrayList();
        }
        to_REReminderDateTP.clear();
        to_REReminderDateTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrReminderDate</b> entities. This corresponds to the OData
     * navigation property <b>_REReminderDateTP</b>.
     * <p>
     * If the navigation property <b>_REReminderDateTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrReminderDate</b> entities.
     */
    public void addREReminderDateTP( REContrReminderDate... entity )
    {
        if( to_REReminderDateTP == null ) {
            to_REReminderDateTP = Lists.newArrayList();
        }
        to_REReminderDateTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrReminderRule</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_REReminderRuleTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REReminderRuleTP</b> is already loaded, the result will
     *         contain the <b>REContrReminderRule</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrReminderRule>> getREReminderRuleTPIfPresent()
    {
        return Option.of(to_REReminderRuleTP);
    }

    /**
     * Overwrites the list of associated <b>REContrReminderRule</b> entities for the loaded navigation property
     * <b>_REReminderRuleTP</b>.
     * <p>
     * If the navigation property <b>_REReminderRuleTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrReminderRule</b> entities.
     */
    public void setREReminderRuleTP( @Nonnull final List<REContrReminderRule> value )
    {
        if( to_REReminderRuleTP == null ) {
            to_REReminderRuleTP = Lists.newArrayList();
        }
        to_REReminderRuleTP.clear();
        to_REReminderRuleTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrReminderRule</b> entities. This corresponds to the OData
     * navigation property <b>_REReminderRuleTP</b>.
     * <p>
     * If the navigation property <b>_REReminderRuleTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrReminderRule</b> entities.
     */
    public void addREReminderRuleTP( REContrReminderRule... entity )
    {
        if( to_REReminderRuleTP == null ) {
            to_REReminderRuleTP = Lists.newArrayList();
        }
        to_REReminderRuleTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrRenewalTerm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_RERenewalTermTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_RERenewalTermTP</b> is already loaded, the result will
     *         contain the <b>REContrRenewalTerm</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrRenewalTerm>> getRERenewalTermTPIfPresent()
    {
        return Option.of(to_RERenewalTermTP);
    }

    /**
     * Overwrites the list of associated <b>REContrRenewalTerm</b> entities for the loaded navigation property
     * <b>_RERenewalTermTP</b>.
     * <p>
     * If the navigation property <b>_RERenewalTermTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrRenewalTerm</b> entities.
     */
    public void setRERenewalTermTP( @Nonnull final List<REContrRenewalTerm> value )
    {
        if( to_RERenewalTermTP == null ) {
            to_RERenewalTermTP = Lists.newArrayList();
        }
        to_RERenewalTermTP.clear();
        to_RERenewalTermTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrRenewalTerm</b> entities. This corresponds to the OData
     * navigation property <b>_RERenewalTermTP</b>.
     * <p>
     * If the navigation property <b>_RERenewalTermTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrRenewalTerm</b> entities.
     */
    public void addRERenewalTermTP( REContrRenewalTerm... entity )
    {
        if( to_RERenewalTermTP == null ) {
            to_RERenewalTermTP = Lists.newArrayList();
        }
        to_RERenewalTermTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrRhythmTerm</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_RERhythmTermTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_RERhythmTermTP</b> is already loaded, the result will
     *         contain the <b>REContrRhythmTerm</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrRhythmTerm>> getRERhythmTermTPIfPresent()
    {
        return Option.of(to_RERhythmTermTP);
    }

    /**
     * Overwrites the list of associated <b>REContrRhythmTerm</b> entities for the loaded navigation property
     * <b>_RERhythmTermTP</b>.
     * <p>
     * If the navigation property <b>_RERhythmTermTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrRhythmTerm</b> entities.
     */
    public void setRERhythmTermTP( @Nonnull final List<REContrRhythmTerm> value )
    {
        if( to_RERhythmTermTP == null ) {
            to_RERhythmTermTP = Lists.newArrayList();
        }
        to_RERhythmTermTP.clear();
        to_RERhythmTermTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrRhythmTerm</b> entities. This corresponds to the OData
     * navigation property <b>_RERhythmTermTP</b>.
     * <p>
     * If the navigation property <b>_RERhythmTermTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrRhythmTerm</b> entities.
     */
    public void addRERhythmTermTP( REContrRhythmTerm... entity )
    {
        if( to_RERhythmTermTP == null ) {
            to_RERhythmTermTP = Lists.newArrayList();
        }
        to_RERhythmTermTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrValuationCondition</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_REValuationConditionTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REValuationConditionTP</b> is already loaded, the result
     *         will contain the <b>REContrValuationCondition</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrValuationCondition>> getREValuationConditionTPIfPresent()
    {
        return Option.of(to_REValuationConditionTP);
    }

    /**
     * Overwrites the list of associated <b>REContrValuationCondition</b> entities for the loaded navigation property
     * <b>_REValuationConditionTP</b>.
     * <p>
     * If the navigation property <b>_REValuationConditionTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrValuationCondition</b> entities.
     */
    public void setREValuationConditionTP( @Nonnull final List<REContrValuationCondition> value )
    {
        if( to_REValuationConditionTP == null ) {
            to_REValuationConditionTP = Lists.newArrayList();
        }
        to_REValuationConditionTP.clear();
        to_REValuationConditionTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrValuationCondition</b> entities. This corresponds to the OData
     * navigation property <b>_REValuationConditionTP</b>.
     * <p>
     * If the navigation property <b>_REValuationConditionTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrValuationCondition</b> entities.
     */
    public void addREValuationConditionTP( REContrValuationCondition... entity )
    {
        if( to_REValuationConditionTP == null ) {
            to_REValuationConditionTP = Lists.newArrayList();
        }
        to_REValuationConditionTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>REContrValuation</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_REValuationTP</b>.
     * <p>
     * If the navigation property for an entity <b>REContract</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_REValuationTP</b> is already loaded, the result will
     *         contain the <b>REContrValuation</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<REContrValuation>> getREValuationTPIfPresent()
    {
        return Option.of(to_REValuationTP);
    }

    /**
     * Overwrites the list of associated <b>REContrValuation</b> entities for the loaded navigation property
     * <b>_REValuationTP</b>.
     * <p>
     * If the navigation property <b>_REValuationTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>REContrValuation</b> entities.
     */
    public void setREValuationTP( @Nonnull final List<REContrValuation> value )
    {
        if( to_REValuationTP == null ) {
            to_REValuationTP = Lists.newArrayList();
        }
        to_REValuationTP.clear();
        to_REValuationTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>REContrValuation</b> entities. This corresponds to the OData
     * navigation property <b>_REValuationTP</b>.
     * <p>
     * If the navigation property <b>_REValuationTP</b> of a queried <b>REContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>REContrValuation</b> entities.
     */
    public void addREValuationTP( REContrValuation... entity )
    {
        if( to_REValuationTP == null ) {
            to_REValuationTP = Lists.newArrayList();
        }
        to_REValuationTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of REContract instances.
     * 
     */
    public final static class REContractBuilder
    {

        private List<REContrAdjustmentTerm> to_REAdjustmentTermTP = Lists.newArrayList();
        private List<REContrCondition> to_REConditionTP = Lists.newArrayList();
        private List<REContrNoticeTermForObj> to_RENoticeTermForObjTP = Lists.newArrayList();
        private List<REContrNoticeTerm> to_RENoticeTermTP = Lists.newArrayList();
        private List<REContrObjAssgmt> to_REObjAssgmtTP = Lists.newArrayList();
        private List<REContrOrglAssgmtTerm> to_REOrglAssgmtTermTP = Lists.newArrayList();
        private List<REContrPartAssgmt> to_REPartnerAssgmtTP = Lists.newArrayList();
        private List<REContrPostingTerm> to_REPostingTermTP = Lists.newArrayList();
        private List<REContrReminderDate> to_REReminderDateTP = Lists.newArrayList();
        private List<REContrReminderRule> to_REReminderRuleTP = Lists.newArrayList();
        private List<REContrRenewalTerm> to_RERenewalTermTP = Lists.newArrayList();
        private List<REContrRhythmTerm> to_RERhythmTermTP = Lists.newArrayList();
        private List<REContrValuationCondition> to_REValuationConditionTP = Lists.newArrayList();
        private List<REContrValuation> to_REValuationTP = Lists.newArrayList();

        private REContract.REContractBuilder to_REAdjustmentTermTP( final List<REContrAdjustmentTerm> value )
        {
            to_REAdjustmentTermTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_REAdjustmentTermTP</b> for <b>REContract</b> to multiple
         * <b>REContrAdjustmentTerm</b>.
         * 
         * @param value
         *            The REContrAdjustmentTerms to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder reAdjustmentTermTP( REContrAdjustmentTerm... value )
        {
            return to_REAdjustmentTermTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_REConditionTP( final List<REContrCondition> value )
        {
            to_REConditionTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_REConditionTP</b> for <b>REContract</b> to multiple <b>REContrCondition</b>.
         * 
         * @param value
         *            The REContrConditions to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder reConditionTP( REContrCondition... value )
        {
            return to_REConditionTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_RENoticeTermForObjTP( final List<REContrNoticeTermForObj> value )
        {
            to_RENoticeTermForObjTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_RENoticeTermForObjTP</b> for <b>REContract</b> to multiple
         * <b>REContrNoticeTermForObj</b>.
         * 
         * @param value
         *            The REContrNoticeTermForObjs to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder reNoticeTermForObjTP( REContrNoticeTermForObj... value )
        {
            return to_RENoticeTermForObjTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_RENoticeTermTP( final List<REContrNoticeTerm> value )
        {
            to_RENoticeTermTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_RENoticeTermTP</b> for <b>REContract</b> to multiple <b>REContrNoticeTerm</b>.
         * 
         * @param value
         *            The REContrNoticeTerms to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder reNoticeTermTP( REContrNoticeTerm... value )
        {
            return to_RENoticeTermTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_REObjAssgmtTP( final List<REContrObjAssgmt> value )
        {
            to_REObjAssgmtTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_REObjAssgmtTP</b> for <b>REContract</b> to multiple <b>REContrObjAssgmt</b>.
         * 
         * @param value
         *            The REContrObjAssgmts to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder reObjAssgmtTP( REContrObjAssgmt... value )
        {
            return to_REObjAssgmtTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_REOrglAssgmtTermTP( final List<REContrOrglAssgmtTerm> value )
        {
            to_REOrglAssgmtTermTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_REOrglAssgmtTermTP</b> for <b>REContract</b> to multiple
         * <b>REContrOrglAssgmtTerm</b>.
         * 
         * @param value
         *            The REContrOrglAssgmtTerms to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder reOrglAssgmtTermTP( REContrOrglAssgmtTerm... value )
        {
            return to_REOrglAssgmtTermTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_REPartnerAssgmtTP( final List<REContrPartAssgmt> value )
        {
            to_REPartnerAssgmtTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_REPartnerAssgmtTP</b> for <b>REContract</b> to multiple <b>REContrPartAssgmt</b>.
         * 
         * @param value
         *            The REContrPartAssgmts to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder rePartnerAssgmtTP( REContrPartAssgmt... value )
        {
            return to_REPartnerAssgmtTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_REPostingTermTP( final List<REContrPostingTerm> value )
        {
            to_REPostingTermTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_REPostingTermTP</b> for <b>REContract</b> to multiple <b>REContrPostingTerm</b>.
         * 
         * @param value
         *            The REContrPostingTerms to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder rePostingTermTP( REContrPostingTerm... value )
        {
            return to_REPostingTermTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_REReminderDateTP( final List<REContrReminderDate> value )
        {
            to_REReminderDateTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_REReminderDateTP</b> for <b>REContract</b> to multiple <b>REContrReminderDate</b>.
         * 
         * @param value
         *            The REContrReminderDates to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder reReminderDateTP( REContrReminderDate... value )
        {
            return to_REReminderDateTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_REReminderRuleTP( final List<REContrReminderRule> value )
        {
            to_REReminderRuleTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_REReminderRuleTP</b> for <b>REContract</b> to multiple <b>REContrReminderRule</b>.
         * 
         * @param value
         *            The REContrReminderRules to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder reReminderRuleTP( REContrReminderRule... value )
        {
            return to_REReminderRuleTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_RERenewalTermTP( final List<REContrRenewalTerm> value )
        {
            to_RERenewalTermTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_RERenewalTermTP</b> for <b>REContract</b> to multiple <b>REContrRenewalTerm</b>.
         * 
         * @param value
         *            The REContrRenewalTerms to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder reRenewalTermTP( REContrRenewalTerm... value )
        {
            return to_RERenewalTermTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_RERhythmTermTP( final List<REContrRhythmTerm> value )
        {
            to_RERhythmTermTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_RERhythmTermTP</b> for <b>REContract</b> to multiple <b>REContrRhythmTerm</b>.
         * 
         * @param value
         *            The REContrRhythmTerms to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder reRhythmTermTP( REContrRhythmTerm... value )
        {
            return to_RERhythmTermTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_REValuationConditionTP( final List<REContrValuationCondition> value )
        {
            to_REValuationConditionTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_REValuationConditionTP</b> for <b>REContract</b> to multiple
         * <b>REContrValuationCondition</b>.
         * 
         * @param value
         *            The REContrValuationConditions to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder reValuationConditionTP( REContrValuationCondition... value )
        {
            return to_REValuationConditionTP(Lists.newArrayList(value));
        }

        private REContract.REContractBuilder to_REValuationTP( final List<REContrValuation> value )
        {
            to_REValuationTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_REValuationTP</b> for <b>REContract</b> to multiple <b>REContrValuation</b>.
         * 
         * @param value
         *            The REContrValuations to build this REContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public REContract.REContractBuilder reValuationTP( REContrValuation... value )
        {
            return to_REValuationTP(Lists.newArrayList(value));
        }

    }

}
