/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Team Attributes
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamAttributesType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamAttributes extends VdmEntity<TeamAttributes> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_respym_team_srv.v0001.TeamAttributesType";
    /**
     * Selector for all available fields of TeamAttributes.
     * 
     */
    public final static SimpleProperty<TeamAttributes> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     * 
     * @return Global Team ID in Responsibility Mgmt.
     */
    @Nullable
    @ElementName( "RespyMgmtGlobalTeamID" )
    private java.lang.String respyMgmtGlobalTeamID;
    public final static SimpleProperty.String<TeamAttributes> RESPY_MGMT_GLOBAL_TEAM_ID =
        new SimpleProperty.String<TeamAttributes>(TeamAttributes.class, "RespyMgmtGlobalTeamID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeName</b>
     * </p>
     * 
     * @return Responsibility Definition Name
     */
    @Nullable
    @ElementName( "RespyMgmtAttributeName" )
    private java.lang.String respyMgmtAttributeName;
    public final static SimpleProperty.String<TeamAttributes> RESPY_MGMT_ATTRIBUTE_NAME =
        new SimpleProperty.String<TeamAttributes>(TeamAttributes.class, "RespyMgmtAttributeName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeSign</b>
     * </p>
     * 
     * @return Type of SIGN component in row type of a Ranges type
     */
    @Nullable
    @ElementName( "RespyMgmtAttributeSign" )
    private java.lang.String respyMgmtAttributeSign;
    public final static SimpleProperty.String<TeamAttributes> RESPY_MGMT_ATTRIBUTE_SIGN =
        new SimpleProperty.String<TeamAttributes>(TeamAttributes.class, "RespyMgmtAttributeSign");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeOption</b>
     * </p>
     * 
     * @return Type of OPTION component in row type of a Ranges type
     */
    @Nullable
    @ElementName( "RespyMgmtAttributeOption" )
    private java.lang.String respyMgmtAttributeOption;
    public final static SimpleProperty.String<TeamAttributes> RESPY_MGMT_ATTRIBUTE_OPTION =
        new SimpleProperty.String<TeamAttributes>(TeamAttributes.class, "RespyMgmtAttributeOption");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeLowValue</b>
     * </p>
     * 
     * @return Start Value of Selection Criteria
     */
    @Nullable
    @ElementName( "RespyMgmtAttributeLowValue" )
    private java.lang.String respyMgmtAttributeLowValue;
    public final static SimpleProperty.String<TeamAttributes> RESPY_MGMT_ATTRIBUTE_LOW_VALUE =
        new SimpleProperty.String<TeamAttributes>(TeamAttributes.class, "RespyMgmtAttributeLowValue");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeHighValue</b>
     * </p>
     * 
     * @return End Value of Selection Criteria
     */
    @Nullable
    @ElementName( "RespyMgmtAttributeHighValue" )
    private java.lang.String respyMgmtAttributeHighValue;
    public final static SimpleProperty.String<TeamAttributes> RESPY_MGMT_ATTRIBUTE_HIGH_VALUE =
        new SimpleProperty.String<TeamAttributes>(TeamAttributes.class, "RespyMgmtAttributeHighValue");
    /**
     * Navigation property <b>_TeamHeader</b> for <b>TeamAttributes</b> to single <b>TeamHeaders</b>.
     * 
     */
    @ElementName( "_TeamHeader" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private TeamHeaders to_TeamHeader;
    /**
     * Use with available request builders to apply the <b>_TeamHeader</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamAttributes, TeamHeaders> TO__TEAM_HEADER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamAttributes, TeamHeaders>(
            TeamAttributes.class,
            "_TeamHeader",
            TeamHeaders.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamAttributes> getType()
    {
        return TeamAttributes.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     * 
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     */
    public void setRespyMgmtGlobalTeamID( @Nullable final java.lang.String respyMgmtGlobalTeamID )
    {
        rememberChangedField("RespyMgmtGlobalTeamID", this.respyMgmtGlobalTeamID);
        this.respyMgmtGlobalTeamID = respyMgmtGlobalTeamID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeName</b>
     * </p>
     * 
     * @param respyMgmtAttributeName
     *            Responsibility Definition Name
     */
    public void setRespyMgmtAttributeName( @Nullable final java.lang.String respyMgmtAttributeName )
    {
        rememberChangedField("RespyMgmtAttributeName", this.respyMgmtAttributeName);
        this.respyMgmtAttributeName = respyMgmtAttributeName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeSign</b>
     * </p>
     * 
     * @param respyMgmtAttributeSign
     *            Type of SIGN component in row type of a Ranges type
     */
    public void setRespyMgmtAttributeSign( @Nullable final java.lang.String respyMgmtAttributeSign )
    {
        rememberChangedField("RespyMgmtAttributeSign", this.respyMgmtAttributeSign);
        this.respyMgmtAttributeSign = respyMgmtAttributeSign;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeOption</b>
     * </p>
     * 
     * @param respyMgmtAttributeOption
     *            Type of OPTION component in row type of a Ranges type
     */
    public void setRespyMgmtAttributeOption( @Nullable final java.lang.String respyMgmtAttributeOption )
    {
        rememberChangedField("RespyMgmtAttributeOption", this.respyMgmtAttributeOption);
        this.respyMgmtAttributeOption = respyMgmtAttributeOption;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeLowValue</b>
     * </p>
     * 
     * @param respyMgmtAttributeLowValue
     *            Start Value of Selection Criteria
     */
    public void setRespyMgmtAttributeLowValue( @Nullable final java.lang.String respyMgmtAttributeLowValue )
    {
        rememberChangedField("RespyMgmtAttributeLowValue", this.respyMgmtAttributeLowValue);
        this.respyMgmtAttributeLowValue = respyMgmtAttributeLowValue;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeHighValue</b>
     * </p>
     * 
     * @param respyMgmtAttributeHighValue
     *            End Value of Selection Criteria
     */
    public void setRespyMgmtAttributeHighValue( @Nullable final java.lang.String respyMgmtAttributeHighValue )
    {
        rememberChangedField("RespyMgmtAttributeHighValue", this.respyMgmtAttributeHighValue);
        this.respyMgmtAttributeHighValue = respyMgmtAttributeHighValue;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamAttributes";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        entityKey.addKeyProperty("RespyMgmtAttributeName", getRespyMgmtAttributeName());
        entityKey.addKeyProperty("RespyMgmtAttributeSign", getRespyMgmtAttributeSign());
        entityKey.addKeyProperty("RespyMgmtAttributeOption", getRespyMgmtAttributeOption());
        entityKey.addKeyProperty("RespyMgmtAttributeLowValue", getRespyMgmtAttributeLowValue());
        entityKey.addKeyProperty("RespyMgmtAttributeHighValue", getRespyMgmtAttributeHighValue());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        values.put("RespyMgmtAttributeName", getRespyMgmtAttributeName());
        values.put("RespyMgmtAttributeSign", getRespyMgmtAttributeSign());
        values.put("RespyMgmtAttributeOption", getRespyMgmtAttributeOption());
        values.put("RespyMgmtAttributeLowValue", getRespyMgmtAttributeLowValue());
        values.put("RespyMgmtAttributeHighValue", getRespyMgmtAttributeHighValue());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtGlobalTeamID") ) {
                final Object value = values.remove("RespyMgmtGlobalTeamID");
                if( (value == null) || (!value.equals(getRespyMgmtGlobalTeamID())) ) {
                    setRespyMgmtGlobalTeamID(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtAttributeName") ) {
                final Object value = values.remove("RespyMgmtAttributeName");
                if( (value == null) || (!value.equals(getRespyMgmtAttributeName())) ) {
                    setRespyMgmtAttributeName(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtAttributeSign") ) {
                final Object value = values.remove("RespyMgmtAttributeSign");
                if( (value == null) || (!value.equals(getRespyMgmtAttributeSign())) ) {
                    setRespyMgmtAttributeSign(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtAttributeOption") ) {
                final Object value = values.remove("RespyMgmtAttributeOption");
                if( (value == null) || (!value.equals(getRespyMgmtAttributeOption())) ) {
                    setRespyMgmtAttributeOption(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtAttributeLowValue") ) {
                final Object value = values.remove("RespyMgmtAttributeLowValue");
                if( (value == null) || (!value.equals(getRespyMgmtAttributeLowValue())) ) {
                    setRespyMgmtAttributeLowValue(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtAttributeHighValue") ) {
                final Object value = values.remove("RespyMgmtAttributeHighValue");
                if( (value == null) || (!value.equals(getRespyMgmtAttributeHighValue())) ) {
                    setRespyMgmtAttributeHighValue(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_TeamHeader") ) {
                final Object value = (values).remove("_TeamHeader");
                if( value instanceof Map ) {
                    if( to_TeamHeader == null ) {
                        to_TeamHeader = new TeamHeaders();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_TeamHeader.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_TeamHeader != null ) {
            (values).put("_TeamHeader", to_TeamHeader);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>TeamHeaders</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_TeamHeader</b>.
     * <p>
     * If the navigation property for an entity <b>TeamAttributes</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamHeader</b> is already loaded, the result will contain
     *         the <b>TeamHeaders</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<TeamHeaders> getTeamHeaderIfPresent()
    {
        return Option.of(to_TeamHeader);
    }

    /**
     * Overwrites the associated <b>TeamHeaders</b> entity for the loaded navigation property <b>_TeamHeader</b>.
     * 
     * @param value
     *            New <b>TeamHeaders</b> entity.
     */
    public void setTeamHeader( final TeamHeaders value )
    {
        to_TeamHeader = value;
    }

    /**
     * Helper class to allow for fluent creation of TeamAttributes instances.
     * 
     */
    public final static class TeamAttributesBuilder
    {

        private TeamHeaders to_TeamHeader;

        private TeamAttributes.TeamAttributesBuilder to_TeamHeader( final TeamHeaders value )
        {
            to_TeamHeader = value;
            return this;
        }

        /**
         * Navigation property <b>_TeamHeader</b> for <b>TeamAttributes</b> to single <b>TeamHeaders</b>.
         * 
         * @param value
         *            The TeamHeaders to build this TeamAttributes with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamAttributes.TeamAttributesBuilder teamHeader( final TeamHeaders value )
        {
            return to_TeamHeader(value);
        }

    }

}
