/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Team Categories
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamCategoriesType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamCategories extends VdmEntity<TeamCategories> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_respym_team_srv.v0001.TeamCategoriesType";
    /**
     * Selector for all available fields of TeamCategories.
     * 
     */
    public final static SimpleProperty<TeamCategories> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @return Team Category
     */
    @Nullable
    @ElementName( "RespyMgmtTeamCategory" )
    private java.lang.String respyMgmtTeamCategory;
    public final static SimpleProperty.String<TeamCategories> RESPY_MGMT_TEAM_CATEGORY =
        new SimpleProperty.String<TeamCategories>(TeamCategories.class, "RespyMgmtTeamCategory");
    /**
     * Navigation property <b>_TeamCategoryTexts</b> for <b>TeamCategories</b> to multiple <b>TeamCategoryTexts</b>.
     * 
     */
    @ElementName( "_TeamCategoryTexts" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamCategoryTexts> to_TeamCategoryTexts;
    /**
     * Navigation property <b>_TeamTypes</b> for <b>TeamCategories</b> to multiple <b>TeamTypes</b>.
     * 
     */
    @ElementName( "_TeamTypes" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamTypes> to_TeamTypes;
    /**
     * Use with available request builders to apply the <b>_TeamCategoryTexts</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamCategories, TeamCategoryTexts> TO__TEAM_CATEGORY_TEXTS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamCategories, TeamCategoryTexts>(
            TeamCategories.class,
            "_TeamCategoryTexts",
            TeamCategoryTexts.class);
    /**
     * Use with available request builders to apply the <b>_TeamTypes</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamCategories, TeamTypes> TO__TEAM_TYPES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamCategories, TeamTypes>(
            TeamCategories.class,
            "_TeamTypes",
            TeamTypes.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamCategories> getType()
    {
        return TeamCategories.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @param respyMgmtTeamCategory
     *            Team Category
     */
    public void setRespyMgmtTeamCategory( @Nullable final java.lang.String respyMgmtTeamCategory )
    {
        rememberChangedField("RespyMgmtTeamCategory", this.respyMgmtTeamCategory);
        this.respyMgmtTeamCategory = respyMgmtTeamCategory;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamCategories";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtTeamCategory") ) {
                final Object value = values.remove("RespyMgmtTeamCategory");
                if( (value == null) || (!value.equals(getRespyMgmtTeamCategory())) ) {
                    setRespyMgmtTeamCategory(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_TeamCategoryTexts") ) {
                final Object value = (values).remove("_TeamCategoryTexts");
                if( value instanceof Iterable ) {
                    if( to_TeamCategoryTexts == null ) {
                        to_TeamCategoryTexts = Lists.newArrayList();
                    } else {
                        to_TeamCategoryTexts = Lists.newArrayList(to_TeamCategoryTexts);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamCategoryTexts entity;
                        if( to_TeamCategoryTexts.size() > i ) {
                            entity = to_TeamCategoryTexts.get(i);
                        } else {
                            entity = new TeamCategoryTexts();
                            to_TeamCategoryTexts.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_TeamTypes") ) {
                final Object value = (values).remove("_TeamTypes");
                if( value instanceof Iterable ) {
                    if( to_TeamTypes == null ) {
                        to_TeamTypes = Lists.newArrayList();
                    } else {
                        to_TeamTypes = Lists.newArrayList(to_TeamTypes);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamTypes entity;
                        if( to_TeamTypes.size() > i ) {
                            entity = to_TeamTypes.get(i);
                        } else {
                            entity = new TeamTypes();
                            to_TeamTypes.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_TeamCategoryTexts != null ) {
            (values).put("_TeamCategoryTexts", to_TeamCategoryTexts);
        }
        if( to_TeamTypes != null ) {
            (values).put("_TeamTypes", to_TeamTypes);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>TeamCategoryTexts</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_TeamCategoryTexts</b>.
     * <p>
     * If the navigation property for an entity <b>TeamCategories</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamCategoryTexts</b> is already loaded, the result will
     *         contain the <b>TeamCategoryTexts</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<TeamCategoryTexts>> getTeamCategoryTextsIfPresent()
    {
        return Option.of(to_TeamCategoryTexts);
    }

    /**
     * Overwrites the list of associated <b>TeamCategoryTexts</b> entities for the loaded navigation property
     * <b>_TeamCategoryTexts</b>.
     * <p>
     * If the navigation property <b>_TeamCategoryTexts</b> of a queried <b>TeamCategories</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamCategoryTexts</b> entities.
     */
    public void setTeamCategoryTexts( @Nonnull final List<TeamCategoryTexts> value )
    {
        if( to_TeamCategoryTexts == null ) {
            to_TeamCategoryTexts = Lists.newArrayList();
        }
        to_TeamCategoryTexts.clear();
        to_TeamCategoryTexts.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamCategoryTexts</b> entities. This corresponds to the OData
     * navigation property <b>_TeamCategoryTexts</b>.
     * <p>
     * If the navigation property <b>_TeamCategoryTexts</b> of a queried <b>TeamCategories</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamCategoryTexts</b> entities.
     */
    public void addTeamCategoryTexts( TeamCategoryTexts... entity )
    {
        if( to_TeamCategoryTexts == null ) {
            to_TeamCategoryTexts = Lists.newArrayList();
        }
        to_TeamCategoryTexts.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>TeamTypes</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_TeamTypes</b>.
     * <p>
     * If the navigation property for an entity <b>TeamCategories</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamTypes</b> is already loaded, the result will contain
     *         the <b>TeamTypes</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<TeamTypes>> getTeamTypesIfPresent()
    {
        return Option.of(to_TeamTypes);
    }

    /**
     * Overwrites the list of associated <b>TeamTypes</b> entities for the loaded navigation property <b>_TeamTypes</b>.
     * <p>
     * If the navigation property <b>_TeamTypes</b> of a queried <b>TeamCategories</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamTypes</b> entities.
     */
    public void setTeamTypes( @Nonnull final List<TeamTypes> value )
    {
        if( to_TeamTypes == null ) {
            to_TeamTypes = Lists.newArrayList();
        }
        to_TeamTypes.clear();
        to_TeamTypes.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamTypes</b> entities. This corresponds to the OData navigation
     * property <b>_TeamTypes</b>.
     * <p>
     * If the navigation property <b>_TeamTypes</b> of a queried <b>TeamCategories</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamTypes</b> entities.
     */
    public void addTeamTypes( TeamTypes... entity )
    {
        if( to_TeamTypes == null ) {
            to_TeamTypes = Lists.newArrayList();
        }
        to_TeamTypes.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of TeamCategories instances.
     * 
     */
    public final static class TeamCategoriesBuilder
    {

        private List<TeamCategoryTexts> to_TeamCategoryTexts = Lists.newArrayList();
        private List<TeamTypes> to_TeamTypes = Lists.newArrayList();

        private TeamCategories.TeamCategoriesBuilder to_TeamCategoryTexts( final List<TeamCategoryTexts> value )
        {
            to_TeamCategoryTexts.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_TeamCategoryTexts</b> for <b>TeamCategories</b> to multiple <b>TeamCategoryTexts</b>.
         * 
         * @param value
         *            The TeamCategoryTextss to build this TeamCategories with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamCategories.TeamCategoriesBuilder teamCategoryTexts( TeamCategoryTexts... value )
        {
            return to_TeamCategoryTexts(Lists.newArrayList(value));
        }

        private TeamCategories.TeamCategoriesBuilder to_TeamTypes( final List<TeamTypes> value )
        {
            to_TeamTypes.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_TeamTypes</b> for <b>TeamCategories</b> to multiple <b>TeamTypes</b>.
         * 
         * @param value
         *            The TeamTypess to build this TeamCategories with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamCategories.TeamCategoriesBuilder teamTypes( TeamTypes... value )
        {
            return to_TeamTypes(Lists.newArrayList(value));
        }

    }

}
