/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Team Category Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamCategoryTextsType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamCategoryTexts extends VdmEntity<TeamCategoryTexts> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_respym_team_srv.v0001.TeamCategoryTextsType";
    /**
     * Selector for all available fields of TeamCategoryTexts.
     * 
     */
    public final static SimpleProperty<TeamCategoryTexts> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @return Team Category
     */
    @Nullable
    @ElementName( "RespyMgmtTeamCategory" )
    private java.lang.String respyMgmtTeamCategory;
    public final static SimpleProperty.String<TeamCategoryTexts> RESPY_MGMT_TEAM_CATEGORY =
        new SimpleProperty.String<TeamCategoryTexts>(TeamCategoryTexts.class, "RespyMgmtTeamCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<TeamCategoryTexts> LANGUAGE =
        new SimpleProperty.String<TeamCategoryTexts>(TeamCategoryTexts.class, "Language");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategoryText</b>
     * </p>
     * 
     * @return Team Category Description
     */
    @Nullable
    @ElementName( "RespyMgmtTeamCategoryText" )
    private java.lang.String respyMgmtTeamCategoryText;
    public final static SimpleProperty.String<TeamCategoryTexts> RESPY_MGMT_TEAM_CATEGORY_TEXT =
        new SimpleProperty.String<TeamCategoryTexts>(TeamCategoryTexts.class, "RespyMgmtTeamCategoryText");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamCategoryTexts> getType()
    {
        return TeamCategoryTexts.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @param respyMgmtTeamCategory
     *            Team Category
     */
    public void setRespyMgmtTeamCategory( @Nullable final java.lang.String respyMgmtTeamCategory )
    {
        rememberChangedField("RespyMgmtTeamCategory", this.respyMgmtTeamCategory);
        this.respyMgmtTeamCategory = respyMgmtTeamCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategoryText</b>
     * </p>
     * 
     * @param respyMgmtTeamCategoryText
     *            Team Category Description
     */
    public void setRespyMgmtTeamCategoryText( @Nullable final java.lang.String respyMgmtTeamCategoryText )
    {
        rememberChangedField("RespyMgmtTeamCategoryText", this.respyMgmtTeamCategoryText);
        this.respyMgmtTeamCategoryText = respyMgmtTeamCategoryText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamCategoryTexts";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        entityKey.addKeyProperty("Language", getLanguage());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        values.put("Language", getLanguage());
        values.put("RespyMgmtTeamCategoryText", getRespyMgmtTeamCategoryText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtTeamCategory") ) {
                final Object value = values.remove("RespyMgmtTeamCategory");
                if( (value == null) || (!value.equals(getRespyMgmtTeamCategory())) ) {
                    setRespyMgmtTeamCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtTeamCategoryText") ) {
                final Object value = values.remove("RespyMgmtTeamCategoryText");
                if( (value == null) || (!value.equals(getRespyMgmtTeamCategoryText())) ) {
                    setRespyMgmtTeamCategoryText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamService.DEFAULT_SERVICE_PATH;
    }

}
