/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Team Headers
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamHeadersType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamHeaders extends VdmEntity<TeamHeaders> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_respym_team_srv.v0001.TeamHeadersType";
    /**
     * Selector for all available fields of TeamHeaders.
     * 
     */
    public final static SimpleProperty<TeamHeaders> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     * 
     * @return Global Team ID in Responsibility Mgmt.
     */
    @Nullable
    @ElementName( "RespyMgmtGlobalTeamID" )
    private java.lang.String respyMgmtGlobalTeamID;
    public final static SimpleProperty.String<TeamHeaders> RESPY_MGMT_GLOBAL_TEAM_ID =
        new SimpleProperty.String<TeamHeaders>(TeamHeaders.class, "RespyMgmtGlobalTeamID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamName</b>
     * </p>
     * 
     * @return Name
     */
    @Nullable
    @ElementName( "RespyMgmtTeamName" )
    private java.lang.String respyMgmtTeamName;
    public final static SimpleProperty.String<TeamHeaders> RESPY_MGMT_TEAM_NAME =
        new SimpleProperty.String<TeamHeaders>(TeamHeaders.class, "RespyMgmtTeamName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamStatus</b>
     * </p>
     * 
     * @return Team Status
     */
    @Nullable
    @ElementName( "RespyMgmtTeamStatus" )
    private java.lang.String respyMgmtTeamStatus;
    public final static SimpleProperty.String<TeamHeaders> RESPY_MGMT_TEAM_STATUS =
        new SimpleProperty.String<TeamHeaders>(TeamHeaders.class, "RespyMgmtTeamStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamType</b>
     * </p>
     * 
     * @return Team Type
     */
    @Nullable
    @ElementName( "RespyMgmtTeamType" )
    private java.lang.String respyMgmtTeamType;
    public final static SimpleProperty.String<TeamHeaders> RESPY_MGMT_TEAM_TYPE =
        new SimpleProperty.String<TeamHeaders>(TeamHeaders.class, "RespyMgmtTeamType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @return Custom Team Category
     */
    @Nullable
    @ElementName( "RespyMgmtTeamCategory" )
    private java.lang.String respyMgmtTeamCategory;
    public final static SimpleProperty.String<TeamHeaders> RESPY_MGMT_TEAM_CATEGORY =
        new SimpleProperty.String<TeamHeaders>(TeamHeaders.class, "RespyMgmtTeamCategory");
    /**
     * Navigation property <b>_TeamAttributes</b> for <b>TeamHeaders</b> to multiple <b>TeamAttributes</b>.
     * 
     */
    @ElementName( "_TeamAttributes" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamAttributes> to_TeamAttributes;
    /**
     * Navigation property <b>_TeamMembers</b> for <b>TeamHeaders</b> to multiple <b>TeamMembers</b>.
     * 
     */
    @ElementName( "_TeamMembers" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamMembers> to_TeamMembers;
    /**
     * Navigation property <b>_TeamOwners</b> for <b>TeamHeaders</b> to multiple <b>TeamOwners</b>.
     * 
     */
    @ElementName( "_TeamOwners" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamOwners> to_TeamOwners;
    /**
     * Navigation property <b>_TeamStatusTexts</b> for <b>TeamHeaders</b> to multiple <b>TeamStatusTexts</b>.
     * 
     */
    @ElementName( "_TeamStatusTexts" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamStatusTexts> to_TeamStatusTexts;
    /**
     * Navigation property <b>_TeamType</b> for <b>TeamHeaders</b> to single <b>TeamTypes</b>.
     * 
     */
    @ElementName( "_TeamType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private TeamTypes to_TeamType;
    /**
     * Use with available request builders to apply the <b>_TeamAttributes</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamHeaders, TeamAttributes> TO__TEAM_ATTRIBUTES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamHeaders, TeamAttributes>(
            TeamHeaders.class,
            "_TeamAttributes",
            TeamAttributes.class);
    /**
     * Use with available request builders to apply the <b>_TeamMembers</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamHeaders, TeamMembers> TO__TEAM_MEMBERS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamHeaders, TeamMembers>(
            TeamHeaders.class,
            "_TeamMembers",
            TeamMembers.class);
    /**
     * Use with available request builders to apply the <b>_TeamOwners</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamHeaders, TeamOwners> TO__TEAM_OWNERS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamHeaders, TeamOwners>(
            TeamHeaders.class,
            "_TeamOwners",
            TeamOwners.class);
    /**
     * Use with available request builders to apply the <b>_TeamStatusTexts</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamHeaders, TeamStatusTexts> TO__TEAM_STATUS_TEXTS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamHeaders, TeamStatusTexts>(
            TeamHeaders.class,
            "_TeamStatusTexts",
            TeamStatusTexts.class);
    /**
     * Use with available request builders to apply the <b>_TeamType</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamHeaders, TeamTypes> TO__TEAM_TYPE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamHeaders, TeamTypes>(
            TeamHeaders.class,
            "_TeamType",
            TeamTypes.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamHeaders> getType()
    {
        return TeamHeaders.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     * 
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     */
    public void setRespyMgmtGlobalTeamID( @Nullable final java.lang.String respyMgmtGlobalTeamID )
    {
        rememberChangedField("RespyMgmtGlobalTeamID", this.respyMgmtGlobalTeamID);
        this.respyMgmtGlobalTeamID = respyMgmtGlobalTeamID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamName</b>
     * </p>
     * 
     * @param respyMgmtTeamName
     *            Name
     */
    public void setRespyMgmtTeamName( @Nullable final java.lang.String respyMgmtTeamName )
    {
        rememberChangedField("RespyMgmtTeamName", this.respyMgmtTeamName);
        this.respyMgmtTeamName = respyMgmtTeamName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamStatus</b>
     * </p>
     * 
     * @param respyMgmtTeamStatus
     *            Team Status
     */
    public void setRespyMgmtTeamStatus( @Nullable final java.lang.String respyMgmtTeamStatus )
    {
        rememberChangedField("RespyMgmtTeamStatus", this.respyMgmtTeamStatus);
        this.respyMgmtTeamStatus = respyMgmtTeamStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamType</b>
     * </p>
     * 
     * @param respyMgmtTeamType
     *            Team Type
     */
    public void setRespyMgmtTeamType( @Nullable final java.lang.String respyMgmtTeamType )
    {
        rememberChangedField("RespyMgmtTeamType", this.respyMgmtTeamType);
        this.respyMgmtTeamType = respyMgmtTeamType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @param respyMgmtTeamCategory
     *            Custom Team Category
     */
    public void setRespyMgmtTeamCategory( @Nullable final java.lang.String respyMgmtTeamCategory )
    {
        rememberChangedField("RespyMgmtTeamCategory", this.respyMgmtTeamCategory);
        this.respyMgmtTeamCategory = respyMgmtTeamCategory;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamHeaders";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        values.put("RespyMgmtTeamName", getRespyMgmtTeamName());
        values.put("RespyMgmtTeamStatus", getRespyMgmtTeamStatus());
        values.put("RespyMgmtTeamType", getRespyMgmtTeamType());
        values.put("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtGlobalTeamID") ) {
                final Object value = values.remove("RespyMgmtGlobalTeamID");
                if( (value == null) || (!value.equals(getRespyMgmtGlobalTeamID())) ) {
                    setRespyMgmtGlobalTeamID(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtTeamName") ) {
                final Object value = values.remove("RespyMgmtTeamName");
                if( (value == null) || (!value.equals(getRespyMgmtTeamName())) ) {
                    setRespyMgmtTeamName(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtTeamStatus") ) {
                final Object value = values.remove("RespyMgmtTeamStatus");
                if( (value == null) || (!value.equals(getRespyMgmtTeamStatus())) ) {
                    setRespyMgmtTeamStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtTeamType") ) {
                final Object value = values.remove("RespyMgmtTeamType");
                if( (value == null) || (!value.equals(getRespyMgmtTeamType())) ) {
                    setRespyMgmtTeamType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtTeamCategory") ) {
                final Object value = values.remove("RespyMgmtTeamCategory");
                if( (value == null) || (!value.equals(getRespyMgmtTeamCategory())) ) {
                    setRespyMgmtTeamCategory(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_TeamAttributes") ) {
                final Object value = (values).remove("_TeamAttributes");
                if( value instanceof Iterable ) {
                    if( to_TeamAttributes == null ) {
                        to_TeamAttributes = Lists.newArrayList();
                    } else {
                        to_TeamAttributes = Lists.newArrayList(to_TeamAttributes);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamAttributes entity;
                        if( to_TeamAttributes.size() > i ) {
                            entity = to_TeamAttributes.get(i);
                        } else {
                            entity = new TeamAttributes();
                            to_TeamAttributes.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_TeamMembers") ) {
                final Object value = (values).remove("_TeamMembers");
                if( value instanceof Iterable ) {
                    if( to_TeamMembers == null ) {
                        to_TeamMembers = Lists.newArrayList();
                    } else {
                        to_TeamMembers = Lists.newArrayList(to_TeamMembers);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamMembers entity;
                        if( to_TeamMembers.size() > i ) {
                            entity = to_TeamMembers.get(i);
                        } else {
                            entity = new TeamMembers();
                            to_TeamMembers.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_TeamOwners") ) {
                final Object value = (values).remove("_TeamOwners");
                if( value instanceof Iterable ) {
                    if( to_TeamOwners == null ) {
                        to_TeamOwners = Lists.newArrayList();
                    } else {
                        to_TeamOwners = Lists.newArrayList(to_TeamOwners);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamOwners entity;
                        if( to_TeamOwners.size() > i ) {
                            entity = to_TeamOwners.get(i);
                        } else {
                            entity = new TeamOwners();
                            to_TeamOwners.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_TeamStatusTexts") ) {
                final Object value = (values).remove("_TeamStatusTexts");
                if( value instanceof Iterable ) {
                    if( to_TeamStatusTexts == null ) {
                        to_TeamStatusTexts = Lists.newArrayList();
                    } else {
                        to_TeamStatusTexts = Lists.newArrayList(to_TeamStatusTexts);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamStatusTexts entity;
                        if( to_TeamStatusTexts.size() > i ) {
                            entity = to_TeamStatusTexts.get(i);
                        } else {
                            entity = new TeamStatusTexts();
                            to_TeamStatusTexts.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_TeamType") ) {
                final Object value = (values).remove("_TeamType");
                if( value instanceof Map ) {
                    if( to_TeamType == null ) {
                        to_TeamType = new TeamTypes();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_TeamType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_TeamAttributes != null ) {
            (values).put("_TeamAttributes", to_TeamAttributes);
        }
        if( to_TeamMembers != null ) {
            (values).put("_TeamMembers", to_TeamMembers);
        }
        if( to_TeamOwners != null ) {
            (values).put("_TeamOwners", to_TeamOwners);
        }
        if( to_TeamStatusTexts != null ) {
            (values).put("_TeamStatusTexts", to_TeamStatusTexts);
        }
        if( to_TeamType != null ) {
            (values).put("_TeamType", to_TeamType);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>TeamAttributes</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_TeamAttributes</b>.
     * <p>
     * If the navigation property for an entity <b>TeamHeaders</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamAttributes</b> is already loaded, the result will
     *         contain the <b>TeamAttributes</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<TeamAttributes>> getTeamAttributesIfPresent()
    {
        return Option.of(to_TeamAttributes);
    }

    /**
     * Overwrites the list of associated <b>TeamAttributes</b> entities for the loaded navigation property
     * <b>_TeamAttributes</b>.
     * <p>
     * If the navigation property <b>_TeamAttributes</b> of a queried <b>TeamHeaders</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamAttributes</b> entities.
     */
    public void setTeamAttributes( @Nonnull final List<TeamAttributes> value )
    {
        if( to_TeamAttributes == null ) {
            to_TeamAttributes = Lists.newArrayList();
        }
        to_TeamAttributes.clear();
        to_TeamAttributes.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamAttributes</b> entities. This corresponds to the OData navigation
     * property <b>_TeamAttributes</b>.
     * <p>
     * If the navigation property <b>_TeamAttributes</b> of a queried <b>TeamHeaders</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamAttributes</b> entities.
     */
    public void addTeamAttributes( TeamAttributes... entity )
    {
        if( to_TeamAttributes == null ) {
            to_TeamAttributes = Lists.newArrayList();
        }
        to_TeamAttributes.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>TeamMembers</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_TeamMembers</b>.
     * <p>
     * If the navigation property for an entity <b>TeamHeaders</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamMembers</b> is already loaded, the result will contain
     *         the <b>TeamMembers</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<TeamMembers>> getTeamMembersIfPresent()
    {
        return Option.of(to_TeamMembers);
    }

    /**
     * Overwrites the list of associated <b>TeamMembers</b> entities for the loaded navigation property
     * <b>_TeamMembers</b>.
     * <p>
     * If the navigation property <b>_TeamMembers</b> of a queried <b>TeamHeaders</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamMembers</b> entities.
     */
    public void setTeamMembers( @Nonnull final List<TeamMembers> value )
    {
        if( to_TeamMembers == null ) {
            to_TeamMembers = Lists.newArrayList();
        }
        to_TeamMembers.clear();
        to_TeamMembers.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamMembers</b> entities. This corresponds to the OData navigation
     * property <b>_TeamMembers</b>.
     * <p>
     * If the navigation property <b>_TeamMembers</b> of a queried <b>TeamHeaders</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamMembers</b> entities.
     */
    public void addTeamMembers( TeamMembers... entity )
    {
        if( to_TeamMembers == null ) {
            to_TeamMembers = Lists.newArrayList();
        }
        to_TeamMembers.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>TeamOwners</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_TeamOwners</b>.
     * <p>
     * If the navigation property for an entity <b>TeamHeaders</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamOwners</b> is already loaded, the result will contain
     *         the <b>TeamOwners</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<TeamOwners>> getTeamOwnersIfPresent()
    {
        return Option.of(to_TeamOwners);
    }

    /**
     * Overwrites the list of associated <b>TeamOwners</b> entities for the loaded navigation property
     * <b>_TeamOwners</b>.
     * <p>
     * If the navigation property <b>_TeamOwners</b> of a queried <b>TeamHeaders</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamOwners</b> entities.
     */
    public void setTeamOwners( @Nonnull final List<TeamOwners> value )
    {
        if( to_TeamOwners == null ) {
            to_TeamOwners = Lists.newArrayList();
        }
        to_TeamOwners.clear();
        to_TeamOwners.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamOwners</b> entities. This corresponds to the OData navigation
     * property <b>_TeamOwners</b>.
     * <p>
     * If the navigation property <b>_TeamOwners</b> of a queried <b>TeamHeaders</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamOwners</b> entities.
     */
    public void addTeamOwners( TeamOwners... entity )
    {
        if( to_TeamOwners == null ) {
            to_TeamOwners = Lists.newArrayList();
        }
        to_TeamOwners.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>TeamStatusTexts</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_TeamStatusTexts</b>.
     * <p>
     * If the navigation property for an entity <b>TeamHeaders</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamStatusTexts</b> is already loaded, the result will
     *         contain the <b>TeamStatusTexts</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<TeamStatusTexts>> getTeamStatusTextsIfPresent()
    {
        return Option.of(to_TeamStatusTexts);
    }

    /**
     * Overwrites the list of associated <b>TeamStatusTexts</b> entities for the loaded navigation property
     * <b>_TeamStatusTexts</b>.
     * <p>
     * If the navigation property <b>_TeamStatusTexts</b> of a queried <b>TeamHeaders</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamStatusTexts</b> entities.
     */
    public void setTeamStatusTexts( @Nonnull final List<TeamStatusTexts> value )
    {
        if( to_TeamStatusTexts == null ) {
            to_TeamStatusTexts = Lists.newArrayList();
        }
        to_TeamStatusTexts.clear();
        to_TeamStatusTexts.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamStatusTexts</b> entities. This corresponds to the OData navigation
     * property <b>_TeamStatusTexts</b>.
     * <p>
     * If the navigation property <b>_TeamStatusTexts</b> of a queried <b>TeamHeaders</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamStatusTexts</b> entities.
     */
    public void addTeamStatusTexts( TeamStatusTexts... entity )
    {
        if( to_TeamStatusTexts == null ) {
            to_TeamStatusTexts = Lists.newArrayList();
        }
        to_TeamStatusTexts.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>TeamTypes</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_TeamType</b>.
     * <p>
     * If the navigation property for an entity <b>TeamHeaders</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamType</b> is already loaded, the result will contain
     *         the <b>TeamTypes</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<TeamTypes> getTeamTypeIfPresent()
    {
        return Option.of(to_TeamType);
    }

    /**
     * Overwrites the associated <b>TeamTypes</b> entity for the loaded navigation property <b>_TeamType</b>.
     * 
     * @param value
     *            New <b>TeamTypes</b> entity.
     */
    public void setTeamType( final TeamTypes value )
    {
        to_TeamType = value;
    }

    /**
     * Helper class to allow for fluent creation of TeamHeaders instances.
     * 
     */
    public final static class TeamHeadersBuilder
    {

        private List<TeamAttributes> to_TeamAttributes = Lists.newArrayList();
        private List<TeamMembers> to_TeamMembers = Lists.newArrayList();
        private List<TeamOwners> to_TeamOwners = Lists.newArrayList();
        private List<TeamStatusTexts> to_TeamStatusTexts = Lists.newArrayList();
        private TeamTypes to_TeamType;

        private TeamHeaders.TeamHeadersBuilder to_TeamAttributes( final List<TeamAttributes> value )
        {
            to_TeamAttributes.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_TeamAttributes</b> for <b>TeamHeaders</b> to multiple <b>TeamAttributes</b>.
         * 
         * @param value
         *            The TeamAttributess to build this TeamHeaders with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamHeaders.TeamHeadersBuilder teamAttributes( TeamAttributes... value )
        {
            return to_TeamAttributes(Lists.newArrayList(value));
        }

        private TeamHeaders.TeamHeadersBuilder to_TeamMembers( final List<TeamMembers> value )
        {
            to_TeamMembers.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_TeamMembers</b> for <b>TeamHeaders</b> to multiple <b>TeamMembers</b>.
         * 
         * @param value
         *            The TeamMemberss to build this TeamHeaders with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamHeaders.TeamHeadersBuilder teamMembers( TeamMembers... value )
        {
            return to_TeamMembers(Lists.newArrayList(value));
        }

        private TeamHeaders.TeamHeadersBuilder to_TeamOwners( final List<TeamOwners> value )
        {
            to_TeamOwners.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_TeamOwners</b> for <b>TeamHeaders</b> to multiple <b>TeamOwners</b>.
         * 
         * @param value
         *            The TeamOwnerss to build this TeamHeaders with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamHeaders.TeamHeadersBuilder teamOwners( TeamOwners... value )
        {
            return to_TeamOwners(Lists.newArrayList(value));
        }

        private TeamHeaders.TeamHeadersBuilder to_TeamStatusTexts( final List<TeamStatusTexts> value )
        {
            to_TeamStatusTexts.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_TeamStatusTexts</b> for <b>TeamHeaders</b> to multiple <b>TeamStatusTexts</b>.
         * 
         * @param value
         *            The TeamStatusTextss to build this TeamHeaders with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamHeaders.TeamHeadersBuilder teamStatusTexts( TeamStatusTexts... value )
        {
            return to_TeamStatusTexts(Lists.newArrayList(value));
        }

        private TeamHeaders.TeamHeadersBuilder to_TeamType( final TeamTypes value )
        {
            to_TeamType = value;
            return this;
        }

        /**
         * Navigation property <b>_TeamType</b> for <b>TeamHeaders</b> to single <b>TeamTypes</b>.
         * 
         * @param value
         *            The TeamTypes to build this TeamHeaders with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamHeaders.TeamHeadersBuilder teamType( final TeamTypes value )
        {
            return to_TeamType(value);
        }

    }

}
