/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Team Member Functions
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamMemberFunctionsType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamMemberFunctions extends VdmEntity<TeamMemberFunctions> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_respym_team_srv.v0001.TeamMemberFunctionsType";
    /**
     * Selector for all available fields of TeamMemberFunctions.
     * 
     */
    public final static SimpleProperty<TeamMemberFunctions> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     * 
     * @return Global Team ID in Responsibility Mgmt.
     */
    @Nullable
    @ElementName( "RespyMgmtGlobalTeamID" )
    private java.lang.String respyMgmtGlobalTeamID;
    public final static SimpleProperty.String<TeamMemberFunctions> RESPY_MGMT_GLOBAL_TEAM_ID =
        new SimpleProperty.String<TeamMemberFunctions>(TeamMemberFunctions.class, "RespyMgmtGlobalTeamID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamMemberType</b>
     * </p>
     * 
     * @return Team Member Type
     */
    @Nullable
    @ElementName( "RespyMgmtTeamMemberType" )
    private java.lang.String respyMgmtTeamMemberType;
    public final static SimpleProperty.String<TeamMemberFunctions> RESPY_MGMT_TEAM_MEMBER_TYPE =
        new SimpleProperty.String<TeamMemberFunctions>(TeamMemberFunctions.class, "RespyMgmtTeamMemberType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibilityTeamMember</b>
     * </p>
     * 
     * @return Business Partner Number
     */
    @Nullable
    @ElementName( "ResponsibilityTeamMember" )
    private java.lang.String responsibilityTeamMember;
    public final static SimpleProperty.String<TeamMemberFunctions> RESPONSIBILITY_TEAM_MEMBER =
        new SimpleProperty.String<TeamMemberFunctions>(TeamMemberFunctions.class, "ResponsibilityTeamMember");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtFunction</b>
     * </p>
     * 
     * @return Function
     */
    @Nullable
    @ElementName( "RespyMgmtFunction" )
    private java.lang.String respyMgmtFunction;
    public final static SimpleProperty.String<TeamMemberFunctions> RESPY_MGMT_FUNCTION =
        new SimpleProperty.String<TeamMemberFunctions>(TeamMemberFunctions.class, "RespyMgmtFunction");
    /**
     * Navigation property <b>_TeamMember</b> for <b>TeamMemberFunctions</b> to single <b>TeamMembers</b>.
     * 
     */
    @ElementName( "_TeamMember" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private TeamMembers to_TeamMember;
    /**
     * Use with available request builders to apply the <b>_TeamMember</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamMemberFunctions, TeamMembers> TO__TEAM_MEMBER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamMemberFunctions, TeamMembers>(
            TeamMemberFunctions.class,
            "_TeamMember",
            TeamMembers.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamMemberFunctions> getType()
    {
        return TeamMemberFunctions.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     * 
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     */
    public void setRespyMgmtGlobalTeamID( @Nullable final java.lang.String respyMgmtGlobalTeamID )
    {
        rememberChangedField("RespyMgmtGlobalTeamID", this.respyMgmtGlobalTeamID);
        this.respyMgmtGlobalTeamID = respyMgmtGlobalTeamID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamMemberType</b>
     * </p>
     * 
     * @param respyMgmtTeamMemberType
     *            Team Member Type
     */
    public void setRespyMgmtTeamMemberType( @Nullable final java.lang.String respyMgmtTeamMemberType )
    {
        rememberChangedField("RespyMgmtTeamMemberType", this.respyMgmtTeamMemberType);
        this.respyMgmtTeamMemberType = respyMgmtTeamMemberType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibilityTeamMember</b>
     * </p>
     * 
     * @param responsibilityTeamMember
     *            Business Partner Number
     */
    public void setResponsibilityTeamMember( @Nullable final java.lang.String responsibilityTeamMember )
    {
        rememberChangedField("ResponsibilityTeamMember", this.responsibilityTeamMember);
        this.responsibilityTeamMember = responsibilityTeamMember;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtFunction</b>
     * </p>
     * 
     * @param respyMgmtFunction
     *            Function
     */
    public void setRespyMgmtFunction( @Nullable final java.lang.String respyMgmtFunction )
    {
        rememberChangedField("RespyMgmtFunction", this.respyMgmtFunction);
        this.respyMgmtFunction = respyMgmtFunction;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamMemberFunctions";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        entityKey.addKeyProperty("RespyMgmtTeamMemberType", getRespyMgmtTeamMemberType());
        entityKey.addKeyProperty("ResponsibilityTeamMember", getResponsibilityTeamMember());
        entityKey.addKeyProperty("RespyMgmtFunction", getRespyMgmtFunction());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        values.put("RespyMgmtTeamMemberType", getRespyMgmtTeamMemberType());
        values.put("ResponsibilityTeamMember", getResponsibilityTeamMember());
        values.put("RespyMgmtFunction", getRespyMgmtFunction());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtGlobalTeamID") ) {
                final Object value = values.remove("RespyMgmtGlobalTeamID");
                if( (value == null) || (!value.equals(getRespyMgmtGlobalTeamID())) ) {
                    setRespyMgmtGlobalTeamID(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtTeamMemberType") ) {
                final Object value = values.remove("RespyMgmtTeamMemberType");
                if( (value == null) || (!value.equals(getRespyMgmtTeamMemberType())) ) {
                    setRespyMgmtTeamMemberType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ResponsibilityTeamMember") ) {
                final Object value = values.remove("ResponsibilityTeamMember");
                if( (value == null) || (!value.equals(getResponsibilityTeamMember())) ) {
                    setResponsibilityTeamMember(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtFunction") ) {
                final Object value = values.remove("RespyMgmtFunction");
                if( (value == null) || (!value.equals(getRespyMgmtFunction())) ) {
                    setRespyMgmtFunction(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_TeamMember") ) {
                final Object value = (values).remove("_TeamMember");
                if( value instanceof Map ) {
                    if( to_TeamMember == null ) {
                        to_TeamMember = new TeamMembers();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_TeamMember.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_TeamMember != null ) {
            (values).put("_TeamMember", to_TeamMember);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>TeamMembers</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_TeamMember</b>.
     * <p>
     * If the navigation property for an entity <b>TeamMemberFunctions</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamMember</b> is already loaded, the result will contain
     *         the <b>TeamMembers</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<TeamMembers> getTeamMemberIfPresent()
    {
        return Option.of(to_TeamMember);
    }

    /**
     * Overwrites the associated <b>TeamMembers</b> entity for the loaded navigation property <b>_TeamMember</b>.
     * 
     * @param value
     *            New <b>TeamMembers</b> entity.
     */
    public void setTeamMember( final TeamMembers value )
    {
        to_TeamMember = value;
    }

    /**
     * Helper class to allow for fluent creation of TeamMemberFunctions instances.
     * 
     */
    public final static class TeamMemberFunctionsBuilder
    {

        private TeamMembers to_TeamMember;

        private TeamMemberFunctions.TeamMemberFunctionsBuilder to_TeamMember( final TeamMembers value )
        {
            to_TeamMember = value;
            return this;
        }

        /**
         * Navigation property <b>_TeamMember</b> for <b>TeamMemberFunctions</b> to single <b>TeamMembers</b>.
         * 
         * @param value
         *            The TeamMembers to build this TeamMemberFunctions with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamMemberFunctions.TeamMemberFunctionsBuilder teamMember( final TeamMembers value )
        {
            return to_TeamMember(value);
        }

    }

}
