/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Team Members
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamMembersType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamMembers extends VdmEntity<TeamMembers> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_respym_team_srv.v0001.TeamMembersType";
    /**
     * Selector for all available fields of TeamMembers.
     * 
     */
    public final static SimpleProperty<TeamMembers> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     * 
     * @return Global Team ID in Responsibility Mgmt.
     */
    @Nullable
    @ElementName( "RespyMgmtGlobalTeamID" )
    private java.lang.String respyMgmtGlobalTeamID;
    public final static SimpleProperty.String<TeamMembers> RESPY_MGMT_GLOBAL_TEAM_ID =
        new SimpleProperty.String<TeamMembers>(TeamMembers.class, "RespyMgmtGlobalTeamID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamMemberType</b>
     * </p>
     * 
     * @return Team Member Type
     */
    @Nullable
    @ElementName( "RespyMgmtTeamMemberType" )
    private java.lang.String respyMgmtTeamMemberType;
    public final static SimpleProperty.String<TeamMembers> RESPY_MGMT_TEAM_MEMBER_TYPE =
        new SimpleProperty.String<TeamMembers>(TeamMembers.class, "RespyMgmtTeamMemberType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibilityTeamMember</b>
     * </p>
     * 
     * @return Business Partner Number
     */
    @Nullable
    @ElementName( "ResponsibilityTeamMember" )
    private java.lang.String responsibilityTeamMember;
    public final static SimpleProperty.String<TeamMembers> RESPONSIBILITY_TEAM_MEMBER =
        new SimpleProperty.String<TeamMembers>(TeamMembers.class, "ResponsibilityTeamMember");
    /**
     * Navigation property <b>_TeamHeader</b> for <b>TeamMembers</b> to single <b>TeamHeaders</b>.
     * 
     */
    @ElementName( "_TeamHeader" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private TeamHeaders to_TeamHeader;
    /**
     * Navigation property <b>_TeamMemberFunctions</b> for <b>TeamMembers</b> to multiple <b>TeamMemberFunctions</b>.
     * 
     */
    @ElementName( "_TeamMemberFunctions" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamMemberFunctions> to_TeamMemberFunctions;
    /**
     * Use with available request builders to apply the <b>_TeamHeader</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamMembers, TeamHeaders> TO__TEAM_HEADER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamMembers, TeamHeaders>(
            TeamMembers.class,
            "_TeamHeader",
            TeamHeaders.class);
    /**
     * Use with available request builders to apply the <b>_TeamMemberFunctions</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamMembers, TeamMemberFunctions> TO__TEAM_MEMBER_FUNCTIONS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamMembers, TeamMemberFunctions>(
            TeamMembers.class,
            "_TeamMemberFunctions",
            TeamMemberFunctions.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamMembers> getType()
    {
        return TeamMembers.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     * 
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     */
    public void setRespyMgmtGlobalTeamID( @Nullable final java.lang.String respyMgmtGlobalTeamID )
    {
        rememberChangedField("RespyMgmtGlobalTeamID", this.respyMgmtGlobalTeamID);
        this.respyMgmtGlobalTeamID = respyMgmtGlobalTeamID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamMemberType</b>
     * </p>
     * 
     * @param respyMgmtTeamMemberType
     *            Team Member Type
     */
    public void setRespyMgmtTeamMemberType( @Nullable final java.lang.String respyMgmtTeamMemberType )
    {
        rememberChangedField("RespyMgmtTeamMemberType", this.respyMgmtTeamMemberType);
        this.respyMgmtTeamMemberType = respyMgmtTeamMemberType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibilityTeamMember</b>
     * </p>
     * 
     * @param responsibilityTeamMember
     *            Business Partner Number
     */
    public void setResponsibilityTeamMember( @Nullable final java.lang.String responsibilityTeamMember )
    {
        rememberChangedField("ResponsibilityTeamMember", this.responsibilityTeamMember);
        this.responsibilityTeamMember = responsibilityTeamMember;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamMembers";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        entityKey.addKeyProperty("RespyMgmtTeamMemberType", getRespyMgmtTeamMemberType());
        entityKey.addKeyProperty("ResponsibilityTeamMember", getResponsibilityTeamMember());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        values.put("RespyMgmtTeamMemberType", getRespyMgmtTeamMemberType());
        values.put("ResponsibilityTeamMember", getResponsibilityTeamMember());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtGlobalTeamID") ) {
                final Object value = values.remove("RespyMgmtGlobalTeamID");
                if( (value == null) || (!value.equals(getRespyMgmtGlobalTeamID())) ) {
                    setRespyMgmtGlobalTeamID(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtTeamMemberType") ) {
                final Object value = values.remove("RespyMgmtTeamMemberType");
                if( (value == null) || (!value.equals(getRespyMgmtTeamMemberType())) ) {
                    setRespyMgmtTeamMemberType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ResponsibilityTeamMember") ) {
                final Object value = values.remove("ResponsibilityTeamMember");
                if( (value == null) || (!value.equals(getResponsibilityTeamMember())) ) {
                    setResponsibilityTeamMember(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_TeamHeader") ) {
                final Object value = (values).remove("_TeamHeader");
                if( value instanceof Map ) {
                    if( to_TeamHeader == null ) {
                        to_TeamHeader = new TeamHeaders();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_TeamHeader.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_TeamMemberFunctions") ) {
                final Object value = (values).remove("_TeamMemberFunctions");
                if( value instanceof Iterable ) {
                    if( to_TeamMemberFunctions == null ) {
                        to_TeamMemberFunctions = Lists.newArrayList();
                    } else {
                        to_TeamMemberFunctions = Lists.newArrayList(to_TeamMemberFunctions);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamMemberFunctions entity;
                        if( to_TeamMemberFunctions.size() > i ) {
                            entity = to_TeamMemberFunctions.get(i);
                        } else {
                            entity = new TeamMemberFunctions();
                            to_TeamMemberFunctions.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_TeamHeader != null ) {
            (values).put("_TeamHeader", to_TeamHeader);
        }
        if( to_TeamMemberFunctions != null ) {
            (values).put("_TeamMemberFunctions", to_TeamMemberFunctions);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>TeamHeaders</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_TeamHeader</b>.
     * <p>
     * If the navigation property for an entity <b>TeamMembers</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamHeader</b> is already loaded, the result will contain
     *         the <b>TeamHeaders</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<TeamHeaders> getTeamHeaderIfPresent()
    {
        return Option.of(to_TeamHeader);
    }

    /**
     * Overwrites the associated <b>TeamHeaders</b> entity for the loaded navigation property <b>_TeamHeader</b>.
     * 
     * @param value
     *            New <b>TeamHeaders</b> entity.
     */
    public void setTeamHeader( final TeamHeaders value )
    {
        to_TeamHeader = value;
    }

    /**
     * Retrieval of associated <b>TeamMemberFunctions</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_TeamMemberFunctions</b>.
     * <p>
     * If the navigation property for an entity <b>TeamMembers</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamMemberFunctions</b> is already loaded, the result will
     *         contain the <b>TeamMemberFunctions</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<TeamMemberFunctions>> getTeamMemberFunctionsIfPresent()
    {
        return Option.of(to_TeamMemberFunctions);
    }

    /**
     * Overwrites the list of associated <b>TeamMemberFunctions</b> entities for the loaded navigation property
     * <b>_TeamMemberFunctions</b>.
     * <p>
     * If the navigation property <b>_TeamMemberFunctions</b> of a queried <b>TeamMembers</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamMemberFunctions</b> entities.
     */
    public void setTeamMemberFunctions( @Nonnull final List<TeamMemberFunctions> value )
    {
        if( to_TeamMemberFunctions == null ) {
            to_TeamMemberFunctions = Lists.newArrayList();
        }
        to_TeamMemberFunctions.clear();
        to_TeamMemberFunctions.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamMemberFunctions</b> entities. This corresponds to the OData
     * navigation property <b>_TeamMemberFunctions</b>.
     * <p>
     * If the navigation property <b>_TeamMemberFunctions</b> of a queried <b>TeamMembers</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamMemberFunctions</b> entities.
     */
    public void addTeamMemberFunctions( TeamMemberFunctions... entity )
    {
        if( to_TeamMemberFunctions == null ) {
            to_TeamMemberFunctions = Lists.newArrayList();
        }
        to_TeamMemberFunctions.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of TeamMembers instances.
     * 
     */
    public final static class TeamMembersBuilder
    {

        private TeamHeaders to_TeamHeader;
        private List<TeamMemberFunctions> to_TeamMemberFunctions = Lists.newArrayList();

        private TeamMembers.TeamMembersBuilder to_TeamHeader( final TeamHeaders value )
        {
            to_TeamHeader = value;
            return this;
        }

        /**
         * Navigation property <b>_TeamHeader</b> for <b>TeamMembers</b> to single <b>TeamHeaders</b>.
         * 
         * @param value
         *            The TeamHeaders to build this TeamMembers with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamMembers.TeamMembersBuilder teamHeader( final TeamHeaders value )
        {
            return to_TeamHeader(value);
        }

        private TeamMembers.TeamMembersBuilder to_TeamMemberFunctions( final List<TeamMemberFunctions> value )
        {
            to_TeamMemberFunctions.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_TeamMemberFunctions</b> for <b>TeamMembers</b> to multiple
         * <b>TeamMemberFunctions</b>.
         * 
         * @param value
         *            The TeamMemberFunctionss to build this TeamMembers with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamMembers.TeamMembersBuilder teamMemberFunctions( TeamMemberFunctions... value )
        {
            return to_TeamMemberFunctions(Lists.newArrayList(value));
        }

    }

}
